/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.lang.ref.SoftReference;
import java.util.ArrayList;
import junit.framework.Assert;
import mondrian.calc.ResultStyle;
import mondrian.olap.Connection;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class HighDimensionsTest
extends FoodMartTestCase {
    private static final String first40HighCardResults = "[Promotions].[All Promotions].[Bag Stuffers][Promotions].[All Promotions].[Best Savings][Promotions].[All Promotions].[Big Promo][Promotions].[All Promotions].[Big Time Discounts][Promotions].[All Promotions].[Big Time Savings][Promotions].[All Promotions].[Bye Bye Baby][Promotions].[All Promotions].[Cash Register Lottery][Promotions].[All Promotions].[Coupon Spectacular][Promotions].[All Promotions].[Dimes Off][Promotions].[All Promotions].[Dollar Cutters][Promotions].[All Promotions].[Dollar Days][Promotions].[All Promotions].[Double Down Sale][Promotions].[All Promotions].[Double Your Savings][Promotions].[All Promotions].[Fantastic Discounts][Promotions].[All Promotions].[Free For All][Promotions].[All Promotions].[Go For It][Promotions].[All Promotions].[Green Light Days][Promotions].[All Promotions].[Green Light Special][Promotions].[All Promotions].[High Roller Savings][Promotions].[All Promotions].[I Cant Believe It Sale][Promotions].[All Promotions].[Money Grabbers][Promotions].[All Promotions].[Money Savers][Promotions].[All Promotions].[Mystery Sale][Promotions].[All Promotions].[No Promotion][Promotions].[All Promotions].[One Day Sale][Promotions].[All Promotions].[Pick Your Savings][Promotions].[All Promotions].[Price Cutters][Promotions].[All Promotions].[Price Destroyers][Promotions].[All Promotions].[Price Savers][Promotions].[All Promotions].[Price Slashers][Promotions].[All Promotions].[Price Smashers][Promotions].[All Promotions].[Price Winners][Promotions].[All Promotions].[Sale Winners][Promotions].[All Promotions].[Sales Days][Promotions].[All Promotions].[Sales Galore][Promotions].[All Promotions].[Save-It Sale][Promotions].[All Promotions].[Saving Days][Promotions].[All Promotions].[Savings Galore][Promotions].[All Promotions].[Shelf Clearing Days][Promotions].[All Promotions].[Shelf Emptiers]";
    private static final String nonEmptyHighCardResults = "[Promotions].[All Promotions].[Bag Stuffers][Promotions].[All Promotions].[Best Savings][Promotions].[All Promotions].[Big Promo][Promotions].[All Promotions].[Big Time Discounts][Promotions].[All Promotions].[Big Time Savings][Promotions].[All Promotions].[Bye Bye Baby][Promotions].[All Promotions].[Cash Register Lottery][Promotions].[All Promotions].[Dimes Off][Promotions].[All Promotions].[Dollar Cutters][Promotions].[All Promotions].[Dollar Days][Promotions].[All Promotions].[Double Down Sale][Promotions].[All Promotions].[Double Your Savings][Promotions].[All Promotions].[Free For All][Promotions].[All Promotions].[Go For It][Promotions].[All Promotions].[Green Light Days][Promotions].[All Promotions].[Green Light Special][Promotions].[All Promotions].[High Roller Savings][Promotions].[All Promotions].[I Cant Believe It Sale][Promotions].[All Promotions].[Money Savers][Promotions].[All Promotions].[Mystery Sale][Promotions].[All Promotions].[No Promotion][Promotions].[All Promotions].[One Day Sale][Promotions].[All Promotions].[Pick Your Savings][Promotions].[All Promotions].[Price Cutters][Promotions].[All Promotions].[Price Destroyers][Promotions].[All Promotions].[Price Savers][Promotions].[All Promotions].[Price Slashers][Promotions].[All Promotions].[Price Smashers][Promotions].[All Promotions].[Price Winners][Promotions].[All Promotions].[Sale Winners][Promotions].[All Promotions].[Sales Days][Promotions].[All Promotions].[Sales Galore][Promotions].[All Promotions].[Save-It Sale][Promotions].[All Promotions].[Saving Days][Promotions].[All Promotions].[Savings Galore][Promotions].[All Promotions].[Shelf Clearing Days][Promotions].[All Promotions].[Shelf Emptiers][Promotions].[All Promotions].[Super Duper Savers][Promotions].[All Promotions].[Super Savers][Promotions].[All Promotions].[Super Wallet Savers][Promotions].[All Promotions].[Three for One][Promotions].[All Promotions].[Tip Top Savings][Promotions].[All Promotions].[Two Day Sale][Promotions].[All Promotions].[Two for One][Promotions].[All Promotions].[Unbeatable Price Savers][Promotions].[All Promotions].[Wallet Savers][Promotions].[All Promotions].[Weekend Markdown][Promotions].[All Promotions].[You Save Days]";
    private static final String highCardResults = "[Promotions].[All Promotions].[Bag Stuffers][Promotions].[All Promotions].[Best Savings][Promotions].[All Promotions].[Big Promo][Promotions].[All Promotions].[Big Time Discounts][Promotions].[All Promotions].[Big Time Savings][Promotions].[All Promotions].[Bye Bye Baby][Promotions].[All Promotions].[Cash Register Lottery][Promotions].[All Promotions].[Coupon Spectacular][Promotions].[All Promotions].[Dimes Off][Promotions].[All Promotions].[Dollar Cutters][Promotions].[All Promotions].[Dollar Days][Promotions].[All Promotions].[Double Down Sale][Promotions].[All Promotions].[Double Your Savings][Promotions].[All Promotions].[Fantastic Discounts][Promotions].[All Promotions].[Free For All][Promotions].[All Promotions].[Go For It][Promotions].[All Promotions].[Green Light Days][Promotions].[All Promotions].[Green Light Special][Promotions].[All Promotions].[High Roller Savings][Promotions].[All Promotions].[I Cant Believe It Sale][Promotions].[All Promotions].[Money Grabbers][Promotions].[All Promotions].[Money Savers][Promotions].[All Promotions].[Mystery Sale][Promotions].[All Promotions].[No Promotion][Promotions].[All Promotions].[One Day Sale][Promotions].[All Promotions].[Pick Your Savings][Promotions].[All Promotions].[Price Cutters][Promotions].[All Promotions].[Price Destroyers][Promotions].[All Promotions].[Price Savers][Promotions].[All Promotions].[Price Slashers][Promotions].[All Promotions].[Price Smashers][Promotions].[All Promotions].[Price Winners][Promotions].[All Promotions].[Sale Winners][Promotions].[All Promotions].[Sales Days][Promotions].[All Promotions].[Sales Galore][Promotions].[All Promotions].[Save-It Sale][Promotions].[All Promotions].[Saving Days][Promotions].[All Promotions].[Savings Galore][Promotions].[All Promotions].[Shelf Clearing Days][Promotions].[All Promotions].[Shelf Emptiers][Promotions].[All Promotions].[Super Duper Savers][Promotions].[All Promotions].[Super Savers][Promotions].[All Promotions].[Super Wallet Savers][Promotions].[All Promotions].[Three for One][Promotions].[All Promotions].[Tip Top Savings][Promotions].[All Promotions].[Two Day Sale][Promotions].[All Promotions].[Two for One][Promotions].[All Promotions].[Unbeatable Price Savers][Promotions].[All Promotions].[Wallet Savers][Promotions].[All Promotions].[Weekend Markdown][Promotions].[All Promotions].[You Save Days]";
    private static final String moreThan4000highCardResults = "[Promotions].[All Promotions].[Cash Register Lottery][Promotions].[All Promotions].[No Promotion][Promotions].[All Promotions].[Price Savers]";
    private static final String moreThan4000Cells = "4792.0195448.04094.0";
    private static final String nonEmptyCells = "901.02081.01789.0932.0700.0921.04792.01219.0781.01652.01959.0843.01638.0689.01607.0436.02654.0253.0899.01021.0195448.01973.0323.01624.02173.04094.01148.0504.01294.0444.02055.02572.02203.01446.01382.0754.02118.02628.02497.01183.01155.0525.02053.0335.02100.0916.0914.03145.0";
    private static final String topcount40Cells = "195448.04792.04094.03145.02654.02628.02572.02497.02203.02173.02118.02100.02081.02055.02053.01973.01959.01789.01652.01638.01624.01607.01446.01382.01294.01219.01183.01155.01148.01021.0932.0921.0916.0914.0901.0899.0843.0781.0754.0700.0";
    private static final String topcount41Cells = "195448.04792.04094.03145.02654.02628.02572.02497.02203.02173.02118.02100.02081.02055.02053.01973.01959.01789.01652.01638.01624.01607.01446.01382.01294.01219.01183.01155.01148.01021.0932.0921.0916.0914.0901.0899.0843.0781.0754.0700.0689.0";

    public HighDimensionsTest() {
    }

    public HighDimensionsTest(String name) {
        super(name);
    }

    public void testBug1971406() throws Exception {
        long nt0 = System.currentTimeMillis();
        int t = 0;
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            t += i;
        }
        long nt1 = System.currentTimeMillis();
        long baselineTime = 0L;
        if (t > 0) {
            baselineTime = nt1 - nt0;
        }
        Connection connection = TestContext.instance().getFoodMartConnection();
        Query query = connection.parseQuery("with set necj as NonEmptyCrossJoin(NonEmptyCrossJoin([Customers].[Name].members,[Store].[Store Name].members),[Product].[Product Name].members) select {[Measures].[Unit Sales]} on columns,tail(intersect(necj,necj,ALL),5) on rows from sales");
        long t0 = System.currentTimeMillis();
        Result result = connection.execute(query);
        for (Position o : result.getAxes()[0].getPositions()) {
            HighDimensionsTest.assertNotNull(o.get(0));
        }
        long t1 = System.currentTimeMillis();
        HighDimensionsTest.assertTrue((String)("Query failed to execute within " + 60L * baselineTime + " milliseconds"), (t1 - t0 < 60L * baselineTime ? 1 : 0) != 0);
    }

    public void testPromotionsTwoDimensions() throws Exception {
    }

    public void testHead() throws Exception {
    }

    public void testTopCount() throws Exception {
        Connection connection = TestContext.instance().getFoodMartConnection();
        StringBuffer buffer = new StringBuffer();
        Query query = connection.parseQuery("select {[Measures].[Unit Sales]} on columns,\nTopCount({[Promotions].[Promotion Name].Members},41, [Measures].[Unit Sales]) on rows from [Sales Ragged]");
        Result result = connection.execute(query);
        int i = 0;
        String topcount40HighCardResults = null;
        String topcount41HighCardResults = null;
        for (Position o : result.getAxes()[1].getPositions()) {
            buffer.append(o.get(0));
            if (++i != 40) continue;
            topcount40HighCardResults = buffer.toString();
        }
        topcount41HighCardResults = buffer.toString();
        this.execHighCardTest("select {[Measures].[Unit Sales]} on columns,\nTopCount({[Promotions].[Promotion Name].Members},40, [Measures].[Unit Sales]) on rows from [Sales Ragged]", 1, "Promotions", topcount40HighCardResults, topcount40Cells, false);
        this.execHighCardTest("select {[Measures].[Unit Sales]} on columns,\nTopCount({[Promotions].[Promotion Name].Members},41, [Measures].[Unit Sales]) on rows from [Sales Ragged]", 1, "Promotions", topcount41HighCardResults, topcount41Cells, false);
        this.execHighCardTest("select {[Measures].[Unit Sales]} on columns,\nTopCount({[Promotions].[Promotion Name].Members},40, [Measures].[Unit Sales]) on rows from [Sales Ragged]", 1, "Promotions", topcount40HighCardResults, topcount40Cells, false);
    }

    public void testNonEmpty() throws Exception {
    }

    public void testFilter() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execHighCardTest(String queryString, int axisIndex, String highDimensionName, String results, String results2, boolean shouldForget) throws Exception {
        int old = MondrianProperties.instance().ResultLimit.get();
        try {
            MondrianProperties.instance().ResultLimit.set(40);
            TestContext testContext = TestContext.createSubstitutingCube("Sales Ragged", "<Dimension name=\"Promotions\" highCardinality=\"true\" foreignKey=\"promotion_id\"><Hierarchy hasAll=\"true\" allMemberName=\"All Promotions\" primaryKey=\"promotion_id\"><Table name=\"promotion\"/><Level name=\"Promotion Name\" column=\"promotion_name\" uniqueMembers=\"true\"/></Hierarchy></Dimension>");
            Connection connection = testContext.getConnection();
            Query query = connection.parseQuery(queryString);
            query.setResultStyle(ResultStyle.ITERABLE);
            Result result = connection.execute(query);
            StringBuffer buffer = new StringBuffer();
            StringBuffer buffer2 = new StringBuffer();
            ArrayList softReferences = new ArrayList();
            int ii = 0;
            for (Position o : result.getAxes()[axisIndex].getPositions()) {
                HighDimensionsTest.assertNotNull(o.get(0));
                buffer2.append(result.getCell(new int[]{0, ii++}).getValue().toString());
                softReferences.add(new SoftReference(o.get(0)));
                buffer.append(((Member)o.get(0)).toString());
            }
            HighDimensionsTest.assertEquals((int)buffer.toString().length(), (int)results.length());
            if (results2 != null) {
                HighDimensionsTest.assertEquals((int)buffer2.toString().length(), (int)results2.length());
            }
            buffer2 = null;
            buffer = null;
            if (!shouldForget) {
                return;
            }
            ArrayList<long[]> overloader = new ArrayList<long[]>();
            try {
                while (true) {
                    overloader.add(new long[99999999]);
                }
            }
            catch (OutOfMemoryError out) {
                int i;
                System.gc();
                for (i = 4; i < ii - 40; ++i) {
                    HighDimensionsTest.assertNull(((SoftReference)softReferences.get(i)).get());
                }
                for (i = 4; i < ii - 40; ++i) {
                    try {
                        result.getAxes()[axisIndex].getPositions().get(i).get(0);
                        Assert.fail((String)"Expected runtime exception of type RuntimeException");
                        continue;
                    }
                    catch (RuntimeException nsee) {
                        // empty catch block
                    }
                }
                MondrianProperties.instance().ResultLimit.set(old);
            }
        }
        finally {
            MondrianProperties.instance().ResultLimit.set(old);
        }
    }
}

