/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Assert;
import junit.framework.ComparisonFailure;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Connection;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.olap.fun.BuiltinFunTable;
import mondrian.olap.fun.FunInfo;
import mondrian.olap.fun.UdfResolver;
import mondrian.resource.MondrianResource;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;
import mondrian.udf.CurrentDateMemberExactUdf;
import mondrian.udf.CurrentDateMemberUdf;
import mondrian.udf.CurrentDateStringUdf;
import org.apache.log4j.Logger;
import org.eigenbase.xom.StringEscaper;

public class FunctionTest
extends FoodMartTestCase {
    private static final Logger LOGGER = Logger.getLogger(FunctionTest.class);
    private static final String months = FunctionTest.fold("[Time].[1997].[Q1].[1]\n[Time].[1997].[Q1].[2]\n[Time].[1997].[Q1].[3]\n[Time].[1997].[Q2].[4]\n[Time].[1997].[Q2].[5]\n[Time].[1997].[Q2].[6]\n[Time].[1997].[Q3].[7]\n[Time].[1997].[Q3].[8]\n[Time].[1997].[Q3].[9]\n[Time].[1997].[Q4].[10]\n[Time].[1997].[Q4].[11]\n[Time].[1997].[Q4].[12]");
    private static final String quarters = FunctionTest.fold("[Time].[1997].[Q1]\n[Time].[1997].[Q2]\n[Time].[1997].[Q3]\n[Time].[1997].[Q4]");
    private static final String year1997 = "[Time].[1997]";
    private static final String hierarchized1997 = FunctionTest.fold("[Time].[1997]\n[Time].[1997].[Q1]\n[Time].[1997].[Q1].[1]\n[Time].[1997].[Q1].[2]\n[Time].[1997].[Q1].[3]\n[Time].[1997].[Q2]\n[Time].[1997].[Q2].[4]\n[Time].[1997].[Q2].[5]\n[Time].[1997].[Q2].[6]\n[Time].[1997].[Q3]\n[Time].[1997].[Q3].[7]\n[Time].[1997].[Q3].[8]\n[Time].[1997].[Q3].[9]\n[Time].[1997].[Q4]\n[Time].[1997].[Q4].[10]\n[Time].[1997].[Q4].[11]\n[Time].[1997].[Q4].[12]");
    private static final String NullNumericExpr = " ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer])";

    public FunctionTest() {
    }

    public FunctionTest(String s) {
        super(s);
    }

    public void testParallelPeriodMinValue() {
        String query = "with member [measures].[foo] as '([Measures].[unit sales],ParallelPeriod([Time].[Quarter], -2147483648))' select [measures].[foo] on columns, [time].[1997].children on rows from [sales]";
        this.executeQuery(query);
    }

    public void testLagMinValue() {
        String query = "with member [measures].[foo] as '([Measures].[unit sales], [Time].[1997].[Q1].Lag(-2147483648))' select [measures].[foo] on columns, [time].[1997].children on rows from [sales]";
        this.executeQuery(query);
    }

    public void testParallelPeriodWithSlicer() {
        String query = "With Set [*NATIVE_CJ_SET] as 'NonEmptyCrossJoin([*BASE_MEMBERS_Time],[*BASE_MEMBERS_Product])' Set [*BASE_MEMBERS_Measures] as '{[Measures].[*FORMATTED_MEASURE_0], [Measures].[*FORMATTED_MEASURE_1]}' Set [*BASE_MEMBERS_Time] as '{[Time].[1997].[Q2].[6]}' Set [*NATIVE_MEMBERS_Time] as 'Generate([*NATIVE_CJ_SET], {[Time].CurrentMember})' Set [*BASE_MEMBERS_Product] as '{[Product].[All Products].[Drink],[Product].[All Products].[Food]}' Set [*NATIVE_MEMBERS_Product] as 'Generate([*NATIVE_CJ_SET], {[Product].CurrentMember})' Member [Measures].[*FORMATTED_MEASURE_0] as '[Measures].[Customer Count]', FORMAT_STRING = '#,##0', SOLVE_ORDER=400 Member [Measures].[*FORMATTED_MEASURE_1] as '([Measures].[Customer Count], ParallelPeriod([Time].[Quarter], 1, [Time].currentMember))', FORMAT_STRING = '#,##0', SOLVE_ORDER=-200 Member [Product].[*FILTER_MEMBER] as 'Aggregate ([*NATIVE_MEMBERS_Product])', SOLVE_ORDER=-300 Select [*BASE_MEMBERS_Measures] on columns, Non Empty Generate([*NATIVE_CJ_SET], {([Time].CurrentMember)}) on rows From [Sales] Where ([Product].[*FILTER_MEMBER])";
        String result = "Axis #0:\n{[Product].[*FILTER_MEMBER]}\nAxis #1:\n{[Measures].[*FORMATTED_MEASURE_0]}\n{[Measures].[*FORMATTED_MEASURE_1]}\nAxis #2:\n{[Time].[1997].[Q2].[6]}\nRow #0: 1,314\nRow #0: 1,447\n";
        this.assertQueryReturns(query, FunctionTest.fold(result));
    }

    public void testParallelperiodOnLevelsString() {
        this.assertQueryReturns("with member Measures.[Prev Unit Sales] as 'parallelperiod(Levels(\"[Time].[Month]\"))'\nselect {[Measures].[Unit Sales], Measures.[Prev Unit Sales]} ON COLUMNS,\n[Gender].members ON ROWS\nfrom [Sales]\nwhere [Time].[1997].[Q2].[5]", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q2].[5]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Prev Unit Sales]}\nAxis #2:\n{[Gender].[All Gender]}\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\nRow #0: 21,081\nRow #0: 20,179\nRow #1: 10,536\nRow #1: 9,990\nRow #2: 10,545\nRow #2: 10,189\n"));
    }

    public void testParallelperiodOnStrToMember() {
        this.assertQueryReturns("with member Measures.[Prev Unit Sales] as 'parallelperiod(strToMember(\"[Time].[1997].[Q2]\"))'\nselect {[Measures].[Unit Sales], Measures.[Prev Unit Sales]} ON COLUMNS,\n[Gender].members ON ROWS\nfrom [Sales]\nwhere [Time].[1997].[Q2].[5]", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q2].[5]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Prev Unit Sales]}\nAxis #2:\n{[Gender].[All Gender]}\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\nRow #0: 21,081\nRow #0: 20,957\nRow #1: 10,536\nRow #1: 10,266\nRow #2: 10,545\nRow #2: 10,691\n"));
        this.assertThrows("with member Measures.[Prev Unit Sales] as 'parallelperiod(strToMember(\"[Time].[Quarter]\"))'\nselect {[Measures].[Unit Sales], Measures.[Prev Unit Sales]} ON COLUMNS,\n[Gender].members ON ROWS\nfrom [Sales]\nwhere [Time].[1997].[Q2].[5]", "Cannot find MDX member '[Time].[Quarter]'. Make sure it is indeed a member and not a level or a hierarchy.");
    }

    public void testNumericLiteral() {
        this.assertExprReturns("2", "2");
        this.assertExprReturns("-10.0", "-10");
        this.getTestContext().assertExprDependsOn("1.5", "{}");
    }

    public void testStringLiteral() {
        this.assertExprReturns("\"foobar\"", "foobar");
        this.getTestContext().assertExprDependsOn("\"foobar\"", "{}");
    }

    public void testDimensionHierarchy() {
        this.assertExprReturns("[Time].Dimension.Name", "Time");
    }

    public void testLevelDimension() {
        this.assertExprReturns("[Time].[Year].Dimension.UniqueName", "[Time]");
    }

    public void testMemberDimension() {
        this.assertExprReturns("[Time].[1997].[Q2].Dimension.UniqueName", "[Time]");
    }

    public void testDimensionsNumeric() {
        this.getTestContext().assertExprDependsOn("Dimensions(2).Name", "{}");
        this.getTestContext().assertMemberExprDependsOn("Dimensions(3).CurrentMember", TestContext.allDims());
        this.assertExprReturns("Dimensions(2).Name", "Store Size in SQFT");
        this.assertExprReturns("Dimensions(0).Name", "Measures");
        this.assertExprThrows("Dimensions(-1).Name", "Index '-1' out of bounds");
        this.assertExprThrows("Dimensions(100).Name", "Index '100' out of bounds");
    }

    public void testDimensionsString() {
        this.getTestContext().assertExprDependsOn("Dimensions(\"foo\").UniqueName", "{}");
        this.getTestContext().assertMemberExprDependsOn("Dimensions(\"foo\").CurrentMember", TestContext.allDims());
        this.assertExprReturns("Dimensions(\"Store\").UniqueName", "[Store]");
    }

    public void testDimensionsDepends() {
        String expression = "Crossjoin({Dimensions(\"Measures\").CurrentMember.Hierarchy.CurrentMember}, {Dimensions(\"Product\")})";
        this.assertAxisReturns("Crossjoin({Dimensions(\"Measures\").CurrentMember.Hierarchy.CurrentMember}, {Dimensions(\"Product\")})", "{[Measures].[Unit Sales], [Product].[All Products]}");
        this.getTestContext().assertSetExprDependsOn("Crossjoin({Dimensions(\"Measures\").CurrentMember.Hierarchy.CurrentMember}, {Dimensions(\"Product\")})", TestContext.allDims());
    }

    public void testTime() {
        this.assertExprReturns("[Time].[1997].[Q1].[1].Hierarchy.UniqueName", "[Time]");
    }

    public void testBasic9() {
        this.assertExprReturns("[Gender].[All Gender].[F].Hierarchy.UniqueName", "[Gender]");
    }

    public void testFirstInLevel9() {
        this.assertExprReturns("[Education Level].[All Education Levels].[Bachelors Degree].Hierarchy.UniqueName", "[Education Level]");
    }

    public void testHierarchyAll() {
        this.assertExprReturns("[Gender].[All Gender].Hierarchy.UniqueName", "[Gender]");
    }

    public void testNullMember() {
        this.assertExprReturns("[Gender].[All Gender].Parent.Level.UniqueName", "[Gender].[(All)]");
        this.assertExprReturns("[Gender].[All Gender].Parent.Hierarchy.UniqueName", "[Gender]");
        this.assertExprReturns("[Gender].[All Gender].Parent.Dimension.UniqueName", "[Gender]");
        this.assertExprReturns("[Gender].[All Gender].Parent.Children.Count", "0");
        if (this.isDefaultNullMemberRepresentation()) {
            this.assertExprReturns("[Gender].[All Gender].Parent.UniqueName", "[Gender].[#null]");
            this.assertExprReturns("[Gender].[All Gender].Parent.Name", "#null");
        }
    }

    public void testNullValue() {
        this.assertQueryReturns("with member [Measures].[X] as 'IIF([Measures].[Store Sales]>10000,[Measures].[Store Sales],Null)'\nselect\n{[Measures].[X]} on columns,\n{[Product].[Product Department].members} on rows\nfrom Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[X]}\nAxis #2:\n{[Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Product].[All Products].[Drink].[Beverages]}\n{[Product].[All Products].[Drink].[Dairy]}\n{[Product].[All Products].[Food].[Baked Goods]}\n{[Product].[All Products].[Food].[Baking Goods]}\n{[Product].[All Products].[Food].[Breakfast Foods]}\n{[Product].[All Products].[Food].[Canned Foods]}\n{[Product].[All Products].[Food].[Canned Products]}\n{[Product].[All Products].[Food].[Dairy]}\n{[Product].[All Products].[Food].[Deli]}\n{[Product].[All Products].[Food].[Eggs]}\n{[Product].[All Products].[Food].[Frozen Foods]}\n{[Product].[All Products].[Food].[Meat]}\n{[Product].[All Products].[Food].[Produce]}\n{[Product].[All Products].[Food].[Seafood]}\n{[Product].[All Products].[Food].[Snack Foods]}\n{[Product].[All Products].[Food].[Snacks]}\n{[Product].[All Products].[Food].[Starchy Foods]}\n{[Product].[All Products].[Non-Consumable].[Carousel]}\n{[Product].[All Products].[Non-Consumable].[Checkout]}\n{[Product].[All Products].[Non-Consumable].[Health and Hygiene]}\n{[Product].[All Products].[Non-Consumable].[Household]}\n{[Product].[All Products].[Non-Consumable].[Periodicals]}\nRow #0: 14,029.08\nRow #1: 27,748.53\nRow #2: \nRow #3: 16,455.43\nRow #4: 38,670.41\nRow #5: \nRow #6: 39,774.34\nRow #7: \nRow #8: 30,508.85\nRow #9: 25,318.93\nRow #10: \nRow #11: 55,207.50\nRow #12: \nRow #13: 82,248.42\nRow #14: \nRow #15: 67,609.82\nRow #16: 14,550.05\nRow #17: 11,756.07\nRow #18: \nRow #19: \nRow #20: 32,571.86\nRow #21: 60,469.89\nRow #22: \n"));
    }

    public void testNullInMultiplication() {
        this.assertExprReturns("NULL*1", "");
        this.assertExprReturns("1*NULL", "");
        this.assertExprReturns("NULL*NULL", "");
    }

    public void testNullInAddition() {
        this.assertExprReturns("1+NULL", "1");
        this.assertExprReturns("NULL+1", "1");
    }

    public void testNullInSubtraction() {
        this.assertExprReturns("1-NULL", "1");
        this.assertExprReturns("NULL-1", "-1");
    }

    public void testMemberLevel() {
        this.assertExprReturns("[Time].[1997].[Q1].[1].Level.UniqueName", "[Time].[Month]");
    }

    public void testLevelsNumeric() {
        this.assertExprReturns("[Time].Levels(2).Name", "Month");
        this.assertExprReturns("[Time].Levels(0).Name", "Year");
        this.assertExprReturns("[Product].Levels(0).Name", "(All)");
    }

    public void testLevelsTooSmall() {
        this.assertExprThrows("[Time].Levels(-1).Name", "Index '-1' out of bounds");
    }

    public void testLevelsTooLarge() {
        this.assertExprThrows("[Time].Levels(8).Name", "Index '8' out of bounds");
    }

    public void testHierarchyLevelsString() {
        this.assertExprReturns("[Time].Levels(\"Year\").UniqueName", "[Time].[Year]");
    }

    public void testHierarchyLevelsStringFail() {
        this.assertExprThrows("[Time].Levels(\"nonexistent\").UniqueName", "Level 'nonexistent' not found in hierarchy '[Time]'");
    }

    public void testLevelsString() {
        this.assertExprReturns("Levels(\"[Time].[Year]\").UniqueName", "[Time].[Year]");
    }

    public void testLevelsStringFail() {
        this.assertExprThrows("Levels(\"nonexistent\").UniqueName", "Level 'nonexistent' not found");
    }

    public void testIsEmptyQuery() {
        String desiredResult = FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q4].[12], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth].[Portsmouth Imported Beer], [Measures].[Foo]}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\n{[Store].[All Stores].[USA].[WA].[Bremerton]}\n{[Store].[All Stores].[USA].[WA].[Seattle]}\n{[Store].[All Stores].[USA].[WA].[Spokane]}\n{[Store].[All Stores].[USA].[WA].[Tacoma]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla]}\n{[Store].[All Stores].[USA].[WA].[Yakima]}\nRow #0: 5\nRow #0: 5\nRow #0: 2\nRow #0: 5\nRow #0: 11\nRow #0: 5\nRow #0: 4\n");
        this.assertQueryReturns("WITH MEMBER [Measures].[Foo] AS 'Iif(IsEmpty([Measures].[Unit Sales]), 5, [Measures].[Unit Sales])'\nSELECT {[Store].[USA].[WA].children} on columns\nFROM Sales\nWHERE ([Time].[1997].[Q4].[12],\n [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth].[Portsmouth Imported Beer],\n [Measures].[Foo])", desiredResult);
        this.assertQueryReturns("WITH MEMBER [Measures].[Foo] AS 'Iif([Measures].[Unit Sales] IS EMPTY, 5, [Measures].[Unit Sales])'\nSELECT {[Store].[USA].[WA].children} on columns\nFROM Sales\nWHERE ([Time].[1997].[Q4].[12],\n [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth].[Portsmouth Imported Beer],\n [Measures].[Foo])", desiredResult);
    }

    public void testIsEmptyWithAggregate() {
        this.assertQueryReturns("WITH MEMBER [gender].[foo] AS 'isEmpty(Aggregate({[Gender].m}))' SELECT {Gender.foo} on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Gender].[foo]}\nRow #0: false\n"));
    }

    public void testIsEmpty() {
        this.assertBooleanExprReturns("[Gender].[All Gender].Parent IS NULL", true);
        this.assertBooleanExprReturns("[Gender].CurrentMember.Parent.NextMember IS NULL", true);
    }

    public void testQueryWithoutValidMeasure() {
        String query = "with\nmember measures.[without VM] as ' [measures].[unit sales] '\nselect {measures.[without VM] } on 0,\n[Warehouse].[Country].members on 1 from [warehouse and sales]\n";
        String expectedResult = "Axis #0:\n{}\nAxis #1:\n{[Measures].[without VM]}\nAxis #2:\n{[Warehouse].[All Warehouses].[Canada]}\n{[Warehouse].[All Warehouses].[Mexico]}\n{[Warehouse].[All Warehouses].[USA]}\nRow #0: \nRow #1: \nRow #2: \n";
        this.assertQueryReturns(query, FunctionTest.fold(expectedResult));
    }

    public void testValidMeasure() {
        String query = "with\nmember measures.[with VM] as 'validmeasure([measures].[unit sales])'\nselect { measures.[with VM]} on 0,\n[Warehouse].[Country].members on 1 from [warehouse and sales]\n";
        String expectedResult = "Axis #0:\n{}\nAxis #1:\n{[Measures].[with VM]}\nAxis #2:\n{[Warehouse].[All Warehouses].[Canada]}\n{[Warehouse].[All Warehouses].[Mexico]}\n{[Warehouse].[All Warehouses].[USA]}\nRow #0: 266,773\nRow #1: 266,773\nRow #2: 266,773\n";
        this.assertQueryReturns(query, FunctionTest.fold(expectedResult));
    }

    public void _testValidMeasureNonEmpty() {
        this.assertQueryReturns("with set [Foo] as ' Crossjoin({[Time].Children}, {[Measures].[Warehouse Sales]}) '\n member [Measures].[with VM] as 'ValidMeasure([Measures].[Unit Sales])'\n member [Measures].[with VM2] as 'Iif(Count(Filter([Foo], not isempty([Measures].CurrentMember))) > 0, ValidMeasure([Measures].[Unit Sales]), NULL)'\nselect NON EMPTY Crossjoin({[Time].Children}, {[Measures].[with VM2], [Measures].[Warehouse Sales]}) ON COLUMNS,\n  NON EMPTY {[Warehouse].[All Warehouses].[USA].[WA].Children} ON ROWS\nfrom [Warehouse and Sales]\nwhere [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Light Beer]", FunctionTest.fold("Axis #0:\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Light Beer]}\nAxis #1:\n{[Time].[1997].[Q1], [Measures].[with VM2]}\n{[Time].[1997].[Q1], [Measures].[Warehouse Sales]}\n{[Time].[1997].[Q2], [Measures].[with VM2]}\n{[Time].[1997].[Q2], [Measures].[Warehouse Sales]}\n{[Time].[1997].[Q3], [Measures].[with VM2]}\n{[Time].[1997].[Q4], [Measures].[with VM2]}\nAxis #2:\n{[Warehouse].[All Warehouses].[USA].[WA].[Seattle]}\n{[Warehouse].[All Warehouses].[USA].[WA].[Tacoma]}\n{[Warehouse].[All Warehouses].[USA].[WA].[Yakima]}\nRow #0: 26\nRow #0: 34.793\nRow #0: 25\nRow #0: \nRow #0: 36\nRow #0: 28\nRow #1: 26\nRow #1: \nRow #1: 25\nRow #1: 64.615\nRow #1: 36\nRow #1: 28\nRow #2: 26\nRow #2: 79.657\nRow #2: 25\nRow #2: \nRow #2: 36\nRow #2: 28\n"));
    }

    public void testValidMeasureTupleHasAnotherMember() {
        String query = "with\nmember measures.[with VM] as 'validmeasure(([measures].[unit sales],[customers].[all customers]))'\nselect { measures.[with VM]} on 0,\n[Warehouse].[Country].members on 1 from [warehouse and sales]\n";
        String expectedResult = "Axis #0:\n{}\nAxis #1:\n{[Measures].[with VM]}\nAxis #2:\n{[Warehouse].[All Warehouses].[Canada]}\n{[Warehouse].[All Warehouses].[Mexico]}\n{[Warehouse].[All Warehouses].[USA]}\nRow #0: 266,773\nRow #1: 266,773\nRow #2: 266,773\n";
        this.assertQueryReturns(query, FunctionTest.fold(expectedResult));
    }

    public void testValidMeasureDepends() {
        String s12 = TestContext.allDimsExcept("[Measures]");
        this.getTestContext().assertExprDependsOn("ValidMeasure([Measures].[Unit Sales])", s12);
        String s11 = TestContext.allDimsExcept("[Measures]", "[Time]");
        this.getTestContext().assertExprDependsOn("ValidMeasure(([Measures].[Unit Sales], [Time].[1997].[Q1]))", s11);
        String s1 = TestContext.allDimsExcept("[Measures]");
        this.getTestContext().assertExprDependsOn("ValidMeasure(([Measures].[Unit Sales], [Time].CurrentMember.Parent))", s1);
    }

    public void testAncestor() {
        Member member = this.executeSingletonAxis("Ancestor([Store].[USA].[CA].[Los Angeles],[Store Country])");
        Assert.assertEquals((String)"USA", (String)member.getName());
        this.assertAxisThrows("Ancestor([Store].[USA].[CA].[Los Angeles],[Promotions].[Promotion Name])", "Error while executing query");
    }

    public void testAncestorNumeric() {
        Member member = this.executeSingletonAxis("Ancestor([Store].[USA].[CA].[Los Angeles],1)");
        Assert.assertEquals((String)"CA", (String)member.getName());
        member = this.executeSingletonAxis("Ancestor([Store].[USA].[CA].[Los Angeles], 0)");
        Assert.assertEquals((String)"Los Angeles", (String)member.getName());
        TestContext testContextRagged = this.getTestContext().withCube("[Sales Ragged]");
        member = testContextRagged.executeSingletonAxis("Ancestor([Store].[All Stores].[Vatican], 1)");
        Assert.assertEquals((String)"All Stores", (String)member.getName());
        member = testContextRagged.executeSingletonAxis("Ancestor([Store].[USA].[Washington], 1)");
        Assert.assertEquals((String)"USA", (String)member.getName());
        member = testContextRagged.executeSingletonAxis("Ancestor([Store].[USA].[Washington], 7 * 6 - 41)");
        Assert.assertEquals((String)"USA", (String)member.getName());
        member = testContextRagged.executeSingletonAxis("Ancestor([Store].[All Stores].[Vatican], 2)");
        Assert.assertNull((String)"Ancestor at 2 must be null", (Object)member);
        member = testContextRagged.executeSingletonAxis("Ancestor([Store].[All Stores].[Vatican], -5)");
        Assert.assertNull((String)"Ancestor at -5 must be null", (Object)member);
    }

    public void testAncestorHigher() {
        Member member = this.executeSingletonAxis("Ancestor([Store].[USA],[Store].[Store City])");
        Assert.assertNull((Object)member);
    }

    public void testAncestorSameLevel() {
        Member member = this.executeSingletonAxis("Ancestor([Store].[Canada],[Store].[Store Country])");
        Assert.assertEquals((String)"Canada", (String)member.getName());
    }

    public void testAncestorWrongHierarchy() {
        this.assertAxisThrows("Ancestor([Gender].[M],[Store].[Store Country])", "Error while executing query");
    }

    public void testAncestorAllLevel() {
        Member member = this.executeSingletonAxis("Ancestor([Store].[USA].[CA],[Store].Levels(0))");
        Assert.assertTrue((boolean)member.isAll());
    }

    public void testAncestorWithHiddenParent() {
        TestContext testContext = this.getTestContext().withCube("[Sales Ragged]");
        Member member = testContext.executeSingletonAxis("Ancestor([Store].[All Stores].[Israel].[Haifa], [Store].[Store Country])");
        FunctionTest.assertNotNull((String)"Member must not be null.", (Object)member);
        Assert.assertEquals((String)"Israel", (String)member.getName());
    }

    public void testAncestorDepends() {
        this.getTestContext().assertExprDependsOn("Ancestor([Store].CurrentMember, [Store].[Store Country]).Name", "{[Store]}");
        this.getTestContext().assertExprDependsOn("Ancestor([Store].[All Stores].[USA], [Store].CurrentMember.Level).Name", "{[Store]}");
        this.getTestContext().assertExprDependsOn("Ancestor([Store].[All Stores].[USA], [Store].[Store Country]).Name", "{}");
        this.getTestContext().assertExprDependsOn("Ancestor([Store].CurrentMember, 2+1).Name", "{[Store]}");
    }

    public void testOrdinal() {
        TestContext testContext = this.getTestContext().withCube("Sales Ragged");
        Cell cell = testContext.executeExprRaw("[Store].[All Stores].[Vatican].ordinal");
        FunctionTest.assertEquals((String)"Vatican is at level 1.", (int)1, (int)((Number)cell.getValue()).intValue());
        cell = testContext.executeExprRaw("[Store].[All Stores].[USA].[Washington].ordinal");
        FunctionTest.assertEquals((String)"Washington is at level 3.", (int)3, (int)((Number)cell.getValue()).intValue());
    }

    public void testClosingPeriodNoArgs() {
        this.getTestContext().assertMemberExprDependsOn("ClosingPeriod()", "{[Time]}");
        Member member = this.executeSingletonAxis("ClosingPeriod()");
        Assert.assertEquals((String)"[Time].[1997].[Q4]", (String)member.getUniqueName());
    }

    public void testClosingPeriodLevel() {
        this.getTestContext().assertMemberExprDependsOn("ClosingPeriod([Time].[Year])", "{[Time]}");
        this.getTestContext().assertMemberExprDependsOn("([Measures].[Unit Sales], ClosingPeriod([Time].[Month]))", "{[Time]}");
        Member member = this.executeSingletonAxis("ClosingPeriod([Year])");
        Assert.assertEquals((String)year1997, (String)member.getUniqueName());
        member = this.executeSingletonAxis("ClosingPeriod([Quarter])");
        Assert.assertEquals((String)"[Time].[1997].[Q4]", (String)member.getUniqueName());
        member = this.executeSingletonAxis("ClosingPeriod([Month])");
        Assert.assertEquals((String)"[Time].[1997].[Q4].[12]", (String)member.getUniqueName());
        this.assertQueryReturns("with member [Measures].[Closing Unit Sales] as '([Measures].[Unit Sales], ClosingPeriod([Time].[Month]))'\nselect non empty {[Measures].[Closing Unit Sales]} on columns,\n {Descendants([Time].[1997])} on rows\nfrom [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Closing Unit Sales]}\nAxis #2:\n{[Time].[1997]}\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q1].[1]}\n{[Time].[1997].[Q1].[2]}\n{[Time].[1997].[Q1].[3]}\n{[Time].[1997].[Q2]}\n{[Time].[1997].[Q2].[4]}\n{[Time].[1997].[Q2].[5]}\n{[Time].[1997].[Q2].[6]}\n{[Time].[1997].[Q3]}\n{[Time].[1997].[Q3].[7]}\n{[Time].[1997].[Q3].[8]}\n{[Time].[1997].[Q3].[9]}\n{[Time].[1997].[Q4]}\n{[Time].[1997].[Q4].[10]}\n{[Time].[1997].[Q4].[11]}\n{[Time].[1997].[Q4].[12]}\nRow #0: 26,796\nRow #1: 23,706\nRow #2: 21,628\nRow #3: 20,957\nRow #4: 23,706\nRow #5: 21,350\nRow #6: 20,179\nRow #7: 21,081\nRow #8: 21,350\nRow #9: 20,388\nRow #10: 23,763\nRow #11: 21,697\nRow #12: 20,388\nRow #13: 26,796\nRow #14: 19,958\nRow #15: 25,270\nRow #16: 26,796\n"));
        this.assertQueryReturns("with member [Measures].[Closing Unit Sales] as '([Measures].[Unit Sales], ClosingPeriod([Time].[Month]))'\nselect {[Measures].[Unit Sales], [Measures].[Closing Unit Sales]} on columns,\n {[Time].[1997], [Time].[1997].[Q1], [Time].[1997].[Q1].[1], [Time].[1997].[Q1].[3], [Time].[1997].[Q4].[12]} on rows\nfrom [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Closing Unit Sales]}\nAxis #2:\n{[Time].[1997]}\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q1].[1]}\n{[Time].[1997].[Q1].[3]}\n{[Time].[1997].[Q4].[12]}\nRow #0: 266,773\nRow #0: 26,796\nRow #1: 66,291\nRow #1: 23,706\nRow #2: 21,628\nRow #2: 21,628\nRow #3: 23,706\nRow #3: 23,706\nRow #4: 26,796\nRow #4: 26,796\n"));
    }

    public void testClosingPeriodLevelNotInTimeFails() {
        this.assertAxisThrows("ClosingPeriod([Store].[Store City])", "The <level> and <member> arguments to ClosingPeriod must be from the same hierarchy. The level was from '[Store]' but the member was from '[Time]'");
    }

    public void testClosingPeriodMember() {
    }

    public void testClosingPeriodMemberLeaf() {
        if (this.isDefaultNullMemberRepresentation()) {
            this.assertQueryReturns("with member [Measures].[Foo] as ' ClosingPeriod().uniquename '\nselect {[Measures].[Foo]} on columns,\n  {[Time].[1997],\n   [Time].[1997].[Q2],\n   [Time].[1997].[Q2].[4]} on rows\nfrom Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Foo]}\nAxis #2:\n{[Time].[1997]}\n{[Time].[1997].[Q2]}\n{[Time].[1997].[Q2].[4]}\nRow #0: [Time].[1997].[Q4]\nRow #1: [Time].[1997].[Q2].[6]\nRow #2: [Time].[#null]\n"));
        }
    }

    public void testClosingPeriod() {
        this.getTestContext().assertMemberExprDependsOn("ClosingPeriod([Time].[Month], [Time].CurrentMember)", "{[Time]}");
        String s1 = TestContext.allDimsExcept("[Measures]");
        this.getTestContext().assertExprDependsOn("(([Measures].[Store Sales], ClosingPeriod([Time].[Month], [Time].CurrentMember)) - ([Measures].[Store Cost], ClosingPeriod([Time].[Month], [Time].CurrentMember)))", s1);
        this.getTestContext().assertMemberExprDependsOn("ClosingPeriod([Time].[Month], [Time].[1997].[Q3])", "{}");
        this.assertAxisReturns("ClosingPeriod([Time].[Year], [Time].[1997].[Q3])", "");
        this.assertAxisReturns("ClosingPeriod([Time].[Quarter], [Time].[1997].[Q3])", "[Time].[1997].[Q3]");
        this.assertAxisReturns("ClosingPeriod([Time].[Month], [Time].[1997].[Q3])", "[Time].[1997].[Q3].[9]");
        this.assertAxisReturns("ClosingPeriod([Time].[Quarter], [Time].[1997])", "[Time].[1997].[Q4]");
        this.assertAxisReturns("ClosingPeriod([Time].[Year], [Time].[1997])", year1997);
        this.assertAxisReturns("ClosingPeriod([Time].[Month], [Time].[1997])", "[Time].[1997].[Q4].[12]");
        this.assertAxisReturns("ClosingPeriod([Time].[Year], [Time].[1997].[Q3].[8])", "");
        this.assertAxisReturns("ClosingPeriod([Time].[Quarter], [Time].[1997].[Q3].[8])", "");
        this.assertAxisReturns("ClosingPeriod([Time].[Month], [Time].[1997].[Q3].[8])", "[Time].[1997].[Q3].[8]");
        this.assertAxisReturns("ClosingPeriod([Product].[Product Name], [Product].[All Products].[Drink])", "[Product].[All Products].[Drink].[Dairy].[Dairy].[Milk].[Gorilla].[Gorilla Whole Milk]");
        this.assertAxisReturns("ClosingPeriod([Product].[Product Family], [Product].[All Products].[Drink])", "[Product].[All Products].[Drink]");
        this.assertAxisReturns("ClosingPeriod([Product].[(All)], [Product].[All Products].[Drink])", "");
        this.getTestContext().withCube("[Sales Ragged]").assertAxisReturns("ClosingPeriod([Store].[Store City], [Store].[All Stores].[Israel])", "[Store].[All Stores].[Israel].[Israel].[Tel Aviv]");
        this.assertAxisReturns("ClosingPeriod([Time].[Month])", "[Time].[1997].[Q4].[12]");
        this.assertAxisReturns("ClosingPeriod()", "[Time].[1997].[Q4]");
        TestContext testContext = this.getTestContext().withCube("[Sales Ragged]");
        testContext.assertAxisReturns("ClosingPeriod([Store].[Store State], [Store].[All Stores].[Israel])", "");
        testContext.assertAxisThrows("ClosingPeriod([Time].[Year], [Store].[All Stores].[Israel])", "The <level> and <member> arguments to ClosingPeriod must be from the same hierarchy. The level was from '[Time]' but the member was from '[Store]'.");
    }

    public void testClosingPeriodBelow() {
        Member member = this.executeSingletonAxis("ClosingPeriod([Quarter],[1997].[Q3].[8])");
        Assert.assertNull((Object)member);
    }

    public void testCousin1() {
        Member member = this.executeSingletonAxis("Cousin([1997].[Q4],[1998])");
        Assert.assertEquals((String)"[Time].[1998].[Q4]", (String)member.getUniqueName());
    }

    public void testCousin2() {
        Member member = this.executeSingletonAxis("Cousin([1997].[Q4].[12],[1998].[Q1])");
        Assert.assertEquals((String)"[Time].[1998].[Q1].[3]", (String)member.getUniqueName());
    }

    public void testCousinOverrun() {
        Member member = this.executeSingletonAxis("Cousin([Customers].[USA].[CA].[San Jose], [Customers].[USA].[OR])");
        Assert.assertNull((Object)member);
    }

    public void testCousinThreeDown() {
        Member member = this.executeSingletonAxis("Cousin([Customers].[USA].[CA].[Berkeley].[Barbara Combs], [Customers].[Mexico])");
        Assert.assertEquals((String)"[Customers].[All Customers].[Mexico].[DF].[Tixapan].[Annmarie Hill]", (String)member.getUniqueName());
    }

    public void testCousinSameLevel() {
        Member member = this.executeSingletonAxis("Cousin([Gender].[M], [Gender].[F])");
        Assert.assertEquals((String)"F", (String)member.getName());
    }

    public void testCousinHigherLevel() {
        Member member = this.executeSingletonAxis("Cousin([Time].[1997], [Time].[1998].[Q1])");
        Assert.assertNull((Object)member);
    }

    public void testCousinWrongHierarchy() {
        this.assertAxisThrows("Cousin([Time].[1997], [Gender].[M])", MondrianResource.instance().CousinHierarchyMismatch.str(year1997, "[Gender].[All Gender].[M]"));
    }

    public void testParent() {
        this.getTestContext().assertMemberExprDependsOn("[Gender].Parent", "{[Gender]}");
        this.getTestContext().assertMemberExprDependsOn("[Gender].[M].Parent", "{}");
        this.assertAxisReturns("{[Store].[USA].[CA].Parent}", "[Store].[All Stores].[USA]");
        this.assertAxisReturns("{[Store].[All Stores].Parent}", "");
        this.assertAxisReturns("{[Store].[All Stores].Parent.Parent}", "");
    }

    public void testParentPC() {
        TestContext testContext = this.getTestContext().withCube("HR");
        testContext.assertAxisReturns("[Employees].Parent", "");
        testContext.assertAxisReturns("[Employees].[Sheri Nowmer].Parent", "[Employees].[All Employees]");
        testContext.assertAxisReturns("[Employees].[Sheri Nowmer].[Derrick Whelply].Parent", "[Employees].[All Employees].[Sheri Nowmer]");
        testContext.assertAxisReturns("[Employees].Members.Item(3)", "[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker]");
        testContext.assertAxisReturns("[Employees].Members.Item(3).Parent", "[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply]");
        testContext.assertAxisReturns("[Employees].AllMembers.Item(3).Parent", "[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply]");
        testContext.assertAxisReturns("Ascendants([Employees].Members.Item(73))", FunctionTest.fold("[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Jacqueline Wyllie].[Ralph Mccoy].[Bertha Jameson].[James Bailey]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Jacqueline Wyllie].[Ralph Mccoy].[Bertha Jameson]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Jacqueline Wyllie].[Ralph Mccoy]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Jacqueline Wyllie]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply]\n[Employees].[All Employees].[Sheri Nowmer]\n[Employees].[All Employees]"));
    }

    public void testMembers() {
        this.assertAxisReturns("{[Customers].[Country].Members}", FunctionTest.fold("[Customers].[All Customers].[Canada]\n[Customers].[All Customers].[Mexico]\n[Customers].[All Customers].[USA]"));
        this.assertAxisReturns("{[Customers].[(All)].Members}", "[Customers].[All Customers]");
        this.assertAxisReturns("{[Measures].[MeasuresLevel].Members}", FunctionTest.fold("[Measures].[Unit Sales]\n[Measures].[Store Cost]\n[Measures].[Store Sales]\n[Measures].[Sales Count]\n[Measures].[Customer Count]\n[Measures].[Promotion Sales]"));
        this.assertAxisReturns("{[Measures].Members}", FunctionTest.fold("[Measures].[Unit Sales]\n[Measures].[Store Cost]\n[Measures].[Store Sales]\n[Measures].[Sales Count]\n[Measures].[Customer Count]\n[Measures].[Promotion Sales]"));
        switch (TestContext.instance().getDialect().getDatabaseProduct()) {
            case INFOBRIGHT: {
                break;
            }
            default: {
                this.assertQueryReturns("with member [Measures].[Xxx] AS ' [Measures].[Unit Sales] 'select {[Measures].members} on columns from [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\n{[Measures].[Sales Count]}\n{[Measures].[Customer Count]}\n{[Measures].[Promotion Sales]}\nRow #0: 266,773\nRow #0: 225,627.23\nRow #0: 565,238.13\nRow #0: 86,837\nRow #0: 5,581\nRow #0: 151,211.21\n"));
            }
        }
        switch (TestContext.instance().getDialect().getDatabaseProduct()) {
            case INFOBRIGHT: {
                break;
            }
            default: {
                this.assertQueryReturns("with member [Measures].[Xxx] AS ' [Measures].[Unit Sales] 'select {[Measures].[Measures].members} on columns from [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\n{[Measures].[Sales Count]}\n{[Measures].[Customer Count]}\n{[Measures].[Promotion Sales]}\nRow #0: 266,773\nRow #0: 225,627.23\nRow #0: 565,238.13\nRow #0: 86,837\nRow #0: 5,581\nRow #0: 151,211.21\n"));
            }
        }
    }

    public void testHierarchyMembers() {
        this.assertAxisReturns("Head({[Time.Weekly].Members}, 10)", FunctionTest.fold("[Time].[Weekly].[All Weeklys]\n[Time].[Weekly].[All Weeklys].[1997]\n[Time].[Weekly].[All Weeklys].[1997].[1]\n[Time].[Weekly].[All Weeklys].[1997].[1].[15]\n[Time].[Weekly].[All Weeklys].[1997].[1].[16]\n[Time].[Weekly].[All Weeklys].[1997].[1].[17]\n[Time].[Weekly].[All Weeklys].[1997].[1].[18]\n[Time].[Weekly].[All Weeklys].[1997].[1].[19]\n[Time].[Weekly].[All Weeklys].[1997].[1].[20]\n[Time].[Weekly].[All Weeklys].[1997].[2]"));
        this.assertAxisReturns("Tail({[Time.Weekly].Members}, 5)", FunctionTest.fold("[Time].[Weekly].[All Weeklys].[1998].[51].[5]\n[Time].[Weekly].[All Weeklys].[1998].[51].[29]\n[Time].[Weekly].[All Weeklys].[1998].[51].[30]\n[Time].[Weekly].[All Weeklys].[1998].[52]\n[Time].[Weekly].[All Weeklys].[1998].[52].[6]"));
    }

    public void testAllMembers() {
        this.assertAxisReturns("{[Customers].[Country].allmembers}", FunctionTest.fold("[Customers].[All Customers].[Canada]\n[Customers].[All Customers].[Mexico]\n[Customers].[All Customers].[USA]"));
        this.assertAxisReturns("{[Customers].[(All)].allmembers}", "[Customers].[All Customers]");
        this.assertAxisReturns("{[Measures].[MeasuresLevel].allmembers}", FunctionTest.fold("[Measures].[Unit Sales]\n[Measures].[Store Cost]\n[Measures].[Store Sales]\n[Measures].[Sales Count]\n[Measures].[Customer Count]\n[Measures].[Promotion Sales]\n[Measures].[Profit]\n[Measures].[Profit Growth]\n[Measures].[Profit last Period]"));
        this.assertAxisReturns("{[Measures].allmembers}", FunctionTest.fold("[Measures].[Unit Sales]\n[Measures].[Store Cost]\n[Measures].[Store Sales]\n[Measures].[Sales Count]\n[Measures].[Customer Count]\n[Measures].[Promotion Sales]\n[Measures].[Profit]\n[Measures].[Profit Growth]\n[Measures].[Profit last Period]"));
        switch (TestContext.instance().getDialect().getDatabaseProduct()) {
            case INFOBRIGHT: {
                break;
            }
            default: {
                this.assertQueryReturns("with member [Measures].[Xxx] AS ' [Measures].[Unit Sales] 'select {[Measures].allmembers} on columns from [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\n{[Measures].[Sales Count]}\n{[Measures].[Customer Count]}\n{[Measures].[Promotion Sales]}\n{[Measures].[Profit]}\n{[Measures].[Profit Growth]}\n{[Measures].[Profit last Period]}\n{[Measures].[Xxx]}\nRow #0: 266,773\nRow #0: 225,627.23\nRow #0: 565,238.13\nRow #0: 86,837\nRow #0: 5,581\nRow #0: 151,211.21\nRow #0: $339,610.90\nRow #0: 0.0%\nRow #0: $339,610.90\nRow #0: 266,773\n"));
            }
        }
        switch (TestContext.instance().getDialect().getDatabaseProduct()) {
            case INFOBRIGHT: {
                break;
            }
            default: {
                this.assertQueryReturns("WITH MEMBER [Measures].[Unit to Sales ratio] as\n '[Measures].[Unit Sales] / [Measures].[Store Sales]', FORMAT_STRING='0.0%' SELECT {[Measures].AllMembers} ON COLUMNS,non empty({[Store].[Store State].Members}) ON ROWS FROM Sales WHERE ([1997].[Q1])", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q1]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\n{[Measures].[Sales Count]}\n{[Measures].[Customer Count]}\n{[Measures].[Promotion Sales]}\n{[Measures].[Profit]}\n{[Measures].[Profit Growth]}\n{[Measures].[Profit last Period]}\n{[Measures].[Unit to Sales ratio]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nRow #0: 16,890\nRow #0: 14,431.09\nRow #0: 36,175.20\nRow #0: 5,498\nRow #0: 1,110\nRow #0: 14,447.16\nRow #0: $21,744.11\nRow #0: 0.0%\nRow #0: $21,744.11\nRow #0: 46.7%\nRow #1: 19,287\nRow #1: 16,081.07\nRow #1: 40,170.29\nRow #1: 6,184\nRow #1: 767\nRow #1: 10,829.64\nRow #1: $24,089.22\nRow #1: 0.0%\nRow #1: $24,089.22\nRow #1: 48.0%\nRow #2: 30,114\nRow #2: 25,240.08\nRow #2: 63,282.86\nRow #2: 9,906\nRow #2: 1,104\nRow #2: 18,459.60\nRow #2: $38,042.78\nRow #2: 0.0%\nRow #2: $38,042.78\nRow #2: 47.6%\n"));
            }
        }
        switch (TestContext.instance().getDialect().getDatabaseProduct()) {
            case INFOBRIGHT: {
                break;
            }
            default: {
                this.assertQueryReturns("WITH MEMBER [Measures].[Unit to Sales ratio] as '[Measures].[Unit Sales] / [Measures].[Store Sales]', FORMAT_STRING='0.0%' SELECT {[Measures].AllMembers} ON COLUMNS,non empty({[Store].[Store State].Members}) ON ROWS FROM Sales WHERE ([1997].[Q1])", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q1]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\n{[Measures].[Sales Count]}\n{[Measures].[Customer Count]}\n{[Measures].[Promotion Sales]}\n{[Measures].[Profit]}\n{[Measures].[Profit Growth]}\n{[Measures].[Profit last Period]}\n{[Measures].[Unit to Sales ratio]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nRow #0: 16,890\nRow #0: 14,431.09\nRow #0: 36,175.20\nRow #0: 5,498\nRow #0: 1,110\nRow #0: 14,447.16\nRow #0: $21,744.11\nRow #0: 0.0%\nRow #0: $21,744.11\nRow #0: 46.7%\nRow #1: 19,287\nRow #1: 16,081.07\nRow #1: 40,170.29\nRow #1: 6,184\nRow #1: 767\nRow #1: 10,829.64\nRow #1: $24,089.22\nRow #1: 0.0%\nRow #1: $24,089.22\nRow #1: 48.0%\nRow #2: 30,114\nRow #2: 25,240.08\nRow #2: 63,282.86\nRow #2: 9,906\nRow #2: 1,104\nRow #2: 18,459.60\nRow #2: $38,042.78\nRow #2: 0.0%\nRow #2: $38,042.78\nRow #2: 47.6%\n"));
            }
        }
        switch (TestContext.instance().getDialect().getDatabaseProduct()) {
            case INFOBRIGHT: {
                break;
            }
            default: {
                this.assertQueryReturns("WITH MEMBER [Measures].[Unit to Sales ratio] as '[Measures].[Unit Sales] / [Measures].[Store Sales]', FORMAT_STRING='0.0%' SELECT {[Measures].Members} ON COLUMNS,non empty({[Store].[Store State].Members}) ON ROWS FROM Sales WHERE ([1997].[Q1])", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q1]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\n{[Measures].[Sales Count]}\n{[Measures].[Customer Count]}\n{[Measures].[Promotion Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nRow #0: 16,890\nRow #0: 14,431.09\nRow #0: 36,175.20\nRow #0: 5,498\nRow #0: 1,110\nRow #0: 14,447.16\nRow #1: 19,287\nRow #1: 16,081.07\nRow #1: 40,170.29\nRow #1: 6,184\nRow #1: 767\nRow #1: 10,829.64\nRow #2: 30,114\nRow #2: 25,240.08\nRow #2: 63,282.86\nRow #2: 9,906\nRow #2: 1,104\nRow #2: 18,459.60\n"));
            }
        }
        this.assertQueryReturns("WITH MEMBER [Store].[USA].[CA plus OR] AS 'AGGREGATE({[Store].[USA].[CA], [Store].[USA].[OR]})' SELECT {[Measures].[Unit Sales], [Measures].[Store Sales]} ON COLUMNS,non empty({[Store].[Store State].AllMembers}) ON ROWS FROM Sales WHERE ([1997].[Q1])", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q1]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\n{[Store].[All Stores].[USA].[CA plus OR]}\nRow #0: 16,890\nRow #0: 36,175.20\nRow #1: 19,287\nRow #1: 40,170.29\nRow #2: 30,114\nRow #2: 63,282.86\nRow #3: 36,177\nRow #3: 76,345.49\n"));
        this.assertQueryReturns("WITH MEMBER [Store].[USA].[CA plus OR] AS 'AGGREGATE({[Store].[USA].[CA], [Store].[USA].[OR]})' SELECT {[Measures].[Unit Sales], [Measures].[Store Sales]} ON COLUMNS,non empty({[Store].[Store Country].AllMembers}) ON ROWS FROM Sales WHERE ([1997].[Q1])", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q1]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Store].[All Stores].[USA]}\nRow #0: 66,291\nRow #0: 139,628.35\n"));
    }

    public void testAddCalculatedMembers() {
        this.assertQueryReturns("WITH MEMBER [Store].[USA].[CA plus OR] AS 'AGGREGATE({[Store].[USA].[CA], [Store].[USA].[OR]})' SELECT {[Measures].[Unit Sales], [Measures].[Store Sales]} ON COLUMNS,AddCalculatedMembers([Store].[USA].Children) ON ROWS FROM Sales WHERE ([1997].[Q1])", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q1]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\n{[Store].[All Stores].[USA].[CA plus OR]}\nRow #0: 16,890\nRow #0: 36,175.20\nRow #1: 19,287\nRow #1: 40,170.29\nRow #2: 30,114\nRow #2: 63,282.86\nRow #3: 36,177\nRow #3: 76,345.49\n"));
        this.assertQueryReturns("WITH MEMBER [Store].[USA].[CA plus OR] AS 'AGGREGATE({[Store].[USA].[CA], [Store].[USA].[OR]})' SELECT AddCalculatedMembers({[Measures].[Unit Sales], [Measures].[Store Sales]}) ON COLUMNS,AddCalculatedMembers([Store].[USA].Children) ON ROWS FROM Sales WHERE ([1997].[Q1])", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q1]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Sales]}\n{[Measures].[Profit]}\n{[Measures].[Profit last Period]}\n{[Measures].[Profit Growth]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\n{[Store].[All Stores].[USA].[CA plus OR]}\nRow #0: 16,890\nRow #0: 36,175.20\nRow #0: $21,744.11\nRow #0: $21,744.11\nRow #0: 0.0%\nRow #1: 19,287\nRow #1: 40,170.29\nRow #1: $24,089.22\nRow #1: $24,089.22\nRow #1: 0.0%\nRow #2: 30,114\nRow #2: 63,282.86\nRow #2: $38,042.78\nRow #2: $38,042.78\nRow #2: 0.0%\nRow #3: 36,177\nRow #3: 76,345.49\nRow #3: $45,833.33\nRow #3: $45,833.33\nRow #3: 0.0%\n"));
        this.assertQueryReturns("SELECT AddCalculatedMembers({[Measures].[Unit Sales], [Measures].[Store Sales]}) ON COLUMNS,{([Store].[USA].[CA], [Gender].[F])} ON ROWS FROM Sales WHERE ([1997].[Q1])", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q1]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Sales]}\n{[Measures].[Profit]}\n{[Measures].[Profit last Period]}\n{[Measures].[Profit Growth]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA], [Gender].[All Gender].[F]}\nRow #0: 8,218\nRow #0: 17,928.37\nRow #0: $10,771.98\nRow #0: $10,771.98\nRow #0: 0.0%\n"));
        this.assertAxisThrows("AddCalculatedMembers({([Store].[USA].[CA], [Gender].[F])})", "Only single dimension members allowed in set for AddCalculatedMembers");
    }

    public void testStripCalculatedMembers() {
        this.assertAxisReturns("StripCalculatedMembers({[Measures].AllMembers})", FunctionTest.fold("[Measures].[Unit Sales]\n[Measures].[Store Cost]\n[Measures].[Store Sales]\n[Measures].[Sales Count]\n[Measures].[Customer Count]\n[Measures].[Promotion Sales]"));
        this.assertAxisReturns("StripCalculatedMembers({[Gender].Parent})", "");
        this.getTestContext().assertSetExprDependsOn("StripCalculatedMembers([Customers].CurrentMember.Children)", "{[Customers]}");
        this.assertQueryReturns("WITH MEMBER [Store].[USA].[CA plus OR] AS 'AGGREGATE({[Store].[USA].[CA], [Store].[USA].[OR]})' SELECT StripCalculatedMembers({[Measures].[Unit Sales], [Measures].[Store Sales]}) ON COLUMNS,StripCalculatedMembers(AddCalculatedMembers([Store].[USA].Children)) ON ROWS FROM Sales WHERE ([1997].[Q1])", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q1]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nRow #0: 16,890\nRow #0: 36,175.20\nRow #1: 19,287\nRow #1: 40,170.29\nRow #2: 30,114\nRow #2: 63,282.86\n"));
    }

    public void testCurrentMember() {
        this.assertAxisReturns("[Gender].CurrentMember", "[Gender].[All Gender]");
        this.assertAxisReturns("[Gender].Hierarchy.CurrentMember", "[Gender].[All Gender]");
        this.assertAxisReturns("[Store Name].CurrentMember", "[Store].[All Stores]");
    }

    public void testCurrentMemberDepends() {
        this.getTestContext().assertMemberExprDependsOn("[Gender].CurrentMember", "{[Gender]}");
        this.getTestContext().assertExprDependsOn("[Gender].[M].Dimension.Name", "{}");
        this.getTestContext().assertMemberExprDependsOn("[Gender].[M].Dimension", "{[Gender]}");
        this.getTestContext().assertMemberExprDependsOn("[Gender].[M].Dimension.CurrentMember", "{[Gender]}");
        this.getTestContext().assertMemberExprDependsOn("[Gender].[M].Dimension.CurrentMember.Parent", "{[Gender]}");
        this.getTestContext().assertExprDependsOn("[Customers]", TestContext.allDims());
    }

    public void testCurrentMemberFromSlicer() {
        Result result = this.executeQuery("with member [Measures].[Foo] as '[Gender].CurrentMember.Name'\nselect {[Measures].[Foo]} on columns\nfrom Sales where ([Gender].[F])");
        Assert.assertEquals((Object)"F", (Object)result.getCell(new int[]{0}).getValue());
    }

    public void testCurrentMemberFromDefaultMember() {
        Result result = this.executeQuery("with member [Measures].[Foo] as '[Time].CurrentMember.Name'\nselect {[Measures].[Foo]} on columns\nfrom Sales");
        Assert.assertEquals((Object)"1997", (Object)result.getCell(new int[]{0}).getValue());
    }

    public void testCurrentMemberMultiHierarchy() {
        String hierarchyName = MondrianProperties.instance().SsasCompatibleNaming.get() ? "Weekly" : "Time.Weekly";
        String queryString = "with member [Measures].[Foo] as\n 'IIf(([Time].CurrentMember.Hierarchy.Name = \"" + hierarchyName + "\"), \n" + "[Measures].[Unit Sales], \n" + "- [Measures].[Unit Sales])'\n" + "select {[Measures].[Unit Sales], [Measures].[Foo]} ON COLUMNS,\n" + "  {[Product].[Food].[Dairy]} ON ROWS\n" + "from [Sales]";
        Result result = this.executeQuery(queryString + " where [Time].[1997]");
        int[] coords = new int[]{1, 0};
        Assert.assertEquals((String)"-12,885", (String)result.getCell(coords).getFormattedValue());
        String queryString1 = "with member [Measures].[Foo] as\n 'IIf(([Time].CurrentMember.Hierarchy.Name = \"" + hierarchyName + "\"), \n" + "[Measures].[Unit Sales], \n" + "- [Measures].[Unit Sales])'\n" + "select {[Measures].[Unit Sales], [Measures].[Foo]} ON COLUMNS,";
        String queryString2 = "from [Sales]\n  where [Product].[Food].[Dairy] ";
        result = this.executeQuery(queryString1 + " {[Time].[1997]} ON ROWS " + "from [Sales]\n  where [Product].[Food].[Dairy] ");
        Assert.assertEquals((String)"-12,885", (String)result.getCell(coords).getFormattedValue());
        String expectedCellValue = MondrianProperties.instance().SsasCompatibleNaming.get() ? "-12,885" : "12,885";
        result = this.executeQuery(queryString + " where [Time.Weekly].[1997]");
        Assert.assertEquals((String)expectedCellValue, (String)result.getCell(coords).getFormattedValue());
        result = this.executeQuery(queryString1 + " {[Time.Weekly].[1997]} ON ROWS " + "from [Sales]\n  where [Product].[Food].[Dairy] ");
        Assert.assertEquals((String)expectedCellValue, (String)result.getCell(coords).getFormattedValue());
    }

    public void testDefaultMember() {
        Result result = this.executeQuery("select {[Time].DefaultMember} on columns\nfrom Sales");
        Assert.assertEquals((String)"1997", (String)((Member)result.getAxes()[0].getPositions().get(0).get(0)).getName());
        result = this.executeQuery("select {[Time.Weekly].DefaultMember} on columns\nfrom Sales");
        Assert.assertEquals((String)(MondrianProperties.instance().SsasCompatibleNaming.get() ? "All Weeklys" : "All Time.Weeklys"), (String)((Member)result.getAxes()[0].getPositions().get(0).get(0)).getName());
        String memberUname = MondrianProperties.instance().SsasCompatibleNaming.get() ? "[Time2].[Weekly].[1997].[23]" : "[Time2.Weekly].[1997].[23]";
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "  <Dimension name=\"Time2\" type=\"TimeDimension\" foreignKey=\"time_id\">\n    <Hierarchy hasAll=\"false\" primaryKey=\"time_id\">\n      <Table name=\"time_by_day\"/>\n      <Level name=\"Year\" column=\"the_year\" type=\"Numeric\" uniqueMembers=\"true\"\n          levelType=\"TimeYears\"/>\n      <Level name=\"Quarter\" column=\"quarter\" uniqueMembers=\"false\"\n          levelType=\"TimeQuarters\"/>\n      <Level name=\"Month\" column=\"month_of_year\" uniqueMembers=\"false\" type=\"Numeric\"\n          levelType=\"TimeMonths\"/>\n    </Hierarchy>\n    <Hierarchy hasAll=\"true\" name=\"Weekly\" primaryKey=\"time_id\"\n          defaultMember=\"" + memberUname + "\">\n" + "      <Table name=\"time_by_day\"/>\n" + "      <Level name=\"Year\" column=\"the_year\" type=\"Numeric\" uniqueMembers=\"true\"\n" + "          levelType=\"TimeYears\"/>\n" + "      <Level name=\"Week\" column=\"week_of_year\" type=\"Numeric\" uniqueMembers=\"false\"\n" + "          levelType=\"TimeWeeks\"/>\n" + "      <Level name=\"Day\" column=\"day_of_month\" uniqueMembers=\"false\" type=\"Numeric\"\n" + "          levelType=\"TimeDays\"/>\n" + "    </Hierarchy>\n" + "  </Dimension>");
        result = testContext.executeQuery("select {[Time2.Weekly].DefaultMember} on columns\nfrom Sales");
        Assert.assertEquals((String)"23", (String)((Member)result.getAxes()[0].getPositions().get(0).get(0)).getName());
    }

    public void testCurrentMemberFromAxis() {
        Result result = this.executeQuery("with member [Measures].[Foo] as '[Gender].CurrentMember.Name || [Marital Status].CurrentMember.Name'\nselect {[Measures].[Foo]} on columns,\n CrossJoin({[Gender].children}, {[Marital Status].children}) on rows\nfrom Sales");
        Assert.assertEquals((Object)"FM", (Object)result.getCell(new int[]{0, 0}).getValue());
    }

    public void testCurrentMemberInCalcMember() {
        Result result = this.executeQuery("with member [Measures].[Foo] as '[Measures].CurrentMember.Name'\nselect {[Measures].[Foo]} on columns\nfrom Sales");
        Assert.assertEquals((Object)"Unit Sales", (Object)result.getCell(new int[]{0}).getValue());
    }

    public void testNamedSetCurrentOrdinalWithOrder() {
        if (Util.Retrowoven) {
            return;
        }
        this.assertQueryReturns("with set [Time Regular] as [Time].Members\n set [Time Reversed] as Order([Time Regular], [Time Regular].CurrentOrdinal, BDESC)\nselect [Time Reversed] on 0\nfrom [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1998].[Q4].[12]}\n{[Time].[1998].[Q4].[11]}\n{[Time].[1998].[Q4].[10]}\n{[Time].[1998].[Q4]}\n{[Time].[1998].[Q3].[9]}\n{[Time].[1998].[Q3].[8]}\n{[Time].[1998].[Q3].[7]}\n{[Time].[1998].[Q3]}\n{[Time].[1998].[Q2].[6]}\n{[Time].[1998].[Q2].[5]}\n{[Time].[1998].[Q2].[4]}\n{[Time].[1998].[Q2]}\n{[Time].[1998].[Q1].[3]}\n{[Time].[1998].[Q1].[2]}\n{[Time].[1998].[Q1].[1]}\n{[Time].[1998].[Q1]}\n{[Time].[1998]}\n{[Time].[1997].[Q4].[12]}\n{[Time].[1997].[Q4].[11]}\n{[Time].[1997].[Q4].[10]}\n{[Time].[1997].[Q4]}\n{[Time].[1997].[Q3].[9]}\n{[Time].[1997].[Q3].[8]}\n{[Time].[1997].[Q3].[7]}\n{[Time].[1997].[Q3]}\n{[Time].[1997].[Q2].[6]}\n{[Time].[1997].[Q2].[5]}\n{[Time].[1997].[Q2].[4]}\n{[Time].[1997].[Q2]}\n{[Time].[1997].[Q1].[3]}\n{[Time].[1997].[Q1].[2]}\n{[Time].[1997].[Q1].[1]}\n{[Time].[1997].[Q1]}\n{[Time].[1997]}\nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: 26,796\nRow #0: 25,270\nRow #0: 19,958\nRow #0: 72,024\nRow #0: 20,388\nRow #0: 21,697\nRow #0: 23,763\nRow #0: 65,848\nRow #0: 21,350\nRow #0: 21,081\nRow #0: 20,179\nRow #0: 62,610\nRow #0: 23,706\nRow #0: 20,957\nRow #0: 21,628\nRow #0: 66,291\nRow #0: 266,773\n"));
    }

    public void testNamedSetCurrentOrdinalWithGenerate() {
        if (Util.Retrowoven) {
            return;
        }
        this.assertQueryReturns(" with set [Time Regular] as [Time].Members\nset [Every Other Time] as\n  Generate(\n    [Time Regular],\n    {[Time].Members.Item(\n      [Time Regular].CurrentOrdinal * 2)})\nselect [Every Other Time] on 0\nfrom [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997]}\n{[Time].[1997].[Q1].[1]}\n{[Time].[1997].[Q1].[3]}\n{[Time].[1997].[Q2].[4]}\n{[Time].[1997].[Q2].[6]}\n{[Time].[1997].[Q3].[7]}\n{[Time].[1997].[Q3].[9]}\n{[Time].[1997].[Q4].[10]}\n{[Time].[1997].[Q4].[12]}\n{[Time].[1998].[Q1]}\n{[Time].[1998].[Q1].[2]}\n{[Time].[1998].[Q2]}\n{[Time].[1998].[Q2].[5]}\n{[Time].[1998].[Q3]}\n{[Time].[1998].[Q3].[8]}\n{[Time].[1998].[Q4]}\n{[Time].[1998].[Q4].[11]}\nRow #0: 266,773\nRow #0: 21,628\nRow #0: 23,706\nRow #0: 20,179\nRow #0: 21,350\nRow #0: 23,763\nRow #0: 20,388\nRow #0: 19,958\nRow #0: 26,796\nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \n"));
    }

    public void testNamedSetCurrentOrdinalWithFilter() {
        if (Util.Retrowoven) {
            return;
        }
        this.assertQueryReturns("with set [Time Regular] as [Time].Members\n set [Time Subset] as Filter([Time Regular], [Time Regular].CurrentOrdinal = 3 or [Time Regular].CurrentOrdinal = 5)\nselect [Time Subset] on 0\nfrom [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997].[Q1].[2]}\n{[Time].[1997].[Q2]}\nRow #0: 20,957\nRow #0: 62,610\n"));
    }

    public void testNamedSetCurrentOrdinalWithCrossjoin() {
    }

    public void testNamedSetCurrentOrdinalWithNonNamedSetFails() {
        this.assertThrows("with set [Time Members] as [Time].Members\nmember [Measures].[Foo] as ' {[Time Members]}.CurrentOrdinal '\nselect {[Measures].[Unit Sales], [Measures].[Foo]} on 0,\n {[Product].Children} on 1\nfrom [Sales]", "Not a named set");
        this.assertThrows("with set [Time Members] as [Time].Members\nmember [Measures].[Foo] as ' {[Time Members]}.Current.Name '\nselect {[Measures].[Unit Sales], [Measures].[Foo]} on 0,\n {[Product].Children} on 1\nfrom [Sales]", "Not a named set");
        this.assertThrows("with member [Measures].[Foo] as\n ' Head([Time].Members, 5).CurrentOrdinal '\nselect {[Measures].[Unit Sales], [Measures].[Foo]} on 0,\n {[Product].Children} on 1\nfrom [Sales]", "Not a named set");
        this.assertThrows("with member [Measures].[Foo] as\n ' Crossjoin([Time].Members, [Gender].Members).Current.Name '\nselect {[Measures].[Unit Sales], [Measures].[Foo]} on 0,\n {[Product].Children} on 1\nfrom [Sales]", "Not a named set");
    }

    public void testDimensionDefaultMember() {
        Member member = this.executeSingletonAxis("[Measures].DefaultMember");
        Assert.assertEquals((String)"Unit Sales", (String)member.getName());
    }

    public void testDrilldownLevel() {
        this.assertAxisReturns("DrilldownLevel({[Store].[USA]}, [Store].[Store Country])", FunctionTest.fold("[Store].[All Stores].[USA]\n[Store].[All Stores].[USA].[CA]\n[Store].[All Stores].[USA].[OR]\n[Store].[All Stores].[USA].[WA]"));
        this.assertAxisReturns("DrilldownLevel({[Store].[USA], [Store].[USA].[CA]}, [Store].[Store Country])", FunctionTest.fold("[Store].[All Stores].[USA]\n[Store].[All Stores].[USA].[CA]"));
        this.assertAxisReturns("DrilldownLevel({[Store].[USA].[CA],[Store].[USA]}, [Store].[Store Country])", FunctionTest.fold("[Store].[All Stores].[USA].[CA]\n[Store].[All Stores].[USA]\n[Store].[All Stores].[USA].[CA]\n[Store].[All Stores].[USA].[OR]\n[Store].[All Stores].[USA].[WA]"));
        this.assertAxisReturns("DrilldownLevel({[Store].[USA].[CA],[Store].[USA]},, 0)", FunctionTest.fold("[Store].[All Stores].[USA].[CA]\n[Store].[All Stores].[USA].[CA].[Alameda]\n[Store].[All Stores].[USA].[CA].[Beverly Hills]\n[Store].[All Stores].[USA].[CA].[Los Angeles]\n[Store].[All Stores].[USA].[CA].[San Diego]\n[Store].[All Stores].[USA].[CA].[San Francisco]\n[Store].[All Stores].[USA]\n[Store].[All Stores].[USA].[CA]\n[Store].[All Stores].[USA].[OR]\n[Store].[All Stores].[USA].[WA]"));
        this.assertAxisReturns("DrilldownLevel({[Store].[USA].[CA],[Store].[USA]} * {[Gender].Members},, 0)", FunctionTest.fold("{[Store].[All Stores].[USA].[CA], [Gender].[All Gender]}\n{[Store].[All Stores].[USA].[CA].[Alameda], [Gender].[All Gender]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills], [Gender].[All Gender]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles], [Gender].[All Gender]}\n{[Store].[All Stores].[USA].[CA].[San Diego], [Gender].[All Gender]}\n{[Store].[All Stores].[USA].[CA].[San Francisco], [Gender].[All Gender]}\n{[Store].[All Stores].[USA].[CA], [Gender].[All Gender].[F]}\n{[Store].[All Stores].[USA].[CA].[Alameda], [Gender].[All Gender].[F]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills], [Gender].[All Gender].[F]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles], [Gender].[All Gender].[F]}\n{[Store].[All Stores].[USA].[CA].[San Diego], [Gender].[All Gender].[F]}\n{[Store].[All Stores].[USA].[CA].[San Francisco], [Gender].[All Gender].[F]}\n{[Store].[All Stores].[USA].[CA], [Gender].[All Gender].[M]}\n{[Store].[All Stores].[USA].[CA].[Alameda], [Gender].[All Gender].[M]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills], [Gender].[All Gender].[M]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles], [Gender].[All Gender].[M]}\n{[Store].[All Stores].[USA].[CA].[San Diego], [Gender].[All Gender].[M]}\n{[Store].[All Stores].[USA].[CA].[San Francisco], [Gender].[All Gender].[M]}\n{[Store].[All Stores].[USA], [Gender].[All Gender]}\n{[Store].[All Stores].[USA].[CA], [Gender].[All Gender]}\n{[Store].[All Stores].[USA].[OR], [Gender].[All Gender]}\n{[Store].[All Stores].[USA].[WA], [Gender].[All Gender]}\n{[Store].[All Stores].[USA], [Gender].[All Gender].[F]}\n{[Store].[All Stores].[USA].[CA], [Gender].[All Gender].[F]}\n{[Store].[All Stores].[USA].[OR], [Gender].[All Gender].[F]}\n{[Store].[All Stores].[USA].[WA], [Gender].[All Gender].[F]}\n{[Store].[All Stores].[USA], [Gender].[All Gender].[M]}\n{[Store].[All Stores].[USA].[CA], [Gender].[All Gender].[M]}\n{[Store].[All Stores].[USA].[OR], [Gender].[All Gender].[M]}\n{[Store].[All Stores].[USA].[WA], [Gender].[All Gender].[M]}"));
        this.assertAxisReturns("DrilldownLevel({[Store].[USA].[CA],[Store].[USA]} * {[Gender].Members},, 1)", FunctionTest.fold("{[Store].[All Stores].[USA].[CA], [Gender].[All Gender]}\n{[Store].[All Stores].[USA].[CA], [Gender].[All Gender].[F]}\n{[Store].[All Stores].[USA].[CA], [Gender].[All Gender].[M]}\n{[Store].[All Stores].[USA].[CA], [Gender].[All Gender].[F]}\n{[Store].[All Stores].[USA].[CA], [Gender].[All Gender].[M]}\n{[Store].[All Stores].[USA], [Gender].[All Gender]}\n{[Store].[All Stores].[USA], [Gender].[All Gender].[F]}\n{[Store].[All Stores].[USA], [Gender].[All Gender].[M]}\n{[Store].[All Stores].[USA], [Gender].[All Gender].[F]}\n{[Store].[All Stores].[USA], [Gender].[All Gender].[M]}"));
    }

    public void testDrilldownLevelTop() {
        this.assertAxisReturns("DrilldownLevelTop({[Store].[USA]}, 2, [Store].[Store Country])", FunctionTest.fold("[Store].[All Stores].[USA]\n[Store].[All Stores].[USA].[WA]\n[Store].[All Stores].[USA].[CA]"));
        this.assertAxisReturns("DrilldownLevelBottom({[Store].[USA]}, 2, [Store].[Store Country])", FunctionTest.fold("[Store].[All Stores].[USA]\n[Store].[All Stores].[USA].[OR]\n[Store].[All Stores].[USA].[CA]"));
        this.assertAxisReturns("DrilldownLevelTop({[Store].[USA]}, 2)", FunctionTest.fold("[Store].[All Stores].[USA]\n[Store].[All Stores].[USA].[WA]\n[Store].[All Stores].[USA].[CA]"));
        this.assertAxisReturns("DrilldownLevelTop({[Store].[USA], [Store].[Canada]}, 4)", FunctionTest.fold("[Store].[All Stores].[USA]\n[Store].[All Stores].[USA].[WA]\n[Store].[All Stores].[USA].[CA]\n[Store].[All Stores].[USA].[OR]\n[Store].[All Stores].[Canada]\n[Store].[All Stores].[Canada].[BC]"));
        this.assertAxisReturns("DrilldownLevelTop({[Store].[USA]}, 2 - 3)", FunctionTest.fold("[Store].[All Stores].[USA]"));
        this.assertAxisReturns("DrilldownLevelTop({[Store].[USA]}, 2 - 2)", FunctionTest.fold("[Store].[All Stores].[USA]"));
        this.assertAxisReturns("DrilldownLevelTop({[Store].[USA]}, null)", FunctionTest.fold("[Store].[All Stores].[USA]"));
        this.assertAxisReturns("DrilldownLevelTop({[Store].[USA], [Store].[USA].[CA].[San Francisco], [Store].[All Stores], [Store].[Canada].[BC]}, 2)", FunctionTest.fold("[Store].[All Stores].[USA]\n[Store].[All Stores].[USA].[WA]\n[Store].[All Stores].[USA].[CA]\n[Store].[All Stores].[USA].[CA].[San Francisco]\n[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]\n[Store].[All Stores]\n[Store].[All Stores].[USA]\n[Store].[All Stores].[Canada]\n[Store].[All Stores].[Canada].[BC]\n[Store].[All Stores].[Canada].[BC].[Vancouver]\n[Store].[All Stores].[Canada].[BC].[Victoria]"));
        this.assertAxisReturns("DrilldownLevelTop({[Store].[USA], [Store].[USA].[CA].[San Francisco], [Store].[All Stores], [Store].[Canada].[BC]}, 2, [Store].[Store City])", FunctionTest.fold("[Store].[All Stores].[USA]\n[Store].[All Stores].[USA].[CA].[San Francisco]\n[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]\n[Store].[All Stores]\n[Store].[All Stores].[Canada].[BC]"));
        this.assertAxisThrows("DrilldownLevelTop({[Store].[USA]}, 2, [Customers].[Country])", "Level '[Customers].[Country]' not compatible with member '[Store].[All Stores].[USA]'");
    }

    public void testDrilldownMemberEmptyExpr() {
        this.assertAxisReturns("DrilldownLevelTop({[Store].[USA]}, 2, , [Measures].[Unit Sales])", FunctionTest.fold("[Store].[All Stores].[USA]\n[Store].[All Stores].[USA].[WA]\n[Store].[All Stores].[USA].[CA]"));
        this.assertAxisReturns("DrilldownLevelTop({[Store].[USA]}, 2, , - [Measures].[Unit Sales])", FunctionTest.fold("[Store].[All Stores].[USA]\n[Store].[All Stores].[USA].[OR]\n[Store].[All Stores].[USA].[CA]"));
    }

    public void testDrilldownMember() {
        this.assertAxisReturns("DrilldownMember({[Store].[USA]}, {[Store].[USA]})", FunctionTest.fold("[Store].[All Stores].[USA]\n[Store].[All Stores].[USA].[CA]\n[Store].[All Stores].[USA].[OR]\n[Store].[All Stores].[USA].[WA]"));
        this.assertAxisReturns("DrilldownMember({[Store].[USA].[CA], [Store].[USA].[OR]}, {[Store].[USA].[CA], [Store].[USA].[OR], [Store].[USA].[WA]})", FunctionTest.fold("[Store].[All Stores].[USA].[CA]\n[Store].[All Stores].[USA].[CA].[Alameda]\n[Store].[All Stores].[USA].[CA].[Beverly Hills]\n[Store].[All Stores].[USA].[CA].[Los Angeles]\n[Store].[All Stores].[USA].[CA].[San Diego]\n[Store].[All Stores].[USA].[CA].[San Francisco]\n[Store].[All Stores].[USA].[OR]\n[Store].[All Stores].[USA].[OR].[Portland]\n[Store].[All Stores].[USA].[OR].[Salem]"));
        this.assertAxisReturns("DrilldownMember({[Store].[USA]}, {})", "[Store].[All Stores].[USA]");
        this.assertAxisReturns("DrilldownMember({[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]}, {[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]})", "[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]");
        this.assertAxisReturns("DrilldownMember({[Store].[All Stores].[USA]}, {[Store].[All Stores].[USA], [Store].[All Stores].[USA].[CA], [Store].[All Stores].[USA].[CA].[San Diego], [Store].[All Stores].[USA].[WA]}, RECURSIVE)", FunctionTest.fold("[Store].[All Stores].[USA]\n[Store].[All Stores].[USA].[CA]\n[Store].[All Stores].[USA].[CA].[Alameda]\n[Store].[All Stores].[USA].[CA].[Beverly Hills]\n[Store].[All Stores].[USA].[CA].[Los Angeles]\n[Store].[All Stores].[USA].[CA].[San Diego]\n[Store].[All Stores].[USA].[CA].[San Diego].[Store 24]\n[Store].[All Stores].[USA].[CA].[San Francisco]\n[Store].[All Stores].[USA].[OR]\n[Store].[All Stores].[USA].[WA]\n[Store].[All Stores].[USA].[WA].[Bellingham]\n[Store].[All Stores].[USA].[WA].[Bremerton]\n[Store].[All Stores].[USA].[WA].[Seattle]\n[Store].[All Stores].[USA].[WA].[Spokane]\n[Store].[All Stores].[USA].[WA].[Tacoma]\n[Store].[All Stores].[USA].[WA].[Walla Walla]\n[Store].[All Stores].[USA].[WA].[Yakima]"));
        this.assertAxisReturns("DrilldownMember({([Store Type].[Supermarket], [Store].[USA])}, {[Store].[USA]})", FunctionTest.fold("{[Store Type].[All Store Types].[Supermarket], [Store].[All Stores].[USA]}\n{[Store Type].[All Store Types].[Supermarket], [Store].[All Stores].[USA].[CA]}\n{[Store Type].[All Store Types].[Supermarket], [Store].[All Stores].[USA].[OR]}\n{[Store Type].[All Store Types].[Supermarket], [Store].[All Stores].[USA].[WA]}"));
    }

    public void testFirstChildFirstInLevel() {
        Member member = this.executeSingletonAxis("[Time].[1997].[Q4].FirstChild");
        Assert.assertEquals((String)"10", (String)member.getName());
    }

    public void testFirstChildAll() {
        Member member = this.executeSingletonAxis("[Gender].[All Gender].FirstChild");
        Assert.assertEquals((String)"F", (String)member.getName());
    }

    public void testFirstChildOfChildless() {
        Member member = this.executeSingletonAxis("[Gender].[All Gender].[F].FirstChild");
        Assert.assertNull((Object)member);
    }

    public void testFirstSiblingFirstInLevel() {
        Member member = this.executeSingletonAxis("[Gender].[F].FirstSibling");
        Assert.assertEquals((String)"F", (String)member.getName());
    }

    public void testFirstSiblingLastInLevel() {
        Member member = this.executeSingletonAxis("[Time].[1997].[Q4].FirstSibling");
        Assert.assertEquals((String)"Q1", (String)member.getName());
    }

    public void testFirstSiblingAll() {
        Member member = this.executeSingletonAxis("[Gender].[All Gender].FirstSibling");
        Assert.assertTrue((boolean)member.isAll());
    }

    public void testFirstSiblingRoot() {
        Member member = this.executeSingletonAxis("[Measures].[Store Sales].FirstSibling");
        Assert.assertEquals((String)"Unit Sales", (String)member.getName());
    }

    public void testFirstSiblingNull() {
        Member member = this.executeSingletonAxis("[Gender].[F].FirstChild.FirstSibling");
        Assert.assertNull((Object)member);
    }

    public void testLag() {
        Member member = this.executeSingletonAxis("[Time].[1997].[Q4].[12].Lag(4)");
        Assert.assertEquals((String)"8", (String)member.getName());
    }

    public void testLagFirstInLevel() {
        Member member = this.executeSingletonAxis("[Gender].[F].Lag(1)");
        Assert.assertNull((Object)member);
    }

    public void testLagAll() {
        Member member = this.executeSingletonAxis("[Gender].DefaultMember.Lag(2)");
        Assert.assertNull((Object)member);
    }

    public void testLagRoot() {
        Member member = this.executeSingletonAxis("[Time].[1998].Lag(1)");
        Assert.assertEquals((String)"1997", (String)member.getName());
    }

    public void testLagRootTooFar() {
        Member member = this.executeSingletonAxis("[Time].[1998].Lag(2)");
        Assert.assertNull((Object)member);
    }

    public void testLastChild() {
        Member member = this.executeSingletonAxis("[Gender].LastChild");
        Assert.assertEquals((String)"M", (String)member.getName());
    }

    public void testLastChildLastInLevel() {
        Member member = this.executeSingletonAxis("[Time].[1997].[Q4].LastChild");
        Assert.assertEquals((String)"12", (String)member.getName());
    }

    public void testLastChildAll() {
        Member member = this.executeSingletonAxis("[Gender].[All Gender].LastChild");
        Assert.assertEquals((String)"M", (String)member.getName());
    }

    public void testLastChildOfChildless() {
        Member member = this.executeSingletonAxis("[Gender].[M].LastChild");
        Assert.assertNull((Object)member);
    }

    public void testLastSibling() {
        Member member = this.executeSingletonAxis("[Gender].[F].LastSibling");
        Assert.assertEquals((String)"M", (String)member.getName());
    }

    public void testLastSiblingFirstInLevel() {
        Member member = this.executeSingletonAxis("[Time].[1997].[Q1].LastSibling");
        Assert.assertEquals((String)"Q4", (String)member.getName());
    }

    public void testLastSiblingAll() {
        Member member = this.executeSingletonAxis("[Gender].[All Gender].LastSibling");
        Assert.assertTrue((boolean)member.isAll());
    }

    public void testLastSiblingRoot() {
        Member member = this.executeSingletonAxis("[Time].[1998].LastSibling");
        Assert.assertEquals((String)"1998", (String)member.getName());
    }

    public void testLastSiblingNull() {
        Member member = this.executeSingletonAxis("[Gender].[F].FirstChild.LastSibling");
        Assert.assertNull((Object)member);
    }

    public void testLead() {
        Member member = this.executeSingletonAxis("[Time].[1997].[Q2].[4].Lead(4)");
        Assert.assertEquals((String)"8", (String)member.getName());
    }

    public void testLeadNegative() {
        Member member = this.executeSingletonAxis("[Gender].[M].Lead(-1)");
        Assert.assertEquals((String)"F", (String)member.getName());
    }

    public void testLeadLastInLevel() {
        Member member = this.executeSingletonAxis("[Gender].[M].Lead(3)");
        Assert.assertNull((Object)member);
    }

    public void testLeadNull() {
        Member member = this.executeSingletonAxis("[Gender].Parent.Lead(1)");
        Assert.assertNull((Object)member);
    }

    public void testLeadZero() {
        Member member = this.executeSingletonAxis("[Gender].[F].Lead(0)");
        Assert.assertEquals((String)"F", (String)member.getName());
    }

    public void testBasic2() {
        Result result = this.executeQuery("select {[Gender].[F].NextMember} ON COLUMNS from Sales");
        Assert.assertTrue((boolean)((Member)result.getAxes()[0].getPositions().get(0).get(0)).getName().equals("M"));
    }

    public void testFirstInLevel2() {
        Result result = this.executeQuery("select {[Gender].[M].NextMember} ON COLUMNS from Sales");
        Assert.assertTrue((result.getAxes()[0].getPositions().size() == 0 ? 1 : 0) != 0);
    }

    public void testAll2() {
        Result result = this.executeQuery("select {[Gender].PrevMember} ON COLUMNS from Sales");
        Assert.assertTrue((result.getAxes()[0].getPositions().size() == 0 ? 1 : 0) != 0);
    }

    public void testBasic5() {
        Result result = this.executeQuery("select{ [Product].[All Products].[Drink].Parent} on columns from Sales");
        Assert.assertTrue((boolean)((Member)result.getAxes()[0].getPositions().get(0).get(0)).getName().equals("All Products"));
    }

    public void testFirstInLevel5() {
        Result result = this.executeQuery("select {[Time].[1997].[Q2].[4].Parent} on columns,{[Gender].[M]} on rows from Sales");
        Assert.assertTrue((boolean)((Member)result.getAxes()[0].getPositions().get(0).get(0)).getName().equals("Q2"));
    }

    public void testAll5() {
        Result result = this.executeQuery("select {[Time].[1997].[Q2].Parent} on columns,{[Gender].[M]} on rows from Sales");
        Assert.assertTrue((boolean)((Member)result.getAxes()[0].getPositions().get(0).get(0)).getName().equals("1997"));
    }

    public void testBasic() {
        Result result = this.executeQuery("select {[Gender].[M].PrevMember} ON COLUMNS from Sales");
        Assert.assertTrue((boolean)((Member)result.getAxes()[0].getPositions().get(0).get(0)).getName().equals("F"));
    }

    public void testFirstInLevel() {
        Result result = this.executeQuery("select {[Gender].[F].PrevMember} ON COLUMNS from Sales");
        Assert.assertTrue((result.getAxes()[0].getPositions().size() == 0 ? 1 : 0) != 0);
    }

    public void testAll() {
        Result result = this.executeQuery("select {[Gender].PrevMember} ON COLUMNS from Sales");
        Assert.assertTrue((result.getAxes()[0].getPositions().size() == 0 ? 1 : 0) != 0);
    }

    public void testAggregateDepends() {
        String s12 = TestContext.allDimsExcept("[Measures]", "[Gender]");
        this.getTestContext().assertExprDependsOn("([Measures].[Unit Sales], [Gender].[F])", s12);
        String s13 = TestContext.allDimsExcept("[Customers]", "[Gender]");
        this.getTestContext().assertExprDependsOn("Aggregate([Customers].Members, ([Measures].[Unit Sales], [Gender].[F]))", s13);
        String s11 = TestContext.allDimsExcept("[Customers]");
        this.getTestContext().assertExprDependsOn("Aggregate([Customers].Members)", s11);
        String s1 = TestContext.allDimsExcept("[Customers]");
        this.getTestContext().assertExprDependsOn("Aggregate(Filter([Customers].[City].Members, (([Measures].[Unit Sales] / ([Measures].[Unit Sales], [Product].[All Products])) > 0.1)))", s1);
    }

    public void testAggregate() {
        this.assertQueryReturns("WITH MEMBER [Store].[CA plus OR] AS 'AGGREGATE({[Store].[USA].[CA], [Store].[USA].[OR]})'\nSELECT {[Measures].[Unit Sales], [Measures].[Store Sales]} ON COLUMNS,\n      {[Store].[USA].[CA], [Store].[USA].[OR], [Store].[CA plus OR]} ON ROWS\nFROM Sales\nWHERE ([1997].[Q1])", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q1]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[CA plus OR]}\nRow #0: 16,890\nRow #0: 36,175.20\nRow #1: 19,287\nRow #1: 40,170.29\nRow #2: 36,177\nRow #2: 76,345.49\n"));
    }

    public void testAggregate2() {
        this.assertQueryReturns("WITH\n  MEMBER [Time].[1st Half Sales] AS 'Aggregate({Time.[1997].[Q1], Time.[1997].[Q2]})'\n  MEMBER [Time].[2nd Half Sales] AS 'Aggregate({Time.[1997].[Q3], Time.[1997].[Q4]})'\n  MEMBER [Time].[Difference] AS 'Time.[2nd Half Sales] - Time.[1st Half Sales]'\nSELECT\n   { [Store].[Store State].Members} ON COLUMNS,\n   { Time.[1st Half Sales], Time.[2nd Half Sales], Time.[Difference]} ON ROWS\nFROM Sales\nWHERE [Measures].[Store Sales]", FunctionTest.fold("Axis #0:\n{[Measures].[Store Sales]}\nAxis #1:\n{[Store].[All Stores].[Canada].[BC]}\n{[Store].[All Stores].[Mexico].[DF]}\n{[Store].[All Stores].[Mexico].[Guerrero]}\n{[Store].[All Stores].[Mexico].[Jalisco]}\n{[Store].[All Stores].[Mexico].[Veracruz]}\n{[Store].[All Stores].[Mexico].[Yucatan]}\n{[Store].[All Stores].[Mexico].[Zacatecas]}\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nAxis #2:\n{[Time].[1st Half Sales]}\n{[Time].[2nd Half Sales]}\n{[Time].[Difference]}\nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: 74,571.95\nRow #0: 71,943.17\nRow #0: 125,779.50\nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: 84,595.89\nRow #1: 70,333.90\nRow #1: 138,013.72\nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: 10,023.94\nRow #2: -1,609.27\nRow #2: 12,234.22\n"));
    }

    public void testAggregateWithIIF() {
        this.assertQueryReturns("with member store.foo as 'iif(3>1,aggregate({[Store].[All Stores].[USA].[OR]}),aggregate({[Store].[All Stores].[USA].[CA]}))' select {store.foo} on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[foo]}\nRow #0: 67,659\n"));
    }

    public void testAggregate2AllMembers() {
        this.assertQueryReturns("WITH\n  MEMBER [Time].[1st Half Sales] AS 'Aggregate({Time.[1997].[Q1], Time.[1997].[Q2]})'\n  MEMBER [Time].[2nd Half Sales] AS 'Aggregate({Time.[1997].[Q3], Time.[1997].[Q4]})'\n  MEMBER [Time].[Difference] AS 'Time.[2nd Half Sales] - Time.[1st Half Sales]'\nSELECT\n   { [Store].[Store State].AllMembers} ON COLUMNS,\n   { Time.[1st Half Sales], Time.[2nd Half Sales], Time.[Difference]} ON ROWS\nFROM Sales\nWHERE [Measures].[Store Sales]", FunctionTest.fold("Axis #0:\n{[Measures].[Store Sales]}\nAxis #1:\n{[Store].[All Stores].[Canada].[BC]}\n{[Store].[All Stores].[Mexico].[DF]}\n{[Store].[All Stores].[Mexico].[Guerrero]}\n{[Store].[All Stores].[Mexico].[Jalisco]}\n{[Store].[All Stores].[Mexico].[Veracruz]}\n{[Store].[All Stores].[Mexico].[Yucatan]}\n{[Store].[All Stores].[Mexico].[Zacatecas]}\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[All Stores].[USA].[WA]}\nAxis #2:\n{[Time].[1st Half Sales]}\n{[Time].[2nd Half Sales]}\n{[Time].[Difference]}\nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: 74,571.95\nRow #0: 71,943.17\nRow #0: 125,779.50\nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: \nRow #1: 84,595.89\nRow #1: 70,333.90\nRow #1: 138,013.72\nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: \nRow #2: 10,023.94\nRow #2: -1,609.27\nRow #2: 12,234.22\n"));
    }

    public void testAggregateToSimulateCompoundSlicer() {
        this.assertQueryReturns("WITH MEMBER [Time].[1997 H1] as 'Aggregate({[Time].[1997].[Q1], [Time].[1997].[Q2]})'\n  MEMBER [Education Level].[College or higher] as 'Aggregate({[Education Level].[Bachelors Degree], [Education Level].[Graduate Degree]})'\nSELECT {[Measures].[Unit Sales], [Measures].[Store Sales]} on columns,\n  {[Product].children} on rows\nFROM [Sales]\nWHERE ([Time].[1997 H1], [Education Level].[College or higher], [Gender].[F])", FunctionTest.fold("Axis #0:\n{[Time].[1997 H1], [Education Level].[College or higher], [Gender].[All Gender].[F]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: 1,797\nRow #0: 3,620.49\nRow #1: 15,002\nRow #1: 31,931.88\nRow #2: 3,845\nRow #2: 8,173.22\n"));
    }

    public void testMultiselectCalculations() {
        this.assertQueryReturns("WITH\nMEMBER [Measures].[Declining Stores Count] AS\n ' Count(Filter(Descendants(Store.CurrentMember, Store.[Store Name]), [Store Sales] < ([Store Sales],Time.PrevMember))) '\n MEMBER \n  [Store].[XL_QZX] AS 'Aggregate ({ [Store].[All Stores].[USA].[WA] , [Store].[All Stores].[USA].[CA] })' \nSELECT \n  NON EMPTY HIERARCHIZE(AddCalculatedMembers({DrillDownLevel({[Product].[All Products]})})) \n    DIMENSION PROPERTIES PARENT_UNIQUE_NAME ON COLUMNS \nFROM [Sales] \nWHERE ([Measures].[Declining Stores Count], [Time].[1998].[Q3], [Store].[XL_QZX])", FunctionTest.fold("Axis #0:\n{[Measures].[Declining Stores Count], [Time].[1998].[Q3], [Store].[XL_QZX]}\nAxis #1:\n{[Product].[All Products]}\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: .00\nRow #0: .00\nRow #0: .00\nRow #0: .00\n"));
    }

    public void testAvg() {
        this.assertExprReturns("AVG({[Store].[All Stores].[USA].children},[Measures].[Store Sales])", "188,412.71");
    }

    public void testCorrelation() {
        this.assertExprReturns("Correlation({[Store].[All Stores].[USA].children}, [Measures].[Unit Sales], [Measures].[Store Sales]) * 1000000", "999,906");
    }

    public void testCount() {
        this.getTestContext().assertExprDependsOn("count(Crossjoin([Store].[All Stores].[USA].Children, {[Gender].children}), INCLUDEEMPTY)", "{[Gender]}");
        String s1 = TestContext.allDimsExcept("[Store]");
        this.getTestContext().assertExprDependsOn("count(Crossjoin([Store].[All Stores].[USA].Children, {[Gender].children}), EXCLUDEEMPTY)", s1);
        this.assertExprReturns("count({[Promotion Media].[Media Type].members})", "14");
        this.assertExprReturns("count({[Gender].Parent}, IncludeEmpty)", "0");
    }

    public void testCountExcludeEmpty() {
        String s1 = TestContext.allDimsExcept("[Store]");
        this.getTestContext().assertExprDependsOn("count(Crossjoin([Store].[USA].Children, {[Gender].children}), EXCLUDEEMPTY)", s1);
        this.assertQueryReturns("with member [Measures].[Promo Count] as \n ' Count(Crossjoin({[Measures].[Unit Sales]},\n {[Promotion Media].[Media Type].members}), EXCLUDEEMPTY)'\nselect {[Measures].[Unit Sales], [Measures].[Promo Count]} on columns,\n {[Product].[Drink].[Beverages].[Carbonated Beverages].[Soda].children} on rows\nfrom Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Promo Count]}\nAxis #2:\n{[Product].[All Products].[Drink].[Beverages].[Carbonated Beverages].[Soda].[Excellent]}\n{[Product].[All Products].[Drink].[Beverages].[Carbonated Beverages].[Soda].[Fabulous]}\n{[Product].[All Products].[Drink].[Beverages].[Carbonated Beverages].[Soda].[Skinner]}\n{[Product].[All Products].[Drink].[Beverages].[Carbonated Beverages].[Soda].[Token]}\n{[Product].[All Products].[Drink].[Beverages].[Carbonated Beverages].[Soda].[Washington]}\nRow #0: 738\nRow #0: 14\nRow #1: 632\nRow #1: 13\nRow #2: 655\nRow #2: 14\nRow #3: 735\nRow #3: 14\nRow #4: 647\nRow #4: 12\n"));
        this.assertExprReturns("count({[Gender].Parent}, ExcludeEmpty)", "0");
    }

    public void testCovariance() {
        this.assertExprReturns("Covariance({[Store].[All Stores].[USA].children}, [Measures].[Unit Sales], [Measures].[Store Sales])", "1,355,761,899");
    }

    public void testCovarianceN() {
        this.assertExprReturns("CovarianceN({[Store].[All Stores].[USA].children}, [Measures].[Unit Sales], [Measures].[Store Sales])", "2,033,642,849");
    }

    public void testIIfNumeric() {
        this.assertExprReturns("IIf(([Measures].[Unit Sales],[Product].[Drink].[Alcoholic Beverages].[Beer and Wine]) > 100, 45, 32)", "45");
        this.assertExprReturns("IIf([Measures].[Unit Sales] > [Measures].[Store Sales], 45, 32)", "32");
    }

    public void testMax() {
        this.assertExprReturns("MAX({[Store].[All Stores].[USA].children},[Measures].[Store Sales])", "263,793.22");
    }

    public void testMaxNegative() {
        this.assertQueryReturns("with \n  member [Customers].[Neg] as '-1'\n  member [Customers].[Min] as 'Min({[Customers].[Neg]})'\n  member [Customers].[Max] as 'Max({[Customers].[Neg]})'\nselect {[Customers].[Neg],[Customers].[Min],[Customers].[Max]} on 0\nfrom Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[Neg]}\n{[Customers].[Min]}\n{[Customers].[Max]}\nRow #0: -1\nRow #0: -1\nRow #0: -1\n"));
    }

    public void testMedian() {
        this.assertExprReturns("MEDIAN({[Store].[All Stores].[USA].children},[Measures].[Store Sales])", "159,167.84");
    }

    public void testMedian2() {
        this.assertQueryReturns("WITH\n   MEMBER [Time].[1st Half Sales] AS 'Sum({[Time].[1997].[Q1], [Time].[1997].[Q2]})'\n   MEMBER [Time].[2nd Half Sales] AS 'Sum({[Time].[1997].[Q3], [Time].[1997].[Q4]})'\n   MEMBER [Time].[Median] AS 'Median(Time.Members)'\nSELECT\n   NON EMPTY { [Store].[Store Name].Members} ON COLUMNS,\n   { [Time].[1st Half Sales], [Time].[2nd Half Sales], [Time].[Median]} ON ROWS\nFROM Sales\nWHERE [Measures].[Store Sales]", FunctionTest.fold("Axis #0:\n{[Measures].[Store Sales]}\nAxis #1:\n{[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles].[Store 7]}\n{[Store].[All Stores].[USA].[CA].[San Diego].[Store 24]}\n{[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]}\n{[Store].[All Stores].[USA].[OR].[Portland].[Store 11]}\n{[Store].[All Stores].[USA].[OR].[Salem].[Store 13]}\n{[Store].[All Stores].[USA].[WA].[Bellingham].[Store 2]}\n{[Store].[All Stores].[USA].[WA].[Bremerton].[Store 3]}\n{[Store].[All Stores].[USA].[WA].[Seattle].[Store 15]}\n{[Store].[All Stores].[USA].[WA].[Spokane].[Store 16]}\n{[Store].[All Stores].[USA].[WA].[Tacoma].[Store 17]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla].[Store 22]}\n{[Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\nAxis #2:\n{[Time].[1st Half Sales]}\n{[Time].[2nd Half Sales]}\n{[Time].[Median]}\nRow #0: 20,801.04\nRow #0: 25,421.41\nRow #0: 26,275.11\nRow #0: 2,074.39\nRow #0: 28,519.18\nRow #0: 43,423.99\nRow #0: 2,140.99\nRow #0: 25,502.08\nRow #0: 25,293.50\nRow #0: 23,265.53\nRow #0: 34,926.91\nRow #0: 2,159.60\nRow #0: 12,490.89\nRow #1: 24,949.20\nRow #1: 29,123.87\nRow #1: 28,156.03\nRow #1: 2,366.79\nRow #1: 26,539.61\nRow #1: 43,794.29\nRow #1: 2,598.24\nRow #1: 27,394.22\nRow #1: 27,350.57\nRow #1: 26,368.93\nRow #1: 39,917.05\nRow #1: 2,546.37\nRow #1: 11,838.34\nRow #2: 4,577.35\nRow #2: 5,211.38\nRow #2: 4,722.87\nRow #2: 398.24\nRow #2: 5,039.50\nRow #2: 7,374.59\nRow #2: 410.22\nRow #2: 4,924.04\nRow #2: 4,569.13\nRow #2: 4,511.68\nRow #2: 6,630.91\nRow #2: 419.51\nRow #2: 2,169.48\n"));
    }

    public void testPercentile() {
        this.assertExprReturns("Percentile({[Store].[All Stores].[USA].children}, [Measures].[Store Sales], 50)", "159,167.84");
        this.assertExprReturns("Percentile({[Store].[All Stores].[USA].children}, [Measures].[Store Sales], 0)", "142,277.07");
        this.assertExprReturns("Percentile({[Store].[All Stores].[USA].children}, [Measures].[Store Sales], 100)", "263,793.22");
        this.assertExprReturns("Percentile({[Store].[All Stores].[USA].children}, [Measures].[Store Sales], 20)", "152,411.53");
        this.assertExprReturns("Percentile({[Store].[All Stores].[USA].children}, [Measures].[Store Sales], 25)", "154,945.15");
        this.assertExprReturns("Percentile({[Store].[All Stores].[USA].children}, [Measures].[Store Sales], 30)", "157,478.76");
    }

    public void testMin() {
        this.assertExprReturns("MIN({[Store].[All Stores].[USA].children},[Measures].[Store Sales])", "142,277.07");
    }

    public void testMinTuple() {
        this.assertExprReturns("Min([Customers].[All Customers].[USA].Children, ([Measures].[Unit Sales], [Gender].[All Gender].[F]))", "33,036");
    }

    public void testStdev() {
        this.assertExprReturns("STDEV({[Store].[All Stores].[USA].children},[Measures].[Store Sales])", "65,825.45");
    }

    public void testStdevP() {
        this.assertExprReturns("STDEVP({[Store].[All Stores].[USA].children},[Measures].[Store Sales])", "53,746.26");
    }

    public void testSumNoExp() {
        this.assertExprReturns("SUM({[Promotion Media].[Media Type].members})", "266,773");
    }

    public void testValue() {
        this.assertExprReturns("[Measures].[Store Sales].VALUE", "565,238.13");
        String s1 = TestContext.allDimsExcept("[Measures]");
        this.getTestContext().assertExprDependsOn("[Measures].[Store Sales].VALUE", s1);
        this.assertExprThrows("[Measures].[Store Sales].FORMATTED_VALUE", "MDX object '[Measures].[Store Sales].[FORMATTED_VALUE]' not found in cube 'Sales'");
        this.assertExprReturns("[Measures].[Store Sales].NAME", "Store Sales");
        this.assertExprThrows("[Measures].[Store Sales].ID", "MDX object '[Measures].[Store Sales].[ID]' not found in cube 'Sales'");
        this.assertExprThrows("[Measures].[Store Sales].KEY", "MDX object '[Measures].[Store Sales].[KEY]' not found in cube 'Sales'");
        this.assertExprReturns("[Measures].[Store Sales].CAPTION", "Store Sales");
    }

    public void testVar() {
        this.assertExprReturns("VAR({[Store].[All Stores].[USA].children},[Measures].[Store Sales])", "4,332,990,493.69");
    }

    public void testVarP() {
        this.assertExprReturns("VARP({[Store].[All Stores].[USA].children},[Measures].[Store Sales])", "2,888,660,329.13");
    }

    public void testAscendants() {
        this.assertAxisReturns("Ascendants([Store].[USA].[CA])", FunctionTest.fold("[Store].[All Stores].[USA].[CA]\n[Store].[All Stores].[USA]\n[Store].[All Stores]"));
    }

    public void testAscendantsAll() {
        this.assertAxisReturns("Ascendants([Store].DefaultMember)", "[Store].[All Stores]");
    }

    public void testAscendantsNull() {
        this.assertAxisReturns("Ascendants([Gender].[F].PrevMember)", "");
    }

    public void testBottomCount() {
        this.assertAxisReturns("BottomCount({[Promotion Media].[Media Type].members}, 2, [Measures].[Unit Sales])", FunctionTest.fold("[Promotion Media].[All Media].[Radio]\n[Promotion Media].[All Media].[Sunday Paper, Radio, TV]"));
    }

    public void testBottomPercent() {
        this.assertAxisReturns("BottomPercent(Filter({[Store].[All Stores].[USA].[CA].Children, [Store].[All Stores].[USA].[OR].Children, [Store].[All Stores].[USA].[WA].Children}, ([Measures].[Unit Sales] > 0.0)), 100.0, [Measures].[Store Sales])", FunctionTest.fold("[Store].[All Stores].[USA].[CA].[San Francisco]\n[Store].[All Stores].[USA].[WA].[Walla Walla]\n[Store].[All Stores].[USA].[WA].[Bellingham]\n[Store].[All Stores].[USA].[WA].[Yakima]\n[Store].[All Stores].[USA].[CA].[Beverly Hills]\n[Store].[All Stores].[USA].[WA].[Spokane]\n[Store].[All Stores].[USA].[WA].[Seattle]\n[Store].[All Stores].[USA].[WA].[Bremerton]\n[Store].[All Stores].[USA].[CA].[San Diego]\n[Store].[All Stores].[USA].[CA].[Los Angeles]\n[Store].[All Stores].[USA].[OR].[Portland]\n[Store].[All Stores].[USA].[WA].[Tacoma]\n[Store].[All Stores].[USA].[OR].[Salem]"));
        this.assertAxisReturns("BottomPercent({[Promotion Media].[Media Type].members}, 1, [Measures].[Unit Sales])", FunctionTest.fold("[Promotion Media].[All Media].[Radio]\n[Promotion Media].[All Media].[Sunday Paper, Radio, TV]"));
    }

    public void testBottomSum() {
        this.assertAxisReturns("BottomSum({[Promotion Media].[Media Type].members}, 5000, [Measures].[Unit Sales])", FunctionTest.fold("[Promotion Media].[All Media].[Radio]\n[Promotion Media].[All Media].[Sunday Paper, Radio, TV]"));
    }

    public void testExceptEmpty() {
        this.assertAxisReturns("Except(Filter([Gender].Members, 1=0), {[Gender].[M]})", "");
        this.assertAxisReturns("Except({[Gender].[M]}, Filter([Gender].Members, 1=0))", "[Gender].[All Gender].[M]");
    }

    public void testExceptCrossjoin() {
        this.assertAxisReturns(FunctionTest.fold("Except(CROSSJOIN({[Promotion Media].[All Media]},\n                  [Product].[All Products].Children),\n       CROSSJOIN({[Promotion Media].[All Media]},\n                  {[Product].[All Products].[Drink]}))"), FunctionTest.fold("{[Promotion Media].[All Media], [Product].[All Products].[Food]}\n{[Promotion Media].[All Media], [Product].[All Products].[Non-Consumable]}"));
    }

    public void testExtract() {
        this.assertAxisReturns("Extract(\nCrossjoin({[Gender].[F], [Gender].[M]},\n          {[Marital Status].Members}),\n[Gender])", FunctionTest.fold("[Gender].[All Gender].[F]\n[Gender].[All Gender].[M]"));
        this.assertAxisThrows("Extract(Crossjoin({[Gender].[F], [Gender].[M]}, {[Marital Status].Members}))", "No function matches signature 'Extract(<Set>)'");
        this.assertAxisThrows("Extract(Crossjoin([Gender].Members, [Store].Children), [Store].Hierarchy.Dimension)", "not a constant dimension: [Store].Hierarchy.Dimension");
        this.assertAxisReturns("Extract({[Gender].[M], [Gender].Members}, [Gender])", FunctionTest.fold("[Gender].[All Gender].[M]\n[Gender].[All Gender]\n[Gender].[All Gender].[F]"));
        this.assertAxisThrows("Extract(Crossjoin([Gender].Members, [Store].Children), [Marital Status])", "dimension [Marital Status] is not a dimension of the expression Crossjoin([Gender].Members, [Store].Children)");
        this.assertAxisReturns("Extract(Crossjoin({[Gender].Parent}, [Store].Children), [Store])", "");
        this.assertAxisReturns("Extract(\n{([Gender].[M], [Marital Status].[M]),\n ([Gender].[F], [Marital Status].[M]),\n ([Gender].[M], [Marital Status].[S])},\n[Gender])", FunctionTest.fold("[Gender].[All Gender].[M]\n[Gender].[All Gender].[F]"));
        this.assertAxisReturns("Extract(\n{([Gender].[M], [Marital Status].[M]),\n ([Gender].[F], [Marital Status].[M]),\n ([Gender].[M], [Marital Status].[S])},\n[Marital Status])", FunctionTest.fold("[Marital Status].[All Marital Status].[M]\n[Marital Status].[All Marital Status].[S]"));
        this.assertAxisReturns("Extract(\n[Gender].Children * [Marital Status].Children * [Time].[1997].Children * [Store].[USA].Children,\n[Time], [Marital Status])", FunctionTest.fold("{[Time].[1997].[Q1], [Marital Status].[All Marital Status].[M]}\n{[Time].[1997].[Q2], [Marital Status].[All Marital Status].[M]}\n{[Time].[1997].[Q3], [Marital Status].[All Marital Status].[M]}\n{[Time].[1997].[Q4], [Marital Status].[All Marital Status].[M]}\n{[Time].[1997].[Q1], [Marital Status].[All Marital Status].[S]}\n{[Time].[1997].[Q2], [Marital Status].[All Marital Status].[S]}\n{[Time].[1997].[Q3], [Marital Status].[All Marital Status].[S]}\n{[Time].[1997].[Q4], [Marital Status].[All Marital Status].[S]}"));
        this.assertAxisThrows("Extract(\n{([Gender].[M], [Marital Status].[M]),\n ([Gender].[F], [Marital Status].[M]),\n ([Gender].[M], [Marital Status].[S])},\n[Gender], [Gender])", "dimension [Gender] is extracted more than once");
    }

    public void testTopPercentCrossjoin() {
        this.assertAxisReturns(FunctionTest.fold("{TopPercent(Crossjoin([Product].[Product Department].members,\n[Time].[1997].children),10,[Measures].[Store Sales])}"), FunctionTest.fold("{[Product].[All Products].[Food].[Produce], [Time].[1997].[Q4]}\n{[Product].[All Products].[Food].[Produce], [Time].[1997].[Q1]}\n{[Product].[All Products].[Food].[Produce], [Time].[1997].[Q3]}"));
    }

    public void testCrossjoinNested() {
        this.assertAxisReturns(FunctionTest.fold("  CrossJoin(\n    CrossJoin(\n      [Gender].members,\n      [Marital Status].members),\n   {[Store], [Store].children})"), FunctionTest.fold("{[Gender].[All Gender], [Marital Status].[All Marital Status], [Store].[All Stores]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status], [Store].[All Stores].[USA]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[M], [Store].[All Stores]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[USA]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[S], [Store].[All Stores]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[USA]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status], [Store].[All Stores]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status], [Store].[All Stores].[USA]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Store].[All Stores]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[USA]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S], [Store].[All Stores]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[USA]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status], [Store].[All Stores]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status], [Store].[All Stores].[USA]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M], [Store].[All Stores]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M], [Store].[All Stores].[USA]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Store].[All Stores]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[USA]}"));
    }

    public void testCrossjoinSingletonTuples() {
        this.assertAxisReturns("CrossJoin({([Gender].[M])}, {([Marital Status].[S])})", "{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S]}");
    }

    public void testCrossjoinSingletonTuplesNested() {
        this.assertAxisReturns("CrossJoin({([Gender].[M])}, CrossJoin({([Marital Status].[S])}, [Store].children))", FunctionTest.fold("{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[Canada]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[Mexico]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Store].[All Stores].[USA]}"));
    }

    public void testCrossjoinAsterisk() {
        this.assertAxisReturns("{[Gender].[M]} * {[Marital Status].[S]}", "{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S]}");
    }

    public void testCrossjoinAsteriskTuple() {
        this.assertThrows("select {[Measures].[Unit Sales]} ON COLUMNS, NON EMPTY [Store].[All Stores]  * ([Product].[All Products], [Gender])  * [Customers].[All Customers] ON ROWS from [Sales]", "Axis 'ROWS' expression is not a set");
    }

    public void testCrossjoinAsteriskAssoc() {
        this.assertAxisReturns("Order({[Gender].Children} * {[Marital Status].Children} * {[Time].[1997].[Q2].Children},[Measures].[Unit Sales])", FunctionTest.fold("{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Time].[1997].[Q2].[4]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Time].[1997].[Q2].[6]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M], [Time].[1997].[Q2].[5]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S], [Time].[1997].[Q2].[4]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S], [Time].[1997].[Q2].[5]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S], [Time].[1997].[Q2].[6]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M], [Time].[1997].[Q2].[4]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M], [Time].[1997].[Q2].[5]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M], [Time].[1997].[Q2].[6]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Time].[1997].[Q2].[6]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Time].[1997].[Q2].[4]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Time].[1997].[Q2].[5]}"));
    }

    public void testCrossjoinAsteriskInsideBraces() {
        this.assertAxisReturns("{[Gender].[M] * [Marital Status].[S] * [Time].[1997].[Q2].Children}", FunctionTest.fold("{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Time].[1997].[Q2].[4]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Time].[1997].[Q2].[5]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S], [Time].[1997].[Q2].[6]}"));
    }

    public void testCrossJoinAsteriskQuery() {
        this.assertQueryReturns("SELECT {[Measures].members * [1997].children} ON COLUMNS,\n {[Store].[USA].children * [Position].[All Position].children} DIMENSION PROPERTIES [Store].[Store SQFT] ON ROWS\nFROM [HR]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Org Salary], [Time].[1997].[Q1]}\n{[Measures].[Org Salary], [Time].[1997].[Q2]}\n{[Measures].[Org Salary], [Time].[1997].[Q3]}\n{[Measures].[Org Salary], [Time].[1997].[Q4]}\n{[Measures].[Count], [Time].[1997].[Q1]}\n{[Measures].[Count], [Time].[1997].[Q2]}\n{[Measures].[Count], [Time].[1997].[Q3]}\n{[Measures].[Count], [Time].[1997].[Q4]}\n{[Measures].[Number of Employees], [Time].[1997].[Q1]}\n{[Measures].[Number of Employees], [Time].[1997].[Q2]}\n{[Measures].[Number of Employees], [Time].[1997].[Q3]}\n{[Measures].[Number of Employees], [Time].[1997].[Q4]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA], [Position].[All Position].[Middle Management]}\n{[Store].[All Stores].[USA].[CA], [Position].[All Position].[Senior Management]}\n{[Store].[All Stores].[USA].[CA], [Position].[All Position].[Store Full Time Staf]}\n{[Store].[All Stores].[USA].[CA], [Position].[All Position].[Store Management]}\n{[Store].[All Stores].[USA].[CA], [Position].[All Position].[Store Temp Staff]}\n{[Store].[All Stores].[USA].[OR], [Position].[All Position].[Middle Management]}\n{[Store].[All Stores].[USA].[OR], [Position].[All Position].[Senior Management]}\n{[Store].[All Stores].[USA].[OR], [Position].[All Position].[Store Full Time Staf]}\n{[Store].[All Stores].[USA].[OR], [Position].[All Position].[Store Management]}\n{[Store].[All Stores].[USA].[OR], [Position].[All Position].[Store Temp Staff]}\n{[Store].[All Stores].[USA].[WA], [Position].[All Position].[Middle Management]}\n{[Store].[All Stores].[USA].[WA], [Position].[All Position].[Senior Management]}\n{[Store].[All Stores].[USA].[WA], [Position].[All Position].[Store Full Time Staf]}\n{[Store].[All Stores].[USA].[WA], [Position].[All Position].[Store Management]}\n{[Store].[All Stores].[USA].[WA], [Position].[All Position].[Store Temp Staff]}\nRow #0: $275.40\nRow #0: $275.40\nRow #0: $275.40\nRow #0: $275.40\nRow #0: 27\nRow #0: 27\nRow #0: 27\nRow #0: 27\nRow #0: 9\nRow #0: 9\nRow #0: 9\nRow #0: 9\nRow #1: $837.00\nRow #1: $837.00\nRow #1: $837.00\nRow #1: $837.00\nRow #1: 24\nRow #1: 24\nRow #1: 24\nRow #1: 24\nRow #1: 8\nRow #1: 8\nRow #1: 8\nRow #1: 8\nRow #2: $1,728.45\nRow #2: $1,727.02\nRow #2: $1,727.72\nRow #2: $1,726.55\nRow #2: 357\nRow #2: 357\nRow #2: 357\nRow #2: 357\nRow #2: 119\nRow #2: 119\nRow #2: 119\nRow #2: 119\nRow #3: $473.04\nRow #3: $473.04\nRow #3: $473.04\nRow #3: $473.04\nRow #3: 51\nRow #3: 51\nRow #3: 51\nRow #3: 51\nRow #3: 17\nRow #3: 17\nRow #3: 17\nRow #3: 17\nRow #4: $401.35\nRow #4: $405.73\nRow #4: $400.61\nRow #4: $402.31\nRow #4: 120\nRow #4: 120\nRow #4: 120\nRow #4: 120\nRow #4: 40\nRow #4: 40\nRow #4: 40\nRow #4: 40\nRow #5: \nRow #5: \nRow #5: \nRow #5: \nRow #5: \nRow #5: \nRow #5: \nRow #5: \nRow #5: \nRow #5: \nRow #5: \nRow #5: \nRow #6: \nRow #6: \nRow #6: \nRow #6: \nRow #6: \nRow #6: \nRow #6: \nRow #6: \nRow #6: \nRow #6: \nRow #6: \nRow #6: \nRow #7: $1,343.62\nRow #7: $1,342.61\nRow #7: $1,342.57\nRow #7: $1,343.65\nRow #7: 279\nRow #7: 279\nRow #7: 279\nRow #7: 279\nRow #7: 93\nRow #7: 93\nRow #7: 93\nRow #7: 93\nRow #8: $286.74\nRow #8: $286.74\nRow #8: $286.74\nRow #8: $286.74\nRow #8: 30\nRow #8: 30\nRow #8: 30\nRow #8: 30\nRow #8: 10\nRow #8: 10\nRow #8: 10\nRow #8: 10\nRow #9: $333.20\nRow #9: $332.65\nRow #9: $331.28\nRow #9: $332.43\nRow #9: 99\nRow #9: 99\nRow #9: 99\nRow #9: 99\nRow #9: 33\nRow #9: 33\nRow #9: 33\nRow #9: 33\nRow #10: \nRow #10: \nRow #10: \nRow #10: \nRow #10: \nRow #10: \nRow #10: \nRow #10: \nRow #10: \nRow #10: \nRow #10: \nRow #10: \nRow #11: \nRow #11: \nRow #11: \nRow #11: \nRow #11: \nRow #11: \nRow #11: \nRow #11: \nRow #11: \nRow #11: \nRow #11: \nRow #11: \nRow #12: $2,768.60\nRow #12: $2,769.18\nRow #12: $2,766.78\nRow #12: $2,769.50\nRow #12: 579\nRow #12: 579\nRow #12: 579\nRow #12: 579\nRow #12: 193\nRow #12: 193\nRow #12: 193\nRow #12: 193\nRow #13: $736.29\nRow #13: $736.29\nRow #13: $736.29\nRow #13: $736.29\nRow #13: 81\nRow #13: 81\nRow #13: 81\nRow #13: 81\nRow #13: 27\nRow #13: 27\nRow #13: 27\nRow #13: 27\nRow #14: $674.70\nRow #14: $674.54\nRow #14: $676.26\nRow #14: $676.48\nRow #14: 201\nRow #14: 201\nRow #14: 201\nRow #14: 201\nRow #14: 67\nRow #14: 67\nRow #14: 67\nRow #14: 67\n"));
    }

    public void testCrossjoinResolve() {
        this.assertQueryReturns("with\nmember [Measures].[Filtered Unit Sales] as\n 'IIf((([Measures].[Unit Sales] > 50000.0)\n      OR ([Product].CurrentMember.Level.UniqueName <>\n          \"[Product].[Product Family]\")),\n      IIf(((Count([Product].CurrentMember.Children) = 0.0)),\n          [Measures].[Unit Sales],\n          Sum([Product].CurrentMember.Children,\n              [Measures].[Filtered Unit Sales])),\n      NULL)'\nselect NON EMPTY {crossjoin({[Measures].[Filtered Unit Sales]},\n{[Gender].[M], [Gender].[F]})} ON COLUMNS,\nNON EMPTY {[Product].[All Products]} ON ROWS\nfrom [Sales]\nwhere [Time].[1997]", FunctionTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Filtered Unit Sales], [Gender].[All Gender].[M]}\n{[Measures].[Filtered Unit Sales], [Gender].[All Gender].[F]}\nAxis #2:\n{[Product].[All Products]}\nRow #0: 97,126\nRow #0: 94,814\n"));
    }

    public void testCrossjoinOrder() {
        this.assertQueryReturns("WITH\n\nSET [S1] AS 'CROSSJOIN({[Time].[1997]}, {[Gender].[Gender].MEMBERS})'\n\nSELECT CROSSJOIN(ORDER([S1], [Measures].[Unit Sales], BDESC),\n{[Measures].[Unit Sales]}) ON AXIS(0)\nFROM [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997], [Gender].[All Gender].[M], [Measures].[Unit Sales]}\n{[Time].[1997], [Gender].[All Gender].[F], [Measures].[Unit Sales]}\nRow #0: 135,215\nRow #0: 131,558\n"));
    }

    public void testCrossjoinDupDimensionFails() {
        this.assertThrows("select [Measures].[Unit Sales] ON COLUMNS,\n CrossJoin({[Time].[Quarter].[Q1]}, {[Time].[Month].[5]}) ON ROWS\nfrom [Sales]", "Tuple contains more than one member of dimension '[Time]'.");
        this.assertThrows("select [Measures].[Unit Sales] ON COLUMNS,\n CrossJoin({[Time].[Quarter].[Q1]}, {[Time].[Month].[5]}).Item(0) ON ROWS\nfrom [Sales]", "Tuple contains more than one member of dimension '[Time]'.");
        this.assertThrows("select [Measures].[Unit Sales] ON COLUMNS,\n ([Time].[Quarter].[Q1], [Time].[Month].[5]) ON ROWS\nfrom [Sales]", "Tuple contains more than one member of dimension '[Time]'.");
    }

    public void testDescendantsM() {
        this.assertAxisReturns("Descendants([Time].[1997].[Q1])", FunctionTest.fold("[Time].[1997].[Q1]\n[Time].[1997].[Q1].[1]\n[Time].[1997].[Q1].[2]\n[Time].[1997].[Q1].[3]"));
    }

    public void testDescendantsDepends() {
        this.getTestContext().assertSetExprDependsOn("Descendants([Time].CurrentMember)", "{[Time]}");
    }

    public void testDescendantsML() {
        this.assertAxisReturns("Descendants([Time].[1997], [Time].[Month])", months);
    }

    public void testDescendantsMLSelf() {
        this.assertAxisReturns("Descendants([Time].[1997], [Time].[Quarter], SELF)", quarters);
    }

    public void testDescendantsMLLeaves() {
        this.assertAxisReturns("Descendants([Time].[1997], [Time].[Year], LEAVES)", "");
        this.assertAxisReturns("Descendants([Time].[1997], [Time].[Quarter], LEAVES)", "");
        this.assertAxisReturns("Descendants([Time].[1997], [Time].[Month], LEAVES)", months);
        this.assertAxisReturns("Descendants([Gender], [Gender].[Gender], leaves)", FunctionTest.fold("[Gender].[All Gender].[F]\n[Gender].[All Gender].[M]"));
    }

    public void testDescendantsMLLeavesRagged() {
        TestContext raggedContext = this.getTestContext().withCube("[Sales Ragged]");
        raggedContext.assertAxisReturns("Descendants([Store].[Israel], [Store].[Store City], leaves)", "");
        raggedContext.assertAxisReturns("Descendants([Geography].[Israel], [Geography].[City], leaves)", FunctionTest.fold("[Geography].[All Geographys].[Israel].[Israel].[Haifa]\n[Geography].[All Geographys].[Israel].[Israel].[Tel Aviv]"));
        raggedContext.assertAxisReturns("Descendants([Geography], [Geography].[State], leaves)", "");
        raggedContext.assertAxisReturns("Descendants([Geography], [Geography].[Country], leaves)", "[Geography].[All Geographys].[Vatican]");
    }

    public void testDescendantsMNLeaves() {
        this.assertAxisReturns("Descendants([Time].[1997].[Q2].[4], 0, Leaves)", "[Time].[1997].[Q2].[4]");
        this.assertAxisReturns("Descendants([Time].[1997].[Q2].[4], 100, Leaves)", "[Time].[1997].[Q2].[4]");
        this.assertAxisReturns("Descendants([Time].[1997].[Q2], -1, Leaves)", FunctionTest.fold("[Time].[1997].[Q2].[4]\n[Time].[1997].[Q2].[5]\n[Time].[1997].[Q2].[6]"));
        this.assertAxisReturns("Descendants([Time].[1997].[Q2], 0, Leaves)", FunctionTest.fold("[Time].[1997].[Q2].[4]\n[Time].[1997].[Q2].[5]\n[Time].[1997].[Q2].[6]"));
        this.assertAxisReturns("Descendants([Time].[1997].[Q2], 3, Leaves)", FunctionTest.fold("[Time].[1997].[Q2].[4]\n[Time].[1997].[Q2].[5]\n[Time].[1997].[Q2].[6]"));
    }

    public void testDescendantsMLSelfBefore() {
        this.assertAxisReturns("Descendants([Time].[1997], [Time].[Quarter], SELF_AND_BEFORE)", year1997 + nl + quarters);
    }

    public void testDescendantsMLSelfBeforeAfter() {
        this.assertAxisReturns("Descendants([Time].[1997], [Time].[Quarter], SELF_BEFORE_AFTER)", hierarchized1997);
    }

    public void testDescendantsMLBefore() {
        this.assertAxisReturns("Descendants([Time].[1997], [Time].[Quarter], BEFORE)", year1997);
    }

    public void testDescendantsMLBeforeAfter() {
        this.assertAxisReturns("Descendants([Time].[1997], [Time].[Quarter], BEFORE_AND_AFTER)", year1997 + nl + months);
    }

    public void testDescendantsMLAfter() {
        this.assertAxisReturns("Descendants([Time].[1997], [Time].[Quarter], AFTER)", months);
    }

    public void testDescendantsMLAfterEnd() {
        this.assertAxisReturns("Descendants([Time].[1997], [Time].[Month], AFTER)", "");
    }

    public void testDescendantsM0() {
        this.assertAxisReturns("Descendants([Time].[1997], 0)", year1997);
    }

    public void testDescendantsM2() {
        this.assertAxisReturns("Descendants([Time].[1997], 2)", months);
    }

    public void testDescendantsM2Self() {
        this.assertAxisReturns("Descendants([Time].[1997], 2, Self)", months);
    }

    public void testDescendantsM2Leaves() {
        this.assertAxisReturns("Descendants([Time].[1997], 2, Leaves)", months);
    }

    public void testDescendantsMFarLeaves() {
        this.assertAxisReturns("Descendants([Time].[1997], 10000, Leaves)", months);
    }

    public void testDescendantsMEmptyLeaves() {
        this.assertAxisReturns("Descendants([Time].[1997], , Leaves)", months);
    }

    public void testDescendantsMEmptyLeavesFail() {
        this.assertAxisThrows("Descendants([Time].[1997],)", "Syntax error at line 1, column 36, token ')'");
    }

    public void testDescendantsMEmptyLeavesFail2() {
        this.assertAxisThrows("Descendants([Time].[1997], , AFTER)", "depth must be specified unless DESC_FLAG is LEAVES");
    }

    public void testDescendantsMFarSelf() {
        this.assertAxisReturns("Descendants([Time].[1997], 10000, Self)", "");
    }

    public void testDescendantsMNY() {
        this.assertAxisReturns("Descendants([Time].[1997], 1, BEFORE_AND_AFTER)", year1997 + nl + months);
    }

    public void testDescendants2ndHier() {
        this.assertAxisReturns("Descendants([Time.Weekly].[1997].[10], [Time.Weekly].[Day])", FunctionTest.fold("[Time].[Weekly].[All Weeklys].[1997].[10].[1]\n[Time].[Weekly].[All Weeklys].[1997].[10].[23]\n[Time].[Weekly].[All Weeklys].[1997].[10].[24]\n[Time].[Weekly].[All Weeklys].[1997].[10].[25]\n[Time].[Weekly].[All Weeklys].[1997].[10].[26]\n[Time].[Weekly].[All Weeklys].[1997].[10].[27]\n[Time].[Weekly].[All Weeklys].[1997].[10].[28]"));
    }

    public void testDescendantsParentChild() {
        this.getTestContext().withCube("HR").assertAxisReturns("Descendants([Employees], 2)", FunctionTest.fold("[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence]\n[Employees].[All Employees].[Sheri Nowmer].[Maya Gutierrez]\n[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra]\n[Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz]\n[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold]"));
    }

    public void testDescendantsParentChildBefore() {
        this.getTestContext().withCube("HR").assertAxisReturns("Descendants([Employees], 2, BEFORE)", FunctionTest.fold("[Employees].[All Employees]\n[Employees].[All Employees].[Sheri Nowmer]"));
    }

    public void testDescendantsParentChildLeaves() {
        TestContext testContext = this.getTestContext().withCube("HR");
        testContext.assertAxisReturns("Descendants([Employees].[All Employees].[Sheri Nowmer].[Michael Spence], [Employees].[Employee Id], LEAVES)", FunctionTest.fold("[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[John Brooks]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Todd Logan]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Joshua Several]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[James Thomas]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Robert Vessa]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Bronson Jacobs]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Rebecca Barley]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Emilio Alvaro]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Becky Waters]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[A. Joyce Jarvis]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Ruby Sue Styles]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Lisa Roy]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Ingrid Burkhardt]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Todd Whitney]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Barbara Wisnewski]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Karren Burkhardt]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[John Long]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Edwin Olenzek]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Jessie Valerio]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Robert Ahlering]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Megan Burke]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Mary Sandidge].[Karel Bates]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[James Tran]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Shelley Crow]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Anne Sims]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Clarence Tatman]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Jan Nelsen]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Jeanie Glenn]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Peggy Smith]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Tish Duff]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Anita Lucero]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Stephen Burton]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Amy Consentino]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Stacie Mcanich]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Mary Browning]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Alexandra Wellington]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Cory Bacugalupi]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Stacy Rizzi]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Mike White]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Marty Simpson]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Robert Jones]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Raul Casts]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Bridget Browqett]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Monk Skonnard].[Kay Kartz]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Jeanette Cole]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Phyllis Huntsman]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Hannah Arakawa]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Wathalee Steuber]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Pamela Cox]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Helen Lutes]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Linda Ecoffey]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Katherine Swint]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Dianne Slattengren]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Ronald Heymsfield]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Steven Whitehead]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[William Sotelo]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Beth Stanley]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Jill Markwood]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Mildred Valentine]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Suzann Reams]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Audrey Wold]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Susan French]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Trish Pederson]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Eric Renn]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Elizabeth Catalano]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Christopher Beck].[Eric Coleman]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Catherine Abel]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Emilo Miller]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Daniel Wolter].[Michael John Troyer].[Hazel Walker]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Dianne Collins].[Lawrence Hurkett].[Sara Pettengill].[Linda Blasingame]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Dianne Collins].[Lawrence Hurkett].[Sara Pettengill].[Jackie Blackwell]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Dianne Collins].[Lawrence Hurkett].[Sara Pettengill].[John Ortiz]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Dianne Collins].[Lawrence Hurkett].[Sara Pettengill].[Stacey Tearpak]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Dianne Collins].[Lawrence Hurkett].[Sara Pettengill].[Fannye Weber]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Dianne Collins].[Lawrence Hurkett].[Sara Pettengill].[Diane Kabbes]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Dianne Collins].[Lawrence Hurkett].[Sara Pettengill].[Brenda Heaney]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Dianne Collins].[Lawrence Hurkett].[Sara Pettengill].[Judith Karavites]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Dianne Collins].[Lawrence Hurkett].[Jauna Elson]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Dianne Collins].[Lawrence Hurkett].[Nancy Hirota]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Dianne Collins].[Lawrence Hurkett].[Marie Moya]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Dianne Collins].[Lawrence Hurkett].[Nicky Chesnut]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Dianne Collins].[Lawrence Hurkett].[Karen Hall]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Dianne Collins].[Lawrence Hurkett].[Greg Narberes]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Dianne Collins].[Lawrence Hurkett].[Anna Townsend]\n[Employees].[All Employees].[Sheri Nowmer].[Michael Spence].[Dianne Collins].[Lawrence Hurkett].[Carol Ann Rockne]"));
        testContext.assertAxisReturns("Descendants([Employees], 1, LEAVES)", "");
        testContext.assertAxisReturns("Descendants([Employees], 2, LEAVES)", FunctionTest.fold("[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra].[Jennifer Cooper]\n[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra].[Peggy Petty]\n[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra].[Jessica Olguin]\n[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra].[Phyllis Burchett]\n[Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki].[Juanita Sharp]\n[Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki].[Sandra Brunner]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz].[Ernest Staton]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz].[Rose Sims]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz].[Lauretta De Carlo]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz].[Mary Williams]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz].[Terri Burke]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz].[Audrey Osborn]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz].[Brian Binai]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz].[Concepcion Lozada]\n[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold].[Howard Bechard]\n[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold].[Doris Carter]"));
        testContext.assertAxisReturns("Descendants([Employees], 3, LEAVES)", FunctionTest.fold("[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra].[Jennifer Cooper]\n[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra].[Peggy Petty]\n[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra].[Jessica Olguin]\n[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra].[Phyllis Burchett]\n[Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki].[Juanita Sharp]\n[Employees].[All Employees].[Sheri Nowmer].[Rebecca Kanagaki].[Sandra Brunner]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz].[Ernest Staton]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz].[Rose Sims]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz].[Lauretta De Carlo]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz].[Mary Williams]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz].[Terri Burke]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz].[Audrey Osborn]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz].[Brian Binai]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz].[Concepcion Lozada]\n[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold].[Howard Bechard]\n[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold].[Doris Carter]"));
        testContext.assertAxisReturns("Descendants([Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra], 1, LEAVES)", FunctionTest.fold("[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra].[Jennifer Cooper]\n[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra].[Peggy Petty]\n[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra].[Jessica Olguin]\n[Employees].[All Employees].[Sheri Nowmer].[Roberta Damstra].[Phyllis Burchett]"));
        testContext.assertAxisReturns("Descendants([Employees].[All Employees].[Sheri Nowmer].[Donna Arnold].[Howard Bechard], 0, LEAVES)", "[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold].[Howard Bechard]");
        testContext.assertAxisReturns("Descendants([Employees].[All Employees].[Sheri Nowmer].[Donna Arnold].[Howard Bechard], 1, LEAVES)", "[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold].[Howard Bechard]");
        testContext.assertExprReturns("Count(Descendants([Employees], 2, LEAVES))", "16");
        testContext.assertExprReturns("Count(Descendants([Employees], 3, LEAVES))", "16");
        testContext.assertExprReturns("Count(Descendants([Employees], 4, LEAVES))", "63");
        testContext.assertExprReturns("Count(Descendants([Employees], 999, LEAVES))", "1,044");
        for (int i = 0; i < 100; ++i) {
            testContext.assertExprReturns("Count(Descendants([Employees], -1, LEAVES))", "1,044");
        }
    }

    public void testDescendantsSBA() {
        this.assertAxisReturns("Descendants([Time].[1997], 1, SELF_BEFORE_AFTER)", hierarchized1997);
    }

    public void testDescendantsSet() {
        this.assertAxisReturns("Descendants({[Time].[1997].[Q4], [Time].[1997].[Q2]}, 1)", FunctionTest.fold("[Time].[1997].[Q4].[10]\n[Time].[1997].[Q4].[11]\n[Time].[1997].[Q4].[12]\n[Time].[1997].[Q2].[4]\n[Time].[1997].[Q2].[5]\n[Time].[1997].[Q2].[6]"));
        this.assertAxisReturns("Descendants({[Time].[1997]}, [Time].[Month], LEAVES)", months);
    }

    public void testDescendantsSetEmpty() {
        this.assertAxisThrows("Descendants({}, 1)", "Cannot deduce type of set");
        this.assertAxisReturns("Descendants(Filter({[Time].Members}, 1=0), 1)", "");
    }

    public void testRange() {
        this.assertAxisReturns("[Time].[1997].[Q1].[2] : [Time].[1997].[Q2].[5]", FunctionTest.fold("[Time].[1997].[Q1].[2]\n[Time].[1997].[Q1].[3]\n[Time].[1997].[Q2].[4]\n[Time].[1997].[Q2].[5]"));
        this.assertQueryReturns("with set [Set1] as '[Product].[Drink]:[Product].[Food]' \n\nselect [Set1] on columns, {[Measures].defaultMember} on rows \n\nfrom Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Food]}\nAxis #2:\n{[Measures].[Unit Sales]}\nRow #0: 24,597\nRow #0: 191,940\n"));
    }

    public void testNullRange() {
        this.assertAxisReturns("[Time].[1997].[Q1].[2] : NULL", FunctionTest.fold(""));
    }

    public void testTwoNullRange() {
        this.assertAxisThrows("NULL : NULL", "Mondrian Error:Failed to parse query 'select {NULL : NULL} on columns from Sales'");
    }

    public void testRangeLarge() {
        this.assertAxisReturns("[Customers].[USA].[CA].[San Francisco] : [Customers].[USA].[WA].[Bellingham]", FunctionTest.fold("[Customers].[All Customers].[USA].[CA].[San Francisco]\n[Customers].[All Customers].[USA].[CA].[San Gabriel]\n[Customers].[All Customers].[USA].[CA].[San Jose]\n[Customers].[All Customers].[USA].[CA].[Santa Cruz]\n[Customers].[All Customers].[USA].[CA].[Santa Monica]\n[Customers].[All Customers].[USA].[CA].[Spring Valley]\n[Customers].[All Customers].[USA].[CA].[Torrance]\n[Customers].[All Customers].[USA].[CA].[West Covina]\n[Customers].[All Customers].[USA].[CA].[Woodland Hills]\n[Customers].[All Customers].[USA].[OR].[Albany]\n[Customers].[All Customers].[USA].[OR].[Beaverton]\n[Customers].[All Customers].[USA].[OR].[Corvallis]\n[Customers].[All Customers].[USA].[OR].[Lake Oswego]\n[Customers].[All Customers].[USA].[OR].[Lebanon]\n[Customers].[All Customers].[USA].[OR].[Milwaukie]\n[Customers].[All Customers].[USA].[OR].[Oregon City]\n[Customers].[All Customers].[USA].[OR].[Portland]\n[Customers].[All Customers].[USA].[OR].[Salem]\n[Customers].[All Customers].[USA].[OR].[W. Linn]\n[Customers].[All Customers].[USA].[OR].[Woodburn]\n[Customers].[All Customers].[USA].[WA].[Anacortes]\n[Customers].[All Customers].[USA].[WA].[Ballard]\n[Customers].[All Customers].[USA].[WA].[Bellingham]"));
    }

    public void testRangeStartEqualsEnd() {
        this.assertAxisReturns("[Time].[1997].[Q3].[7] : [Time].[1997].[Q3].[7]", "[Time].[1997].[Q3].[7]");
    }

    public void testRangeStartEqualsEndLarge() {
        this.assertAxisReturns("[Customers].[USA].[CA] : [Customers].[USA].[CA]", "[Customers].[All Customers].[USA].[CA]");
    }

    public void testRangeEndBeforeStart() {
        this.assertAxisReturns("[Time].[1997].[Q3].[7] : [Time].[1997].[Q2].[5]", FunctionTest.fold("[Time].[1997].[Q2].[5]\n[Time].[1997].[Q2].[6]\n[Time].[1997].[Q3].[7]"));
    }

    public void testRangeEndBeforeStartLarge() {
        this.assertAxisReturns("[Customers].[USA].[WA] : [Customers].[USA].[CA]", FunctionTest.fold("[Customers].[All Customers].[USA].[CA]\n[Customers].[All Customers].[USA].[OR]\n[Customers].[All Customers].[USA].[WA]"));
    }

    public void testRangeBetweenDifferentLevelsIsError() {
        this.assertAxisThrows("[Time].[1997].[Q2] : [Time].[1997].[Q2].[5]", "Members must belong to the same level");
    }

    public void testRangeBoundedByAll() {
        this.assertAxisReturns("[Gender] : [Gender]", "[Gender].[All Gender]");
    }

    public void testRangeBoundedByAllLarge() {
        this.assertAxisReturns("[Customers].DefaultMember : [Customers]", "[Customers].[All Customers]");
    }

    public void testRangeBoundedByNull() {
        this.assertAxisReturns("[Gender].[F] : [Gender].[M].NextMember", "");
    }

    public void testRangeBoundedByNullLarge() {
        this.assertAxisReturns("[Customers].PrevMember : [Customers].[USA].[OR]", "");
    }

    public void testSetContainingLevelFails() {
        this.assertAxisThrows("[Store].[Store City]", "No function matches signature '{<Level>}'");
    }

    public void testBug715177() {
        this.assertQueryReturns("WITH MEMBER [Product].[All Products].[Non-Consumable].[Other] AS\n 'Sum(Except( [Product].[Product Department].Members,\n       TopCount([Product].[Product Department].Members, 3)),\n       Measures.[Unit Sales])'\nSELECT\n  { [Measures].[Unit Sales] } ON COLUMNS,\n  { TopCount([Product].[Product Department].Members,3),\n              [Product].[All Products].[Non-Consumable].[Other] } ON ROWS\nFROM [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Product].[All Products].[Drink].[Beverages]}\n{[Product].[All Products].[Drink].[Dairy]}\n{[Product].[All Products].[Non-Consumable].[Other]}\nRow #0: 6,838\nRow #1: 13,573\nRow #2: 4,186\nRow #3: 242,176\n"));
    }

    public void testBug714707() {
        this.assertAxisReturns("{[Store].[USA].[CA].children, [Store].[USA]}", FunctionTest.fold("[Store].[All Stores].[USA].[CA].[Alameda]\n[Store].[All Stores].[USA].[CA].[Beverly Hills]\n[Store].[All Stores].[USA].[CA].[Los Angeles]\n[Store].[All Stores].[USA].[CA].[San Diego]\n[Store].[All Stores].[USA].[CA].[San Francisco]\n[Store].[All Stores].[USA]"));
    }

    public void testBug715177c() {
        this.assertAxisReturns("Order(TopCount({[Store].[USA].[CA].children}, [Measures].[Unit Sales], 2), [Measures].[Unit Sales])", FunctionTest.fold("[Store].[All Stores].[USA].[CA].[Alameda]\n[Store].[All Stores].[USA].[CA].[San Francisco]\n[Store].[All Stores].[USA].[CA].[Beverly Hills]\n[Store].[All Stores].[USA].[CA].[San Diego]\n[Store].[All Stores].[USA].[CA].[Los Angeles]"));
    }

    public void testFormatFixed() {
        this.assertExprReturns("Format(12.2, \"#,##0.00\")", "12.20");
    }

    public void testFormatVariable() {
        this.assertExprReturns("Format(1234.5, \"#,#\" || \"#0.00\")", "1,234.50");
    }

    public void testFormatMember() {
        this.assertExprReturns("Format([Store].[USA].[CA], \"#,#\" || \"#0.00\")", "74,748.00");
    }

    public void testIIf() {
        this.assertExprReturns("IIf(([Measures].[Unit Sales],[Product].[Drink].[Alcoholic Beverages].[Beer and Wine]) > 100, \"Yes\",\"No\")", "Yes");
    }

    public void testIIfWithNullAndNumber() {
        this.assertExprReturns("IIf(([Measures].[Unit Sales],[Product].[Drink].[Alcoholic Beverages].[Beer and Wine]) > 100, null,20)", "");
        this.assertExprReturns("IIf(([Measures].[Unit Sales],[Product].[Drink].[Alcoholic Beverages].[Beer and Wine]) > 100, 20,null)", "20");
    }

    public void testIIfWithStringAndNull() {
        this.assertExprReturns("IIf(([Measures].[Unit Sales],[Product].[Drink].[Alcoholic Beverages].[Beer and Wine]) > 100, null,\"foo\")", "");
        this.assertExprReturns("IIf(([Measures].[Unit Sales],[Product].[Drink].[Alcoholic Beverages].[Beer and Wine]) > 100, \"foo\",null)", "foo");
    }

    public void testIsEmptyWithNull() {
        this.assertExprReturns("iif (isempty(null), \"is empty\", \"not is empty\")", "is empty");
        this.assertExprReturns("iif (isempty(null), 1, 2)", "1");
    }

    public void testIIfMember() {
        this.assertAxisReturns("IIf(1 > 2,[Store].[USA],[Store].[Canada].[BC])", "[Store].[All Stores].[Canada].[BC]");
    }

    public void testIIfLevel() {
        this.assertExprReturns("IIf(1 > 2, [Store].[Store Country],[Store].[Store City]).Name", "Store City");
    }

    public void testIIfHierarchy() {
        this.assertExprReturns("IIf(1 > 2, [Time], [Store]).Name", "Store");
        this.assertExprReturns("IIf(1 > 2, [Time], [Time.Weekly]).Name", "Time");
    }

    public void testIIfDimension() {
        this.assertExprReturns("IIf(1 > 2, [Store], [Time]).Name", "Time");
    }

    public void testIIfSet() {
        this.assertAxisReturns("IIf(1 > 2, {[Store].[USA], [Store].[USA].[CA]}, {[Store].[Mexico], [Store].[USA].[OR]})", FunctionTest.fold("[Store].[All Stores].[Mexico]\n[Store].[All Stores].[USA].[OR]"));
    }

    public void testDimensionCaption() {
        this.assertExprReturns("[Time].[1997].Dimension.Caption", "Time");
    }

    public void testHierarchyCaption() {
        this.assertExprReturns("[Time].[1997].Hierarchy.Caption", "Time");
    }

    public void testLevelCaption() {
        this.assertExprReturns("[Time].[1997].Level.Caption", "Year");
    }

    public void testMemberCaption() {
        this.assertExprReturns("[Time].[1997].Caption", "1997");
    }

    public void testDimensionName() {
        this.assertExprReturns("[Time].[1997].Dimension.Name", "Time");
    }

    public void testHierarchyName() {
        this.assertExprReturns("[Time].[1997].Hierarchy.Name", "Time");
    }

    public void testLevelName() {
        this.assertExprReturns("[Time].[1997].Level.Name", "Year");
    }

    public void testMemberName() {
        this.assertExprReturns("[Time].[1997].Name", "1997");
        this.assertExprReturns("[Store].Name", "Store");
        this.assertExprReturns("[Store].DefaultMember.Name", "All Stores");
        if (this.isDefaultNullMemberRepresentation()) {
            this.assertExprReturns("[Store].Parent.Name", "#null");
        }
    }

    public void testDimensionUniqueName() {
        this.assertExprReturns("[Gender].DefaultMember.Dimension.UniqueName", "[Gender]");
    }

    public void testHierarchyUniqueName() {
        this.assertExprReturns("[Gender].DefaultMember.Hierarchy.UniqueName", "[Gender]");
    }

    public void testLevelUniqueName() {
        this.assertExprReturns("[Gender].DefaultMember.Level.UniqueName", "[Gender].[(All)]");
    }

    public void testMemberUniqueName() {
        this.assertExprReturns("[Gender].DefaultMember.UniqueName", "[Gender].[All Gender]");
    }

    public void testMemberUniqueNameOfNull() {
        if (this.isDefaultNullMemberRepresentation()) {
            this.assertExprReturns("[Measures].[Unit Sales].FirstChild.UniqueName", "[Measures].[#null]");
        }
    }

    public void testCoalesceEmptyDepends() {
        this.getTestContext().assertExprDependsOn("coalesceempty([Time].[1997], [Gender].[M])", TestContext.allDims());
        String s1 = TestContext.allDimsExcept("[Measures]", "[Time]");
        this.getTestContext().assertExprDependsOn("coalesceempty(([Measures].[Unit Sales], [Time].[1997]), ([Measures].[Store Sales], [Time].[1997].[Q2]))", s1);
    }

    public void testCoalesceEmpty() {
        Result result = this.executeQuery("with\n    member Measures.[Coal1] as 'coalesceempty(([Time].[1997], Measures.[Store Sales]), ([Time].[1998], Measures.[Store Sales]))'\n    member Measures.[Coal2] as 'coalesceempty(([Time].[1997], Measures.[Unit Sales]), ([Time].[1998], Measures.[Unit Sales]))'\nselect \n    {Measures.[Coal1], Measures.[Coal2]} on columns,\n    {[Store].[All Stores].[Mexico].[DF], [Store].[All Stores].[USA].[WA]} on rows\nfrom \n    [Sales]");
        this.checkDataResults(new Double[][]{{null, null}, {new Double(263793.22), new Double(124366.0)}}, result, 0.001);
        result = this.executeQuery("with\n    member Measures.[Sales Per Customer] as 'Measures.[Sales Count] / Measures.[Customer Count]'\n    member Measures.[Coal] as 'coalesceempty(([Measures].[Sales Per Customer], [Store].[All Stores].[Mexico].[DF]),\n        Measures.[Sales Per Customer])'\nselect \n    {Measures.[Sales Per Customer], Measures.[Coal]} on columns,\n    {[Store].[All Stores].[Mexico].[DF], [Store].[All Stores].[USA].[WA]} on rows\nfrom \n    [Sales]\nwhere\n    ([Time].[1997].[Q2])");
        this.checkDataResults(new Double[][]{{null, null}, {new Double(8.963), new Double(8.963)}}, result, 0.001);
        result = this.executeQuery("with\n    member Measures.[Sales Per Customer] as 'Measures.[Sales Count] / Measures.[Customer Count]'\n    member Measures.[Coal] as 'coalesceempty(([Measures].[Sales Per Customer], [Store].[All Stores].[Mexico].[DF]),\n        ([Measures].[Sales Per Customer], [Store].[All Stores].[Mexico].[DF]),\n        ([Measures].[Sales Per Customer], [Store].[All Stores].[Mexico].[DF]),\n        ([Measures].[Sales Per Customer], [Store].[All Stores].[Mexico].[DF]),\n        ([Measures].[Sales Per Customer], [Store].[All Stores].[Mexico].[DF]),\n        ([Measures].[Sales Per Customer], [Store].[All Stores].[Mexico].[DF]),\n        ([Measures].[Sales Per Customer], [Store].[All Stores].[Mexico].[DF]),\n        ([Measures].[Sales Per Customer], [Store].[All Stores].[Mexico].[DF]),\n        Measures.[Sales Per Customer])'\nselect \n    {Measures.[Sales Per Customer], Measures.[Coal]} on columns,\n    {[Store].[All Stores].[Mexico].[DF], [Store].[All Stores].[USA].[WA]} on rows\nfrom \n    [Sales]\nwhere\n    ([Time].[1997].[Q2])");
        this.checkDataResults(new Double[][]{{null, null}, {new Double(8.963), new Double(8.963)}}, result, 0.001);
    }

    public void testBrokenContextBug() {
        Result result = this.executeQuery("with\n    member Measures.[Sales Per Customer] as 'Measures.[Sales Count] / Measures.[Customer Count]'\n    member Measures.[Coal] as 'coalesceempty(([Measures].[Sales Per Customer], [Store].[All Stores].[Mexico].[DF]),\n        Measures.[Sales Per Customer])'\nselect \n    {Measures.[Coal]} on columns,\n    {[Store].[All Stores].[USA].[WA]} on rows\nfrom \n    [Sales]\nwhere\n    ([Time].[1997].[Q2])");
        this.checkDataResults(new Double[][]{{new Double(8.963)}}, result, 0.001);
    }

    public void testSetItemInt() {
        this.assertAxisReturns("{[Customers].[All Customers].[USA].[OR].[Lebanon].[Mary Frances Christian]}.Item(0)", "[Customers].[All Customers].[USA].[OR].[Lebanon].[Mary Frances Christian]");
        this.assertAxisReturns("{[Customers].[All Customers].[USA],[Customers].[All Customers].[USA].[WA],[Customers].[All Customers].[USA].[CA],[Customers].[All Customers].[USA].[OR].[Lebanon].[Mary Frances Christian]}.Item(2)", "[Customers].[All Customers].[USA].[CA]");
        this.assertAxisReturns("{[Customers].[All Customers].[USA],[Customers].[All Customers].[USA].[WA],[Customers].[All Customers].[USA].[CA],[Customers].[All Customers].[USA].[OR].[Lebanon].[Mary Frances Christian]}.Item(100 / 50 - 1)", "[Customers].[All Customers].[USA].[WA]");
        this.assertAxisReturns("{([Time].[1997].[Q1].[1], [Customers].[All Customers].[USA]),([Time].[1997].[Q1].[2], [Customers].[All Customers].[USA].[WA]),([Time].[1997].[Q1].[3], [Customers].[All Customers].[USA].[CA]),([Time].[1997].[Q2].[4], [Customers].[All Customers].[USA].[OR].[Lebanon].[Mary Frances Christian])}.Item(100 / 50 - 1)", "{[Time].[1997].[Q1].[2], [Customers].[All Customers].[USA].[WA]}");
        this.assertAxisReturns("{[Customers].[All Customers].[USA],[Customers].[All Customers].[USA].[WA],[Customers].[All Customers].[USA].[CA],[Customers].[All Customers].[USA].[OR].[Lebanon].[Mary Frances Christian]}.Item(-1)", "");
        this.assertAxisReturns("{[Customers].[All Customers].[USA],[Customers].[All Customers].[USA].[WA],[Customers].[All Customers].[USA].[CA],[Customers].[All Customers].[USA].[OR].[Lebanon].[Mary Frances Christian]}.Item(4)", "");
    }

    public void testSetItemString() {
        this.assertAxisReturns("{[Gender].[M], [Gender].[F]}.Item(\"M\")", "[Gender].[All Gender].[M]");
        this.assertAxisReturns("{CrossJoin([Gender].Members, [Marital Status].Members)}.Item(\"M\", \"S\")", "{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S]}");
        this.assertAxisReturns("{CrossJoin([Gender].Members, [Marital Status].Members)}.Item(\"M\", \"M\")", "{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M]}");
        this.assertAxisReturns("{[Gender].[M], [Gender].[F]}.Item(\"X\")", "");
        this.assertAxisReturns("{CrossJoin([Gender].Members, [Marital Status].Members)}.Item(\"M\", \"F\")", "");
        this.assertAxisReturns("CrossJoin([Gender].Members, [Marital Status].Members).Item(\"S\", \"M\")", "");
        this.assertAxisThrows("CrossJoin([Gender].Members, [Marital Status].Members).Item(\"M\")", "Argument count does not match set's cardinality 2");
    }

    public void testTuple() {
        this.assertExprReturns("([Gender].[M], [Time].Children.Item(2), [Measures].[Unit Sales])", "33,249");
        this.assertExprCompilesTo("([Gender].[M], [Time].Children.Item(2), [Measures].[Unit Sales])", "MemberValueCalc([Gender].[All Gender].[M], Item(Children(CurrentMember([Time])), 2), [Measures].[Unit Sales])");
    }

    public void testTupleArgTypes() {
        this.assertExprReturns("([Gender], [Time])", "266,773");
        this.assertExprReturns("([Gender].[M], [Time.Weekly])", "135,215");
        this.assertAxisThrows("{([Gender].[M], [Store].[Store City])}", "No function matches signature '(<Member>, <Level>)'");
        this.assertAxisReturns("{([Time.Weekly], [Measures].[Store Sales], [Marital Status].[M], [Promotion Media])}", "{[Time].[Weekly].[All Weeklys], [Measures].[Store Sales], [Marital Status].[All Marital Status].[M], [Promotion Media].[All Media]}");
        this.assertAxisThrows("{([Time.Weekly], [Measures].[Store Sales], [Marital Status].[M], [Time])}", "Tuple contains more than one member of dimension '[Time]'.");
        this.assertAxisThrows("{([Gender].[M], 123)}", "No function matches signature '(<Member>, <Numeric Expression>)'");
    }

    public void testTupleItem() {
        this.assertAxisReturns("([Time].[1997].[Q1].[1], [Customers].[All Customers].[USA].[OR], [Gender].[All Gender].[M]).item(2)", "[Gender].[All Gender].[M]");
        this.assertAxisReturns("([Time].[1997].[Q1].[1], [Customers].[All Customers].[USA].[OR], [Gender].[All Gender].[M]).item(1)", "[Customers].[All Customers].[USA].[OR]");
        this.assertAxisReturns("{[Time].[1997].[Q1].[1]}.item(0)", "[Time].[1997].[Q1].[1]");
        this.assertAxisReturns("{[Time].[1997].[Q1].[1]}.Item(0).Item(0)", "[Time].[1997].[Q1].[1]");
        this.assertAxisReturns("([Time].[1997].[Q1].[1], [Customers].[All Customers].[USA].[OR], [Gender].[All Gender].[M]).item(-1)", "");
        this.assertAxisReturns("([Time].[1997].[Q1].[1], [Customers].[All Customers].[USA].[OR], [Gender].[All Gender].[M]).item(500)", "");
        this.assertExprReturns("Filter([Gender].members, 1 = 0).Item(0)", "");
        this.assertExprReturns("{}.Item(3)", "");
        this.assertExprReturns("{[Gender].members}.Item(4)", "");
        this.assertExprReturns("{[Gender].members}.Item(-50)", "");
    }

    public void testTupleAppliedToUnknownHierarchy() {
        this.assertQueryReturns("with \nmember [Product].[Test] as '([Product].[Food],Dimensions(0).defaultMember)' \nselect \n{[Product].[Test], [Product].[Food]} on columns, \n{[Measures].[Store Sales]} on rows \nfrom Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Product].[Test]}\n{[Product].[All Products].[Food]}\nAxis #2:\n{[Measures].[Store Sales]}\nRow #0: 191,940.00\nRow #0: 409,035.59\n"));
    }

    public void testTupleDepends() {
        this.getTestContext().assertMemberExprDependsOn("([Store].[USA], [Gender].[F])", "{}");
        this.getTestContext().assertMemberExprDependsOn("([Store].[USA], [Gender])", "{[Gender]}");
        this.getTestContext().assertExprDependsOn("([Store].[USA], [Gender])", TestContext.allDimsExcept("[Store]"));
        this.getTestContext().assertExprDependsOn("(Dimensions('Store').CurrentMember, [Gender].[F])", TestContext.allDims());
    }

    public void testItemNull() {
        this.assertExprReturns("Filter([Gender].members, 1 = 0).Item(0).Dimension.Name", "Gender");
        this.assertExprReturns("Filter([Gender].members, 1 = 0).Item(0).Parent", "");
        this.assertExprReturns("(Filter([Store].members, 0 = 0).Item(0).Item(0),Filter([Store].members, 0 = 0).Item(0).Item(0))", "266,773");
        if (this.isDefaultNullMemberRepresentation()) {
            this.assertExprReturns("Filter([Gender].members, 1 = 0).Item(0).Name", "#null");
        }
    }

    public void testTupleNull() {
        this.assertQueryReturns("select {[Measures].[Unit Sales]} on columns,\n { ([Gender].[M], [Store]),\n   ([Gender].[F], [Store].parent),\n   ([Gender].parent, [Store])} on rows\nfrom [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Gender].[All Gender].[M], [Store].[All Stores]}\nRow #0: 135,215\n"));
        this.assertAxisReturns("([Gender].parent, [Marital Status]),\n ([Gender].[M], [Marital Status].parent),\n ([Gender].parent, [Marital Status].parent),\n ([Gender].[M], [Marital Status])", "{[Gender].[All Gender].[M], [Marital Status].[All Marital Status]}");
        if (this.isDefaultNullMemberRepresentation()) {
            this.assertExprReturns("([Gender].parent, [Marital Status]).Item(0).Name", "#null");
            this.assertExprReturns("([Gender].parent, [Marital Status]).Item(1).Name", "#null");
        }
    }

    private void checkDataResults(Double[][] expected, Result result, double tolerance) {
        int[] coords = new int[2];
        for (int row = 0; row < expected.length; ++row) {
            coords[1] = row;
            for (int col = 0; col < expected[0].length; ++col) {
                coords[0] = col;
                Cell cell = result.getCell(coords);
                Double expectedValue = expected[row][col];
                if (expectedValue == null) {
                    FunctionTest.assertTrue((String)"Expected null value", (boolean)cell.isNull());
                    continue;
                }
                if (cell.isNull()) {
                    FunctionTest.fail((String)("Cell at (" + row + ", " + col + ") was null, but was expecting " + expectedValue));
                    continue;
                }
                FunctionTest.assertEquals((String)("Incorrect value returned at (" + row + ", " + col + ")"), (double)expectedValue, (double)((Number)cell.getValue()).doubleValue(), (double)tolerance);
            }
        }
    }

    public void testLevelMemberExpressions() {
        this.assertAxisReturns("[Store].[Store City].[Beverly Hills]", "[Store].[All Stores].[USA].[CA].[Beverly Hills]");
        this.assertAxisReturns("[Time].[Month].[1]", "[Time].[1997].[Q1].[1]");
        this.assertAxisThrows("[Time].[Month].[Q1]", "MDX object '[Time].[Month].[Q1]' not found in cube");
    }

    public void testCaseTestMatch() {
        this.assertExprReturns("CASE WHEN 1=0 THEN \"first\" WHEN 1=1 THEN \"second\" WHEN 1=2 THEN \"third\" ELSE \"fourth\" END", "second");
    }

    public void testCaseTestMatchElse() {
        this.assertExprReturns("CASE WHEN 1=0 THEN \"first\" ELSE \"fourth\" END", "fourth");
    }

    public void testCaseTestMatchNoElse() {
        this.assertExprReturns("CASE WHEN 1=0 THEN \"first\" END", "");
    }

    public void testCaseTestReturnsMemberBug1799391() {
        this.assertQueryReturns("WITH\n MEMBER [Product].[CaseTest] AS\n 'CASE\n WHEN [Gender].CurrentMember IS [Gender].[M] THEN [Gender].[F]\n ELSE [Gender].[F]\n END'\n                \nSELECT {[Product].[CaseTest]} ON 0, {[Gender].[M]} ON 1 FROM Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Product].[CaseTest]}\nAxis #2:\n{[Gender].[All Gender].[M]}\nRow #0: 131,558\n"));
        this.assertAxisReturns("CASE WHEN 1+1 = 2 THEN [Gender].[F] ELSE [Gender].[F].Parent END", "[Gender].[All Gender].[F]");
        this.assertAxisReturns("CASE 1 WHEN 2 THEN [Gender].[F] ELSE [Gender].[F].Parent END", "[Gender].[All Gender]");
    }

    public void testCaseMatch() {
        this.assertExprReturns("CASE 2 WHEN 1 THEN \"first\" WHEN 2 THEN \"second\" WHEN 3 THEN \"third\" ELSE \"fourth\" END", "second");
    }

    public void testCaseMatchElse() {
        this.assertExprReturns("CASE 7 WHEN 1 THEN \"first\" ELSE \"fourth\" END", "fourth");
    }

    public void testCaseMatchNoElse() {
        this.assertExprReturns("CASE 8 WHEN 0 THEN \"first\" END", "");
    }

    public void testCaseTypeMismatch() {
        this.assertAxisThrows("CASE 1 WHEN 1 THEN 2 ELSE \"foo\" END", "No function matches signature");
        this.assertAxisThrows("CASE 1 WHEN 1 THEN 2 WHEN 2 THEN \"foo\" ELSE 3 END", "No function matches signature");
        this.assertAxisThrows("CASE 1 WHEN \"foo\" THEN 2 ELSE 3 END", "No function matches signature");
        this.assertAxisThrows("CASE WHEN 1 = 2 THEN 3 WHEN 4 THEN 5 ELSE 6 END", "No function matches signature");
    }

    public void testPropertiesExpr() {
        this.assertExprReturns("[Store].[USA].[CA].[Beverly Hills].[Store 6].Properties(\"Store Type\")", "Gourmet Supermarket");
    }

    public void testPropertiesNonExistent() {
        this.assertExprThrows("[Store].[USA].[CA].[Beverly Hills].[Store 6].Properties(\"Foo\")", "Property 'Foo' is not valid for");
    }

    public void testPropertiesFilter() {
        Result result = this.executeQuery("SELECT { [Store Sales] } ON COLUMNS,\n TOPCOUNT(Filter( [Store].[Store Name].Members,\n                   [Store].CurrentMember.Properties(\"Store Type\") = \"Supermarket\"),\n           10, [Store Sales]) ON ROWS\nFROM [Sales]");
        Assert.assertEquals((int)8, (int)result.getAxes()[1].getPositions().size());
    }

    public void testPropertyInCalculatedMember() {
        Result result = this.executeQuery("WITH MEMBER [Measures].[Store Sales per Sqft]\nAS '[Measures].[Store Sales] /   [Store].CurrentMember.Properties(\"Store Sqft\")'\nSELECT \n  {[Measures].[Unit Sales], [Measures].[Store Sales per Sqft]} ON COLUMNS,\n  {[Store].[Store Name].members} ON ROWS\nFROM Sales");
        Member member = (Member)result.getAxes()[1].getPositions().get(18).get(0);
        Assert.assertEquals((String)"[Store].[All Stores].[USA].[WA].[Bellingham].[Store 2]", (String)member.getUniqueName());
        Cell cell = result.getCell(new int[]{0, 18});
        Assert.assertEquals((String)"2,237", (String)cell.getFormattedValue());
        cell = result.getCell(new int[]{1, 18});
        Assert.assertEquals((String)".17", (String)cell.getFormattedValue());
        member = (Member)result.getAxes()[1].getPositions().get(3).get(0);
        Assert.assertEquals((String)"[Store].[All Stores].[Mexico].[DF].[San Andres].[Store 21]", (String)member.getUniqueName());
        cell = result.getCell(new int[]{0, 3});
        Assert.assertEquals((String)"", (String)cell.getFormattedValue());
        cell = result.getCell(new int[]{1, 3});
        Assert.assertEquals((String)"", (String)cell.getFormattedValue());
    }

    public void testOpeningPeriod() {
        this.assertAxisReturns("OpeningPeriod([Time].[Month], [Time].[1997].[Q3])", "[Time].[1997].[Q3].[7]");
        this.assertAxisReturns("OpeningPeriod([Time].[Quarter], [Time].[1997])", "[Time].[1997].[Q1]");
        this.assertAxisReturns("OpeningPeriod([Time].[Year], [Time].[1997])", year1997);
        this.assertAxisReturns("OpeningPeriod([Time].[Month], [Time].[1997])", "[Time].[1997].[Q1].[1]");
        this.assertAxisReturns("OpeningPeriod([Product].[Product Name], [Product].[All Products].[Drink])", "[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]");
        this.getTestContext().withCube("[Sales Ragged]").assertAxisReturns("OpeningPeriod([Store].[Store City], [Store].[All Stores].[Israel])", "[Store].[All Stores].[Israel].[Israel].[Haifa]");
        this.getTestContext().withCube("[Sales Ragged]").assertAxisReturns("OpeningPeriod([Store].[Store State], [Store].[All Stores].[Israel])", "");
        this.assertAxisReturns("OpeningPeriod([Time].[Month])", "[Time].[1997].[Q1].[1]");
        this.assertAxisReturns("OpeningPeriod()", "[Time].[1997].[Q1]");
        TestContext testContext = this.getTestContext().withCube("[Sales Ragged]");
        testContext.assertAxisThrows("OpeningPeriod([Time].[Year], [Store].[All Stores].[Israel])", "The <level> and <member> arguments to OpeningPeriod must be from the same hierarchy. The level was from '[Time]' but the member was from '[Store]'.");
        this.assertAxisThrows("OpeningPeriod([Store].[Store City])", "The <level> and <member> arguments to OpeningPeriod must be from the same hierarchy. The level was from '[Store]' but the member was from '[Time]'.");
    }

    public void testOpeningPeriodNull() {
        this.assertAxisThrows("OpeningPeriod([Time].[Month], NULL)", "Mondrian Error:Failed to parse query 'select {OpeningPeriod([Time].[Month], NULL)} on columns from Sales'");
    }

    public void testLastPeriods() {
        this.assertAxisReturns("LastPeriods(0, [Time].[1998])", "");
        this.assertAxisReturns("LastPeriods(1, [Time].[1998])", "[Time].[1998]");
        this.assertAxisReturns("LastPeriods(-1, [Time].[1998])", "[Time].[1998]");
        this.assertAxisReturns("LastPeriods(2, [Time].[1998])", FunctionTest.fold("[Time].[1997]\n[Time].[1998]"));
        this.assertAxisReturns("LastPeriods(-2, [Time].[1997])", FunctionTest.fold("[Time].[1997]\n[Time].[1998]"));
        this.assertAxisReturns("LastPeriods(5000, [Time].[1998])", FunctionTest.fold("[Time].[1997]\n[Time].[1998]"));
        this.assertAxisReturns("LastPeriods(-5000, [Time].[1997])", FunctionTest.fold("[Time].[1997]\n[Time].[1998]"));
        this.assertAxisReturns("LastPeriods(2, [Time].[1998].[Q2])", FunctionTest.fold("[Time].[1998].[Q1]\n[Time].[1998].[Q2]"));
        this.assertAxisReturns("LastPeriods(4, [Time].[1998].[Q2])", FunctionTest.fold("[Time].[1997].[Q3]\n[Time].[1997].[Q4]\n[Time].[1998].[Q1]\n[Time].[1998].[Q2]"));
        this.assertAxisReturns("LastPeriods(-2, [Time].[1997].[Q2])", FunctionTest.fold("[Time].[1997].[Q2]\n[Time].[1997].[Q3]"));
        this.assertAxisReturns("LastPeriods(-4, [Time].[1997].[Q2])", FunctionTest.fold("[Time].[1997].[Q2]\n[Time].[1997].[Q3]\n[Time].[1997].[Q4]\n[Time].[1998].[Q1]"));
        this.assertAxisReturns("LastPeriods(5000, [Time].[1998].[Q2])", FunctionTest.fold("[Time].[1997].[Q1]\n[Time].[1997].[Q2]\n[Time].[1997].[Q3]\n[Time].[1997].[Q4]\n[Time].[1998].[Q1]\n[Time].[1998].[Q2]"));
        this.assertAxisReturns("LastPeriods(-5000, [Time].[1998].[Q2])", FunctionTest.fold("[Time].[1998].[Q2]\n[Time].[1998].[Q3]\n[Time].[1998].[Q4]"));
        this.assertAxisReturns("LastPeriods(2, [Time].[1998].[Q2].[5])", FunctionTest.fold("[Time].[1998].[Q2].[4]\n[Time].[1998].[Q2].[5]"));
        this.assertAxisReturns("LastPeriods(12, [Time].[1998].[Q2].[5])", FunctionTest.fold("[Time].[1997].[Q2].[6]\n[Time].[1997].[Q3].[7]\n[Time].[1997].[Q3].[8]\n[Time].[1997].[Q3].[9]\n[Time].[1997].[Q4].[10]\n[Time].[1997].[Q4].[11]\n[Time].[1997].[Q4].[12]\n[Time].[1998].[Q1].[1]\n[Time].[1998].[Q1].[2]\n[Time].[1998].[Q1].[3]\n[Time].[1998].[Q2].[4]\n[Time].[1998].[Q2].[5]"));
        this.assertAxisReturns("LastPeriods(-2, [Time].[1998].[Q2].[4])", FunctionTest.fold("[Time].[1998].[Q2].[4]\n[Time].[1998].[Q2].[5]"));
        this.assertAxisReturns("LastPeriods(-12, [Time].[1997].[Q2].[6])", FunctionTest.fold("[Time].[1997].[Q2].[6]\n[Time].[1997].[Q3].[7]\n[Time].[1997].[Q3].[8]\n[Time].[1997].[Q3].[9]\n[Time].[1997].[Q4].[10]\n[Time].[1997].[Q4].[11]\n[Time].[1997].[Q4].[12]\n[Time].[1998].[Q1].[1]\n[Time].[1998].[Q1].[2]\n[Time].[1998].[Q1].[3]\n[Time].[1998].[Q2].[4]\n[Time].[1998].[Q2].[5]"));
        this.assertAxisReturns("LastPeriods(2, [Gender].[M])", FunctionTest.fold("[Gender].[All Gender].[F]\n[Gender].[All Gender].[M]"));
        this.assertAxisReturns("LastPeriods(-2, [Gender].[F])", FunctionTest.fold("[Gender].[All Gender].[F]\n[Gender].[All Gender].[M]"));
        this.assertAxisReturns("LastPeriods(2, [Gender])", "[Gender].[All Gender]");
        this.assertAxisReturns("LastPeriods(2, [Gender].Parent)", "");
    }

    public void testParallelPeriod() {
        this.assertAxisReturns("parallelperiod([Time].[Quarter], 1, [Time].[1998].[Q1])", "[Time].[1997].[Q4]");
        this.assertAxisReturns("parallelperiod([Time].[Quarter], -1, [Time].[1997].[Q1])", "[Time].[1997].[Q2]");
        this.assertAxisReturns("parallelperiod([Time].[Year], 1, [Time].[1998].[Q1])", "[Time].[1997].[Q1]");
        this.assertAxisReturns("parallelperiod([Time].[Year], 1, [Time].[1998].[Q1].[1])", "[Time].[1997].[Q1].[1]");
        this.assertAxisReturns("ParallelPeriod()", "");
        this.assertAxisReturns("ParallelPeriod([Time].[Year], 1, [Time].[1997])", "");
        if (this.isDefaultNullMemberRepresentation()) {
            this.assertQueryReturns("WITH MEMBER [Measures].[Foo] AS \n ' ParallelPeriod([Time].[Year]).UniqueName '\nSELECT {[Measures].[Foo]} ON COLUMNS\nFROM [Sales]\nWHERE [Time].[1997].[Q3].[8]", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q3].[8]}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: [Time].[#null]\n"));
        }
        this.assertQueryReturns("WITH MEMBER [Measures].[Foo] AS \n ' ParallelPeriod([Time].[Quarter]).UniqueName '\nSELECT {[Measures].[Foo]} ON COLUMNS\nFROM [Sales]\nWHERE [Time].[1997].[Q3].[8]", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q3].[8]}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: [Time].[1997].[Q2].[5]\n"));
        this.assertQueryReturns("WITH MEMBER [Measures].[Foo] AS \n ' ParallelPeriod([Time].[Month]).UniqueName '\nSELECT {[Measures].[Foo]} ON COLUMNS\nFROM [Sales]\nWHERE [Time].[1997].[Q3].[8]", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q3].[8]}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: [Time].[1997].[Q3].[7]\n"));
        if (this.isDefaultNullMemberRepresentation()) {
            this.assertQueryReturns("WITH MEMBER [Measures].[Foo] AS \n ' ParallelPeriod([Time].[Month]).UniqueName '\nSELECT {[Measures].[Foo]} ON COLUMNS\nFROM [Sales]\nWHERE [Time].[1997].[Q3]", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q3]}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: [Time].[#null]\n"));
        }
    }

    public void _testParallelPeriodThrowsException() {
        this.assertThrows("select {parallelperiod([Time].[Year], 1)} on columns from [Sales] where ([Time].[1998].[Q1].[2])", "This should say something about Time appearing on two different axes (slicer an columns)");
    }

    public void testParallelPeriodDepends() {
        this.getTestContext().assertMemberExprDependsOn("ParallelPeriod([Time].[Quarter], 2.0)", "{[Time]}");
        this.getTestContext().assertMemberExprDependsOn("ParallelPeriod([Time].[Quarter], 2.0, [Time].[1997].[Q3])", "{}");
        this.getTestContext().assertMemberExprDependsOn("ParallelPeriod()", "{[Time]}");
        this.getTestContext().assertMemberExprDependsOn("ParallelPeriod([Product].[Food])", "{[Product]}");
        String s1 = TestContext.allDimsExcept("[Gender]");
        this.getTestContext().assertMemberExprDependsOn("ParallelPeriod([Product].[Product Family], [Gender].[M], [Product].[Food])", s1);
        String s11 = TestContext.allDimsExcept("[Gender]");
        this.getTestContext().assertMemberExprDependsOn("ParallelPeriod([Product].[Product Family], [Gender].[M])", s11);
        this.getTestContext().assertSetExprDependsOn("parallelperiod([Time].CurrentMember)", "{[Time]}");
    }

    public void testParallelPeriodLevelLag() {
        this.assertQueryReturns("with member [Measures].[Prev Unit Sales] as         '([Measures].[Unit Sales], parallelperiod([Time].[Quarter], 2))' select     crossjoin({[Measures].[Unit Sales], [Measures].[Prev Unit Sales]}, {[Marital Status].[All Marital Status].children}) on columns,     {[Time].[1997].[Q3]} on rows from      [Sales] ", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales], [Marital Status].[All Marital Status].[M]}\n{[Measures].[Unit Sales], [Marital Status].[All Marital Status].[S]}\n{[Measures].[Prev Unit Sales], [Marital Status].[All Marital Status].[M]}\n{[Measures].[Prev Unit Sales], [Marital Status].[All Marital Status].[S]}\nAxis #2:\n{[Time].[1997].[Q3]}\nRow #0: 32,815\nRow #0: 33,033\nRow #0: 33,101\nRow #0: 33,190\n"));
    }

    public void testParallelPeriodLevel() {
        this.assertQueryReturns("with     member [Measures].[Prev Unit Sales] as         '([Measures].[Unit Sales], parallelperiod([Time].[Quarter]))' select     crossjoin({[Measures].[Unit Sales], [Measures].[Prev Unit Sales]}, {[Marital Status].[All Marital Status].[M]}) on columns,     {[Time].[1997].[Q3].[8]} on rows from      [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales], [Marital Status].[All Marital Status].[M]}\n{[Measures].[Prev Unit Sales], [Marital Status].[All Marital Status].[M]}\nAxis #2:\n{[Time].[1997].[Q3].[8]}\nRow #0: 10,957\nRow #0: 10,280\n"));
    }

    public void testPlus() {
        this.getTestContext().assertExprDependsOn("1 + 2", "{}");
        String s1 = TestContext.allDimsExcept("[Measures]", "[Gender]");
        this.getTestContext().assertExprDependsOn("([Measures].[Unit Sales], [Gender].[F]) + 2", s1);
        this.assertExprReturns("1+2", "3");
        this.assertExprReturns("5 +  ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer])", "5");
        this.assertExprReturns(" ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]) +  ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer])", "");
        this.assertExprReturns(" ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]) + 0", "0");
    }

    public void testMinus() {
        this.assertExprReturns("1-3", "-2");
        this.assertExprReturns("5 -  ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer])", "5");
        this.assertExprReturns(" ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]) - - 2", "2");
        this.assertExprReturns(" ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]) -  ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer])", "");
    }

    public void testMinus_bug1234759() {
        this.assertQueryReturns("WITH MEMBER [Customers].[USAMinusMexico]\nAS '([Customers].[All Customers].[USA] - [Customers].[All Customers].[Mexico])'\nSELECT {[Measures].[Unit Sales]} ON COLUMNS,\n{[Customers].[All Customers].[USA], [Customers].[All Customers].[Mexico],\n[Customers].[USAMinusMexico]} ON ROWS\nFROM [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Customers].[All Customers].[USA]}\n{[Customers].[All Customers].[Mexico]}\n{[Customers].[USAMinusMexico]}\nRow #0: 266,773\nRow #1: \nRow #2: 266,773\n"));
    }

    public void testMinusAssociativity() {
        this.assertExprReturns("11-7-5", "-1");
    }

    public void testMultiply() {
        this.assertExprReturns("4*7", "28");
        this.assertExprReturns("5 *  ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer])", "");
        this.assertExprReturns(" ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]) * - 2", "");
        this.assertExprReturns(" ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]) -  ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer])", "");
    }

    public void testMultiplyPrecedence() {
        this.assertExprReturns("3 + 4 * 5 + 6", "29");
        this.assertExprReturns("5 * 24 / 4 * 2", "60");
        this.assertExprReturns("48 / 4 / 2", "6");
    }

    public void testMultiplyBug774807() {
        String desiredResult = FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores]}\nAxis #2:\n{[Measures].[Store Sales]}\n{[Measures].[A]}\nRow #0: 565,238.13\nRow #1: 319,494,143,605.90\n");
        this.assertQueryReturns("WITH MEMBER [Measures].[A] AS\n '([Measures].[Store Sales] * [Measures].[Store Sales])'\nSELECT {[Store]} ON COLUMNS,\n {[Measures].[Store Sales], [Measures].[A]} ON ROWS\nFROM Sales", desiredResult);
        this.assertQueryReturns("WITH MEMBER [Measures].[A] AS\n '[Measures].[Store Sales] * [Measures].[Store Sales]'\nSELECT {[Store]} ON COLUMNS,\n {[Measures].[Store Sales], [Measures].[A]} ON ROWS\nFROM Sales", desiredResult);
        this.assertQueryReturns("WITH MEMBER [Measures].[A] AS\n '[Measures].[Store Sales] * [Measures].[Store Sales] + 0'\nSELECT {[Store]} ON COLUMNS,\n {[Measures].[Store Sales], [Measures].[A]} ON ROWS\nFROM Sales", desiredResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDivide() {
        this.assertExprReturns("10 / 5", "2");
        this.assertExprReturns(" ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]) / - 2", "");
        this.assertExprReturns(" ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]) /  ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer])", "");
        boolean origNullDenominatorProducesNull = MondrianProperties.instance().NullDenominatorProducesNull.get();
        try {
            MondrianProperties.instance().NullDenominatorProducesNull.set(false);
            this.assertExprReturns("-2 /  ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer])", "Infinity");
            this.assertExprReturns("0 / 0", "NaN");
            this.assertExprReturns("-3 / (2 - 2)", "-Infinity");
            this.assertExprReturns("NULL/1", "");
            this.assertExprReturns("NULL/NULL", "");
            this.assertExprReturns("1/NULL", "Infinity");
            MondrianProperties.instance().NullDenominatorProducesNull.set(true);
            this.assertExprReturns("-2 /  ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer])", "");
            this.assertExprReturns("0 / 0", "NaN");
            this.assertExprReturns("-3 / (2 - 2)", "-Infinity");
            this.assertExprReturns("NULL/1", "");
            this.assertExprReturns("NULL/NULL", "");
            this.assertExprReturns("1/NULL", "");
        }
        finally {
            MondrianProperties.instance().NullDenominatorProducesNull.set(origNullDenominatorProducesNull);
        }
    }

    public void testDividePrecedence() {
        this.assertExprReturns("24 / 4 / 2 * 10 - -1", "31");
    }

    public void testUnaryMinus() {
        this.assertExprReturns("-3", "-3");
    }

    public void testUnaryMinusMember() {
        this.assertExprReturns("- ([Measures].[Unit Sales],[Gender].[F])", "-131,558");
    }

    public void testUnaryMinusPrecedence() {
        this.assertExprReturns("1 - -10.5 * 2 -3", "19");
    }

    public void testNegativeZero() {
        this.assertExprReturns("-0.0", "0");
    }

    public void testNegativeZero1() {
        this.assertExprReturns("-(0.0)", "0");
    }

    public void testNegativeZeroSubtract() {
        this.assertExprReturns("-0.0 - 0.0", "0");
    }

    public void testNegativeZeroMultiply() {
        this.assertExprReturns("-1 * 0", "0");
    }

    public void testNegativeZeroDivide() {
        this.assertExprReturns("-0.0 / 2", "0");
    }

    public void testStringConcat() {
        this.assertExprReturns(" \"foo\" || \"bar\"  ", "foobar");
    }

    public void testStringConcat2() {
        this.assertExprReturns(" \"foo\" || [Gender].[M].Name || \"\" ", "fooM");
    }

    public void testAnd() {
        this.assertBooleanExprReturns(" 1=1 AND 2=2 ", true);
    }

    public void testAnd2() {
        this.assertBooleanExprReturns(" 1=1 AND 2=0 ", false);
    }

    public void testOr() {
        this.assertBooleanExprReturns(" 1=0 OR 2=0 ", false);
    }

    public void testOr2() {
        this.assertBooleanExprReturns(" 1=0 OR 0=0 ", true);
    }

    public void testOrAssociativity1() {
        this.assertBooleanExprReturns(" 1=1 AND 1=0 OR 1=1 ", true);
    }

    public void testOrAssociativity2() {
        this.assertBooleanExprReturns(" 1=1 OR 1=0 AND 1=1 ", true);
    }

    public void testOrAssociativity3() {
        this.assertBooleanExprReturns(" (1=0 OR 1=1) AND 1=1 ", true);
    }

    public void testXor() {
        this.assertBooleanExprReturns(" 1=1 XOR 2=2 ", false);
    }

    public void testXorAssociativity() {
        this.assertBooleanExprReturns(" 1 = 1 AND 1 = 1 XOR 1 = 0 ", true);
    }

    public void testNonEmptyCrossJoin() {
        String s1 = TestContext.allDimsExcept("[Store]");
        this.getTestContext().assertSetExprDependsOn("NonEmptyCrossJoin([Store].[USA].Children, [Gender].Children)", s1);
        this.assertAxisReturns("NonEmptyCrossJoin([Customers].[All Customers].[USA].[CA].Children, [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].Children)", FunctionTest.fold("{[Customers].[All Customers].[USA].[CA].[Bellflower], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Light Beer]}\n{[Customers].[All Customers].[USA].[CA].[Downey], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]}\n{[Customers].[All Customers].[USA].[CA].[Glendale], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]}\n{[Customers].[All Customers].[USA].[CA].[Glendale], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Light Beer]}\n{[Customers].[All Customers].[USA].[CA].[Grossmont], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Light Beer]}\n{[Customers].[All Customers].[USA].[CA].[Imperial Beach], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Light Beer]}\n{[Customers].[All Customers].[USA].[CA].[La Jolla], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]}\n{[Customers].[All Customers].[USA].[CA].[Lincoln Acres], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]}\n{[Customers].[All Customers].[USA].[CA].[Lincoln Acres], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Light Beer]}\n{[Customers].[All Customers].[USA].[CA].[Long Beach], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Light Beer]}\n{[Customers].[All Customers].[USA].[CA].[Los Angeles], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]}\n{[Customers].[All Customers].[USA].[CA].[Newport Beach], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]}\n{[Customers].[All Customers].[USA].[CA].[Pomona], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]}\n{[Customers].[All Customers].[USA].[CA].[Pomona], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Light Beer]}\n{[Customers].[All Customers].[USA].[CA].[San Gabriel], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Light Beer]}\n{[Customers].[All Customers].[USA].[CA].[West Covina], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]}\n{[Customers].[All Customers].[USA].[CA].[West Covina], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Light Beer]}\n{[Customers].[All Customers].[USA].[CA].[Woodland Hills], [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]}"));
        this.assertAxisReturns("NonEmptyCrossJoin({Gender.Parent}, {Store.Parent})", "");
        this.assertAxisReturns("NonEmptyCrossJoin({Store.Parent}, Gender.Children)", "");
        this.assertAxisReturns("NonEmptyCrossJoin(Store.Members, {})", "");
    }

    public void testNot() {
        this.assertBooleanExprReturns(" NOT 1=1 ", false);
    }

    public void testNotNot() {
        this.assertBooleanExprReturns(" NOT NOT 1=1 ", true);
    }

    public void testNotAssociativity() {
        this.assertBooleanExprReturns(" 1=1 AND NOT 1=1 OR NOT 1=1 AND 1=1 ", false);
    }

    public void testIsNull() {
        this.assertBooleanExprReturns(" Store.[All Stores] IS NULL ", false);
        this.assertBooleanExprReturns(" Store.[All Stores].parent IS NULL ", true);
    }

    public void testIsMember() {
        this.assertBooleanExprReturns(" Store.[USA].parent IS Store.[All Stores]", true);
        this.assertBooleanExprReturns(" [Store].[USA].[CA].parent IS [Store].[Mexico]", false);
    }

    public void testIsString() {
        this.assertExprThrows(" [Store].[USA].Name IS \"USA\" ", "No function matches signature '<String> IS <String>'");
    }

    public void testIsNumeric() {
        this.assertExprThrows(" [Store].[USA].Level.Ordinal IS 25 ", "No function matches signature '<Numeric Expression> IS <Numeric Expression>'");
    }

    public void testIsTuple() {
        this.assertBooleanExprReturns(" (Store.[USA], Gender.[M]) IS (Store.[USA], Gender.[M])", true);
        this.assertBooleanExprReturns(" (Store.[USA], Gender.[M]) IS (Gender.[M], Store.[USA])", true);
        this.assertBooleanExprReturns(" (Store.[USA], Gender.[M]) IS (Gender.[M], Store.[USA]) OR [Gender] IS NULL", true);
        this.assertBooleanExprReturns(" (Store.[USA], Gender.[M]) IS (Gender.[M], Store.[USA]) AND [Gender] IS NULL", false);
        this.assertBooleanExprReturns(" (Store.[USA], Gender.[M]) IS (Store.[USA], Gender.[F])", false);
        this.assertBooleanExprReturns(" (Store.[USA], Gender.[M]) IS (Store.[USA])", false);
        this.assertBooleanExprReturns(" (Store.[USA], Gender.[M]) IS Store.[USA]", false);
    }

    public void testIsLevel() {
        this.assertBooleanExprReturns(" Store.[USA].level IS Store.[Store Country] ", true);
        this.assertBooleanExprReturns(" Store.[USA].[CA].level IS Store.[Store Country] ", false);
    }

    public void testIsHierarchy() {
        this.assertBooleanExprReturns(" Store.[USA].hierarchy IS Store.[Mexico].hierarchy ", true);
        this.assertBooleanExprReturns(" Store.[USA].hierarchy IS Gender.[M].hierarchy ", false);
    }

    public void testIsDimension() {
        this.assertBooleanExprReturns(" Store.[USA].dimension IS Store ", true);
        this.assertBooleanExprReturns(" Gender.[M].dimension IS Store ", false);
    }

    public void testStringEquals() {
        this.assertBooleanExprReturns(" \"foo\" = \"bar\" ", false);
    }

    public void testStringEqualsAssociativity() {
        this.assertBooleanExprReturns(" \"foo\" = \"fo\" || \"o\" ", true);
    }

    public void testStringEqualsEmpty() {
        this.assertBooleanExprReturns(" \"\" = \"\" ", true);
    }

    public void testEq() {
        this.assertBooleanExprReturns(" 1.0 = 1 ", true);
        this.assertBooleanExprReturns("[Product].CurrentMember.Level.Ordinal = 2.0", false);
        this.checkNullOp("=");
    }

    public void testStringNe() {
        this.assertBooleanExprReturns(" \"foo\" <> \"bar\" ", true);
    }

    public void testNe() {
        this.assertBooleanExprReturns(" 2 <> 1.0 + 1.0 ", false);
        this.checkNullOp("<>");
    }

    public void testNeInfinity() {
        this.assertBooleanExprReturns("(1 / 0) <> (1 / 0)", false);
    }

    public void testLt() {
        this.assertBooleanExprReturns(" 2 < 1.0 + 1.0 ", false);
        this.checkNullOp("<");
    }

    public void testLe() {
        this.assertBooleanExprReturns(" 2 <= 1.0 + 1.0 ", true);
        this.checkNullOp("<=");
    }

    public void testGt() {
        this.assertBooleanExprReturns(" 2 > 1.0 + 1.0 ", false);
        this.checkNullOp(">");
    }

    public void testGe() {
        this.assertBooleanExprReturns(" 2 > 1.0 + 1.0 ", false);
        this.checkNullOp(">=");
    }

    private void checkNullOp(String op) {
        this.assertBooleanExprReturns(" 0 " + op + " " + NullNumericExpr, false);
        this.assertBooleanExprReturns(" ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]) " + op + " 0", false);
        this.assertBooleanExprReturns(" ([Measures].[Unit Sales],   [Customers].[All Customers].[USA].[CA].[Bellflower],    [Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good].[Good Imported Beer]) " + op + " " + NullNumericExpr, false);
    }

    public void testDistinctTwoMembers() {
        this.getTestContext().withCube("HR").assertAxisReturns("Distinct({[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold],[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold]})", "[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold]");
    }

    public void testDistinctThreeMembers() {
        this.getTestContext().withCube("HR").assertAxisReturns("Distinct({[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold],[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz],[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold]})", FunctionTest.fold("[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz]"));
    }

    public void testDistinctFourMembers() {
        this.getTestContext().withCube("HR").assertAxisReturns("Distinct({[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold],[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz],[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold],[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz]})", FunctionTest.fold("[Employees].[All Employees].[Sheri Nowmer].[Donna Arnold]\n[Employees].[All Employees].[Sheri Nowmer].[Darren Stanz]"));
    }

    public void testDistinctTwoTuples() {
        this.getTestContext().assertAxisReturns("Distinct({([Time].[1997],[Store].[All Stores].[Mexico]), ([Time].[1997], [Store].[All Stores].[Mexico])})", "{[Time].[1997], [Store].[All Stores].[Mexico]}");
    }

    public void testDistinctSomeTuples() {
        this.getTestContext().assertAxisReturns("Distinct({([Time].[1997],[Store].[All Stores].[Mexico]), crossjoin({[Time].[1997]},{[Store].[All Stores].children})})", FunctionTest.fold("{[Time].[1997], [Store].[All Stores].[Mexico]}\n{[Time].[1997], [Store].[All Stores].[Canada]}\n{[Time].[1997], [Store].[All Stores].[USA]}"));
    }

    public void testFilterWithSlicer() {
        Result result = this.executeQuery("select {[Measures].[Unit Sales]} on columns,\n filter([Customers].[USA].children,\n        [Measures].[Unit Sales] > 20000) on rows\nfrom Sales\nwhere ([Time].[1997].[Q1])");
        Axis rows = result.getAxes()[1];
        Assert.assertEquals((int)1, (int)rows.getPositions().size());
        Cell cell = result.getCell(new int[]{0, 0});
        Assert.assertEquals((String)"30,114", (String)cell.getFormattedValue());
    }

    public void testFilterCompound() {
        Result result = this.executeQuery("select {[Measures].[Unit Sales]} on columns,\n  Filter(\n    CrossJoin(\n      [Gender].Children,\n      [Customers].[USA].Children),\n    [Measures].[Unit Sales] > 9500) on rows\nfrom Sales\nwhere ([Time].[1997].[Q1])");
        List<Position> rows = result.getAxes()[1].getPositions();
        Assert.assertTrue((rows.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"F", (String)((Member)rows.get(0).get(0)).getName());
        Assert.assertEquals((String)"WA", (String)((Member)rows.get(0).get(1)).getName());
        Assert.assertEquals((String)"M", (String)((Member)rows.get(1).get(0)).getName());
        Assert.assertEquals((String)"OR", (String)((Member)rows.get(1).get(1)).getName());
        Assert.assertEquals((String)"M", (String)((Member)rows.get(2).get(0)).getName());
        Assert.assertEquals((String)"WA", (String)((Member)rows.get(2).get(1)).getName());
    }

    public void testGenerateDepends() {
        this.getTestContext().assertSetExprDependsOn("Generate([Product].CurrentMember.Children, Crossjoin({[Product].CurrentMember}, Crossjoin([Store].[Store State].Members, [Store Type].Members)), ALL)", "{[Product]}");
        this.getTestContext().assertSetExprDependsOn("Generate([Product].[All Products].Children, Crossjoin({[Product].CurrentMember}, Crossjoin([Store].[Store State].Members, [Store Type].Members)), ALL)", "{}");
        this.getTestContext().assertSetExprDependsOn("Generate({[Store].[USA], [Store].[USA].[CA]}, {[Store].CurrentMember.Children})", "{}");
        this.getTestContext().assertSetExprDependsOn("Generate({[Store].[USA], [Store].[USA].[CA]}, {[Gender].CurrentMember})", "{[Gender]}");
        this.getTestContext().assertSetExprDependsOn("Generate({[Store].[USA], [Store].[USA].[CA]}, {[Gender].[M]})", "{}");
    }

    public void testGenerate() {
        this.assertAxisReturns("Generate({[Store].[USA], [Store].[USA].[CA]}, {[Store].CurrentMember.Children})", FunctionTest.fold("[Store].[All Stores].[USA].[CA]\n[Store].[All Stores].[USA].[OR]\n[Store].[All Stores].[USA].[WA]\n[Store].[All Stores].[USA].[CA].[Alameda]\n[Store].[All Stores].[USA].[CA].[Beverly Hills]\n[Store].[All Stores].[USA].[CA].[Los Angeles]\n[Store].[All Stores].[USA].[CA].[San Diego]\n[Store].[All Stores].[USA].[CA].[San Francisco]"));
    }

    public void testGenerateNonSetFails() {
        this.assertAxisThrows("Generate({[Store].[USA], [Store].[USA].[CA]}, [Store].PrevMember, ALL)", FunctionTest.fold("No function matches signature 'Generate(<Set>, <Member>, <Symbol>)'"));
    }

    public void testGenerateAll() {
        this.assertAxisReturns("Generate({[Store].[USA].[CA], [Store].[USA].[OR].[Portland]}, Ascendants([Store].CurrentMember), ALL)", FunctionTest.fold("[Store].[All Stores].[USA].[CA]\n[Store].[All Stores].[USA]\n[Store].[All Stores]\n[Store].[All Stores].[USA].[OR].[Portland]\n[Store].[All Stores].[USA].[OR]\n[Store].[All Stores].[USA]\n[Store].[All Stores]"));
    }

    public void testGenerateUnique() {
        this.assertAxisReturns("Generate({[Store].[USA].[CA], [Store].[USA].[OR].[Portland]}, Ascendants([Store].CurrentMember))", FunctionTest.fold("[Store].[All Stores].[USA].[CA]\n[Store].[All Stores].[USA]\n[Store].[All Stores]\n[Store].[All Stores].[USA].[OR].[Portland]\n[Store].[All Stores].[USA].[OR]"));
    }

    public void testGenerateUniqueTuple() {
        this.assertAxisReturns("Generate({([Store].[USA].[CA],[Product].[All Products]), ([Store].[USA].[CA],[Product].[All Products])},{([Store].CurrentMember, [Product].CurrentMember)})", FunctionTest.fold("{[Store].[All Stores].[USA].[CA], [Product].[All Products]}"));
    }

    public void testGenerateCrossJoin() {
        this.assertAxisReturns(FunctionTest.fold("Generate({[Store].[USA].[CA], [Store].[USA].[CA].[San Francisco]},\n  CrossJoin({[Store].CurrentMember},\n    TopCount([Product].[Brand Name].members, \n    2,\n    [Measures].[Unit Sales])))"), FunctionTest.fold("{[Store].[All Stores].[USA].[CA], [Product].[All Products].[Food].[Produce].[Vegetables].[Fresh Vegetables].[Hermanos]}\n{[Store].[All Stores].[USA].[CA], [Product].[All Products].[Food].[Produce].[Vegetables].[Fresh Vegetables].[Tell Tale]}\n{[Store].[All Stores].[USA].[CA].[San Francisco], [Product].[All Products].[Food].[Produce].[Vegetables].[Fresh Vegetables].[Ebony]}\n{[Store].[All Stores].[USA].[CA].[San Francisco], [Product].[All Products].[Food].[Produce].[Vegetables].[Fresh Vegetables].[High Top]}"));
    }

    public void testGenerateString() {
        this.assertExprReturns("Generate({Time.[1997], Time.[1998]}, Time.CurrentMember.Name)", "19971998");
        this.assertExprReturns("Generate({Time.[1997], Time.[1998]}, Time.CurrentMember.Name, \" and \")", "1997 and 1998");
    }

    public void testHead() {
        this.assertAxisReturns("Head([Store].Children, 2)", FunctionTest.fold("[Store].[All Stores].[Canada]\n[Store].[All Stores].[Mexico]"));
    }

    public void testHeadNegative() {
        this.assertAxisReturns("Head([Store].Children, 2 - 3)", "");
    }

    public void testHeadDefault() {
        this.assertAxisReturns("Head([Store].Children)", "[Store].[All Stores].[Canada]");
    }

    public void testHeadOvershoot() {
        this.assertAxisReturns("Head([Store].Children, 2 + 2)", FunctionTest.fold("[Store].[All Stores].[Canada]\n[Store].[All Stores].[Mexico]\n[Store].[All Stores].[USA]"));
    }

    public void testHeadEmpty() {
        this.assertAxisReturns("Head([Gender].[F].Children, 2)", "");
        this.assertAxisReturns("Head([Gender].[F].Children)", "");
    }

    public void testHeadBug() {
        this.assertQueryReturns("SELECT\n                        UNION(\n                            {([Customers].CURRENTMEMBER)},\n                            HEAD(\n                                {([Customers].CURRENTMEMBER)},\n                                IIF(\n                                    COUNT(\n                                        FILTER(\n                                            DESCENDANTS(\n                                                [Customers].CURRENTMEMBER,\n                                                [Customers].[Country]),\n                                            [Measures].[Unit Sales] >= 66),\n                                        INCLUDEEMPTY)> 0,\n                                    1,\n                                    0)),\n                            ALL)\n    ON AXIS(0)\nFROM\n    [Sales]\n", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers]}\n{[Customers].[All Customers]}\nRow #0: 266,773\nRow #0: 266,773\n"));
        this.assertQueryReturns("WITH\n    MEMBER\n        [Customers].[COG_OQP_INT_t2]AS '1',\n        SOLVE_ORDER = 65535\nSELECT\n                        UNION(\n                            {([Customers].[COG_OQP_INT_t2])},\n                            HEAD(\n                                {([Customers].CURRENTMEMBER)},\n                                IIF(\n                                    COUNT(\n                                        FILTER(\n                                            DESCENDANTS(\n                                                [Customers].CURRENTMEMBER,\n                                                [Customers].[Country]),\n                                            [Measures].[Unit Sales]>= 66),\n                                        INCLUDEEMPTY)> 0,\n                                    1,\n                                    0)),\n                            ALL)\n    ON AXIS(0)\nFROM\n    [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[COG_OQP_INT_t2]}\n{[Customers].[All Customers]}\nRow #0: 1\nRow #0: 266,773\n"));
        this.assertAxisReturns("Union(\n  Union(\n    Tail([Customers].[USA].[CA].Children, 2),\n    Head([Customers].[USA].[WA].Children, 2),\n    ALL),\n  Tail([Customers].[USA].[OR].Children, 2),  ALL)", FunctionTest.fold("[Customers].[All Customers].[USA].[CA].[West Covina]\n[Customers].[All Customers].[USA].[CA].[Woodland Hills]\n[Customers].[All Customers].[USA].[WA].[Anacortes]\n[Customers].[All Customers].[USA].[WA].[Ballard]\n[Customers].[All Customers].[USA].[OR].[W. Linn]\n[Customers].[All Customers].[USA].[OR].[Woodburn]"));
    }

    public void testHierarchize() {
        this.assertAxisReturns(FunctionTest.fold("Hierarchize(\n    {[Product].[All Products],      [Product].[Food],\n     [Product].[Drink],\n     [Product].[Non-Consumable],\n     [Product].[Food].[Eggs],\n     [Product].[Drink].[Dairy]})"), FunctionTest.fold("[Product].[All Products]\n[Product].[All Products].[Drink]\n[Product].[All Products].[Drink].[Dairy]\n[Product].[All Products].[Food]\n[Product].[All Products].[Food].[Eggs]\n[Product].[All Products].[Non-Consumable]"));
    }

    public void testHierarchizePost() {
        this.assertAxisReturns(FunctionTest.fold("Hierarchize(\n    {[Product].[All Products],      [Product].[Food],\n     [Product].[Food].[Eggs],\n     [Product].[Drink].[Dairy]},\n  POST)"), FunctionTest.fold("[Product].[All Products].[Drink].[Dairy]\n[Product].[All Products].[Food].[Eggs]\n[Product].[All Products].[Food]\n[Product].[All Products]"));
    }

    public void testHierarchizePC() {
        this.getTestContext().withCube("HR").assertAxisReturns("Hierarchize(\n   { Subset([Employees].Members, 90, 10),\n     Head([Employees].Members, 5) })", FunctionTest.fold("[Employees].[All Employees]\n[Employees].[All Employees].[Sheri Nowmer]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Beverly Baker].[Shauna Wyro]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Lin Conley].[Paul Tays].[Cheryl Thorton].[Leopoldo Renfro]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Lin Conley].[Paul Tays].[Cheryl Thorton].[Donna Brockett]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Lin Conley].[Paul Tays].[Cheryl Thorton].[Laurie Anderson]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Lin Conley].[Paul Tays].[Cheryl Thorton].[Louis Gomez]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Lin Conley].[Paul Tays].[Cheryl Thorton].[Melvin Glass]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Lin Conley].[Paul Tays].[Cheryl Thorton].[Kristin Cohen]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Lin Conley].[Paul Tays].[Cheryl Thorton].[Susan Kharman]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Lin Conley].[Paul Tays].[Cheryl Thorton].[Gordon Kirschner]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Lin Conley].[Paul Tays].[Cheryl Thorton].[Geneva Kouba]\n[Employees].[All Employees].[Sheri Nowmer].[Derrick Whelply].[Pedro Castillo].[Lin Conley].[Paul Tays].[Cheryl Thorton].[Tricia Clark]"));
    }

    public void testHierarchizeCrossJoinPre() {
        this.assertAxisReturns(FunctionTest.fold("Hierarchize(\n  CrossJoin(\n    {[Product].[All Products],      [Product].[Food],\n     [Product].[Food].[Eggs],\n     [Product].[Drink].[Dairy]},\n    [Gender].MEMBERS),\n  PRE)"), FunctionTest.fold("{[Product].[All Products], [Gender].[All Gender]}\n{[Product].[All Products], [Gender].[All Gender].[F]}\n{[Product].[All Products], [Gender].[All Gender].[M]}\n{[Product].[All Products].[Drink].[Dairy], [Gender].[All Gender]}\n{[Product].[All Products].[Drink].[Dairy], [Gender].[All Gender].[F]}\n{[Product].[All Products].[Drink].[Dairy], [Gender].[All Gender].[M]}\n{[Product].[All Products].[Food], [Gender].[All Gender]}\n{[Product].[All Products].[Food], [Gender].[All Gender].[F]}\n{[Product].[All Products].[Food], [Gender].[All Gender].[M]}\n{[Product].[All Products].[Food].[Eggs], [Gender].[All Gender]}\n{[Product].[All Products].[Food].[Eggs], [Gender].[All Gender].[F]}\n{[Product].[All Products].[Food].[Eggs], [Gender].[All Gender].[M]}"));
    }

    public void testHierarchizeCrossJoinPost() {
        this.assertAxisReturns(FunctionTest.fold("Hierarchize(\n  CrossJoin(\n    {[Product].[All Products],      [Product].[Food],\n     [Product].[Food].[Eggs],\n     [Product].[Drink].[Dairy]},\n    [Gender].MEMBERS),\n  POST)"), FunctionTest.fold("{[Product].[All Products].[Drink].[Dairy], [Gender].[All Gender].[F]}\n{[Product].[All Products].[Drink].[Dairy], [Gender].[All Gender].[M]}\n{[Product].[All Products].[Drink].[Dairy], [Gender].[All Gender]}\n{[Product].[All Products].[Food].[Eggs], [Gender].[All Gender].[F]}\n{[Product].[All Products].[Food].[Eggs], [Gender].[All Gender].[M]}\n{[Product].[All Products].[Food].[Eggs], [Gender].[All Gender]}\n{[Product].[All Products].[Food], [Gender].[All Gender].[F]}\n{[Product].[All Products].[Food], [Gender].[All Gender].[M]}\n{[Product].[All Products].[Food], [Gender].[All Gender]}\n{[Product].[All Products], [Gender].[All Gender].[F]}\n{[Product].[All Products], [Gender].[All Gender].[M]}\n{[Product].[All Products], [Gender].[All Gender]}"));
    }

    public void testHierarchizeOrdinal() {
        TestContext context = this.getTestContext().withCube("[Sales_Hierarchize]");
        Connection connection = context.getFoodMartConnection();
        connection.getSchema().createCube(FunctionTest.fold("<Cube name=\"Sales_Hierarchize\">\n  <Table name=\"sales_fact_1997\"/>\n  <Dimension name=\"Time_Alphabetical\" type=\"TimeDimension\" foreignKey=\"time_id\">\n    <Hierarchy hasAll=\"false\" primaryKey=\"time_id\">\n      <Table name=\"time_by_day\"/>\n      <Level name=\"Year\" column=\"the_year\" type=\"Numeric\" uniqueMembers=\"true\"\n          levelType=\"TimeYears\"/>\n      <Level name=\"Quarter\" column=\"quarter\" uniqueMembers=\"false\"\n          levelType=\"TimeQuarters\"/>\n      <Level name=\"Month\" column=\"month_of_year\" uniqueMembers=\"false\" type=\"Numeric\"\n          ordinalColumn=\"the_month\"\n          levelType=\"TimeMonths\"/>\n    </Hierarchy>\n  </Dimension>\n\n  <Dimension name=\"Month_Alphabetical\" type=\"TimeDimension\" foreignKey=\"time_id\">\n    <Hierarchy hasAll=\"false\" primaryKey=\"time_id\">\n      <Table name=\"time_by_day\"/>\n      <Level name=\"Month\" column=\"month_of_year\" uniqueMembers=\"false\" type=\"Numeric\"\n          ordinalColumn=\"the_month\"\n          levelType=\"TimeMonths\"/>\n    </Hierarchy>\n  </Dimension>\n\n  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\"/>\n</Cube>"));
        context.assertAxisReturns("Hierarchize([Time_Alphabetical].members)", FunctionTest.fold("[Time_Alphabetical].[1997]\n[Time_Alphabetical].[1997].[Q1]\n[Time_Alphabetical].[1997].[Q1].[2]\n[Time_Alphabetical].[1997].[Q1].[1]\n[Time_Alphabetical].[1997].[Q1].[3]\n[Time_Alphabetical].[1997].[Q2]\n[Time_Alphabetical].[1997].[Q2].[4]\n[Time_Alphabetical].[1997].[Q2].[6]\n[Time_Alphabetical].[1997].[Q2].[5]\n[Time_Alphabetical].[1997].[Q3]\n[Time_Alphabetical].[1997].[Q3].[8]\n[Time_Alphabetical].[1997].[Q3].[7]\n[Time_Alphabetical].[1997].[Q3].[9]\n[Time_Alphabetical].[1997].[Q4]\n[Time_Alphabetical].[1997].[Q4].[12]\n[Time_Alphabetical].[1997].[Q4].[11]\n[Time_Alphabetical].[1997].[Q4].[10]\n[Time_Alphabetical].[1998]\n[Time_Alphabetical].[1998].[Q1]\n[Time_Alphabetical].[1998].[Q1].[2]\n[Time_Alphabetical].[1998].[Q1].[1]\n[Time_Alphabetical].[1998].[Q1].[3]\n[Time_Alphabetical].[1998].[Q2]\n[Time_Alphabetical].[1998].[Q2].[4]\n[Time_Alphabetical].[1998].[Q2].[6]\n[Time_Alphabetical].[1998].[Q2].[5]\n[Time_Alphabetical].[1998].[Q3]\n[Time_Alphabetical].[1998].[Q3].[8]\n[Time_Alphabetical].[1998].[Q3].[7]\n[Time_Alphabetical].[1998].[Q3].[9]\n[Time_Alphabetical].[1998].[Q4]\n[Time_Alphabetical].[1998].[Q4].[12]\n[Time_Alphabetical].[1998].[Q4].[11]\n[Time_Alphabetical].[1998].[Q4].[10]"));
        context.assertAxisReturns("Hierarchize([Month_Alphabetical].members)", FunctionTest.fold("[Month_Alphabetical].[4]\n[Month_Alphabetical].[8]\n[Month_Alphabetical].[12]\n[Month_Alphabetical].[2]\n[Month_Alphabetical].[1]\n[Month_Alphabetical].[7]\n[Month_Alphabetical].[6]\n[Month_Alphabetical].[3]\n[Month_Alphabetical].[5]\n[Month_Alphabetical].[11]\n[Month_Alphabetical].[10]\n[Month_Alphabetical].[9]"));
        connection.getCacheControl(null).flushSchemaCache();
    }

    public void testIntersect() {
        this.assertAxisReturns("Intersect({[Time].[1997].[Q2], [Time].[1997], [Time].[1997].[Q1], [Time].[1997].[Q2]}, {[Time].[1998], [Time].[1997], [Time].[1997].[Q2], [Time].[1997]}, ALL)", FunctionTest.fold("[Time].[1997].[Q2]\n[Time].[1997]\n[Time].[1997].[Q2]"));
    }

    public void testIntersectRightEmpty() {
        this.assertAxisReturns("Intersect({[Time].[1997]}, {})", "");
    }

    public void testIntersectLeftEmpty() {
        this.assertAxisReturns("Intersect({}, {[Store].[USA].[CA]})", "");
    }

    public void testOrderDepends() {
        String s11 = TestContext.allDimsExcept("[Product]", "[Measures]", "[Marital Status]", "[Gender]");
        this.getTestContext().assertSetExprDependsOn("Order( Crossjoin([Gender].MEMBERS, [Product].MEMBERS), ([Measures].[Unit Sales], [Marital Status].[S]), ASC)", s11);
        String s12 = TestContext.allDimsExcept("[Product]", "[Measures]", "[Marital Status]");
        this.getTestContext().assertSetExprDependsOn("Order( Crossjoin({[Gender].CurrentMember}, [Product].MEMBERS), ([Measures].[Unit Sales], [Marital Status].[S]), ASC)", s12);
        String s13 = TestContext.allDimsExcept("[Measures]");
        this.getTestContext().assertSetExprDependsOn("Order(  Crossjoin(    [Gender].CurrentMember.Children,     [Marital Status].CurrentMember.Children),   [Measures].[Unit Sales],   BDESC)", s13);
        String s1 = TestContext.allDimsExcept("[Measures]", "[Store]", "[Product]", "[Time]");
        this.getTestContext().assertSetExprDependsOn(FunctionTest.fold("  Order(\n    CrossJoin(\n      {[Product].[All Products].[Food].[Eggs],\n       [Product].[All Products].[Food].[Seafood],\n       [Product].[All Products].[Drink].[Alcoholic Beverages]},\n      {[Store].[USA].[WA].[Seattle],\n       [Store].[USA].[CA],\n       [Store].[USA].[OR]}),\n    ([Time].[1997].[Q1], [Measures].[Unit Sales]),\n    ASC)"), s1);
    }

    public void testOrderCalc() {
        this.assertAxisCompilesTo("order([Product].children, [Measures].[Unit Sales])", "ContextCalc([Measures].[Unit Sales], Order(MemberListIterCalc(Children(CurrentMember([Product]))), ValueCalc, ASC))");
        this.assertAxisCompilesTo("order([Product].children, ([Time].[1997], [Product].CurrentMember.Parent))", "ContextCalc([Time].[1997], Order(MemberListIterCalc(Children(CurrentMember([Product]))), MemberValueCalc(Parent(CurrentMember([Product]))), ASC))");
        this.assertAxisCompilesTo("order([Product].children, [Product].CurrentMember.Parent)", "Order(MemberListIterCalc(Children(CurrentMember([Product]))), MemberValueCalc(Parent(CurrentMember([Product]))), ASC)");
        this.assertAxisCompilesTo("order(filter([Product].children, [Measures].[Unit Sales] > 1000), ([Gender].[M], [Measures].[Store Sales]))", Util.Retrowoven ? "ContextCalc([Measures].[Store Sales], Order(MemberListIterCalc(Filter(Children(CurrentMember([Product])), >(MemberValueCalc([Measures].[Unit Sales]), 1000.0))), MemberValueCalc([Gender].[All Gender].[M]), ASC))" : "ContextCalc([Measures].[Store Sales], Order(Filter(Children(CurrentMember([Product])), >(MemberValueCalc([Measures].[Unit Sales]), 1000.0)), MemberValueCalc([Gender].[All Gender].[M]), ASC))");
    }

    public void testOrderWithMember() {
        this.assertQueryReturns("with member [Measures].[Product Name Length] as 'LEN([Product].CurrentMember.Name)'\nselect {[Measures].[Product Name Length]} ON COLUMNS,\nOrder([Product].[All Products].Children, [Measures].[Product Name Length], BASC) ON ROWS\nfrom [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Product Name Length]}\nAxis #2:\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: 4\nRow #1: 5\nRow #2: 14\n"));
    }

    public void testOrderNonEmpty() {
        this.assertQueryReturns("select NON EMPTY [Gender].Members ON COLUMNS,\nNON EMPTY Order([Product].[All Products].[Drink].Children,\n[Gender].[All Gender].[F], ASC) ON ROWS\nfrom [Sales]\nwhere ([Customers].[All Customers].[USA].[CA].[San Francisco],\n [Time].[1997])", FunctionTest.fold("Axis #0:\n{[Customers].[All Customers].[USA].[CA].[San Francisco], [Time].[1997]}\nAxis #1:\n{[Gender].[All Gender]}\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\nAxis #2:\n{[Product].[All Products].[Drink].[Beverages]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages]}\nRow #0: 2\nRow #0: \nRow #0: 2\nRow #1: 4\nRow #1: 2\nRow #1: 2\n"));
    }

    public void testOrder() {
        this.assertQueryReturns("select {[Measures].[Unit Sales]} on columns,\n order({\n  [Product].[All Products].[Drink],\n  [Product].[All Products].[Drink].[Beverages],\n  [Product].[All Products].[Drink].[Dairy],\n  [Product].[All Products].[Food],\n  [Product].[All Products].[Food].[Baked Goods],\n  [Product].[All Products].[Food].[Eggs],\n  [Product].[All Products]},\n [Measures].[Unit Sales]) on rows\nfrom Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products]}\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Drink].[Dairy]}\n{[Product].[All Products].[Drink].[Beverages]}\n{[Product].[All Products].[Food]}\n{[Product].[All Products].[Food].[Eggs]}\n{[Product].[All Products].[Food].[Baked Goods]}\nRow #0: 266,773\nRow #1: 24,597\nRow #2: 4,186\nRow #3: 13,573\nRow #4: 191,940\nRow #5: 4,132\nRow #6: 7,870\n"));
    }

    public void testOrderParentsMissing() {
        this.assertQueryReturns("select {[Measures].[Unit Sales]} on columns, order({\n  [Product].[All Products].[Drink].[Alcoholic Beverages],\n  [Product].[All Products].[Food].[Eggs]},\n [Measures].[Unit Sales], ASC) on rows\nfrom Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Product].[All Products].[Food].[Eggs]}\nRow #0: 6,838\nRow #1: 4,132\n"));
    }

    public void testOrderCrossJoinBreak() {
        this.assertQueryReturns("select {[Measures].[Unit Sales]} on columns,\n  Order(\n    CrossJoin(\n      [Gender].children,\n      [Marital Status].children),\n    [Measures].[Unit Sales],\n    BDESC) on rows\nfrom Sales\nwhere [Time].[1997].[Q1]", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q1]}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S]}\nRow #0: 17,070\nRow #1: 16,790\nRow #2: 16,311\nRow #3: 16,120\n"));
    }

    public void testOrderCrossJoin() {
        this.assertQueryReturns("select CrossJoin(\n    {[Time].[1997],\n     [Time].[1997].[Q1]},\n    {[Measures].[Unit Sales]}) on columns,\n  Order(\n    CrossJoin(\n      {[Product].[All Products].[Food].[Eggs],\n       [Product].[All Products].[Food].[Seafood],\n       [Product].[All Products].[Drink].[Alcoholic Beverages]},\n      {[Store].[USA].[WA].[Seattle],\n       [Store].[USA].[CA],\n       [Store].[USA].[OR]}),\n    ([Time].[1997].[Q1], [Measures].[Unit Sales]),\n    ASC) on rows\nfrom Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997], [Measures].[Unit Sales]}\n{[Time].[1997].[Q1], [Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Store].[All Stores].[USA].[OR]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Store].[All Stores].[USA].[CA]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages], [Store].[All Stores].[USA].[WA].[Seattle]}\n{[Product].[All Products].[Food].[Seafood], [Store].[All Stores].[USA].[CA]}\n{[Product].[All Products].[Food].[Seafood], [Store].[All Stores].[USA].[OR]}\n{[Product].[All Products].[Food].[Seafood], [Store].[All Stores].[USA].[WA].[Seattle]}\n{[Product].[All Products].[Food].[Eggs], [Store].[All Stores].[USA].[CA]}\n{[Product].[All Products].[Food].[Eggs], [Store].[All Stores].[USA].[OR]}\n{[Product].[All Products].[Food].[Eggs], [Store].[All Stores].[USA].[WA].[Seattle]}\nRow #0: 1,680\nRow #0: 393\nRow #1: 1,936\nRow #1: 431\nRow #2: 635\nRow #2: 142\nRow #3: 441\nRow #3: 91\nRow #4: 451\nRow #4: 107\nRow #5: 217\nRow #5: 44\nRow #6: 1,116\nRow #6: 240\nRow #7: 1,119\nRow #7: 251\nRow #8: 373\nRow #8: 57\n"));
    }

    public void testOrderHierarchicalDesc() {
        this.assertAxisReturns(FunctionTest.fold("Order(\n    {[Product].[All Products],      [Product].[Food],\n     [Product].[Drink],\n     [Product].[Non-Consumable],\n     [Product].[Food].[Eggs],\n     [Product].[Drink].[Dairy]},\n  [Measures].[Unit Sales],\n  DESC)"), FunctionTest.fold("[Product].[All Products]\n[Product].[All Products].[Food]\n[Product].[All Products].[Food].[Eggs]\n[Product].[All Products].[Non-Consumable]\n[Product].[All Products].[Drink]\n[Product].[All Products].[Drink].[Dairy]"));
    }

    public void testOrderCrossJoinDesc() {
        this.assertAxisReturns(FunctionTest.fold("Order(\n  CrossJoin(\n    {[Gender].[M], [Gender].[F]},\n    {[Product].[All Products],      [Product].[Food],\n     [Product].[Drink],\n     [Product].[Non-Consumable],\n     [Product].[Food].[Eggs],\n     [Product].[Drink].[Dairy]}),\n  [Measures].[Unit Sales],\n  DESC)"), FunctionTest.fold("{[Gender].[All Gender].[M], [Product].[All Products]}\n{[Gender].[All Gender].[M], [Product].[All Products].[Food]}\n{[Gender].[All Gender].[M], [Product].[All Products].[Food].[Eggs]}\n{[Gender].[All Gender].[M], [Product].[All Products].[Non-Consumable]}\n{[Gender].[All Gender].[M], [Product].[All Products].[Drink]}\n{[Gender].[All Gender].[M], [Product].[All Products].[Drink].[Dairy]}\n{[Gender].[All Gender].[F], [Product].[All Products]}\n{[Gender].[All Gender].[F], [Product].[All Products].[Food]}\n{[Gender].[All Gender].[F], [Product].[All Products].[Food].[Eggs]}\n{[Gender].[All Gender].[F], [Product].[All Products].[Non-Consumable]}\n{[Gender].[All Gender].[F], [Product].[All Products].[Drink]}\n{[Gender].[All Gender].[F], [Product].[All Products].[Drink].[Dairy]}"));
    }

    public void testOrderBug656802() {
        this.assertQueryReturns("select {[Measures].[Unit Sales], [Measures].[Store Cost], [Measures].[Store Sales]} ON columns, \nOrder(\n  ToggleDrillState(\n    {([Promotion Media].[All Media], [Product].[All Products])},\n    {[Product].[All Products]}), \n  [Measures].[Unit Sales], DESC) ON rows \nfrom [Sales] where ([Time].[1997])", FunctionTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Promotion Media].[All Media], [Product].[All Products]}\n{[Promotion Media].[All Media], [Product].[All Products].[Food]}\n{[Promotion Media].[All Media], [Product].[All Products].[Non-Consumable]}\n{[Promotion Media].[All Media], [Product].[All Products].[Drink]}\nRow #0: 266,773\nRow #0: 225,627.23\nRow #0: 565,238.13\nRow #1: 191,940\nRow #1: 163,270.72\nRow #1: 409,035.59\nRow #2: 50,236\nRow #2: 42,879.28\nRow #2: 107,366.33\nRow #3: 24,597\nRow #3: 19,477.23\nRow #3: 48,836.21\n"));
    }

    public void testOrderBug712702_Simplified() {
        this.assertQueryReturns("SELECT Order({[Time].[Year].members}, [Measures].[Unit Sales]) on columns\nfrom [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1998]}\n{[Time].[1997]}\nRow #0: \nRow #0: 266,773\n"));
    }

    public void testOrderBug712702_Original() {
        this.assertQueryReturns("with member [Measures].[Average Unit Sales] as 'Avg(Descendants([Time].CurrentMember, [Time].[Month]), \n[Measures].[Unit Sales])' \nmember [Measures].[Max Unit Sales] as 'Max(Descendants([Time].CurrentMember, [Time].[Month]), [Measures].[Unit Sales])' \nselect {[Measures].[Average Unit Sales], [Measures].[Max Unit Sales], [Measures].[Unit Sales]} ON columns, \n  NON EMPTY Order(\n    Crossjoin(\n      {[Store].[All Stores].[USA].[OR].[Portland],\n       [Store].[All Stores].[USA].[OR].[Salem],\n       [Store].[All Stores].[USA].[OR].[Salem].[Store 13],\n       [Store].[All Stores].[USA].[CA].[San Francisco],\n       [Store].[All Stores].[USA].[CA].[San Diego],\n       [Store].[All Stores].[USA].[CA].[Beverly Hills],\n       [Store].[All Stores].[USA].[CA].[Los Angeles],\n       [Store].[All Stores].[USA].[WA].[Walla Walla],\n       [Store].[All Stores].[USA].[WA].[Bellingham],\n       [Store].[All Stores].[USA].[WA].[Yakima],\n       [Store].[All Stores].[USA].[WA].[Spokane],\n       [Store].[All Stores].[USA].[WA].[Seattle], \n       [Store].[All Stores].[USA].[WA].[Bremerton],\n       [Store].[All Stores].[USA].[WA].[Tacoma]},\n     [Time].[Year].Members), \n  [Measures].[Average Unit Sales], ASC) ON rows\nfrom [Sales] ", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Average Unit Sales]}\n{[Measures].[Max Unit Sales]}\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[OR].[Portland], [Time].[1997]}\n{[Store].[All Stores].[USA].[OR].[Salem], [Time].[1997]}\n{[Store].[All Stores].[USA].[OR].[Salem].[Store 13], [Time].[1997]}\n{[Store].[All Stores].[USA].[CA].[San Francisco], [Time].[1997]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills], [Time].[1997]}\n{[Store].[All Stores].[USA].[CA].[San Diego], [Time].[1997]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles], [Time].[1997]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla], [Time].[1997]}\n{[Store].[All Stores].[USA].[WA].[Bellingham], [Time].[1997]}\n{[Store].[All Stores].[USA].[WA].[Yakima], [Time].[1997]}\n{[Store].[All Stores].[USA].[WA].[Spokane], [Time].[1997]}\n{[Store].[All Stores].[USA].[WA].[Bremerton], [Time].[1997]}\n{[Store].[All Stores].[USA].[WA].[Seattle], [Time].[1997]}\n{[Store].[All Stores].[USA].[WA].[Tacoma], [Time].[1997]}\nRow #0: 2,173\nRow #0: 2,933\nRow #0: 26,079\nRow #1: 3,465\nRow #1: 5,891\nRow #1: 41,580\nRow #2: 3,465\nRow #2: 5,891\nRow #2: 41,580\nRow #3: 176\nRow #3: 222\nRow #3: 2,117\nRow #4: 1,778\nRow #4: 2,545\nRow #4: 21,333\nRow #5: 2,136\nRow #5: 2,686\nRow #5: 25,635\nRow #6: 2,139\nRow #6: 2,669\nRow #6: 25,663\nRow #7: 184\nRow #7: 301\nRow #7: 2,203\nRow #8: 186\nRow #8: 275\nRow #8: 2,237\nRow #9: 958\nRow #9: 1,163\nRow #9: 11,491\nRow #10: 1,966\nRow #10: 2,634\nRow #10: 23,591\nRow #11: 2,048\nRow #11: 2,623\nRow #11: 24,576\nRow #12: 2,084\nRow #12: 2,304\nRow #12: 25,011\nRow #13: 2,938\nRow #13: 3,818\nRow #13: 35,257\n"));
    }

    public void testOrderEmpty() {
        String query = "select \n  Order(    {},    [Customers].currentMember, BDESC) \non 0 from [Sales]";
        this.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n"));
    }

    public void testOrderOne() {
        String query = "select \n  Order(    {[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]},    [Customers].currentMember, BDESC) \non 0 from [Sales]";
        this.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\nRow #0: 75\n"));
    }

    public void testOrderKeyEmpty() {
        String query = "select \n  Order(    {},    [Customers].currentMember.OrderKey, BDESC) \non 0 from [Sales]";
        this.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n"));
    }

    public void testOrderKeyOne() {
        String query = "select \n  Order(    {[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]},    [Customers].currentMember.OrderKey, BDESC) \non 0 from [Sales]";
        this.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\nRow #0: 75\n"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderMemberMemberValueExpNew() {
        String query = "select \n  Order(    {[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young],     [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]},    [Customers].currentMember.OrderKey, BDESC) \non 0 from [Sales]";
        this.propSaver.set(MondrianProperties.instance().CompareSiblingsByOrderKey, true);
        Connection conn = null;
        try {
            conn = this.getTestContext().getFoodMartConnection(false);
            TestContext context = this.getTestContext(conn);
            context.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]}\n{[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\nRow #0: 33\nRow #0: 75\n"));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderMemberMemberValueExpNew1() {
        String query = "select \n  Order(    {[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young],     [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]},    [Customers].currentMember, BDESC) \non 0 from [Sales]";
        this.propSaver.set(MondrianProperties.instance().CompareSiblingsByOrderKey, true);
        Connection conn = null;
        try {
            conn = this.getTestContext().getFoodMartConnection(false);
            TestContext context = this.getTestContext(conn);
            context.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\n{[Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]}\nRow #0: 75\nRow #0: 33\n"));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public void testOrderMemberDefaultFlag1() {
        String query = "with \n  Member [Measures].[Zero] as '0' \nselect \n  Order(    {[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young],     [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]},    [Customers].currentMember.OrderKey) \non 0 from [Sales]";
        this.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]}\n{[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\nRow #0: 33\nRow #0: 75\n"));
    }

    public void testOrderMemberDefaultFlag2() {
        String query = "with \n  Member [Measures].[Zero] as '0' \nselect \n  Order(    {[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young],     [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]},    [Measures].[Store Cost]) \non 0 from [Sales]";
        this.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\n{[Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]}\nRow #0: 75\nRow #0: 33\n"));
    }

    public void testOrderMemberMemberValueExpHierarchy() {
        String query = "select \n  Order(    {[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young],     [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]},    [Customers].currentMember.OrderKey, DESC) \non 0 from [Sales]";
        this.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\n{[Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]}\nRow #0: 75\nRow #0: 33\n"));
    }

    public void testOrderMemberMultiKeysMemberValueExp1() {
        String query = "select \n  Order(    {[Customers].[USA].[WA].[Issaquah].[Abe Tramel],     [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young],     [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]},    [Measures].[Unit Sales], BDESC, [Customers].currentMember.OrderKey, BDESC) \non 0 from [Sales]";
        this.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\n{[Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]}\n{[Customers].[All Customers].[USA].[WA].[Issaquah].[Abe Tramel]}\nRow #0: 75\nRow #0: 33\nRow #0: 33\n"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderMemberMultiKeysMemberValueExp2() {
        String query = "select \n  Order(    {[Customers].[USA].[WA].[Issaquah].[Abe Tramel],     [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young],     [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]},    [Customers].currentMember.Parent.Parent.OrderKey, BASC, [Customers].currentMember.OrderKey, BDESC) \non 0 from [Sales]";
        this.propSaver.set(MondrianProperties.instance().CompareSiblingsByOrderKey, true);
        Connection conn = null;
        try {
            conn = this.getTestContext().getFoodMartConnection(false);
            TestContext context = this.getTestContext(conn);
            context.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]}\n{[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\n{[Customers].[All Customers].[USA].[WA].[Issaquah].[Abe Tramel]}\nRow #0: 33\nRow #0: 75\nRow #0: 33\n"));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public void testOrderMemberMultiKeysMemberValueExpDepends() {
        String query = "select \n  Order(    {[Customers].[USA].[WA].[Issaquah].[Abe Tramel],     [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young],     [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]},    [Measures].[Unit Sales], BDESC, [Time].currentMember, BDESC) \non 0 from [Sales]";
        this.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\n{[Customers].[All Customers].[USA].[WA].[Issaquah].[Abe Tramel]}\n{[Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]}\nRow #0: 75\nRow #0: 33\nRow #0: 33\n"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderTupleSingleKeysNew() {
        String query = "with \n  set [NECJ] as \n    'NonEmptyCrossJoin( \n    {[Customers].[USA].[WA].[Issaquah].[Abe Tramel],     [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young],     [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]},    {[Store].[USA].[WA].[Seattle],\n     [Store].[USA].[CA],\n     [Store].[USA].[OR]})'\nselect \n Order([NECJ], [Customers].currentMember.OrderKey, BDESC) \non 0 from [Sales]";
        this.propSaver.set(MondrianProperties.instance().CompareSiblingsByOrderKey, true);
        Connection conn = null;
        try {
            conn = this.getTestContext().getFoodMartConnection(false);
            TestContext context = this.getTestContext(conn);
            context.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun], [Store].[All Stores].[USA].[CA]}\n{[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young], [Store].[All Stores].[USA].[CA]}\n{[Customers].[All Customers].[USA].[WA].[Issaquah].[Abe Tramel], [Store].[All Stores].[USA].[WA].[Seattle]}\nRow #0: 33\nRow #0: 75\nRow #0: 33\n"));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testOrderTupleSingleKeysNew1() {
        String query = "with \n  set [NECJ] as \n    'NonEmptyCrossJoin( \n    {[Customers].[USA].[WA].[Issaquah].[Abe Tramel],     [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young],     [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]},    {[Store].[USA].[WA].[Seattle],\n     [Store].[USA].[CA],\n     [Store].[USA].[OR]})'\nselect \n Order([NECJ], [Store].currentMember.OrderKey, DESC) \non 0 from [Sales]";
        this.propSaver.set(MondrianProperties.instance().CompareSiblingsByOrderKey, true);
        Connection conn = null;
        try {
            conn = this.getTestContext().getFoodMartConnection(false);
            TestContext context = this.getTestContext(conn);
            context.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[WA].[Issaquah].[Abe Tramel], [Store].[All Stores].[USA].[WA].[Seattle]}\n{[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young], [Store].[All Stores].[USA].[CA]}\n{[Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun], [Store].[All Stores].[USA].[CA]}\nRow #0: 33\nRow #0: 75\nRow #0: 33\n"));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public void testOrderTupleMultiKeys1() {
        String query = "with \n  set [NECJ] as \n    'NonEmptyCrossJoin( \n    {[Store].[USA].[CA],\n     [Store].[USA].[WA]},\n    {[Customers].[USA].[WA].[Issaquah].[Abe Tramel],     [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young],     [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]})' \nselect \n Order([NECJ], [Store].currentMember.OrderKey, BDESC, [Measures].[Unit Sales], BDESC) \non 0 from [Sales]";
        this.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA], [Customers].[All Customers].[USA].[WA].[Issaquah].[Abe Tramel]}\n{[Store].[All Stores].[USA].[CA], [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\n{[Store].[All Stores].[USA].[CA], [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]}\nRow #0: 33\nRow #0: 75\nRow #0: 33\n"));
    }

    public void testOrderTupleMultiKeys2() {
        String query = "with \n  set [NECJ] as \n    'NonEmptyCrossJoin( \n    {[Store].[USA].[CA],\n     [Store].[USA].[WA]},\n    {[Customers].[USA].[WA].[Issaquah].[Abe Tramel],     [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young],     [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]})' \nselect \n Order([NECJ], [Measures].[Unit Sales], BDESC, Ancestor([Customers].currentMember, [Customers].[Name]).OrderKey, BDESC) \non 0 from [Sales]";
        this.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[CA], [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\n{[Store].[All Stores].[USA].[CA], [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]}\n{[Store].[All Stores].[USA].[WA], [Customers].[All Customers].[USA].[WA].[Issaquah].[Abe Tramel]}\nRow #0: 75\nRow #0: 33\nRow #0: 33\n"));
    }

    public void testOrderTupleMultiKeys3() {
        String query = "with \n  set [NECJ] as \n    'NonEmptyCrossJoin( \n    {[Store].[USA].[CA],\n     [Store].[USA].[WA]},\n    {[Customers].[USA].[WA].[Issaquah].[Abe Tramel],     [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young],     [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]})' \nselect \n Order([NECJ], [Measures].[Unit Sales], DESC, Ancestor([Customers].currentMember, [Customers].[Name]), BDESC) \non 0 from [Sales]";
        this.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA], [Customers].[All Customers].[USA].[WA].[Issaquah].[Abe Tramel]}\n{[Store].[All Stores].[USA].[CA], [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]}\n{[Store].[All Stores].[USA].[CA], [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\nRow #0: 33\nRow #0: 33\nRow #0: 75\n"));
    }

    public void testOrderTupleMultiKeyswithVCube() {
        String query = "with \n  set [CJ] as \n    'CrossJoin( \n    {[Position].[Store Management].children},\n    {[Customers].[USA].[WA].[Issaquah].[Abe Tramel],     [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young],     [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]})' \nselect \n  [Measures].[Org Salary] on columns, \n  Order([CJ], [Position].currentMember.OrderKey, BASC, Ancestor([Customers].currentMember, [Customers].[Name]).OrderKey, BDESC) \non rows \nfrom [Sales vs HR]";
        this.propSaver.set(MondrianProperties.instance().CompareSiblingsByOrderKey, true);
        TestContext context = TestContext.create(null, null, "<VirtualCube name=\"Sales vs HR\">\n<VirtualCubeDimension cubeName=\"Sales\" name=\"Customers\"/>\n<VirtualCubeDimension cubeName=\"HR\" name=\"Position\"/>\n<VirtualCubeMeasure cubeName=\"HR\" name=\"[Measures].[Org Salary]\"/>\n</VirtualCube>", null, null, null);
        context.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Org Salary]}\nAxis #2:\n{[Position].[All Position].[Store Management].[Store Manager], [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]}\n{[Position].[All Position].[Store Management].[Store Manager], [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\n{[Position].[All Position].[Store Management].[Store Manager], [Customers].[All Customers].[USA].[WA].[Issaquah].[Abe Tramel]}\n{[Position].[All Position].[Store Management].[Store Assistant Manager], [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]}\n{[Position].[All Position].[Store Management].[Store Assistant Manager], [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\n{[Position].[All Position].[Store Management].[Store Assistant Manager], [Customers].[All Customers].[USA].[WA].[Issaquah].[Abe Tramel]}\n{[Position].[All Position].[Store Management].[Store Shift Supervisor], [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]}\n{[Position].[All Position].[Store Management].[Store Shift Supervisor], [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\n{[Position].[All Position].[Store Management].[Store Shift Supervisor], [Customers].[All Customers].[USA].[WA].[Issaquah].[Abe Tramel]}\nRow #0: \nRow #1: \nRow #2: \nRow #3: \nRow #4: \nRow #5: \nRow #6: \nRow #7: \nRow #8: \n"));
    }

    public void testOrderConstant1() {
        String query = "select \n  Order(    {[Customers].[USA].[WA].[Issaquah].[Abe Tramel],     [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young],     [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]},    [Customers].[USA].OrderKey, BDESC, [Customers].currentMember.OrderKey, BASC) \non 0 from [Sales]";
        this.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[WA].[Issaquah].[Abe Tramel]}\n{[Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]}\n{[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\nRow #0: 33\nRow #0: 33\nRow #0: 75\n"));
    }

    public void testOrderDiffrentDim() {
        String query = "select \n  Order(    {[Customers].[USA].[WA].[Issaquah].[Abe Tramel],     [Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young],     [Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]},    [Product].currentMember.OrderKey, BDESC, [Gender].currentMember.OrderKey, BDESC) \non 0 from [Sales]";
        this.assertQueryReturns(query, FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[WA].[Issaquah].[Abe Tramel]}\n{[Customers].[All Customers].[USA].[CA].[Woodland Hills].[Abel Young]}\n{[Customers].[All Customers].[USA].[CA].[Santa Monica].[Adeline Chun]}\nRow #0: 33\nRow #0: 75\nRow #0: 33\n"));
    }

    public void testUnorder() {
        this.assertAxisReturns("Unorder([Gender].members)", FunctionTest.fold("[Gender].[All Gender]\n[Gender].[All Gender].[F]\n[Gender].[All Gender].[M]"));
        this.assertAxisReturns("Unorder(Order([Gender].members, -[Measures].[Unit Sales]))", FunctionTest.fold("[Gender].[All Gender]\n[Gender].[All Gender].[M]\n[Gender].[All Gender].[F]"));
        this.assertAxisReturns("Unorder(Crossjoin([Gender].members, [Marital Status].Children))", FunctionTest.fold("{[Gender].[All Gender], [Marital Status].[All Marital Status].[M]}\n{[Gender].[All Gender], [Marital Status].[All Marital Status].[S]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[M]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S]}"));
        this.assertAxisThrows("Unorder([Gender].[M])", "No function matches signature 'Unorder(<Member>)'");
        this.assertAxisThrows("Unorder(1 + 3)", "No function matches signature 'Unorder(<Numeric Expression>)'");
        this.assertAxisThrows("Unorder([Gender].[M], 1 + 3)", "No function matches signature 'Unorder(<Member>, <Numeric Expression>)'");
        this.assertQueryReturns("select {[Measures].[Store Sales], [Measures].[Unit Sales]} on 0,\n  Unorder([Gender].Members) on 1\nfrom [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Gender].[All Gender]}\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\nRow #0: 565,238.13\nRow #0: 266,773\nRow #1: 280,226.21\nRow #1: 131,558\nRow #2: 285,011.92\nRow #2: 135,215\n"));
    }

    public void testSiblingsA() {
        this.assertAxisReturns("{[Time].[1997].Siblings}", FunctionTest.fold("[Time].[1997]\n[Time].[1998]"));
    }

    public void testSiblingsB() {
        this.assertAxisReturns("{[Store].Siblings}", "[Store].[All Stores]");
    }

    public void testSiblingsC() {
        this.assertAxisReturns("{[Store].[USA].[CA].Siblings}", FunctionTest.fold("[Store].[All Stores].[USA].[CA]\n[Store].[All Stores].[USA].[OR]\n[Store].[All Stores].[USA].[WA]"));
    }

    public void testSiblingsD() {
        this.assertAxisReturns("{[Gender].Parent.Siblings}", "");
        this.assertExprReturns("count ([Gender].parent.siblings, includeempty)", "0");
    }

    public void testSubset() {
        this.assertAxisReturns("Subset([Promotion Media].Children, 7, 2)", FunctionTest.fold("[Promotion Media].[All Media].[Product Attachment]\n[Promotion Media].[All Media].[Radio]"));
    }

    public void testSubsetNegativeCount() {
        this.assertAxisReturns("Subset([Promotion Media].Children, 3, -1)", "");
    }

    public void testSubsetNegativeStart() {
        this.assertAxisReturns("Subset([Promotion Media].Children, -2, 4)", "");
    }

    public void testSubsetDefault() {
        this.assertAxisReturns("Subset([Promotion Media].Children, 11)", FunctionTest.fold("[Promotion Media].[All Media].[Sunday Paper, Radio]\n[Promotion Media].[All Media].[Sunday Paper, Radio, TV]\n[Promotion Media].[All Media].[TV]"));
    }

    public void testSubsetOvershoot() {
        this.assertAxisReturns("Subset([Promotion Media].Children, 15)", "");
    }

    public void testSubsetEmpty() {
        this.assertAxisReturns("Subset([Gender].[F].Children, 1)", "");
        this.assertAxisReturns("Subset([Gender].[F].Children, 1, 3)", "");
    }

    public void testTail() {
        this.assertAxisReturns("Tail([Store].Children, 2)", FunctionTest.fold("[Store].[All Stores].[Mexico]\n[Store].[All Stores].[USA]"));
    }

    public void testTailNegative() {
        this.assertAxisReturns("Tail([Store].Children, 2 - 3)", "");
    }

    public void testTailDefault() {
        this.assertAxisReturns("Tail([Store].Children)", "[Store].[All Stores].[USA]");
    }

    public void testTailOvershoot() {
        this.assertAxisReturns("Tail([Store].Children, 2 + 2)", FunctionTest.fold("[Store].[All Stores].[Canada]\n[Store].[All Stores].[Mexico]\n[Store].[All Stores].[USA]"));
    }

    public void testTailEmpty() {
        this.assertAxisReturns("Tail([Gender].[F].Children, 2)", "");
        this.assertAxisReturns("Tail([Gender].[F].Children)", "");
    }

    public void testToggleDrillState() {
        this.assertAxisReturns("ToggleDrillState({[Customers].[USA],[Customers].[Canada]},{[Customers].[USA],[Customers].[USA].[CA]})", FunctionTest.fold("[Customers].[All Customers].[USA]\n[Customers].[All Customers].[USA].[CA]\n[Customers].[All Customers].[USA].[OR]\n[Customers].[All Customers].[USA].[WA]\n[Customers].[All Customers].[Canada]"));
    }

    public void testToggleDrillState2() {
        this.assertAxisReturns("ToggleDrillState([Product].[Product Department].members, {[Product].[All Products].[Food].[Snack Foods]})", FunctionTest.fold("[Product].[All Products].[Drink].[Alcoholic Beverages]\n[Product].[All Products].[Drink].[Beverages]\n[Product].[All Products].[Drink].[Dairy]\n[Product].[All Products].[Food].[Baked Goods]\n[Product].[All Products].[Food].[Baking Goods]\n[Product].[All Products].[Food].[Breakfast Foods]\n[Product].[All Products].[Food].[Canned Foods]\n[Product].[All Products].[Food].[Canned Products]\n[Product].[All Products].[Food].[Dairy]\n[Product].[All Products].[Food].[Deli]\n[Product].[All Products].[Food].[Eggs]\n[Product].[All Products].[Food].[Frozen Foods]\n[Product].[All Products].[Food].[Meat]\n[Product].[All Products].[Food].[Produce]\n[Product].[All Products].[Food].[Seafood]\n[Product].[All Products].[Food].[Snack Foods]\n[Product].[All Products].[Food].[Snack Foods].[Snack Foods]\n[Product].[All Products].[Food].[Snacks]\n[Product].[All Products].[Food].[Starchy Foods]\n[Product].[All Products].[Non-Consumable].[Carousel]\n[Product].[All Products].[Non-Consumable].[Checkout]\n[Product].[All Products].[Non-Consumable].[Health and Hygiene]\n[Product].[All Products].[Non-Consumable].[Household]\n[Product].[All Products].[Non-Consumable].[Periodicals]"));
    }

    public void testToggleDrillState3() {
        this.assertAxisReturns("ToggleDrillState({[Time].[1997].[Q1], [Time].[1997].[Q2], [Time].[1997].[Q2].[4], [Time].[1997].[Q2].[6], [Time].[1997].[Q3]},{[Time].[1997].[Q2]})", FunctionTest.fold("[Time].[1997].[Q1]\n[Time].[1997].[Q2]\n[Time].[1997].[Q3]"));
    }

    public void testToggleDrillStateTuple() {
        this.assertAxisReturns(FunctionTest.fold("ToggleDrillState(\n{([Store].[All Stores].[USA].[CA],  [Product].[All Products].[Drink].[Alcoholic Beverages]),\n ([Store].[All Stores].[USA],  [Product].[All Products].[Drink])},\n{[Store].[All stores].[USA].[CA]})"), FunctionTest.fold("{[Store].[All Stores].[USA].[CA], [Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Store].[All Stores].[USA].[CA].[Alameda], [Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills], [Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles], [Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Store].[All Stores].[USA].[CA].[San Diego], [Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Store].[All Stores].[USA].[CA].[San Francisco], [Product].[All Products].[Drink].[Alcoholic Beverages]}\n{[Store].[All Stores].[USA], [Product].[All Products].[Drink]}"));
    }

    public void testToggleDrillStateRecursive() {
        this.assertThrows("Select \n    ToggleDrillState(\n        {[Store].[All Stores].[USA]}, \n        {[Store].[All Stores].[USA]}, recursive) on Axis(0) \nfrom [Sales]\n", "'RECURSIVE' is not supported in ToggleDrillState.");
    }

    public void testTopCount() {
        this.assertAxisReturns("TopCount({[Promotion Media].[Media Type].members}, 2, [Measures].[Unit Sales])", FunctionTest.fold("[Promotion Media].[All Media].[No Media]\n[Promotion Media].[All Media].[Daily Paper, Radio, TV]"));
    }

    public void testTopCountTuple() {
        this.assertAxisReturns("TopCount([Customers].[Name].members,2,(Time.[1997].[Q1],[Measures].[Store Sales]))", FunctionTest.fold("[Customers].[All Customers].[USA].[WA].[Spokane].[Grace McLaughlin]\n[Customers].[All Customers].[USA].[WA].[Spokane].[Matt Bellah]"));
    }

    public void testTopCountEmpty() {
        this.assertAxisReturns("TopCount(Filter({[Promotion Media].[Media Type].members}, 1=0), 2, [Measures].[Unit Sales])", "");
    }

    public void testTopCountDepends() {
        this.checkTopBottomCountPercentDepends("TopCount");
        this.checkTopBottomCountPercentDepends("TopPercent");
        this.checkTopBottomCountPercentDepends("TopSum");
        this.checkTopBottomCountPercentDepends("BottomCount");
        this.checkTopBottomCountPercentDepends("BottomPercent");
        this.checkTopBottomCountPercentDepends("BottomSum");
    }

    private void checkTopBottomCountPercentDepends(String fun) {
        String s1 = TestContext.allDimsExcept("[Measures]", "[Promotion Media]");
        this.getTestContext().assertSetExprDependsOn(fun + "({[Promotion Media].[Media Type].members}, 2, [Measures].[Unit Sales])", s1);
        if (fun.endsWith("Count")) {
            this.getTestContext().assertSetExprDependsOn(fun + "({[Promotion Media].[Media Type].members}, 2)", "{}");
        }
    }

    public void testTopCountHuge() {
        String query = "SELECT [Measures].[Store Sales] ON 0,\nTopCount([Time].[Month].members * [Customers].[Name].members, 3, [Measures].[Store Sales]) ON 1\nFROM [Sales]";
        String desiredResult = FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\nAxis #2:\n{[Time].[1997].[Q1].[3], [Customers].[All Customers].[USA].[WA].[Spokane].[George Todero]}\n{[Time].[1997].[Q3].[7], [Customers].[All Customers].[USA].[WA].[Spokane].[James Horvat]}\n{[Time].[1997].[Q4].[11], [Customers].[All Customers].[USA].[WA].[Olympia].[Charles Stanley]}\nRow #0: 234.83\nRow #1: 199.46\nRow #2: 191.90\n");
        long now = System.currentTimeMillis();
        this.assertQueryReturns("SELECT [Measures].[Store Sales] ON 0,\nTopCount([Time].[Month].members * [Customers].[Name].members, 3, [Measures].[Store Sales]) ON 1\nFROM [Sales]", desiredResult);
        LOGGER.info((Object)("first query took " + (System.currentTimeMillis() - now)));
        now = System.currentTimeMillis();
        this.assertQueryReturns("SELECT [Measures].[Store Sales] ON 0,\nTopCount([Time].[Month].members * [Customers].[Name].members, 3, [Measures].[Store Sales]) ON 1\nFROM [Sales]", desiredResult);
        LOGGER.info((Object)("second query took " + (System.currentTimeMillis() - now)));
    }

    public void testTopPercent() {
        this.assertAxisReturns("TopPercent({[Promotion Media].[Media Type].members}, 70, [Measures].[Unit Sales])", "[Promotion Media].[All Media].[No Media]");
    }

    public void testTopSum() {
        this.assertAxisReturns("TopSum({[Promotion Media].[Media Type].members}, 200000, [Measures].[Unit Sales])", FunctionTest.fold("[Promotion Media].[All Media].[No Media]\n[Promotion Media].[All Media].[Daily Paper, Radio, TV]"));
    }

    public void testTopSumEmpty() {
        this.assertAxisReturns("TopSum(Filter({[Promotion Media].[Media Type].members}, 1=0), 200000, [Measures].[Unit Sales])", "");
    }

    public void testUnionAll() {
        this.assertAxisReturns("Union({[Gender].[M]}, {[Gender].[F]}, ALL)", FunctionTest.fold("[Gender].[All Gender].[M]\n[Gender].[All Gender].[F]"));
    }

    public void testUnionAllTuple() {
        this.assertQueryReturns("with \nset [Set1] as 'Crossjoin({[Time].[1997].[Q1]:[Time].[1997].[Q4]},{[Store].[USA].[CA]:[Store].[USA].[OR]})'\nset [Set2] as 'Crossjoin({[Time].[1997].[Q2]:[Time].[1997].[Q3]},{[Store].[Mexico].[DF]:[Store].[Mexico].[Veracruz]})'\nselect \n{[Measures].[Unit Sales]} ON COLUMNS,\nUnion([Set1], [Set2], ALL) ON ROWS\nfrom [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Time].[1997].[Q1], [Store].[All Stores].[USA].[CA]}\n{[Time].[1997].[Q1], [Store].[All Stores].[USA].[OR]}\n{[Time].[1997].[Q2], [Store].[All Stores].[USA].[CA]}\n{[Time].[1997].[Q2], [Store].[All Stores].[USA].[OR]}\n{[Time].[1997].[Q3], [Store].[All Stores].[USA].[CA]}\n{[Time].[1997].[Q3], [Store].[All Stores].[USA].[OR]}\n{[Time].[1997].[Q4], [Store].[All Stores].[USA].[CA]}\n{[Time].[1997].[Q4], [Store].[All Stores].[USA].[OR]}\n{[Time].[1997].[Q2], [Store].[All Stores].[Mexico].[DF]}\n{[Time].[1997].[Q2], [Store].[All Stores].[Mexico].[Guerrero]}\n{[Time].[1997].[Q2], [Store].[All Stores].[Mexico].[Jalisco]}\n{[Time].[1997].[Q2], [Store].[All Stores].[Mexico].[Veracruz]}\n{[Time].[1997].[Q3], [Store].[All Stores].[Mexico].[DF]}\n{[Time].[1997].[Q3], [Store].[All Stores].[Mexico].[Guerrero]}\n{[Time].[1997].[Q3], [Store].[All Stores].[Mexico].[Jalisco]}\n{[Time].[1997].[Q3], [Store].[All Stores].[Mexico].[Veracruz]}\nRow #0: 16,890\nRow #1: 19,287\nRow #2: 18,052\nRow #3: 15,079\nRow #4: 18,370\nRow #5: 16,940\nRow #6: 21,436\nRow #7: 16,353\nRow #8: \nRow #9: \nRow #10: \nRow #11: \nRow #12: \nRow #13: \nRow #14: \nRow #15: \n"));
    }

    public void testUnion() {
        this.assertAxisReturns("Union({[Store].[USA], [Store].[USA], [Store].[USA].[OR]}, {[Store].[USA].[CA], [Store].[USA]})", FunctionTest.fold("[Store].[All Stores].[USA]\n[Store].[All Stores].[USA].[OR]\n[Store].[All Stores].[USA].[CA]"));
    }

    public void testUnionEmptyBoth() {
        this.assertAxisReturns("Union({}, {})", "");
    }

    public void testUnionEmptyRight() {
        this.assertAxisReturns("Union({[Gender].[M]}, {})", "[Gender].[All Gender].[M]");
    }

    public void testUnionTuple() {
        this.assertAxisReturns("Union({ ([Gender].[M], [Marital Status].[S]), ([Gender].[F], [Marital Status].[S])}, { ([Gender].[M], [Marital Status].[M]), ([Gender].[M], [Marital Status].[S])})", FunctionTest.fold("{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M]}"));
    }

    public void testUnionTupleDistinct() {
        this.assertAxisReturns("Union({ ([Gender].[M], [Marital Status].[S]), ([Gender].[F], [Marital Status].[S])}, { ([Gender].[M], [Marital Status].[M]), ([Gender].[M], [Marital Status].[S])}, Distinct)", FunctionTest.fold("{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[S]}\n{[Gender].[All Gender].[F], [Marital Status].[All Marital Status].[S]}\n{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M]}"));
    }

    public void testUnionQuery() {
        Result result = this.executeQuery("select {[Measures].[Unit Sales], [Measures].[Store Cost], [Measures].[Store Sales]} on columns,\n Hierarchize(\n   Union(\n     Crossjoin(\n       Crossjoin([Gender].[All Gender].children,\n                 [Marital Status].[All Marital Status].children),\n       Crossjoin([Customers].[All Customers].children,\n                 [Product].[All Products].children) ),\n     Crossjoin({([Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M])},\n       Crossjoin(\n         [Customers].[All Customers].[USA].children,\n         [Product].[All Products].children) ) )) on rows\nfrom Sales where ([Time].[1997])");
        Axis rowsAxis = result.getAxes()[1];
        Assert.assertEquals((int)45, (int)rowsAxis.getPositions().size());
    }

    public void testItemMember() {
        this.assertExprReturns("Descendants([Time].[1997], [Time].[Month]).Item(1).Item(0).UniqueName", "[Time].[1997].[Q1].[2]");
        if (this.isDefaultNullMemberRepresentation()) {
            this.assertExprReturns("[Time].[1997].Children.Item(6).UniqueName", "[Time].[#null]");
            this.assertExprReturns("[Time].[1997].Children.Item(-1).UniqueName", "[Time].[#null]");
        }
    }

    public void testItemTuple() {
        this.assertExprReturns("CrossJoin([Gender].[All Gender].children, [Time].[1997].[Q2].children).Item(0).Item(1).UniqueName", "[Time].[1997].[Q2].[4]");
    }

    public void testStrToMember() {
        this.assertExprReturns("StrToMember(\"[Time].[1997].[Q2].[4]\").Name", "4");
    }

    public void testStrToTuple() {
        this.assertAxisReturns("{StrToTuple(\"[Time].[1997].[Q2]\", [Time])}", "[Time].[1997].[Q2]");
        this.assertAxisReturns("{StrToTuple(\"([Gender].[F], [Time].[1997].[Q2])\", [Gender], [Time])}", "{[Gender].[All Gender].[F], [Time].[1997].[Q2]}");
    }

    public void testStrToTupleDupDimensionsFails() {
        this.assertAxisThrows("{StrToTuple(\"([Gender].[F], [Time].[1997].[Q2], [Gender].[M])\", [Gender], [Time], [Gender])}", "Tuple contains more than one member of dimension '[Gender]'.");
    }

    public void testStrToTupleDepends() {
        this.getTestContext().assertMemberExprDependsOn("StrToTuple(\"[Time].[1997].[Q2]\", [Time])", "{}");
        this.getTestContext().assertExprDependsOn("StrToTuple(\"[Time].[1997].[Q2]\", [Time])", TestContext.allDimsExcept("[Time]"));
        this.getTestContext().assertMemberExprDependsOn("StrToTuple(\"[Time].[1997].[Q2], [Gender].[F]\", [Time], [Gender])", "{}");
        this.getTestContext().assertExprDependsOn("StrToTuple(\"[Time].[1997].[Q2], [Gender].[F]\", [Time], [Gender])", TestContext.allDimsExcept("[Time]", "[Gender]"));
    }

    public void testStrToSet() {
        this.assertAxisReturns("StrToSet( \"{[Gender].[F], [Gender].[M]}\", [Gender])", FunctionTest.fold("[Gender].[All Gender].[F]\n[Gender].[All Gender].[M]"));
        this.assertAxisThrows("StrToSet( \"{[Gender].[F], [Time].[1997]}\", [Gender])", "member is of wrong hierarchy");
        this.assertAxisReturns("StrToSet( \"  {   [Gender] .  [F]  ,[Gender].[M] }  \", [Gender])", FunctionTest.fold("[Gender].[All Gender].[F]\n[Gender].[All Gender].[M]"));
        this.assertAxisReturns("StrToSet(\"{ ([Gender].[F], [Time].[1997].[Q2]),  ([Gender].[M], [Time].[1997])}\", [Gender], [Time])", FunctionTest.fold("{[Gender].[All Gender].[F], [Time].[1997].[Q2]}\n{[Gender].[All Gender].[M], [Time].[1997]}"));
    }

    public void testStrToSetDupDimensionsFails() {
        this.assertAxisThrows("StrToSet(\"{ ([Gender].[F], [Time].[1997].[Q2], [Gender].[F]),  ([Gender].[M], [Time].[1997], [Gender].[F])}\", [Gender], [Time], [Gender])", "Tuple contains more than one member of dimension '[Gender]'.");
    }

    public void testYtd() {
        this.assertAxisReturns("Ytd()", year1997);
        this.assertAxisReturns("Ytd([Time].[1997].[Q3])", FunctionTest.fold("[Time].[1997].[Q1]\n[Time].[1997].[Q2]\n[Time].[1997].[Q3]"));
        this.assertAxisReturns("Ytd([Time].[1997].[Q2].[4])", FunctionTest.fold("[Time].[1997].[Q1].[1]\n[Time].[1997].[Q1].[2]\n[Time].[1997].[Q1].[3]\n[Time].[1997].[Q2].[4]"));
        this.assertAxisThrows("Ytd([Store])", "Argument to function 'Ytd' must belong to Time hierarchy");
        this.getTestContext().assertSetExprDependsOn("Ytd()", "{[Time]}");
        this.getTestContext().assertSetExprDependsOn("Ytd([Time].[1997].[Q2])", "{}");
    }

    public void testGeneratePlusXtd() {
        this.assertAxisReturns("generate(\n  {[Time].[1997].[Q1].[2], [Time].[1997].[Q3].[7]},\n {Ytd( [Time].currentMember)})", FunctionTest.fold("[Time].[1997].[Q1].[1]\n[Time].[1997].[Q1].[2]\n[Time].[1997].[Q1].[3]\n[Time].[1997].[Q2].[4]\n[Time].[1997].[Q2].[5]\n[Time].[1997].[Q2].[6]\n[Time].[1997].[Q3].[7]"));
        this.assertAxisReturns("generate(\n  {[Time].[1997].[Q1].[2], [Time].[1997].[Q3].[7]},\n {Ytd( [Time].currentMember)}, ALL)", FunctionTest.fold("[Time].[1997].[Q1].[1]\n[Time].[1997].[Q1].[2]\n[Time].[1997].[Q1].[1]\n[Time].[1997].[Q1].[2]\n[Time].[1997].[Q1].[3]\n[Time].[1997].[Q2].[4]\n[Time].[1997].[Q2].[5]\n[Time].[1997].[Q2].[6]\n[Time].[1997].[Q3].[7]"));
        this.assertExprReturns("count(generate({[Time].[1997].[Q4].[11]}, {Qtd( [Time].currentMember)}))", 2.0, 0.0);
        this.assertExprReturns("count(generate({[Time].[1997].[Q4].[11]}, {Mtd( [Time].currentMember)}))", 1.0, 0.0);
    }

    public void testQtd() {
        this.assertQueryReturns("with member [Measures].[Foo] as ' SetToStr(Qtd()) '\nselect {[Measures].[Foo]} on columns\nfrom [Sales]\nwhere [Time].[1997].[Q2].[5]", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q2].[5]}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: {[Time].[1997].[Q2].[4], [Time].[1997].[Q2].[5]}\n"));
        this.assertAxisReturns("Qtd([Time].[1997].[Q2].[5])", FunctionTest.fold("[Time].[1997].[Q2].[4]\n[Time].[1997].[Q2].[5]"));
        this.assertAxisReturns("Qtd([Time].[1997].[Q2])", "[Time].[1997].[Q2]");
        this.assertAxisReturns("Qtd([Time].[1997])", "");
        this.assertAxisThrows("Qtd([Store])", "Argument to function 'Qtd' must belong to Time hierarchy");
    }

    public void testMtd() {
        this.assertQueryReturns("with member [Measures].[Foo] as ' SetToStr(Mtd()) '\nselect {[Measures].[Foo]} on columns\nfrom [Sales]\nwhere [Time].[1997].[Q2].[5]", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q2].[5]}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: {[Time].[1997].[Q2].[5]}\n"));
        this.assertAxisReturns("Mtd([Time].[1997].[Q2].[5])", "[Time].[1997].[Q2].[5]");
        this.assertAxisReturns("Mtd([Time].[1997].[Q2])", "");
        this.assertAxisReturns("Mtd([Time].[1997])", "");
        this.assertAxisThrows("Mtd([Store])", "Argument to function 'Mtd' must belong to Time hierarchy");
    }

    public void testPeriodsToDate() {
        this.getTestContext().assertSetExprDependsOn("PeriodsToDate()", "{[Time]}");
        this.getTestContext().assertSetExprDependsOn("PeriodsToDate([Time].[Year])", "{[Time]}");
        this.getTestContext().assertSetExprDependsOn("PeriodsToDate([Time].[Year], [Time].[1997].[Q2].[5])", "{}");
        this.assertAxisReturns("PeriodsToDate([Time].[Quarter], [Time].[1997].[Q2].[5])", FunctionTest.fold("[Time].[1997].[Q2].[4]\n[Time].[1997].[Q2].[5]"));
        this.assertAxisReturns("TopCount(  Descendants(    Ancestor(      [Time].[1997].[Q2].[5], [Time].[Quarter]),    [Time].[1997].[Q2].[5].Level),  1).Item(0) : [Time].[1997].[Q2].[5]", FunctionTest.fold("[Time].[1997].[Q2].[4]\n[Time].[1997].[Q2].[5]"));
        this.assertQueryReturns("with member [Measures].[Foo] as ' SetToStr(PeriodsToDate([Time].[Quarter])) '\nselect {[Measures].[Foo]} on columns\nfrom [Sales]\nwhere [Time].[1997].[Q2].[5]", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q2].[5]}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: {[Time].[1997].[Q2].[4], [Time].[1997].[Q2].[5]}\n"));
        this.assertQueryReturns("with member [Measures].[Foo] as ' SetToStr(PeriodsToDate()) '\nselect {[Measures].[Foo]} on columns\nfrom [Sales]\nwhere [Time].[1997].[Q2].[5]", FunctionTest.fold("Axis #0:\n{[Time].[1997].[Q2].[5]}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: {[Time].[1997].[Q2].[4], [Time].[1997].[Q2].[5]}\n"));
        this.assertQueryReturns("with member [Measures].[Foo] as ' SetToStr(PeriodsToDate()) '\nselect {[Measures].[Foo]} on columns\nfrom [Sales]\nwhere [Time].[1997]", FunctionTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: {}\n"));
        this.assertQueryReturns("with member [Measures].[Position] as\n 'Sum(PeriodsToDate([Time].Levels(0), [Time].CurrentMember), [Measures].[Store Sales])'\nselect {[Time].[1997],\n [Time].[1997].[Q1],\n [Time].[1997].[Q1].[1],\n [Time].[1997].[Q1].[2],\n [Time].[1997].[Q1].[3]} ON COLUMNS,\n{[Measures].[Store Sales], [Measures].[Position] } ON ROWS\nfrom [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997]}\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q1].[1]}\n{[Time].[1997].[Q1].[2]}\n{[Time].[1997].[Q1].[3]}\nAxis #2:\n{[Measures].[Store Sales]}\n{[Measures].[Position]}\nRow #0: 565,238.13\nRow #0: 139,628.35\nRow #0: 45,539.69\nRow #0: 44,058.79\nRow #0: 50,029.87\nRow #1: 565,238.13\nRow #1: 139,628.35\nRow #1: 45,539.69\nRow #1: 89,598.48\nRow #1: 139,628.35\n"));
        this.assertQueryReturns("select\n{[Measures].[Unit Sales]} on columns,\nperiodstodate(\n    [Product].[Product Category],\n    [Product].[Food].[Baked Goods].[Bread].[Muffins]) on rows\nfrom [Sales]\n", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]}\nRow #0: 815\nRow #1: 3,497\n"));
    }

    public void testSetToStr() {
        this.assertExprReturns("SetToStr([Time].children)", "{[Time].[1997].[Q1], [Time].[1997].[Q2], [Time].[1997].[Q3], [Time].[1997].[Q4]}");
        this.assertExprReturns("SetToStr({CrossJoin([Marital Status].children, {[Gender].[M]})})", "{([Marital Status].[All Marital Status].[M], [Gender].[All Gender].[M]), ([Marital Status].[All Marital Status].[S], [Gender].[All Gender].[M])}");
    }

    public void testTupleToStr() {
        this.assertExprReturns("TupleToStr([Time])", year1997);
        this.assertExprReturns("TupleToStr([Store].[USA].[OR])", "[Store].[All Stores].[USA].[OR]");
        this.assertExprReturns("TupleToStr(([Store].[USA].[OR]))", "[Store].[All Stores].[USA].[OR]");
        this.assertExprReturns("TupleToStr(([Marital Status], [Gender].[M]))", "([Marital Status].[All Marital Status], [Gender].[All Gender].[M])");
        this.assertExprReturns("TupleToStr(([Marital Status], [Gender].Parent))", "");
        this.assertExprReturns("TupleToStr([Marital Status].Parent)", "");
    }

    public void assertExprReturns(String expr, String expected) {
        String actual = this.executeExpr(expr);
        FunctionTest.assertEquals((String)expected, (String)actual);
    }

    public void assertExprReturns(String expr, double expected, double delta) {
        Object value = this.getTestContext().executeExprRaw(expr).getValue();
        try {
            double actual = ((Number)value).doubleValue();
            if (Double.isNaN(expected) && Double.isNaN(actual)) {
                return;
            }
            Assert.assertEquals(null, (double)expected, (double)actual, (double)delta);
        }
        catch (ClassCastException ex) {
            String msg = "Actual value \"" + value + "\" is not a number.";
            throw new ComparisonFailure(msg, Double.toString(expected), String.valueOf(value));
        }
    }

    public void assertExprCompilesTo(String expr, String expectedCalc) {
        String actualCalc = this.getTestContext().compileExpression(expr, true);
        int expDeps = MondrianProperties.instance().TestExpDependencies.get();
        if (expDeps > 0) {
            return;
        }
        FunctionTest.assertEquals((String)expectedCalc, (String)actualCalc);
    }

    public void assertAxisCompilesTo(String expr, String expectedCalc) {
        String actualCalc = this.getTestContext().compileExpression(expr, false);
        int expDeps = MondrianProperties.instance().TestExpDependencies.get();
        if (expDeps > 0) {
            return;
        }
        FunctionTest.assertEquals((String)expectedCalc, (String)actualCalc);
    }

    public void testRank() {
        this.assertExprReturns("Rank([Store].[USA].[CA], {[Store].[USA].[OR], [Store].[USA].[CA], [Store].[USA]})", "2");
        this.assertExprReturns("Rank([Store].[USA].[WA], {[Store].[USA].[OR], [Store].[USA].[CA], [Store].[USA]})", "0");
        this.assertExprReturns("Rank([Store].[USA].[WA], {})", "0");
        this.assertExprReturns("Rank([Store].Parent, {[Store].[USA].[OR], [Store].[USA].[CA], [Store].[USA]})", "");
        this.assertExprReturns("Rank([Gender].Parent, {})", "");
        this.assertExprReturns(FunctionTest.fold("Rank([Store].[USA].[WA], \n{[Store].[USA].[WA], [Store].[USA].[CA], [Store].[USA], [Store].[USA].[WA]})"), "1");
        this.assertExprReturns(FunctionTest.fold("Rank(([Gender].[F], [Marital Status].[M]), \n{([Gender].[F], [Marital Status].[S]),\n ([Gender].[M], [Marital Status].[S]),\n ([Gender].[M], [Marital Status].[M])})"), "0");
        this.assertExprReturns(FunctionTest.fold("Rank(([Gender].[F], [Marital Status].[M]), \n{([Gender].[F], [Marital Status].[S]),\n ([Gender].[M], [Marital Status].[S]),\n ([Gender].[F], [Marital Status].[M])})"), "3");
        this.assertExprReturns(FunctionTest.fold("Rank(([Gender].[F], [Marital Status].[M]), \n{})"), "0");
        this.assertExprReturns(FunctionTest.fold("Rank(([Gender].[F], [Marital Status].Parent), \n{([Gender].[F], [Marital Status].[S]),\n ([Gender].[M], [Marital Status].[S]),\n ([Gender].[F], [Marital Status].[M])})"), "");
    }

    public void testRankWithExpr() {
        this.assertQueryReturns("with member [Measures].[Sibling Rank] as ' Rank([Product].CurrentMember, [Product].CurrentMember.Siblings) '\n  member [Measures].[Sales Rank] as ' Rank([Product].CurrentMember, Order([Product].Parent.Children, [Measures].[Unit Sales], DESC)) '\n  member [Measures].[Sales Rank2] as ' Rank([Product].CurrentMember, [Product].Parent.Children, [Measures].[Unit Sales]) '\nselect {[Measures].[Unit Sales], [Measures].[Sales Rank], [Measures].[Sales Rank2]} on columns,\n {[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].children} on rows\nfrom [Sales]\nWHERE ([Store].[All Stores].[USA].[OR].[Portland].[Store 11], [Time].[1997].[Q2].[6])", FunctionTest.fold("Axis #0:\n{[Store].[All Stores].[USA].[OR].[Portland].[Store 11], [Time].[1997].[Q2].[6]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Sales Rank]}\n{[Measures].[Sales Rank2]}\nAxis #2:\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Pearl]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Top Measure]}\n{[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Walrus]}\nRow #0: 5\nRow #0: 1\nRow #0: 1\nRow #1: \nRow #1: 5\nRow #1: 5\nRow #2: 3\nRow #2: 3\nRow #2: 3\nRow #3: 5\nRow #3: 2\nRow #3: 1\nRow #4: 3\nRow #4: 4\nRow #4: 3\n"));
    }

    public void testRankWithExpr2() {
        this.assertExprReturns("Rank([Gender].[All Gender], {[Gender].Members}, [Measures].[Unit Sales])", "1");
        this.assertExprReturns("Rank([Gender].[F], {[Gender].Members}, [Measures].[Unit Sales])", "3");
        this.assertExprReturns("Rank([Gender].[M], {[Gender].Members}, [Measures].[Unit Sales])", "2");
        this.assertExprReturns("Rank([Gender].[All Gender].Parent, {[Gender].Members}, [Measures].[Unit Sales])", "");
        this.assertExprReturns("Rank([Gender].[M], {}, [Measures].[Unit Sales])", "");
        this.assertExprReturns("Rank([Gender].[M], {[Gender].[All Gender], [Gender].[F]})", "0");
        this.assertExprReturns("Rank([Gender].[M], {[Gender].[All Gender], [Gender].[F]}, [Measures].[Unit Sales])", "2");
        this.assertExprReturns("Rank([Product].[Non-Consumable].[Household], {[Product].[Food], [Product].[All Products], [Product].[Drink].[Dairy]}, [Product].CurrentMember.Parent)", "2");
        this.assertExprReturns("Rank([Gender].[M], {[Gender].[All Gender], [Gender].[F]}, [Marital Status].[All Marital Status].Parent)", "1");
    }

    public void testRankWithNulls() {
        this.assertQueryReturns("with member [Measures].[X] as 'iif([Measures].[Store Sales]=777,[Measures].[Store Sales],Null)'\nmember [Measures].[Y] as 'Rank([Gender].[M],{[Measures].[X],[Measures].[X],[Measures].[X]}, [Marital Status].[All Marital Status].Parent)'select {[Measures].[Y]} on columns from Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Y]}\nRow #0: 1\n"));
    }

    public void testRankHuge() {
        if (!MondrianProperties.instance().EnableExpCache.get()) {
            return;
        }
        String query = "WITH \n  MEMBER [Measures].[Rank among products] \n    AS ' Rank([Product].CurrentMember, Order([Product].members, [Measures].[Unit Sales], BDESC)) '\nSELECT CrossJoin(\n  [Gender].members,\n  {[Measures].[Unit Sales],\n   [Measures].[Rank among products]}) ON COLUMNS,\n  {[Product].members} ON ROWS\nFROM [Sales]";
        this.checkRankHuge(query, false);
    }

    public void _testRank3Huge() {
        if (!MondrianProperties.instance().EnableExpCache.get()) {
            return;
        }
        String query = "WITH \n  MEMBER [Measures].[Rank among products] \n    AS ' Rank([Product].CurrentMember, [Product].members, [Measures].[Unit Sales]) '\nSELECT CrossJoin(\n  [Gender].members,\n  {[Measures].[Unit Sales],\n   [Measures].[Rank among products]}) ON COLUMNS,\n  {[Product], [Product].[All Products].[Non-Consumable].[Periodicals].[Magazines].[Sports Magazines].[Robust].[Robust Monthly Sports Magazine]} ON ROWS\nFROM [Sales]";
        this.checkRankHuge(query, true);
    }

    private void checkRankHuge(String query, boolean rank3) {
        Result result = this.getTestContext().executeQuery(query);
        Axis[] axes = result.getAxes();
        Axis rowsAxis = axes[1];
        int rowCount = rowsAxis.getPositions().size();
        FunctionTest.assertEquals((int)2256, (int)rowCount);
        Cell cell = result.getCell(new int[]{1, 0});
        FunctionTest.assertEquals((String)"1", (String)cell.getFormattedValue());
        Member member = (Member)rowsAxis.getPositions().get(rowCount - 1).get(0);
        FunctionTest.assertEquals((String)"Robust Monthly Sports Magazine", (String)member.getName());
        cell = result.getCell(new int[]{0, rowCount - 1});
        FunctionTest.assertEquals((String)"152", (String)cell.getFormattedValue());
        cell = result.getCell(new int[]{1, rowCount - 1});
        FunctionTest.assertEquals((String)(rank3 ? "1,854" : "1,871"), (String)cell.getFormattedValue());
        cell = result.getCell(new int[]{2, rowCount - 1});
        FunctionTest.assertEquals((String)"90", (String)cell.getFormattedValue());
        cell = result.getCell(new int[]{3, rowCount - 1});
        FunctionTest.assertEquals((String)(rank3 ? "1,119" : "1,150"), (String)cell.getFormattedValue());
        cell = result.getCell(new int[]{4, rowCount - 1});
        FunctionTest.assertEquals((String)"62", (String)cell.getFormattedValue());
        cell = result.getCell(new int[]{5, rowCount - 1});
        FunctionTest.assertEquals((String)(rank3 ? "2,131" : "2,147"), (String)cell.getFormattedValue());
    }

    public void testLinRegPointQuarter() {
        String query = "WITH MEMBER [Measures].[Test] as \n  'LinRegPoint(\n    Rank(Time.CurrentMember, Time.CurrentMember.Level.Members),\n    Descendants([Time].[1997], [Time].[Quarter]), \n[Measures].[Store Sales], \n    Rank(Time.CurrentMember, Time.CurrentMember.Level.Members))' \nSELECT \n{[Measures].[Test],[Measures].[Store Sales]} ON ROWS, \n{[Time].[1997].Children} ON COLUMNS \nFROM Sales";
        String expected = FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997].[Q1]}\n{[Time].[1997].[Q2]}\n{[Time].[1997].[Q3]}\n{[Time].[1997].[Q4]}\nAxis #2:\n{[Measures].[Test]}\n{[Measures].[Store Sales]}\nRow #0: 134,299.22\nRow #0: 138,972.76\nRow #0: 143,646.30\nRow #0: 148,319.85\nRow #1: 139,628.35\nRow #1: 132,666.27\nRow #1: 140,271.89\nRow #1: 152,671.62\n");
        this.assertQueryReturns(query, expected);
    }

    public void _testLinRegAll() {
        String query = "WITH MEMBER \n[Measures].[Intercept] AS \n  'LinRegIntercept([Time].CurrentMember.Lag(10) : [Time].CurrentMember, [Measures].[Unit Sales], [Measures].[Store Sales])' \nMEMBER [Measures].[Regression Slope] AS\n  'LinRegSlope([Time].CurrentMember.Lag(9) : [Time].CurrentMember,[Measures].[Unit Sales],[Measures].[Store Sales]) '\nMEMBER [Measures].[Predict] AS\n  'LinRegPoint([Measures].[Unit Sales],[Time].CurrentMember.Lag(9) : [Time].CurrentMember,[Measures].[Unit Sales],[Measures].[Store Sales])',\n  FORMAT_STRING = 'Standard' \nMEMBER [Measures].[Predict Formula] AS\n  '([Measures].[Regression Slope] * [Measures].[Unit Sales]) + [Measures].[Intercept]',\n  FORMAT_STRING='Standard'\nMEMBER [Measures].[Good Fit] AS\n  'LinRegR2([Time].CurrentMember.Lag(9) : [Time].CurrentMember, [Measures].[Unit Sales],[Measures].[Store Sales])',\n  FORMAT_STRING='#,#.00'\nMEMBER [Measures].[Variance] AS\n  'LinRegVariance([Time].CurrentMember.Lag(9) : [Time].CurrentMember,[Measures].[Unit Sales],[Measures].[Store Sales])'\nSELECT \n  {[Measures].[Store Sales], \n   [Measures].[Intercept], \n   [Measures].[Regression Slope], \n   [Measures].[Predict], \n   [Measures].[Predict Formula], \n   [Measures].[Good Fit], \n   [Measures].[Variance] } ON COLUMNS, \n  Descendants([Time].[1997], [Time].[Month]) ON ROWS\nFROM Sales";
        String expected = FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Store Sales]}\n{[Measures].[Intercept]}\n{[Measures].[Regression Slope]}\n{[Measures].[Predict]}\n{[Measures].[Predict Formula]}\n{[Measures].[Good Fit]}\n{[Measures].[Variance]}\nAxis #2:\n{[Time].[1997].[Q1].[1]}\n{[Time].[1997].[Q1].[2]}\n{[Time].[1997].[Q1].[3]}\n{[Time].[1997].[Q2].[4]}\n{[Time].[1997].[Q2].[5]}\n{[Time].[1997].[Q2].[6]}\n{[Time].[1997].[Q3].[7]}\n{[Time].[1997].[Q3].[8]}\n{[Time].[1997].[Q3].[9]}\n{[Time].[1997].[Q4].[10]}\n{[Time].[1997].[Q4].[11]}\n{[Time].[1997].[Q4].[12]}\nRow #0: 45,539.69\nRow #0: 68711.40\nRow #0: -1.033\nRow #0: 46,350.26\nRow #0: 46.350.26\nRow #0: -1.#INF\nRow #0: 5.17E-08\n...\nRow #11: 15343.67\n");
        this.assertQueryReturns(query, expected);
    }

    public void testLinRegPointMonth() {
        String query = "WITH MEMBER \n[Measures].[Test] as \n  'LinRegPoint(\n    Rank(Time.CurrentMember, Time.CurrentMember.Level.Members),\n    Descendants([Time].[1997], [Time].[Month]), \n    [Measures].[Store Sales], \n    Rank(Time.CurrentMember, Time.CurrentMember.Level.Members)\n )' \nSELECT \n  {[Measures].[Test],[Measures].[Store Sales]} ON ROWS, \n  Descendants([Time].[1997], [Time].[Month]) ON COLUMNS \nFROM Sales";
        String expected = FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Time].[1997].[Q1].[1]}\n{[Time].[1997].[Q1].[2]}\n{[Time].[1997].[Q1].[3]}\n{[Time].[1997].[Q2].[4]}\n{[Time].[1997].[Q2].[5]}\n{[Time].[1997].[Q2].[6]}\n{[Time].[1997].[Q3].[7]}\n{[Time].[1997].[Q3].[8]}\n{[Time].[1997].[Q3].[9]}\n{[Time].[1997].[Q4].[10]}\n{[Time].[1997].[Q4].[11]}\n{[Time].[1997].[Q4].[12]}\nAxis #2:\n{[Measures].[Test]}\n{[Measures].[Store Sales]}\nRow #0: 43,824.36\nRow #0: 44,420.51\nRow #0: 45,016.66\nRow #0: 45,612.81\nRow #0: 46,208.95\nRow #0: 46,805.10\nRow #0: 47,401.25\nRow #0: 47,997.40\nRow #0: 48,593.55\nRow #0: 49,189.70\nRow #0: 49,785.85\nRow #0: 50,382.00\nRow #1: 45,539.69\nRow #1: 44,058.79\nRow #1: 50,029.87\nRow #1: 42,878.25\nRow #1: 44,456.29\nRow #1: 45,331.73\nRow #1: 50,246.88\nRow #1: 46,199.04\nRow #1: 43,825.97\nRow #1: 42,342.27\nRow #1: 53,363.71\nRow #1: 56,965.64\n");
        this.assertQueryReturns(query, expected);
    }

    public void testLinRegIntercept() {
        this.assertExprReturns("LinRegIntercept([Time].[Month].members, [Measures].[Unit Sales], [Measures].[Store Sales])", -126.65, 0.5);
        this.assertExprReturns("LinRegIntercept([Time].[Month].members, 7, [Measures].[Store Sales])", 7.0, 0.01);
    }

    public void testLinRegSlope() {
        this.assertExprReturns("LinRegSlope([Time].[Month].members, [Measures].[Unit Sales], [Measures].[Store Sales])", 0.4746, 0.5);
        this.assertExprReturns("LinRegSlope([Time].[Month].members, 7, [Measures].[Store Sales])", 0.0, 0.01);
    }

    public void testLinRegPoint() {
        this.assertExprReturns("LinRegPoint([Measures].[Unit Sales], [Time].[Month].members, 7, [Measures].[Store Sales])", 7.0, 0.01);
    }

    public void _testLinRegR2() {
        this.assertExprReturns("LinRegR2([Time].[Month].members, 7, [Measures].[Store Sales])", "$7.00");
    }

    public void _testLinRegVariance() {
        this.assertExprReturns("LinRegVariance([Time].[Month].members, [Measures].[Unit Sales], [Measures].[Store Sales])", "0.4746");
        this.assertExprReturns("LinRegVariance({[Time].Parent}, [Measures].[Unit Sales], [Measures].[Store Sales])", "-1.#IND");
        this.assertExprReturns("LinRegVariance([Time].[Month].members, 7, [Measures].[Store Sales])", "$7.00");
        this.assertExprReturns("LinRegVariance([Time].[Month].members, [Measures].[Unit Sales], 4)", "-1.#IND");
    }

    public void testVisualTotalsBasic() {
        this.assertQueryReturns("select {[Measures].[Unit Sales]} on columns, {VisualTotals(    {[Product].[All Products].[Food].[Baked Goods].[Bread],     [Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels],     [Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]},     \"**Subtotal - *\")} on rows from [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Baked Goods].[*Subtotal - Bread]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]}\nRow #0: 4,312\nRow #1: 815\nRow #2: 3,497\n"));
    }

    public void testVisualTotalsConsecutively() {
        this.assertQueryReturns("select {[Measures].[Unit Sales]} on columns, {VisualTotals(    {[Product].[All Products].[Food].[Baked Goods].[Bread],     [Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels],     [Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels],     [Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels].[Colony],     [Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels],     [Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]},     \"**Subtotal - *\")} on rows from [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Baked Goods].[*Subtotal - Bread]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[*Subtotal - Bagels]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels].[Colony]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]}\nRow #0: 5,290\nRow #1: 815\nRow #2: 163\nRow #3: 163\nRow #4: 815\nRow #5: 3,497\n"));
    }

    public void testVisualTotalsNoPattern() {
        this.assertAxisReturns("VisualTotals(    {[Product].[All Products].[Food].[Baked Goods].[Bread],     [Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels],     [Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]})", FunctionTest.fold("[Product].[All Products].[Food].[Baked Goods].[Bread]\n[Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels]\n[Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]"));
    }

    public void testVisualTotalsWithFilter() {
        this.assertQueryReturns("select {[Measures].[Unit Sales]} on columns, {Filter(    VisualTotals(        {[Product].[All Products].[Food].[Baked Goods].[Bread],         [Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels],         [Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]},        \"**Subtotal - *\"),[Measures].[Unit Sales] > 3400)} on rows from [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Baked Goods].[*Subtotal - Bread]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]}\nRow #0: 4,312\nRow #1: 3,497\n"));
    }

    public void testVisualTotalsNested() {
        this.assertQueryReturns("select {[Measures].[Unit Sales]} on columns, {VisualTotals(    Filter(        VisualTotals(            {[Product].[All Products].[Food].[Baked Goods].[Bread],             [Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels],             [Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]},            \"**Subtotal - *\"),    [Measures].[Unit Sales] > 3400),    \"Second total - *\")} on rows from [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Baked Goods].[*Subtotal - Bread]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]}\nRow #0: 4,312\nRow #1: 3,497\n"));
    }

    public void testVisualTotalsFilterInside() {
        this.assertQueryReturns("select {[Measures].[Unit Sales]} on columns, {VisualTotals(    Filter(        {[Product].[All Products].[Food].[Baked Goods].[Bread],         [Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels],         [Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]},        [Measures].[Unit Sales] > 3400),    \"**Subtotal - *\")} on rows from [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Baked Goods].[*Subtotal - Bread]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]}\nRow #0: 3,497\nRow #1: 3,497\n"));
    }

    public void testVisualTotalsOutOfOrder() {
        this.assertQueryReturns("select {[Measures].[Unit Sales]} on columns, {VisualTotals(    {[Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels],     [Product].[All Products].[Food].[Baked Goods].[Bread],     [Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]},    \"**Subtotal - *\")} on rows from [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels]}\n{[Product].[All Products].[Food].[Baked Goods].[*Subtotal - Bread]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]}\nRow #0: 815\nRow #1: 3,497\nRow #2: 3,497\n"));
    }

    public void testVisualTotalsGrandparentsAndOutOfOrder() {
        this.assertQueryReturns("select {[Measures].[Unit Sales]} on columns, {VisualTotals(    {[Product].[All Products].[Food],     [Product].[All Products].[Food].[Baked Goods].[Bread],     [Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels],     [Product].[All Products].[Food].[Frozen Foods].[Breakfast Foods],     [Product].[All Products].[Food].[Frozen Foods].[Breakfast Foods].[Pancake Mix].[Golden],     [Product].[All Products].[Food].[Frozen Foods].[Breakfast Foods].[Pancake Mix].[Big Time],     [Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]},    \"**Subtotal - *\")} on rows from [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Product].[All Products].[*Subtotal - Food]}\n{[Product].[All Products].[Food].[Baked Goods].[*Subtotal - Bread]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Bagels]}\n{[Product].[All Products].[Food].[Frozen Foods].[*Subtotal - Breakfast Foods]}\n{[Product].[All Products].[Food].[Frozen Foods].[Breakfast Foods].[Pancake Mix].[Golden]}\n{[Product].[All Products].[Food].[Frozen Foods].[Breakfast Foods].[Pancake Mix].[Big Time]}\n{[Product].[All Products].[Food].[Baked Goods].[Bread].[Muffins]}\nRow #0: 4,623\nRow #1: 815\nRow #2: 815\nRow #3: 311\nRow #4: 110\nRow #5: 201\nRow #6: 3,497\n"));
    }

    public void testVisualTotalsCrossjoin() {
        this.assertAxisThrows("VisualTotals(Crossjoin([Gender].Members, [Store].children))", "Argument to 'VisualTotals' function must be a set of members; got set of tuples.");
    }

    public void testCalculatedChild() {
        this.assertQueryReturns("with\n member [Product].[All Products].[Drink].[Calculated Child] as '[Product].[All Products].[Drink].[Alcoholic Beverages]'\n member [Product].[All Products].[Non-Consumable].[Calculated Child] as '[Product].[All Products].[Non-Consumable].[Carousel]'\n member [Measures].[Unit Sales CC] as '([Measures].[Unit Sales],[Product].currentmember.CalculatedChild(\"Calculated Child\"))'\n select non empty {[Measures].[Unit Sales CC]} on columns,\n non empty {[Product].[All Products].[Drink], [Product].[All Products].[Non-Consumable]} on rows\n from [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales CC]}\nAxis #2:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: 6,838\nRow #1: 841\n"));
        Member member = this.executeSingletonAxis("[Product].[All Products].CalculatedChild(\"foobar\")");
        Assert.assertEquals((Object)member, null);
    }

    public void testCalculatedChildUsingItem() {
        this.assertQueryReturns("with\n member [Product].[All Products].[Drink].[Calculated Child] as '[Product].[All Products].[Drink].[Alcoholic Beverages]'\n member [Product].[All Products].[Non-Consumable].[Calculated Child] as '[Product].[All Products].[Non-Consumable].[Carousel]'\n member [Measures].[Unit Sales CC] as '([Measures].[Unit Sales],AddCalculatedMembers([Product].currentmember.children).Item(\"Calculated Child\"))'\n select non empty {[Measures].[Unit Sales CC]} on columns,\n non empty {[Product].[All Products].[Drink], [Product].[All Products].[Non-Consumable]} on rows\n from [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales CC]}\nAxis #2:\n{[Product].[All Products].[Drink]}\n{[Product].[All Products].[Non-Consumable]}\nRow #0: 6,838\nRow #1: 6,838\n"));
        Member member = this.executeSingletonAxis("[Product].[All Products].CalculatedChild(\"foobar\")");
        Assert.assertEquals((Object)member, null);
    }

    public void testCalculatedChildOnMemberWithNoChildren() {
        Member member = this.executeSingletonAxis("[Measures].[Store Sales].CalculatedChild(\"foobar\")");
        Assert.assertEquals((Object)member, null);
    }

    public void testCalculatedChildOnNullMember() {
        Member member = this.executeSingletonAxis("[Measures].[Store Sales].parent.CalculatedChild(\"foobar\")");
        Assert.assertEquals((Object)member, null);
    }

    public void testCast() {
        this.assertExprReturns("0 + Cast(1 + 2 AS Integer)", "3");
        this.assertExprReturns("'' || Cast(1 + 2 AS String)", "3.0");
        this.assertExprReturns("1=1 AND Cast(1 + 2 AS Boolean)", "true");
        this.assertExprReturns("1=1 AND Cast(1 - 1 AS Boolean)", "false");
        this.assertExprReturns("'' || Cast(1 = 1 AND 1 = 2 AS String)", "false");
        this.assertExprReturns("1=1 AND Cast(1 = 1 AND 1 = 2 AS Boolean)", "false");
        this.assertExprReturns("0 * Cast(NULL AS Integer)", "");
        this.assertExprReturns("0 * Cast(NULL AS Numeric)", "");
        this.assertExprReturns("'' || Cast(NULL AS String)", "null");
        this.assertExprReturns("1=1 AND Cast(NULL AS Boolean)", "false");
        this.assertExprThrows("Cast(1 AS Double)", "Unknown type 'Double'; values are NUMERIC, STRING, BOOLEAN");
        this.assertExprThrows("Cast(1 AS 5)", "Syntax error at line 1, column 11, token '5.0'");
        this.assertExprReturns("Cast('tr' || 'ue' AS boolean)", "true");
    }

    public void testDumpFunctions() throws IOException {
        ArrayList<FunInfo> funInfoList = new ArrayList<FunInfo>();
        funInfoList.addAll(BuiltinFunTable.instance().getFunInfoList());
        funInfoList.add(new FunInfo(new UdfResolver(new CurrentDateMemberExactUdf())));
        funInfoList.add(new FunInfo(new UdfResolver(new CurrentDateMemberUdf())));
        funInfoList.add(new FunInfo(new UdfResolver(new CurrentDateStringUdf())));
        Collections.sort(funInfoList);
        File file = new File("functions.html");
        FileOutputStream os = new FileOutputStream(file);
        PrintWriter pw = new PrintWriter(os);
        pw.println("<table border='1'>");
        pw.println("<tr>");
        pw.println("<td><b>Name</b></td>");
        pw.println("<td><b>Description</b></td>");
        pw.println("</tr>");
        for (FunInfo funInfo : funInfoList) {
            pw.println("<tr>");
            pw.print("  <td valign=top><code>");
            FunctionTest.printHtml(pw, funInfo.getName());
            pw.println("</code></td>");
            pw.print("  <td>");
            if (funInfo.getDescription() != null) {
                FunctionTest.printHtml(pw, funInfo.getDescription());
            }
            pw.println();
            String[] signatures = funInfo.getSignatures();
            if (signatures != null) {
                pw.println("    <h1>Syntax</h1>");
                for (int j = 0; j < signatures.length; ++j) {
                    if (j > 0) {
                        pw.println("<br/>");
                    }
                    String signature = signatures[j];
                    pw.print("    ");
                    FunctionTest.printHtml(pw, signature);
                }
                pw.println();
            }
            pw.println("  </td>");
            pw.println("</tr>");
        }
        pw.println("</table>");
        pw.close();
    }

    public void testComplexOrExpr() {
        switch (TestContext.instance().getDialect().getDatabaseProduct()) {
            case INFOBRIGHT: {
                return;
            }
        }
        int origDepth = MondrianProperties.instance().MaxEvalDepth.get();
        MondrianProperties.instance().MaxEvalDepth.set(3);
        this.assertQueryReturns("with set [*NATIVE_CJ_SET] as '[Store].[Store Country].members' set [*GENERATED_MEMBERS_Measures] as '{[Measures].[Unit Sales], [Measures].[Store Cost], [Measures].[Sales Count], [Measures].[Customer Count], [Measures].[Promotion Sales]}' set [*GENERATED_MEMBERS] as 'Generate([*NATIVE_CJ_SET], {[Store].CurrentMember})' member [Store].[*SUBTOTAL_MEMBER_SEL~SUM] as 'Sum([*GENERATED_MEMBERS])' select [*GENERATED_MEMBERS_Measures] ON COLUMNS, NON EMPTY Filter(Generate([*NATIVE_CJ_SET], {[Store].CurrentMember}), (((((NOT IsEmpty([Measures].[Unit Sales])) OR (NOT IsEmpty([Measures].[Store Cost]))) OR (NOT IsEmpty([Measures].[Sales Count]))) OR (NOT IsEmpty([Measures].[Customer Count]))) OR (NOT IsEmpty([Measures].[Promotion Sales])))) on rows from [Sales]", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[Sales Count]}\n{[Measures].[Customer Count]}\n{[Measures].[Promotion Sales]}\nAxis #2:\n{[Store].[All Stores].[USA]}\nRow #0: 266,773\nRow #0: 225,627.23\nRow #0: 86,837\nRow #0: 5,581\nRow #0: 151,211.21\n"));
        MondrianProperties.instance().MaxEvalDepth.set(origDepth);
    }

    public void testLeftFunctionWithValidArguments() {
        this.assertQueryReturns("select filter([Store].MEMBERS,Left([Store].CURRENTMEMBER.Name, 4)=\"Bell\") on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testLeftFunctionWithLengthValueZero() {
        this.assertQueryReturns("select filter([Store].MEMBERS,Left([Store].CURRENTMEMBER.Name, 0)=\"\" And [Store].CURRENTMEMBER.Name = \"Bellingham\") on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testLeftFunctionWithLengthValueEqualToStringLength() {
        this.assertQueryReturns("select filter([Store].MEMBERS,Left([Store].CURRENTMEMBER.Name, 10)=\"Bellingham\") on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testLeftFunctionWithLengthMoreThanStringLength() {
        this.assertQueryReturns("select filter([Store].MEMBERS,Left([Store].CURRENTMEMBER.Name, 20)=\"Bellingham\") on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testLeftFunctionWithZeroLengthString() {
        this.assertQueryReturns("select filter([Store].MEMBERS,Left(\"\", 20)=\"\" And [Store].CURRENTMEMBER.Name = \"Bellingham\") on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testLeftFunctionWithNegativeLength() {
        this.assertThrows("select filter([Store].MEMBERS,Left([Store].CURRENTMEMBER.Name, -20)=\"Bellingham\") on 0 from sales", "StringIndexOutOfBoundsException: String index out of range: -20");
    }

    public void testMidFunctionWithValidArguments() {
        this.assertQueryReturns("select filter([Store].MEMBERS,[Store].CURRENTMEMBER.Name = \"Bellingham\"And Mid(\"Bellingham\", 4, 6) = \"lingha\")on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testMidFunctionWithZeroLengthStringArgument() {
        this.assertQueryReturns("select filter([Store].MEMBERS,[Store].CURRENTMEMBER.Name = \"Bellingham\"And Mid(\"\", 4, 6) = \"\")on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testMidFunctionWithLengthArgumentLargerThanStringLength() {
        this.assertQueryReturns("select filter([Store].MEMBERS,[Store].CURRENTMEMBER.Name = \"Bellingham\"And Mid(\"Bellingham\", 4, 20) = \"lingham\")on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testMidFunctionWithStartIndexGreaterThanStringLength() {
        this.assertQueryReturns("select filter([Store].MEMBERS,[Store].CURRENTMEMBER.Name = \"Bellingham\"And Mid(\"Bellingham\", 20, 2) = \"\")on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testMidFunctionWithStartIndexZero() {
        this.assertQueryReturns("select filter([Store].MEMBERS,[Store].CURRENTMEMBER.Name = \"Bellingham\"And Mid(\"Bellingham\", 0, 2) = \"Be\")on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testMidFunctionWithNegativeStartIndex() {
        this.assertThrows("select filter([Store].MEMBERS,[Store].CURRENTMEMBER.Name = \"Bellingham\"And Mid(\"Bellingham\", -20, 2) = \"\")on 0 from sales", "Invalid parameter. Start parameter of Mid function can't be negative");
    }

    public void testMidFunctionWithNegativeLength() {
        this.assertThrows("select filter([Store].MEMBERS,[Store].CURRENTMEMBER.Name = \"Bellingham\"And Mid(\"Bellingham\", 2, -2) = \"\")on 0 from sales", "Invalid parameter. Length parameter of Mid function can't be negative");
    }

    public void testMidFunctionWithoutLength() {
        this.assertQueryReturns("select filter([Store].MEMBERS,[Store].CURRENTMEMBER.Name = \"Bellingham\"And Mid(\"Bellingham\", 2) = \"ellingham\")on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testLenFunctionWithNonEmptyString() {
        this.assertQueryReturns("select filter([Store].MEMBERS, Len([Store].CURRENTMEMBER.Name) = 3) on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA]}\nRow #0: 266,773\n"));
    }

    public void testLenFunctionWithAnEmptyString() {
        this.assertQueryReturns("select filter([Store].MEMBERS,Len(\"\")=0 And [Store].CURRENTMEMBER.Name = \"Bellingham\") on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testUCaseWithNonEmptyString() {
        this.assertQueryReturns("select filter([Store].MEMBERS,  UCase([Store].CURRENTMEMBER.Name) = \"BELLINGHAM\") on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testUCaseWithEmptyString() {
        this.assertQueryReturns("select filter([Store].MEMBERS,  UCase(\"\") = \"\" And [Store].CURRENTMEMBER.Name = \"Bellingham\") on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testInStrFunctionWithValidArguments() {
        this.assertQueryReturns("select filter([Store].MEMBERS,InStr(\"Bellingham\", \"ingha\")=5 And [Store].CURRENTMEMBER.Name = \"Bellingham\") on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testIIFWithBooleanBooleanAndNumericParameterForReturningTruePart() {
        this.assertQueryReturns("SELECT Filter(Store.allmembers, iif(measures.profit < 400000,[store].currentMember.NAME = \"USA\", 0)) on 0 FROM SALES", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA]}\nRow #0: 266,773\n"));
    }

    public void testIIFWithBooleanBooleanAndNumericParameterForReturningFalsePart() {
        this.assertQueryReturns("SELECT Filter([Store].[All Stores].[USA].[CA].[Beverly Hills].children, iif(measures.profit > 400000,[store].currentMember.NAME = \"USA\", 1)) on 0 FROM SALES", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]}\nRow #0: 21,333\n"));
    }

    public void testIIFWithBooleanBooleanAndNumericParameterForReturningZero() {
        this.assertQueryReturns("SELECT Filter(Store.allmembers, iif(measures.profit > 400000,[store].currentMember.NAME = \"USA\", 0)) on 0 FROM SALES", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n"));
    }

    public void testInStrFunctionWithEmptyString1() {
        this.assertQueryReturns("select filter([Store].MEMBERS,InStr(\"\", \"ingha\")=0 And [Store].CURRENTMEMBER.Name = \"Bellingham\") on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testInStrFunctionWithEmptyString2() {
        this.assertQueryReturns("select filter([Store].MEMBERS,InStr(\"Bellingham\", \"\")=1 And [Store].CURRENTMEMBER.Name = \"Bellingham\") on 0 from sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[WA].[Bellingham]}\nRow #0: 2,237\n"));
    }

    public void testGetCaptionUsingMemberDotCaption() {
        this.assertQueryReturns("SELECT Filter(Store.allmembers, [store].currentMember.caption = \"USA\") on 0 FROM SALES", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA]}\nRow #0: 266,773\n"));
    }

    private static void printHtml(PrintWriter pw, String s) {
        String escaped = StringEscaper.htmlEscaper.escapeString(s);
        pw.print(escaped);
    }

    public void testCache() {
        this.assertExprReturns("Cache(1 + 2)", "3");
        this.assertExprReturns("Cache('foo' || 'bar')", "foobar");
        this.assertAxisReturns("[Gender].Children", FunctionTest.fold("[Gender].[All Gender].[F]\n[Gender].[All Gender].[M]"));
        this.assertAxisReturns("([Gender].[M], [Marital Status].[S].PrevMember)", "{[Gender].[All Gender].[M], [Marital Status].[All Marital Status].[M]}");
        this.assertAxisReturns("Order(Cache([Gender].Children), Cache(([Measures].[Unit Sales], [Time].[1997].[Q1])), BDESC)", FunctionTest.fold("[Gender].[All Gender].[M]\n[Gender].[All Gender].[F]"));
        this.assertExprThrows("Cache(1, 2)", "No function matches signature 'Cache(<Numeric Expression>, <Numeric Expression>)'");
    }

    public void testVbaBasic() {
        this.assertExprReturns("exp(0)", "1");
        this.assertExprReturns("exp(1)", Math.E, 1.0E-8);
        this.assertExprReturns("exp(-2)", 0.1353352832366127, 1.0E-8);
        this.assertExprReturns("exp(cast(null as numeric))", "");
    }

    public void testVbaOverloading() {
        this.assertExprReturns("replace('xyzxyz', 'xy', 'a')", "azaz");
        this.assertExprReturns("replace('xyzxyz', 'xy', 'a', 2)", "xyzaz");
        this.assertExprReturns("replace('xyzxyz', 'xy', 'a', 1, 1)", "azxyz");
    }

    public void testVbaExceptions() {
        this.assertExprThrows("right(\"abc\", -4)", "StringIndexOutOfBoundsException: String index out of range: -4");
    }

    public void testVbaDateTime() {
        this.assertExprReturns("Format(DateSerial(2006, 4, 29), \"Long Date\")", "Saturday, April 29, 2006");
        this.assertExprReturns("Year(DateSerial(2006, 4, 29))", "2,006");
    }

    public void testExcelPi() {
        this.assertExprReturns("Pi()", "3");
    }

    public void testExcelPower() {
        this.assertExprReturns("Power(8, 0.333333)", 2.0, 0.01);
        this.assertExprReturns("Power(-2, 0.5)", Double.NaN, 0.001);
    }

    public void testBug1881739() {
        this.assertExprReturns("LEFT(\"TEST\", LEN(\"TEST\"))", "TEST");
    }

    public void testCubeTimeDimensionFails() {
        this.assertThrows("select LastPeriods(1) on columns from [Store]", "'LastPeriods', no time dimension");
        this.assertThrows("select OpeningPeriod() on columns from [Store]", "'OpeningPeriod', no time dimension");
        this.assertThrows("select OpeningPeriod([Store Type]) on columns from [Store]", "'OpeningPeriod', no time dimension");
        this.assertThrows("select ClosingPeriod() on columns from [Store]", "'ClosingPeriod', no time dimension");
        this.assertThrows("select ClosingPeriod([Store Type]) on columns from [Store]", "'ClosingPeriod', no time dimension");
        this.assertThrows("select ParallelPeriod() on columns from [Store]", "'ParallelPeriod', no time dimension");
        this.assertThrows("select PeriodsToDate() on columns from [Store]", "'PeriodsToDate', no time dimension");
        this.assertThrows("select Mtd() on columns from [Store]", "'Mtd', no time dimension");
    }

    public void testFilterEmpty() {
        this.assertAxisReturns("Filter({}, 1=0)", "");
        this.assertAxisReturns("Filter({[Time].Children}, 1=0)", "");
    }

    public void testFilterCalcSlicer() {
        this.assertQueryReturns("with member [Time].[Date Range] as \n'Aggregate({[Time].[1997].[Q1]:[Time].[1997].[Q3]})'\nselect\n{[Measures].[Unit Sales],[Measures].[Store Cost],\n[Measures].[Store Sales]} ON columns,\nNON EMPTY Filter ([Store].[Store State].members,\n[Measures].[Store Cost] > 75000) ON rows\nfrom [Sales] where [Time].[Date Range]", FunctionTest.fold("Axis #0:\n{[Time].[Date Range]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[WA]}\nRow #0: 90,131\nRow #0: 76,151.59\nRow #0: 190,776.88\n"));
        this.assertQueryReturns("with member [Time].[Date Range] as \n'Aggregate({[Time].[1997].[Q1]:[Time].[1997].[Q3]})'\nselect\n{[Measures].[Unit Sales],[Measures].[Store Cost],\n[Measures].[Store Sales]} ON columns,\nNON EMPTY Order (Filter ([Store].[Store State].members,\n[Measures].[Store Cost] > 100),[Measures].[Store Cost], DESC) ON rows\nfrom [Sales] where [Time].[Date Range]", FunctionTest.fold("Axis #0:\n{[Time].[Date Range]}\nAxis #1:\n{[Measures].[Unit Sales]}\n{[Measures].[Store Cost]}\n{[Measures].[Store Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[WA]}\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\nRow #0: 90,131\nRow #0: 76,151.59\nRow #0: 190,776.88\nRow #1: 53,312\nRow #1: 45,435.93\nRow #1: 113,966.00\nRow #2: 51,306\nRow #2: 43,033.82\nRow #2: 107,823.63\n"));
    }

    public void testExistsMembersAll() {
        this.assertQueryReturns("select exists(\n  {[Customers].[All Customers],\n   [Customers].[Country].Members,\n   [Customers].[State Province].[CA],\n   [Customers].[Canada].[BC].[Richmond]},\n  {[Customers].[All Customers]})\non 0 from Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers]}\n{[Customers].[All Customers].[Canada]}\n{[Customers].[All Customers].[Mexico]}\n{[Customers].[All Customers].[USA]}\n{[Customers].[All Customers].[USA].[CA]}\n{[Customers].[All Customers].[Canada].[BC].[Richmond]}\nRow #0: 266,773\nRow #0: \nRow #0: \nRow #0: 266,773\nRow #0: 74,748\nRow #0: \n"));
    }

    public void testExistsMembersLevel2() {
        this.assertQueryReturns("select exists(\n  {[Customers].[All Customers],\n   [Customers].[Country].Members,\n   [Customers].[State Province].[CA],\n   [Customers].[Canada].[BC].[Richmond]},\n  {[Customers].[Country].[USA]})\non 0 from Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers]}\n{[Customers].[All Customers].[USA]}\n{[Customers].[All Customers].[USA].[CA]}\nRow #0: 266,773\nRow #0: 266,773\nRow #0: 74,748\n"));
    }

    public void testExistsMembersDiffDim() {
        this.assertQueryReturns("select exists(\n  {[Customers].[All Customers],\n   [Customers].[All Customers].Children,\n   [Customers].[State Province].Members},\n  {[Product].Members})\non 0 from Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n"));
    }

    public void testExistsMembers2Hierarchies() {
        this.assertQueryReturns("select exists(\n  {[Customers].[All Customers],\n   [Customers].[All Customers].Children,\n   [Customers].[State Province].Members,\n   [Customers].[Country].[Canada],\n   [Customers].[Country].[Mexico]},\n  {[Customers].[Country].[USA],\n   [Customers].[State Province].[Veracruz]})\non 0 from Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers]}\n{[Customers].[All Customers].[Mexico]}\n{[Customers].[All Customers].[USA]}\n{[Customers].[All Customers].[Mexico].[Veracruz]}\n{[Customers].[All Customers].[USA].[CA]}\n{[Customers].[All Customers].[USA].[OR]}\n{[Customers].[All Customers].[USA].[WA]}\n{[Customers].[All Customers].[Mexico]}\nRow #0: 266,773\nRow #0: \nRow #0: 266,773\nRow #0: \nRow #0: 74,748\nRow #0: 67,659\nRow #0: 124,366\nRow #0: \n"));
    }

    public void testExistsTuplesAll() {
        this.assertQueryReturns("select exists(\n  crossjoin({[Product].[All Products]},{[Customers].[All Customers]}),\n  {[Customers].[All Customers]})\non 0 from Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Product].[All Products], [Customers].[All Customers]}\nRow #0: 266,773\n"));
    }

    public void testExistsTuplesLevel2() {
        this.assertQueryReturns("select exists(\n  crossjoin({[Product].[All Products]},{[Customers].[All Customers].Children}),\n  {[Customers].[All Customers].[USA]})\non 0 from Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Product].[All Products], [Customers].[All Customers].[USA]}\nRow #0: 266,773\n"));
    }

    public void testExistsTuplesLevel23() {
        this.assertQueryReturns("select exists(\n  crossjoin({[Customers].[State Province].Members}, {[Product].[All Products]}),\n  {[Customers].[All Customers].[USA]})\non 0 from Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[CA], [Product].[All Products]}\n{[Customers].[All Customers].[USA].[OR], [Product].[All Products]}\n{[Customers].[All Customers].[USA].[WA], [Product].[All Products]}\nRow #0: 74,748\nRow #0: 67,659\nRow #0: 124,366\n"));
    }

    public void testExistsTuples2Dim() {
        this.assertQueryReturns("select exists(\n  crossjoin({[Customers].[State Province].Members}, {[Product].[Product Family].Members}),\n  {([Product].[Product Department].[Dairy],[Customers].[All Customers].[USA])})\non 0 from Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n{[Customers].[All Customers].[USA].[CA], [Product].[All Products].[Drink]}\n{[Customers].[All Customers].[USA].[OR], [Product].[All Products].[Drink]}\n{[Customers].[All Customers].[USA].[WA], [Product].[All Products].[Drink]}\nRow #0: 7,102\nRow #0: 6,106\nRow #0: 11,389\n"));
    }

    public void testExistsTuplesDiffDim() {
        this.assertQueryReturns("select exists(\n  crossjoin(\n    crossjoin({[Customers].[State Province].Members},\n              {[Time].[Year].[1997]}), \n    {[Product].[Product Family].Members}),\n  {([Product].[Product Department].[Dairy],\n    [Promotions].[All Promotions], \n    [Customers].[All Customers].[USA])})\non 0 from Sales", FunctionTest.fold("Axis #0:\n{}\nAxis #1:\n"));
    }
}

