/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.server;

import java.util.Collection;
import javax.swing.event.ChangeListener;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ServerRegistry {
    public static final String SERVERS_PATH = "Servers";
    private static ServerRegistry registry;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private final Lookup.Result<ServerInstanceProvider> result;

    private ServerRegistry() {
        Lookup lookup = Lookups.forPath((String)SERVERS_PATH);
        this.result = lookup.lookupResult(ServerInstanceProvider.class);
    }

    public static synchronized ServerRegistry getInstance() {
        if (registry == null) {
            registry = new ServerRegistry();
            ServerRegistry.registry.result.addLookupListener((LookupListener)new ProviderLookupListener(ServerRegistry.registry.changeSupport));
        }
        return registry;
    }

    public Collection<? extends ServerInstanceProvider> getProviders() {
        return this.result.allInstances();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private static class ProviderLookupListener
    implements LookupListener {
        private final ChangeSupport changeSupport;

        public ProviderLookupListener(ChangeSupport changeSupport) {
            this.changeSupport = changeSupport;
        }

        public void resultChanged(LookupEvent lookupEvent) {
            this.changeSupport.fireChange();
        }
    }
}

