/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.diff.builtin.visualizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.FontMetricsCache;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.openide.text.NbDocument;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;

public class LinesComponent
extends JComponent
implements Accessible,
PropertyChangeListener {
    private JEditorPane editorPane;
    private EditorUI editorUI;
    private Color backgroundColor;
    private Color foreColor;
    private Font font;
    private boolean init = false;
    private int numberWidth;
    private boolean showLineNumbers = true;
    private static final int ENLARGE_GUTTER_HEIGHT = 300;
    private int highestLineNumber = 0;
    private Insets lineNumberMargin;
    private int lineNumberDigitWidth;
    private LinkedList<String> linesList;
    private int activeLine = -1;
    private static final long serialVersionUID = -4861542695772182147L;

    public LinesComponent(JEditorPane jEditorPane) {
        this.editorPane = jEditorPane;
        this.font = this.editorPane.getFont();
        this.foreColor = this.editorPane.getForeground();
        this.backgroundColor = this.editorPane.getBackground();
        this.setLineNumberDigitWidth(10);
        this.setLineNumberMargin(new Insets(2, 2, 2, 4));
        this.editorUI = Utilities.getEditorUI((JTextComponent)this.editorPane);
        this.editorUI.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.editorUI));
        this.init();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new JComponent.AccessibleJComponent(){

                public AccessibleRole getAccessibleRole() {
                    return AccessibleRole.PANEL;
                }
            };
        }
        return this.accessibleContext;
    }

    protected void init() {
        this.createLines();
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(LinesComponent.class, (String)"ACSN_Lines_Component"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(LinesComponent.class, (String)"ACSD_Lines_Component"));
    }

    private void createLines() {
        this.linesList = new LinkedList();
        StyledDocument styledDocument = (StyledDocument)this.editorPane.getDocument();
        int n = styledDocument.getEndPosition().getOffset();
        int n2 = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)n);
        for (int i = 0; i < n2; ++i) {
            this.linesList.add(Integer.toString(i + 1));
        }
    }

    public void addEmptyLines(int n, int n2) {
        boolean bl = n > this.linesList.size();
        for (int i = 0; i < n2; ++i) {
            if (bl) {
                this.linesList.add("");
                continue;
            }
            this.linesList.add(n, "");
        }
    }

    public void insertNumbers(int n, int n2, int n3) {
        boolean bl;
        boolean bl2 = bl = n >= this.linesList.size();
        if (bl) {
            int n4 = 0;
            while (n4 < n3) {
                this.linesList.add(Integer.toString(n2));
                ++n4;
                ++n2;
            }
        } else {
            int n5 = Math.max(n + n3 - this.linesList.size(), 0);
            n3 -= n5;
            int n6 = 0;
            while (n6 < n3) {
                this.linesList.set(n, Integer.toString(n2));
                ++n6;
                ++n2;
                ++n;
            }
            n6 = 0;
            while (n6 < n5) {
                this.linesList.add(Integer.toString(n2));
                ++n6;
                ++n2;
            }
        }
    }

    public void removeNumbers(int n, int n2) {
        boolean bl;
        boolean bl2 = bl = n >= this.linesList.size();
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                this.linesList.add("");
            }
        } else {
            int n3 = Math.max(n + n2 - this.linesList.size(), 0);
            n2 -= n3;
            int n4 = 0;
            while (n4 < n2) {
                this.linesList.set(n, "");
                ++n4;
                ++n;
            }
            for (n4 = 0; n4 < n3; ++n4) {
                this.linesList.add("");
            }
        }
    }

    public void shrink(int n) {
        while (this.linesList.size() > n) {
            this.linesList.remove(n);
        }
    }

    private void updateState(Graphics graphics) {
        String string = DocumentUtilities.getMimeType((JTextComponent)this.editorPane);
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((String)string).lookup(FontColorSettings.class);
        Coloring coloring = Coloring.fromAttributeSet((AttributeSet)AttributesUtilities.createComposite((AttributeSet[])new AttributeSet[]{fontColorSettings.getFontColors("line-number"), fontColorSettings.getFontColors("default")}));
        this.foreColor = coloring.getForeColor();
        this.backgroundColor = coloring.getBackColor();
        this.font = coloring.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        this.showLineNumbers = true;
        this.init = true;
        if (this.highestLineNumber <= this.getLineCount()) {
            this.highestLineNumber = this.getLineCount();
        }
        int n = 1;
        char[] cArray = new char[1];
        for (int i = 0; i <= 9; ++i) {
            cArray[0] = (char)(48 + i);
            n = Math.max(n, fontMetrics.charsWidth(cArray, 0, 1));
        }
        this.setLineNumberDigitWidth(n);
        this.resize();
    }

    protected void resize() {
        Dimension dimension = new Dimension();
        dimension.width = this.getWidthDimension();
        dimension.height = this.getHeightDimension();
        dimension.height += 300 * this.editorUI.getLineHeight();
        this.numberWidth = this.getLineNumberWidth();
        this.setPreferredSize(dimension);
        this.revalidate();
    }

    protected int getLineCount() {
        return this.linesList.size();
    }

    protected int getDigitCount(int n) {
        return Integer.toString(n).length();
    }

    protected int getLineNumberWidth() {
        int n = 0;
        Insets insets = this.getLineNumberMargin();
        if (insets != null) {
            n += insets.left + insets.right;
        }
        return n += (this.getDigitCount(this.highestLineNumber) + 1) * this.getLineNumberDigitWidth();
    }

    protected int getWidthDimension() {
        int n = 0;
        if (this.showLineNumbers) {
            n += this.getLineNumberWidth();
        }
        return n;
    }

    protected int getHeightDimension() {
        return this.highestLineNumber * this.editorUI.getLineHeight();
    }

    public void paintComponent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        super.paintComponent(graphics);
        if (!this.init) {
            this.updateState(graphics);
        }
        Rectangle rectangle = graphics.getClipBounds();
        graphics.setColor(this.backgroundColor);
        graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.setFont(this.font);
        graphics.setColor(this.foreColor);
        FontMetrics fontMetrics = FontMetricsCache.getFontMetrics((Font)this.font, (Component)this);
        int n4 = 0;
        Insets insets = this.getLineNumberMargin();
        if (insets != null) {
            n4 = insets.right;
        }
        if ((n3 = (int)((float)rectangle.y / (float)(n2 = this.editorUI.getLineHeight()))) > 0) {
            --n3;
        }
        int n5 = n3 * n2;
        if (this.showLineNumbers && (n = (int)((float)(rectangle.y + rectangle.height) / (float)n2) + 1) > this.highestLineNumber) {
            int n6 = this.highestLineNumber;
            this.highestLineNumber = n;
            if (this.getDigitCount(this.highestLineNumber) > this.getDigitCount(n6)) {
                this.resize();
                return;
            }
        }
        n = this.editorUI.getLineAscent();
        while (n5 + n2 / 2 <= rectangle.y + rectangle.height) {
            if (this.showLineNumbers) {
                String string = null;
                if (n3 < this.linesList.size()) {
                    string = this.linesList.get(n3);
                }
                if (string == null) {
                    string = "";
                }
                String string2 = "*";
                int n7 = fontMetrics.stringWidth(string);
                if (n3 == this.activeLine - 1) {
                    string = string + string2;
                }
                int n8 = fontMetrics.stringWidth(string2);
                graphics.drawString(string, this.numberWidth - (n7 += n8) - n4, n5 + n);
            }
            n5 += n2;
            ++n3;
        }
    }

    public void changedLine(int n) {
        if (!this.init) {
            return;
        }
        int n2 = this.editorUI.getLineHeight();
        if (n > 0) {
            --n;
        }
        int n3 = n * n2;
        this.repaint(0, n3, (int)this.getSize().getWidth(), 3 * n2);
        this.checkSize();
    }

    public void changedAll() {
        if (!this.init) {
            return;
        }
        this.repaint();
        this.checkSize();
    }

    protected void checkSize() {
        int n = this.getLineCount();
        if (n > this.highestLineNumber) {
            this.highestLineNumber = n;
        }
        Dimension dimension = this.getPreferredSize();
        if (this.getWidthDimension() > dimension.width || this.getHeightDimension() > dimension.height) {
            this.resize();
        }
    }

    public Insets getLineNumberMargin() {
        return this.lineNumberMargin;
    }

    public void setLineNumberMargin(Insets insets) {
        this.lineNumberMargin = insets;
    }

    public int getLineNumberDigitWidth() {
        return this.lineNumberDigitWidth;
    }

    public void setLineNumberDigitWidth(int n) {
        this.lineNumberDigitWidth = n;
    }

    public int getActiveLine() {
        return this.activeLine;
    }

    public void setActiveLine(int n) {
        this.activeLine = n;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.init = false;
        this.repaint();
    }
}

