/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JViewport;
import javax.swing.ListCellRenderer;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.LocaleSupport;
import org.netbeans.modules.editor.completion.CompletionImpl;
import org.netbeans.modules.editor.completion.LazyListModel;
import org.netbeans.modules.editor.completion.ScreenBoundsProvider;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.LazyCompletionItem;

public class CompletionJList
extends JList {
    private static final int DARKER_COLOR_COMPONENT = 5;
    private final RenderComponent renderComponent;
    private Graphics cellPreferredSizeGraphics;
    private int fixedItemHeight;
    private int maxVisibleRowCount;
    private JTextComponent editorComponent;
    private int smartIndex;

    public CompletionJList(int n, MouseListener mouseListener, JTextComponent jTextComponent) {
        this.maxVisibleRowCount = n;
        this.editorComponent = jTextComponent;
        this.addMouseListener(mouseListener);
        this.setFont(jTextComponent.getFont());
        this.setLayoutOrientation(0);
        this.fixedItemHeight = Math.max(16, this.getFontMetrics(this.getFont()).getHeight());
        this.setFixedCellHeight(this.fixedItemHeight);
        this.setModel(new Model(Collections.EMPTY_LIST));
        this.setFocusable(false);
        this.renderComponent = new RenderComponent();
        this.setSelectionMode(0);
        this.setCellRenderer(new ListCellRenderer(){
            private ListCellRenderer defaultRenderer = new DefaultListCellRenderer();

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                if (object instanceof CompletionItem) {
                    Color color;
                    Color color2;
                    CompletionItem completionItem = (CompletionItem)object;
                    CompletionJList.this.renderComponent.setItem(completionItem);
                    CompletionJList.this.renderComponent.setSelected(bl);
                    CompletionJList.this.renderComponent.setSeparator(CompletionJList.this.smartIndex > 0 && CompletionJList.this.smartIndex == n);
                    if (bl) {
                        color2 = jList.getSelectionBackground();
                        color = jList.getSelectionForeground();
                    } else {
                        color2 = jList.getBackground();
                        if (n % 2 == 0) {
                            color2 = new Color(Math.abs(color2.getRed() - 5), Math.abs(color2.getGreen() - 5), Math.abs(color2.getBlue() - 5));
                        }
                        color = jList.getForeground();
                    }
                    if (CompletionJList.this.renderComponent.getBackground() != color2) {
                        CompletionJList.this.renderComponent.setBackground(color2);
                    }
                    if (CompletionJList.this.renderComponent.getForeground() != color) {
                        CompletionJList.this.renderComponent.setForeground(color);
                    }
                    return CompletionJList.this.renderComponent;
                }
                return this.defaultRenderer.getListCellRendererComponent(jList, object, n, bl, bl2);
            }
        });
        this.getAccessibleContext().setAccessibleName(LocaleSupport.getString((String)"ACSN_CompletionView"));
        this.getAccessibleContext().setAccessibleDescription(LocaleSupport.getString((String)"ACSD_CompletionView"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Map map;
        Map map2 = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        Map map3 = map = map2 instanceof Map ? map2 : null;
        if (map != null && graphics instanceof Graphics2D) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            RenderingHints renderingHints = graphics2D.getRenderingHints();
            graphics2D.setRenderingHints(map);
            try {
                super.paint(graphics2D);
            }
            finally {
                graphics2D.setRenderingHints(renderingHints);
            }
        } else {
            super.paint(graphics);
        }
    }

    void setData(List list) {
        this.smartIndex = -1;
        if (list != null) {
            int n = list.size();
            ListCellRenderer listCellRenderer = this.getCellRenderer();
            int n2 = 0;
            int n3 = this.getParent().getParent().getMaximumSize().width;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                Object e = list.get(i);
                if (e instanceof LazyCompletionItem) {
                    n3 = (int)((double)ScreenBoundsProvider.getScreenBounds((JTextComponent)this.editorComponent).width * 0.4);
                }
                Component component = listCellRenderer.getListCellRendererComponent(this, e, i, false, false);
                Dimension dimension = component.getPreferredSize();
                if (dimension.width > n2 && (n2 = dimension.width) >= n3) {
                    bl = true;
                }
                if (this.smartIndex < 0 && e instanceof CompletionItem && ((CompletionItem)e).getSortPriority() >= 0) {
                    this.smartIndex = i;
                }
                if (bl && this.smartIndex >= 0) break;
            }
            this.setFixedCellWidth(n2);
            LazyListModel lazyListModel = LazyListModel.create(new Model(list), CompletionImpl.filter, 1.0, LocaleSupport.getString((String)"completion-please-wait"));
            this.setModel(lazyListModel);
            if (n > 0) {
                this.setSelectedIndex(0);
            }
            int n4 = Math.min(n, this.maxVisibleRowCount);
            this.setVisibleRowCount(n4);
        }
    }

    public void up() {
        int n = this.getModel().getSize();
        if (n > 0) {
            int n2;
            for (n2 = (this.getSelectedIndex() - 1 + n) % n; n2 > 0 && this.getModel().getElementAt(n2) == null; --n2) {
            }
            this.setSelectedIndex(n2);
            this.ensureIndexIsVisible(n2);
        }
    }

    public void down() {
        int n = this.getModel().getSize();
        if (n > 0) {
            int n2;
            for (n2 = (this.getSelectedIndex() + 1) % n; n2 < n && this.getModel().getElementAt(n2) == null; ++n2) {
            }
            if (n2 == n) {
                n2 = 0;
            }
            this.setSelectedIndex(n2);
            this.ensureIndexIsVisible(n2);
        }
    }

    public void pageUp() {
        if (this.getModel().getSize() > 0) {
            int n;
            int n2 = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            for (n = Math.max(this.getSelectedIndex() - n2, 0); n > 0 && this.getModel().getElementAt(n) == null; --n) {
            }
            this.setSelectedIndex(n);
            this.ensureIndexIsVisible(n);
        }
    }

    public void pageDown() {
        int n = this.getModel().getSize();
        if (n > 0) {
            int n2;
            int n3 = Math.max(this.getLastVisibleIndex() - this.getFirstVisibleIndex(), 0);
            for (n2 = Math.min(this.getSelectedIndex() + n3, n - 1); n2 < n && this.getModel().getElementAt(n2) == null; ++n2) {
            }
            if (n2 == n) {
                for (n2 = Math.min(this.getSelectedIndex() + n3, n - 1); n2 > 0 && this.getModel().getElementAt(n2) == null; --n2) {
                }
            }
            this.setSelectedIndex(n2);
            this.ensureIndexIsVisible(n2);
        }
    }

    public void begin() {
        if (this.getModel().getSize() > 0) {
            this.setSelectedIndex(0);
            this.ensureIndexIsVisible(0);
        }
    }

    public void end() {
        int n = this.getModel().getSize();
        if (n > 0) {
            int n2;
            for (n2 = n - 1; n2 > 0 && this.getModel().getElementAt(n2) == null; --n2) {
            }
            this.setSelectedIndex(n2);
            this.ensureIndexIsVisible(n2);
        }
    }

    private final class RenderComponent
    extends JComponent {
        private CompletionItem item;
        private boolean selected;
        private boolean separator;

        private RenderComponent() {
        }

        void setItem(CompletionItem completionItem) {
            this.item = completionItem;
        }

        void setSelected(boolean bl) {
            this.selected = bl;
        }

        void setSeparator(boolean bl) {
            this.separator = bl;
        }

        public void paintComponent(Graphics graphics) {
            int n = ((JViewport)CompletionJList.this.getParent()).getWidth();
            Color color = this.getBackground();
            Color color2 = this.getForeground();
            int n2 = this.getHeight();
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color2);
            this.item.render(graphics, CompletionJList.this.getFont(), this.getForeground(), color, n, this.getHeight(), this.selected);
            if (this.separator) {
                graphics.setColor(Color.gray);
                graphics.drawLine(0, 0, n, 0);
                graphics.setColor(color2);
            }
        }

        public Dimension getPreferredSize() {
            if (CompletionJList.this.cellPreferredSizeGraphics == null) {
                CompletionJList.this.cellPreferredSizeGraphics = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().createCompatibleImage(1, 1).getGraphics();
                assert (CompletionJList.this.cellPreferredSizeGraphics != null);
            }
            return new Dimension(this.item.getPreferredWidth(CompletionJList.this.cellPreferredSizeGraphics, CompletionJList.this.getFont()), CompletionJList.this.fixedItemHeight);
        }
    }

    private final class Model
    extends AbstractListModel {
        List data;

        public Model(List list) {
            this.data = list;
        }

        public int getSize() {
            return this.data.size();
        }

        public Object getElementAt(int n) {
            return n >= 0 && n < this.data.size() ? this.data.get(n) : null;
        }
    }
}

