/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.jrctx.nodes.editors;

import com.jaspersoft.ireport.designer.sheet.editors.box.ColorSelectorPanel2;
import java.awt.BorderLayout;
import net.sf.jasperreports.chartthemes.simple.ColorProvider;
import net.sf.jasperreports.chartthemes.simple.GradientPaintProvider;
import net.sf.jasperreports.chartthemes.simple.PaintProvider;

/**
 * @author Teodor Danciu (teodord@users.sourceforge.net)
 * @version $Id: JasperDesignViewer.java 1988 2007-12-04 16:17:57Z teodord $
 */
public class PaintProviderEditorPanel extends javax.swing.JPanel  
{
//    private ColorProvider colorProvider = null;
//    private GradientPaintProvider gradientPaintProvider = null;
    
    private ColorSelectorPanel2 colorSelector = null;
    private ColorSelectorPanel2 firstColorSelector = null;
    private ColorSelectorPanel2 secondColorSelector = null;

    
    /** Creates new form PenEditorPanel */
    public PaintProviderEditorPanel() 
    {
        initComponents();
        
        colorSelector = new ColorSelectorPanel2();
        pnlColorSelector.add(colorSelector, BorderLayout.CENTER);
        firstColorSelector = new ColorSelectorPanel2();
        pnlFirstColorSelector.add(firstColorSelector, BorderLayout.CENTER);
        secondColorSelector = new ColorSelectorPanel2();
        pnlSecondColorSelector.add(secondColorSelector, BorderLayout.CENTER);
        
//        colorSelector.addActionListener(
//            new ActionListener()
//            {
//                public void actionPerformed(ActionEvent e)
//                {
//                    setPaintProvider(new ColorProvider(colorSelector.getColor()));
//                }
//            });
//        
//        firstColorSelector.addActionListener(
//            new ActionListener()
//            {
//                public void actionPerformed(ActionEvent e)
//                {
//                    setPaintProvider(
//                        new GradientPaintProvider(
//                            0, 0,
//                            firstColorSelector.getColor(),
//                            0, 0,
//                            secondColorSelector.getColor()
//                            )
//                        );
//                }
//            });
//        
//        secondColorSelector.addActionListener(
//            new ActionListener()
//            {
//                public void actionPerformed(ActionEvent e)
//                {
//                    setPaintProvider(
//                        new GradientPaintProvider(
//                            0, 0,
//                            firstColorSelector.getColor(),
//                            0, 0,
//                            secondColorSelector.getColor()
//                            )
//                        );
//                }
//            });
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        lblPaint = new javax.swing.JLabel();
        cmbPaint = new javax.swing.JComboBox();
        jSeparator1 = new javax.swing.JSeparator();
        jPanel5 = new javax.swing.JPanel();
        pnlColor = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        pnlColorSelector = new javax.swing.JPanel();
        pnlGradient = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        pnlFirstColorSelector = new javax.swing.JPanel();
        jLabel3 = new javax.swing.JLabel();
        pnlSecondColorSelector = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        lblPaint.setText(org.openide.util.NbBundle.getMessage(PaintProviderEditorPanel.class, "PaintProviderEditorPanel.lblPaint.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(lblPaint, gridBagConstraints);

        cmbPaint.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Color", "Gradient" }));
        cmbPaint.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cmbPaintActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 4);
        add(cmbPaint, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(jSeparator1, gridBagConstraints);

        jPanel5.setMinimumSize(new java.awt.Dimension(220, 10));
        jPanel5.setPreferredSize(new java.awt.Dimension(220, 10));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        add(jPanel5, gridBagConstraints);

        pnlColor.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText(org.openide.util.NbBundle.getMessage(PaintProviderEditorPanel.class, "PaintProviderEditorPanel.jLabel1.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        pnlColor.add(jLabel1, gridBagConstraints);

        pnlColorSelector.setMinimumSize(new java.awt.Dimension(120, 21));
        pnlColorSelector.setPreferredSize(new java.awt.Dimension(120, 21));
        pnlColorSelector.setLayout(new java.awt.BorderLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 4);
        pnlColor.add(pnlColorSelector, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        add(pnlColor, gridBagConstraints);

        pnlGradient.setLayout(new java.awt.GridBagLayout());

        jLabel2.setText(org.openide.util.NbBundle.getMessage(PaintProviderEditorPanel.class, "PaintProviderEditorPanel.jLabel2.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 0, 0);
        pnlGradient.add(jLabel2, gridBagConstraints);

        pnlFirstColorSelector.setMinimumSize(new java.awt.Dimension(120, 21));
        pnlFirstColorSelector.setPreferredSize(new java.awt.Dimension(120, 21));
        pnlFirstColorSelector.setLayout(new java.awt.BorderLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 0, 4);
        pnlGradient.add(pnlFirstColorSelector, gridBagConstraints);

        jLabel3.setText(org.openide.util.NbBundle.getMessage(PaintProviderEditorPanel.class, "PaintProviderEditorPanel.jLabel3.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 0);
        pnlGradient.add(jLabel3, gridBagConstraints);

        pnlSecondColorSelector.setMinimumSize(new java.awt.Dimension(120, 21));
        pnlSecondColorSelector.setPreferredSize(new java.awt.Dimension(120, 21));
        pnlSecondColorSelector.setLayout(new java.awt.BorderLayout());
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        pnlGradient.add(pnlSecondColorSelector, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        add(pnlGradient, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.VERTICAL;
        gridBagConstraints.weighty = 1.0;
        add(jPanel4, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

private void cmbPaintActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cmbPaintActionPerformed
// TODO add your handling code here:
    pnlColor.setVisible(cmbPaint.getSelectedIndex() == 0);
    pnlGradient.setVisible(!pnlColor.isVisible());
}//GEN-LAST:event_cmbPaintActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox cmbPaint;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JLabel lblPaint;
    private javax.swing.JPanel pnlColor;
    private javax.swing.JPanel pnlColorSelector;
    private javax.swing.JPanel pnlFirstColorSelector;
    private javax.swing.JPanel pnlGradient;
    private javax.swing.JPanel pnlSecondColorSelector;
    // End of variables declaration//GEN-END:variables

    public PaintProvider getPaintProvider() {
        if (cmbPaint.getSelectedIndex() == 0)
        {
            if (colorSelector.getColor() == null)
            {
                return null;
            }

            return new ColorProvider(colorSelector.getColor());
        }

        if (firstColorSelector.getColor() == null && secondColorSelector.getColor() == null)
        {
            return null;
        }

        if (firstColorSelector.getColor() == null)
        {
            return new ColorProvider(secondColorSelector.getColor());
        }
        
        if (secondColorSelector.getColor() == null)
        {
            return new ColorProvider(firstColorSelector.getColor());
        }
        
        return 
            new GradientPaintProvider(
                firstColorSelector.getColor(),
                secondColorSelector.getColor()
                );
    }

    public void setPaintProvider(PaintProvider paintProvider) 
    {
        ColorProvider colorProvider = paintProvider instanceof ColorProvider ? (ColorProvider)paintProvider : null;
        GradientPaintProvider gradientPaintProvider = paintProvider instanceof GradientPaintProvider ? (GradientPaintProvider)paintProvider : null;

        if (gradientPaintProvider == null)
        {
            cmbPaint.setSelectedIndex(0);
        }
        else
        {
            cmbPaint.setSelectedIndex(1);
        }

        colorSelector.setColor(colorProvider == null ? null : colorProvider.getColor());
        firstColorSelector.setColor(gradientPaintProvider == null ? null : gradientPaintProvider.getColor1());
        secondColorSelector.setColor(gradientPaintProvider == null ? null : gradientPaintProvider.getColor2());
    }

}
