/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.connection.JDBCConnection;
import com.jaspersoft.ireport.designer.connection.MondrianConnection;
import java.util.List;

/**
 *
 * @author  gtoffoli
 */
public class MondrianConnectionEditor extends javax.swing.JPanel implements IReportConnectionEditor {
    
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    
    /** Creates new form EJBQLConnectionEditor */
    public MondrianConnectionEditor() {
        initComponents();
        
        List<IReportConnection> conns = IReportManager.getInstance().getConnections();
        for (IReportConnection con : conns)
        {
           if (con instanceof JDBCConnection)
            {
                jComboBoxMondrianJdbc.addItem( con.getName() );
            }
        }
        
        if (jComboBoxMondrianJdbc.getItemCount() > 0)
        {
            jComboBoxMondrianJdbc.setSelectedIndex(0);
        }
        
        //applyI18n();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelMondrian = new javax.swing.JPanel();
        jLabel20 = new javax.swing.JLabel();
        jComboBoxMondrianJdbc = new javax.swing.JComboBox();
        jLabel19 = new javax.swing.JLabel();
        jTextFieldCatalogURI = new javax.swing.JTextField();
        jButtonBrowseCatalog = new javax.swing.JButton();
        jPanel14 = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        jPanelMondrian.setLayout(new java.awt.GridBagLayout());

        jLabel20.setText("JDBC接続");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        jPanelMondrian.add(jLabel20, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanelMondrian.add(jComboBoxMondrianJdbc, gridBagConstraints);

        jLabel19.setText("カタログURI (例：file:/path/schema.xml) ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        jPanelMondrian.add(jLabel19, gridBagConstraints);

        jTextFieldCatalogURI.setMargin(new java.awt.Insets(0, 5, 2, 4));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 3, 4);
        jPanelMondrian.add(jTextFieldCatalogURI, gridBagConstraints);

        jButtonBrowseCatalog.setText("参照...");
        jButtonBrowseCatalog.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonBrowseCatalogActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        jPanelMondrian.add(jButtonBrowseCatalog, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        jPanelMondrian.add(jPanel14, gridBagConstraints);

        add(jPanelMondrian, java.awt.BorderLayout.CENTER);

    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonBrowseCatalog;
    private javax.swing.JComboBox jComboBoxMondrianJdbc;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JPanel jPanel14;
    private javax.swing.JPanel jPanelMondrian;
    private javax.swing.JTextField jTextFieldCatalogURI;
    // End of variables declaration//GEN-END:variables
    
    
    public void setIReportConnection(IReportConnection c) {
        this.iReportConnection = c;
        
        
        if (iReportConnection instanceof MondrianConnection)
        {
            MondrianConnection con = (MondrianConnection)iReportConnection;
            this.jTextFieldCatalogURI.setText( Misc.nvl(con.getProperties().get(MondrianConnection.CATALOG_URI), "") );            
            jComboBoxMondrianJdbc.setSelectedItem( con.getConnectionName() );
        }
    }

    @SuppressWarnings("unchecked")
    public IReportConnection getIReportConnection() {
        
        if (this.jComboBoxMondrianJdbc.getSelectedIndex() < 0) {
            javax.swing.JOptionPane.showMessageDialog(this,
                    //I18n.getString("messages.connectionDialog.setJDBCConnection",
                    "You have to choose a JDBC connection in order to configure the Mondrian OLAP connection.\nIf JDBC connection are not yet available, please create one before creating this connection.",
                    //I18n.getString("messages.connectionDialog.setJDBCConnectionCaption",
                    "Invalid JDBC connection!",javax.swing.JOptionPane.WARNING_MESSAGE );
            return null;
        }

        if (this.jTextFieldCatalogURI.getText().trim().length() == 0) {
            javax.swing.JOptionPane.showMessageDialog(this,
                    //I18n.getString("messages.connectionDialog.setCatalogUri",
                    "Please set the Catalog URI",
                    //I18n.getString("messages.connectionDialog.setCatalogUriCaption",
                    "Invalid URI!",javax.swing.JOptionPane.WARNING_MESSAGE );
            return null;
        }

        IReportConnection irConn = new MondrianConnection();
        irConn.getProperties().put(MondrianConnection.CATALOG_URI, jTextFieldCatalogURI.getText().trim());
        irConn.getProperties().put(MondrianConnection.CONNECTION_NAME, jComboBoxMondrianJdbc.getSelectedItem()+"");
        
        iReportConnection = irConn;
        return iReportConnection;
    }
    
    /*
    public void applyI18n(){
                jButtonBrowseCatalog.setText(I18n.getString("connectionDialog.buttonBrowseCatalog","Browse..."));
                jLabel19.setText(I18n.getString("connectionDialog.label19","Catalog URI (i.e. file:/path/schema.xml)"));
                jLabel20.setText(I18n.getString("connectionDialog.label20","Jdbc Connection"));
                
    }
     */
    
    
    private void jButtonBrowseCatalogActionPerformed(java.awt.event.ActionEvent evt) {                                                     
            
            
	    javax.swing.JFileChooser jfc = new javax.swing.JFileChooser( IReportManager.getInstance().getCurrentDirectory());
	    
	    jfc.setDialogTitle("Select file....");
	    
	    jfc.addChoosableFileFilter( new javax.swing.filechooser.FileFilter() {
		    public boolean accept(java.io.File file) {
			    String filename = file.getName();
			    return (filename.toLowerCase().endsWith(".xml") || file.isDirectory()) ;
		    }
		    public String getDescription() {
			    return "XML *.xml";
		    }
	    });
	    
	    jfc.setMultiSelectionEnabled(false);
	    jfc.setDialogType( javax.swing.JFileChooser.OPEN_DIALOG);
	    if  (jfc.showOpenDialog( this) == javax.swing.JOptionPane.OK_OPTION) {
		    java.io.File file = jfc.getSelectedFile();		
                    try {
                        jTextFieldCatalogURI.setText( file.toURI() + "");
                    } catch (Exception ex){}
	    }        
        
        
    } 
    
    
}
