/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.BitSet;
import junit.framework.Assert;
import junit.framework.TestCase;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;

public class BitKeyTest
extends TestCase {
    public BitKeyTest(String name) {
        super(name);
    }

    public void testBadSize() {
        int size = -1;
        boolean gotException = false;
        BitKey bitKey = null;
        try {
            bitKey = BitKey.Factory.makeBitKey(size);
            Util.discard((Object)bitKey);
        }
        catch (IllegalArgumentException e) {
            gotException = true;
        }
        BitKeyTest.assertTrue((String)("BitKey negative size " + size), (boolean)gotException);
        size = -10;
        gotException = false;
        try {
            bitKey = BitKey.Factory.makeBitKey(size);
        }
        catch (IllegalArgumentException e) {
            gotException = true;
        }
        BitKeyTest.assertTrue((String)("BitKey negative size " + size), (boolean)gotException);
    }

    public void testGoodSize() {
        int size = 0;
        boolean gotException = false;
        BitKey bitKey = null;
        try {
            bitKey = BitKey.Factory.makeBitKey(size);
            Util.discard((Object)bitKey);
        }
        catch (IllegalArgumentException e) {
            gotException = true;
        }
        BitKeyTest.assertTrue((String)("BitKey size " + size), (!gotException ? 1 : 0) != 0);
        size = 1;
        gotException = false;
        try {
            bitKey = BitKey.Factory.makeBitKey(size);
        }
        catch (IllegalArgumentException e) {
            gotException = true;
        }
        BitKeyTest.assertTrue((String)("BitKey size " + size), (!gotException ? 1 : 0) != 0);
        size = 10;
        gotException = false;
        try {
            bitKey = BitKey.Factory.makeBitKey(size);
        }
        catch (IllegalArgumentException e) {
            gotException = true;
        }
        BitKeyTest.assertTrue((String)("BitKey size " + size), (!gotException ? 1 : 0) != 0);
    }

    public void testSizeTypes() {
        int size = 0;
        BitKey bitKey = BitKey.Factory.makeBitKey(size);
        BitKeyTest.assertTrue((String)("BitKey size " + size + " not BitKey.Small"), (bitKey.getClass() == BitKey.Small.class ? 1 : 0) != 0);
        size = 63;
        bitKey = BitKey.Factory.makeBitKey(size);
        BitKeyTest.assertTrue((String)("BitKey size " + size + " not BitKey.Small"), (bitKey.getClass() == BitKey.Small.class ? 1 : 0) != 0);
        size = 64;
        bitKey = BitKey.Factory.makeBitKey(size);
        BitKeyTest.assertTrue((String)("BitKey size " + size + " not BitKey.Mid128"), (bitKey.getClass() == BitKey.Mid128.class ? 1 : 0) != 0);
        size = 65;
        bitKey = BitKey.Factory.makeBitKey(size);
        BitKeyTest.assertTrue((String)("BitKey size " + size + " not BitKey.Mid128"), (bitKey.getClass() == BitKey.Mid128.class ? 1 : 0) != 0);
        size = 127;
        bitKey = BitKey.Factory.makeBitKey(size);
        BitKeyTest.assertTrue((String)("BitKey size " + size + " not BitKey.Mid128"), (bitKey.getClass() == BitKey.Mid128.class ? 1 : 0) != 0);
        size = 128;
        bitKey = BitKey.Factory.makeBitKey(size);
        BitKeyTest.assertTrue((String)("BitKey size " + size + " not BitKey.Big"), (bitKey.getClass() == BitKey.Big.class ? 1 : 0) != 0);
        size = 129;
        bitKey = BitKey.Factory.makeBitKey(size);
        BitKeyTest.assertTrue((String)("BitKey size " + size + " not BitKey.Big"), (bitKey.getClass() == BitKey.Big.class ? 1 : 0) != 0);
        size = 1280;
        bitKey = BitKey.Factory.makeBitKey(size);
        BitKeyTest.assertTrue((String)("BitKey size " + size + " not BitKey.Big"), (bitKey.getClass() == BitKey.Big.class ? 1 : 0) != 0);
    }

    public void testEquals() {
        int[][] positionsArray0 = new int[][]{{0, 1, 2, 3}, {3, 17, 33, 63}, {1, 2, 3, 20, 21, 33, 61, 62, 63}};
        this.doTestEquals(0, 0, positionsArray0);
        this.doTestEquals(0, 64, positionsArray0);
        this.doTestEquals(64, 0, positionsArray0);
        this.doTestEquals(0, 128, positionsArray0);
        this.doTestEquals(128, 0, positionsArray0);
        this.doTestEquals(64, 128, positionsArray0);
        this.doTestEquals(128, 64, positionsArray0);
        int[][] positionsArray1 = new int[][]{{0, 1, 2, 3}, {3, 17, 33, 63}, {1, 2, 3, 20, 21, 33, 61, 62, 63}, {1, 2, 3, 20, 21, 33, 61, 62, 55, 56, 127}};
        this.doTestEquals(65, 65, positionsArray1);
        this.doTestEquals(65, 128, positionsArray1);
        this.doTestEquals(128, 65, positionsArray1);
        this.doTestEquals(128, 128, positionsArray1);
        int[][] positionsArray2 = new int[][]{{0, 1, 2, 3}, {1, 2, 3, 20, 21, 33, 61, 62, 55, 56, 127, 128}, {1, 2, 499}, {1, 2, 200, 300, 499}};
        this.doTestEquals(500, 500, positionsArray2);
        this.doTestEquals(500, 700, positionsArray2);
        this.doTestEquals(700, 500, positionsArray2);
        this.doTestEquals(700, 700, positionsArray2);
    }

    public void testHashCode() {
        int i;
        BitKey small = BitKey.Factory.makeBitKey(10);
        BitKey mid = BitKey.Factory.makeBitKey(70);
        BitKey big255 = BitKey.Factory.makeBitKey(255);
        BitKey big256 = BitKey.Factory.makeBitKey(256);
        BitKey big257 = BitKey.Factory.makeBitKey(257);
        BitKey[] bitKeys = new BitKey[]{small, mid, big255, big256, big257};
        this.doHashCode(bitKeys);
        for (i = 0; i < bitKeys.length; ++i) {
            bitKeys[i].set(0, true);
        }
        this.doHashCode(bitKeys);
        bitKeys = new BitKey[]{mid, big255, big256, big257};
        for (i = 0; i < bitKeys.length; ++i) {
            bitKeys[i].set(50, true);
        }
        this.doHashCode(bitKeys);
        bitKeys = new BitKey[]{big255, big256, big257};
        for (i = 0; i < bitKeys.length; ++i) {
            bitKeys[i].set(128, true);
            bitKeys[i].set(50, false);
        }
        this.doHashCode(bitKeys);
    }

    private void doHashCode(BitKey[] bitKeys) {
        for (int i1 = 0; i1 < bitKeys.length; ++i1) {
            BitKey bitKey1 = bitKeys[i1];
            for (int i2 = 0; i2 < bitKeys.length; ++i2) {
                BitKey bitKey2 = bitKeys[i2];
                String s = "(" + i1 + ", " + i2 + ")";
                BitKeyTest.assertEquals((String)s, (Object)bitKey1, (Object)bitKey2);
                BitKeyTest.assertEquals((String)s, (int)bitKey1.hashCode(), (int)bitKey2.hashCode());
                BitKeyTest.assertEquals((String)s, (int)0, (int)bitKey1.compareTo(bitKey2));
            }
        }
    }

    public void testNotEquals() {
        int[] positions0 = new int[]{0, 1, 2, 3, 4};
        int[] positions1 = new int[]{0, 1, 2, 3};
        this.doTestNotEquals(0, positions0, 0, positions1);
        this.doTestNotEquals(0, positions1, 0, positions0);
        this.doTestNotEquals(0, positions0, 64, positions1);
        this.doTestNotEquals(0, positions1, 64, positions0);
        this.doTestNotEquals(64, positions0, 0, positions1);
        this.doTestNotEquals(64, positions1, 0, positions0);
        this.doTestNotEquals(0, positions0, 128, positions1);
        this.doTestNotEquals(128, positions1, 0, positions0);
        this.doTestNotEquals(64, positions0, 128, positions1);
        this.doTestNotEquals(128, positions1, 64, positions0);
        this.doTestNotEquals(128, positions0, 128, positions1);
        this.doTestNotEquals(128, positions1, 128, positions0);
        int[] positions2 = new int[]{0, 1};
        int[] positions3 = new int[]{0, 1, 113};
        this.doTestNotEquals(0, positions2, 127, positions3);
        this.doTestNotEquals(127, positions3, 0, positions2);
        int[] positions4 = new int[]{0, 1, 100, 121};
        int[] positions5 = new int[]{0, 1, 100, 121, 200};
        this.doTestNotEquals(127, positions4, 300, positions5);
        this.doTestNotEquals(300, positions5, 127, positions4);
        int[] positions6 = new int[]{0, 1, 100, 121, 200};
        int[] positions7 = new int[]{0, 1, 100, 121, 130, 200};
        this.doTestNotEquals(200, positions6, 300, positions7);
        this.doTestNotEquals(300, positions7, 200, positions6);
    }

    public void testClear() {
        BitKey bitKey_0 = BitKey.Factory.makeBitKey(0);
        BitKey bitKey_64 = BitKey.Factory.makeBitKey(64);
        BitKey bitKey_128 = BitKey.Factory.makeBitKey(128);
        int size0 = 20;
        int[] positions0 = new int[]{0, 1, 2, 3, 4};
        BitKey bitKey0 = BitKeyTest.makeAndSet(size0, positions0);
        bitKey0.clear();
        BitKeyTest.assertTrue((String)"BitKey 0 not equals after clear to 0", (boolean)bitKey0.equals(bitKey_0));
        BitKeyTest.assertTrue((String)"BitKey 0 not equals after clear to 64", (boolean)bitKey0.equals(bitKey_64));
        BitKeyTest.assertTrue((String)"BitKey 0 not equals after clear to 128", (boolean)bitKey0.equals(bitKey_128));
        int size1 = 68;
        int[] positions1 = new int[]{0, 1, 2, 3, 4, 45, 67};
        BitKey bitKey1 = BitKeyTest.makeAndSet(size1, positions1);
        bitKey1.clear();
        BitKeyTest.assertTrue((String)"BitKey 1 not equals after clear to 0", (boolean)bitKey1.equals(bitKey_0));
        BitKeyTest.assertTrue((String)"BitKey 1 not equals after clear to 64", (boolean)bitKey1.equals(bitKey_64));
        BitKeyTest.assertTrue((String)"BitKey 1 not equals after clear to 128", (boolean)bitKey1.equals(bitKey_128));
        int size2 = 400;
        int[] positions2 = new int[]{0, 1, 2, 3, 4, 45, 67, 213, 333};
        BitKey bitKey2 = BitKeyTest.makeAndSet(size2, positions2);
        bitKey2.clear();
        BitKeyTest.assertTrue((String)"BitKey 2 not equals after clear to 0", (boolean)bitKey2.equals(bitKey_0));
        BitKeyTest.assertTrue((String)"BitKey 2 not equals after clear to 64", (boolean)bitKey2.equals(bitKey_64));
        BitKeyTest.assertTrue((String)"BitKey 2 not equals after clear to 128", (boolean)bitKey2.equals(bitKey_128));
    }

    public void testNewBitKeyIsTheSameAsAClearedBitKey() {
        BitKey bitKey = BitKey.Factory.makeBitKey(8);
        bitKey.set(1);
        BitKeyTest.assertFalse((boolean)BitKey.Factory.makeBitKey(8).equals(bitKey));
        bitKey.clear();
        BitKeyTest.assertEquals((Object)BitKey.Factory.makeBitKey(8), (Object)bitKey);
    }

    public void testEmptyCopyCreatesBitKeyOfTheSameSize() {
        BitKey bitKey = BitKey.Factory.makeBitKey(8);
        BitKeyTest.assertEquals((Object)bitKey, (Object)bitKey.emptyCopy());
    }

    public void testIsSuperSetOf() {
        int size0 = 20;
        int[] positions0 = new int[]{0, 2, 3, 4, 23, 30};
        BitKey bitKey0 = BitKeyTest.makeAndSet(size0, positions0);
        int size1 = 20;
        int[] positions1 = new int[]{0, 2, 23};
        BitKey bitKey1 = BitKeyTest.makeAndSet(size1, positions1);
        BitKeyTest.assertTrue((String)"BitKey 1 not subset of 0", (boolean)bitKey0.isSuperSetOf(bitKey1));
        BitKeyTest.assertTrue((String)"BitKey 0 is subset of 1", (!bitKey1.isSuperSetOf(bitKey0) ? 1 : 0) != 0);
        int size2 = 65;
        int[] positions2 = new int[]{0, 1, 2, 3, 4, 23, 30, 113};
        BitKey bitKey2 = BitKeyTest.makeAndSet(size2, positions2);
        BitKeyTest.assertTrue((String)"BitKey 0 not subset of 2", (boolean)bitKey2.isSuperSetOf(bitKey0));
        BitKeyTest.assertTrue((String)"BitKey 1 not subset of 2", (boolean)bitKey2.isSuperSetOf(bitKey1));
        BitKeyTest.assertTrue((String)"BitKey 2 is subset of 0", (!bitKey0.isSuperSetOf(bitKey2) ? 1 : 0) != 0);
        BitKeyTest.assertTrue((String)"BitKey 2 is subset of 1", (!bitKey1.isSuperSetOf(bitKey2) ? 1 : 0) != 0);
        int size3 = 213;
        int[] positions3 = new int[]{0, 1, 2, 3, 4, 23, 30, 113, 145, 233, 234};
        BitKey bitKey3 = BitKeyTest.makeAndSet(size3, positions3);
        BitKeyTest.assertTrue((String)"BitKey 0 not subset of 3", (boolean)bitKey3.isSuperSetOf(bitKey0));
        BitKeyTest.assertTrue((String)"BitKey 1 not subset of 3", (boolean)bitKey3.isSuperSetOf(bitKey1));
        BitKeyTest.assertTrue((String)"BitKey 2 not subset of 3", (boolean)bitKey3.isSuperSetOf(bitKey2));
        BitKeyTest.assertTrue((String)"BitKey 3 is subset of 0", (!bitKey0.isSuperSetOf(bitKey3) ? 1 : 0) != 0);
        BitKeyTest.assertTrue((String)"BitKey 3 is subset of 1", (!bitKey1.isSuperSetOf(bitKey3) ? 1 : 0) != 0);
        BitKeyTest.assertTrue((String)"BitKey 3 is subset of 2", (!bitKey2.isSuperSetOf(bitKey3) ? 1 : 0) != 0);
    }

    public void testOr() {
        this.doTestOp(new Checker(){

            public void check(int size0, int[] positions0, int size1, int[] positions1) {
                int i;
                BitKey bitKey0 = BitKeyTest.makeAndSet(size0, positions0);
                BitKey bitKey1 = BitKeyTest.makeAndSet(size1, positions1);
                BitKey bitKey = bitKey0.or(bitKey1);
                int max = 0;
                for (i = 0; i < positions0.length; ++i) {
                    max = Math.max(max, positions0[i]);
                }
                for (i = 0; i < positions1.length; ++i) {
                    max = Math.max(max, positions1[i]);
                }
                for (int pos = 0; pos <= max; ++pos) {
                    boolean expected = BitKeyTest.contains(positions0, pos) || BitKeyTest.contains(positions1, pos);
                    Assert.assertEquals((boolean)expected, (boolean)bitKey.get(pos));
                }
            }
        });
    }

    public void testAnd() {
        this.doTestOp(new Checker(){

            public void check(int size0, int[] positions0, int size1, int[] positions1) {
                int i;
                BitKey bitKey0 = BitKeyTest.makeAndSet(size0, positions0);
                BitKey bitKey1 = BitKeyTest.makeAndSet(size1, positions1);
                BitKey bitKey = bitKey0.and(bitKey1);
                int max = 0;
                for (i = 0; i < positions0.length; ++i) {
                    max = Math.max(max, positions0[i]);
                }
                for (i = 0; i < positions1.length; ++i) {
                    max = Math.max(max, positions1[i]);
                }
                for (int pos = 0; pos <= max; ++pos) {
                    boolean expected = BitKeyTest.contains(positions0, pos) && BitKeyTest.contains(positions1, pos);
                    Assert.assertEquals((boolean)expected, (boolean)bitKey.get(pos));
                }
            }
        });
    }

    public void testAndNot() {
        this.doTestOp(new Checker(){

            public void check(int size0, int[] positions0, int size1, int[] positions1) {
                int i;
                BitKey bitKey0 = BitKeyTest.makeAndSet(size0, positions0);
                BitKey bitKey1 = BitKeyTest.makeAndSet(size1, positions1);
                BitKey bitKey = bitKey0.andNot(bitKey1);
                int max = 0;
                for (i = 0; i < positions0.length; ++i) {
                    max = Math.max(max, positions0[i]);
                }
                for (i = 0; i < positions1.length; ++i) {
                    max = Math.max(max, positions1[i]);
                }
                for (int pos = 0; pos <= max; ++pos) {
                    boolean expected = BitKeyTest.contains(positions0, pos) && !BitKeyTest.contains(positions1, pos);
                    Assert.assertEquals((boolean)expected, (boolean)bitKey.get(pos));
                }
            }
        });
    }

    public void testIntersects() {
        this.doTestOp(new Checker(){

            public void check(int size0, int[] positions0, int size1, int[] positions1) {
                BitKey bitKey0 = BitKeyTest.makeAndSet(size0, positions0);
                BitKey bitKey1 = BitKeyTest.makeAndSet(size1, positions1);
                boolean result = bitKey0.intersects(bitKey1);
                boolean expected = false;
                for (int i = 0; i < positions0.length; ++i) {
                    for (int j = 0; j < positions1.length; ++j) {
                        if (positions0[i] != positions1[j]) continue;
                        expected = true;
                    }
                }
                Assert.assertEquals((boolean)expected, (boolean)result);
            }
        });
    }

    public void testToBitSet() {
        this.doTestOp(new Checker(){

            public void check(int size0, int[] positions0, int size1, int[] positions1) {
                BitKey bitKey0 = BitKeyTest.makeAndSet(size0, positions0);
                BitSet bitSet = bitKey0.toBitSet();
                int j = 0;
                int i = bitSet.nextSetBit(0);
                while (i >= 0) {
                    Assert.assertTrue((i == positions0[j++] ? 1 : 0) != 0);
                    i = bitSet.nextSetBit(i + 1);
                }
                Assert.assertTrue((j == positions0.length ? 1 : 0) != 0);
            }
        });
    }

    public void testCompareTo() {
        this.doTestOp(new Checker(){

            public void check(int size0, int[] positions0, int size1, int[] positions1) {
                BitKey bitKey0 = BitKeyTest.makeAndSet(size0, positions0);
                BitKey bitKey1 = BitKeyTest.makeAndSet(size1, positions1);
                int c = bitKey0.compareTo(bitKey1);
                String s0 = bitKey0.toString();
                String s1 = bitKey1.toString();
                String ps0 = s0.substring("0x".length());
                String ps1 = s1.substring("0x".length());
                while (ps0.length() < ps1.length()) {
                    ps0 = "0" + ps0;
                }
                while (ps1.length() < ps0.length()) {
                    ps1 = "0" + ps1;
                }
                Assert.assertEquals((int)c, (int)BitKeyTest.sign(ps0.compareTo(ps1)));
                Assert.assertEquals((int)(-c), (int)bitKey1.compareTo(bitKey0));
                Assert.assertEquals((int)0, (int)bitKey0.compareTo(bitKey0));
                Assert.assertEquals((int)0, (int)bitKey1.compareTo(bitKey1));
            }
        });
    }

    private static int sign(int c) {
        return c < 0 ? -1 : (c > 0 ? 1 : 0);
    }

    private void doTestOp(Checker checker) {
        int size0 = 40;
        int size1 = 100;
        int size2 = 400;
        int[] positions0 = new int[]{0};
        int[] positions1 = new int[]{1};
        checker.check(size0, positions0, size0, positions1);
        int[] positions2 = new int[]{0, 1, 10, 20};
        int[] positions3 = new int[]{1, 2, 10, 11};
        checker.check(size0, positions2, size0, positions3);
        int[] positions4 = new int[]{0, 1, 10, 20};
        int[] positions5 = new int[]{1, 2, 10, 65, 66};
        checker.check(size0, positions4, size1, positions5);
        checker.check(size1, positions5, size0, positions4);
        int[] positions6 = new int[]{0, 1, 10, 20, 64, 65, 66};
        int[] positions7 = new int[]{1, 2, 10, 65, 66};
        checker.check(size1, positions6, size1, positions7);
        int[] positions8 = new int[]{0, 1, 10, 20};
        int[] positions9 = new int[]{1, 2, 10, 165, 366};
        checker.check(size0, positions8, size2, positions9);
        checker.check(size2, positions9, size0, positions8);
        int[] positions10 = new int[]{0, 1, 10, 20, 100};
        int[] positions11 = new int[]{1, 2, 10, 165, 366};
        checker.check(size1, positions10, size2, positions11);
        checker.check(size2, positions11, size1, positions10);
        int[] positions12 = new int[]{0, 1, 10, 20, 100, 165, 367};
        int[] positions13 = new int[]{1, 2, 10, 165, 366};
        checker.check(size2, positions12, size2, positions13);
        checker.check(size2, positions13, size2, positions12);
        int[] positions14 = new int[]{63};
        int[] positions15 = new int[]{63, 127, 191};
        checker.check(size1, positions14, size1, positions14);
        checker.check(size2, positions15, size2, positions15);
    }

    private static boolean contains(int[] positions, int pos) {
        for (int i = 0; i < positions.length; ++i) {
            if (positions[i] != pos) continue;
            return true;
        }
        return false;
    }

    public void testCreateFromBitSet() {
        BitSet bitSet = new BitSet(72);
        bitSet.set(2);
        bitSet.set(3);
        bitSet.set(5);
        bitSet.set(11);
        BitKey bitKey = BitKey.Factory.makeBitKey(bitSet);
        BitKeyTest.assertEquals((String)"0x0000000000000000000000000000000000000000000000000000100000101100", (String)bitKey.toString());
        BitSet emptyBitSet = new BitSet(77);
        bitKey = BitKey.Factory.makeBitKey(emptyBitSet);
        BitKeyTest.assertTrue((boolean)bitKey.isEmpty());
    }

    public void testIsEmpty() {
        BitKey small = BitKey.Factory.makeBitKey(3);
        BitKeyTest.assertTrue((boolean)small.isEmpty());
        small.set(2);
        BitKeyTest.assertFalse((boolean)small.isEmpty());
        BitKey medium = BitKey.Factory.makeBitKey(66);
        BitKeyTest.assertTrue((boolean)medium.isEmpty());
        medium.set(2);
        BitKeyTest.assertFalse((boolean)medium.isEmpty());
        medium.set(2, false);
        BitKeyTest.assertTrue((boolean)medium.isEmpty());
        medium.set(65);
        BitKeyTest.assertFalse((boolean)medium.isEmpty());
        BitKey large = BitKey.Factory.makeBitKey(131);
        BitKeyTest.assertTrue((boolean)large.isEmpty());
        large.set(2);
        BitKeyTest.assertFalse((boolean)large.isEmpty());
        large.set(129);
        BitKeyTest.assertFalse((boolean)large.isEmpty());
        large.set(129, false);
        large.set(2, false);
        BitKeyTest.assertTrue((boolean)large.isEmpty());
    }

    public void testIterator() {
        int[] bitPositions = new int[]{1};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{2, 3, 4, 7, 14};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{3, 6, 9, 12, 15, 24, 35, 48};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{60, 62};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{1, 3, 60, 63};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{63};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{0, 1, 62, 63};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{65};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{1, 65};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{1, 63, 64, 65, 66, 127};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{127};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{128};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{192};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{1, 128};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{0, 1, 127, 193};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{0, 1, 127, 128, 191, 192, 193};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{0, 1, 62, 63, 64, 127, 128, 191, 192, 193};
        this.doTestIterator(bitPositions);
        bitPositions = new int[]{567};
        this.doTestIterator(bitPositions);
    }

    private void printBitPositions(int i) {
        int b = i & -i;
        byte p = BitKey.bitPositionTable[b];
        System.out.println("  i=" + i + ",b=" + b + ",p=" + p);
    }

    private void doTestIterator(int[] bitPositions) {
        int maxPosition = 0;
        for (int pos : bitPositions) {
            if (pos <= maxPosition) continue;
            maxPosition = pos;
        }
        BitKey bitKey = BitKey.Factory.makeBitKey(maxPosition);
        for (int pos : bitPositions) {
            bitKey.set(pos);
        }
        int index = 0;
        for (Integer i : bitKey) {
            BitKeyTest.assertEquals((Object)i, (Object)bitPositions[index++]);
        }
    }

    private void doTestEquals(int size0, int size1, int[][] positionsArray) {
        for (int i = 0; i < positionsArray.length; ++i) {
            int[] positions = positionsArray[i];
            BitKey bitKey0 = BitKeyTest.makeAndSet(size0, positions);
            BitKey bitKey1 = BitKeyTest.makeAndSet(size1, positions);
            BitKeyTest.assertTrue((String)("BitKey not equals size0=" + size0 + ", size1=" + size1 + ", i=" + i), (boolean)bitKey0.equals(bitKey1));
        }
    }

    private void doTestNotEquals(int size0, int[] positions0, int size1, int[] positions1) {
        BitKey bitKey0 = BitKeyTest.makeAndSet(size0, positions0);
        BitKey bitKey1 = BitKeyTest.makeAndSet(size1, positions1);
        BitKeyTest.assertTrue((String)("BitKey not equals size0=" + size0 + ", size1=" + size1), (!bitKey0.equals(bitKey1) ? 1 : 0) != 0);
    }

    private static BitKey makeAndSet(int size, int[] positions) {
        BitKey bitKey = BitKey.Factory.makeBitKey(size);
        for (int i = 0; i < positions.length; ++i) {
            bitKey.set(positions[i]);
        }
        return bitKey;
    }

    public void testCompareUnsigned() {
        BitKeyTest.assertEquals((int)0, (int)BitKey.AbstractBitKey.compareUnsigned(0L, 0L));
        BitKeyTest.assertEquals((int)0, (int)BitKey.AbstractBitKey.compareUnsigned(10L, 10L));
        BitKeyTest.assertEquals((int)0, (int)BitKey.AbstractBitKey.compareUnsigned(-3L, -3L));
        BitKeyTest.assertEquals((int)-1, (int)BitKey.AbstractBitKey.compareUnsigned(0L, 1L));
        BitKeyTest.assertEquals((int)1, (int)BitKey.AbstractBitKey.compareUnsigned(1L, 0L));
        BitKeyTest.assertEquals((int)1, (int)BitKey.AbstractBitKey.compareUnsigned(-1L, 1L));
        BitKeyTest.assertEquals((int)1, (int)BitKey.AbstractBitKey.compareUnsigned(-1L, 0L));
        BitKeyTest.assertEquals((int)1, (int)BitKey.AbstractBitKey.compareUnsigned(-1L, -2L));
        BitKeyTest.assertEquals((int)-1, (int)BitKey.AbstractBitKey.compareUnsigned(-2L, -1L));
    }

    public void testCompareUnsignedLongArrays() {
        BitKeyTest.assertEquals((int)0, (int)BitKey.AbstractBitKey.compareUnsignedArrays(new long[0], new long[0]));
        BitKeyTest.assertEquals((int)-1, (int)BitKey.AbstractBitKey.compareUnsignedArrays(new long[0], new long[]{1L}));
        BitKeyTest.assertEquals((int)0, (int)BitKey.AbstractBitKey.compareUnsignedArrays(new long[0], new long[]{0L, 0L}));
        BitKeyTest.assertEquals((int)0, (int)BitKey.AbstractBitKey.compareUnsignedArrays(new long[]{0L}, new long[0]));
        BitKeyTest.assertEquals((int)0, (int)BitKey.AbstractBitKey.compareUnsignedArrays(new long[]{0L, 0L}, new long[]{0L, 0L}));
        BitKeyTest.assertEquals((int)1, (int)BitKey.AbstractBitKey.compareUnsignedArrays(new long[]{1L, 5L}, new long[]{2L, 4L}));
        BitKeyTest.assertEquals((int)-1, (int)BitKey.AbstractBitKey.compareUnsignedArrays(new long[]{1L, 5L}, new long[]{2L, 5L}));
        BitKeyTest.assertEquals((int)-1, (int)BitKey.AbstractBitKey.compareUnsignedArrays(new long[]{1L, 5L}, new long[]{2L, 5L, 0L, 0L}));
        BitKeyTest.assertEquals((int)-1, (int)BitKey.AbstractBitKey.compareUnsignedArrays(new long[]{1L, 5L, 0L, 0L, 0L}, new long[]{2L, 5L, 0L, 0L}));
        BitKeyTest.assertEquals((int)-1, (int)BitKey.AbstractBitKey.compareUnsignedArrays(new long[]{1L, 5L, 0L, 0L, 0L}, new long[]{2L, 5L}));
        BitKeyTest.assertEquals((int)1, (int)BitKey.AbstractBitKey.compareUnsignedArrays(new long[]{1L, 5L}, new long[]{-2L, 4L}));
    }

    private static interface Checker {
        public void check(int var1, int[] var2, int var3, int[] var4);
    }
}

