/*
 * Decompiled with CFR 0.152.
 */
package javassist.bytecode;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Map;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ByteArray;
import javassist.bytecode.ConstPool;

public class StackMapTable
extends AttributeInfo {
    public static final String tag = "StackMapTable";
    public static final int TOP = 0;
    public static final int INTEGER = 1;
    public static final int FLOAT = 2;
    public static final int DOUBLE = 3;
    public static final int LONG = 4;
    public static final int NULL = 5;
    public static final int THIS = 6;
    public static final int OBJECT = 7;
    public static final int UNINIT = 8;

    private StackMapTable(ConstPool cp, byte[] newInfo) {
        super(cp, tag, newInfo);
    }

    StackMapTable(ConstPool cp, int name_id, DataInputStream in) throws IOException {
        super(cp, name_id, in);
    }

    public AttributeInfo copy(ConstPool newCp, Map classnames) {
        int s = this.info.length;
        byte[] newInfo = new byte[s];
        System.arraycopy(this.info, 0, newInfo, 0, s);
        return new StackMapTable(newCp, newInfo);
    }

    void write(DataOutputStream out) throws IOException {
        super.write(out);
    }

    static class Writer {
        ByteArrayOutputStream output;
        int numOfEntries;

        public Writer(int size) {
            this.output = new ByteArrayOutputStream(size);
            this.numOfEntries = 0;
            this.output.write(0);
            this.output.write(0);
        }

        public byte[] toByteArray() {
            byte[] b = this.output.toByteArray();
            ByteArray.write16bit(this.numOfEntries, b, 0);
            return b;
        }

        public void sameFrame(int offsetDelta) {
            ++this.numOfEntries;
            if (offsetDelta < 64) {
                this.output.write(offsetDelta);
            } else {
                this.output.write(251);
                this.write16(offsetDelta);
            }
        }

        public void sameLocals(int offsetDelta, int tag, int data) {
            ++this.numOfEntries;
            if (offsetDelta < 64) {
                this.output.write(offsetDelta + 64);
            } else {
                this.output.write(247);
                this.write16(offsetDelta);
            }
            this.writeTypeInfo(tag, data);
        }

        public void chopFrame(int offsetDelta, int k) {
            ++this.numOfEntries;
            this.output.write(251 - k);
            this.write16(offsetDelta);
        }

        public void appendFrame(int offsetDelta, int[] tags, int[] data) {
            ++this.numOfEntries;
            int k = tags.length;
            this.output.write(k + 251);
            this.write16(offsetDelta);
            for (int i = 0; i < k; ++i) {
                this.writeTypeInfo(tags[i], data[i]);
            }
        }

        public void fullFrame(int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
            int i;
            ++this.numOfEntries;
            this.output.write(255);
            this.write16(offsetDelta);
            int n = localTags.length;
            this.write16(n);
            for (i = 0; i < n; ++i) {
                this.writeTypeInfo(localTags[i], localData[i]);
            }
            n = stackTags.length;
            for (i = 0; i < n; ++i) {
                this.writeTypeInfo(stackTags[i], stackData[i]);
            }
        }

        private void writeTypeInfo(int tag, int data) {
            this.output.write(tag);
            if (tag == 7 || tag == 8) {
                this.write16(data);
            }
        }

        private void write16(int value) {
            this.output.write(value >>> 8 & 0xFF);
            this.output.write(value & 0xFF);
        }
    }

    static class Walker {
        byte[] info;
        int numOfEntries;

        public Walker(byte[] data) {
            this.info = data;
            this.numOfEntries = ByteArray.readU16bit(data, 0);
        }

        public final int size() {
            return this.numOfEntries;
        }

        public final void parse() throws BadBytecode {
            int n = this.numOfEntries;
            int pos = 2;
            for (int i = 0; i < n; ++i) {
                pos = this.stackMapFrames(pos, i);
            }
        }

        int stackMapFrames(int pos, int nth) throws BadBytecode {
            int type = this.info[pos] & 0xFF;
            if (type < 64) {
                this.sameFrame(pos, type);
                ++pos;
            } else if (type < 128) {
                pos = this.sameLocals(pos, type);
            } else {
                if (type < 247) {
                    throw new BadBytecode("bad frame_type in StackMapTable");
                }
                if (type == 247) {
                    pos = this.sameLocals(pos, type);
                } else if (type < 251) {
                    int offset = ByteArray.readU16bit(this.info, pos + 1);
                    this.chopFrame(pos, offset, 251 - type);
                    pos += 3;
                } else if (type == 251) {
                    int offset = ByteArray.readU16bit(this.info, pos + 1);
                    this.sameFrame(pos, offset);
                    pos += 3;
                } else {
                    pos = type < 255 ? this.appendFrame(pos, type) : this.fullFrame(pos);
                }
            }
            return pos;
        }

        public void sameFrame(int pos, int offsetDelta) {
        }

        private int sameLocals(int pos, int type) {
            int offset;
            if (type < 128) {
                offset = type - 64;
            } else {
                offset = ByteArray.readU16bit(this.info, pos + 1);
                pos += 2;
            }
            int tag = this.info[pos + 1] & 0xFF;
            int data = 0;
            if (tag == 7 || tag == 8) {
                data = ByteArray.readU16bit(this.info, pos + 2);
                pos += 2;
            }
            this.sameLocals(pos, offset, tag, data);
            return pos + 2;
        }

        public void sameLocals(int pos, int offsetDelta, int stackTag, int stackData) {
        }

        public void chopFrame(int pos, int offsetDelta, int k) {
        }

        private int appendFrame(int pos, int type) {
            int k = type - 251;
            int offset = ByteArray.readU16bit(this.info, pos + 1);
            int[] tags = new int[k];
            int[] data = new int[k];
            int p = pos + 3;
            for (int i = 0; i < k; ++i) {
                int tag;
                tags[i] = tag = this.info[p] & 0xFF;
                if (tag == 7 || tag == 8) {
                    data[i] = ByteArray.readU16bit(this.info, p + 1);
                    p += 3;
                    continue;
                }
                data[i] = 0;
                ++p;
            }
            this.appendFrame(pos, offset, tags, data);
            return p;
        }

        public void appendFrame(int pos, int offsetDelta, int[] tags, int[] data) {
        }

        private int fullFrame(int pos) {
            int offset = ByteArray.readU16bit(this.info, pos + 1);
            int numOfLocals = ByteArray.readU16bit(this.info, pos + 3);
            int[] localsTags = new int[numOfLocals];
            int[] localsData = new int[numOfLocals];
            int p = this.verifyTypeInfo(pos + 5, numOfLocals, localsTags, localsData);
            int numOfItems = ByteArray.readU16bit(this.info, p);
            int[] itemsTags = new int[numOfItems];
            int[] itemsData = new int[numOfItems];
            p = this.verifyTypeInfo(p + 2, numOfItems, itemsTags, itemsData);
            this.fullFrame(pos, offset, localsTags, localsData, itemsTags, itemsData);
            return p;
        }

        void fullFrame(int pos, int offsetDelta, int[] localTags, int[] localData, int[] stackTags, int[] stackData) {
        }

        private int verifyTypeInfo(int pos, int n, int[] tags, int[] data) {
            for (int i = 0; i < n; ++i) {
                int tag;
                tags[i] = tag = this.info[pos++] & 0xFF;
                if (tag != 7 && tag != 8) continue;
                data[i] = ByteArray.readU16bit(this.info, pos);
                pos += 2;
            }
            return pos;
        }
    }
}

