/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mondrian.olap.OlapElement;
import mondrian.olap.Util;
import mondrian.rolap.DefaultMemberChildrenConstraint;
import mondrian.rolap.MemberCache;
import mondrian.rolap.MemberKey;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMember;
import mondrian.rolap.SmartMemberListCache;
import mondrian.rolap.SqlConstraintFactory;
import mondrian.rolap.cache.SmartCache;
import mondrian.rolap.cache.SoftSmartCache;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.spi.DataSourceChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberCacheHelper
implements MemberCache {
    private final SqlConstraintFactory sqlConstraintFactory = SqlConstraintFactory.instance();
    final SmartMemberListCache<RolapMember, List<RolapMember>> mapMemberToChildren;
    SmartCache<Object, RolapMember> mapKeyToMember;
    RolapHierarchy rolapHierarchy;
    DataSourceChangeListener changeListener;
    final SmartMemberListCache<RolapLevel, List<RolapMember>> mapLevelToMembers;

    public MemberCacheHelper(RolapHierarchy rolapHierarchy) {
        this.rolapHierarchy = rolapHierarchy;
        this.mapLevelToMembers = new SmartMemberListCache();
        this.mapKeyToMember = new SoftSmartCache<Object, RolapMember>();
        this.mapMemberToChildren = new SmartMemberListCache();
        this.changeListener = rolapHierarchy != null ? rolapHierarchy.getRolapSchema().getDataSourceChangeListener() : null;
    }

    @Override
    public synchronized RolapMember getMember(Object key, boolean mustCheckCacheStatus) {
        if (mustCheckCacheStatus) {
            this.checkCacheStatus();
        }
        return this.mapKeyToMember.get(key);
    }

    @Override
    public synchronized Object putMember(Object key, RolapMember value) {
        return this.mapKeyToMember.put(key, value);
    }

    @Override
    public Object makeKey(RolapMember parent, Object key) {
        return new MemberKey(parent, key);
    }

    @Override
    public synchronized RolapMember getMember(Object key) {
        return this.getMember(key, true);
    }

    public synchronized void checkCacheStatus() {
        if (this.changeListener != null && this.changeListener.isHierarchyChanged(this.rolapHierarchy)) {
            this.flushCache();
        }
    }

    public synchronized void putLevelMembersInCache(RolapLevel level, TupleConstraint constraint, List<RolapMember> members) {
        this.mapLevelToMembers.put(level, constraint, members);
    }

    @Override
    public synchronized List<RolapMember> getChildrenFromCache(RolapMember member, MemberChildrenConstraint constraint) {
        if (constraint == null) {
            constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        }
        return this.mapMemberToChildren.get(member, constraint);
    }

    @Override
    public synchronized void putChildren(RolapMember member, MemberChildrenConstraint constraint, List<RolapMember> children) {
        if (constraint == null) {
            constraint = this.sqlConstraintFactory.getMemberChildrenConstraint(null);
        }
        this.mapMemberToChildren.put(member, constraint, children);
    }

    @Override
    public synchronized List<RolapMember> getLevelMembersFromCache(RolapLevel level, TupleConstraint constraint) {
        if (constraint == null) {
            constraint = this.sqlConstraintFactory.getLevelMembersConstraint(null);
        }
        return this.mapLevelToMembers.get(level, constraint);
    }

    public synchronized void flushCache() {
        this.mapMemberToChildren.clear();
        this.mapKeyToMember.clear();
        this.mapLevelToMembers.clear();
    }

    public DataSourceChangeListener getChangeListener() {
        return this.changeListener;
    }

    public void setChangeListener(DataSourceChangeListener listener) {
        this.changeListener = listener;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public synchronized RolapMember removeMember(Object key) {
        RolapMember member = this.getMember(key);
        if (member == null) {
            return null;
        }
        RolapLevel level = member.getLevel();
        for (Map.Entry entry : this.mapLevelToMembers.getCache()) {
            if (!((RolapLevel)((SmartMemberListCache.Key2)entry.getKey()).o1).equals(level)) continue;
            List peers = (List)entry.getValue();
            boolean removedIt = peers.remove(member);
            Util.discard((boolean)removedIt);
        }
        RolapMember parent = member.getParentMember();
        Iterator iterator = this.mapMemberToChildren.getCache().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            RolapMember member1 = (RolapMember)((SmartMemberListCache.Key2)entry.getKey()).o1;
            Object constraint = ((SmartMemberListCache.Key2)entry.getKey()).o2;
            if (member1.equals((OlapElement)parent)) {
                if (constraint == DefaultMemberChildrenConstraint.instance()) {
                    List siblings = (List)entry.getValue();
                    boolean removedIt = siblings.remove(member);
                    Util.discard((boolean)removedIt);
                } else {
                    iterator.remove();
                }
            }
            if (!member1.equals((OlapElement)member)) continue;
            iterator.remove();
        }
        return this.mapKeyToMember.put(key, null);
    }

    @Override
    public synchronized RolapMember removeMemberAndDescendants(Object key) {
        return null;
    }
}

