/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import net.sf.ehcache.CacheException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class Element
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 7832456720941087574L;
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$Element == null ? (class$net$sf$ehcache$Element = Element.class$("net.sf.ehcache.Element")) : class$net$sf$ehcache$Element).getName());
    private final Object key;
    private final Object value;
    private long version;
    private long creationTime;
    private long lastAccessTime;
    private long nextToLastAccessTime;
    private long hitCount;
    static /* synthetic */ Class class$net$sf$ehcache$Element;

    public Element(Serializable key, Serializable value, long version) {
        this((Object)key, (Object)value, version);
    }

    public Element(Object key, Object value, long version) {
        this.key = key;
        this.value = value;
        this.version = version;
        this.creationTime = System.currentTimeMillis();
        this.hitCount = 0L;
    }

    public Element(Serializable key, Serializable value) {
        this((Object)key, (Object)value, 1L);
    }

    public Element(Object key, Object value) {
        this(key, value, 1L);
    }

    public final Serializable getKey() {
        Serializable keyAsSerializable;
        try {
            keyAsSerializable = (Serializable)this.key;
        }
        catch (Exception e) {
            throw new CacheException("Key " + this.key + " is not Serializable. Consider using Element#getObjectKey()");
        }
        return keyAsSerializable;
    }

    public final Object getObjectKey() {
        return this.key;
    }

    public final Serializable getValue() {
        Serializable valueAsSerializable;
        try {
            valueAsSerializable = (Serializable)this.value;
        }
        catch (Exception e) {
            throw new CacheException("Value " + this.value + " is not Serializable. Consider using Element#getObjectKey()");
        }
        return valueAsSerializable;
    }

    public final Object getObjectValue() {
        return this.value;
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        Element element = (Element)object;
        if (this.key == null || element.getObjectKey() == null) {
            return false;
        }
        return this.key.equals(element.getObjectKey());
    }

    public final int hashCode() {
        return this.key.hashCode();
    }

    public final void setVersion(long version) {
        this.version = version;
    }

    public final long getCreationTime() {
        return this.creationTime;
    }

    public final void setCreateTime() {
        this.creationTime = System.currentTimeMillis();
    }

    public final long getVersion() {
        return this.version;
    }

    public final long getLastAccessTime() {
        return this.lastAccessTime;
    }

    final long getNextToLastAccessTime() {
        return this.nextToLastAccessTime;
    }

    public final long getHitCount() {
        return this.hitCount;
    }

    public final void resetAccessStatistics() {
        this.lastAccessTime = 0L;
        this.nextToLastAccessTime = 0L;
        this.hitCount = 0L;
    }

    public final void updateAccessStatistics() {
        this.nextToLastAccessTime = this.lastAccessTime;
        this.lastAccessTime = System.currentTimeMillis();
        ++this.hitCount;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[ key = ").append(this.key).append(", value=").append(this.value).append(", version=").append(this.version).append(", hitCount=").append(this.hitCount).append(", CreationTime = ").append(this.getCreationTime()).append(", LastAccessTime = ").append(this.getLastAccessTime()).append(" ]");
        return sb.toString();
    }

    public final Object clone() throws CloneNotSupportedException {
        super.clone();
        Element element = new Element(this.deepCopy(this.key), this.deepCopy(this.value), this.version);
        element.creationTime = this.creationTime;
        element.lastAccessTime = this.lastAccessTime;
        element.nextToLastAccessTime = this.nextToLastAccessTime;
        element.hitCount = this.hitCount;
        return element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deepCopy(Object oldValue) {
        Serializable newValue = null;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        try {
            oos = new ObjectOutputStream(bout);
            oos.writeObject(oldValue);
            ByteArrayInputStream bin = new ByteArrayInputStream(bout.toByteArray());
            ois = new ObjectInputStream(bin);
            newValue = (Serializable)ois.readObject();
        }
        catch (IOException e) {
            LOG.error((Object)("Error cloning Element with key " + this.key + " during serialization and deserialization of value"));
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)("Error cloning Element with key " + this.key + " during serialization and deserialization of value"));
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
                if (ois != null) {
                    ois.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error closing Stream");
            }
        }
        return newValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getSerializedSize() {
        if (!this.isSerializable()) {
            return 0L;
        }
        long size = 0L;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(bout);
            oos.writeObject(this);
            long l = size = (long)bout.size();
            return l;
        }
        catch (IOException e) {
            LOG.error((Object)("Error measuring element size for element with key " + this.key));
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error closing ObjectOutputStream");
            }
        }
        return size;
    }

    public final boolean isSerializable() {
        return this.key instanceof Serializable && this.value instanceof Serializable;
    }

    public final boolean isKeySerializable() {
        return this.key instanceof Serializable;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

