/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.tools.schemaframework;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.TopLinkException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.databaseaccess.DatabaseAccessor;
import oracle.toplink.essentials.internal.sequencing.Sequencing;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.DatabaseSessionImpl;
import oracle.toplink.essentials.sequencing.DefaultSequence;
import oracle.toplink.essentials.sequencing.NativeSequence;
import oracle.toplink.essentials.sequencing.Sequence;
import oracle.toplink.essentials.sequencing.TableSequence;
import oracle.toplink.essentials.sessions.DatabaseSession;
import oracle.toplink.essentials.tools.schemaframework.DatabaseObjectDefinition;
import oracle.toplink.essentials.tools.schemaframework.DefaultTableGenerator;
import oracle.toplink.essentials.tools.schemaframework.OracleSequenceDefinition;
import oracle.toplink.essentials.tools.schemaframework.SequenceDefinition;
import oracle.toplink.essentials.tools.schemaframework.TableDefinition;
import oracle.toplink.essentials.tools.schemaframework.TableSequenceDefinition;
import oracle.toplink.essentials.tools.schemaframework.TimesTenSequenceDefinition;

public class SchemaManager {
    protected DatabaseSessionImpl session;
    protected Writer createSchemaWriter;
    protected Writer dropSchemaWriter;
    protected boolean createSQLFiles = true;

    public SchemaManager(DatabaseSessionImpl session) {
        this.session = session;
    }

    public SchemaManager(DatabaseSession session) {
        this.session = (DatabaseSessionImpl)session;
    }

    protected Writer getDropSchemaWriter() {
        if (null == this.dropSchemaWriter) {
            return this.createSchemaWriter;
        }
        return this.dropSchemaWriter;
    }

    public void appendToDDLWriter(String stringToWrite) {
        this.appendToDDLWriter(this.createSchemaWriter, stringToWrite);
    }

    public void appendToDDLWriter(Writer schemaWriter, String stringToWrite) {
        if (schemaWriter == null) {
            return;
        }
        try {
            schemaWriter.write(stringToWrite);
            schemaWriter.flush();
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void buildFieldTypes(TableDefinition tableDef) {
        tableDef.buildFieldTypes(this.getSession());
    }

    public void closeDDLWriter() {
        this.closeDDLWriter(this.createSchemaWriter);
        if (null != this.dropSchemaWriter) {
            this.closeDDLWriter(this.dropSchemaWriter);
        }
    }

    public void closeDDLWriter(Writer schemaWriter) {
        if (schemaWriter == null) {
            return;
        }
        try {
            schemaWriter.flush();
            schemaWriter.close();
            schemaWriter = null;
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void createConstraints(TableDefinition tableDefinition) throws TopLinkException {
        if (this.shouldWriteToDatabase()) {
            tableDefinition.createConstraintsOnDatabase(this.getSession());
        } else {
            tableDefinition.setCreateSQLFiles(this.createSQLFiles);
            tableDefinition.createConstraints(this.getSession(), this.createSchemaWriter);
        }
    }

    public void createObject(DatabaseObjectDefinition databaseObjectDefinition) throws TopLinkException {
        if (this.shouldWriteToDatabase()) {
            databaseObjectDefinition.createOnDatabase(this.getSession());
        } else {
            databaseObjectDefinition.createObject(this.getSession(), this.createSchemaWriter);
            if (this.createSQLFiles) {
                this.appendToDDLWriter(this.createSchemaWriter, this.getSession().getPlatform().getStoredProcedureTerminationToken());
            }
            this.appendToDDLWriter(this.createSchemaWriter, "\n");
        }
    }

    public void createSequences() throws TopLinkException {
        this.createOrReplaceSequences(true);
    }

    public void replaceSequences() throws TopLinkException {
        this.createOrReplaceSequences(false);
    }

    protected void createOrReplaceSequences(boolean create) throws TopLinkException {
        Sequencing sequencing = this.getSession().getSequencing();
        if (sequencing == null || sequencing.whenShouldAcquireValueForAll() == 1) {
            return;
        }
        HashMap tableDefinitions = new HashMap();
        HashSet sequenceDefinitions = new HashSet();
        HashSet processedSequenceNames = new HashSet();
        this.buildTableAndSequenceDefinitions(sequenceDefinitions, processedSequenceNames, tableDefinitions);
        this.processTableDefinitions(tableDefinitions, create);
        this.processSequenceDefinitions(sequenceDefinitions, create);
    }

    protected void createOrReplaceSequences(boolean create, boolean drop) throws TopLinkException {
        Sequencing sequencing = this.getSession().getSequencing();
        if (sequencing == null || sequencing.whenShouldAcquireValueForAll() == 1) {
            return;
        }
        HashMap tableDefinitions = new HashMap();
        HashSet sequenceDefinitions = new HashSet();
        HashSet processedSequenceNames = new HashSet();
        this.buildTableAndSequenceDefinitions(sequenceDefinitions, processedSequenceNames, tableDefinitions);
        this.processTableDefinitions(tableDefinitions, create);
        this.processSequenceDefinitions(sequenceDefinitions, drop);
    }

    private void buildTableAndSequenceDefinitions(HashSet sequenceDefinitions, HashSet processedSequenceNames, HashMap tableDefinitions) {
        for (ClassDescriptor descriptor : this.getSession().getDescriptors().values()) {
            String tableName;
            TableDefinition otherTableDefinition;
            SequenceDefinition sequenceDefinition;
            if (!descriptor.usesSequenceNumbers()) continue;
            String seqName = descriptor.getSequenceNumberName();
            if (seqName == null) {
                seqName = this.getSession().getDatasourcePlatform().getDefaultSequence().getName();
            }
            if (processedSequenceNames.contains(seqName)) continue;
            processedSequenceNames.add(seqName);
            Sequence sequence = this.getSession().getDatasourcePlatform().getSequence(seqName);
            if (sequence.shouldAcquireValueAfterInsert() || (sequenceDefinition = this.buildSequenceDefinition(sequence)) == null) continue;
            sequenceDefinitions.add(sequenceDefinition);
            TableDefinition tableDefinition = sequenceDefinition.buildTableDefinition();
            if (tableDefinition == null || (otherTableDefinition = (TableDefinition)tableDefinitions.get(tableName = tableDefinition.getName())) != null) continue;
            tableDefinitions.put(tableName, tableDefinition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processTableDefinitions(HashMap tableDefinitions, boolean create) throws TopLinkException {
        for (TableDefinition tableDefinition : tableDefinitions.values()) {
            boolean shouldLogExceptionStackTrace = this.session.getSessionLog().shouldLogExceptionStackTrace();
            if (shouldLogExceptionStackTrace) {
                this.session.getSessionLog().setShouldLogExceptionStackTrace(false);
            }
            if (create) {
                try {
                    this.createObject(tableDefinition);
                }
                catch (DatabaseException exception) {}
                continue;
                finally {
                    if (shouldLogExceptionStackTrace) {
                        this.session.getSessionLog().setShouldLogExceptionStackTrace(true);
                    }
                    continue;
                }
            }
            try {
                this.dropObject(tableDefinition);
            }
            catch (DatabaseException exception) {
            }
            finally {
                if (shouldLogExceptionStackTrace) {
                    this.session.getSessionLog().setShouldLogExceptionStackTrace(true);
                }
            }
            this.createObject(tableDefinition);
        }
    }

    private void processSequenceDefinitions(HashSet sequenceDefinitions, boolean create) throws TopLinkException {
        for (SequenceDefinition sequenceDefinition : sequenceDefinitions) {
            if (!create) {
                try {
                    this.dropObject(sequenceDefinition);
                }
                catch (DatabaseException exception) {
                    // empty catch block
                }
            }
            this.createObject(sequenceDefinition);
        }
    }

    protected SequenceDefinition buildSequenceDefinition(Sequence sequence) {
        if (sequence instanceof DefaultSequence) {
            String name = sequence.getName();
            int size = sequence.getPreallocationSize();
            int initialValue = sequence.getInitialValue();
            sequence = this.getSession().getDatasourcePlatform().getDefaultSequence();
            if (sequence instanceof TableSequence) {
                TableSequence tableSequence = (TableSequence)sequence;
                return new TableSequenceDefinition(name, tableSequence);
            }
            if (sequence instanceof NativeSequence) {
                if (this.getSession().getDatasourcePlatform().isOracle()) {
                    return new OracleSequenceDefinition(name, size, initialValue);
                }
                if (this.getSession().getDatasourcePlatform().isTimesTen()) {
                    return new TimesTenSequenceDefinition(name, size, initialValue);
                }
                return null;
            }
            return null;
        }
        if (sequence instanceof TableSequence) {
            TableSequence tableSequence = (TableSequence)sequence;
            return new TableSequenceDefinition(tableSequence);
        }
        if (sequence instanceof NativeSequence) {
            if (this.getSession().getDatasourcePlatform().isOracle()) {
                NativeSequence nativeSequence = (NativeSequence)sequence;
                return new OracleSequenceDefinition(nativeSequence);
            }
            return null;
        }
        return null;
    }

    public void dropConstraints(TableDefinition tableDefinition) throws TopLinkException {
        if (this.shouldWriteToDatabase()) {
            tableDefinition.dropConstraintsOnDatabase(this.getSession());
        } else {
            tableDefinition.setCreateSQLFiles(this.createSQLFiles);
            tableDefinition.dropConstraints(this.getSession(), this.getDropSchemaWriter());
        }
    }

    public void dropObject(DatabaseObjectDefinition databaseObjectDefinition) throws TopLinkException {
        if (this.shouldWriteToDatabase()) {
            databaseObjectDefinition.dropFromDatabase(this.getSession());
        } else {
            Writer dropSchemaWriter = this.getDropSchemaWriter();
            databaseObjectDefinition.dropObject(this.getSession(), dropSchemaWriter);
            if (this.createSQLFiles) {
                this.appendToDDLWriter(dropSchemaWriter, this.getSession().getPlatform().getStoredProcedureTerminationToken());
            }
            this.appendToDDLWriter(dropSchemaWriter, "\n");
        }
    }

    public void dropTable(String tableName) throws TopLinkException {
        TableDefinition tableDefinition = new TableDefinition();
        tableDefinition.setName(tableName);
        this.dropObject(tableDefinition);
    }

    public void finalize() {
        try {
            this.closeDDLWriter();
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
    }

    protected DatabaseAccessor getAccessor() {
        return (DatabaseAccessor)this.getSession().getAccessor();
    }

    public Vector getAllColumnNames(String tableName) throws DatabaseException {
        return this.getAccessor().getColumnInfo(null, null, tableName, null, this.getSession());
    }

    public Vector getAllColumnNames(String creatorName, String tableName) throws DatabaseException {
        return this.getAccessor().getColumnInfo(null, creatorName, tableName, null, this.getSession());
    }

    public Vector getAllTableNames() throws DatabaseException {
        return this.getAccessor().getTableInfo(null, null, null, null, this.getSession());
    }

    public Vector getAllTableNames(String creatorName) throws DatabaseException {
        return this.getAccessor().getTableInfo(null, creatorName, null, null, this.getSession());
    }

    public Vector getColumnInfo(String catalog, String schema, String tableName, String columnName) throws DatabaseException {
        return this.getAccessor().getColumnInfo(catalog, schema, tableName, columnName, this.getSession());
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public Vector getTableInfo(String catalog, String schema, String tableName, String[] types) throws DatabaseException {
        return this.getAccessor().getTableInfo(catalog, schema, tableName, types, this.getSession());
    }

    public void outputDDLToDatabase() {
        this.createSchemaWriter = null;
        this.dropSchemaWriter = null;
    }

    public void outputDDLToFile(String fileName) {
        try {
            this.createSchemaWriter = new FileWriter(fileName);
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void outputCreateDDLToFile(String fileName) {
        try {
            this.createSchemaWriter = new FileWriter(fileName);
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void outputDropDDLToFile(String fileName) {
        try {
            this.dropSchemaWriter = new FileWriter(fileName);
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void outputDDLToWriter(Writer schemaWriter) {
        this.createSchemaWriter = schemaWriter;
    }

    public void outputCreateDDLToWriter(Writer createWriter) {
        this.createSchemaWriter = createWriter;
    }

    public void outputDropDDLToWriter(Writer dropWriter) {
        this.dropSchemaWriter = dropWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceObject(DatabaseObjectDefinition databaseDefinition) throws TopLinkException {
        boolean shouldLogExceptionStackTrace = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
        if (shouldLogExceptionStackTrace) {
            this.getSession().getSessionLog().setShouldLogExceptionStackTrace(false);
        }
        try {
            this.dropObject(databaseDefinition);
        }
        catch (DatabaseException databaseException) {
        }
        finally {
            if (shouldLogExceptionStackTrace) {
                this.getSession().getSessionLog().setShouldLogExceptionStackTrace(true);
            }
        }
        this.createObject(databaseDefinition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDefaultTables() {
        for (TableDefinition tblDef : new DefaultTableGenerator(this.session.getProject()).generateDefaultTableCreator().getTableDefinitions()) {
            boolean shouldLogExceptionStackTrace = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
            this.getSession().getSessionLog().setShouldLogExceptionStackTrace(false);
            try {
                this.createObject(tblDef);
                this.session.getSessionLog().log(1, "default_tables_created", tblDef.getFullName());
            }
            catch (DatabaseException exception) {
                this.session.getSessionLog().log(1, "default_tables_already_existed", tblDef.getFullName());
            }
            finally {
                this.getSession().getSessionLog().setShouldLogExceptionStackTrace(shouldLogExceptionStackTrace);
            }
        }
        this.createSequences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDefaultTables() throws TopLinkException {
        boolean shouldLogExceptionStackTrace = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
        this.getSession().getSessionLog().setShouldLogExceptionStackTrace(false);
        try {
            DefaultTableGenerator gen = new DefaultTableGenerator(this.session.getProject());
            gen.generateDefaultTableCreator().replaceTables(this.session, this);
        }
        catch (DatabaseException databaseException) {
        }
        finally {
            this.getSession().getSessionLog().setShouldLogExceptionStackTrace(shouldLogExceptionStackTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceDefaultTables(boolean keepSequenceTables) throws TopLinkException {
        boolean shouldLogExceptionStackTrace = this.getSession().getSessionLog().shouldLogExceptionStackTrace();
        this.getSession().getSessionLog().setShouldLogExceptionStackTrace(false);
        try {
            DefaultTableGenerator gen = new DefaultTableGenerator(this.session.getProject());
            gen.generateDefaultTableCreator().replaceTables(this.session, this, keepSequenceTables);
        }
        catch (DatabaseException databaseException) {
        }
        finally {
            this.getSession().getSessionLog().setShouldLogExceptionStackTrace(shouldLogExceptionStackTrace);
        }
    }

    public void setSession(DatabaseSessionImpl session) {
        this.session = session;
    }

    public boolean shouldWriteToDatabase() {
        return this.createSchemaWriter == null && this.dropSchemaWriter == null;
    }

    public void alterSequence(SequenceDefinition sequenceDefinition) throws TopLinkException {
        if (!sequenceDefinition.isAlterSupported()) {
            return;
        }
        if (this.shouldWriteToDatabase()) {
            sequenceDefinition.alterOnDatabase(this.getSession());
        } else {
            sequenceDefinition.alter(this.getSession(), this.createSchemaWriter);
        }
    }

    public void setCreateSQLFiles(boolean genFlag) {
        this.createSQLFiles = genFlag;
    }
}

