/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.tools.schemaframework;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.sessions.AbstractSession;

public class ForeignKeyConstraint
implements Serializable {
    protected String name = "";
    protected Vector sourceFields = new Vector();
    protected Vector targetFields = new Vector();
    protected String targetTable = "";
    protected boolean shouldCascadeOnDelete = false;

    public ForeignKeyConstraint() {
    }

    public ForeignKeyConstraint(String name, String sourceField, String targetField, String targetTable) {
        this();
        this.name = name;
        this.sourceFields.addElement(sourceField);
        this.targetFields.addElement(targetField);
        this.targetTable = targetTable;
    }

    public void addSourceField(String sourceField) {
        this.getSourceFields().addElement(sourceField);
    }

    public void addTargetField(String targetField) {
        this.getTargetFields().addElement(targetField);
    }

    public void appendDBString(Writer writer, AbstractSession session) {
        try {
            writer.write("FOREIGN KEY (");
            Enumeration sourceEnum = this.getSourceFields().elements();
            while (sourceEnum.hasMoreElements()) {
                writer.write((String)sourceEnum.nextElement());
                if (!sourceEnum.hasMoreElements()) continue;
                writer.write(", ");
            }
            writer.write(") REFERENCES ");
            writer.write(this.getTargetTable());
            writer.write(" (");
            Enumeration targetEnum = this.getTargetFields().elements();
            while (targetEnum.hasMoreElements()) {
                writer.write((String)targetEnum.nextElement());
                if (!targetEnum.hasMoreElements()) continue;
                writer.write(", ");
            }
            writer.write(")");
            if (this.shouldCascadeOnDelete()) {
                writer.write(" ON DELETE CASCADE");
            }
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public void cascadeOnDelete() {
        this.setShouldCascadeOnDelete(true);
    }

    public void dontCascadeOnDelete() {
        this.setShouldCascadeOnDelete(false);
    }

    public String getName() {
        return this.name;
    }

    public Vector getSourceFields() {
        return this.sourceFields;
    }

    public Vector getTargetFields() {
        return this.targetFields;
    }

    public String getTargetTable() {
        return this.targetTable;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setShouldCascadeOnDelete(boolean shouldCascadeOnDelete) {
        this.shouldCascadeOnDelete = shouldCascadeOnDelete;
    }

    public void setSourceFields(Vector sourceFields) {
        this.sourceFields = sourceFields;
    }

    public void setTargetFields(Vector targetFields) {
        this.targetFields = targetFields;
    }

    public void setTargetTable(String targetTable) {
        this.targetTable = targetTable;
    }

    public boolean shouldCascadeOnDelete() {
        return this.shouldCascadeOnDelete;
    }
}

