/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.weaving;

import java.io.FileOutputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Map;
import javax.persistence.spi.ClassTransformer;
import oracle.toplink.essentials.internal.weaving.ClassDetails;
import oracle.toplink.essentials.internal.weaving.TopLinkClassWeaver;
import oracle.toplink.essentials.sessions.Session;
import oracle.toplink.libraries.asm.ClassReader;
import oracle.toplink.libraries.asm.ClassWriter;
import oracle.toplink.libraries.asm.attrs.Attributes;

public class TopLinkWeaver
implements ClassTransformer {
    protected Session session;
    protected Map classDetailsMap;

    public TopLinkWeaver(Session session, Map classDetailsMap) {
        this.session = session;
        this.classDetailsMap = classDetailsMap;
    }

    public Map getClassDetailsMap() {
        return this.classDetailsMap;
    }

    public byte[] transform(ClassLoader loader, String className, Class classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        ClassDetails classDetails = (ClassDetails)this.classDetailsMap.get(className);
        if (classDetails != null) {
            ClassReader cr = new ClassReader(classfileBuffer);
            ClassWriter cw = new ClassWriter(true, true);
            TopLinkClassWeaver tcw = new TopLinkClassWeaver(cw, classDetails);
            cr.accept(tcw, Attributes.getDefaultAttributes(), false);
            if (tcw.alreadyWeaved) {
                return null;
            }
            byte[] bytes = cw.toByteArray();
            if ("true".equalsIgnoreCase(System.getProperties().getProperty("toplink.weaver.clz", "false"))) {
                try {
                    FileOutputStream fos = new FileOutputStream(className.replace('/', '-') + ".clz");
                    fos.write(bytes);
                    fos.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (tcw.weavedVH) {
                return bytes;
            }
        }
        return null;
    }

    protected static String getShortName(String name) {
        int pos = name.lastIndexOf(47);
        if (pos >= 0) {
            if ((name = name.substring(pos + 1)).endsWith(";")) {
                name = name.substring(0, name.length() - 1);
            }
            return name;
        }
        return "";
    }
}

