/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.queryframework;

import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.DescriptorQueryManager;
import oracle.toplink.essentials.descriptors.InheritancePolicy;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.descriptors.OptimisticLockingPolicy;
import oracle.toplink.essentials.internal.expressions.DataExpression;
import oracle.toplink.essentials.internal.expressions.ExpressionIterator;
import oracle.toplink.essentials.internal.expressions.ObjectExpression;
import oracle.toplink.essentials.internal.expressions.SQLDeleteAllStatement;
import oracle.toplink.essentials.internal.expressions.SQLDeleteAllStatementForTempTable;
import oracle.toplink.essentials.internal.expressions.SQLDeleteStatement;
import oracle.toplink.essentials.internal.expressions.SQLInsertStatement;
import oracle.toplink.essentials.internal.expressions.SQLModifyStatement;
import oracle.toplink.essentials.internal.expressions.SQLSelectStatement;
import oracle.toplink.essentials.internal.expressions.SQLStatement;
import oracle.toplink.essentials.internal.expressions.SQLUpdateAllStatement;
import oracle.toplink.essentials.internal.expressions.SQLUpdateAllStatementForOracleAnonymousBlock;
import oracle.toplink.essentials.internal.expressions.SQLUpdateAllStatementForTempTable;
import oracle.toplink.essentials.internal.expressions.SQLUpdateStatement;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.IdentityHashtable;
import oracle.toplink.essentials.internal.helper.InvalidObject;
import oracle.toplink.essentials.internal.helper.NonSynchronizedVector;
import oracle.toplink.essentials.internal.queryframework.DatabaseQueryMechanism;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.internal.queryframework.ReportItem;
import oracle.toplink.essentials.internal.queryframework.StatementQueryMechanism;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.DirectCollectionMapping;
import oracle.toplink.essentials.mappings.ManyToManyMapping;
import oracle.toplink.essentials.mappings.OneToOneMapping;
import oracle.toplink.essentials.queryframework.ConstructorReportItem;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.DeleteAllQuery;
import oracle.toplink.essentials.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.essentials.queryframework.ModifyAllQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReadAllQuery;
import oracle.toplink.essentials.queryframework.ReadObjectQuery;
import oracle.toplink.essentials.queryframework.ReportQuery;
import oracle.toplink.essentials.queryframework.SQLCall;
import oracle.toplink.essentials.queryframework.UpdateAllQuery;

public class ExpressionQueryMechanism
extends StatementQueryMechanism {
    protected Expression selectionCriteria;

    public ExpressionQueryMechanism(DatabaseQuery query) {
        super(query);
    }

    public ExpressionQueryMechanism(DatabaseQuery query, Expression expression) {
        super(query);
        this.selectionCriteria = expression;
    }

    protected Vector aliasFields(ObjectExpression node, Vector fields) {
        Vector<DatabaseField> result = new Vector<DatabaseField>(fields.size());
        Enumeration e = fields.elements();
        while (e.hasMoreElements()) {
            DatabaseField eachField = (DatabaseField)((DatabaseField)e.nextElement()).clone();
            eachField.setTable(node.aliasForTable(eachField.getTable()));
            result.addElement(eachField);
        }
        return result;
    }

    public Vector aliasPresetFields(SQLSelectStatement statement) {
        Vector fields = statement.getFields();
        Expression exp = statement.getWhereClause();
        if (exp == null) {
            return fields;
        }
        ExpressionBuilder base = exp.getBuilder();
        return this.aliasFields(base, fields);
    }

    public Expression buildBaseSelectionCriteria(boolean isSubSelect, Dictionary clonedExpressions) {
        DescriptorQueryManager queryManager;
        Expression expression = this.getSelectionCriteria();
        if (expression == null && this.getQuery().isObjectLevelReadQuery()) {
            expression = ((ObjectLevelReadQuery)this.getQuery()).getExpressionBuilder();
        }
        if (!isSubSelect && expression != null) {
            expression = expression.copiedVersionFrom(clonedExpressions);
        }
        if (!((queryManager = this.getDescriptor().getQueryManager()).getAdditionalJoinExpression() == null || this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().hasView())) {
            Expression additionalJoin = queryManager.getAdditionalJoinExpression();
            expression = expression == null ? (Expression)additionalJoin.clone() : expression.and(additionalJoin);
            expression.getBuilder().setWasAdditionJoinCriteriaUsed(true);
        }
        return expression;
    }

    public SQLSelectStatement buildBaseSelectStatement(boolean isSubSelect, Dictionary clonedExpressions) {
        SQLSelectStatement selectStatement = new SQLSelectStatement();
        selectStatement.setLockingClause(((ObjectLevelReadQuery)this.getQuery()).getLockingClause());
        selectStatement.setDistinctState(((ObjectLevelReadQuery)this.getQuery()).getDistinctState());
        selectStatement.setTables((Vector)this.getDescriptor().getTables().clone());
        selectStatement.setWhereClause(this.buildBaseSelectionCriteria(isSubSelect, clonedExpressions));
        if (this.getQuery().isReadAllQuery() && ((ReadAllQuery)this.getQuery()).hasOrderByExpressions()) {
            selectStatement.setOrderByExpressions(((ReadAllQuery)this.getQuery()).getOrderByExpressions());
        }
        selectStatement.setTranslationRow(this.getTranslationRow());
        return selectStatement;
    }

    protected SQLSelectStatement buildConcreteSelectStatement() {
        IdentityHashtable clonedExpressions = new IdentityHashtable();
        SQLSelectStatement selectStatement = this.buildBaseSelectStatement(false, clonedExpressions);
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().shouldReadSubclasses()) {
            Expression concrete = this.getDescriptor().getInheritancePolicy().getOnlyInstancesExpression();
            if (concrete != null && selectStatement.getWhereClause() != null) {
                selectStatement.setWhereClause(selectStatement.getWhereClause().and(concrete));
            } else if (concrete != null) {
                selectStatement.setWhereClause((Expression)concrete.clone());
            }
        }
        selectStatement.setFields(this.getSelectionFields(selectStatement, false));
        selectStatement.normalize(this.getSession(), this.getDescriptor(), clonedExpressions);
        ((ObjectLevelReadQuery)this.getQuery()).getJoinedAttributeManager().computeJoiningMappingIndexes(false, this.getSession(), 0);
        return selectStatement;
    }

    protected SQLDeleteStatement buildDeleteAllStatement(DatabaseTable table, Expression inheritanceExpression, SQLCall selectCallForExist, SQLSelectStatement selectStatementForExist, SQLCall selectCallForNotExist, SQLSelectStatement selectStatementForNotExist, Collection primaryKeyFields) {
        if (selectCallForExist == null && selectCallForNotExist == null) {
            return this.buildDeleteAllStatement(table, inheritanceExpression);
        }
        SQLDeleteAllStatement deleteAllStatement = new SQLDeleteAllStatement();
        deleteAllStatement.setTable(table);
        deleteAllStatement.setTranslationRow(this.getTranslationRow());
        if (inheritanceExpression != null) {
            deleteAllStatement.setInheritanceExpression((Expression)inheritanceExpression.clone());
        }
        if (selectCallForExist != null) {
            deleteAllStatement.setSelectCallForExist(selectCallForExist);
            deleteAllStatement.setTableAliasInSelectCallForExist(ExpressionQueryMechanism.getAliasTableName(selectStatementForExist, table));
        }
        if (selectCallForNotExist != null) {
            deleteAllStatement.setSelectCallForNotExist(selectCallForNotExist);
            deleteAllStatement.setTableAliasInSelectCallForNotExist(ExpressionQueryMechanism.getAliasTableName(selectStatementForNotExist, table));
        }
        deleteAllStatement.setPrimaryKeyFieldsForAutoJoin(primaryKeyFields);
        return deleteAllStatement;
    }

    protected SQLDeleteStatement buildSQLDeleteAllStatementForMapping(SQLCall selectCallForExist, SQLSelectStatement selectStatementForExist, Vector sourceFields, Vector targetFields) {
        DatabaseTable targetTable = ((DatabaseField)targetFields.firstElement()).getTable();
        if (selectCallForExist == null) {
            return this.buildDeleteAllStatement(targetTable);
        }
        SQLDeleteAllStatement deleteAllStatement = new SQLDeleteAllStatement();
        deleteAllStatement.setTable(targetTable);
        deleteAllStatement.setTranslationRow(this.getTranslationRow());
        deleteAllStatement.setSelectCallForExist(selectCallForExist);
        DatabaseTable sourceTable = ((DatabaseField)sourceFields.firstElement()).getTable();
        if (selectStatementForExist != null) {
            deleteAllStatement.setTableAliasInSelectCallForExist(ExpressionQueryMechanism.getAliasTableName(selectStatementForExist, sourceTable));
        }
        deleteAllStatement.setAliasedFieldsForJoin(sourceFields);
        deleteAllStatement.setOriginalFieldsForJoin(targetFields);
        return deleteAllStatement;
    }

    protected static String getAliasTableName(SQLSelectStatement selectStatement, DatabaseTable table) {
        if (!selectStatement.requiresAliases()) {
            return null;
        }
        HashSet<DatabaseTable> aliasTables = new HashSet<DatabaseTable>();
        Iterator itEntries = selectStatement.getTableAliases().entrySet().iterator();
        DatabaseTable aliasTable = null;
        while (itEntries.hasNext()) {
            Map.Entry entry = itEntries.next();
            if (!table.equals(entry.getValue())) continue;
            aliasTable = (DatabaseTable)entry.getKey();
            aliasTables.add(aliasTable);
        }
        if (aliasTables.isEmpty()) {
            return null;
        }
        if (aliasTables.size() == 1) {
            return aliasTable.getQualifiedName();
        }
        ExpressionIterator expIterator = new ExpressionIterator(){

            public void iterate(Expression each) {
                DataExpression dataExpression;
                DatabaseField field;
                if (each instanceof DataExpression && (field = (dataExpression = (DataExpression)each).getField()) != null && dataExpression.getBaseExpression() != this.getStatement().getBuilder()) {
                    ((Collection)this.getResult()).remove(dataExpression.getAliasedField().getTable());
                }
            }

            public boolean shouldIterateOverSubSelects() {
                return true;
            }
        };
        expIterator.setStatement(selectStatement);
        expIterator.setResult(aliasTables);
        expIterator.iterateOn(selectStatement.getWhereClause());
        if (aliasTables.size() == 1) {
            aliasTable = (DatabaseTable)aliasTables.iterator().next();
            return aliasTable.getQualifiedName();
        }
        if (aliasTables.isEmpty()) {
            return aliasTable.getQualifiedName();
        }
        aliasTable = (DatabaseTable)aliasTables.iterator().next();
        return aliasTable.getQualifiedName();
    }

    protected SQLDeleteStatement buildDeleteAllStatement() {
        return this.buildDeleteAllStatement(this.getDescriptor().getDefaultTable());
    }

    protected SQLDeleteStatement buildDeleteAllStatement(Expression inheritanceExpression) {
        return this.buildDeleteAllStatement(this.getDescriptor().getDefaultTable(), inheritanceExpression);
    }

    protected SQLDeleteStatement buildDeleteAllStatement(DatabaseTable table) {
        return this.buildDeleteAllStatement(table, null);
    }

    protected SQLDeleteStatement buildDeleteAllStatement(DatabaseTable table, Expression inheritanceExpression) {
        SQLDeleteStatement deleteStatement = new SQLDeleteStatement();
        deleteStatement.setWhereClause(this.getSelectionCriteria());
        if (deleteStatement.getWhereClause() != null) {
            deleteStatement.setWhereClause((Expression)deleteStatement.getWhereClause().clone());
            deleteStatement.getWhereClause().getBuilder().setSession(this.getSession());
            deleteStatement.getWhereClause().getBuilder().setQueryClass(this.getQuery().getReferenceClass());
        }
        if (inheritanceExpression != null) {
            if (deleteStatement.getWhereClause() != null) {
                deleteStatement.setWhereClause(deleteStatement.getWhereClause().and(inheritanceExpression));
            } else {
                deleteStatement.setWhereClause((Expression)inheritanceExpression.clone());
            }
        }
        deleteStatement.setTable(table);
        deleteStatement.setTranslationRow(this.getTranslationRow());
        return deleteStatement;
    }

    protected SQLDeleteStatement buildDeleteStatement(DatabaseTable table) {
        SQLDeleteStatement deleteStatement = new SQLDeleteStatement();
        Expression whereClause = this.getDescriptor().getObjectBuilder().buildDeleteExpression(table, this.getTranslationRow());
        deleteStatement.setWhereClause(whereClause);
        deleteStatement.setTable(table);
        deleteStatement.setTranslationRow(this.getTranslationRow());
        return deleteStatement;
    }

    protected SQLInsertStatement buildInsertStatement(DatabaseTable table) {
        SQLInsertStatement insertStatement = new SQLInsertStatement();
        insertStatement.setTable(table);
        insertStatement.setModifyRow(this.getModifyRow());
        return insertStatement;
    }

    protected SQLSelectStatement buildNormalSelectStatement() {
        IdentityHashtable clonedExpressions = new IdentityHashtable();
        SQLSelectStatement selectStatement = this.buildBaseSelectStatement(false, clonedExpressions);
        if (this.getDescriptor().hasInheritance()) {
            this.getDescriptor().getInheritancePolicy().appendWithAllSubclassesExpression(selectStatement);
        }
        selectStatement.setFields(this.getSelectionFields(selectStatement, true));
        selectStatement.setNonSelectFields(this.getNonSelectionFields());
        selectStatement.normalize(this.getSession(), this.getDescriptor(), clonedExpressions);
        ((ObjectLevelReadQuery)this.getQuery()).getJoinedAttributeManager().computeJoiningMappingIndexes(true, this.getSession(), 0);
        return selectStatement;
    }

    protected SQLSelectStatement buildReportQuerySelectStatement(boolean isSubSelect) {
        return this.buildReportQuerySelectStatement(isSubSelect, false, null);
    }

    protected SQLSelectStatement buildReportQuerySelectStatement(boolean isSubSelect, boolean useCustomaryInheritanceExpression, Expression inheritanceExpression) {
        int i;
        int size;
        List reportItems;
        ConstructorReportItem citem;
        IdentityHashtable clonedExpressions = isSubSelect ? null : new IdentityHashtable();
        SQLSelectStatement selectStatement = this.buildBaseSelectStatement(isSubSelect, clonedExpressions);
        selectStatement.setGroupByExpressions(((ReportQuery)this.getQuery()).getGroupByExpressions());
        selectStatement.setHavingExpression(((ReportQuery)this.getQuery()).getHavingExpression());
        if (this.getDescriptor().hasInheritance()) {
            if (useCustomaryInheritanceExpression) {
                if (inheritanceExpression != null) {
                    if (selectStatement.getWhereClause() == null) {
                        selectStatement.setWhereClause((Expression)inheritanceExpression.clone());
                    } else {
                        selectStatement.setWhereClause(selectStatement.getWhereClause().and(inheritanceExpression));
                    }
                }
            } else {
                this.getDescriptor().getInheritancePolicy().appendWithAllSubclassesExpression(selectStatement);
            }
        }
        Vector fieldExpressions = ((ReportQuery)this.getQuery()).getQueryExpressions();
        int itemOffset = fieldExpressions.size();
        for (ReportItem item : ((ReportQuery)this.getQuery()).getItems()) {
            if (item.isContructorItem()) {
                citem = (ConstructorReportItem)item;
                reportItems = citem.getReportItems();
                size = reportItems.size();
                for (i = 0; i < size; ++i) {
                    item = (ReportItem)reportItems.get(i);
                    this.extractStatementFromItem(item, clonedExpressions, selectStatement, fieldExpressions);
                }
                continue;
            }
            this.extractStatementFromItem(item, clonedExpressions, selectStatement, fieldExpressions);
        }
        selectStatement.setFields(fieldExpressions);
        selectStatement.setNonSelectFields(((ReportQuery)this.getQuery()).getNonFetchJoinAttributeExpressions());
        if (!isSubSelect) {
            selectStatement.normalize(this.getSession(), this.getDescriptor(), clonedExpressions);
        }
        for (ReportItem item : ((ReportQuery)this.getQuery()).getItems()) {
            if (item.isContructorItem()) {
                citem = (ConstructorReportItem)item;
                reportItems = citem.getReportItems();
                size = reportItems.size();
                for (i = 0; i < size; ++i) {
                    item = (ReportItem)reportItems.get(i);
                    itemOffset = this.computeAndSetItemOffset(item, itemOffset);
                }
                continue;
            }
            itemOffset = this.computeAndSetItemOffset(item, itemOffset);
        }
        return selectStatement;
    }

    protected int computeAndSetItemOffset(ReportItem item, int itemOffset) {
        item.setResultIndex(itemOffset);
        if (item.getAttributeExpression() != null) {
            JoinedAttributeManager joinManager = item.getJoinedAttributeManager();
            itemOffset = joinManager.hasJoinedExpressions() ? joinManager.computeJoiningMappingIndexes(true, this.getSession(), itemOffset) : (item.getDescriptor() != null ? (itemOffset += item.getDescriptor().getAllFields().size()) : ++itemOffset);
        }
        return itemOffset;
    }

    public void extractStatementFromItem(ReportItem item, IdentityHashtable clonedExpressions, SQLSelectStatement selectStatement, Vector fieldExpressions) {
        if (item.getAttributeExpression() != null) {
            ExpressionBuilder clonedBuilder = item.getAttributeExpression().getBuilder();
            if (clonedBuilder.wasQueryClassSetInternally() && ((ReportQuery)this.getQuery()).getExpressionBuilder() != clonedBuilder) {
                clonedBuilder = selectStatement.getBuilder();
                item.attributeExpression = item.attributeExpression.rebuildOn(clonedBuilder);
            } else if (clonedExpressions != null && clonedExpressions.get(clonedBuilder) != null) {
                clonedBuilder = (ExpressionBuilder)clonedBuilder.copiedVersionFrom(clonedExpressions);
                item.attributeExpression = item.attributeExpression.rebuildOn(clonedBuilder);
            }
            if (item.getAttributeExpression().isExpressionBuilder() && item.getDescriptor().getQueryManager().getAdditionalJoinExpression() != null) {
                if (selectStatement.getWhereClause() == null) {
                    selectStatement.setWhereClause(item.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(clonedBuilder));
                } else {
                    selectStatement.setWhereClause(selectStatement.getWhereClause().and(item.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(clonedBuilder)));
                }
            }
            fieldExpressions.add(item.getAttributeExpression());
            JoinedAttributeManager joinManager = item.getJoinedAttributeManager();
            if (joinManager.hasJoinedExpressions()) {
                fieldExpressions.addAll(joinManager.getJoinedAttributeExpressions());
                fieldExpressions.addAll(joinManager.getJoinedMappingExpressions());
            }
        }
    }

    protected SQLSelectStatement buildSelectStatementForDoesExist(DatabaseField field) {
        SQLSelectStatement selectStatement = new SQLSelectStatement();
        selectStatement.addField(field);
        selectStatement.setWhereClause(((Expression)this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression().clone()).and(this.getDescriptor().getQueryManager().getAdditionalJoinExpression()));
        selectStatement.setTranslationRow(this.getTranslationRow());
        selectStatement.normalize(this.getSession(), this.getQuery().getDescriptor());
        return selectStatement;
    }

    protected SQLUpdateAllStatement buildUpdateAllStatement(DatabaseTable table, HashMap databaseFieldsToValues, SQLCall selectCallForExist, SQLSelectStatement selectStatementForExist, Collection primaryKeyFields) {
        SQLUpdateAllStatement updateAllStatement = new SQLUpdateAllStatement();
        updateAllStatement.setTable(table);
        updateAllStatement.setTranslationRow(this.getTranslationRow());
        HashMap<DatabaseField, SQLCall> databaseFieldsToValuesCopy = new HashMap<DatabaseField, SQLCall>(databaseFieldsToValues.size());
        HashMap<DatabaseField, String> databaseFieldsToTableAliases = null;
        for (Map.Entry entry : databaseFieldsToValues.entrySet()) {
            DatabaseField field = (DatabaseField)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof SQLSelectStatement) {
                SQLSelectStatement selStatement = (SQLSelectStatement)value;
                SQLCall selCall = (SQLCall)selStatement.buildCall(this.getSession());
                databaseFieldsToValuesCopy.put(field, selCall);
                if (databaseFieldsToTableAliases == null) {
                    databaseFieldsToTableAliases = new HashMap<DatabaseField, String>();
                    updateAllStatement.setPrimaryKeyFieldsForAutoJoin(primaryKeyFields);
                }
                databaseFieldsToTableAliases.put(field, ExpressionQueryMechanism.getAliasTableName(selStatement, table));
                continue;
            }
            databaseFieldsToValuesCopy.put(field, (SQLCall)value);
        }
        updateAllStatement.setUpdateClauses(databaseFieldsToValuesCopy);
        updateAllStatement.setDatabaseFieldsToTableAliases(databaseFieldsToTableAliases);
        if (selectCallForExist != null) {
            updateAllStatement.setSelectCallForExist(selectCallForExist);
            updateAllStatement.setTableAliasInSelectCallForExist(ExpressionQueryMechanism.getAliasTableName(selectStatementForExist, table));
            updateAllStatement.setPrimaryKeyFieldsForAutoJoin(primaryKeyFields);
        } else {
            updateAllStatement.setWhereClause(this.getSelectionCriteria());
            if (updateAllStatement.getWhereClause() != null) {
                updateAllStatement.setWhereClause((Expression)updateAllStatement.getWhereClause().clone());
                updateAllStatement.getWhereClause().getBuilder().setSession(this.getSession());
                updateAllStatement.getWhereClause().getBuilder().setQueryClass(this.getQuery().getReferenceClass());
            }
        }
        return updateAllStatement;
    }

    protected SQLUpdateStatement buildUpdateStatement(DatabaseTable table) {
        SQLUpdateStatement updateStatement = new SQLUpdateStatement();
        updateStatement.setModifyRow(this.getModifyRow());
        updateStatement.setTranslationRow(this.getTranslationRow());
        updateStatement.setTable(table);
        updateStatement.setWhereClause(this.getDescriptor().getObjectBuilder().buildUpdateExpression(table, this.getTranslationRow(), this.getModifyRow()));
        return updateStatement;
    }

    public Object checkCacheForObject(AbstractRecord translationRow, AbstractSession session) {
        Expression selectionCriteria;
        Vector selectionKey;
        Object cachedObject;
        InMemoryQueryIndirectionPolicy policyToUse;
        boolean conforming;
        ReadObjectQuery query;
        block31: {
            query = this.getReadObjectQuery();
            conforming = (query.shouldConformResultsInUnitOfWork() || this.getDescriptor().shouldAlwaysConformResultsInUnitOfWork()) && session.isUnitOfWork();
            policyToUse = query.getInMemoryQueryIndirectionPolicy();
            if (conforming && !policyToUse.shouldTriggerIndirection()) {
                policyToUse = new InMemoryQueryIndirectionPolicy();
                policyToUse.ignoreIndirectionExceptionReturnNotConformed();
            }
            cachedObject = null;
            selectionKey = null;
            selectionCriteria = this.getSelectionCriteria();
            if (query.getSelectionKey() != null || query.getSelectionObject() != null) {
                if (query.getSelectionKey() == null && query.getSelectionObject() != null) {
                    query.setSelectionKey(this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(query.getSelectionObject(), session));
                }
                if (query.getSelectionKey() != null) {
                    selectionKey = query.getSelectionKey();
                    cachedObject = this.getDescriptor().shouldAcquireCascadedLocks() ? session.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(selectionKey, query.getReferenceClass(), false, this.getDescriptor()) : session.getIdentityMapAccessorInstance().getFromIdentityMap(selectionKey, query.getReferenceClass(), false, this.getDescriptor());
                }
            } else if (selectionCriteria == null) {
                if (query.shouldConformResultsInUnitOfWork() || this.getDescriptor().shouldAlwaysConformResultsInUnitOfWork() || query.shouldCheckCacheOnly() || query.shouldCheckCacheThenDatabase()) {
                    cachedObject = session.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(null, query.getReferenceClass(), translationRow, policyToUse, conforming, false, this.getDescriptor());
                }
            } else {
                selectionKey = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromExpression(true, selectionCriteria, translationRow, session);
                if (selectionKey != null || query.shouldCheckCacheByExactPrimaryKey()) {
                    if (selectionKey != null) {
                        cachedObject = this.getDescriptor().shouldAcquireCascadedLocks() ? session.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(selectionKey, query.getReferenceClass(), false, this.getDescriptor()) : session.getIdentityMapAccessorInstance().getFromIdentityMap(selectionKey, query.getReferenceClass(), false, this.getDescriptor());
                    }
                } else {
                    boolean conformingButOutsideUnitOfWork;
                    Vector inexactSelectionKey = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromExpression(false, selectionCriteria, translationRow, session);
                    if (inexactSelectionKey != null && (cachedObject = this.getDescriptor().shouldAcquireCascadedLocks() ? session.getIdentityMapAccessorInstance().getFromIdentityMapWithDeferredLock(inexactSelectionKey, query.getReferenceClass(), false, this.getDescriptor()) : session.getIdentityMapAccessorInstance().getFromIdentityMap(inexactSelectionKey, query.getReferenceClass(), false, this.getDescriptor())) != null) {
                        try {
                            selectionCriteria.getBuilder().setSession(session.getRootSession(query));
                            selectionCriteria.getBuilder().setQueryClass(this.getDescriptor().getJavaClass());
                            if (!selectionCriteria.doesConform(cachedObject, session, translationRow, policyToUse)) {
                                cachedObject = null;
                            }
                        }
                        catch (QueryException exception) {
                            if (query.shouldCheckCacheOnly()) {
                                throw exception;
                            }
                            cachedObject = null;
                        }
                    }
                    boolean bl = conformingButOutsideUnitOfWork = (query.shouldConformResultsInUnitOfWork() || this.getDescriptor().shouldAlwaysConformResultsInUnitOfWork()) && !session.isUnitOfWork();
                    if (cachedObject == null && (conforming || !query.shouldCheckCacheByPrimaryKey() && !conformingButOutsideUnitOfWork)) {
                        if (selectionCriteria != null) {
                            selectionCriteria.getBuilder().setSession(session.getRootSession(query));
                            selectionCriteria.getBuilder().setQueryClass(this.getDescriptor().getJavaClass());
                        }
                        try {
                            cachedObject = session.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(selectionCriteria, query.getReferenceClass(), translationRow, policyToUse, conforming, false, this.getDescriptor());
                        }
                        catch (QueryException exception) {
                            if (!query.shouldCheckCacheOnly()) break block31;
                            throw exception;
                        }
                    }
                }
            }
        }
        if (conforming) {
            if (selectionCriteria != null) {
                selectionCriteria.getBuilder().setSession(session.getRootSession(query));
                selectionCriteria.getBuilder().setQueryClass(this.getDescriptor().getJavaClass());
            }
            if (cachedObject == null) {
                try {
                    if (selectionKey != null) {
                        if (!((UnitOfWorkImpl)session).shouldNewObjectsBeCached()) {
                            cachedObject = ((UnitOfWorkImpl)session).getObjectFromNewObjects(query.getReferenceClass(), selectionKey);
                        }
                    } else {
                        cachedObject = ((UnitOfWorkImpl)session).getObjectFromNewObjects(selectionCriteria, query.getReferenceClass(), translationRow, policyToUse);
                    }
                }
                catch (QueryException exception) {
                    // empty catch block
                }
            }
            if (cachedObject != null && ((UnitOfWorkImpl)session).isObjectDeleted(cachedObject)) {
                if (selectionKey != null) {
                    return InvalidObject.instance;
                }
                cachedObject = null;
            }
        }
        if (this.getDescriptor().hasFetchGroupManager() && this.getDescriptor().getFetchGroupManager().isPartialObject(cachedObject) && !this.getDescriptor().getFetchGroupManager().isObjectValidForFetchGroup(cachedObject, this.getReadObjectQuery().getFetchGroup())) {
            cachedObject = null;
        }
        return cachedObject;
    }

    public DatabaseQueryMechanism clone(DatabaseQuery queryClone) {
        DatabaseQueryMechanism clone = (DatabaseQueryMechanism)this.clone();
        clone.setQuery(queryClone);
        return clone;
    }

    public ExpressionBuilder getExpressionBuilder() {
        if (this.getSelectionCriteria() != null) {
            return this.getSelectionCriteria().getBuilder();
        }
        return null;
    }

    public Expression getSelectionCriteria() {
        return this.selectionCriteria;
    }

    public Vector getSelectionFields(SQLSelectStatement statement, boolean includeAllSubclassFields) {
        Vector fields;
        ObjectLevelReadQuery owner = (ObjectLevelReadQuery)this.getQuery();
        if (owner.hasFetchGroupAttributeExpressions()) {
            Vector<Expression> fields2 = new Vector<Expression>(owner.getFetchGroup().getFetchGroupAttributeExpressions().size());
            for (Expression fetchGroupAttrExpr : owner.getFetchGroup().getFetchGroupAttributeExpressions()) {
                fields2.add(fetchGroupAttrExpr);
            }
            Helper.addAllToVector(fields2, owner.getAdditionalFields());
            return fields2;
        }
        ExpressionBuilder base = statement.getExpressionBuilder();
        if (includeAllSubclassFields) {
            fields = (Vector)this.getDescriptor().getAllFields().clone();
        } else {
            fields = NonSynchronizedVector.newInstance();
            fields.addElement(base);
        }
        fields.addAll(owner.getJoinedAttributeManager().getJoinedAttributeExpressions());
        fields.addAll(owner.getJoinedAttributeManager().getJoinedMappingExpressions());
        fields.addAll(owner.getAdditionalFields());
        return fields;
    }

    public Vector getNonSelectionFields() {
        NonSynchronizedVector fields = NonSynchronizedVector.newInstance();
        ((Vector)fields).addAll(((ObjectLevelReadQuery)this.getQuery()).getNonFetchJoinAttributeExpressions());
        return fields;
    }

    public boolean isExpressionQueryMechanism() {
        return true;
    }

    public boolean isStatementQueryMechanism() {
        return false;
    }

    public void prepare() throws QueryException {
    }

    public void prepareCursorSelectAllRows() {
        if (this.getQuery().isReportQuery()) {
            SQLSelectStatement statement = this.buildReportQuerySelectStatement(false);
            this.setSQLStatement(statement);
        } else if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead() && this.getDescriptor().getInheritancePolicy().hasView()) {
            InheritancePolicy inheritancePolicy = this.getDescriptor().getInheritancePolicy();
            SQLSelectStatement statement = inheritancePolicy.buildViewSelectStatement((ObjectLevelReadQuery)this.getQuery());
            this.setSQLStatement(statement);
        } else {
            this.setSQLStatement(this.buildNormalSelectStatement());
        }
        super.prepareCursorSelectAllRows();
    }

    public void prepareDeleteAll() {
        this.prepareDeleteAll(null);
    }

    protected void prepareDeleteAll(Vector tablesToIgnore) {
        boolean shouldHandleChildren;
        Vector<DatabaseTable> tablesInInsertOrder;
        if (tablesToIgnore == null) {
            tablesInInsertOrder = this.getDescriptor().getMultipleTableInsertOrder();
        } else {
            tablesInInsertOrder = new Vector<DatabaseTable>(this.getDescriptor().getMultipleTableInsertOrder().size());
            for (DatabaseTable table : this.getDescriptor().getMultipleTableInsertOrder()) {
                if (tablesToIgnore.contains(table)) continue;
                tablesInInsertOrder.addElement(table);
            }
        }
        if (!tablesInInsertOrder.isEmpty()) {
            SQLSelectStatement selectStatementForExist;
            boolean isMainCase;
            Expression whereClause = this.getSelectionCriteria();
            SQLCall selectCallForExist = null;
            boolean isSelectCallForNotExistRequired = tablesToIgnore == null && tablesInInsertOrder.size() > 1;
            SQLSelectStatement selectStatementForNotExist = null;
            SQLCall selectCallForNotExist = null;
            Expression inheritanceExpression = null;
            if (this.getDescriptor().hasInheritance()) {
                inheritanceExpression = this.getDescriptor().getInheritancePolicy().shouldReadSubclasses() ? this.getDescriptor().getInheritancePolicy().getWithAllSubclassesExpression() : this.getDescriptor().getInheritancePolicy().getOnlyInstancesExpression();
            }
            if (isMainCase = (selectStatementForExist = this.createSQLSelectStatementForModifyAll(whereClause)).requiresAliases()) {
                if (whereClause != null) {
                    if (this.getSession().getPlatform().shouldAlwaysUseTempStorageForModifyAll() && tablesToIgnore == null && !this.getSession().getPlatform().isOracle()) {
                        this.prepareDeleteAllUsingTempStorage();
                        return;
                    }
                    selectCallForExist = (SQLCall)selectStatementForExist.buildCall(this.getSession());
                    if (isSelectCallForNotExistRequired) {
                        selectStatementForNotExist = this.createSQLSelectStatementForModifyAll(null, null);
                        selectCallForNotExist = (SQLCall)selectStatementForNotExist.buildCall(this.getSession());
                    }
                } else if (this.getSession().getPlatform().shouldAlwaysUseTempStorageForModifyAll() && tablesToIgnore == null && !this.getSession().getPlatform().isOracle() && this.getDescriptor().hasInheritance() && this.getDescriptor().getTables().size() > 2) {
                    this.prepareDeleteAllUsingTempStorage();
                    return;
                }
            }
            if (isMainCase) {
                Enumeration tablesEnum = tablesInInsertOrder.elements();
                while (tablesEnum.hasMoreElements()) {
                    SQLDeleteStatement deleteStatement;
                    boolean useSelectCallForExist;
                    DatabaseTable table = (DatabaseTable)tablesEnum.nextElement();
                    Collection primaryKeyFields = this.getPrimaryKeyFieldsForTable(table);
                    boolean bl = useSelectCallForExist = !isSelectCallForNotExistRequired || table.equals((DatabaseTable)tablesInInsertOrder.lastElement());
                    if (useSelectCallForExist) {
                        deleteStatement = this.buildDeleteAllStatement(table, null, selectCallForExist, selectStatementForExist, null, null, primaryKeyFields);
                    } else if (inheritanceExpression == null) {
                        deleteStatement = this.buildDeleteAllStatement(table, null, null, null, selectCallForNotExist, selectStatementForNotExist, primaryKeyFields);
                    } else if (table.equals(this.getDescriptor().getMultipleTableInsertOrder().firstElement())) {
                        deleteStatement = this.buildDeleteAllStatement(table, inheritanceExpression, null, null, selectCallForNotExist, selectStatementForNotExist, primaryKeyFields);
                    } else {
                        ClassDescriptor desc = this.getDescriptor();
                        ClassDescriptor parentDescriptor = this.getDescriptor().getInheritancePolicy().getParentDescriptor();
                        while (parentDescriptor.getTables().contains(table)) {
                            desc = parentDescriptor;
                            parentDescriptor = parentDescriptor.getInheritancePolicy().getParentDescriptor();
                        }
                        if (desc == this.getDescriptor()) {
                            deleteStatement = this.buildDeleteAllStatement(table, null, null, null, selectCallForNotExist, selectStatementForNotExist, primaryKeyFields);
                        } else {
                            SQLSelectStatement inheritanceSelectStatementForExist = this.createSQLSelectStatementForModifyAll(null, inheritanceExpression, desc);
                            SQLCall inheritanceSelectCallForExist = (SQLCall)inheritanceSelectStatementForExist.buildCall(this.getSession());
                            deleteStatement = this.buildDeleteAllStatement(table, null, inheritanceSelectCallForExist, inheritanceSelectStatementForExist, selectCallForNotExist, selectStatementForNotExist, primaryKeyFields);
                        }
                    }
                    if (this.getDescriptor().getTables().size() > 1) {
                        this.getSQLStatements().addElement(deleteStatement);
                        continue;
                    }
                    this.setSQLStatement(deleteStatement);
                }
            } else {
                this.setSQLStatement(this.buildDeleteAllStatement(inheritanceExpression));
            }
            Vector deleteStatementsForMappings = this.buildDeleteAllStatementsForMappings(inheritanceExpression, selectCallForExist, selectStatementForExist, tablesToIgnore == null);
            if (!deleteStatementsForMappings.isEmpty()) {
                if (this.getSQLStatement() != null) {
                    this.getSQLStatements().add(this.getSQLStatement());
                    this.setSQLStatement(null);
                }
                this.getSQLStatements().addAll(deleteStatementsForMappings);
            }
        }
        boolean hasChildrenWithExtraTables = this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().hasChildren() && this.getDescriptor().getInheritancePolicy().hasMultipleTableChild();
        boolean bl = shouldHandleChildren = hasChildrenWithExtraTables && this.getDescriptor().getInheritancePolicy().shouldReadSubclasses();
        if (shouldHandleChildren) {
            Vector<DatabaseTable> tablesToIgnoreForChildren = new Vector<DatabaseTable>();
            if (tablesToIgnore != null) {
                tablesToIgnoreForChildren.addAll(tablesToIgnore);
            }
            if (this.getDescriptor().getInheritancePolicy().shouldReadSubclasses()) {
                tablesToIgnoreForChildren.addAll(tablesInInsertOrder);
            }
            for (ClassDescriptor childDescriptor : this.getDescriptor().getInheritancePolicy().getChildDescriptors()) {
                if (childDescriptor.getTables().size() <= this.getDescriptor().getTables().size() && !childDescriptor.getInheritancePolicy().hasMultipleTableChild()) continue;
                DeleteAllQuery childQuery = new DeleteAllQuery();
                childQuery.setReferenceClass(childDescriptor.getJavaClass());
                childQuery.setSelectionCriteria(this.getSelectionCriteria());
                childQuery.setDescriptor(childDescriptor);
                childQuery.setSession(this.getSession());
                ExpressionQueryMechanism childMechanism = (ExpressionQueryMechanism)childQuery.getQueryMechanism();
                childMechanism.prepareDeleteAll(tablesToIgnoreForChildren);
                Vector<SQLStatement> childStatements = new Vector<SQLStatement>();
                if (childMechanism.getCall() != null) {
                    childStatements.add(childMechanism.getSQLStatement());
                } else if (childMechanism.getSQLStatements() != null) {
                    childStatements.addAll(childMechanism.getSQLStatements());
                }
                if (childStatements.isEmpty()) continue;
                if (this.getSQLStatement() != null) {
                    this.getSQLStatements().add(this.getSQLStatement());
                    this.setSQLStatement(null);
                }
                this.getSQLStatements().addAll(childStatements);
            }
        }
        if (tablesToIgnore == null) {
            ((DeleteAllQuery)this.getQuery()).setIsPreparedUsingTempStorage(false);
            super.prepareDeleteAll();
        }
    }

    protected void prepareDeleteAllUsingTempStorage() {
        if (!this.getSession().getPlatform().supportsTempTables()) {
            throw QueryException.tempTablesNotSupported(this.getQuery(), Helper.getShortClassName(this.getSession().getPlatform()));
        }
        this.prepareDeleteAllUsingTempTables();
    }

    protected void prepareDeleteAllUsingTempTables() {
        this.getSQLStatements().addAll(this.buildStatementsForDeleteAllForTempTables());
        ((DeleteAllQuery)this.getQuery()).setIsPreparedUsingTempStorage(true);
        super.prepareDeleteAll();
    }

    protected Vector buildDeleteAllStatementsForMappings(Expression inheritanceExpression, SQLCall selectCallForExist, SQLSelectStatement selectStatementForExist, boolean dontCheckDescriptor) {
        Vector<SQLDeleteStatement> deleteStatements = new Vector<SQLDeleteStatement>();
        for (DatabaseMapping mapping : this.getDescriptor().getMappings()) {
            if (!mapping.isManyToManyMapping() && !mapping.isDirectCollectionMapping() || !dontCheckDescriptor && !mapping.getDescriptor().equals(this.getDescriptor())) continue;
            Vector sourceFields = null;
            Vector targetFields = null;
            if (mapping.isManyToManyMapping()) {
                sourceFields = ((ManyToManyMapping)mapping).getSourceKeyFields();
                targetFields = ((ManyToManyMapping)mapping).getSourceRelationKeyFields();
            } else if (mapping.isDirectCollectionMapping()) {
                sourceFields = ((DirectCollectionMapping)mapping).getSourceKeyFields();
                targetFields = ((DirectCollectionMapping)mapping).getReferenceKeyFields();
            }
            if (selectCallForExist == null && (inheritanceExpression != null || this.getSelectionCriteria() != null)) {
                selectCallForExist = (SQLCall)selectStatementForExist.buildCall(this.getSession());
            }
            deleteStatements.addElement(this.buildSQLDeleteAllStatementForMapping(selectCallForExist, selectStatementForExist, sourceFields, targetFields));
        }
        return deleteStatements;
    }

    protected SQLSelectStatement createSQLSelectStatementForModifyAll(Expression whereClause) {
        return this.createSQLSelectStatementForModifyAll(whereClause, null, this.getDescriptor(), false);
    }

    protected SQLSelectStatement createSQLSelectStatementForModifyAll(Expression whereClause, Expression inheritanceExpression) {
        return this.createSQLSelectStatementForModifyAll(whereClause, inheritanceExpression, this.getDescriptor(), true);
    }

    protected SQLSelectStatement createSQLSelectStatementForModifyAll(Expression whereClause, Expression inheritanceExpression, ClassDescriptor desc) {
        return this.createSQLSelectStatementForModifyAll(whereClause, inheritanceExpression, desc, true);
    }

    protected SQLSelectStatement createSQLSelectStatementForModifyAll(Expression whereClause, Expression inheritanceExpression, ClassDescriptor desc, boolean useCustomaryInheritanceExpression) {
        ExpressionBuilder builder;
        if (whereClause != null) {
            whereClause = (Expression)whereClause.clone();
            builder = whereClause.getBuilder();
        } else {
            builder = new ExpressionBuilder();
        }
        ReportQuery reportQuery = new ReportQuery(desc.getJavaClass(), builder);
        reportQuery.setDescriptor(desc);
        reportQuery.setShouldRetrieveFirstPrimaryKey(true);
        reportQuery.setSelectionCriteria(whereClause);
        reportQuery.setSession(this.getSession());
        return ((ExpressionQueryMechanism)reportQuery.getQueryMechanism()).buildReportQuerySelectStatement(false, useCustomaryInheritanceExpression, inheritanceExpression);
    }

    protected SQLSelectStatement createSQLSelectStatementForAssignedExpressionForUpdateAll(Expression value) {
        ReportQuery reportQuery = new ReportQuery(this.getQuery().getReferenceClass(), value.getBuilder());
        reportQuery.setDescriptor(this.getQuery().getDescriptor());
        reportQuery.setSession(this.getSession());
        reportQuery.addAttribute("", value);
        return ((ExpressionQueryMechanism)reportQuery.getQueryMechanism()).buildReportQuerySelectStatement(false);
    }

    public void prepareDeleteObject() {
        Enumeration tablesEnum = this.getDescriptor().getMultipleTableInsertOrder().elements();
        while (tablesEnum.hasMoreElements()) {
            DatabaseTable table = (DatabaseTable)tablesEnum.nextElement();
            SQLDeleteStatement deleteStatement = this.buildDeleteStatement(table);
            if (this.getDescriptor().getTables().size() > 1) {
                this.getSQLStatements().addElement(deleteStatement);
                continue;
            }
            this.setSQLStatement(deleteStatement);
        }
        super.prepareDeleteObject();
    }

    public void prepareDoesExist(DatabaseField field) {
        this.setSQLStatement(this.buildSelectStatementForDoesExist(field));
        super.prepareDoesExist(field);
    }

    public void prepareInsertObject() {
        if (this.getModifyRow() == null) {
            return;
        }
        Enumeration tablesEnum = this.getDescriptor().getMultipleTableInsertOrder().elements();
        while (tablesEnum.hasMoreElements()) {
            DatabaseTable table = (DatabaseTable)tablesEnum.nextElement();
            SQLInsertStatement insertStatement = this.buildInsertStatement(table);
            if (this.getDescriptor().getTables().size() > 1) {
                this.getSQLStatements().addElement(insertStatement);
                continue;
            }
            this.setSQLStatement(insertStatement);
        }
        super.prepareInsertObject();
    }

    public void prepareReportQuerySelectAllRows() {
        SQLSelectStatement statement = this.buildReportQuerySelectStatement(false);
        this.setSQLStatement(statement);
        this.setCallFromStatement();
        this.setSQLStatement(null);
        this.getCall().returnManyRows();
        this.prepareCall();
    }

    public void prepareReportQuerySubSelect() {
        this.setSQLStatement(this.buildReportQuerySelectStatement(true));
        this.setSelectionCriteria(null);
    }

    public void prepareSelectAllRows() {
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead()) {
            if (this.getDescriptor().getInheritancePolicy().hasView()) {
                this.setSQLStatement(this.getDescriptor().getInheritancePolicy().buildViewSelectStatement((ObjectLevelReadQuery)this.getQuery()));
                super.prepareSelectAllRows();
            } else if (!this.getDescriptor().getInheritancePolicy().hasClassExtractor()) {
                this.setSQLStatement(this.getDescriptor().getInheritancePolicy().buildClassIndicatorSelectStatement((ObjectLevelReadQuery)this.getQuery()));
                super.prepareSelectAllRows();
            }
        } else {
            this.setSQLStatement(this.buildNormalSelectStatement());
            super.prepareSelectAllRows();
        }
    }

    public void prepareSelectOneRow() {
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead()) {
            if (this.getDescriptor().getInheritancePolicy().hasView()) {
                this.setSQLStatement(this.getDescriptor().getInheritancePolicy().buildViewSelectStatement((ObjectLevelReadQuery)this.getQuery()));
                super.prepareSelectOneRow();
            } else if (!this.getDescriptor().getInheritancePolicy().hasClassExtractor()) {
                this.setSQLStatement(this.getDescriptor().getInheritancePolicy().buildClassIndicatorSelectStatement((ObjectLevelReadQuery)this.getQuery()));
                super.prepareSelectOneRow();
            }
        } else {
            this.setSQLStatement(this.buildNormalSelectStatement());
            super.prepareSelectOneRow();
        }
    }

    public void prepareUpdateObject() {
        if (this.getModifyRow() == null) {
            return;
        }
        int tablesSize = this.getDescriptor().getTables().size();
        for (int index = 0; index < tablesSize; ++index) {
            DatabaseTable table = (DatabaseTable)this.getDescriptor().getTables().get(index);
            SQLUpdateStatement updateStatement = this.buildUpdateStatement(table);
            if (tablesSize > 1) {
                this.getSQLStatements().addElement(updateStatement);
                continue;
            }
            this.setSQLStatement(updateStatement);
        }
        super.prepareUpdateObject();
    }

    public void prepareUpdateAll() {
        ExpressionBuilder builder = ((UpdateAllQuery)this.getQuery()).getExpressionBuilder();
        HashMap updateClauses = ((UpdateAllQuery)this.getQuery()).getUpdateClauses();
        OptimisticLockingPolicy policy = this.getDescriptor().getOptimisticLockingPolicy();
        if (policy != null && policy.getWriteLockField() != null) {
            Expression writeLock = builder.getField(policy.getWriteLockField());
            Expression writeLockUpdateExpression = policy.getWriteLockUpdateExpression(builder);
            if (writeLockUpdateExpression != null) {
                updateClauses = (HashMap)updateClauses.clone();
                updateClauses.put(writeLock, writeLockUpdateExpression);
            }
        }
        HashMap tables_databaseFieldsToValues = new HashMap();
        HashMap<DatabaseTable, Collection> tablesToPrimaryKeyFields = new HashMap<DatabaseTable, Collection>();
        for (Map.Entry entry : updateClauses.entrySet()) {
            int i;
            NonSynchronizedVector values;
            int fieldsSize;
            Vector fields;
            Object fieldObject = entry.getKey();
            DataExpression fieldExpression = null;
            String attributeName = null;
            if (fieldObject instanceof String) {
                attributeName = (String)fieldObject;
            } else {
                fieldExpression = (DataExpression)fieldObject;
            }
            DatabaseField field = null;
            DatabaseMapping mapping = null;
            if (attributeName != null) {
                mapping = this.getDescriptor().getObjectBuilder().getMappingForAttributeName(attributeName);
                if (mapping != null && !mapping.getFields().isEmpty()) {
                    field = (DatabaseField)mapping.getFields().firstElement();
                }
                if (field == null) {
                    throw QueryException.updateAllQueryAddUpdateDoesNotDefineField(this.getDescriptor(), this.getQuery(), attributeName);
                }
            } else if (fieldExpression != null) {
                field = this.getDescriptor().getObjectBuilder().getFieldForQueryKeyName(fieldExpression.getName());
                if (field == null) {
                    DataExpression fieldExpressionClone = (DataExpression)fieldExpression.clone();
                    fieldExpressionClone.getBuilder().setQueryClass(this.getQuery().getReferenceClass());
                    fieldExpressionClone.getBuilder().setSession(this.getSession());
                    field = fieldExpressionClone.getField();
                    if (field == null) {
                        throw QueryException.updateAllQueryAddUpdateDoesNotDefineField(this.getDescriptor(), this.getQuery(), fieldExpression.toString());
                    }
                }
                mapping = this.getDescriptor().getObjectBuilder().getMappingForField(field);
            }
            Object valueObject = entry.getValue();
            if (mapping != null && mapping.isOneToOneMapping()) {
                fields = mapping.getFields();
                fieldsSize = fields.size();
                values = NonSynchronizedVector.newInstance(fieldsSize);
                for (i = 0; i < fieldsSize; ++i) {
                    if (valueObject == null) {
                        ((Vector)values).add(null);
                        continue;
                    }
                    DatabaseField targetField = (DatabaseField)((OneToOneMapping)mapping).getSourceToTargetKeyFields().get(fields.elementAt(i));
                    if (valueObject instanceof Expression) {
                        ((Vector)values).add(((Expression)((Expression)valueObject).clone()).getField(targetField));
                        continue;
                    }
                    ((Vector)values).add(((OneToOneMapping)mapping).getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(valueObject, targetField, this.getSession()));
                }
            } else {
                fields = NonSynchronizedVector.newInstance(1);
                fields.add(field);
                values = NonSynchronizedVector.newInstance(1);
                ((Vector)values).add(valueObject);
            }
            fieldsSize = fields.size();
            for (i = 0; i < fieldsSize; ++i) {
                field = (DatabaseField)fields.elementAt(i);
                DatabaseTable table = field.getTable();
                if (!this.getDescriptor().getTables().contains(table)) {
                    if (attributeName != null) {
                        throw QueryException.updateAllQueryAddUpdateDefinesWrongField(this.getDescriptor(), this.getQuery(), attributeName, field.getQualifiedName());
                    }
                    throw QueryException.updateAllQueryAddUpdateDefinesWrongField(this.getDescriptor(), this.getQuery(), fieldExpression.toString(), field.getQualifiedName());
                }
                HashMap<DatabaseField, Expression> databaseFieldsToValues = (HashMap<DatabaseField, Expression>)tables_databaseFieldsToValues.get(table);
                if (databaseFieldsToValues == null) {
                    databaseFieldsToValues = new HashMap<DatabaseField, Expression>();
                    tables_databaseFieldsToValues.put(table, databaseFieldsToValues);
                    tablesToPrimaryKeyFields.put(table, this.getPrimaryKeyFieldsForTable(table));
                }
                Object value = ((Vector)values).elementAt(i);
                Expression valueExpression = valueObject instanceof Expression ? (Expression)value : builder.value(value);
                databaseFieldsToValues.put(field, valueExpression);
            }
        }
        SQLCall selectCallForExist = null;
        SQLSelectStatement selectStatementForExist = this.createSQLSelectStatementForModifyAll(this.getSelectionCriteria());
        boolean isMainCase = selectStatementForExist.requiresAliases();
        if (isMainCase && this.getSelectionCriteria() != null) {
            if (this.getSession().getPlatform().shouldAlwaysUseTempStorageForModifyAll()) {
                this.prepareUpdateAllUsingTempStorage(tables_databaseFieldsToValues, tablesToPrimaryKeyFields);
                return;
            }
            selectCallForExist = (SQLCall)selectStatementForExist.buildCall(this.getSession());
        }
        ExpressionIterator expRequiresSelectIterator = new ExpressionIterator(){

            public void iterate(Expression each) {
                if (this.getResult() == null) {
                    return;
                }
                if (each instanceof DataExpression) {
                    DatabaseField field;
                    DataExpression dataExpression = (DataExpression)each;
                    Expression baseExpression = dataExpression.getBaseExpression();
                    if (baseExpression != null && !(baseExpression instanceof ExpressionBuilder)) {
                        DataExpression baseDataExpression;
                        boolean stop = true;
                        if (baseExpression instanceof DataExpression && (baseDataExpression = (DataExpression)baseExpression).getMapping() != null && baseDataExpression.getMapping().isAggregateObjectMapping()) {
                            stop = false;
                        }
                        if (stop) {
                            this.setResult(null);
                            return;
                        }
                    }
                    if ((field = dataExpression.getField()) != null && !field.getTable().equals((DatabaseTable)this.getResult())) {
                        this.setResult(null);
                        return;
                    }
                }
            }

            public boolean shouldIterateOverSubSelects() {
                return true;
            }
        };
        HashMap tables_databaseFieldsToValuesCopy = new HashMap();
        for (Map.Entry entry : tables_databaseFieldsToValues.entrySet()) {
            DatabaseTable table = (DatabaseTable)entry.getKey();
            HashMap databaseFieldsToValues = (HashMap)entry.getValue();
            HashMap<DatabaseField, Cloneable> databaseFieldsToValuesCopy = new HashMap<DatabaseField, Cloneable>();
            tables_databaseFieldsToValuesCopy.put(table, databaseFieldsToValuesCopy);
            for (Map.Entry entry2 : databaseFieldsToValues.entrySet()) {
                DatabaseField field = (DatabaseField)entry2.getKey();
                Expression value = (Expression)entry2.getValue();
                expRequiresSelectIterator.setResult(table);
                Expression valueClone = (Expression)value.clone();
                valueClone.getBuilder().setSession(this.getSession());
                valueClone.getBuilder().setQueryClass(this.getQuery().getReferenceClass());
                expRequiresSelectIterator.iterateOn(valueClone);
                if (expRequiresSelectIterator.getResult() == null) {
                    if (this.getSession().getPlatform().shouldAlwaysUseTempStorageForModifyAll()) {
                        this.prepareUpdateAllUsingTempStorage(tables_databaseFieldsToValues, tablesToPrimaryKeyFields);
                        return;
                    }
                    SQLSelectStatement selStatement = this.createSQLSelectStatementForAssignedExpressionForUpdateAll(value);
                    databaseFieldsToValuesCopy.put(field, selStatement);
                    continue;
                }
                databaseFieldsToValuesCopy.put(field, valueClone);
            }
        }
        HashMap tables_databaseFieldsToValuesOriginal = tables_databaseFieldsToValues;
        tables_databaseFieldsToValues = tables_databaseFieldsToValuesCopy;
        if (tables_databaseFieldsToValues.size() == 1) {
            Map.Entry entry = tables_databaseFieldsToValues.entrySet().iterator().next();
            DatabaseTable table = (DatabaseTable)entry.getKey();
            HashMap databaseFieldsToValues = (HashMap)entry.getValue();
            Collection primaryKeyFields = (Collection)tablesToPrimaryKeyFields.values().iterator().next();
            this.setSQLStatement(this.buildUpdateAllStatement(table, databaseFieldsToValues, selectCallForExist, selectStatementForExist, primaryKeyFields));
        } else {
            ExpressionIterator expIterator = new ExpressionIterator(){

                public void iterate(Expression each) {
                    DataExpression dataExpression;
                    DatabaseField field;
                    if (each instanceof DataExpression && (field = (dataExpression = (DataExpression)each).getField()) != null) {
                        ((Collection)this.getResult()).add(field);
                    }
                }

                public boolean shouldIterateOverSubSelects() {
                    return true;
                }
            };
            HashSet selectCallForExistFields = new HashSet();
            if (selectCallForExist != null) {
                expIterator.setResult(selectCallForExistFields);
                expIterator.iterateOn(selectStatementForExist.getWhereClause());
            }
            HashMap tablesToLeftFields = new HashMap();
            HashMap<DatabaseTable, HashSet> tablesToRightFields = new HashMap<DatabaseTable, HashSet>();
            NonSynchronizedVector beforeTables = NonSynchronizedVector.newInstance();
            NonSynchronizedVector afterTables = NonSynchronizedVector.newInstance();
            HashMap<DatabaseTable, DatabaseTable> simpleConflicts = new HashMap<DatabaseTable, DatabaseTable>();
            for (Map.Entry entry : tables_databaseFieldsToValues.entrySet()) {
                DatabaseTable table = (DatabaseTable)entry.getKey();
                HashMap databaseFieldsToValues = (HashMap)entry.getValue();
                HashSet<DatabaseField> leftFields = new HashSet<DatabaseField>(databaseFieldsToValues.size());
                HashSet rightFields = (HashSet)selectCallForExistFields.clone();
                expIterator.setResult(rightFields);
                for (Map.Entry databaseFieldValueEntry : databaseFieldsToValues.entrySet()) {
                    DatabaseField field = (DatabaseField)databaseFieldValueEntry.getKey();
                    leftFields.add(field);
                    Object value = databaseFieldValueEntry.getValue();
                    if (value instanceof Expression) {
                        Expression valueExpression = (Expression)value;
                        expIterator.iterateOn(valueExpression);
                        continue;
                    }
                    SQLSelectStatement selStatement = (SQLSelectStatement)value;
                    expIterator.iterateOn((Expression)selStatement.getFields().elementAt(0));
                    expIterator.iterateOn(selStatement.getWhereClause());
                }
                for (DatabaseTable processedTable : tablesToLeftFields.keySet()) {
                    HashSet processedTableLeftFields = (HashSet)tablesToLeftFields.get(processedTable);
                    HashSet processedTableRightFields = (HashSet)tablesToRightFields.get(processedTable);
                    boolean tableBeforeProcessedTable = false;
                    Iterator itProcessedTableLeftField = processedTableLeftFields.iterator();
                    while (itProcessedTableLeftField.hasNext()) {
                        if (!rightFields.contains(itProcessedTableLeftField.next())) continue;
                        tableBeforeProcessedTable = true;
                        break;
                    }
                    boolean processedTableBeforeTable = false;
                    Iterator itLeftField = leftFields.iterator();
                    while (itLeftField.hasNext()) {
                        if (!processedTableRightFields.contains(itLeftField.next())) continue;
                        processedTableBeforeTable = true;
                        break;
                    }
                    if (tableBeforeProcessedTable && !processedTableBeforeTable) {
                        ((Vector)beforeTables).add(table);
                        ((Vector)afterTables).add(processedTable);
                        continue;
                    }
                    if (!tableBeforeProcessedTable && processedTableBeforeTable) {
                        ((Vector)beforeTables).add(processedTable);
                        ((Vector)afterTables).add(table);
                        continue;
                    }
                    if (!tableBeforeProcessedTable || !processedTableBeforeTable) continue;
                    simpleConflicts.put(processedTable, table);
                }
                tablesToLeftFields.put(table, leftFields);
                tablesToRightFields.put(table, rightFields);
            }
            if (!simpleConflicts.isEmpty()) {
                this.prepareUpdateAllUsingTempStorage(tables_databaseFieldsToValuesOriginal, tablesToPrimaryKeyFields);
                return;
            }
            NonSynchronizedVector orderedTables = NonSynchronizedVector.newInstance(tables_databaseFieldsToValues.size());
            while (!((Vector)beforeTables).isEmpty()) {
                int i;
                DatabaseTable firstTable = null;
                for (i = 0; i < ((Vector)beforeTables).size(); ++i) {
                    DatabaseTable beforeTable = (DatabaseTable)((Vector)beforeTables).elementAt(i);
                    if (afterTables.contains(beforeTable)) continue;
                    firstTable = beforeTable;
                    break;
                }
                if (firstTable == null) {
                    this.prepareUpdateAllUsingTempStorage(tables_databaseFieldsToValuesOriginal, tablesToPrimaryKeyFields);
                    return;
                }
                for (i = ((Vector)beforeTables).size() - 1; i >= 0; --i) {
                    if (!((Vector)beforeTables).elementAt(i).equals(firstTable)) continue;
                    ((Vector)beforeTables).remove(i);
                    ((Vector)afterTables).remove(i);
                }
                ((Vector)orderedTables).addElement(firstTable);
            }
            for (DatabaseTable table : tables_databaseFieldsToValues.keySet()) {
                if (orderedTables.contains(table)) continue;
                ((Vector)orderedTables).add(table);
            }
            for (int i = 0; i < ((Vector)orderedTables).size(); ++i) {
                DatabaseTable table = (DatabaseTable)((Vector)orderedTables).elementAt(i);
                HashMap databaseFieldsToValues = (HashMap)tables_databaseFieldsToValues.get(table);
                Collection primaryKeyFields = (Collection)tablesToPrimaryKeyFields.get(table);
                this.getSQLStatements().addElement(this.buildUpdateAllStatement(table, databaseFieldsToValues, selectCallForExist, selectStatementForExist, primaryKeyFields));
            }
        }
        ((UpdateAllQuery)this.getQuery()).setIsPreparedUsingTempStorage(false);
        super.prepareUpdateAll();
    }

    protected SQLSelectStatement createSQLSelectStatementForUpdateAllForOracleAnonymousBlock(HashMap tables_databaseFieldsToValues) {
        ExpressionBuilder builder = ((UpdateAllQuery)this.getQuery()).getExpressionBuilder();
        Expression whereClause = this.getSelectionCriteria();
        if (whereClause != null) {
            whereClause = (Expression)whereClause.clone();
        }
        ReportQuery reportQuery = new ReportQuery(this.getDescriptor().getJavaClass(), builder);
        reportQuery.setDescriptor(this.getDescriptor());
        reportQuery.setSelectionCriteria(whereClause);
        reportQuery.setSession(this.getSession());
        reportQuery.setShouldRetrievePrimaryKeys(true);
        for (HashMap databaseFieldsToValues : tables_databaseFieldsToValues.values()) {
            Iterator itValues = databaseFieldsToValues.values().iterator();
            while (itValues.hasNext()) {
                reportQuery.addAttribute("", (Expression)itValues.next());
            }
        }
        return ((ExpressionQueryMechanism)reportQuery.getQueryMechanism()).buildReportQuerySelectStatement(false);
    }

    protected SQLSelectStatement createSQLSelectStatementForModifyAllForTempTable(HashMap databaseFieldsToValues) {
        ExpressionBuilder builder = ((ModifyAllQuery)this.getQuery()).getExpressionBuilder();
        Expression whereClause = this.getSelectionCriteria();
        if (whereClause != null) {
            whereClause = (Expression)whereClause.clone();
        }
        ReportQuery reportQuery = new ReportQuery(this.getDescriptor().getJavaClass(), builder);
        reportQuery.setDescriptor(this.getDescriptor());
        reportQuery.setSelectionCriteria(whereClause);
        reportQuery.setSession(this.getSession());
        reportQuery.setShouldRetrievePrimaryKeys(true);
        if (databaseFieldsToValues != null) {
            Iterator itValues = databaseFieldsToValues.values().iterator();
            while (itValues.hasNext()) {
                reportQuery.addAttribute("", (Expression)itValues.next());
            }
        }
        return ((ExpressionQueryMechanism)reportQuery.getQueryMechanism()).buildReportQuerySelectStatement(false);
    }

    protected SQLModifyStatement buildUpdateAllStatementForOracleAnonymousBlock(HashMap tables_databaseFieldsToValues, HashMap tablesToPrimaryKeyFields) {
        SQLSelectStatement selectStatement = this.createSQLSelectStatementForUpdateAllForOracleAnonymousBlock(tables_databaseFieldsToValues);
        SQLCall selectCall = (SQLCall)selectStatement.buildCall(this.getSession());
        SQLUpdateAllStatementForOracleAnonymousBlock updateAllStatement = new SQLUpdateAllStatementForOracleAnonymousBlock();
        updateAllStatement.setTranslationRow(this.getTranslationRow());
        updateAllStatement.setSelectCall(selectCall);
        updateAllStatement.setTables_databaseFieldsToValues(tables_databaseFieldsToValues);
        updateAllStatement.setTablesToPrimaryKeyFields(tablesToPrimaryKeyFields);
        updateAllStatement.setTable((DatabaseTable)this.getDescriptor().getTables().firstElement());
        return updateAllStatement;
    }

    protected void prepareUpdateAllUsingTempStorage(HashMap tables_databaseFieldsToValues, HashMap tablesToPrimaryKeyFields) {
        if (this.getSession().getPlatform().supportsTempTables()) {
            this.prepareUpdateAllUsingTempTables(tables_databaseFieldsToValues, tablesToPrimaryKeyFields);
        } else if (this.getSession().getPlatform().isOracle()) {
            this.prepareUpdateAllUsingOracleAnonymousBlock(tables_databaseFieldsToValues, tablesToPrimaryKeyFields);
        } else {
            throw QueryException.tempTablesNotSupported(this.getQuery(), Helper.getShortClassName(this.getSession().getPlatform()));
        }
    }

    protected void prepareUpdateAllUsingOracleAnonymousBlock(HashMap tables_databaseFieldsToValues, HashMap tablesToPrimaryKeyFields) {
        this.setSQLStatement(this.buildUpdateAllStatementForOracleAnonymousBlock(tables_databaseFieldsToValues, tablesToPrimaryKeyFields));
        ((UpdateAllQuery)this.getQuery()).setIsPreparedUsingTempStorage(true);
        super.prepareUpdateAll();
    }

    protected void prepareUpdateAllUsingTempTables(HashMap tables_databaseFieldsToValues, HashMap tablesToPrimaryKeyFields) {
        int nTables = tables_databaseFieldsToValues.size();
        NonSynchronizedVector createTableStatements = NonSynchronizedVector.newInstance(nTables);
        NonSynchronizedVector selectStatements = NonSynchronizedVector.newInstance(nTables);
        NonSynchronizedVector updateStatements = NonSynchronizedVector.newInstance(nTables);
        NonSynchronizedVector cleanupStatements = NonSynchronizedVector.newInstance(nTables);
        for (Map.Entry entry : tables_databaseFieldsToValues.entrySet()) {
            DatabaseTable table = (DatabaseTable)entry.getKey();
            HashMap databaseFieldsToValues = (HashMap)entry.getValue();
            Collection primaryKeyFields = (Collection)tablesToPrimaryKeyFields.get(table);
            Vector statementsForTable = this.buildStatementsForUpdateAllForTempTables(table, databaseFieldsToValues, primaryKeyFields);
            ((Vector)createTableStatements).add(statementsForTable.elementAt(0));
            ((Vector)selectStatements).add(statementsForTable.elementAt(1));
            ((Vector)updateStatements).add(statementsForTable.elementAt(2));
            ((Vector)cleanupStatements).add(statementsForTable.elementAt(3));
        }
        this.getSQLStatements().addAll(createTableStatements);
        this.getSQLStatements().addAll(selectStatements);
        this.getSQLStatements().addAll(updateStatements);
        this.getSQLStatements().addAll(cleanupStatements);
        if (this.getSession().getPlatform().dontBindUpdateAllQueryUsingTempTables() && (this.getQuery().shouldBindAllParameters() || this.getQuery().shouldIgnoreBindAllParameters() && this.getSession().getPlatform().shouldBindAllParameters())) {
            this.getQuery().setShouldBindAllParameters(false);
            this.getSession().warning("update_all_query_cannot_use_binding_on_this_platform", "query");
        }
        ((UpdateAllQuery)this.getQuery()).setIsPreparedUsingTempStorage(true);
        super.prepareUpdateAll();
    }

    protected Vector buildStatementsForDeleteAllForTempTables() {
        NonSynchronizedVector statements = NonSynchronizedVector.newInstance();
        DatabaseTable rootTable = (DatabaseTable)this.getDescriptor().getMultipleTableInsertOrder().firstElement();
        Collection rootTablePrimaryKeyFields = this.getPrimaryKeyFieldsForTable(rootTable);
        ClassDescriptor rootDescriptor = this.getDescriptor();
        if (this.getDescriptor().hasInheritance()) {
            rootDescriptor = rootDescriptor.getInheritancePolicy().getRootParentDescriptor();
        }
        NonSynchronizedVector allFields = NonSynchronizedVector.newInstance();
        for (DatabaseField field : rootDescriptor.getFields()) {
            if (!rootTable.equals(field.getTable())) continue;
            ((Vector)allFields).add(field);
        }
        SQLDeleteAllStatementForTempTable cleanupStatement = new SQLDeleteAllStatementForTempTable();
        cleanupStatement.setMode(3);
        cleanupStatement.setTable(rootTable);
        ((Vector)statements).addElement(cleanupStatement);
        for (DatabaseTable table : this.getDescriptor().getMultipleTableInsertOrder()) {
            SQLDeleteAllStatementForTempTable deleteStatement = new SQLDeleteAllStatementForTempTable();
            deleteStatement.setMode(2);
            deleteStatement.setTable(rootTable);
            deleteStatement.setPrimaryKeyFields(rootTablePrimaryKeyFields);
            deleteStatement.setTargetTable(table);
            deleteStatement.setTargetPrimaryKeyFields(this.getPrimaryKeyFieldsForTable(table));
            ((Vector)statements).addElement(deleteStatement);
        }
        SQLSelectStatement selectStatement = this.createSQLSelectStatementForModifyAllForTempTable(null);
        SQLCall selectCall = (SQLCall)selectStatement.buildCall(this.getSession());
        SQLDeleteAllStatementForTempTable insertStatement = new SQLDeleteAllStatementForTempTable();
        insertStatement.setMode(1);
        insertStatement.setTable(rootTable);
        insertStatement.setTranslationRow(this.getTranslationRow());
        insertStatement.setSelectCall(selectCall);
        insertStatement.setPrimaryKeyFields(rootTablePrimaryKeyFields);
        ((Vector)statements).addElement(insertStatement);
        SQLDeleteAllStatementForTempTable createTempTableStatement = new SQLDeleteAllStatementForTempTable();
        createTempTableStatement.setMode(0);
        createTempTableStatement.setTable(rootTable);
        createTempTableStatement.setAllFields(allFields);
        createTempTableStatement.setPrimaryKeyFields(rootTablePrimaryKeyFields);
        ((Vector)statements).addElement(createTempTableStatement);
        return statements;
    }

    protected Vector buildStatementsForUpdateAllForTempTables(DatabaseTable table, HashMap databaseFieldsToValues, Collection primaryKeyFields) {
        NonSynchronizedVector statements = NonSynchronizedVector.newInstance(4);
        NonSynchronizedVector allFields = NonSynchronizedVector.newInstance();
        for (DatabaseField field : this.getDescriptor().getFields()) {
            if (!table.equals(field.getTable())) continue;
            ((Vector)allFields).add(field);
        }
        SQLUpdateAllStatementForTempTable createTempTableStatement = new SQLUpdateAllStatementForTempTable();
        createTempTableStatement.setMode(0);
        createTempTableStatement.setTable(table);
        createTempTableStatement.setAllFields(allFields);
        createTempTableStatement.setAssignedFields(databaseFieldsToValues.keySet());
        createTempTableStatement.setPrimaryKeyFields(primaryKeyFields);
        ((Vector)statements).addElement(createTempTableStatement);
        SQLSelectStatement selectStatement = this.createSQLSelectStatementForModifyAllForTempTable(databaseFieldsToValues);
        SQLCall selectCall = (SQLCall)selectStatement.buildCall(this.getSession());
        SQLUpdateAllStatementForTempTable insertStatement = new SQLUpdateAllStatementForTempTable();
        insertStatement.setMode(1);
        insertStatement.setTable(table);
        insertStatement.setTranslationRow(this.getTranslationRow());
        insertStatement.setSelectCall(selectCall);
        insertStatement.setAssignedFields(databaseFieldsToValues.keySet());
        insertStatement.setPrimaryKeyFields(primaryKeyFields);
        ((Vector)statements).addElement(insertStatement);
        SQLUpdateAllStatementForTempTable updateStatement = new SQLUpdateAllStatementForTempTable();
        updateStatement.setMode(2);
        updateStatement.setTable(table);
        updateStatement.setTranslationRow(this.getTranslationRow());
        updateStatement.setAssignedFields(databaseFieldsToValues.keySet());
        updateStatement.setPrimaryKeyFields(primaryKeyFields);
        ((Vector)statements).addElement(updateStatement);
        SQLUpdateAllStatementForTempTable cleanupStatement = new SQLUpdateAllStatementForTempTable();
        cleanupStatement.setMode(3);
        cleanupStatement.setTable(table);
        ((Vector)statements).addElement(cleanupStatement);
        return statements;
    }

    protected Collection getPrimaryKeyFieldsForTable(DatabaseTable table) {
        Collection<Object> primaryKeyFields = table.equals(this.getDescriptor().getTables().firstElement()) ? this.getDescriptor().getPrimaryKeyFields() : ((Map)this.getDescriptor().getAdditionalTablePrimaryKeyFields().get(table)).values();
        return primaryKeyFields;
    }

    public Vector selectAllReportQueryRows() throws DatabaseException {
        return this.selectAllRowsFromTable();
    }

    public Vector selectAllRows() throws DatabaseException {
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead() && !this.getDescriptor().getInheritancePolicy().hasView()) {
            return this.getDescriptor().getInheritancePolicy().selectAllRowUsingMultipleTableSubclassRead((ReadAllQuery)this.getQuery());
        }
        return this.selectAllRowsFromTable();
    }

    public Vector selectAllRowsFromConcreteTable() throws DatabaseException {
        this.setSQLStatement(this.buildConcreteSelectStatement());
        super.prepareSelectAllRows();
        return super.selectAllRows();
    }

    public Vector selectAllRowsFromTable() throws DatabaseException {
        return super.selectAllRows();
    }

    public AbstractRecord selectOneRow() throws DatabaseException {
        if (this.getDescriptor().hasInheritance() && this.getDescriptor().getInheritancePolicy().requiresMultipleTableSubclassRead() && !this.getDescriptor().getInheritancePolicy().hasView()) {
            return this.getDescriptor().getInheritancePolicy().selectOneRowUsingMultipleTableSubclassRead((ReadObjectQuery)this.getQuery());
        }
        return this.selectOneRowFromTable();
    }

    public AbstractRecord selectOneRowFromConcreteTable() throws DatabaseException {
        this.setSQLStatement(this.buildConcreteSelectStatement());
        super.prepareSelectOneRow();
        return super.selectOneRow();
    }

    public AbstractRecord selectOneRowFromTable() throws DatabaseException {
        return super.selectOneRow();
    }

    public void setSelectionCriteria(Expression expression) {
        this.selectionCriteria = expression;
    }
}

