/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.exceptions.EJBQLException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.expressions.ExpressionBuilder;
import oracle.toplink.essentials.internal.expressions.ConstantExpression;
import oracle.toplink.essentials.internal.parsing.AttributeNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.LogicalOperatorNode;
import oracle.toplink.essentials.internal.parsing.Node;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.TypeHelper;
import oracle.toplink.essentials.internal.parsing.VariableNode;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.DirectToFieldMapping;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReportQuery;

public class DotNode
extends LogicalOperatorNode {
    private Object enumConstant;

    public void applyToQuery(ObjectLevelReadQuery theQuery, GenerationContext context) {
        if (theQuery.isReportQuery()) {
            ReportQuery reportQuery = (ReportQuery)theQuery;
            reportQuery.addAttribute(this.resolveAttribute(), this.generateExpression(context));
            reportQuery.dontRetrievePrimaryKeys();
        }
    }

    public void validate(ParseTreeContext context) {
        Node leftMost = this.getLeftMostNode();
        if (this.isDeclaredVariable(leftMost, context)) {
            this.left.validate(context);
            TypeHelper typeHelper = context.getTypeHelper();
            Object attributeType = typeHelper.resolveAttribute(this.left.getType(), ((AttributeNode)this.right).getAttributeName());
            this.setType(attributeType);
            this.right.setType(attributeType);
        } else {
            String typeName = this.left.getAsString();
            String name = ((AttributeNode)this.right).getAttributeName();
            TypeHelper helper = context.getTypeHelper();
            Object type = this.resolveEnumTypeName(typeName, helper);
            if (type != null && helper.isEnumType(type)) {
                this.enumConstant = helper.resolveEnumConstant(type, name);
                if (this.enumConstant == null) {
                    throw EJBQLException.invalidEnumLiteral(typeName, name);
                }
            }
        }
    }

    private boolean isDeclaredVariable(Node node, ParseTreeContext context) {
        if (node.isVariableNode()) {
            String name = ((VariableNode)node).getCanonicalVariableName();
            return context.isVariable(name);
        }
        return false;
    }

    public Expression generateExpression(GenerationContext context) {
        Node left = this.getLeft();
        Node right = this.getRight();
        if (this.enumConstant != null) {
            return new ConstantExpression(this.enumConstant, new ExpressionBuilder());
        }
        Expression whereClause = this.getLeft().generateExpression(context);
        if (right.isAttributeNode()) {
            ((AttributeNode)right).setMapping(this.resolveMapping(context));
        }
        whereClause = right.addToExpression(whereClause, context);
        return whereClause;
    }

    public boolean isDotNode() {
        return true;
    }

    public boolean endsWithDirectToField(GenerationContext context) {
        DatabaseMapping mapping = this.resolveMapping(context);
        return mapping != null && mapping.isDirectToFieldMapping();
    }

    public Class getTypeOfDirectToField(GenerationContext context) {
        DatabaseMapping mapping = this.resolveMapping(context);
        if (mapping != null && mapping.isDirectToFieldMapping()) {
            return ((DirectToFieldMapping)mapping).getAttributeClassification();
        }
        return null;
    }

    public boolean endsWithCollectionField(GenerationContext context) {
        DatabaseMapping mapping = this.resolveMapping(context);
        return mapping != null && mapping.isCollectionMapping();
    }

    public String resolveAttribute() {
        return ((AttributeNode)this.getRight()).getAttributeName();
    }

    public DatabaseMapping resolveMapping(GenerationContext context) {
        Class leftClass = this.getLeft().resolveClass(context);
        return this.getRight().resolveMapping(context, leftClass);
    }

    public Class resolveClass(GenerationContext context) {
        Class leftClass = this.getLeft().resolveClass(context);
        return this.getRight().resolveClass(context, leftClass);
    }

    public String getAsString() {
        return this.left.getAsString() + "." + this.right.getAsString();
    }

    private Node getLeftMostNode() {
        return this.left.isDotNode() ? ((DotNode)this.left).getLeftMostNode() : this.left;
    }

    private Object resolveEnumTypeName(String name, TypeHelper helper) {
        int index;
        Object type = helper.resolveTypeName(name);
        if (type == null && (index = name.lastIndexOf(46)) != -1) {
            name = name.substring(0, index) + '$' + name.substring(index + 1);
            type = helper.resolveTypeName(name);
        }
        return type;
    }
}

