/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.xml;

import java.lang.reflect.Method;
import java.util.HashMap;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataEntityListener;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;

public class XMLListener
extends MetadataEntityListener {
    protected String entityClassName;
    protected String listenerClassName;
    protected HashMap callbackMethodNames;

    protected XMLListener(String listenerClassName, String entityClassName) {
        this.listenerClassName = listenerClassName;
        this.entityClassName = entityClassName;
    }

    public void addEventMethodName(String event, String methodName) {
        this.getEventMethodNames().put(event, methodName);
    }

    protected Method[] getCandidateMethods() {
        return MetadataHelper.getCandidateCallbackMethodsForEntityListener(this);
    }

    public HashMap getEventMethodNames() {
        if (this.callbackMethodNames == null) {
            this.callbackMethodNames = new HashMap();
        }
        return this.callbackMethodNames;
    }

    public void initializeCallbackMethods(ClassLoader classLoader) {
        this.setEntityClass(MetadataHelper.getClassForName(this.entityClassName, classLoader));
        Class listenerClass = MetadataHelper.getClassForName(this.listenerClassName, classLoader);
        try {
            this.setListener(listenerClass.newInstance());
        }
        catch (Exception ex) {
            ValidationException.errorInstantiatingEntityListener(listenerClass, ex);
        }
        this.setMethodsOnListener();
    }

    protected void setMethodsOnListener() {
        Method[] methods = this.getCandidateMethods();
        for (String event : this.getEventMethodNames().keySet()) {
            String methodName = (String)this.getEventMethodNames().get(event);
            Method method = MetadataHelper.getMethodForName(methods, methodName);
            if (method == null) {
                throw ValidationException.invalidCallbackMethod(this.getListenerClass(), methodName);
            }
            if (event.equals("pre-persist")) {
                super.setPrePersistMethod(method);
                continue;
            }
            if (event.equals("post-persist")) {
                super.setPostInsertMethod(method);
                continue;
            }
            if (event.equals("pre-remove")) {
                super.setPreRemoveMethod(method);
                continue;
            }
            if (event.equals("post-remove")) {
                super.setPostDeleteMethod(method);
                continue;
            }
            if (event.equals("pre-update")) {
                super.setPreUpdateWithChangesMethod(method);
                continue;
            }
            if (event.equals("post-update")) {
                super.setPostUpdateMethod(method);
                continue;
            }
            if (!event.equals("post-load")) continue;
            super.setPostBuildMethod(method);
            super.setPostCloneMethod(method);
            super.setPostRefreshMethod(method);
        }
    }
}

