/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.transaction.base;

import javax.persistence.TransactionRequiredException;
import oracle.toplink.essentials.exceptions.TransactionException;
import oracle.toplink.essentials.internal.ejb.cmp3.base.EntityManagerImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.base.RepeatableWriteUnitOfWork;
import oracle.toplink.essentials.internal.ejb.cmp3.transaction.base.EntityTransactionImpl;
import oracle.toplink.essentials.internal.ejb.cmp3.transaction.base.TransactionWrapperImpl;
import oracle.toplink.essentials.internal.localization.ExceptionLocalization;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;

public class EntityTransactionWrapper
extends TransactionWrapperImpl {
    protected EntityTransactionImpl entityTransaction;

    public EntityTransactionWrapper(EntityManagerImpl entityManager) {
        super(entityManager);
    }

    public Object checkForTransaction(boolean validateExistence) {
        if (this.entityTransaction != null && this.entityTransaction.isActive()) {
            return this.entityTransaction;
        }
        if (validateExistence) {
            this.throwCheckTransactionFailedException();
        }
        return null;
    }

    public RepeatableWriteUnitOfWork getTransactionalUnitOfWork(Object transaction) {
        if (transaction == null) {
            return null;
        }
        if (this.localUOW == null) {
            this.localUOW = new RepeatableWriteUnitOfWork(this.entityManager.getServerSession().acquireClientSession());
        }
        return this.localUOW;
    }

    public EntityManagerImpl getEntityManager() {
        return this.entityManager;
    }

    public void registerUnitOfWorkWithTxn(UnitOfWorkImpl uow) {
        throw new TransactionRequiredException(ExceptionLocalization.buildMessage("join_trans_called_on_entity_trans"));
    }

    public boolean shouldClose() {
        return this.entityTransaction == null || !this.entityTransaction.isActive();
    }

    protected void throwCheckTransactionFailedException() {
        throw TransactionException.transactionNotActive();
    }

    public void markLastTransaction() {
        if (this.entityTransaction != null) {
            this.entityTransaction.markLastTransaction();
        }
    }

    public boolean hasLastTransactionCompleted() {
        return this.entityTransaction != null && this.entityTransaction.hasLastTransactionCompleted();
    }
}

