/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.transaction.base;

import javax.persistence.RollbackException;
import oracle.toplink.essentials.exceptions.TransactionException;
import oracle.toplink.essentials.internal.ejb.cmp3.base.RepeatableWriteUnitOfWork;
import oracle.toplink.essentials.internal.ejb.cmp3.transaction.base.EntityTransactionWrapper;
import oracle.toplink.essentials.internal.localization.ExceptionLocalization;

public class EntityTransactionImpl {
    protected EntityTransactionWrapper wrapper;
    protected boolean active = false;
    protected Boolean hasLastTransactionCompleted;
    protected boolean rollbackOnly = false;

    public EntityTransactionImpl(EntityTransactionWrapper wrapper) {
        this.wrapper = wrapper;
    }

    public void begin() {
        if (this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionIsActive().getMessage());
        }
        if (this.wrapper.getEntityManager().isExtended()) {
            this.wrapper.localUOW = this.wrapper.getEntityManager().getActivePersistenceContext(null);
            this.wrapper.localUOW.setShouldTerminateTransaction(false);
        } else {
            this.wrapper.localUOW = new RepeatableWriteUnitOfWork(this.wrapper.getEntityManager().getServerSession().acquireClientSession());
            this.wrapper.localUOW.setShouldTerminateTransaction(false);
        }
        this.active = true;
    }

    public void commit() {
        if (!this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionNotActive().getMessage());
        }
        try {
            this.transactionCompleted();
            if (this.wrapper.localUOW != null) {
                this.wrapper.localUOW.setShouldTerminateTransaction(true);
                if (!this.rollbackOnly) {
                    if (this.wrapper.localUOW.shouldResumeUnitOfWorkOnTransactionCompletion()) {
                        this.wrapper.localUOW.commitAndResume();
                        return;
                    }
                    this.wrapper.localUOW.commit();
                }
                this.wrapper.getLocalUnitOfWork().release();
                this.wrapper.getLocalUnitOfWork().getParent().release();
                if (this.rollbackOnly) {
                    this.wrapper.getEntityManager().clear();
                    throw new RollbackException(ExceptionLocalization.buildMessage("rollback_because_of_rollback_only"));
                }
            }
        }
        catch (RuntimeException ex) {
            if (this.wrapper.localUOW != null) {
                this.wrapper.getEntityManager().clear();
                this.wrapper.localUOW.release();
                this.wrapper.localUOW.getParent().release();
            }
            throw new RollbackException(ex);
        }
        finally {
            this.active = false;
            this.rollbackOnly = false;
            this.wrapper.setLocalUnitOfWork(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        if (!this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionNotActive().getMessage());
        }
        try {
            this.transactionCompleted();
            if (this.wrapper.getLocalUnitOfWork() != null) {
                this.wrapper.localUOW.setShouldTerminateTransaction(true);
                this.wrapper.localUOW.release();
                this.wrapper.localUOW.getParent().release();
            }
        }
        finally {
            this.active = false;
            this.rollbackOnly = false;
            this.wrapper.getEntityManager().clear();
            this.wrapper.setLocalUnitOfWork(null);
        }
    }

    public void setRollbackOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionNotActive().getMessage());
        }
        this.rollbackOnly = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.isActive()) {
                this.rollback();
            }
        }
        finally {
            super.finalize();
        }
    }

    public boolean getRollbackOnly() {
        if (!this.isActive()) {
            throw new IllegalStateException(TransactionException.transactionNotActive().getMessage());
        }
        return this.rollbackOnly;
    }

    public boolean isActive() {
        return this.active;
    }

    public void markLastTransaction() {
        if (this.hasLastTransactionCompleted == null) {
            this.hasLastTransactionCompleted = Boolean.FALSE;
        }
    }

    public boolean hasLastTransactionCompleted() {
        return this.hasLastTransactionCompleted != null && this.hasLastTransactionCompleted != false;
    }

    protected void transactionCompleted() {
        if (this.hasLastTransactionCompleted != null) {
            this.hasLastTransactionCompleted = Boolean.TRUE;
        }
    }
}

