/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataEntityListener;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.security.PrivilegedAccessController;
import oracle.toplink.essentials.mappings.CollectionMapping;
import oracle.toplink.essentials.sessions.Project;

public class MetadataHelper {
    public static final String IS_PROPERTY_METHOD_PREFIX = "is";
    public static final String GET_PROPERTY_METHOD_PREFIX = "get";
    public static final String SET_PROPERTY_METHOD_PREFIX = "set";
    public static final String SET_IS_PROPERTY_METHOD_PREFIX = "setIs";
    private static final int POSITION_AFTER_IS_PREFIX = "is".length();
    private static final int POSITION_AFTER_GET_PREFIX = "get".length();
    protected static HashMap m_fieldClassifications;
    protected static HashMap m_discriminatorTypes;

    public static ClassDescriptor findDescriptor(Project project, Class cls) {
        for (ClassDescriptor descriptor : project.getOrderedDescriptors()) {
            if (!descriptor.getJavaClassName().equals(cls.getName())) continue;
            return descriptor;
        }
        return null;
    }

    public static String getAttributeNameFromMethodName(String methodName) {
        String restOfName;
        String leadingChar;
        if (methodName.startsWith(GET_PROPERTY_METHOD_PREFIX)) {
            leadingChar = methodName.substring(POSITION_AFTER_GET_PREFIX, POSITION_AFTER_GET_PREFIX + 1);
            restOfName = methodName.substring(POSITION_AFTER_GET_PREFIX + 1);
        } else {
            leadingChar = methodName.substring(POSITION_AFTER_IS_PREFIX, POSITION_AFTER_IS_PREFIX + 1);
            restOfName = methodName.substring(POSITION_AFTER_IS_PREFIX + 1);
        }
        return leadingChar.toLowerCase().concat(restOfName);
    }

    public static Method[] getCandidateCallbackMethodsForDefaultListener(MetadataEntityListener listener) {
        return MetadataHelper.getCandidateCallbackMethodsForEntityListener(listener);
    }

    public static Method[] getCandidateCallbackMethodsForEntityClass(Class entityClass) {
        return MetadataHelper.getDeclaredMethods(entityClass);
    }

    public static Method[] getCandidateCallbackMethodsForEntityListener(MetadataEntityListener listener) {
        HashSet<Method> candidateMethods = new HashSet<Method>();
        Class listenerClass = listener.getListenerClass();
        Method[] declaredMethods = MetadataHelper.getDeclaredMethods(listenerClass);
        for (int i = 0; i < declaredMethods.length; ++i) {
            candidateMethods.add(declaredMethods[i]);
        }
        Method[] methods = MetadataHelper.getMethods(listenerClass);
        for (int i = 0; i < methods.length; ++i) {
            if (candidateMethods.contains(methods[i])) continue;
            candidateMethods.add(methods[i]);
        }
        return candidateMethods.toArray(new Method[candidateMethods.size()]);
    }

    public static Method[] getCandidateCallbackMethodsForMappedSuperclass(Class mappedSuperclass, Class entityClass) {
        ArrayList<Method> candidateMethods = new ArrayList<Method>();
        Method[] allMethods = MetadataHelper.getMethods(entityClass);
        Method[] declaredMethods = MetadataHelper.getDeclaredMethods(mappedSuperclass);
        for (int i = 0; i < declaredMethods.length; ++i) {
            Method method = MetadataHelper.getMethodForName(allMethods, declaredMethods[i].getName());
            if (method == null) continue;
            candidateMethods.add(method);
        }
        return candidateMethods.toArray(new Method[candidateMethods.size()]);
    }

    public static Class getClassForAttribute(String attributeName, MetadataDescriptor mdd) {
        Class entityClass = mdd.getJavaClass();
        Field field = null;
        try {
            field = PrivilegedAccessController.getField(entityClass, attributeName, false);
        }
        catch (NoSuchFieldException nsfex) {
            throw ValidationException.unableToDetermineClassForAttribute(attributeName, entityClass.getName(), nsfex);
        }
        return field.getType();
    }

    public static Class getClassForName(String classname, ClassLoader classLoader) {
        try {
            return PrivilegedAccessController.getClassForName(classname, true, classLoader);
        }
        catch (ClassNotFoundException exception) {
            throw ValidationException.unableToLoadClass(classname, exception);
        }
    }

    public static Method[] getDeclaredMethods(Class cls) {
        return PrivilegedAccessController.getDeclaredMethods(cls);
    }

    public static Class getDiscriminatorType(String discriminatorType) {
        if (m_discriminatorTypes == null) {
            m_discriminatorTypes = new HashMap();
            m_discriminatorTypes.put("CHAR", Character.class);
            m_discriminatorTypes.put("STRING", String.class);
            m_discriminatorTypes.put("INTEGER", Integer.class);
        }
        return (Class)m_discriminatorTypes.get(discriminatorType);
    }

    public static Class getFieldClassification(String temporalType) {
        if (m_fieldClassifications == null) {
            m_fieldClassifications = new HashMap();
            m_fieldClassifications.put("DATE", Date.class);
            m_fieldClassifications.put("TIME", Time.class);
            m_fieldClassifications.put("TIMESTAMP", Timestamp.class);
        }
        return (Class)m_fieldClassifications.get(temporalType);
    }

    public static Field getFieldForAttribute(String attributeName, Class javaClass) {
        Field field = null;
        try {
            field = PrivilegedAccessController.getField(javaClass, attributeName, false);
        }
        catch (NoSuchFieldException nsfex) {
            return null;
        }
        return field;
    }

    public static Field[] getFields(Class cls) {
        return PrivilegedAccessController.getDeclaredFields(cls);
    }

    public static String getFullyQualifiedColumnName(String name, String tableName) {
        String columnName = name;
        if (tableName != null && !tableName.equals("") && name.indexOf(46) < 0) {
            columnName = tableName + "." + name;
        }
        return columnName;
    }

    public static String getFullyQualifiedTableName(String tableName, String catalog, String schema) {
        if (!catalog.equals("")) {
            tableName = catalog + "." + tableName;
        }
        if (!schema.equals("")) {
            tableName = schema + "." + tableName;
        }
        return tableName;
    }

    public static String getFullyQualifiedTableName(String name, String defaultName, String catalog, String schema) {
        String tableName = name;
        if (tableName.equals("")) {
            tableName = defaultName;
        }
        return MetadataHelper.getFullyQualifiedTableName(tableName, catalog, schema);
    }

    public static Type getGenericReturnType(Method method) {
        return method.getGenericReturnType();
    }

    public static Type getGenericType(Field field) {
        return field.getGenericType();
    }

    protected static Method getMethod(String methodName, Class cls, Class[] params) {
        try {
            return PrivilegedAccessController.getMethod(cls, methodName, params, true);
        }
        catch (NoSuchMethodException e1) {
            return null;
        }
    }

    protected static String getMethodName(String methodName, Class cls, Class[] params) {
        try {
            PrivilegedAccessController.getMethod(cls, methodName, params, true);
        }
        catch (NoSuchMethodException e1) {
            return null;
        }
        return methodName;
    }

    public static String[] getMethodNamesForField(String name, Object type) {
        String getMethod = "";
        String setMethod = "";
        if (type instanceof Boolean) {
            if (name.startsWith(IS_PROPERTY_METHOD_PREFIX)) {
                getMethod = name;
                setMethod = SET_PROPERTY_METHOD_PREFIX + name.substring(2);
            } else {
                name = Character.toString(name.charAt(0)).toUpperCase() + name.substring(1);
                getMethod = IS_PROPERTY_METHOD_PREFIX + name;
                setMethod = SET_PROPERTY_METHOD_PREFIX + name;
            }
        } else {
            name = Character.toString(name.charAt(0)).toUpperCase() + name.substring(1);
            getMethod = GET_PROPERTY_METHOD_PREFIX + name;
            setMethod = SET_PROPERTY_METHOD_PREFIX + name;
        }
        return new String[]{getMethod, setMethod};
    }

    public static Method getMethodForName(Method[] methods, String methodName) {
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static Method[] getMethods(Class cls) {
        return PrivilegedAccessController.getMethods(cls);
    }

    public static Class getRawClassFromGeneric(Type type) {
        return (Class)((ParameterizedType)type).getRawType();
    }

    public static Class getReferenceClass(Class defaultReferenceClass, Class targetEntity) {
        if (targetEntity == Void.TYPE) {
            return defaultReferenceClass;
        }
        return targetEntity;
    }

    public static Class getReturnType(Method method) {
        return PrivilegedAccessController.getMethodReturnType(method);
    }

    public static Class getReturnTypeFromGeneric(Type type) {
        ParameterizedType pType = (ParameterizedType)type;
        if (Map.class.isAssignableFrom((Class)pType.getRawType())) {
            return (Class)pType.getActualTypeArguments()[1];
        }
        return (Class)pType.getActualTypeArguments()[0];
    }

    public static Method getSetMethod(Method method, Class cls) {
        String getMethodName = method.getName();
        Class[] params = new Class[]{method.getReturnType()};
        if (getMethodName.startsWith(GET_PROPERTY_METHOD_PREFIX)) {
            return MetadataHelper.getMethod(SET_PROPERTY_METHOD_PREFIX + getMethodName.substring(3), cls, params);
        }
        Method setMethod = MetadataHelper.getMethod(SET_PROPERTY_METHOD_PREFIX + getMethodName.substring(2), cls, params);
        if (setMethod == null) {
            return MetadataHelper.getMethod(SET_IS_PROPERTY_METHOD_PREFIX + getMethodName.substring(2), cls, params);
        }
        return setMethod;
    }

    public static String getSetMethodName(Method method, Class cls) {
        String getMethodName = method.getName();
        Class[] params = new Class[]{method.getReturnType()};
        if (getMethodName.startsWith(GET_PROPERTY_METHOD_PREFIX)) {
            return MetadataHelper.getMethodName(SET_PROPERTY_METHOD_PREFIX + getMethodName.substring(3), cls, params);
        }
        String setMethodName = MetadataHelper.getMethodName(SET_PROPERTY_METHOD_PREFIX + getMethodName.substring(2), cls, params);
        if (setMethodName == null) {
            return MetadataHelper.getMethodName(SET_IS_PROPERTY_METHOD_PREFIX + getMethodName.substring(2), cls, params);
        }
        return setMethodName;
    }

    public static Class getType(Field field) {
        return PrivilegedAccessController.getFieldType(field);
    }

    public static boolean isGenericCollectionType(Type type) {
        return type instanceof ParameterizedType;
    }

    public static boolean isPrimitiveWrapperClass(Class cls) {
        return cls.equals(Long.class) || cls.equals(Short.class) || cls.equals(Float.class) || cls.equals(Byte.class) || cls.equals(Double.class) || cls.equals(Number.class) || cls.equals(Boolean.class) || cls.equals(Integer.class) || cls.equals(Character.class) || cls.equals(BigInteger.class) || cls.equals(BigDecimal.class);
    }

    public static boolean isSupportedCollectionClass(Class cls) {
        return cls == Collection.class || cls == Set.class || cls == List.class || cls == Map.class;
    }

    public static boolean isValidAttributeName(String attributeName, Class javaClass) {
        Field[] attributes = MetadataHelper.getFields(javaClass);
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equals(attributeName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isValidClobType(Class cls) {
        return cls.equals(char[].class) || cls.equals(String.class) || cls.equals(Character[].class) || cls.equals(Clob.class);
    }

    public static boolean isValidBlobType(Class cls) {
        return cls.equals(byte[].class) || cls.equals(Byte[].class) || cls.equals(Blob.class) || Helper.classImplementsInterface(cls, Serializable.class);
    }

    public static boolean isValidEnumeratedType(Class cls) {
        return cls.isEnum();
    }

    public static boolean isValidLobType(Class cls) {
        return MetadataHelper.isValidClobType(cls) || MetadataHelper.isValidBlobType(cls);
    }

    public static boolean isValidPersistenceMethodName(String methodName) {
        return methodName.startsWith(GET_PROPERTY_METHOD_PREFIX) || methodName.startsWith(IS_PROPERTY_METHOD_PREFIX);
    }

    public static boolean isValidSerializedType(Class cls) {
        if (cls.isPrimitive()) {
            return false;
        }
        if (MetadataHelper.isPrimitiveWrapperClass(cls)) {
            return false;
        }
        if (MetadataHelper.isValidLobType(cls)) {
            return false;
        }
        return !MetadataHelper.isValidTemporalType(cls);
    }

    public static boolean isValidTemporalType(Class cls) {
        return cls.equals(java.util.Date.class) || cls.equals(Calendar.class) || cls.equals(GregorianCalendar.class);
    }

    public static void setIndirectionPolicy(boolean usesIndirection, CollectionMapping mapping, Class rawClass, String mapKey) {
        if (usesIndirection) {
            if (rawClass == Map.class) {
                mapping.useTransparentMap(mapKey);
            } else if (rawClass == List.class) {
                mapping.useTransparentList();
            } else if (rawClass == Collection.class) {
                mapping.useTransparentCollection();
            } else if (rawClass == Set.class) {
                mapping.useTransparentSet();
            }
        } else {
            mapping.dontUseIndirection();
            if (rawClass == Map.class) {
                mapping.useMapClass(Hashtable.class, mapKey);
            } else {
                mapping.useCollectionClass(Vector.class);
            }
        }
    }
}

