/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.imageMap;

import java.io.Serializable;
import org.jCharts.imageMap.AreaShape;

public abstract class ImageMapArea
implements Serializable {
    int[] x;
    int[] y;
    private double value;
    private String xAxisLabel;
    private String legendLabel;

    ImageMapArea(int n, double d, String string, String string2) {
        this.x = new int[n];
        this.y = new int[n];
        this.value = d;
        this.xAxisLabel = string;
        this.legendLabel = string2;
    }

    abstract AreaShape getAreaShape();

    public final int getNumberOfCoordinates() {
        return this.x.length;
    }

    public final int getXCoordinate(int n) {
        return this.x[n];
    }

    public final int getYCoordinate(int n) {
        return this.y[n];
    }

    public final double getValue() {
        return this.value;
    }

    public final String getXAxisLabel() {
        return this.xAxisLabel;
    }

    public final String getLengendLabel() {
        return this.legendLabel;
    }

    protected void getCoordinates(StringBuffer stringBuffer) {
        int n = 0;
        while (n < this.x.length) {
            stringBuffer.append(this.x[n] + "," + this.y[n]);
            if (n + 1 != this.x.length) {
                stringBuffer.append(",");
            }
            ++n;
        }
    }

    public final String toHTML(String string) {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("<area");
        stringBuffer.append(" shape=\"" + this.getAreaShape().getValue() + "\"");
        stringBuffer.append(" coords=\"");
        this.getCoordinates(stringBuffer);
        stringBuffer.append("\" ");
        stringBuffer.append(string);
        stringBuffer.append(">");
        return stringBuffer.toString();
    }
}

