/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.List;
import org.olap4j.Axis;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.MdxUtil;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeVisitor;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AxisNode
implements ParseTreeNode {
    private final ParseRegion region;
    private boolean nonEmpty;
    private ParseTreeNode expression;
    private final Axis axis;
    private final List<IdentifierNode> dimensionProperties;

    public AxisNode(ParseRegion region, boolean nonEmpty, Axis axisDef, List<IdentifierNode> dimensionProperties, ParseTreeNode expression) {
        this.region = region;
        this.nonEmpty = nonEmpty;
        this.expression = expression;
        this.axis = axisDef;
        if (dimensionProperties == null) {
            dimensionProperties = Collections.emptyList();
        }
        this.dimensionProperties = dimensionProperties;
    }

    @Override
    public ParseRegion getRegion() {
        return this.region;
    }

    @Override
    public <T> T accept(ParseTreeVisitor<T> visitor) {
        T o = visitor.visit(this);
        this.expression.accept(visitor);
        return o;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public boolean isNonEmpty() {
        return this.nonEmpty;
    }

    public void setNonEmpty(boolean nonEmpty) {
        this.nonEmpty = nonEmpty;
    }

    public ParseTreeNode getExpression() {
        return this.expression;
    }

    public void setExpression(ParseTreeNode expr) {
        this.expression = expr;
    }

    @Override
    public void unparse(ParseTreeWriter writer) {
        PrintWriter pw = writer.getPrintWriter();
        if (this.nonEmpty) {
            pw.print("NON EMPTY ");
        }
        if (this.expression != null) {
            this.expression.unparse(writer);
        }
        if (this.dimensionProperties.size() > 0) {
            pw.print(" DIMENSION PROPERTIES ");
            for (int i = 0; i < this.dimensionProperties.size(); ++i) {
                IdentifierNode dimensionProperty = this.dimensionProperties.get(i);
                if (i > 0) {
                    pw.print(", ");
                }
                dimensionProperty.unparse(writer);
            }
        }
        if (this.axis != Axis.FILTER) {
            pw.print(" ON " + this.axis);
        }
    }

    public List<IdentifierNode> getDimensionProperties() {
        return this.dimensionProperties;
    }

    @Override
    public Type getType() {
        return null;
    }

    @Override
    public AxisNode deepCopy() {
        return new AxisNode(this.region, this.nonEmpty, this.axis, MdxUtil.deepCopyList(this.dimensionProperties), this.expression.deepCopy());
    }
}

