/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.zeroconf;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceEvent;
import javax.jmdns.ServiceInfo;
import javax.jmdns.ServiceListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.help.HelpManager;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.plugins.GUIPluginSkeleton;
import org.apache.log4j.chainsaw.prefs.SettingsManager;
import org.apache.log4j.chainsaw.zeroconf.ZeroConfDeviceModel;
import org.apache.log4j.chainsaw.zeroconf.ZeroConfPreferenceModel;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.MulticastReceiver;
import org.apache.log4j.net.SocketHubReceiver;
import org.apache.log4j.net.SocketReceiver;
import org.apache.log4j.net.UDPReceiver;
import org.apache.log4j.net.XMLSocketReceiver;
import org.apache.log4j.net.ZeroConfSupport;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.PluginEvent;
import org.apache.log4j.plugins.PluginListener;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.spi.LoggerRepositoryEx;

public class ZeroConfPlugin
extends GUIPluginSkeleton {
    private static final Logger LOG = Logger.getLogger((Class)(class$org$apache$log4j$chainsaw$zeroconf$ZeroConfPlugin == null ? (class$org$apache$log4j$chainsaw$zeroconf$ZeroConfPlugin = ZeroConfPlugin.class$("org.apache.log4j.chainsaw.zeroconf.ZeroConfPlugin")) : class$org$apache$log4j$chainsaw$zeroconf$ZeroConfPlugin));
    private static final Icon DEVICE_DISCOVERED_ICON = new ImageIcon(ChainsawIcons.ANIM_RADIO_TOWER);
    private ZeroConfDeviceModel discoveredDevices = new ZeroConfDeviceModel();
    private JTable deviceTable = new JTable(this.discoveredDevices);
    private final JScrollPane scrollPane = new JScrollPane(this.deviceTable);
    private ZeroConfPreferenceModel preferenceModel;
    private Map serviceInfoToReceiveMap = new HashMap();
    private JMenu connectToMenu = new JMenu("\u63a5\u7d9a\u5148");
    private JMenuItem helpItem = new JMenuItem(new AbstractAction("ZeroConf\u306b\u3064\u3044\u3066...", ChainsawIcons.ICON_HELP){

        public void actionPerformed(ActionEvent e) {
            HelpManager.getInstance().showHelpForClass(class$org$apache$log4j$chainsaw$zeroconf$ZeroConfPlugin == null ? (class$org$apache$log4j$chainsaw$zeroconf$ZeroConfPlugin = ZeroConfPlugin.class$("org.apache.log4j.chainsaw.zeroconf.ZeroConfPlugin")) : class$org$apache$log4j$chainsaw$zeroconf$ZeroConfPlugin);
        }
    });
    private JMenuItem nothingToConnectTo = new JMenuItem("\u30c7\u30d0\u30a4\u30b9\u304c\u3042\u308a\u307e\u305b\u3093");
    private static final String MULTICAST_APPENDER_SERVICE_NAME = "_log4j_xml_mcast_appender.local.";
    private static final String UDP_APPENDER_SERVICE_NAME = "_log4j_xml_udp_appender.local.";
    private static final String XML_SOCKET_APPENDER_SERVICE_NAME = "_log4j_xml_tcpconnect_appender.local.";
    private static final String SOCKET_APPENDER_SERVICE_NAME = "_log4j_obj_tcpconnect_appender.local.";
    private static final String SOCKETHUB_APPENDER_SERVICE_NAME = "_log4j_obj_tcpaccept_appender.local.";
    private JmDNS jmDNS;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$zeroconf$ZeroConfPlugin;

    public ZeroConfPlugin() {
        this.setName("Zeroconf");
    }

    public void shutdown() {
        if (this.jmDNS != null) {
            this.jmDNS.close();
        }
        this.save();
    }

    private void save() {
        File fileLocation = this.getPreferenceFileLocation();
        XStream stream = new XStream((HierarchicalStreamDriver)new DomDriver());
        try {
            stream.toXML((Object)this.preferenceModel, (Writer)new FileWriter(fileLocation));
        }
        catch (Exception e) {
            LOG.error((Object)"ZeroConfPlugin\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u4fdd\u5b58\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
        }
    }

    private File getPreferenceFileLocation() {
        return new File(SettingsManager.getInstance().getSettingsDirectory(), "zeroconfprefs.xml");
    }

    public void activateOptions() {
        this.setLayout(new BorderLayout());
        this.jmDNS = (JmDNS)ZeroConfSupport.getJMDNSInstance();
        this.registerServiceListenersForAppenders();
        this.deviceTable.addMouseListener(new ConnectorMouseListener());
        JToolBar toolbar = new JToolBar();
        SmallButton helpButton = new SmallButton(this.helpItem.getAction());
        helpButton.setText(this.helpItem.getText());
        toolbar.add(helpButton);
        toolbar.setFloatable(false);
        this.add((Component)toolbar, "North");
        this.add((Component)this.scrollPane, "Center");
        this.injectMenu();
        ((LoggerRepositoryEx)LogManager.getLoggerRepository()).getPluginRegistry().addPluginListener(new PluginListener(){

            public void pluginStarted(PluginEvent e) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void pluginStopped(PluginEvent e) {
                Plugin plugin = e.getPlugin();
                Map map = ZeroConfPlugin.this.serviceInfoToReceiveMap;
                synchronized (map) {
                    Iterator iter = ZeroConfPlugin.this.serviceInfoToReceiveMap.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        if (entry.getValue() != plugin) continue;
                        iter.remove();
                    }
                }
                ZeroConfPlugin.this.discoveredDevices.fireTableDataChanged();
            }
        });
        File fileLocation = this.getPreferenceFileLocation();
        XStream stream = new XStream((HierarchicalStreamDriver)new DomDriver());
        if (fileLocation.exists()) {
            try {
                this.preferenceModel = (ZeroConfPreferenceModel)stream.fromXML((Reader)new FileReader(fileLocation));
            }
            catch (Exception e) {
                LOG.error((Object)"ZeroConfPlugin\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
            }
        } else {
            this.preferenceModel = new ZeroConfPreferenceModel();
        }
        this.discoveredDevices.setZeroConfPreferenceModel(this.preferenceModel);
        this.discoveredDevices.setZeroConfPluginParent(this);
    }

    private void registerServiceListenersForAppenders() {
        HashSet<String> serviceNames = new HashSet<String>();
        serviceNames.add(MULTICAST_APPENDER_SERVICE_NAME);
        serviceNames.add(SOCKET_APPENDER_SERVICE_NAME);
        serviceNames.add(SOCKETHUB_APPENDER_SERVICE_NAME);
        serviceNames.add(UDP_APPENDER_SERVICE_NAME);
        serviceNames.add(XML_SOCKET_APPENDER_SERVICE_NAME);
        Iterator iter = serviceNames.iterator();
        while (iter.hasNext()) {
            String serviceName = iter.next().toString();
            this.jmDNS.addServiceListener(serviceName, (ServiceListener)new ZeroConfServiceListener());
            this.jmDNS.addServiceListener(serviceName, (ServiceListener)this.discoveredDevices);
        }
    }

    private void setIconIfNeeded() {
        Container container = this.getParent();
        if (container instanceof JTabbedPane) {
            JTabbedPane tabbedPane = (JTabbedPane)container;
            Icon icon = this.discoveredDevices.getRowCount() == 0 ? null : DEVICE_DISCOVERED_ICON;
            tabbedPane.setIconAt(tabbedPane.indexOfTab(this.getName()), icon);
        } else {
            LOG.warn((Object)("\u89aa\u306fTabbedPane\u3067\u306f\u3042\u308a\u307e\u305b\u3093\u3002\u30a2\u30a4\u30b3\u30f3\u3092\u8a2d\u5b9a\u3057\u307e\u305b\u3093\uff1a" + container.getClass().getName()));
        }
    }

    private void injectMenu() {
        JFrame frame = (JFrame)SwingUtilities.getWindowAncestor(this);
        if (frame == null) {
            LOG.info((Object)"\u30e1\u30cb\u30e5\u30fc\u3092\u8ffd\u52a0\u3059\u308bJFrame\u89aa\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
        } else {
            JMenuBar menuBar = frame.getJMenuBar();
            if (menuBar == null) {
                menuBar = new JMenuBar();
                frame.setJMenuBar(menuBar);
            }
            this.insertToLeftOfHelp(menuBar, this.connectToMenu);
            this.connectToMenu.add(this.nothingToConnectTo);
            this.discoveredDevices.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    if (ZeroConfPlugin.this.discoveredDevices.getRowCount() == 0) {
                        ZeroConfPlugin.this.connectToMenu.add((Component)ZeroConfPlugin.this.nothingToConnectTo, 0);
                    } else if (ZeroConfPlugin.this.discoveredDevices.getRowCount() > 0) {
                        ZeroConfPlugin.this.connectToMenu.remove(ZeroConfPlugin.this.nothingToConnectTo);
                    }
                }
            });
            this.nothingToConnectTo.setEnabled(false);
            this.connectToMenu.addSeparator();
            this.connectToMenu.add(this.helpItem);
        }
    }

    private void insertToLeftOfHelp(JMenuBar menuBar, JMenu item) {
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            JMenu menu = menuBar.getMenu(i);
            if (!menu.getText().equalsIgnoreCase("\u30d8\u30eb\u30d7")) continue;
            menuBar.add((Component)item, i - 1);
        }
        LOG.warn((Object)("\u30e1\u30cb\u30e5\u30fc\u300c" + item.getText() + "\u300d\u306f\u8ffd\u52a0\u3055\u308c\u307e\u305b\u3093\u3067\u3057\u305f\u3002\u300c\u30d8\u30eb\u30d7\u300d\u30e1\u30cb\u30e5\u30fc\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093"));
    }

    private void deviceDiscovered(final ServiceInfo info) {
        final String name = info.getName();
        JMenuItem connectToDeviceMenuItem = new JMenuItem(new AbstractAction(info.getName()){

            public void actionPerformed(ActionEvent e) {
                ZeroConfPlugin.this.connectTo(info);
            }
        });
        if (this.discoveredDevices.getRowCount() > 0) {
            Component[] menuComponents = this.connectToMenu.getMenuComponents();
            boolean located = false;
            for (int i = 0; i < menuComponents.length; ++i) {
                JMenuItem item;
                Component c = menuComponents[i];
                if (c instanceof JPopupMenu.Separator || (item = (JMenuItem)menuComponents[i]).getText().compareToIgnoreCase(name) >= 0) continue;
                this.connectToMenu.insert(connectToDeviceMenuItem, i);
                located = true;
                break;
            }
            if (!located) {
                this.connectToMenu.insert(connectToDeviceMenuItem, 0);
            }
        } else {
            this.connectToMenu.insert(connectToDeviceMenuItem, 0);
        }
        if (this.preferenceModel != null && this.preferenceModel.getAutoConnectDevices() != null && this.preferenceModel.getAutoConnectDevices().contains(name)) {
            new Thread(new Runnable(){

                public void run() {
                    LOG.info((Object)("Auto-connecting to " + name));
                    ZeroConfPlugin.this.connectTo(info);
                }
            }).start();
        }
    }

    private void deviceRemoved(String name) {
        Component[] menuComponents = this.connectToMenu.getMenuComponents();
        for (int i = 0; i < menuComponents.length; ++i) {
            JMenuItem item;
            Component c = menuComponents[i];
            if (c instanceof JPopupMenu.Separator || (item = (JMenuItem)menuComponents[i]).getText().compareToIgnoreCase(name) != 0) continue;
            this.connectToMenu.remove(item);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnectFrom(ServiceInfo info) {
        Plugin plugin;
        if (!this.isConnectedTo(info)) {
            return;
        }
        Map map = this.serviceInfoToReceiveMap;
        synchronized (map) {
            plugin = (Plugin)this.serviceInfoToReceiveMap.get(info);
        }
        ((LoggerRepositoryEx)LogManager.getLoggerRepository()).getPluginRegistry().stopPlugin(plugin.getName());
        JMenuItem item = this.locateMatchingMenuItem(info.getName());
        if (item != null) {
            item.setIcon(null);
            item.setEnabled(true);
        }
    }

    boolean isConnectedTo(ServiceInfo info) {
        return this.serviceInfoToReceiveMap.containsKey(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectTo(ServiceInfo info) {
        LOG.info((Object)("Connection request for " + info));
        Receiver receiver = this.getReceiver(info);
        if (receiver == null) {
            return;
        }
        ((LoggerRepositoryEx)LogManager.getLoggerRepository()).getPluginRegistry().addPlugin((Plugin)receiver);
        receiver.activateOptions();
        LOG.info((Object)("Receiver '" + receiver.getName() + "' has been started"));
        Map map = this.serviceInfoToReceiveMap;
        synchronized (map) {
            this.serviceInfoToReceiveMap.put(info, receiver);
        }
        JMenuItem item = this.locateMatchingMenuItem(info.getName());
        if (item != null) {
            item.setIcon(new ImageIcon(ChainsawIcons.ANIM_NET_CONNECT));
            item.setEnabled(false);
        }
    }

    private Receiver getReceiver(ServiceInfo info) {
        String zone = info.getType();
        int port = info.getPort();
        String hostAddress = info.getHostAddress();
        String name = info.getName();
        String decoderClass = info.getPropertyString("decoder");
        if (MULTICAST_APPENDER_SERVICE_NAME.equals(zone)) {
            MulticastReceiver receiver = new MulticastReceiver();
            receiver.setAddress(info.getPropertyString("multicastAddress"));
            receiver.setPort(port);
            receiver.setName(name + "-receiver");
            if (decoderClass != null && !decoderClass.equals("")) {
                receiver.setDecoder(decoderClass);
            }
            return receiver;
        }
        if (UDP_APPENDER_SERVICE_NAME.equals(zone)) {
            UDPReceiver receiver = new UDPReceiver();
            receiver.setPort(port);
            receiver.setName(name + "-receiver");
            if (decoderClass != null && !decoderClass.equals("")) {
                receiver.setDecoder(decoderClass);
            }
            return receiver;
        }
        if (XML_SOCKET_APPENDER_SERVICE_NAME.equals(zone)) {
            XMLSocketReceiver receiver = new XMLSocketReceiver();
            receiver.setPort(port);
            receiver.setName(name + "-receiver");
            if (decoderClass != null && !decoderClass.equals("")) {
                receiver.setDecoder(decoderClass);
            }
            return receiver;
        }
        if (SOCKET_APPENDER_SERVICE_NAME.equals(zone)) {
            SocketReceiver receiver = new SocketReceiver();
            receiver.setPort(port);
            receiver.setName(name + "-receiver");
            return receiver;
        }
        if (SOCKETHUB_APPENDER_SERVICE_NAME.equals(zone)) {
            SocketHubReceiver receiver = new SocketHubReceiver();
            receiver.setHost(hostAddress);
            receiver.setPort(port);
            receiver.setName(name + "-receiver");
            return receiver;
        }
        LogLog.debug((String)("Unable to find receiver for appender with service name: " + zone));
        return null;
    }

    private JMenuItem locateMatchingMenuItem(String name) {
        Component[] menuComponents = this.connectToMenu.getMenuComponents();
        for (int i = 0; i < menuComponents.length; ++i) {
            JMenuItem item;
            Component c = menuComponents[i];
            if (c instanceof JPopupMenu.Separator || (item = (JMenuItem)menuComponents[i]).getText().compareToIgnoreCase(name) != 0) continue;
            return item;
        }
        return null;
    }

    public static void main(String[] args) throws InterruptedException {
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure();
        final ZeroConfPlugin plugin = new ZeroConfPlugin();
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)plugin, "Center");
        plugin.activateOptions();
        frame.pack();
        frame.setVisible(true);
        Thread thread = new Thread(new Runnable(){

            public void run() {
                plugin.shutdown();
            }
        });
        Runtime.getRuntime().addShutdownHook(thread);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ConnectorMouseListener
    extends MouseAdapter {
        private ConnectorMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int row = ZeroConfPlugin.this.deviceTable.rowAtPoint(e.getPoint());
                if (ZeroConfPlugin.this.deviceTable.columnAtPoint(e.getPoint()) == 2) {
                    return;
                }
                ServiceInfo info = ZeroConfPlugin.this.discoveredDevices.getServiceInfoAtRow(row);
                if (!ZeroConfPlugin.this.isConnectedTo(info)) {
                    ZeroConfPlugin.this.connectTo(info);
                } else {
                    ZeroConfPlugin.this.disconnectFrom(info);
                }
            }
        }

        public void mousePressed(MouseEvent e) {
        }
    }

    private class ZeroConfServiceListener
    implements ServiceListener {
        private ZeroConfServiceListener() {
        }

        public void serviceAdded(final ServiceEvent event) {
            LOG.info((Object)("Service Added: " + event));
            Runnable runnable = new Runnable(){

                public void run() {
                    ZeroConfPlugin.this.jmDNS.requestServiceInfo(event.getType(), event.getName());
                }
            };
            Thread thread = new Thread(runnable, "ChainsawZeroConfRequestResolutionThread");
            thread.setPriority(1);
            thread.start();
        }

        public void serviceRemoved(ServiceEvent event) {
            LOG.info((Object)("Service Removed: " + event));
            ZeroConfPlugin.this.deviceRemoved(event.getName());
        }

        public void serviceResolved(ServiceEvent event) {
            LOG.info((Object)("Service Resolved: " + event));
            ZeroConfPlugin.this.deviceDiscovered(event.getInfo());
        }
    }
}

