/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.receivers;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.net.SocketReceiver;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.plugins.PluginEvent;
import org.apache.log4j.plugins.PluginListener;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggerRepositoryEx;

public class ReceiversTreeModel
extends DefaultTreeModel
implements PluginListener {
    private static final String ROOTNODE_LABEL = "\u30ec\u30b7\u30fc\u30d0\u30fc";
    final DefaultMutableTreeNode NoReceiversNode = new DefaultMutableTreeNode("\u5b9a\u7fa9\u3055\u308c\u305f\u30ec\u30b7\u30fc\u30d0\u30fc\u304c\u3042\u308a\u307e\u305b\u3093");
    final DefaultMutableTreeNode RootNode;
    private final Logger logger = LogManager.getLogger((Class)(class$org$apache$log4j$chainsaw$receivers$ReceiversTreeModel == null ? (class$org$apache$log4j$chainsaw$receivers$ReceiversTreeModel = ReceiversTreeModel.class$("org.apache.log4j.chainsaw.receivers.ReceiversTreeModel")) : class$org$apache$log4j$chainsaw$receivers$ReceiversTreeModel));
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$receivers$ReceiversTreeModel;
    static /* synthetic */ Class class$org$apache$log4j$plugins$Receiver;

    ReceiversTreeModel() {
        super(new DefaultMutableTreeNode(ROOTNODE_LABEL));
        this.RootNode = (DefaultMutableTreeNode)this.getRoot();
        this.refresh();
    }

    public final synchronized ReceiversTreeModel refresh() {
        this.RootNode.removeAllChildren();
        LoggerRepository repo = LogManager.getLoggerRepository();
        List receivers = repo instanceof LoggerRepositoryEx ? ((LoggerRepositoryEx)repo).getPluginRegistry().getPlugins(class$org$apache$log4j$plugins$Receiver == null ? (class$org$apache$log4j$plugins$Receiver = ReceiversTreeModel.class$("org.apache.log4j.plugins.Receiver")) : class$org$apache$log4j$plugins$Receiver) : new Vector();
        this.updateRootDisplay();
        if (receivers.size() == 0) {
            this.getRootNode().add(this.NoReceiversNode);
        } else {
            Iterator iter = receivers.iterator();
            while (iter.hasNext()) {
                Receiver item = (Receiver)iter.next();
                DefaultMutableTreeNode receiverNode = new DefaultMutableTreeNode(item);
                item.addPropertyChangeListener(this.creatPluginPropertyChangeListener(item, receiverNode));
                if (item instanceof SocketReceiver) {
                    Iterator iterator = ((AbstractList)((SocketReceiver)item).getConnectedSocketDetails()).iterator();
                    while (iterator.hasNext()) {
                        Object details = iterator.next();
                        receiverNode.add(new DefaultMutableTreeNode(details));
                    }
                }
                this.getRootNode().add(receiverNode);
            }
        }
        this.reload();
        return this;
    }

    private PropertyChangeListener creatPluginPropertyChangeListener(final Receiver item, final DefaultMutableTreeNode receiverNode) {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ReceiversTreeModel.this.logger.debug((Object)((EventObject)evt).toString());
                ReceiversTreeModel.this.fireTreeNodesChanged(item, receiverNode.getPath(), null, null);
            }
        };
    }

    void updateRootDisplay() {
        this.getRootNode().setUserObject(ROOTNODE_LABEL);
        this.nodeChanged(this.getRootNode());
    }

    DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.getRoot();
    }

    public void pluginStarted(PluginEvent e) {
        if (e.getPlugin() instanceof Receiver) {
            if (this.NoReceiversNode.getParent() == this.getRootNode()) {
                int index = this.getRootNode().getIndex(this.NoReceiversNode);
                this.getRootNode().remove(this.NoReceiversNode);
                this.nodesWereRemoved(this.getRootNode(), new int[]{index}, new Object[]{this.NoReceiversNode});
            }
            Receiver receiver = (Receiver)e.getPlugin();
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(receiver);
            this.getRootNode().add(newNode);
            receiver.addPropertyChangeListener(this.creatPluginPropertyChangeListener(receiver, newNode));
            this.nodesWereInserted(this.getRootNode(), new int[]{this.getRootNode().getIndex(newNode)});
        }
    }

    TreeNode resolvePluginNode(Plugin p) {
        DefaultMutableTreeNode treeNode = null;
        Enumeration<TreeNode> e = this.getRootNode().breadthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.nextElement();
            if (!node.getUserObject().equals(p)) continue;
            treeNode = node;
            break;
        }
        return treeNode;
    }

    public void pluginStopped(PluginEvent e) {
        if (e.getPlugin() instanceof Receiver) {
            int index;
            Receiver receiver = (Receiver)e.getPlugin();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.resolvePluginNode((Plugin)receiver);
            if (node != null) {
                index = this.getRootNode().getIndex(node);
                this.getRootNode().remove(node);
                this.nodesWereRemoved(this.getRootNode(), new int[]{index}, new Object[]{node});
            }
            if (this.getRootNode().getChildCount() == 0) {
                this.getRootNode().add(this.NoReceiversNode);
                index = this.getRootNode().getIndex(this.NoReceiversNode);
                this.nodesWereInserted(this.getRootNode(), new int[]{index});
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

