/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.receivers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.Generator;
import org.apache.log4j.chainsaw.helper.TableCellEditorFactory;
import org.apache.log4j.net.SocketHubReceiver;
import org.apache.log4j.plugins.Plugin;

public class PluginPropertyEditorPanel
extends JPanel {
    private final JScrollPane scrollPane = new JScrollPane();
    private final JTable propertyTable = new JTable();
    private Plugin plugin;
    private TableModel defaultModel = new DefaultTableModel(new String[]{"\u30d7\u30ed\u30d1\u30c6\u30a3", "\u5024"}, 1);
    private static final Logger logger = LogManager.getLogger((Class)(class$org$apache$log4j$chainsaw$receivers$PluginPropertyEditorPanel == null ? (class$org$apache$log4j$chainsaw$receivers$PluginPropertyEditorPanel = PluginPropertyEditorPanel.class$("org.apache.log4j.chainsaw.receivers.PluginPropertyEditorPanel")) : class$org$apache$log4j$chainsaw$receivers$PluginPropertyEditorPanel));
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$receivers$PluginPropertyEditorPanel;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$org$apache$log4j$Level;
    static /* synthetic */ Class class$java$lang$Integer;

    public PluginPropertyEditorPanel() {
        this.initComponents();
        this.setupListeners();
    }

    private void initComponents() {
        this.propertyTable.setRowHeight(19);
        this.setLayout(new BorderLayout());
        this.scrollPane.setViewportView(this.propertyTable);
        this.add((Component)this.scrollPane, "Center");
        this.defaultModel = new DefaultTableModel(new String[]{"\u30d7\u30ed\u30d1\u30c6\u30a3", "\u5024"}, 1);
        this.propertyTable.setModel(this.defaultModel);
    }

    private void setupListeners() {
        this.addPropertyChangeListener("plugin", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Plugin p = (Plugin)evt.getNewValue();
                if (p != null) {
                    try {
                        PluginPropertyTableModel model = new PluginPropertyTableModel(p);
                        PluginPropertyEditorPanel.this.propertyTable.setModel(model);
                        PluginPropertyEditorPanel.this.propertyTable.getColumnModel().getColumn(1).setCellEditor(new PluginTableCellEditor());
                        PluginPropertyEditorPanel.this.propertyTable.setEnabled(true);
                    }
                    catch (Throwable e) {
                        logger.error((Object)"Failed to introspect the Plugin", e);
                    }
                } else {
                    PluginPropertyEditorPanel.this.propertyTable.setModel(PluginPropertyEditorPanel.this.defaultModel);
                    PluginPropertyEditorPanel.this.propertyTable.setEnabled(false);
                }
            }
        });
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("\u30d7\u30ed\u30d1\u30c6\u30a3\u30a8\u30c7\u30a3\u30bf\u30c6\u30b9\u30c8");
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent e) {
                System.exit(1);
            }
        });
        PluginPropertyEditorPanel panel = new PluginPropertyEditorPanel();
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setVisible(true);
        SocketHubReceiver r = new SocketHubReceiver();
        panel.setPlugin((Plugin)r);
        try {
            Thread.sleep(3000L);
            panel.setPlugin((Plugin)new Generator("MyPlugin"));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public final Plugin getPlugin() {
        return this.plugin;
    }

    public final void setPlugin(Plugin plugin) {
        Plugin oldValue = this.plugin;
        this.plugin = plugin;
        this.firePropertyChange("plugin", oldValue, this.plugin);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class PluginPropertyTableModel
    extends AbstractTableModel {
        private final PropertyDescriptor[] descriptors;
        private final Plugin plugin;

        private PluginPropertyTableModel(Plugin p) throws IntrospectionException {
            BeanInfo beanInfo = Introspector.getBeanInfo(p.getClass());
            ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(Arrays.asList(beanInfo.getPropertyDescriptors()));
            Collections.sort(list, new Comparator(){

                public int compare(Object o1, Object o2) {
                    PropertyDescriptor d1 = (PropertyDescriptor)o1;
                    PropertyDescriptor d2 = (PropertyDescriptor)o2;
                    return d1.getDisplayName().compareToIgnoreCase(d2.getDisplayName());
                }
            });
            this.plugin = p;
            this.descriptors = list.toArray(new PropertyDescriptor[0]);
        }

        public Object getValueAt(int row, int col) {
            PropertyDescriptor d = this.descriptors[row];
            switch (col) {
                case 1: {
                    try {
                        Object object = d.getReadMethod().invoke((Object)this.plugin, new Object[0]);
                        if (object != null) {
                            return object;
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)("Error reading value for PropertyDescriptor " + d));
                    }
                    return "";
                }
                case 0: {
                    return d.getName();
                }
            }
            return null;
        }

        public int getColumnCount() {
            return 2;
        }

        public int getRowCount() {
            return this.descriptors.length;
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                return this.descriptors[rowIndex].getWriteMethod() != null;
            }
            return false;
        }

        public String getColumnName(int column) {
            return column == 0 ? "\u30d7\u30ed\u30d1\u30c6\u30a3" : "\u5024";
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 1) {
                if (this.descriptors[rowIndex].getName().toLowerCase().equals("name") && aValue == null || aValue.toString().trim().equals("")) {
                    logger.error((Object)"Name required");
                    return;
                }
                aValue = this.translateValueIfNeeded(rowIndex, aValue);
                logger.debug((Object)("setValueAt, " + rowIndex + ", " + columnIndex + ", value=" + aValue + ", valueClass" + aValue.getClass()));
                try {
                    this.descriptors[rowIndex].getWriteMethod().invoke((Object)this.plugin, aValue);
                    this.fireTableCellUpdated(rowIndex, columnIndex);
                }
                catch (IllegalArgumentException e) {
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to modify the Plugin because of Exception", (Throwable)e);
                }
            } else {
                super.setValueAt(aValue, rowIndex, columnIndex);
            }
        }

        private Object translateValueIfNeeded(int row, Object value) {
            if (this.descriptors[row].getPropertyType() == Integer.TYPE || this.descriptors[row].getPropertyType() == (class$java$lang$Integer == null ? (class$java$lang$Integer = PluginPropertyEditorPanel.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                try {
                    return Integer.valueOf(value.toString());
                }
                catch (Exception e) {
                    logger.error((Object)"Failed to convert to Integer type");
                }
            }
            return value;
        }

        public final PropertyDescriptor[] getDescriptors() {
            return this.descriptors;
        }
    }

    private class PluginTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private Map editorMap = new HashMap();
        private DefaultCellEditor defaultEditor;
        private DefaultCellEditor currentEditor = this.defaultEditor = new DefaultCellEditor(new JTextField());

        private PluginTableCellEditor() {
            this.editorMap.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = PluginPropertyEditorPanel.class$("java.lang.Boolean")) : class$java$lang$Boolean, TableCellEditorFactory.createBooleanTableCellEditor());
            this.editorMap.put(class$org$apache$log4j$Level == null ? (class$org$apache$log4j$Level = PluginPropertyEditorPanel.class$("org.apache.log4j.Level")) : class$org$apache$log4j$Level, TableCellEditorFactory.createLevelTableCellEditor());
            this.editorMap.put(Boolean.TYPE, TableCellEditorFactory.createBooleanTableCellEditor());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            PluginPropertyTableModel model = (PluginPropertyTableModel)table.getModel();
            PropertyDescriptor descriptor = model.getDescriptors()[row];
            Class<?> valueClass = descriptor.getPropertyType();
            if (this.editorMap.containsKey(valueClass)) {
                DefaultCellEditor editor = (DefaultCellEditor)this.editorMap.get(valueClass);
                logger.debug((Object)("Located CellEditor for " + valueClass));
                this.currentEditor = editor;
                return this.currentEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
            this.currentEditor = this.defaultEditor;
            logger.debug((Object)("Cell value class " + valueClass + " not know, using default editor"));
            return this.defaultEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        public Object getCellEditorValue() {
            return this.currentEditor.getCellEditorValue();
        }
    }
}

