/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.messages;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.TTCCLayout;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.PopupListener;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.varia.ListModelAppender;

public class MessageCenter {
    private static final MessageCenter instance = new MessageCenter();
    private final Logger logger = Logger.getLogger((Class)(class$org$apache$log4j$chainsaw$messages$MessageCenter == null ? (class$org$apache$log4j$chainsaw$messages$MessageCenter = MessageCenter.class$("org.apache.log4j.chainsaw.messages.MessageCenter")) : class$org$apache$log4j$chainsaw$messages$MessageCenter));
    private Layout layout = new TTCCLayout();
    private final JList messageList = new JList();
    private final ListModelAppender appender = new ListModelAppender();
    private ListCellRenderer listCellRenderer = new LayoutListCellRenderer(this.layout);
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport(this);
    private JScrollPane pane = new JScrollPane(this.messageList);
    private final JToolBar toolbar = new JToolBar();
    private JPopupMenu popupMenu = new JPopupMenu();
    private PopupListener popupListener = new PopupListener(this.popupMenu);
    private Action clearAction;
    private final JPanel componentPanel = new JPanel(new BorderLayout());
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$messages$MessageCenter;

    private MessageCenter() {
        this.setupActions();
        this.setupComponentPanel();
        this.setupLogger();
        this.setupListeners();
        this.setupPopMenu();
        this.setupToolbar();
    }

    private void setupPopMenu() {
        this.popupMenu.add(this.clearAction);
    }

    private void setupToolbar() {
        SmallButton clearButton = new SmallButton(this.clearAction);
        clearButton.setText(null);
        this.toolbar.add(clearButton);
        this.toolbar.setFloatable(false);
    }

    private void setupActions() {
        this.clearAction = new AbstractAction("Clear"){

            public void actionPerformed(ActionEvent e) {
                MessageCenter.this.appender.clearModel();
            }
        };
        this.clearAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.DELETE));
    }

    private void setupListeners() {
        this.propertySupport.addPropertyChangeListener("layout", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Layout newLayout = (Layout)evt.getNewValue();
                MessageCenter.this.messageList.setCellRenderer(new LayoutListCellRenderer(newLayout));
            }
        });
        this.messageList.addMouseListener(this.popupListener);
        this.appender.getModel().addListDataListener(new ListDataListener(){

            public void contentsChanged(ListDataEvent e) {
                MessageCenter.this.updateActions();
            }

            public void intervalAdded(ListDataEvent e) {
                MessageCenter.this.updateActions();
            }

            public void intervalRemoved(ListDataEvent e) {
                MessageCenter.this.updateActions();
            }
        });
    }

    private void updateActions() {
        this.clearAction.putValue("enabled", this.appender.getModel().getSize() > 0 ? Boolean.TRUE : Boolean.FALSE);
    }

    private void setupLogger() {
        this.logger.addAppender((Appender)this.appender);
        this.logger.setAdditivity(true);
        this.logger.setLevel(Boolean.getBoolean("log4j.debug") ? Level.DEBUG : Level.INFO);
    }

    private void setupComponentPanel() {
        this.messageList.setModel(this.appender.getModel());
        this.messageList.setCellRenderer(this.listCellRenderer);
        this.componentPanel.add((Component)this.toolbar, "North");
        this.componentPanel.add((Component)this.pane, "Center");
    }

    public final JComponent getGUIComponent() {
        return this.componentPanel;
    }

    public ListModel getModel() {
        return this.messageList.getModel();
    }

    public static MessageCenter getInstance() {
        return instance;
    }

    public void addMessage(String message) {
        this.logger.info((Object)message);
    }

    public final Layout getLayout() {
        return this.layout;
    }

    public final void setLayout(Layout layout) {
        Layout oldValue = this.layout;
        this.layout = layout;
        this.propertySupport.firePropertyChange("layout", oldValue, this.layout);
    }

    public final Logger getLogger() {
        return this.logger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LayoutListCellRenderer
    extends DefaultListCellRenderer
    implements ListCellRenderer {
        private Layout layout;

        public LayoutListCellRenderer(Layout layout) {
            this.layout = layout;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            value = this.layout.format((LoggingEvent)value);
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            c.setBackground(index % 2 == 0 ? ChainsawConstants.COLOR_EVEN_ROW_BACKGROUND : ChainsawConstants.COLOR_ODD_ROW_BACKGROUND);
            return c;
        }
    }
}

