/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw.helper;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.KeyStroke;

public final class SwingHelper {
    public static void centerOnScreen(Component component) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        component.setLocation(screenSize.width / 2 - component.getWidth() / 2, screenSize.height / 2 - component.getHeight() / 2);
    }

    public static void configureCancelForDialog(final JDialog dialog, JButton cancelButton) {
        String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
        int noModifiers = 0;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, noModifiers, false);
        InputMap inputMap = dialog.getRootPane().getInputMap(1);
        inputMap.put(escapeKey, CANCEL_ACTION_KEY);
        AbstractAction closeAction = new AbstractAction("\u30ad\u30e3\u30f3\u30bb\u30eb"){

            public void actionPerformed(ActionEvent arg0) {
                dialog.dispose();
            }
        };
        cancelButton.setAction(closeAction);
        dialog.getRootPane().getActionMap().put(CANCEL_ACTION_KEY, closeAction);
    }

    public static void invokeOnEDT(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }
}

