/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import org.apache.log4j.chainsaw.SmallButton;

class ThrowableRenderPanel
extends AbstractCellEditor
implements TableCellEditor {
    private final SmallButton btn = new SmallButton();
    private final JLabel lbl = new JLabel("");
    private final JPanel panel = new JPanel();
    private Color background = new Color(255, 255, 254);
    private final Color COLOR_ODD = new Color(230, 230, 230);
    private final Action showStackTraceAction;

    ThrowableRenderPanel() {
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.lbl, "Center");
        this.panel.add((Component)this.btn, "East");
        this.lbl.setOpaque(false);
        this.showStackTraceAction = new AbstractAction("..."){

            public void actionPerformed(ActionEvent e) {
            }
        };
        this.showStackTraceAction.putValue("ShortDescription", "Display the full stack trace in a popup");
        this.btn.setAction(this.showStackTraceAction);
    }

    void addActionListener(ActionListener l) {
        this.btn.addActionListener(l);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof String[] && ((String[])value).length > 0) {
            this.lbl.setText(((String[])value)[0]);
        } else {
            this.lbl.setText("");
        }
        if (isSelected) {
            this.panel.setBackground(table.getSelectionBackground());
            this.panel.setForeground(table.getSelectionForeground());
        } else if (row % 2 != 0) {
            this.panel.setBackground(this.COLOR_ODD);
            this.panel.setForeground(table.getSelectionForeground());
        } else {
            this.panel.setBackground(this.background);
            this.panel.setForeground(table.getSelectionForeground());
        }
        return this.panel;
    }

    public Object getCellEditorValue() {
        return this.lbl.getText();
    }
}

