/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class RuleMediator
extends AbstractRule
implements Rule {
    private Rule inclusionRule;
    private Rule loggerRule;
    private Rule refinementRule;
    private Rule exclusionRule;
    private final PropertyChangeListener ruleChangerNotifier = new RuleChangerNotifier();

    public boolean evaluate(LoggingEvent e, Map matches) {
        boolean accepts = true;
        if (this.inclusionRule != null) {
            accepts = this.inclusionRule.evaluate(e, null);
        }
        if (!accepts) {
            return false;
        }
        if (this.loggerRule != null) {
            accepts = this.loggerRule.evaluate(e, null);
        }
        if (!accepts) {
            return false;
        }
        if (this.refinementRule != null) {
            accepts = this.refinementRule.evaluate(e, null);
        }
        if (!accepts) {
            return false;
        }
        if (this.exclusionRule != null) {
            accepts = this.exclusionRule.evaluate(e, null);
        }
        return accepts;
    }

    public void setInclusionRule(Rule r) {
        Rule oldRule = this.inclusionRule;
        this.inclusionRule = r;
        this.firePropertyChange("inclusionRule", oldRule, this.inclusionRule);
    }

    public void setRefinementRule(Rule r) {
        Rule oldRefinementRule = this.refinementRule;
        this.refinementRule = r;
        this.firePropertyChange("refinementRule", oldRefinementRule, this.refinementRule);
    }

    public void setLoggerRule(Rule r) {
        Rule oldLoggerRule = this.loggerRule;
        this.loggerRule = r;
        if (oldLoggerRule != null) {
            oldLoggerRule.removePropertyChangeListener(this.ruleChangerNotifier);
        }
        this.loggerRule.addPropertyChangeListener(this.ruleChangerNotifier);
        this.firePropertyChange("loggerRule", oldLoggerRule, this.loggerRule);
    }

    public void setExclusionRule(Rule r) {
        Rule oldExclusionRule = this.exclusionRule;
        this.exclusionRule = r;
        this.firePropertyChange("exclusionRule", oldExclusionRule, this.exclusionRule);
    }

    public final Rule getExclusionRule() {
        return this.exclusionRule;
    }

    public final Rule getInclusionRule() {
        return this.inclusionRule;
    }

    public final Rule getLoggerRule() {
        return this.loggerRule;
    }

    public final Rule getRefinementRule() {
        return this.refinementRule;
    }

    private class RuleChangerNotifier
    implements PropertyChangeListener {
        private RuleChangerNotifier() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            RuleMediator.this.firePropertyChange(evt);
        }
    }
}

