/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class ProgressPanel
extends JPanel {
    private final JLabel messageLabel = new JLabel();
    private final JProgressBar progressBar;

    ProgressPanel(int min, int max, String msg) {
        this.progressBar = new JProgressBar(min, max);
        this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.messageLabel.setHorizontalAlignment(0);
        this.messageLabel.setText(msg);
        this.setLayout(new BorderLayout());
        this.add((Component)this.progressBar, "Center");
        this.add((Component)this.messageLabel, "South");
    }

    public void setMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ProgressPanel.this.messageLabel.setText(string);
            }
        });
    }

    public void setProgress(final int progress) {
        try {
            Runnable runnable = new Runnable(){

                public void run() {
                    ProgressPanel.this.progressBar.setValue(progress);
                }
            };
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(runnable);
            } else {
                runnable.run();
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }
}

