/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.prefs.SettingsManager;
import org.apache.log4j.net.PortBased;

class NoReceiversWarningPanel
extends JPanel {
    private final JComboBox previousConfigs = new JComboBox();
    private final JRadioButton simpleReceiver = new JRadioButton("\u6b21\u3092\u5b9a\u7fa9 ");
    private final JRadioButton justLoadingFile = new JRadioButton("\u3053\u306e\u307e\u3093\u307e\u3067\uff2f\uff2b\u3067\u3059");
    private final JRadioButton searchOption = new JRadioButton("\u65e2\u5b58\u306e\u30ec\u30b7\u30fc\u30d0\u30fc\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u5229\u7528...");
    private final JRadioButton chainsawSavedConfigOption = new JRadioButton("\u30ec\u30b7\u30fc\u30d0\u30fc\u8a2d\u5b9a\u30d1\u30cd\u30eb\u3067\u5b9a\u7fa9\u3055\u308c\u305f\u6700\u65b0\u306e\u8a2d\u5b9a");
    private final JRadioButton manualOption = new JRadioButton("\u30ec\u30b7\u30fc\u30d0\u30fc\u8a2d\u5b9a\u30d1\u30cd\u30eb\u304b\u3089\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u5b9a\u7fa9\u3059\u308b(\u7d42\u4e86\u6642\u306b\u8a2d\u5b9a\u3092\u4fdd\u5b58\u3059\u308b)");
    private final JButton okButton = new JButton(" OK ");
    private final PanelModel model = new PanelModel();
    final DefaultComboBoxModel configModel = new DefaultComboBoxModel();
    final DefaultComboBoxModel simpleReceiverModel = new DefaultComboBoxModel();
    final DefaultComboBoxModel simplePortModel = new DefaultComboBoxModel();
    private boolean dontWarnMeAgain = false;
    private final Logger logger = LogManager.getLogger((Class)(class$org$apache$log4j$chainsaw$NoReceiversWarningPanel == null ? (class$org$apache$log4j$chainsaw$NoReceiversWarningPanel = NoReceiversWarningPanel.class$("org.apache.log4j.chainsaw.NoReceiversWarningPanel")) : class$org$apache$log4j$chainsaw$NoReceiversWarningPanel));
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$NoReceiversWarningPanel;
    static /* synthetic */ Class class$org$apache$log4j$net$SocketReceiver;
    static /* synthetic */ Class class$org$apache$log4j$net$SocketHubReceiver;

    NoReceiversWarningPanel() {
        this.initComponents();
    }

    PanelModel getModel() {
        return this.model;
    }

    void setOkActionListener(ActionListener actionListener) {
        this.okButton.addActionListener(actionListener);
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        this.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        gc.gridx = 1;
        gc.fill = 1;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        JTextPane description = new JTextPane();
        description.setText("\u30a4\u30d9\u30f3\u30c8\u3092Chainsaw\u306b\u8aad\u307f\u8fbc\u3080\u5834\u5408\u306f\u3001\u300c\u30ec\u30b7\u30fc\u30d0\u30fc\u300d\u8a2d\u5b9a\u304c\u5fc5\u8981\u3067\u3059\u3002\n\n\u6ce8\uff1a \u30ea\u30b7\u30fc\u30d0\u30fc\u8a2d\u5b9a\u306e\u4f8b\u984c\u306f\u59cb\u3081\u306b\u30bf\u30b0\u306b\u3042\u308a\u307e\u3059 ('\u30ea\u30b7\u30fc\u30d0\u30fc\u8a2d\u5b9a\u306e\u4f8b\u3092\u8868\u793a')");
        description.setEditable(false);
        description.setOpaque(false);
        description.setFont(this.getFont());
        this.add((Component)description, gc);
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.gridy = -1;
        this.add(Box.createVerticalStrut(20), gc);
        JPanel optionpanel = new JPanel();
        optionpanel.setLayout(new GridLayout(5, 1, 3, 3));
        optionpanel.setBackground(this.getBackground());
        optionpanel.setBorder(BorderFactory.createEtchedBorder());
        final ButtonGroup optionGroup = new ButtonGroup();
        this.simpleReceiver.setToolTipText("\uff11\u3064\u306e\u6a19\u6e96\u30dd\u30fc\u30c8\u306b\uff11\u3064\u306e\u6a19\u6e96\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u4f5c\u6210\u3059\u308b");
        this.simpleReceiver.setMnemonic('p');
        this.searchOption.setToolTipText("\u30ec\u30b7\u30fc\u30d0\u30fc\u5b9a\u7fa9\u3092\u542b\u3080Log4J\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u9078\u629e\u3059\u308b");
        this.searchOption.setMnemonic('S');
        this.chainsawSavedConfigOption.setToolTipText("\u4ee5\u524d\u306bChainsaw\u3067\u4fdd\u5b58\u3057\u305f\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u8aad\u307f\u8fbc\u3080");
        this.chainsawSavedConfigOption.setMnemonic('C');
        this.manualOption.setToolTipText("GUI\u3067\u5b9a\u7fa9\u3067\u304d\u308b\u3088\u3046\u306b\u30ec\u30b7\u30fc\u30d0\u30fc\u30d1\u30cd\u30eb\u3092\u958b\u304f");
        this.manualOption.setMnemonic('m');
        this.justLoadingFile.setToolTipText("\u3069\u3053\u306a\u306b\u4fdd\u5b58\u3055\u308c\u3066\u3044\u308bLog4J\u30ed\u30b0\u30d5\u30a1\u30a4\u30eb\u3092\u8868\u793a\u3059\u308b");
        this.justLoadingFile.setMnemonic('I');
        this.manualOption.setOpaque(false);
        this.justLoadingFile.setOpaque(false);
        optionGroup.add(this.searchOption);
        optionGroup.add(this.chainsawSavedConfigOption);
        optionGroup.add(this.manualOption);
        optionGroup.add(this.justLoadingFile);
        optionGroup.add(this.simpleReceiver);
        this.chainsawSavedConfigOption.setEnabled(this.getModel().isChinsawConfigFileExists());
        gc.gridy = -1;
        this.configModel.removeAllElements();
        this.previousConfigs.setModel(this.configModel);
        this.previousConfigs.setOpaque(false);
        this.previousConfigs.setBackground(this.getBackground());
        this.previousConfigs.setToolTipText("\u4ee5\u524d\u306b\u8aad\u307f\u8fbc\u3093\u3060\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306f\u3001\u3053\u3053\u304b\u3089\u9078\u629e\u3059\u308b\u3053\u3068\u304c\u3067\u304d\u307e\u3059");
        this.previousConfigs.setEditable(true);
        this.previousConfigs.getModel().addListDataListener(new ListDataListener(){

            private void validateUrl() {
                NoReceiversWarningPanel.this.okButton.setEnabled(NoReceiversWarningPanel.this.isValidConfigURL());
            }

            public void contentsChanged(ListDataEvent e) {
                this.validateUrl();
            }

            public void intervalAdded(ListDataEvent e) {
                this.validateUrl();
            }

            public void intervalRemoved(ListDataEvent e) {
                this.validateUrl();
            }
        });
        this.previousConfigs.setMaximumSize(new Dimension(200, (int)this.previousConfigs.getPreferredSize().getHeight()));
        this.previousConfigs.setPreferredSize(this.previousConfigs.getMaximumSize());
        this.previousConfigs.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                this.selectAll();
            }

            private void selectAll() {
                NoReceiversWarningPanel.this.previousConfigs.getEditor().selectAll();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        final JButton searchButton = new JButton(new AbstractAction("\u53c2\u7167... "){

            public void actionPerformed(ActionEvent e) {
                try {
                    URL url = NoReceiversWarningPanel.this.browseForConfig();
                    if (url != null) {
                        NoReceiversWarningPanel.this.getModel().configUrl = url;
                        NoReceiversWarningPanel.this.configModel.addElement(url);
                        NoReceiversWarningPanel.this.previousConfigs.getModel().setSelectedItem(url);
                    }
                }
                catch (Exception ex) {
                    NoReceiversWarningPanel.this.logger.error((Object)"\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u53c2\u7167\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", (Throwable)ex);
                }
            }
        });
        searchButton.setToolTipText("\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u63a2\u3059\u305f\u3081\u306b\u3001\u30d5\u30a1\u30a4\u30eb\u30c0\u30a4\u30a2\u30ed\u30b0\u3092\u958b\u304d\u307e\u3059\u3002");
        this.simplePortModel.addElement(new PortBased(){

            private void unsupported() {
                throw new UnsupportedOperationException("\u3053\u3053\u3067\u306f\u4f7f\u3048\u307e\u305b\u3093");
            }

            public String getName() {
                this.unsupported();
                return null;
            }

            public boolean isActive() {
                this.unsupported();
                return false;
            }

            public int getPort() {
                return 4445;
            }

            public String toString() {
                return this.getPort() + " (\u65e7\u30b9\u30bf\u30a4\u30eb\uff0f\u6a19\u6e96\u306eChainsaw\u30dd\u30fc\u30c8)";
            }
        });
        this.simplePortModel.addElement(new PortBased(){

            private void unsupported() {
                throw new UnsupportedOperationException("\u3053\u3053\u3067\u306f\u4f7f\u308f\u306a\u3044\u3067\u304f\u3060\u3055\u3044");
            }

            public String getName() {
                this.unsupported();
                return null;
            }

            public boolean isActive() {
                this.unsupported();
                return false;
            }

            public int getPort() {
                return 4560;
            }

            public String toString() {
                return this.getPort() + " (\u30c7\u30d5\u30a9\u30eb\u30c8SocketAppender\u30dd\u30fc\u30c8)";
            }
        });
        JPanel simpleSocketPanel = new JPanel();
        simpleSocketPanel.setLayout(new BoxLayout(simpleSocketPanel, 0));
        simpleSocketPanel.add(this.simpleReceiver);
        simpleSocketPanel.add(Box.createHorizontalStrut(5));
        final JComboBox socketCombo = new JComboBox(this.simplePortModel);
        this.simpleReceiverModel.addElement(class$org$apache$log4j$net$SocketReceiver == null ? (class$org$apache$log4j$net$SocketReceiver = NoReceiversWarningPanel.class$("org.apache.log4j.net.SocketReceiver")) : class$org$apache$log4j$net$SocketReceiver);
        this.simpleReceiverModel.addElement(class$org$apache$log4j$net$SocketHubReceiver == null ? (class$org$apache$log4j$net$SocketHubReceiver = NoReceiversWarningPanel.class$("org.apache.log4j.net.SocketHubReceiver")) : class$org$apache$log4j$net$SocketHubReceiver);
        final JComboBox<Object> receiverCombo = new JComboBox<Object>(this.simpleReceiverModel);
        receiverCombo.setEditable(false);
        receiverCombo.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof Class) {
                    Class receiverClass = (Class)value;
                    JLabel cellLabel = (JLabel)c;
                    String shortenedName = receiverClass.getName().substring(receiverClass.getName().lastIndexOf(46) + 1);
                    cellLabel.setText(shortenedName);
                }
                return c;
            }
        });
        simpleSocketPanel.add(receiverCombo);
        simpleSocketPanel.add(Box.createHorizontalStrut(5));
        simpleSocketPanel.add(new JLabel(" \u30dd\u30fc\u30c8\u756a\u53f7 "));
        simpleSocketPanel.add(Box.createHorizontalStrut(5));
        simpleSocketPanel.add(socketCombo);
        ActionListener al = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NoReceiversWarningPanel.this.previousConfigs.setEnabled(e.getSource() == NoReceiversWarningPanel.this.searchOption);
                searchButton.setEnabled(e.getSource() == NoReceiversWarningPanel.this.searchOption);
                socketCombo.setEnabled(e.getSource() == NoReceiversWarningPanel.this.simpleReceiver);
                receiverCombo.setEnabled(e.getSource() == NoReceiversWarningPanel.this.simpleReceiver);
                if (optionGroup.isSelected(NoReceiversWarningPanel.this.searchOption.getModel())) {
                    NoReceiversWarningPanel.this.okButton.setEnabled(NoReceiversWarningPanel.this.isValidConfigURL());
                } else {
                    NoReceiversWarningPanel.this.okButton.setEnabled(true);
                }
            }
        };
        this.searchOption.addActionListener(al);
        this.chainsawSavedConfigOption.addActionListener(al);
        this.manualOption.addActionListener(al);
        this.justLoadingFile.addActionListener(al);
        this.simpleReceiver.addActionListener(al);
        this.justLoadingFile.doClick();
        JPanel searchOptionPanel = new JPanel(new GridBagLayout());
        searchOptionPanel.setOpaque(false);
        GridBagConstraints searchGCC = new GridBagConstraints();
        searchGCC.fill = 2;
        searchGCC.gridx = 1;
        searchGCC.weightx = 0.0;
        searchGCC.anchor = 17;
        searchOptionPanel.add((Component)this.searchOption, searchGCC);
        searchGCC.fill = 0;
        searchGCC.weightx = 1.0;
        searchGCC.gridx = 2;
        searchOptionPanel.add(Box.createHorizontalStrut(5), searchGCC);
        searchGCC.gridx = 3;
        searchGCC.weightx = 0.0;
        searchOptionPanel.add((Component)this.previousConfigs, searchGCC);
        searchGCC.weightx = 0.0;
        searchGCC.gridx = 4;
        searchOptionPanel.add(Box.createHorizontalStrut(5), searchGCC);
        searchGCC.gridx = 5;
        searchOptionPanel.add((Component)searchButton, searchGCC);
        optionpanel.add(this.justLoadingFile);
        optionpanel.add(simpleSocketPanel);
        optionpanel.add(searchOptionPanel);
        optionpanel.add(this.chainsawSavedConfigOption);
        optionpanel.add(this.manualOption);
        this.add((Component)optionpanel, gc);
        gc.gridy = -1;
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.anchor = 14;
        this.add(Box.createVerticalStrut(20), gc);
        this.okButton.setMnemonic('O');
        final JCheckBox dontwarnIfNoReceiver = new JCheckBox("\u6b21\u56de\u306f\u8868\u793a\u3057\u306a\u3044");
        JPanel okPanel = new JPanel();
        okPanel.add(dontwarnIfNoReceiver);
        okPanel.add(this.okButton);
        this.add((Component)okPanel, gc);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NoReceiversWarningPanel.this.dontWarnMeAgain = dontwarnIfNoReceiver.isSelected();
            }
        });
    }

    private URL browseForConfig() throws MalformedURLException {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle("\u65e2\u5b58\u306e\u30ec\u30b7\u30fc\u30d0\u30fc\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u3092\u4f7f\u3046...");
        chooser.setDialogType(0);
        chooser.setFileFilter(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".properties") || f.getName().endsWith(".xml");
            }

            public String getDescription() {
                return "Log4j\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb";
            }
        });
        chooser.showOpenDialog(this);
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile == null) {
            return null;
        }
        if (!selectedFile.exists() || !selectedFile.canRead()) {
            return null;
        }
        return chooser.getSelectedFile().toURI().toURL();
    }

    private boolean isValidConfigURL() {
        if (this.previousConfigs.getSelectedItem() == null) {
            return false;
        }
        String urlString = this.previousConfigs.getSelectedItem().toString();
        try {
            this.getModel().configUrl = new URL(urlString);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new NoReceiversWarningPanel());
        frame.setDefaultCloseOperation(3);
        frame.pack();
        frame.setVisible(true);
    }

    public final boolean isDontWarnMeAgain() {
        return this.dontWarnMeAgain;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PanelModel {
        private URL configUrl;
        private File file = new File(SettingsManager.getInstance().getSettingsDirectory(), "receiver-configs.xml");

        boolean isLoadLogFile() {
            return NoReceiversWarningPanel.this.justLoadingFile.isSelected();
        }

        boolean isSimpleReceiverMode() {
            return NoReceiversWarningPanel.this.simpleReceiver.isSelected();
        }

        int getSimplePort() {
            return ((PortBased)NoReceiversWarningPanel.this.simplePortModel.getSelectedItem()).getPort();
        }

        Class getSimpleReceiverClass() {
            return (Class)NoReceiversWarningPanel.this.simpleReceiverModel.getSelectedItem();
        }

        boolean isLoadConfig() {
            return NoReceiversWarningPanel.this.searchOption.isSelected();
        }

        boolean isLoadSavedConfigs() {
            return NoReceiversWarningPanel.this.chainsawSavedConfigOption.isSelected();
        }

        boolean isManualMode() {
            return NoReceiversWarningPanel.this.manualOption.isSelected();
        }

        public Object[] getRememberedConfigs() {
            Object[] urls = new Object[NoReceiversWarningPanel.this.configModel.getSize()];
            for (int i = 0; i < NoReceiversWarningPanel.this.configModel.getSize(); ++i) {
                urls[i] = NoReceiversWarningPanel.this.configModel.getElementAt(i);
            }
            return urls;
        }

        public void setRememberedConfigs(final Object[] configs) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ((PanelModel)PanelModel.this).NoReceiversWarningPanel.this.configModel.removeAllElements();
                    for (int i = 0; i < configs.length; ++i) {
                        ((PanelModel)PanelModel.this).NoReceiversWarningPanel.this.configModel.addElement(configs[i]);
                    }
                }
            });
        }

        URL getConfigToLoad() {
            return this.configUrl;
        }

        boolean isChinsawConfigFileExists() {
            return this.file.exists();
        }

        URL getSavedConfigToLoad() {
            try {
                if (this.file.exists()) {
                    return this.file.toURL();
                }
                NoReceiversWarningPanel.this.logger.debug((Object)"\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093");
            }
            catch (MalformedURLException e) {
                NoReceiversWarningPanel.this.logger.error((Object)"Chainsaw\u304c\u4fdd\u5b58\u3057\u305f\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u8aad\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
            }
            return null;
        }
    }
}

