/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.ExpressionRuleContext;
import org.apache.log4j.chainsaw.JTextComponentFormatter;
import org.apache.log4j.chainsaw.LogPanel;
import org.apache.log4j.chainsaw.LogPanelLoggerTreeModel;
import org.apache.log4j.chainsaw.LogPanelPreferenceModel;
import org.apache.log4j.chainsaw.PopupListener;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.SmallToggleButton;
import org.apache.log4j.chainsaw.color.RuleColorizer;
import org.apache.log4j.chainsaw.filter.FilterModel;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.icons.LineIconFactory;
import org.apache.log4j.rule.AbstractRule;
import org.apache.log4j.rule.ColorRule;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

final class LoggerNameTreePanel
extends JPanel {
    private static final int WARN_DEPTH = 4;
    private LoggerNameTreeCellRenderer cellRenderer = new LoggerNameTreeCellRenderer();
    private final Action clearIgnoreListAction;
    private final Action closeAction;
    private final JButton closeButton = new SmallButton();
    private final Action collapseAction;
    private final JButton collapseButton = new SmallButton();
    private final Action editLoggerAction;
    private final JButton editLoggerButton = new SmallButton();
    private final Action expandAction;
    private final Action findNextAction;
    private final Action clearFindNextAction;
    private final Action defineColorRuleForLoggerAction;
    private final Action setRefineFocusAction;
    private final Action updateRefineFocusAction;
    private final JButton expandButton = new SmallButton();
    private final Action focusOnAction;
    private final Action clearRefineFocusAction;
    private final SmallToggleButton focusOnLoggerButton = new SmallToggleButton();
    private final Set hiddenSet = new HashSet();
    private final Action hideAction;
    private final Action hideSubLoggersAction;
    private final LogPanelPreferenceModel preferenceModel;
    private final JList ignoreList = new JList();
    private final JEditorPane ignoreExpressionEntryField = new JEditorPane();
    private final JScrollPane ignoreListScroll = new JScrollPane(this.ignoreList);
    private final JDialog ignoreDialog = new JDialog();
    private final JDialog ignoreExpressionDialog = new JDialog();
    private final JLabel ignoreSummary = new JLabel("0 \u975e\u8868\u793a\u30ed\u30b0");
    private final JLabel ignoreExpressionSummary = new JLabel("\u5f0f\u3092\u7121\u8996");
    private final SmallToggleButton ignoreLoggerButton = new SmallToggleButton();
    private final EventListenerList listenerList = new EventListenerList();
    private final JTree logTree;
    private final Logger logger = LogManager.getLogger((Class)(class$org$apache$log4j$chainsaw$LoggerNameTreePanel == null ? (class$org$apache$log4j$chainsaw$LoggerNameTreePanel = LoggerNameTreePanel.class$("org.apache.log4j.chainsaw.LoggerNameTreePanel")) : class$org$apache$log4j$chainsaw$LoggerNameTreePanel));
    private final LogPanelLoggerTreeModel logTreeModel;
    private final PopupListener popupListener;
    private final LoggerTreePopupMenu popupMenu;
    private final VisibilityRuleDelegate visibilityRuleDelegate;
    private Rule colorRuleDelegate;
    private final JScrollPane scrollTree;
    private final JToolBar toolbar = new JToolBar();
    private final LogPanel logPanel;
    private final RuleColorizer colorizer;
    private Rule ignoreExpressionRule;
    private FilterModel filterModel;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$LoggerNameTreePanel;
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    LoggerNameTreePanel(LogPanelLoggerTreeModel logTreeModel, LogPanelPreferenceModel preferenceModel, LogPanel logPanel, RuleColorizer colorizer, FilterModel filterModel) {
        this.logTreeModel = logTreeModel;
        this.preferenceModel = preferenceModel;
        this.logPanel = logPanel;
        this.colorizer = colorizer;
        this.filterModel = filterModel;
        this.setLayout(new BorderLayout());
        this.ignoreExpressionEntryField.setPreferredSize(new Dimension(300, 150));
        JTextComponentFormatter.applySystemFontAndSize(this.ignoreExpressionEntryField);
        this.visibilityRuleDelegate = new VisibilityRuleDelegate();
        this.colorRuleDelegate = new AbstractRule(){

            public boolean evaluate(LoggingEvent e, Map matches) {
                boolean hiddenLogger = e.getLoggerName() != null && LoggerNameTreePanel.this.isHiddenLogger(e.getLoggerName());
                boolean hiddenExpression = LoggerNameTreePanel.this.ignoreExpressionRule != null && LoggerNameTreePanel.this.ignoreExpressionRule.evaluate(e, null);
                boolean hidden = hiddenLogger || hiddenExpression;
                String currentlySelectedLoggerName = LoggerNameTreePanel.this.getCurrentlySelectedLoggerName();
                if (!(LoggerNameTreePanel.this.isFocusOnSelected() || hidden || currentlySelectedLoggerName == null || "".equals(currentlySelectedLoggerName))) {
                    return e.getLoggerName().startsWith(currentlySelectedLoggerName + ".") || e.getLoggerName().endsWith(currentlySelectedLoggerName);
                }
                return false;
            }
        };
        this.logTree = new JTree(logTreeModel){

            public String getToolTipText(MouseEvent ev) {
                if (ev == null) {
                    return null;
                }
                TreePath path = LoggerNameTreePanel.this.logTree.getPathForLocation(ev.getX(), ev.getY());
                String loggerName = LoggerNameTreePanel.this.getLoggerName(path);
                if (LoggerNameTreePanel.this.hiddenSet.contains(loggerName)) {
                    loggerName = loggerName + " (you are ignoring this logger)";
                }
                return loggerName;
            }
        };
        ToolTipManager.sharedInstance().registerComponent(this.logTree);
        this.logTree.setCellRenderer(this.cellRenderer);
        logTreeModel.addTreeModelListener(new TreeModelListener(){
            private boolean latched = false;

            public void treeNodesChanged(TreeModelEvent e) {
            }

            public void treeNodesInserted(TreeModelEvent e) {
                if (!this.latched) {
                    LoggerNameTreePanel.this.ensureRootExpanded();
                    this.latched = true;
                }
            }

            public void treeNodesRemoved(TreeModelEvent e) {
            }

            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
        this.logTree.setEditable(false);
        DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
        selectionModel.setSelectionMode(1);
        this.logTree.setSelectionModel(selectionModel);
        this.logTree.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.scrollTree = new JScrollPane(this.logTree);
        this.toolbar.setLayout(new BoxLayout(this.toolbar, 0));
        this.expandAction = this.createExpandAction();
        this.findNextAction = this.createFindNextAction();
        this.clearFindNextAction = this.createClearFindNextAction();
        this.defineColorRuleForLoggerAction = this.createDefineColorRuleForLoggerAction();
        this.clearRefineFocusAction = this.createClearRefineFocusAction();
        this.setRefineFocusAction = this.createSetRefineFocusAction();
        this.updateRefineFocusAction = this.createUpdateRefineFocusAction();
        this.editLoggerAction = this.createEditLoggerAction();
        this.closeAction = this.createCloseAction();
        this.collapseAction = this.createCollapseAction();
        this.focusOnAction = this.createFocusOnAction();
        this.hideAction = this.createIgnoreAction();
        this.hideSubLoggersAction = this.createIgnoreAllAction();
        this.clearIgnoreListAction = this.createClearIgnoreListAction();
        this.popupMenu = new LoggerTreePopupMenu();
        this.popupListener = new PopupListener(this.popupMenu);
        this.setupListeners();
        this.configureToolbarPanel();
        this.add((Component)this.toolbar, "North");
        this.add((Component)this.scrollTree, "Center");
        this.ignoreDialog.setTitle("\u975e\u8868\u793a\uff0f\u7121\u8996\u30ed\u30b0");
        this.ignoreDialog.setModal(true);
        this.ignoreExpressionDialog.setTitle("\u975e\u8868\u793a\uff0f\u7121\u8996\u5f0f");
        this.ignoreExpressionDialog.setModal(true);
        JPanel ignorePanel = new JPanel();
        ignorePanel.setLayout(new BoxLayout(ignorePanel, 1));
        JPanel ignoreSummaryPanel = new JPanel(new FlowLayout(0));
        ignoreSummaryPanel.add(this.ignoreSummary);
        AbstractAction showIgnoreDialogAction = new AbstractAction("..."){

            public void actionPerformed(ActionEvent e) {
                LogPanel.centerAndSetVisible(LoggerNameTreePanel.this.ignoreDialog);
            }
        };
        AbstractAction showIgnoreExpressionDialogAction = new AbstractAction("..."){

            public void actionPerformed(ActionEvent e) {
                LogPanel.centerAndSetVisible(LoggerNameTreePanel.this.ignoreExpressionDialog);
            }
        };
        showIgnoreDialogAction.putValue("ShortDescription", "\u30ed\u30b0\u306e\u975e\u8868\u793a\uff0f\u7121\u8996\u3092\u8868\u793a\u53ca\u3073\u7ba1\u7406\u3059\u308b\u5834\u5408\u306f\u30af\u30ea\u30c3\u30af\u3057\u3066\u304f\u3060\u3055\u3044");
        SmallButton btnShowIgnoreDialog = new SmallButton(showIgnoreDialogAction);
        ignoreSummaryPanel.add(btnShowIgnoreDialog);
        ignorePanel.add(ignoreSummaryPanel);
        JPanel ignoreExpressionPanel = new JPanel(new FlowLayout(0));
        ignoreExpressionPanel.add(this.ignoreExpressionSummary);
        showIgnoreExpressionDialogAction.putValue("ShortDescription", "\u975e\u8868\u793a\uff0f\u7121\u8996\u5f0f\u3092\u8868\u793a\u53ca\u3073\u7ba1\u7406\u3059\u308b\u5834\u5408\u306f\u30af\u30ea\u30c3\u30af\u3057\u3066\u304f\u3060\u3055\u3044");
        SmallButton btnShowIgnoreExpressionDialog = new SmallButton(showIgnoreExpressionDialogAction);
        ignoreExpressionPanel.add(btnShowIgnoreExpressionDialog);
        ignorePanel.add(ignoreExpressionPanel);
        this.add((Component)ignorePanel, "South");
        this.ignoreList.setModel(new DefaultListModel());
        this.ignoreList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                int index;
                if (e.getClickCount() > 1 && (e.getModifiers() & 0x10) > 0 && (index = LoggerNameTreePanel.this.ignoreList.locationToIndex(e.getPoint())) >= 0) {
                    String string = LoggerNameTreePanel.this.ignoreList.getModel().getElementAt(index).toString();
                    LoggerNameTreePanel.this.toggleHiddenLogger(string);
                    LoggerNameTreePanel.this.fireChangeEvent();
                    LoggerNameTreePanel.this.logTreeModel.nodeStructureChanged((TreeNode)LoggerNameTreePanel.this.logTreeModel.getRoot());
                }
            }
        });
        JPanel ignoreListPanel = new JPanel(new BorderLayout());
        this.ignoreListScroll.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\u9805\u76ee\u3092\u30c0\u30d6\u30eb\u30af\u30ea\u30c3\u30af\u3059\u308b\u3068\u8868\u793a\u3055\u308c\u307e\u3059"));
        ignoreListPanel.add((Component)this.ignoreListScroll, "Center");
        JPanel ignoreExpressionDialogPanel = new JPanel(new BorderLayout());
        this.ignoreExpressionEntryField.addKeyListener(new ExpressionRuleContext(filterModel, this.ignoreExpressionEntryField));
        ignoreExpressionDialogPanel.add((Component)new JScrollPane(this.ignoreExpressionEntryField), "Center");
        JButton ignoreExpressionCloseButton = new JButton(new AbstractAction("\u9589\u3058\u308b"){

            public void actionPerformed(ActionEvent e) {
                String ignoreText = LoggerNameTreePanel.this.ignoreExpressionEntryField.getText();
                if (LoggerNameTreePanel.this.updateIgnoreExpression(ignoreText)) {
                    LoggerNameTreePanel.this.ignoreExpressionDialog.setVisible(false);
                }
            }
        });
        JPanel closePanel = new JPanel();
        closePanel.add(ignoreExpressionCloseButton);
        ignoreExpressionDialogPanel.add((Component)closePanel, "South");
        Box ignoreListButtonPanel = Box.createHorizontalBox();
        JButton unhideAll = new JButton(new AbstractAction("\u3059\u3079\u3066\u8868\u793a"){

            public void actionPerformed(final ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        LoggerNameTreePanel.this.clearIgnoreListAction.actionPerformed(e);
                    }
                });
            }
        });
        ignoreListButtonPanel.add(unhideAll);
        ignoreListButtonPanel.add(Box.createHorizontalGlue());
        JButton ignoreCloseButton = new JButton(new AbstractAction("\u9589\u3058\u308b"){

            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.ignoreDialog.setVisible(false);
            }
        });
        ignoreListButtonPanel.add(ignoreCloseButton);
        ignoreListPanel.add((Component)ignoreListButtonPanel, "South");
        this.ignoreDialog.getContentPane().add(ignoreListPanel);
        this.ignoreDialog.pack();
        this.ignoreExpressionDialog.getContentPane().add(ignoreExpressionDialogPanel);
        this.ignoreExpressionDialog.pack();
    }

    private boolean updateIgnoreExpression(String ignoreText) {
        try {
            this.ignoreExpressionRule = ignoreText != null && !ignoreText.trim().equals("") ? ExpressionRule.getRule((String)ignoreText) : null;
            this.visibilityRuleDelegate.firePropertyChange("hiddenSet", null, null);
            this.updateAllIgnoreStuff();
            this.ignoreExpressionEntryField.setBackground(UIManager.getColor("TextField.background"));
            return true;
        }
        catch (IllegalArgumentException iae) {
            this.ignoreExpressionEntryField.setToolTipText(iae.getMessage());
            this.ignoreExpressionEntryField.setBackground(ChainsawConstants.INVALID_EXPRESSION_BACKGROUND);
            return false;
        }
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = LoggerNameTreePanel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    public Rule getLoggerColorRule() {
        return this.colorRuleDelegate;
    }

    public Rule getLoggerVisibilityRule() {
        return this.visibilityRuleDelegate;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = LoggerNameTreePanel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    public void setFocusOn(String newLogger) {
        LogPanelLoggerTreeModel.LogPanelTreeNode node = this.logTreeModel.lookupLogger(newLogger);
        if (node != null) {
            Object[] nodes = node.getPath();
            TreePath treePath = new TreePath(nodes);
            this.logTree.setSelectionPath(treePath);
            if (!this.focusOnLoggerButton.isSelected()) {
                this.focusOnLoggerButton.doClick();
            }
        } else {
            this.logger.error((Object)("failed to lookup logger " + newLogger));
        }
    }

    private boolean isHiddenLogger(String loggerName) {
        Iterator iter = this.hiddenSet.iterator();
        while (iter.hasNext()) {
            String hiddenLoggerEntry = iter.next().toString();
            if (!loggerName.startsWith(hiddenLoggerEntry + ".") && !loggerName.endsWith(hiddenLoggerEntry)) continue;
            return true;
        }
        return false;
    }

    protected void toggleHiddenLogger(String logger) {
        if (!this.hiddenSet.contains(logger)) {
            this.hiddenSet.add(logger);
        } else {
            this.hiddenSet.remove(logger);
        }
        this.visibilityRuleDelegate.firePropertyChange("hiddenSet", null, null);
    }

    String getCurrentlySelectedLoggerName() {
        TreePath[] paths = this.logTree.getSelectionPaths();
        if (paths == null || paths.length == 0) {
            return null;
        }
        TreePath firstPath = paths[0];
        return this.getLoggerName(firstPath);
    }

    String getLoggerName(TreePath path) {
        if (path != null) {
            Object[] objects = path.getPath();
            StringBuffer buf = new StringBuffer();
            for (int i = 1; i < objects.length; ++i) {
                buf.append(objects[i].toString());
                if (i >= objects.length - 1) continue;
                buf.append(".");
            }
            return buf.toString();
        }
        return null;
    }

    void ignore(Collection fqnLoggersToIgnore) {
        this.hiddenSet.addAll(fqnLoggersToIgnore);
        this.visibilityRuleDelegate.firePropertyChange("hiddenSet", null, null);
        this.fireChangeEvent();
    }

    boolean isFocusOnSelected() {
        return this.focusOnAction.getValue("checked") != null;
    }

    void setFocusOnSelected(boolean selected) {
        if (selected) {
            this.focusOnAction.putValue("checked", Boolean.TRUE);
        } else {
            this.focusOnAction.putValue("checked", null);
        }
    }

    private void collapseCurrentlySelectedNode() {
        TreePath[] paths = this.logTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        this.logger.debug((Object)"Collapsing all children of selected node");
        for (int i = 0; i < paths.length; ++i) {
            TreePath path = paths[i];
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Enumeration<TreeNode> enumeration = node.depthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumeration.nextElement();
                if (child.getParent() == null || child == node) continue;
                Object[] nodes = ((DefaultMutableTreeNode)child.getParent()).getPath();
                TreePath treePath = new TreePath(nodes);
                this.logTree.collapsePath(treePath);
            }
        }
        this.ensureRootExpanded();
    }

    private void configureToolbarPanel() {
        this.toolbar.setFloatable(false);
        this.expandButton.setAction(this.expandAction);
        this.expandButton.setText(null);
        this.collapseButton.setAction(this.collapseAction);
        this.collapseButton.setText(null);
        this.focusOnLoggerButton.setAction(this.focusOnAction);
        this.focusOnLoggerButton.setText(null);
        this.ignoreLoggerButton.setAction(this.hideAction);
        this.ignoreLoggerButton.setText(null);
        this.expandButton.setFont(this.expandButton.getFont().deriveFont(1));
        this.collapseButton.setFont(this.collapseButton.getFont().deriveFont(1));
        this.editLoggerButton.setAction(this.editLoggerAction);
        this.editLoggerButton.setText(null);
        this.closeButton.setAction(this.closeAction);
        this.closeButton.setText(null);
        this.toolbar.add(this.expandButton);
        this.toolbar.add(this.collapseButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.focusOnLoggerButton);
        this.toolbar.add(this.ignoreLoggerButton);
        this.toolbar.addSeparator();
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.add(this.closeButton);
        this.toolbar.add(Box.createHorizontalStrut(5));
    }

    private Action createClearIgnoreListAction() {
        AbstractAction action = new AbstractAction("\u7121\u8996\u4e00\u89a7\u3092\u6d88\u53bb", null){

            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.ignoreLoggerButton.setSelected(false);
                LoggerNameTreePanel.this.logTreeModel.reload();
                LoggerNameTreePanel.this.hiddenSet.clear();
                LoggerNameTreePanel.this.fireChangeEvent();
            }
        };
        action.putValue("ShortDescription", "\u7121\u8996\u4e00\u89a7\u304b\u3089\u3059\u3079\u3066\u306e\u9805\u76ee\u3092\u6d88\u53bb\u3059\u308b\u3002\u3059\u3079\u3066\u306e\u30a4\u30d9\u30f3\u30c8\u304c\u30d3\u30e5\u30fc\u306b\u8868\u793a\u3055\u308c\u307e\u3059");
        return action;
    }

    private Action createCloseAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.preferenceModel.setLogTreePanelVisible(false);
            }
        };
        action.putValue("Name", "\u9589\u3058\u308b");
        action.putValue("ShortDescription", "\u30ed\u30b0\u30d1\u30cd\u30eb\u3092\u9589\u3058\u308b");
        action.putValue("SmallIcon", LineIconFactory.createCloseIcon());
        return action;
    }

    private Action createCollapseAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.collapseCurrentlySelectedNode();
            }
        };
        action.putValue("SmallIcon", LineIconFactory.createCollapseIcon());
        action.putValue("Name", "\u30d6\u30e9\u30f3\u30c1\u3092\u7573\u3080");
        action.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u30ce\u30fc\u30c9\u306e\u3059\u3079\u3066\u306e\u5b50\u3092\u7573\u3080");
        action.setEnabled(false);
        return action;
    }

    private Action createEditLoggerAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
            }
        };
        action.putValue("enabled", Boolean.FALSE);
        action.putValue("Name", "\u30d5\u30a3\u30eb\u30bf\uff0f\u8272\u3092\u7de8\u96c6");
        action.putValue("ShortDescription", "\u3053\u306e\u30ed\u30b0\u306e\u30d5\u30a3\u30eb\u30bf\u3068\u8272\u4ed8\u3051\u3092\u8a2d\u5b9a\u3059\u308b");
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ICON_EDIT_RECEIVER));
        action.setEnabled(false);
        return action;
    }

    private Action createExpandAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.expandCurrentlySelectedNode();
            }
        };
        action.putValue("SmallIcon", LineIconFactory.createExpandIcon());
        action.putValue("Name", "\u30d6\u30e9\u30f3\u30c1\u3092\u5c55\u958b");
        action.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u30ce\u30fc\u30c9\u3092\u518d\u5e30\u7684\u306b\u3059\u3079\u3066\u5c55\u958b\u3059\u308b");
        action.setEnabled(false);
        return action;
    }

    private Action createFindNextAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.findNextUsingCurrentlySelectedNode();
            }
        };
        action.putValue("Name", "\u6b21\u3092\u691c\u7d22");
        action.putValue("ShortDescription", "\u9078\u629e\u30ce\u30fc\u30c9\u3092\u691c\u7d22\u3059\u308b");
        action.setEnabled(false);
        return action;
    }

    private Action createSetRefineFocusAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.setRefineFocusUsingCurrentlySelectedNode();
            }
        };
        action.putValue("Name", "\u9078\u629e\u3055\u308c\u305f\u30ed\u30b0\u306e\u8a73\u7d30\u3092\u8a2d\u5b9a");
        action.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u30ce\u30fc\u30c9\u306e\u8a73\u7d30\u3092\u8868\u793a\u3059\u308b");
        action.setEnabled(false);
        return action;
    }

    private Action createUpdateRefineFocusAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.updateRefineFocusUsingCurrentlySelectedNode();
            }
        };
        action.putValue("Name", "\u9078\u629e\u3055\u308c\u305f\u30ed\u30b0\u306e\u8a73\u7d30\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u66f4\u65b0");
        action.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u30ce\u30fc\u30c9\u3092\u8a73\u7d30\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u8ffd\u52a0\u3059\u308b");
        action.setEnabled(false);
        return action;
    }

    private void updateRefineFocusUsingCurrentlySelectedNode() {
        String selectedLogger = this.getCurrentlySelectedLoggerName();
        TreePath[] paths = this.logTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        String currentFilterText = this.logPanel.getRefineFocusText();
        this.logPanel.setRefineFocusText(currentFilterText + " || logger ~= " + selectedLogger);
    }

    private void setRefineFocusUsingCurrentlySelectedNode() {
        String selectedLogger = this.getCurrentlySelectedLoggerName();
        TreePath[] paths = this.logTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        this.logPanel.setRefineFocusText("logger ~= " + selectedLogger);
    }

    private Action createDefineColorRuleForLoggerAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                String selectedLogger = LoggerNameTreePanel.this.getCurrentlySelectedLoggerName();
                TreePath[] paths = LoggerNameTreePanel.this.logTree.getSelectionPaths();
                if (paths == null) {
                    return;
                }
                Color c = JColorChooser.showDialog(LoggerNameTreePanel.this.getRootPane(), "\u8272\u306e\u9078\u629e", Color.red);
                if (c != null) {
                    String expression = "logger like '^" + selectedLogger + ".*'";
                    LoggerNameTreePanel.this.colorizer.addRule("\u30c7\u30d5\u30a9\u30eb\u30c8", new ColorRule(expression, ExpressionRule.getRule((String)expression), c, ChainsawConstants.COLOR_DEFAULT_FOREGROUND));
                }
            }
        };
        action.putValue("Name", "\u9078\u629e\u3055\u308c\u305f\u30ed\u30b0\u306e\u8272\u30eb\u30fc\u30eb\u3092\u5b9a\u7fa9\u3059\u308b");
        action.putValue("ShortDescription", "\u30ed\u30b0\u306e\u8272\u30eb\u30fc\u30eb\u3092\u5b9a\u7fa9\u3059\u308b");
        action.setEnabled(false);
        return action;
    }

    private Action createClearFindNextAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.clearFindNext();
            }
        };
        action.putValue("Name", "\u691c\u7d22\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u6d88\u53bb");
        action.putValue("ShortDescription", "\u691c\u7d22\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u6d88\u53bb");
        action.setEnabled(false);
        return action;
    }

    private Action createClearRefineFocusAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.clearRefineFocus();
            }
        };
        action.putValue("Name", "\u8a73\u7d30\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u6d88\u53bb\u3059\u308b");
        action.putValue("ShortDescription", "\u8a73\u7d30\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u6d88\u53bb\u3059\u308b");
        action.setEnabled(false);
        return action;
    }

    private Action createFocusOnAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LoggerNameTreePanel.this.toggleFocusOnState();
            }
        };
        action.putValue("Name", "\u30d5\u30a9\u30fc\u30ab\u30b9");
        action.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u30ed\u30b0\u306b\u6ce8\u76ee\u3067\u304d\u308b\u3088\u3046\u306b\u3001\u30d5\u30a3\u30eb\u30bf\u3092\u8a2d\u5b9a\u3057\u3066\u4ed6\u30ed\u30b0\u3092\u975e\u8868\u793a\u306b\u3059\u308b");
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.WINDOW_ICON));
        action.setEnabled(false);
        return action;
    }

    private Action createIgnoreAllAction() {
        AbstractAction action = new AbstractAction("\u9078\u629e\u4ee5\u964d\u306e\u30ed\u30b0\u3092\u7121\u8996"){

            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode root;
                TreePath[] paths = LoggerNameTreePanel.this.logTree.getSelectionPaths();
                String parentPathString = "";
                if (paths == null || paths.length == 0) {
                    root = (DefaultMutableTreeNode)LoggerNameTreePanel.this.logTreeModel.getRoot();
                } else {
                    root = (DefaultMutableTreeNode)LoggerNameTreePanel.this.logTree.getSelectionPath().getLastPathComponent();
                    TreeNode[] path = root.getPath();
                    for (int i = 1; i < path.length; ++i) {
                        if (i > 1) {
                            parentPathString = parentPathString + ".";
                        }
                        parentPathString = parentPathString + path[i].toString();
                    }
                    if (!parentPathString.equals("")) {
                        parentPathString = parentPathString + ".";
                    }
                }
                Enumeration<TreeNode> topLevelLoggersEnumeration = root.children();
                HashSet<String> topLevelLoggersSet = new HashSet<String>();
                while (topLevelLoggersEnumeration.hasMoreElements()) {
                    String thisLogger = topLevelLoggersEnumeration.nextElement().toString();
                    topLevelLoggersSet.add(parentPathString + thisLogger);
                }
                if (topLevelLoggersSet.size() > 0) {
                    LoggerNameTreePanel.this.ignore(topLevelLoggersSet);
                }
                LoggerNameTreePanel.this.logTreeModel.nodeChanged(root);
                LoggerNameTreePanel.this.ignoreLoggerButton.setSelected(false);
                LoggerNameTreePanel.this.focusOnAction.setEnabled(false);
                ((LoggerNameTreePanel)LoggerNameTreePanel.this).popupMenu.hideCheck.setSelected(false);
                LoggerNameTreePanel.this.fireChangeEvent();
            }
        };
        action.putValue("ShortDescription", "\u3059\u3079\u3066\u306e\u30ed\u30b0\u3092\u7121\u8996\u4e00\u89a7\u306b\u8ffd\u52a0(\u30d3\u30e5\u30fc\u306b\u8868\u793a\u3057\u305f\u3044\u30ed\u30b0\u306f\u8868\u793a\u3059\u308b\u3088\u3046\u306b\u8a2d\u5b9a\u3057\u3066\u304f\u3060\u3055\u3044)");
        return action;
    }

    private Action createIgnoreAction() {
        AbstractAction action = new AbstractAction("Ignore this Logger", new ImageIcon(ChainsawIcons.ICON_COLLAPSE)){

            public void actionPerformed(ActionEvent e) {
                String logger = LoggerNameTreePanel.this.getCurrentlySelectedLoggerName();
                if (logger != null) {
                    LoggerNameTreePanel.this.toggleHiddenLogger(logger);
                    LoggerNameTreePanel.this.logTreeModel.nodeChanged((TreeNode)LoggerNameTreePanel.this.logTree.getSelectionPath().getLastPathComponent());
                    LoggerNameTreePanel.this.ignoreLoggerButton.setSelected(LoggerNameTreePanel.this.hiddenSet.contains(logger));
                    LoggerNameTreePanel.this.focusOnAction.setEnabled(!LoggerNameTreePanel.this.hiddenSet.contains(logger));
                    ((LoggerNameTreePanel)LoggerNameTreePanel.this).popupMenu.hideCheck.setSelected(LoggerNameTreePanel.this.hiddenSet.contains(logger));
                }
                LoggerNameTreePanel.this.fireChangeEvent();
            }
        };
        action.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u30ed\u30b0\u3092\u7121\u8996\u4e00\u89a7\u306b\u8ffd\u52a0\u3057\u3001\u30d3\u30e5\u30fc\u304b\u3089\u30a4\u30d9\u30f3\u30c8\u3092\u30d5\u30a3\u30eb\u30bf\u3059\u308b");
        return action;
    }

    private void ensureRootExpanded() {
        this.logger.debug((Object)"Ensuring Root node is expanded.");
        final DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.logTreeModel.getRoot();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LoggerNameTreePanel.this.logTree.expandPath(new TreePath(root));
            }
        });
    }

    private void findNextUsingCurrentlySelectedNode() {
        String selectedLogger = this.getCurrentlySelectedLoggerName();
        TreePath[] paths = this.logTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        this.visibilityRuleDelegate.firePropertyChange("searchExpression", null, "logger like '^" + selectedLogger + ".*'");
    }

    private void clearFindNext() {
        this.visibilityRuleDelegate.firePropertyChange("searchExpression", null, "");
    }

    private void clearRefineFocus() {
        this.logPanel.setRefineFocusText("");
    }

    private void expandCurrentlySelectedNode() {
        TreePath path;
        DefaultMutableTreeNode treeNode;
        Enumeration<TreeNode> depthEnum;
        TreePath[] paths = this.logTree.getSelectionPaths();
        if (paths == null) {
            return;
        }
        this.logger.debug((Object)"Expanding all children of selected node");
        for (int i = 0; i < paths.length && (depthEnum = (treeNode = (DefaultMutableTreeNode)(path = paths[i]).getLastPathComponent()).depthFirstEnumeration()).hasMoreElements(); ++i) {
            ArrayList<Integer> depths = new ArrayList<Integer>();
            while (depthEnum.hasMoreElements()) {
                depths.add(new Integer(((DefaultMutableTreeNode)depthEnum.nextElement()).getDepth()));
            }
            Collections.sort(depths);
            Collections.reverse(depths);
            int maxDepth = (Integer)depths.get(0);
            if (maxDepth > 4) {
                this.logger.warn((Object)("Should warn user, depth=" + maxDepth));
            }
            depthEnum = treeNode.depthFirstEnumeration();
            while (depthEnum.hasMoreElements()) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)depthEnum.nextElement();
                if (!node.isLeaf()) continue;
                Object[] nodes = ((DefaultMutableTreeNode)node.getParent()).getPath();
                TreePath treePath = new TreePath(nodes);
                this.logger.debug((Object)("Expanding path:" + treePath));
                this.logTree.expandPath(treePath);
            }
        }
    }

    private void fireChangeEvent() {
        ChangeListener[] listeners = (ChangeListener[])this.listenerList.getListeners(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = LoggerNameTreePanel.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener);
        ChangeEvent e = null;
        for (int i = 0; i < listeners.length; ++i) {
            if (e == null) {
                e = new ChangeEvent(this);
            }
            listeners[i].stateChanged(e);
        }
    }

    private void reconfigureMenuText() {
        String logger = this.getCurrentlySelectedLoggerName();
        if (logger == null || logger.length() == 0) {
            this.focusOnAction.putValue("Name", "\u30d5\u30a9\u30fc\u30ab\u30b9...");
            this.hideAction.putValue("Name", "\u7121\u8996...");
            this.findNextAction.putValue("Name", "\u691c\u7d22...");
            this.setRefineFocusAction.putValue("Name", "\u8a73\u7d30\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u8a2d\u5b9a");
            this.updateRefineFocusAction.putValue("Name", "\u8a73\u7d30\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u8ffd\u52a0");
            this.defineColorRuleForLoggerAction.putValue("Name", "\u8272\u30eb\u30fc\u30eb\u3092\u5b9a\u7fa9");
        } else {
            this.focusOnAction.putValue("Name", "\u30d5\u30a9\u30fc\u30ab\u30b9 '" + logger + "'");
            this.hideAction.putValue("Name", "\u7121\u8996 '" + logger + "'");
            this.findNextAction.putValue("Name", "\u691c\u7d22 '" + logger + "'");
            this.setRefineFocusAction.putValue("Name", "\u8a73\u7d30\u30d5\u30a3\u30fc\u30eb\u30c9 '" + logger + "'");
            this.updateRefineFocusAction.putValue("Name", "\u8a73\u7d30\u30d5\u30a3\u30fc\u30eb '" + logger + "' \u3092\u8ffd\u52a0");
            this.defineColorRuleForLoggerAction.putValue("Name", "\u8272\u30eb\u30fc\u30eb\u3092\u5b9a\u7fa9 '" + logger + "'");
        }
        this.hideSubLoggersAction.putValue("Name", "\u9078\u629e\u4ee5\u964d\u306e\u30ed\u30b0\u3092\u7121\u8996");
        this.focusOnLoggerButton.setText(null);
        this.ignoreLoggerButton.setText(null);
    }

    private void setupListeners() {
        this.logTree.addMouseMotionListener(new MouseKeyIconListener());
        this.logTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getNewLeadSelectionPath();
                TreeNode node = null;
                if (path != null) {
                    node = (TreeNode)path.getLastPathComponent();
                }
                boolean focusOnSelected = LoggerNameTreePanel.this.isFocusOnSelected();
                String logger = LoggerNameTreePanel.this.getCurrentlySelectedLoggerName();
                LoggerNameTreePanel.this.focusOnAction.setEnabled(path != null && node != null && node.getParent() != null && !LoggerNameTreePanel.this.hiddenSet.contains(logger));
                LoggerNameTreePanel.this.hideAction.setEnabled(path != null && node != null && node.getParent() != null);
                if (!LoggerNameTreePanel.this.focusOnAction.isEnabled()) {
                    LoggerNameTreePanel.this.setFocusOnSelected(false);
                }
                LoggerNameTreePanel.this.expandAction.setEnabled(path != null);
                LoggerNameTreePanel.this.findNextAction.setEnabled(path != null);
                LoggerNameTreePanel.this.clearFindNextAction.setEnabled(true);
                LoggerNameTreePanel.this.defineColorRuleForLoggerAction.setEnabled(path != null);
                LoggerNameTreePanel.this.setRefineFocusAction.setEnabled(path != null);
                LoggerNameTreePanel.this.updateRefineFocusAction.setEnabled(path != null);
                LoggerNameTreePanel.this.clearRefineFocusAction.setEnabled(true);
                if (logger != null) {
                    boolean isHidden = LoggerNameTreePanel.this.hiddenSet.contains(logger);
                    ((LoggerNameTreePanel)LoggerNameTreePanel.this).popupMenu.hideCheck.setSelected(isHidden);
                    LoggerNameTreePanel.this.ignoreLoggerButton.setSelected(isHidden);
                }
                LoggerNameTreePanel.this.collapseAction.setEnabled(path != null);
                LoggerNameTreePanel.this.reconfigureMenuText();
                if (LoggerNameTreePanel.this.isFocusOnSelected()) {
                    LoggerNameTreePanel.this.fireChangeEvent();
                }
                if (focusOnSelected && !LoggerNameTreePanel.this.isFocusOnSelected()) {
                    LoggerNameTreePanel.this.fireChangeEvent();
                }
                LoggerNameTreePanel.this.logPanel.repaint();
            }
        });
        this.logTree.addMouseListener(this.popupListener);
        this.focusOnAction.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                ((LoggerNameTreePanel)LoggerNameTreePanel.this).popupMenu.focusOnCheck.setSelected(LoggerNameTreePanel.this.isFocusOnSelected());
                LoggerNameTreePanel.this.focusOnLoggerButton.setSelected(LoggerNameTreePanel.this.isFocusOnSelected());
                if (LoggerNameTreePanel.this.logTree.getSelectionPath() != null) {
                    LoggerNameTreePanel.this.logTreeModel.nodeChanged((TreeNode)LoggerNameTreePanel.this.logTree.getSelectionPath().getLastPathComponent());
                }
            }
        });
        this.hideAction.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (LoggerNameTreePanel.this.logTree.getSelectionPath() != null) {
                    LoggerNameTreePanel.this.logTreeModel.nodeChanged((TreeNode)LoggerNameTreePanel.this.logTree.getSelectionPath().getLastPathComponent());
                }
            }
        });
        this.logTree.addMouseListener(new MouseFocusOnListener());
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                LoggerNameTreePanel.this.visibilityRuleDelegate.firePropertyChange("rule", null, null);
                LoggerNameTreePanel.this.updateAllIgnoreStuff();
            }
        });
        this.visibilityRuleDelegate.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getPropertyName().equals("hiddenSet")) {
                    LoggerNameTreePanel.this.updateAllIgnoreStuff();
                }
            }
        });
    }

    private void updateAllIgnoreStuff() {
        this.updateHiddenSetModels();
        this.updateIgnoreSummary();
        this.updateIgnoreExpressionSummary();
    }

    private void updateHiddenSetModels() {
        DefaultListModel model = (DefaultListModel)this.ignoreList.getModel();
        model.clear();
        ArrayList sortedIgnoreList = new ArrayList(this.hiddenSet);
        Collections.sort(sortedIgnoreList);
        Iterator iter = sortedIgnoreList.iterator();
        while (iter.hasNext()) {
            String string = (String)iter.next();
            model.addElement(string);
        }
    }

    private void updateIgnoreSummary() {
        this.ignoreSummary.setText(this.ignoreList.getModel().getSize() + " \u975e\u8868\u793a\u30ed\u30b0");
    }

    private void updateIgnoreExpressionSummary() {
        this.ignoreExpressionSummary.setText(this.ignoreExpressionRule != null ? "\u7121\u8996\u5f0f\uff08\u8a2d\u5b9a\uff09" : "\u7121\u8996\u5f0f\uff08\u89e3\u9664\uff09");
    }

    private void toggleFocusOnState() {
        this.setFocusOnSelected(!this.isFocusOnSelected());
        this.fireChangeEvent();
    }

    public Collection getHiddenSet() {
        return Collections.unmodifiableSet(this.hiddenSet);
    }

    public String getHiddenExpression() {
        String text = this.ignoreExpressionEntryField.getText();
        if (text == null || text.trim().equals("")) {
            return null;
        }
        return text.trim();
    }

    public void setHiddenExpression(String hiddenExpression) {
        this.ignoreExpressionEntryField.setText(hiddenExpression);
        this.updateIgnoreExpression(hiddenExpression);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class VisibilityRuleDelegate
    extends AbstractRule {
        VisibilityRuleDelegate() {
        }

        public boolean evaluate(LoggingEvent e, Map matches) {
            boolean result;
            boolean hidden;
            String currentlySelectedLoggerName = LoggerNameTreePanel.this.getCurrentlySelectedLoggerName();
            boolean hiddenLogger = e.getLoggerName() != null && LoggerNameTreePanel.this.isHiddenLogger(e.getLoggerName());
            boolean hiddenExpression = LoggerNameTreePanel.this.ignoreExpressionRule != null && LoggerNameTreePanel.this.ignoreExpressionRule.evaluate(e, null);
            boolean bl = hidden = hiddenLogger || hiddenExpression;
            if (currentlySelectedLoggerName == null) {
                return !hidden;
            }
            boolean bl2 = result = e.getLoggerName() != null && !hidden;
            if (result && LoggerNameTreePanel.this.isFocusOnSelected()) {
                result = e.getLoggerName() != null && (e.getLoggerName().startsWith(currentlySelectedLoggerName + ".") || e.getLoggerName().endsWith(currentlySelectedLoggerName));
            }
            return result;
        }

        public void firePropertyChange(String propertyName, Object oldVal, Object newVal) {
            super.firePropertyChange(propertyName, oldVal, newVal);
        }

        public void firePropertyChange(PropertyChangeEvent evt) {
            super.firePropertyChange(evt);
        }
    }

    private final class MouseKeyIconListener
    extends MouseMotionAdapter
    implements MouseMotionListener {
        Cursor focusOnCursor = Toolkit.getDefaultToolkit().createCustomCursor(ChainsawIcons.FOCUS_ON_ICON.getImage(), new Point(10, 10), "");
        Cursor ignoreCursor = Toolkit.getDefaultToolkit().createCustomCursor(ChainsawIcons.IGNORE_ICON.getImage(), new Point(10, 10), "");

        private MouseKeyIconListener() {
        }

        public void mouseMoved(MouseEvent e) {
            if ((e.getModifiers() & 2) > 0 && (e.getModifiers() & 1) > 0) {
                LoggerNameTreePanel.this.logTree.setCursor(this.ignoreCursor);
            } else if ((e.getModifiers() & 2) > 0) {
                LoggerNameTreePanel.this.logTree.setCursor(this.focusOnCursor);
            } else {
                LoggerNameTreePanel.this.logTree.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    private final class MouseFocusOnListener
    extends MouseAdapter {
        private MouseFocusOnListener() {
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() > 1 && (e.getModifiers() & 2) > 0 && (e.getModifiers() & 1) > 0) {
                this.ignoreLoggerAtPoint(e.getPoint());
                e.consume();
                LoggerNameTreePanel.this.fireChangeEvent();
            } else if (e.getClickCount() > 1 && (e.getModifiers() & 2) > 0) {
                this.focusAnLoggerAtPoint(e.getPoint());
                e.consume();
                LoggerNameTreePanel.this.fireChangeEvent();
            }
        }

        private void focusAnLoggerAtPoint(Point point) {
            String logger = this.getLoggerAtPoint(point);
            if (logger != null) {
                LoggerNameTreePanel.this.toggleFocusOnState();
            }
        }

        private String getLoggerAtPoint(Point point) {
            TreePath path = LoggerNameTreePanel.this.logTree.getPathForLocation(point.x, point.y);
            if (path != null) {
                return LoggerNameTreePanel.this.getLoggerName(path);
            }
            return null;
        }

        private void ignoreLoggerAtPoint(Point point) {
            String logger = this.getLoggerAtPoint(point);
            if (logger != null) {
                LoggerNameTreePanel.this.toggleHiddenLogger(logger);
                LoggerNameTreePanel.this.fireChangeEvent();
            }
        }
    }

    private class LoggerTreePopupMenu
    extends JPopupMenu {
        JCheckBoxMenuItem focusOnCheck = new JCheckBoxMenuItem();
        JCheckBoxMenuItem hideCheck = new JCheckBoxMenuItem();

        private LoggerTreePopupMenu() {
            this.initMenu();
        }

        public void show(Component invoker, int x, int y) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)LoggerNameTreePanel.this.logTree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            super.show(invoker, x, y);
        }

        private void initMenu() {
            this.focusOnCheck.setAction(LoggerNameTreePanel.this.focusOnAction);
            this.hideCheck.setAction(LoggerNameTreePanel.this.hideAction);
            this.add(LoggerNameTreePanel.this.expandAction);
            this.add(LoggerNameTreePanel.this.collapseAction);
            this.addSeparator();
            this.add(this.focusOnCheck);
            this.add(this.hideCheck);
            this.addSeparator();
            this.add(LoggerNameTreePanel.this.setRefineFocusAction);
            this.add(LoggerNameTreePanel.this.updateRefineFocusAction);
            this.add(LoggerNameTreePanel.this.clearRefineFocusAction);
            this.addSeparator();
            this.add(LoggerNameTreePanel.this.findNextAction);
            this.add(LoggerNameTreePanel.this.clearFindNextAction);
            this.addSeparator();
            this.add(LoggerNameTreePanel.this.defineColorRuleForLoggerAction);
            this.addSeparator();
            this.add(LoggerNameTreePanel.this.hideSubLoggersAction);
            this.add(LoggerNameTreePanel.this.clearIgnoreListAction);
        }
    }

    private class LoggerNameTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private LoggerNameTreeCellRenderer() {
            this.setLeafIcon(null);
            this.setOpaque(false);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean focus) {
            Font font2;
            JLabel component = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, focus);
            Font originalFont = new Font(component.getFont().getName(), component.getFont().getStyle(), component.getFont().getSize());
            int style = 0;
            if (sel && LoggerNameTreePanel.this.focusOnLoggerButton.isSelected()) {
                style |= 1;
            }
            String logger = LoggerNameTreePanel.this.getLoggerName(new TreePath(((DefaultMutableTreeNode)value).getPath()));
            if (LoggerNameTreePanel.this.hiddenSet.contains(logger)) {
                style |= 2;
            }
            if (originalFont != null && (font2 = originalFont.deriveFont(style)) != null) {
                component.setFont(font2);
            }
            return component;
        }
    }
}

