/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.EOFException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.MutableComboBoxModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.Document;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.ApplicationPreferenceModel;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.chainsaw.ChainsawCyclicBufferTableModel;
import org.apache.log4j.chainsaw.ChainsawStatusBar;
import org.apache.log4j.chainsaw.DockablePanel;
import org.apache.log4j.chainsaw.EventBatchListener;
import org.apache.log4j.chainsaw.EventContainer;
import org.apache.log4j.chainsaw.EventCountListener;
import org.apache.log4j.chainsaw.ExpressionRuleContext;
import org.apache.log4j.chainsaw.ExtendedLoggingEvent;
import org.apache.log4j.chainsaw.JSortTable;
import org.apache.log4j.chainsaw.JTextComponentFormatter;
import org.apache.log4j.chainsaw.LogPanelLoggerTreeModel;
import org.apache.log4j.chainsaw.LogPanelPreferenceModel;
import org.apache.log4j.chainsaw.LogPanelPreferencePanel;
import org.apache.log4j.chainsaw.LoggerNameTreePanel;
import org.apache.log4j.chainsaw.NewKeyEvent;
import org.apache.log4j.chainsaw.NewKeyListener;
import org.apache.log4j.chainsaw.PopupListener;
import org.apache.log4j.chainsaw.RuleMediator;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.SmallToggleButton;
import org.apache.log4j.chainsaw.TableColorizingRenderer;
import org.apache.log4j.chainsaw.ThrowableRenderPanel;
import org.apache.log4j.chainsaw.color.ColorPanel;
import org.apache.log4j.chainsaw.color.RuleColorizer;
import org.apache.log4j.chainsaw.filter.FilterModel;
import org.apache.log4j.chainsaw.helper.SwingHelper;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.icons.LineIconFactory;
import org.apache.log4j.chainsaw.layout.DefaultLayoutFactory;
import org.apache.log4j.chainsaw.layout.EventDetailLayout;
import org.apache.log4j.chainsaw.layout.LayoutEditorPane;
import org.apache.log4j.chainsaw.messages.MessageCenter;
import org.apache.log4j.chainsaw.prefs.LoadSettingsEvent;
import org.apache.log4j.chainsaw.prefs.Profileable;
import org.apache.log4j.chainsaw.prefs.SaveSettingsEvent;
import org.apache.log4j.chainsaw.prefs.SettingsManager;
import org.apache.log4j.chainsaw.xstream.TableColumnConverter;
import org.apache.log4j.rule.ColorRule;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class LogPanel
extends DockablePanel
implements EventBatchListener,
Profileable {
    private static final double DEFAULT_DETAIL_SPLIT_LOCATION = 0.71;
    private static final double DEFAULT_LOG_TREE_SPLIT_LOCATION = 0.2;
    private final String identifier;
    private final ChainsawStatusBar statusBar;
    private final JFrame logPanelPreferencesFrame = new JFrame();
    private ColorPanel colorPanel;
    private final JFrame colorFrame = new JFrame();
    private final JFrame undockedFrame;
    private final DockablePanel externalPanel;
    private final Action dockingAction;
    private final JToolBar undockedToolbar;
    private final JSortTable table;
    private final TableColorizingRenderer renderer;
    private final EventContainer tableModel;
    private final ThrowableRenderPanel throwableRenderPanel;
    private final JEditorPane detail;
    private final JSplitPane lowerPanel;
    private final DetailPaneUpdater detailPaneUpdater;
    private final JPanel detailPanel = new JPanel(new BorderLayout());
    private final JSplitPane nameTreeAndMainPanelSplit;
    private final LoggerNameTreePanel logTreePanel;
    private final LogPanelPreferenceModel preferenceModel = new LogPanelPreferenceModel();
    private final LogPanelPreferencePanel logPanelPreferencesPanel = new LogPanelPreferencePanel(this.preferenceModel);
    private final FilterModel filterModel = new FilterModel();
    private final RuleColorizer colorizer = new RuleColorizer();
    private final RuleMediator ruleMediator = new RuleMediator();
    private final EventDetailLayout detailLayout = new EventDetailLayout();
    private double lastDetailPanelSplitLocation = 0.71;
    private double lastLogTreePanelSplitLocation = 0.2;
    private Point currentPoint;
    private boolean paused = false;
    private Rule findRule;
    private String currentFindRuleText;
    private Rule findMarkerRule;
    private final JPanel findPanel;
    private JTextField findField;
    private final int dividerSize;
    static final String TABLE_COLUMN_ORDER = "table.columns.order";
    static final String TABLE_COLUMN_WIDTHS = "table.columns.widths";
    static final String COLORS_EXTENSION = ".colors";
    private static final int LOG_PANEL_SERIALIZATION_VERSION_NUMBER = 2;
    private int previousLastIndex = -1;
    private final DateFormat timestampExpressionFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
    private final Logger logger = LogManager.getLogger((Class)(class$org$apache$log4j$chainsaw$LogPanel == null ? (class$org$apache$log4j$chainsaw$LogPanel = LogPanel.class$("org.apache.log4j.chainsaw.LogPanel")) : class$org$apache$log4j$chainsaw$LogPanel));
    private TableCellEditor markerCellEditor;
    private AutoFilterComboBox filterCombo;
    private JScrollPane eventsPane;
    private int currentSearchMatchCount;
    private ApplicationPreferenceModel applicationPreferenceModel;
    private Rule clearTableExpressionRule;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$LogPanel;
    static /* synthetic */ Class class$java$lang$Object;

    public LogPanel(final ChainsawStatusBar statusBar, String identifier, int cyclicBufferSize, Map allColorizers, ApplicationPreferenceModel applicationPreferenceModel) {
        this.identifier = identifier;
        this.statusBar = statusBar;
        this.applicationPreferenceModel = applicationPreferenceModel;
        this.logger.debug((Object)("\u6b21\u306e\u30ed\u30b0\u30d1\u30cd\u30eb\u3092\u4f5c\u6210 " + identifier));
        this.setLayout(new BorderLayout());
        this.findPanel = new JPanel();
        this.findPanel.setLayout(new BoxLayout(this.findPanel, 0));
        Dimension findPanelSize = new Dimension(310, 30);
        this.findPanel.setPreferredSize(findPanelSize);
        this.findPanel.setMaximumSize(findPanelSize);
        this.findPanel.setMinimumSize(findPanelSize);
        final HashMap<String, String> columnNameKeywordMap = new HashMap<String, String>();
        columnNameKeywordMap.put("\u30af\u30e9\u30b9", "CLASS");
        columnNameKeywordMap.put("\u30d5\u30a1\u30a4\u30eb", "FILE");
        columnNameKeywordMap.put("\u30ec\u30d9\u30eb", "LEVEL");
        columnNameKeywordMap.put("\u884c", "LINE");
        columnNameKeywordMap.put("\u30ed\u30b0", "LOGGER");
        columnNameKeywordMap.put("NDC", "NDC");
        columnNameKeywordMap.put("\u30e1\u30c3\u30bb\u30fc\u30b8", "MSG");
        columnNameKeywordMap.put("\u30b9\u30ec\u30c3\u30c9", "THREAD");
        columnNameKeywordMap.put("THROWABLE", "EXCEPTION");
        columnNameKeywordMap.put("\u30bf\u30a4\u30e0\u30b9\u30bf\u30f3\u30d7", "TIMESTAMP");
        columnNameKeywordMap.put("log4j.marker".toUpperCase(), "PROP.log4j.marker");
        this.logPanelPreferencesFrame.setTitle("'" + identifier + "' \u30ed\u30b0\u30d1\u30cd\u30eb\u306e\u8a2d\u5b9a");
        this.logPanelPreferencesFrame.setIconImage(((ImageIcon)ChainsawIcons.ICON_PREFERENCES).getImage());
        this.logPanelPreferencesFrame.getContentPane().add(new JScrollPane(this.logPanelPreferencesPanel));
        this.logPanelPreferencesFrame.setSize(740, 520);
        this.logPanelPreferencesPanel.setOkCancelActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.logPanelPreferencesFrame.setVisible(false);
            }
        });
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction closeLogPanelPreferencesFrameAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.logPanelPreferencesFrame.setVisible(false);
            }
        };
        this.logPanelPreferencesFrame.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.logPanelPreferencesFrame.getRootPane().getActionMap().put("ESCAPE", closeLogPanelPreferencesFrameAction);
        this.setDetailPaneConversionPattern(DefaultLayoutFactory.getDefaultPatternLayout());
        this.detailLayout.setConversionPattern(DefaultLayoutFactory.getDefaultPatternLayout());
        this.undockedFrame = new JFrame(identifier);
        this.undockedFrame.setDefaultCloseOperation(0);
        if (ChainsawIcons.UNDOCKED_ICON != null) {
            this.undockedFrame.setIconImage(new ImageIcon(ChainsawIcons.UNDOCKED_ICON).getImage());
        }
        this.externalPanel = new DockablePanel();
        this.externalPanel.setLayout(new BorderLayout());
        this.undockedFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                LogPanel.this.dock();
            }
        });
        this.undockedToolbar = this.createDockwindowToolbar();
        this.externalPanel.add((Component)this.undockedToolbar, "North");
        this.undockedFrame.getContentPane().add(this.externalPanel);
        this.undockedFrame.setSize(new Dimension(1024, 768));
        this.undockedFrame.pack();
        final JPopupMenu dateFormatChangePopup = new JPopupMenu();
        final JRadioButtonMenuItem isoButton = new JRadioButtonMenuItem(new AbstractAction("ISO8601\u5f62\u5f0f"){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.preferenceModel.setDateFormatPattern("ISO8601");
            }
        });
        final JRadioButtonMenuItem simpleTimeButton = new JRadioButtonMenuItem(new AbstractAction("\u77ed\u3044\u6642\u9593\u5f62\u5f0f"){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.preferenceModel.setDateFormatPattern("HH:mm:ss");
            }
        });
        ButtonGroup dfBG = new ButtonGroup();
        dfBG.add(isoButton);
        dfBG.add(simpleTimeButton);
        simpleTimeButton.setSelected(true);
        dateFormatChangePopup.add(isoButton);
        dateFormatChangePopup.add(simpleTimeButton);
        final JCheckBoxMenuItem menuItemToggleToolTips = new JCheckBoxMenuItem("\u30c4\u30fc\u30eb\u30c1\u30c3\u30d7\u3092\u8868\u793a");
        menuItemToggleToolTips.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogPanel.this.preferenceModel.setToolTips(menuItemToggleToolTips.isSelected());
            }
        });
        menuItemToggleToolTips.setIcon(new ImageIcon(ChainsawIcons.TOOL_TIP));
        final JCheckBoxMenuItem menuItemLoggerTree = new JCheckBoxMenuItem("\u30ed\u30b0\u30c4\u30ea\u30fc\u3092\u8868\u793a");
        menuItemLoggerTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.preferenceModel.setLogTreePanelVisible(menuItemLoggerTree.isSelected());
            }
        });
        menuItemLoggerTree.setIcon(new ImageIcon(ChainsawIcons.WINDOW_ICON));
        JMenuItem menuItemScrollToTop = new JMenuItem("\u4e0a\u307e\u3067\u30b9\u30af\u30ed\u30fc\u30eb");
        menuItemScrollToTop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogPanel.this.scrollToTop();
            }
        });
        final JCheckBoxMenuItem menuItemScrollBottom = new JCheckBoxMenuItem("\u4e0b\u307e\u3067\u30b9\u30af\u30ed\u30fc\u30eb");
        menuItemScrollBottom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogPanel.this.preferenceModel.setScrollToBottom(menuItemScrollBottom.isSelected());
            }
        });
        menuItemScrollBottom.setSelected(this.isScrollToBottom());
        menuItemScrollBottom.setIcon(new ImageIcon(ChainsawIcons.SCROLL_TO_BOTTOM));
        final JCheckBoxMenuItem menuItemToggleDetails = new JCheckBoxMenuItem("\u8a73\u7d30\u30da\u30a4\u30f3\u3092\u8868\u793a");
        menuItemToggleDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.preferenceModel.setDetailPaneVisible(menuItemToggleDetails.isSelected());
            }
        });
        menuItemToggleDetails.setIcon(new ImageIcon(ChainsawIcons.INFO));
        this.preferenceModel.addPropertyChangeListener("levelIcons", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                LogPanel.this.renderer.setLevelUseIcons((Boolean)evt.getNewValue());
                LogPanel.this.table.tableChanged(new TableModelEvent(LogPanel.this.tableModel));
            }
        });
        this.preferenceModel.addPropertyChangeListener("wrapMessage", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                LogPanel.this.renderer.setWrapMessage((Boolean)evt.getNewValue());
                LogPanel.this.table.tableChanged(new TableModelEvent(LogPanel.this.tableModel));
            }
        });
        this.preferenceModel.addPropertyChangeListener("highlightSearchMatchText", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                LogPanel.this.renderer.setHighlightSearchMatchText((Boolean)evt.getNewValue());
                LogPanel.this.table.tableChanged(new TableModelEvent(LogPanel.this.tableModel));
            }
        });
        this.preferenceModel.addPropertyChangeListener("detailPaneVisible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean newValue = (Boolean)evt.getNewValue();
                if (newValue) {
                    LogPanel.this.showDetailPane();
                } else {
                    LogPanel.this.hideDetailPane();
                }
            }
        });
        this.preferenceModel.addPropertyChangeListener("logTreePanelVisible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean newValue = (Boolean)evt.getNewValue();
                if (newValue) {
                    LogPanel.this.showLogTreePanel();
                } else {
                    LogPanel.this.hideLogTreePanel();
                }
            }
        });
        this.preferenceModel.addPropertyChangeListener("toolTips", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                LogPanel.this.renderer.setToolTipsVisible((Boolean)evt.getNewValue());
            }
        });
        this.preferenceModel.addPropertyChangeListener("visibleColumns", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                TableColumnModel columnModel = LogPanel.this.table.getColumnModel();
                while (columnModel.getColumnCount() > 0) {
                    columnModel.removeColumn(columnModel.getColumn(0));
                }
                Iterator iter = LogPanel.this.preferenceModel.getVisibleColumnOrder().iterator();
                while (iter.hasNext()) {
                    TableColumn c = (TableColumn)iter.next();
                    columnModel.addColumn(c);
                }
            }
        });
        PropertyChangeListener datePrefsChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                LogPanelPreferenceModel model = (LogPanelPreferenceModel)evt.getSource();
                isoButton.setSelected(model.isUseISO8601Format());
                simpleTimeButton.setSelected(!model.isUseISO8601Format() && !model.isCustomDateFormat());
                if (model.getTimeZone() != null) {
                    LogPanel.this.renderer.setTimeZone(model.getTimeZone());
                }
                if (model.isUseISO8601Format()) {
                    LogPanel.this.renderer.setDateFormatter(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS"));
                } else {
                    try {
                        LogPanel.this.renderer.setDateFormatter(new SimpleDateFormat(model.getDateFormatPattern()));
                    }
                    catch (IllegalArgumentException iae) {
                        model.setDefaultDatePatternFormat();
                        LogPanel.this.renderer.setDateFormatter(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS"));
                    }
                }
                LogPanel.this.table.tableChanged(new TableModelEvent(LogPanel.this.tableModel));
            }
        };
        this.preferenceModel.addPropertyChangeListener("dateFormatPattern", datePrefsChangeListener);
        this.preferenceModel.addPropertyChangeListener("dateFormatTimeZone", datePrefsChangeListener);
        this.preferenceModel.addPropertyChangeListener("clearTableExpression", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                LogPanelPreferenceModel model = (LogPanelPreferenceModel)evt.getSource();
                String expression = model.getClearTableExpression();
                try {
                    LogPanel.this.clearTableExpressionRule = ExpressionRule.getRule((String)expression);
                    LogPanel.this.logger.info((Object)("clearTableExpressionRule\u306f\u6b21\u306b\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u3059\uff1a " + expression));
                }
                catch (Exception e) {
                    LogPanel.this.logger.info((Object)("clearTableExpressionRule\u306f\u4e0d\u6b63\u3067\u3059 - \u7121\u8996\uff1a " + expression));
                    LogPanel.this.clearTableExpressionRule = null;
                }
            }
        });
        this.preferenceModel.addPropertyChangeListener("loggerPrecision", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                LogPanelPreferenceModel model = (LogPanelPreferenceModel)evt.getSource();
                LogPanel.this.renderer.setLoggerPrecision(model.getLoggerPrecision());
                LogPanel.this.table.tableChanged(new TableModelEvent(LogPanel.this.tableModel));
            }
        });
        this.preferenceModel.addPropertyChangeListener("toolTips", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean value = (Boolean)evt.getNewValue();
                menuItemToggleToolTips.setSelected(value);
            }
        });
        this.preferenceModel.addPropertyChangeListener("logTreePanelVisible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean value = (Boolean)evt.getNewValue();
                menuItemLoggerTree.setSelected(value);
            }
        });
        this.preferenceModel.addPropertyChangeListener("scrollToBottom", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean value = (Boolean)evt.getNewValue();
                menuItemScrollBottom.setSelected(value);
                if (value) {
                    LogPanel.this.scrollToBottom();
                }
            }
        });
        this.preferenceModel.addPropertyChangeListener("detailPaneVisible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean value = (Boolean)evt.getNewValue();
                menuItemToggleDetails.setSelected(value);
            }
        });
        applicationPreferenceModel.addPropertyChangeListener("searchColor", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (LogPanel.this.table != null) {
                    LogPanel.this.table.repaint();
                }
            }
        });
        applicationPreferenceModel.addPropertyChangeListener("alternatingColor", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (LogPanel.this.table != null) {
                    LogPanel.this.table.repaint();
                }
            }
        });
        this.tableModel = new ChainsawCyclicBufferTableModel(cyclicBufferSize, this.colorizer);
        this.table = new JSortTable(this.tableModel);
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke("F2"), "none");
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(113, 1), "none");
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(113, 2), "none");
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(113, 3), "none");
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(65, 2), "none");
        this.tableModel.addNewKeyListener(new NewKeyListener(){

            public void newKeyAdded(NewKeyEvent e) {
                columnNameKeywordMap.put(e.getKey(), "PROP." + e.getKey());
            }
        });
        this.tableModel.setDisplayRule(this.ruleMediator);
        this.tableModel.addEventCountListener(new EventCountListener(){

            public void eventCountChanged(int currentCount, int totalCount) {
                if (LogPanel.this.isVisible()) {
                    statusBar.setSelectedLine(LogPanel.this.table.getSelectedRow() + 1, currentCount, totalCount, LogPanel.this.getIdentifier());
                }
            }
        });
        this.tableModel.addEventCountListener(new EventCountListener(){
            final NumberFormat formatter = NumberFormat.getPercentInstance();
            boolean warning75 = false;
            boolean warning100 = false;

            public void eventCountChanged(int currentCount, int totalCount) {
                if (LogPanel.this.tableModel.isCyclic()) {
                    double percent = (double)totalCount / (double)((ChainsawCyclicBufferTableModel)LogPanel.this.tableModel).getMaxSize();
                    String msg = null;
                    if (percent > 0.75 && percent < 1.0 && !this.warning75) {
                        msg = "\u8b66\u544a\uff1a\uff1a " + this.formatter.format(percent) + "\u306e\u30d0\u30c3\u30d5\u30a1\u30fc\u300c" + LogPanel.this.getIdentifier() + "\u300d\u304c\u5229\u7528\u3055\u308c\u307e\u305b\u3044\u305f";
                        this.warning75 = true;
                    } else if (percent >= 1.0 && !this.warning100) {
                        msg = "\u8b66\u544a\uff1a\uff1a " + this.formatter.format(percent) + "\u306e\u300c" + LogPanel.this.getIdentifier() + "\u300d\u30d0\u30c3\u30d5\u30a1\u30fc\u304c\u5229\u7528\u3055\u308c\u307e\u3057\u305f\u3002\u53e4\u3044\u30a4\u30d9\u30f3\u30c8\u3092\u524a\u9664\u3057\u3066\u3044\u307e\u3059\u3002";
                        this.warning100 = true;
                    }
                    if (msg != null) {
                        MessageCenter.getInstance().getLogger().info(msg);
                    }
                }
            }
        });
        LogPanelLoggerTreeModel logTreeModel = new LogPanelLoggerTreeModel();
        this.logTreePanel = new LoggerNameTreePanel(logTreeModel, this.preferenceModel, this, this.colorizer, this.filterModel);
        this.logTreePanel.getLoggerVisibilityRule().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("searchExpression")) {
                    LogPanel.this.findField.setText(evt.getNewValue().toString());
                    LogPanel.this.findNext();
                }
            }
        });
        this.tableModel.addLoggerNameListener(logTreeModel);
        this.ruleMediator.setLoggerRule(this.logTreePanel.getLoggerVisibilityRule());
        this.colorizer.setLoggerRule(this.logTreePanel.getLoggerColorRule());
        this.colorFrame.setTitle("'" + identifier + "' \u8272\u8a2d\u5b9a");
        this.colorFrame.setIconImage(((ImageIcon)ChainsawIcons.ICON_PREFERENCES).getImage());
        allColorizers.put(identifier, this.colorizer);
        this.colorPanel = new ColorPanel(this.colorizer, this.filterModel, allColorizers, applicationPreferenceModel);
        this.colorFrame.getContentPane().add(this.colorPanel);
        AbstractAction closeColorPanelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.colorPanel.hidePanel();
            }
        };
        this.colorFrame.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.colorFrame.getRootPane().getActionMap().put("ESCAPE", closeColorPanelAction);
        this.colorPanel.setCloseActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.colorFrame.setVisible(false);
            }
        });
        this.colorizer.addPropertyChangeListener("colorrule", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (LogPanel.this.table != null) {
                    LogPanel.this.table.repaint();
                }
            }
        });
        this.table.setRowHeight(20);
        this.table.setRowMargin(0);
        this.table.getColumnModel().setColumnMargin(0);
        this.table.setShowGrid(false);
        this.table.getColumnModel().addColumnModelListener(new ChainsawTableColumnModelListener());
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.addMouseMotionListener(new TableColumnDetailMouseListener());
        this.table.addMouseListener(new TableMarkerListener());
        this.table.setAutoResizeMode(0);
        this.table.addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyPressed(KeyEvent e) {
                JEditorPane jEditorPane = LogPanel.this.detail;
                synchronized (jEditorPane) {
                    LogPanel.this.table.getSelectionModel().setValueIsAdjusting(true);
                    LogPanel.this.detail.notify();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void keyReleased(KeyEvent e) {
                JEditorPane jEditorPane = LogPanel.this.detail;
                synchronized (jEditorPane) {
                    LogPanel.this.table.getSelectionModel().setValueIsAdjusting(false);
                    LogPanel.this.detail.notify();
                }
            }
        });
        this.table.setSelectionMode(0);
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                boolean disableScrollToBottom;
                if (evt.getFirstIndex() == evt.getLastIndex() && evt.getFirstIndex() > 0 && LogPanel.this.previousLastIndex != -1 || evt.getValueIsAdjusting()) {
                    return;
                }
                boolean lastIndexOnLastRow = evt.getLastIndex() == LogPanel.this.table.getRowCount() - 1;
                boolean lastIndexSame = LogPanel.this.previousLastIndex == evt.getLastIndex();
                boolean bl = disableScrollToBottom = lastIndexOnLastRow && lastIndexSame && LogPanel.this.previousLastIndex != evt.getFirstIndex();
                if (disableScrollToBottom && LogPanel.this.isScrollToBottom() && LogPanel.this.table.getRowCount() > 0) {
                    LogPanel.this.preferenceModel.setScrollToBottom(false);
                }
                LogPanel.this.previousLastIndex = evt.getLastIndex();
            }
        });
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                if (evt.getFirstIndex() == evt.getLastIndex() && evt.getFirstIndex() > 0 && LogPanel.this.previousLastIndex != -1 || evt.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)evt.getSource();
                if (lsm.isSelectionEmpty()) {
                    if (LogPanel.this.isVisible()) {
                        statusBar.setNothingSelected();
                    }
                    if (LogPanel.this.detail.getDocument().getDefaultRootElement() != null) {
                        LogPanel.this.detailPaneUpdater.setSelectedRow(-1);
                    }
                } else if (LogPanel.this.table.getSelectedRow() > -1) {
                    int selectedRow = LogPanel.this.table.getSelectedRow();
                    if (LogPanel.this.isVisible()) {
                        LogPanel.this.updateStatusBar();
                    }
                    try {
                        if (LogPanel.this.tableModel.getRowCount() >= selectedRow) {
                            LogPanel.this.detailPaneUpdater.setSelectedRow(LogPanel.this.table.getSelectedRow());
                        } else {
                            LogPanel.this.detailPaneUpdater.setSelectedRow(-1);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LogPanel.this.detailPaneUpdater.setSelectedRow(-1);
                    }
                }
            }
        });
        this.renderer = new TableColorizingRenderer(this.colorizer, applicationPreferenceModel);
        this.renderer.setToolTipsVisible(this.preferenceModel.isToolTips());
        this.table.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = LogPanel.class$("java.lang.Object")) : class$java$lang$Object, this.renderer);
        this.throwableRenderPanel = new ThrowableRenderPanel();
        this.markerCellEditor = new MarkerCellEditor();
        final JDialog detailDialog = new JDialog((Frame)null, true);
        Container container = detailDialog.getContentPane();
        final JEditorPane detailArea = new JEditorPane();
        JTextComponentFormatter.applySystemFontAndSize(detailArea);
        detailArea.setEditable(false);
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        detailArea.setPreferredSize(new Dimension(screenDimension.width / 2, screenDimension.height / 2));
        container.setLayout(new BoxLayout(container, 1));
        container.add(new JScrollPane(detailArea));
        detailDialog.pack();
        this.throwableRenderPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ExtendedLoggingEvent event = LogPanel.this.tableModel.getRow(LogPanel.this.table.getSelectedRow());
                detailDialog.setTitle(LogPanel.this.table.getColumnName(LogPanel.this.table.getSelectedColumn()) + " \u8a73\u7d30...");
                if (event == null) {
                    detailArea.setText("");
                } else {
                    String[] ti = event.getThrowableStrRep();
                    if (!(ti == null || ti.length <= 0 || ti.length == 1 && ti[0].equals(""))) {
                        StringBuffer buf = new StringBuffer();
                        buf.append(event.getMessage());
                        buf.append("\n");
                        for (int i = 0; i < ti.length; ++i) {
                            buf.append(ti[i]).append("\n    ");
                        }
                        detailArea.setText(buf.toString());
                    } else {
                        detailArea.setText("");
                    }
                }
                SwingHelper.invokeOnEDT(new Runnable(){

                    public void run() {
                        LogPanel.centerAndSetVisible(detailDialog);
                    }
                });
            }
        });
        this.tableModel.addNewKeyListener(new NewKeyListener(){

            public void newKeyAdded(final NewKeyEvent e) {
                SwingHelper.invokeOnEDT(new Runnable(){

                    public void run() {
                        try {
                            if (LogPanel.this.table.getColumn(e.getKey()) != null) {
                                return;
                            }
                        }
                        catch (IllegalArgumentException iae) {
                            // empty catch block
                        }
                        TableColumn col = new TableColumn(e.getNewModelIndex());
                        col.setHeaderValue(e.getKey());
                        if (LogPanel.this.preferenceModel.addColumn(col)) {
                            LogPanel.this.table.addColumn(col);
                            LogPanel.this.preferenceModel.setColumnVisible(e.getKey().toString(), true);
                        }
                    }
                });
            }
        });
        this.tableModel.addPropertyChangeListener("cyclic", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent arg0) {
                if (LogPanel.this.tableModel.isCyclic()) {
                    MessageCenter.getInstance().getLogger().warn((Object)("\u5faa\u74b0\u30e2\u30fc\u30c9\u306b\u5207\u308a\u66ff\u3048\uff1a " + LogPanel.this.tableModel.getMaxSize()));
                } else {
                    MessageCenter.getInstance().getLogger().warn((Object)"\u7121\u5236\u9650\u30ce\u30fc\u30c9\u306b\u5207\u308a\u66ff\u3048\u3002\u6ce8\u610f\uff1a\u30e1\u30e2\u30ea\u304c\u4e0d\u8db3\u3059\u308b\u5834\u5408\u304c\u3042\u308a\u307e\u3059\u3002");
                }
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                this.checkEvent(e);
            }

            public void mousePressed(MouseEvent e) {
                this.checkEvent(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.checkEvent(e);
            }

            private void checkEvent(MouseEvent e) {
                int index;
                TableColumnModel colModel;
                int modelIndex;
                if (e.isPopupTrigger() && (modelIndex = (colModel = LogPanel.this.table.getColumnModel()).getColumn(index = colModel.getColumnIndexAtX(e.getX())).getModelIndex()) + 1 == 3) {
                    dateFormatChangePopup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        JPanel upperPanel = new JPanel(new BorderLayout());
        upperPanel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 0));
        JLabel filterLabel = new JLabel("\u8a73\u7d30\uff1a ");
        filterLabel.setFont(filterLabel.getFont().deriveFont(1));
        filterLabel.setDisplayedMnemonic('k');
        JPanel upperLeftPanel = new JPanel();
        upperLeftPanel.setLayout(new BoxLayout(upperLeftPanel, 0));
        upperLeftPanel.setAlignmentY(0.5f);
        upperLeftPanel.setAlignmentY(0.5f);
        upperLeftPanel.add(filterLabel);
        Vector<String> filterExpressionVector = new Vector<String>();
        filterExpressionVector.add("LEVEL == TRACE");
        filterExpressionVector.add("LEVEL >= DEBUG");
        filterExpressionVector.add("LEVEL >= INFO");
        filterExpressionVector.add("LEVEL >= WARN");
        filterExpressionVector.add("LEVEL >= ERROR");
        filterExpressionVector.add("LEVEL == FATAL");
        this.filterCombo = new AutoFilterComboBox((Collection)filterExpressionVector);
        final JTextField filterText = (JTextField)this.filterCombo.getEditor().getEditorComponent();
        filterText.getDocument().addDocumentListener(new DelayedFilterTextDocumentListener(filterText));
        filterText.setToolTipText("\u5f0f\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\u3002\u4e00\u89a7\u306b\u8ffd\u52a0\u3059\u308b\u5834\u5408\u306f\u300cEnter\u300d\u30ad\u30fc\u3092\u62bc\u4e0b\u3057\u3066\u304f\u3060\u3055\u3044");
        filterText.addKeyListener(new ExpressionRuleContext(this.filterModel, filterText));
        if (this.filterCombo.getEditor().getEditorComponent() instanceof JTextField) {
            this.filterCombo.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent e) {
                    if (e.getActionCommand().equals("comboBoxEdited")) {
                        try {
                            Object item = LogPanel.this.filterCombo.getSelectedItem();
                            if (item != null && !item.toString().trim().equals("")) {
                                ExpressionRule.getRule((String)item.toString());
                                LogPanel.this.filterCombo.insertItemAt(item, 0);
                            }
                            filterText.setBackground(UIManager.getColor("TextField.background"));
                        }
                        catch (IllegalArgumentException iae) {
                            filterText.setToolTipText(iae.getMessage());
                            filterText.setBackground(ChainsawConstants.INVALID_EXPRESSION_BACKGROUND);
                            return;
                        }
                    }
                }
            });
        }
        upperPanel.add((Component)this.filterCombo, "Center");
        filterLabel.setLabelFor(this.filterCombo);
        upperPanel.add((Component)upperLeftPanel, "West");
        JPanel upperRightPanel = new JPanel(new FlowLayout(1, 0, 0));
        final JButton clearButton = new JButton("\u5f0f\u3092\u6d88\u53bb");
        clearButton.setToolTipText("\u9078\u629e\u3055\u308c\u305f\u9805\u76ee\u3092\u4e00\u89a7\u304b\u3089\u524a\u9664\u3059\u308b\u5834\u5408\u306f\u3001\u3053\u3053\u3092\u30af\u30ea\u30c3\u30af\u3057\u3066\u304f\u3060\u3055\u3057");
        clearButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                Object selectedItem = LogPanel.this.filterCombo.getSelectedItem();
                if (e.getSource() == clearButton && selectedItem != null && !selectedItem.toString().trim().equals("")) {
                    filterText.setText(null);
                    int index = LogPanel.this.filterCombo.getSelectedIndex();
                    LogPanel.this.filterCombo.setSelectedIndex(-1);
                    LogPanel.this.filterCombo.removeItemAt(index);
                }
            }
        });
        upperRightPanel.add(clearButton);
        upperPanel.add((Component)upperRightPanel, "East");
        this.detail = new JEditorPane("text/html", "");
        this.detail.setEditable(false);
        this.detailPaneUpdater = new DetailPaneUpdater();
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                LogPanel.this.detailPaneUpdater.updateDetailPane();
            }

            public void focusLost(FocusEvent e) {
            }
        });
        this.findMarkerRule = ExpressionRule.getRule((String)"prop.log4j.marker exists");
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                int currentRow = LogPanel.this.table.getSelectedRow();
                if (e.getFirstRow() <= currentRow && e.getLastRow() >= currentRow) {
                    LogPanel.this.detailPaneUpdater.setAndUpdateSelectedRow(LogPanel.this.table.getSelectedRow());
                }
            }
        });
        this.addPropertyChangeListener("detailPaneConversionPattern", this.detailPaneUpdater);
        JScrollPane detailPane = new JScrollPane(this.detail);
        detailPane.setPreferredSize(new Dimension(900, 50));
        this.detailPanel.add((Component)detailPane, "Center");
        JPanel eventsAndStatusPanel = new JPanel(new BorderLayout());
        this.eventsPane = new JScrollPane(this.table);
        this.eventsPane.getVerticalScrollBar().setUnitIncrement(40);
        eventsAndStatusPanel.add((Component)this.eventsPane, "Center");
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        EventMatchThumbnail thumbNailPanel = new EventMatchThumbnail();
        rightPanel.add(thumbNailPanel);
        Integer scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
        if (scrollBarWidth != null) {
            thumbNailPanel.setPreferredSize(new Dimension(scrollBarWidth - 4, -1));
        }
        eventsAndStatusPanel.add((Component)rightPanel, "East");
        JPanel statusLabelPanel = new JPanel();
        statusLabelPanel.setLayout(new BorderLayout());
        statusLabelPanel.add((Component)upperPanel, "Center");
        eventsAndStatusPanel.add((Component)statusLabelPanel, "North");
        this.lowerPanel = new JSplitPane(0, eventsAndStatusPanel, this.detailPanel);
        this.dividerSize = this.lowerPanel.getDividerSize();
        this.lowerPanel.setDividerLocation(-1);
        this.lowerPanel.setResizeWeight(1.0);
        this.lowerPanel.setBorder(null);
        this.lowerPanel.setContinuousLayout(true);
        if (this.preferenceModel.isDetailPaneVisible()) {
            this.showDetailPane();
        } else {
            this.hideDetailPane();
        }
        JToolBar detailToolbar = new JToolBar(0);
        detailToolbar.setFloatable(false);
        final LayoutEditorPane layoutEditorPane = new LayoutEditorPane();
        final JDialog layoutEditorDialog = new JDialog((Frame)null, "\u30d1\u30bf\u30fc\u30f3\u30a8\u30c7\u30a3\u30bf");
        layoutEditorDialog.getContentPane().add(layoutEditorPane);
        layoutEditorDialog.setSize(640, 480);
        layoutEditorPane.addCancelActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                layoutEditorDialog.setVisible(false);
            }
        });
        layoutEditorPane.addOkActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.setDetailPaneConversionPattern(layoutEditorPane.getConversionPattern());
                layoutEditorDialog.setVisible(false);
            }
        });
        AbstractAction copyToRefineFocusAction = new AbstractAction("\u300c\u8a73\u7d30\u300d\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u8a2d\u5b9a"){

            public void actionPerformed(ActionEvent e) {
                String selectedText = LogPanel.this.detail.getSelectedText();
                if (selectedText == null || selectedText.equals("")) {
                    return;
                }
                filterText.setText("msg ~= '" + selectedText + "'");
            }
        };
        AbstractAction copyToSearchAction = new AbstractAction("\u6b21\u306e\u691c\u7d22"){

            public void actionPerformed(ActionEvent e) {
                String selectedText = LogPanel.this.detail.getSelectedText();
                if (selectedText == null || selectedText.equals("")) {
                    return;
                }
                LogPanel.this.findField.setText("msg ~= '" + selectedText + "'");
                LogPanel.this.findNext();
            }
        };
        AbstractAction editDetailAction = new AbstractAction("\u7de8\u96c6...", new ImageIcon(ChainsawIcons.ICON_EDIT_RECEIVER)){

            public void actionPerformed(ActionEvent e) {
                layoutEditorPane.setConversionPattern(LogPanel.this.getDetailPaneConversionPattern());
                Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
                Point p = new Point((int)(size.getWidth() / 2.0 - layoutEditorDialog.getSize().getWidth() / 2.0), (int)(size.getHeight() / 2.0 - layoutEditorDialog.getSize().getHeight() / 2.0));
                ((Component)layoutEditorDialog).setLocation(p);
                layoutEditorDialog.setVisible(true);
            }
        };
        editDetailAction.putValue("ShortDescription", "\u30d1\u30bf\u30fc\u30f3\u30ec\u30a4\u30a2\u30a6\u30c8\u30c6\u30ad\u30b9\u30c8\u3092\u7de8\u96c6\u3059\u308b\u305f\u3081\u306b\u30c0\u30a4\u30a2\u30ed\u30b0\u30a6\u30a3\u30f3\u30c9\u30a6\u3092\u958b\u304f");
        SmallButton editDetailButton = new SmallButton(editDetailAction);
        editDetailButton.setText(null);
        detailToolbar.add(Box.createHorizontalGlue());
        detailToolbar.add(editDetailButton);
        detailToolbar.addSeparator();
        detailToolbar.add(Box.createHorizontalStrut(5));
        AbstractAction closeDetailAction = new AbstractAction(null, LineIconFactory.createCloseIcon()){

            public void actionPerformed(ActionEvent arg0) {
                LogPanel.this.preferenceModel.setDetailPaneVisible(false);
            }
        };
        closeDetailAction.putValue("ShortDescription", "\u8a73\u7d30\u30d1\u30cd\u30eb\u3092\u96a0\u3059");
        SmallButton closeDetailButton = new SmallButton(closeDetailAction);
        detailToolbar.add(closeDetailButton);
        this.detailPanel.add((Component)detailToolbar, "North");
        JPopupMenu editDetailPopupMenu = new JPopupMenu();
        editDetailPopupMenu.add(copyToRefineFocusAction);
        editDetailPopupMenu.add(copyToSearchAction);
        editDetailPopupMenu.addSeparator();
        editDetailPopupMenu.add(editDetailAction);
        editDetailPopupMenu.addSeparator();
        ButtonGroup layoutGroup = new ButtonGroup();
        JRadioButtonMenuItem defaultLayoutRadio = new JRadioButtonMenuItem(new AbstractAction("\u30c7\u30d5\u30a9\u30eb\u30c8\u30ec\u30a4\u30a2\u30a6\u30c8\u306b\u8a2d\u5b9a"){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.setDetailPaneConversionPattern(DefaultLayoutFactory.getDefaultPatternLayout());
            }
        });
        JRadioButtonMenuItem fullLayoutRadio = new JRadioButtonMenuItem(new AbstractAction("\u5b8c\u5168\u30ec\u30a4\u30a2\u30a6\u30c8\u306b\u8a2d\u5b9a"){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.setDetailPaneConversionPattern(DefaultLayoutFactory.getFullPatternLayout());
            }
        });
        editDetailPopupMenu.add(defaultLayoutRadio);
        editDetailPopupMenu.add(fullLayoutRadio);
        layoutGroup.add(defaultLayoutRadio);
        layoutGroup.add(fullLayoutRadio);
        defaultLayoutRadio.setSelected(true);
        JRadioButtonMenuItem tccLayoutRadio = new JRadioButtonMenuItem(new AbstractAction("TCCLayout\u306b\u8a2d\u5b9a"){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.setDetailPaneConversionPattern("%r [%t] %p %c %x - %m%n");
            }
        });
        editDetailPopupMenu.add(tccLayoutRadio);
        layoutGroup.add(tccLayoutRadio);
        PopupListener editDetailPopupListener = new PopupListener(editDetailPopupMenu);
        this.detail.addMouseListener(editDetailPopupListener);
        this.nameTreeAndMainPanelSplit = new JSplitPane(1, this.logTreePanel, this.lowerPanel);
        this.nameTreeAndMainPanelSplit.setDividerLocation(-1);
        this.add((Component)this.nameTreeAndMainPanelSplit, "Center");
        if (this.isLogTreeVisible()) {
            this.showLogTreePanel();
        } else {
            this.hideLogTreePanel();
        }
        JMenuItem menuItemBestFit = new JMenuItem("\u6700\u9069\u306a\u5217");
        menuItemBestFit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (LogPanel.this.currentPoint != null) {
                    int column = LogPanel.this.table.columnAtPoint(LogPanel.this.currentPoint);
                    int maxWidth = LogPanel.this.getMaxColumnWidth(column);
                    LogPanel.this.table.getColumnModel().getColumn(column).setPreferredWidth(maxWidth);
                }
            }
        });
        JMenuItem menuItemColorPanel = new JMenuItem("\u8272\u8a2d\u5b9a...");
        menuItemColorPanel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogPanel.this.showColorPreferences();
            }
        });
        menuItemColorPanel.setIcon(ChainsawIcons.ICON_PREFERENCES);
        JMenuItem menuItemLogPanelPreferences = new JMenuItem("\u30bf\u30d6\u8a2d\u5b9a...");
        menuItemLogPanelPreferences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LogPanel.this.showPreferences();
            }
        });
        menuItemLogPanelPreferences.setIcon(ChainsawIcons.ICON_PREFERENCES);
        JMenuItem menuItemFocusOn = new JMenuItem("\u300c\u8a73\u7d30\u300d\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u5024\u3092\u8a2d\u5b9a");
        menuItemFocusOn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (LogPanel.this.currentPoint != null) {
                    String operator = "==";
                    int column = LogPanel.this.table.columnAtPoint(LogPanel.this.currentPoint);
                    int row = LogPanel.this.table.rowAtPoint(LogPanel.this.currentPoint);
                    String colName = LogPanel.this.table.getColumnName(column).toUpperCase();
                    String value = "";
                    if (colName.equalsIgnoreCase("\u30bf\u30a4\u30e0\u30b9\u30bf\u30f3\u30d7")) {
                        value = LogPanel.this.timestampExpressionFormat.format(new Date(LogPanel.this.table.getValueAt(row, column).toString()));
                    } else {
                        Object o = LogPanel.this.table.getValueAt(row, column);
                        if (o != null) {
                            if (o instanceof String[] && ((String[])o).length > 0) {
                                value = ((String[])o)[0];
                                operator = "~=";
                            } else {
                                value = o.toString();
                            }
                        }
                    }
                    if (columnNameKeywordMap.containsKey(colName)) {
                        filterText.setText(columnNameKeywordMap.get(colName).toString() + " " + operator + " '" + value + "'");
                    }
                }
            }
        });
        JMenuItem menuDefineAddCustomFilter = new JMenuItem("\u30dd\u30a4\u30f3\u30c8\u4e0b\u306e\u5024\u3092\u300c\u8a73\u7d30\u300d\u30d5\u30a3\u30fc\u30eb\u30c9\u306b\u8ffd\u52a0");
        menuDefineAddCustomFilter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (LogPanel.this.currentPoint != null) {
                    String operator = "==";
                    int column = LogPanel.this.table.columnAtPoint(LogPanel.this.currentPoint);
                    int row = LogPanel.this.table.rowAtPoint(LogPanel.this.currentPoint);
                    String colName = LogPanel.this.table.getColumnName(column).toUpperCase();
                    String value = "";
                    if (colName.equalsIgnoreCase("\u30bf\u30a4\u30e0\u30b9\u30bf\u30f3\u30d7")) {
                        JComponent comp = (JComponent)((Object)LogPanel.this.table.getCellRenderer(row, column));
                        if (comp instanceof JLabel) {
                            value = ((JLabel)comp).getText();
                        }
                    } else {
                        Object o = LogPanel.this.table.getValueAt(row, column);
                        if (o instanceof String[] && ((String[])o).length > 0) {
                            value = ((String[])o)[0];
                            operator = "~=";
                        } else {
                            value = o.toString();
                        }
                    }
                    if (columnNameKeywordMap.containsKey(colName)) {
                        filterText.setText(filterText.getText() + " && " + columnNameKeywordMap.get(colName).toString() + " " + operator + " '" + value + "'");
                    }
                }
            }
        });
        JMenuItem menuBuildColorRule = new JMenuItem("\u5024\u306e\u8272\u30eb\u30fc\u30eb\u3092\u5b9a\u7fa9");
        menuBuildColorRule.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (LogPanel.this.currentPoint != null) {
                    Color c;
                    String operator = "==";
                    int column = LogPanel.this.table.columnAtPoint(LogPanel.this.currentPoint);
                    int row = LogPanel.this.table.rowAtPoint(LogPanel.this.currentPoint);
                    String colName = LogPanel.this.table.getColumnName(column).toUpperCase();
                    String value = "";
                    if (colName.equalsIgnoreCase("\u30bf\u30a4\u30e0\u30b9\u30bf\u30f3\u30d7")) {
                        JComponent comp = (JComponent)((Object)LogPanel.this.table.getCellRenderer(row, column));
                        if (comp instanceof JLabel) {
                            value = ((JLabel)comp).getText();
                        }
                    } else {
                        Object o = LogPanel.this.table.getValueAt(row, column);
                        value = o instanceof String[] && ((String[])o).length > 0 ? ((String[])o)[0] : o.toString();
                    }
                    if (columnNameKeywordMap.containsKey(colName) && (c = JColorChooser.showDialog(LogPanel.this.getRootPane(), "\u8272\u3092\u9078\u629e", Color.red)) != null) {
                        String expression = columnNameKeywordMap.get(colName).toString() + " " + operator + " '" + value + "'";
                        LogPanel.this.colorizer.addRule("\u30c7\u30d5\u30a9\u30eb\u30c8", new ColorRule(expression, ExpressionRule.getRule((String)expression), c, ChainsawConstants.COLOR_DEFAULT_FOREGROUND));
                    }
                }
            }
        });
        JPopupMenu p = new JPopupMenu();
        AbstractAction clearFocusAction = new AbstractAction("\u300c\u8a73\u7d30\u300d\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u6d88\u53bb"){

            public void actionPerformed(ActionEvent e) {
                filterText.setText(null);
                LogPanel.this.ruleMediator.setRefinementRule(null);
            }
        };
        AbstractAction copyAction = new AbstractAction("\u30af\u30ea\u30c3\u30d7\u30dc\u30fc\u30c9\u306b\u30b3\u30d4\u30fc"){

            public void actionPerformed(ActionEvent e) {
                if (LogPanel.this.currentPoint != null) {
                    int column = LogPanel.this.table.columnAtPoint(LogPanel.this.currentPoint);
                    int row = LogPanel.this.table.rowAtPoint(LogPanel.this.currentPoint);
                    String colName = LogPanel.this.table.getColumnName(column).toUpperCase();
                    String value = "";
                    if (colName.equalsIgnoreCase("\u30bf\u30a4\u30e0\u30b9\u30bf\u30f3\u30d7")) {
                        JComponent comp = (JComponent)((Object)LogPanel.this.table.getCellRenderer(row, column));
                        if (comp instanceof JLabel) {
                            value = ((JLabel)comp).getText();
                        }
                    } else {
                        Object o = LogPanel.this.table.getValueAt(row, column);
                        if (o != null) {
                            if (o instanceof String[]) {
                                String[] ti = (String[])o;
                                if (!(ti.length <= 0 || ti.length == 1 && ti[0].equals(""))) {
                                    ExtendedLoggingEvent event = LogPanel.this.tableModel.getRow(row);
                                    value = event.getMessage().toString();
                                    for (int i = 0; i < ((String[])o).length; ++i) {
                                        value = value + "\n" + ((String[])o)[i];
                                    }
                                }
                            } else {
                                value = o.toString();
                            }
                        }
                    }
                    StringSelection selection = new StringSelection(value);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(selection, null);
                }
            }
        };
        JMenuItem menuItemToggleDock = new JMenuItem("\u5206\u96e2\uff0f\u63a5\u7d9a");
        this.dockingAction = new AbstractAction("Undock"){

            public void actionPerformed(ActionEvent evt) {
                if (LogPanel.this.isDocked()) {
                    LogPanel.this.undock();
                } else {
                    LogPanel.this.dock();
                }
            }
        };
        this.dockingAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.UNDOCK));
        menuItemToggleDock.setAction(this.dockingAction);
        p.add(menuItemFocusOn);
        p.add(menuDefineAddCustomFilter);
        p.add(clearFocusAction);
        p.add(new JSeparator());
        JMenuItem menuItemSearch = new JMenuItem("\u5024\u3092\u691c\u7d22");
        menuItemSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (LogPanel.this.currentPoint != null) {
                    String operator = "~=";
                    int column = LogPanel.this.table.columnAtPoint(LogPanel.this.currentPoint);
                    int row = LogPanel.this.table.rowAtPoint(LogPanel.this.currentPoint);
                    String colName = LogPanel.this.table.getColumnName(column).toUpperCase();
                    String value = "";
                    if (colName.equalsIgnoreCase("\u30bf\u30a4\u30e0\u30b9\u30bf\u30f3\u30d7")) {
                        value = LogPanel.this.timestampExpressionFormat.format(new Date(LogPanel.this.table.getValueAt(row, column).toString()));
                    } else {
                        Object o = LogPanel.this.table.getValueAt(row, column);
                        if (o != null) {
                            value = o instanceof String[] && ((String[])o).length > 0 ? ((String[])o)[0] : o.toString();
                        }
                    }
                    if (columnNameKeywordMap.containsKey(colName)) {
                        LogPanel.this.findField.setText(columnNameKeywordMap.get(colName).toString() + " " + operator + " '" + value + "'");
                        LogPanel.this.findNext();
                    }
                }
            }
        });
        AbstractAction clearSearchAction = new AbstractAction("\u691c\u7d22\u30d5\u30a3\u30fc\u30eb\u30c9\u3092\u6d88\u53bb"){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.findField.setText(null);
                LogPanel.this.updateFindRule(null);
            }
        };
        p.add(menuItemSearch);
        p.add(clearSearchAction);
        p.add(new JSeparator());
        p.add(menuItemBestFit);
        p.add(new JSeparator());
        final JMenuItem menuItemDisplayNormalTimes = new JMenuItem("\u76f8\u5bfe\u6642\u9593\u3092\u96a0\u3059");
        menuItemDisplayNormalTimes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (LogPanel.this.currentPoint != null) {
                    LogPanel.this.renderer.setUseNormalTimes();
                    LogPanel.this.tableModel.reFilter();
                    menuItemDisplayNormalTimes.setEnabled(false);
                }
            }
        });
        JMenuItem menuItemDisplayRelativeTimesToRowUnderCursor = new JMenuItem("\u3053\u306e\u30a4\u30d9\u30f3\u30c8\u306e\u76f8\u5bfe\u6642\u9593\u3092\u8868\u793a\u3059\u308b");
        menuItemDisplayRelativeTimesToRowUnderCursor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (LogPanel.this.currentPoint != null) {
                    int row = LogPanel.this.table.rowAtPoint(LogPanel.this.currentPoint);
                    ExtendedLoggingEvent event = LogPanel.this.tableModel.getRow(row);
                    if (event != null) {
                        LogPanel.this.renderer.setUseRelativeTimes(event.getTimeStamp());
                        LogPanel.this.tableModel.reFilter();
                    }
                    menuItemDisplayNormalTimes.setEnabled(true);
                }
            }
        });
        menuItemDisplayNormalTimes.setEnabled(false);
        p.add(menuItemDisplayRelativeTimesToRowUnderCursor);
        p.add(menuItemDisplayNormalTimes);
        p.add(new JSeparator());
        p.add(menuBuildColorRule);
        p.add(copyAction);
        p.add(new JSeparator());
        p.add(menuItemToggleDetails);
        p.add(menuItemLoggerTree);
        p.add(menuItemToggleToolTips);
        p.add(new JSeparator());
        p.add(menuItemScrollToTop);
        p.add(menuItemScrollBottom);
        p.add(new JSeparator());
        p.add(menuItemToggleDock);
        p.add(new JSeparator());
        p.add(menuItemColorPanel);
        p.add(menuItemLogPanelPreferences);
        PopupListener popupListener = new PopupListener(p);
        this.eventsPane.addMouseListener(popupListener);
        this.table.addMouseListener(popupListener);
    }

    public boolean isScrollToBottom() {
        return this.preferenceModel.isScrollToBottom();
    }

    public void setRefineFocusText(String refineFocusText) {
        JTextField filterText = (JTextField)this.filterCombo.getEditor().getEditorComponent();
        filterText.setText(refineFocusText);
    }

    public String getRefineFocusText() {
        JTextField filterText = (JTextField)this.filterCombo.getEditor().getEditorComponent();
        return filterText.getText();
    }

    public void toggleScrollToBottom() {
        this.preferenceModel.setScrollToBottom(!this.preferenceModel.isScrollToBottom());
    }

    private void scrollToBottom() {
        final int scrollRow = this.tableModel.getRowCount() - 1;
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                LogPanel.this.table.scrollToRow(scrollRow);
            }
        });
    }

    public void scrollToTop() {
        if (this.tableModel.getRowCount() > 1) {
            this.table.scrollToRow(0);
        }
    }

    public String getNamespace() {
        return this.getIdentifier();
    }

    public String getInterestedIdentifier() {
        return this.getIdentifier();
    }

    public void receiveEventBatch(String ident, final List events) {
        SwingHelper.invokeOnEDT(new Runnable(){

            public void run() {
                int newIndex;
                if (LogPanel.this.isPaused()) {
                    return;
                }
                int selectedRow = LogPanel.this.table.getSelectedRow();
                int startingRow = LogPanel.this.table.getRowCount();
                ExtendedLoggingEvent selectedEvent = selectedRow >= 0 ? LogPanel.this.tableModel.getRow(selectedRow) : null;
                boolean rowAdded = false;
                int addedRowCount = 0;
                Iterator iter = events.iterator();
                while (iter.hasNext()) {
                    ExtendedLoggingEvent event = new ExtendedLoggingEvent((LoggingEvent)iter.next());
                    if (LogPanel.this.clearTableExpressionRule != null && LogPanel.this.clearTableExpressionRule.evaluate((LoggingEvent)event, null)) {
                        LogPanel.this.logger.info((Object)("\u4e00\u81f4\u3057\u305f\u30c6\u30fc\u30d6\u30eb\u306e\u5f0f\u3092\u6d88\u53bb - \u30c6\u30fc\u30d6\u30eb\u306e\u6d88\u53bb - \u4e00\u81f4\u3057\u305f\u30a4\u30d9\u30f3\u30c8\u30e1\u30c3\u30bb\u30fc\u30b8 - " + event.getMessage()));
                        LogPanel.this.clearEvents();
                    }
                    LogPanel.this.updateOtherModels(event);
                    boolean isCurrentRowAdded = LogPanel.this.tableModel.isAddRow(event);
                    if (isCurrentRowAdded) {
                        ++addedRowCount;
                    }
                    rowAdded = rowAdded || isCurrentRowAdded;
                }
                if (rowAdded) {
                    LogPanel.this.tableModel.fireTableEvent(startingRow, startingRow + addedRowCount, addedRowCount);
                }
                LogPanel.this.tableModel.notifyCountListeners();
                if (rowAdded) {
                    if (LogPanel.this.tableModel.isSortEnabled()) {
                        LogPanel.this.tableModel.sort();
                    }
                    LogPanel.this.detailPaneUpdater.setSelectedRow(LogPanel.this.table.getSelectedRow());
                }
                if (!LogPanel.this.isScrollToBottom() && selectedEvent != null && (newIndex = LogPanel.this.tableModel.getRowIndex(selectedEvent)) >= 0) {
                    LogPanel.this.table.setRowSelectionInterval(newIndex, newIndex);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadSettings(LoadSettingsEvent event) {
        File xmlFile = new File(SettingsManager.getInstance().getSettingsDirectory(), URLEncoder.encode(this.identifier) + ".xml");
        if (xmlFile.exists()) {
            XStream stream = this.buildXStreamForLogPanelPreference();
            ObjectInputStream in = null;
            try {
                FileReader r = new FileReader(xmlFile);
                in = stream.createObjectInputStream((Reader)r);
                LogPanelPreferenceModel storedPrefs = (LogPanelPreferenceModel)in.readObject();
                int lowerPanelDividerLocation = in.readInt();
                int treeDividerLocation = in.readInt();
                String conversionPattern = in.readObject().toString();
                Point p = (Point)in.readObject();
                Dimension d = (Dimension)in.readObject();
                int versionNumber = 0;
                try {
                    versionNumber = in.readInt();
                }
                catch (EOFException eof) {
                    // empty catch block
                }
                if (versionNumber > 0) {
                    Vector savedVector = (Vector)in.readObject();
                    for (int i = 0; i < savedVector.size(); ++i) {
                        Object item = savedVector.get(i);
                        this.filterCombo.insertItemAt(item, 0);
                    }
                    if (versionNumber > 1) {
                        int index = 0;
                        String columnOrder = event.getSetting(TABLE_COLUMN_ORDER);
                        StringTokenizer tok = new StringTokenizer(columnOrder, ",");
                        while (tok.hasMoreElements()) {
                            String element = tok.nextElement().toString().trim().toUpperCase();
                            TableColumn column = new TableColumn(index++);
                            column.setHeaderValue(element);
                            this.preferenceModel.addColumn(column);
                        }
                        TableColumnModel columnModel = this.table.getColumnModel();
                        while (columnModel.getColumnCount() > 0) {
                            columnModel.removeColumn(columnModel.getColumn(0));
                        }
                        Iterator iter = this.preferenceModel.getVisibleColumnOrder().iterator();
                        while (iter.hasNext()) {
                            TableColumn col = (TableColumn)iter.next();
                            columnModel.addColumn(col);
                        }
                        this.preferenceModel.apply(storedPrefs);
                    } else {
                        this.loadDefaultColumnSettings(event);
                    }
                    this.lowerPanel.setDividerLocation(lowerPanelDividerLocation);
                    this.nameTreeAndMainPanelSplit.setDividerLocation(treeDividerLocation);
                    this.detailLayout.setConversionPattern(conversionPattern);
                    if (p.x != 0 && p.y != 0) {
                        ((Component)this.undockedFrame).setLocation(p.x, p.y);
                        this.undockedFrame.setSize(d);
                    }
                    ((Component)this.undockedFrame).setLocation(0, 0);
                    this.undockedFrame.setSize(new Dimension(1024, 768));
                }
                this.loadDefaultColumnSettings(event);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.loadDefaultColumnSettings(event);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe) {}
                }
            }
        } else {
            this.loadDefaultColumnSettings(event);
        }
        this.logTreePanel.ignore(this.preferenceModel.getHiddenLoggers());
        this.logTreePanel.setHiddenExpression(this.preferenceModel.getHiddenExpression());
        if (this.preferenceModel.getClearTableExpression() != null) {
            try {
                this.clearTableExpressionRule = ExpressionRule.getRule((String)this.preferenceModel.getClearTableExpression());
            }
            catch (Exception e) {
                this.clearTableExpressionRule = null;
            }
        }
        this.colorizer.loadColorSettings(this.identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettings(SaveSettingsEvent event) {
        File xmlFile = new File(SettingsManager.getInstance().getSettingsDirectory(), URLEncoder.encode(this.identifier) + ".xml");
        this.preferenceModel.setHiddenLoggers(new HashSet(this.logTreePanel.getHiddenSet()));
        this.preferenceModel.setHiddenExpression(this.logTreePanel.getHiddenExpression());
        ArrayList<TableColumn> visibleOrder = new ArrayList<TableColumn>();
        Enumeration<TableColumn> cols = this.table.getColumnModel().getColumns();
        while (cols.hasMoreElements()) {
            TableColumn c = cols.nextElement();
            visibleOrder.add(c);
        }
        this.preferenceModel.setVisibleColumnOrder(visibleOrder);
        XStream stream = this.buildXStreamForLogPanelPreference();
        ObjectOutputStream s = null;
        try {
            FileWriter w = new FileWriter(xmlFile);
            s = stream.createObjectOutputStream((Writer)w);
            s.writeObject(this.preferenceModel);
            s.writeInt(this.lowerPanel.getDividerLocation());
            s.writeInt(this.nameTreeAndMainPanelSplit.getDividerLocation());
            s.writeObject(this.detailLayout.getConversionPattern());
            s.writeObject(this.undockedFrame.getLocation());
            s.writeObject(this.undockedFrame.getSize());
            s.writeInt(2);
            s.writeObject(this.filterCombo.getModelData());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException ioe) {}
            }
        }
        this.colorizer.saveColorSettings(this.identifier);
    }

    private XStream buildXStreamForLogPanelPreference() {
        XStream stream = new XStream((HierarchicalStreamDriver)new DomDriver());
        stream.registerConverter((Converter)new TableColumnConverter());
        return stream;
    }

    void showPreferences() {
        LogPanel.centerAndSetVisible(this.logPanelPreferencesFrame);
    }

    public static void centerAndSetVisible(Window window) {
        Dimension screenDimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)window).setLocation(new Point(screenDimension.width / 2 - window.getSize().width / 2, screenDimension.height / 2 - window.getSize().height / 2));
        window.setVisible(true);
    }

    void showColorPreferences() {
        this.colorPanel.loadLogPanelColorizers();
        this.colorFrame.pack();
        LogPanel.centerAndSetVisible(this.colorFrame);
    }

    void toggleDetailVisible() {
        this.preferenceModel.setDetailPaneVisible(!this.preferenceModel.isDetailPaneVisible());
    }

    boolean isDetailVisible() {
        return this.preferenceModel.isDetailPaneVisible();
    }

    void toggleLogTreeVisible() {
        this.preferenceModel.setLogTreePanelVisible(!this.preferenceModel.isLogTreePanelVisible());
    }

    boolean isLogTreeVisible() {
        return this.preferenceModel.isLogTreePanelVisible();
    }

    List getEvents() {
        return this.tableModel.getAllEvents();
    }

    List getFilteredEvents() {
        return this.tableModel.getFilteredEvents();
    }

    List getMatchingEvents(Rule rule) {
        return this.tableModel.getMatchingEvents(rule);
    }

    void clearEvents() {
        this.clearModel();
    }

    String getIdentifier() {
        return this.identifier;
    }

    void undock() {
        int row = this.table.getSelectedRow();
        this.setDocked(false);
        this.externalPanel.removeAll();
        this.findPanel.removeAll();
        JLabel searchLabel = new JLabel("\u691c\u7d22\uff1a");
        searchLabel.setDisplayedMnemonic('j');
        searchLabel.setFont(searchLabel.getFont().deriveFont(1));
        this.findPanel.add(searchLabel);
        this.findPanel.add(Box.createHorizontalStrut(3));
        this.findPanel.add(this.findField);
        this.findPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        searchLabel.setLabelFor(this.findField);
        this.externalPanel.add((Component)this.undockedToolbar, "North");
        this.externalPanel.add((Component)this.nameTreeAndMainPanelSplit, "Center");
        this.externalPanel.setDocked(false);
        this.undockedFrame.pack();
        this.undockedFrame.setVisible(true);
        this.dockingAction.putValue("Name", "Dock");
        this.dockingAction.putValue("SmallIcon", ChainsawIcons.ICON_DOCK);
        if (row > -1) {
            this.table.scrollToRow(row);
        }
    }

    void addEventCountListener(EventCountListener l) {
        this.tableModel.addEventCountListener(l);
    }

    boolean isPaused() {
        return this.paused;
    }

    void setPaused(boolean paused) {
        boolean oldValue = this.paused;
        this.paused = paused;
        this.firePropertyChange("paused", oldValue, paused);
    }

    int setSelectedEvent(int eventNumber) {
        int row = this.tableModel.locate(ExpressionRule.getRule((String)("prop.log4jid == " + eventNumber)), 0, true);
        if (row > -1) {
            this.preferenceModel.setScrollToBottom(false);
            this.table.scrollTo(row, 0);
        }
        return row;
    }

    void addPreferencePropertyChangeListener(PropertyChangeListener listener) {
        this.preferenceModel.addPropertyChangeListener(listener);
    }

    void toggleCyclic() {
        this.tableModel.setCyclic(!this.tableModel.isCyclic());
    }

    boolean isCyclic() {
        return this.tableModel.isCyclic();
    }

    public void updateFindRule(String ruleText) {
        if (ruleText == null || ruleText.trim().equals("")) {
            this.findRule = null;
            this.tableModel.updateEventsWithFindRule(null);
            this.colorizer.setFindRule(null);
            this.findField.setBackground(UIManager.getColor("TextField.background"));
            this.findField.setToolTipText("\u5f0f\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044 - \u53f3\u30af\u30ea\u30c3\u30af\u53c8\u306fctrl+space");
            this.currentSearchMatchCount = 0;
            this.statusBar.setSearchMatchCount(this.currentSearchMatchCount, this.getIdentifier());
        } else {
            this.preferenceModel.setScrollToBottom(false);
            if (ruleText.equals(this.currentFindRuleText)) {
                return;
            }
            this.currentFindRuleText = ruleText;
            try {
                this.findField.setToolTipText("\u5f0f\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044 - \u53f3\u30af\u30ea\u30c3\u30af\u53c8\u306fctrl+space");
                this.findRule = ExpressionRule.getRule((String)ruleText);
                this.currentSearchMatchCount = this.tableModel.updateEventsWithFindRule(this.findRule);
                this.colorizer.setFindRule(this.findRule);
                this.findField.setBackground(UIManager.getColor("TextField.background"));
                this.statusBar.setSearchMatchCount(this.currentSearchMatchCount, this.getIdentifier());
            }
            catch (IllegalArgumentException re) {
                this.findField.setToolTipText(re.getMessage());
                this.findField.setBackground(ChainsawConstants.INVALID_EXPRESSION_BACKGROUND);
                this.colorizer.setFindRule(null);
                this.tableModel.updateEventsWithFindRule(null);
                this.currentSearchMatchCount = 0;
                this.statusBar.setSearchMatchCount(this.currentSearchMatchCount, this.getIdentifier());
            }
        }
    }

    private void showDetailPane() {
        this.lowerPanel.setDividerSize(this.dividerSize);
        this.lowerPanel.setDividerLocation(this.lastDetailPanelSplitLocation);
        this.detailPanel.setVisible(true);
        this.lowerPanel.repaint();
    }

    private void hideDetailPane() {
        int currentSize = this.lowerPanel.getHeight() - this.lowerPanel.getDividerSize();
        if (currentSize > 0) {
            this.lastDetailPanelSplitLocation = (double)this.lowerPanel.getDividerLocation() / (double)currentSize;
        }
        this.lowerPanel.setDividerSize(0);
        this.detailPanel.setVisible(false);
        this.lowerPanel.repaint();
    }

    private void showLogTreePanel() {
        this.nameTreeAndMainPanelSplit.setDividerSize(this.dividerSize);
        this.nameTreeAndMainPanelSplit.setDividerLocation(this.lastLogTreePanelSplitLocation);
        this.logTreePanel.setVisible(true);
        this.nameTreeAndMainPanelSplit.repaint();
    }

    private void hideLogTreePanel() {
        int currentSize = this.nameTreeAndMainPanelSplit.getWidth() - this.nameTreeAndMainPanelSplit.getDividerSize() - 1;
        if (currentSize > 0) {
            this.lastLogTreePanelSplitLocation = (double)this.nameTreeAndMainPanelSplit.getDividerLocation() / (double)currentSize;
        }
        this.nameTreeAndMainPanelSplit.setDividerSize(0);
        this.logTreePanel.setVisible(false);
        this.nameTreeAndMainPanelSplit.repaint();
    }

    private JToolBar createDockwindowToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        AbstractAction dockPauseAction = new AbstractAction("Pause"){

            public void actionPerformed(ActionEvent evt) {
                LogPanel.this.setPaused(!LogPanel.this.isPaused());
            }
        };
        dockPauseAction.putValue("MnemonicKey", new Integer(80));
        dockPauseAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F12"));
        dockPauseAction.putValue("ShortDescription", "\u8868\u793a\u3092\u505c\u6b62\u3002\u30d0\u30c3\u30af\u30b0\u30e9\u30a6\u30f3\u30c9\u3067\u30a4\u30d9\u30f3\u30c8\u306f\u7d99\u7d9a\u7684\u306b\u53d6\u5f97\u3059\u308b");
        dockPauseAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.PAUSE));
        final SmallToggleButton dockPauseButton = new SmallToggleButton(dockPauseAction);
        dockPauseButton.setText("");
        dockPauseButton.getModel().setSelected(this.isPaused());
        this.addPropertyChangeListener("paused", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                dockPauseButton.getModel().setSelected(LogPanel.this.isPaused());
            }
        });
        toolbar.add(dockPauseButton);
        AbstractAction dockShowPrefsAction = new AbstractAction(""){

            public void actionPerformed(ActionEvent arg0) {
                LogPanel.this.showPreferences();
            }
        };
        dockShowPrefsAction.putValue("ShortDescription", "\u8a2d\u5b9a\u306e\u6307\u5b9a...");
        dockShowPrefsAction.putValue("SmallIcon", ChainsawIcons.ICON_PREFERENCES);
        toolbar.add(new SmallButton(dockShowPrefsAction));
        AbstractAction dockToggleLogTreeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.toggleLogTreeVisible();
            }
        };
        dockToggleLogTreeAction.putValue("ShortDescription", "\u30ed\u30b0\u30c4\u30ea\u30fc\u30d1\u30cd\u30eb\u306e\u5207\u308a\u66ff\u3048");
        dockToggleLogTreeAction.putValue("enabled", Boolean.TRUE);
        dockToggleLogTreeAction.putValue("MnemonicKey", new Integer(84));
        dockToggleLogTreeAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 8));
        dockToggleLogTreeAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.WINDOW_ICON));
        final SmallToggleButton toggleLogTreeButton = new SmallToggleButton(dockToggleLogTreeAction);
        this.preferenceModel.addPropertyChangeListener("logTreePanelVisible", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                toggleLogTreeButton.setSelected(LogPanel.this.preferenceModel.isLogTreePanelVisible());
            }
        });
        toggleLogTreeButton.setSelected(this.isLogTreeVisible());
        toolbar.add(toggleLogTreeButton);
        toolbar.addSeparator();
        AbstractAction undockedClearAction = new AbstractAction("Clear"){

            public void actionPerformed(ActionEvent arg0) {
                LogPanel.this.clearModel();
            }
        };
        undockedClearAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.DELETE));
        undockedClearAction.putValue("ShortDescription", "\u73fe\u5728\u306e\u30d3\u30e5\u30fc\u304b\u3089\u3059\u3079\u3066\u306e\u30a4\u30d9\u30f3\u30c8\u3092\u524a\u9664");
        SmallButton dockClearButton = new SmallButton(undockedClearAction);
        dockClearButton.getInputMap(1).put(KeyStroke.getKeyStroke(8, 2), undockedClearAction.getValue("Name"));
        dockClearButton.getActionMap().put(undockedClearAction.getValue("Name"), undockedClearAction);
        dockClearButton.setText("");
        toolbar.add(dockClearButton);
        toolbar.addSeparator();
        AbstractAction dockToggleScrollToBottomAction = new AbstractAction("\u4e0b\u307e\u3067\u30b9\u30af\u30ed\u30fc\u30eb\u306e\u5207\u308a\u66ff\u3048"){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.toggleScrollToBottom();
            }
        };
        dockToggleScrollToBottomAction.putValue("ShortDescription", "\u4e0b\u307e\u3067\u30b9\u30af\u30ed\u30fc\u30eb\u306e\u5207\u308a\u66ff\u3048");
        dockToggleScrollToBottomAction.putValue("enabled", Boolean.TRUE);
        dockToggleScrollToBottomAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.SCROLL_TO_BOTTOM));
        final SmallToggleButton toggleScrollToBottomButton = new SmallToggleButton(dockToggleScrollToBottomAction);
        this.preferenceModel.addPropertyChangeListener("scrollToBottom", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                toggleScrollToBottomButton.setSelected(LogPanel.this.isScrollToBottom());
            }
        });
        toggleScrollToBottomButton.getInputMap(1).put(KeyStroke.getKeyStroke(66, 2), dockToggleScrollToBottomAction.getValue("Name"));
        toggleScrollToBottomButton.getActionMap().put(dockToggleScrollToBottomAction.getValue("Name"), dockToggleScrollToBottomAction);
        toggleScrollToBottomButton.setSelected(this.isScrollToBottom());
        toggleScrollToBottomButton.setText("");
        toolbar.add(toggleScrollToBottomButton);
        toolbar.addSeparator();
        this.findField = new JTextField();
        Dimension findSize = new Dimension(260, 22);
        this.findField.setPreferredSize(findSize);
        this.findField.setMaximumSize(findSize);
        this.findField.setMinimumSize(findSize);
        this.findPanel.setAlignmentY(0.5f);
        this.findField.setAlignmentY(0.5f);
        this.findField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.findNext();
            }
        });
        this.findField.addKeyListener(new ExpressionRuleContext(this.filterModel, this.findField));
        AbstractAction undockedFindNextAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.findNext();
            }
        };
        undockedFindNextAction.putValue("Name", "\u6b21\u306e\u691c\u7d22");
        undockedFindNextAction.putValue("ShortDescription", "\u6b21\u306e\u4e00\u81f4\u3059\u308b\u30a4\u30d9\u30f3\u30c8\u3092\u691c\u7d22\u3059\u308b");
        undockedFindNextAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.DOWN));
        SmallButton undockedFindNextButton = new SmallButton(undockedFindNextAction);
        undockedFindNextButton.setAction(undockedFindNextAction);
        undockedFindNextButton.setText("");
        undockedFindNextButton.getActionMap().put(undockedFindNextAction.getValue("Name"), undockedFindNextAction);
        undockedFindNextButton.getInputMap(2).put(KeyStroke.getKeyStroke("F3"), undockedFindNextAction.getValue("Name"));
        AbstractAction undockedFindPreviousAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                LogPanel.this.findPrevious();
            }
        };
        undockedFindPreviousAction.putValue("Name", "\u524d\u3092\u691c\u7d22");
        undockedFindPreviousAction.putValue("ShortDescription", "\u524d\u306e\u4e00\u81f4\u3059\u308b\u30a4\u30d9\u30f3\u30c8\u3092\u691c\u7d22\u3059\u308b");
        undockedFindPreviousAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.UP));
        SmallButton undockedFindPreviousButton = new SmallButton(undockedFindPreviousAction);
        undockedFindPreviousButton.setAction(undockedFindPreviousAction);
        undockedFindPreviousButton.setText("");
        undockedFindPreviousButton.getActionMap().put(undockedFindPreviousAction.getValue("Name"), undockedFindPreviousAction);
        undockedFindPreviousButton.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), undockedFindPreviousAction.getValue("Name"));
        Dimension findPanelSize = new Dimension(310, 30);
        this.findPanel.setPreferredSize(findPanelSize);
        this.findPanel.setMaximumSize(findPanelSize);
        this.findPanel.setMinimumSize(findPanelSize);
        this.findField.setPreferredSize(findSize);
        this.findField.setMaximumSize(findSize);
        this.findField.setMinimumSize(findSize);
        this.findPanel.setAlignmentY(0.5f);
        this.findField.setAlignmentY(0.5f);
        toolbar.add(this.findPanel);
        toolbar.addSeparator(new Dimension(7, 5));
        toolbar.add(undockedFindNextButton);
        toolbar.add(undockedFindPreviousButton);
        toolbar.addSeparator();
        AbstractAction redockAction = new AbstractAction("", ChainsawIcons.ICON_DOCK){

            public void actionPerformed(ActionEvent arg0) {
                LogPanel.this.dock();
            }
        };
        redockAction.putValue("ShortDescription", "\u3053\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u3092\u30e1\u30a4\u30f3Chainsaw\u30a6\u30a3\u30f3\u30c9\u30a6\u306b\u63a5\u7d9a\u3059\u308b");
        SmallButton redockButton = new SmallButton(redockAction);
        toolbar.add(redockButton);
        return toolbar;
    }

    protected void updateStatusBar() {
        SwingHelper.invokeOnEDT(new Runnable(){

            public void run() {
                LogPanel.this.statusBar.setSelectedLine(LogPanel.this.table.getSelectedRow() + 1, LogPanel.this.tableModel.getRowCount(), LogPanel.this.tableModel.size(), LogPanel.this.getIdentifier());
                LogPanel.this.statusBar.setSearchMatchCount(LogPanel.this.currentSearchMatchCount, LogPanel.this.getIdentifier());
            }
        });
    }

    private void setDetailPaneConversionPattern(String conversionPattern) {
        String oldPattern = this.getDetailPaneConversionPattern();
        this.detailLayout.setConversionPattern(conversionPattern);
        this.firePropertyChange("detailPaneConversionPattern", oldPattern, this.getDetailPaneConversionPattern());
    }

    private String getDetailPaneConversionPattern() {
        return this.detailLayout.getConversionPattern();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearModel() {
        this.previousLastIndex = -1;
        this.tableModel.clearModel();
        JEditorPane jEditorPane = this.detail;
        synchronized (jEditorPane) {
            this.detailPaneUpdater.setSelectedRow(-1);
            this.detail.notify();
        }
        this.statusBar.setNothingSelected();
    }

    public void findNextColorizedEvent() {
        int nextRow = this.tableModel.findColoredRow(this.table.getSelectedRow() + 1, true);
        if (nextRow > -1) {
            this.table.scrollToRow(nextRow);
        }
    }

    public void findPreviousColorizedEvent() {
        int previousRow = this.tableModel.findColoredRow(this.table.getSelectedRow() - 1, false);
        if (previousRow > -1) {
            this.table.scrollToRow(previousRow);
        }
    }

    public void findNext() {
        this.updateFindRule(this.findField.getText());
        if (this.findRule != null) {
            try {
                int nextRow;
                int filteredEventsSize = this.getFilteredEvents().size();
                int startRow = this.table.getSelectedRow() + 1;
                if (startRow > filteredEventsSize - 1) {
                    startRow = 0;
                }
                if ((nextRow = this.tableModel.locate(this.findRule, startRow, true)) > -1) {
                    this.table.scrollToRow(nextRow);
                    this.findField.setToolTipText("\u5f0f\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
                }
            }
            catch (IllegalArgumentException iae) {
                this.findField.setToolTipText(iae.getMessage());
                this.colorizer.setFindRule(null);
            }
        }
    }

    public void findPrevious() {
        this.updateFindRule(this.findField.getText());
        if (this.findRule != null) {
            try {
                int previousRow;
                int startRow = this.table.getSelectedRow() - 1;
                int filteredEventsSize = this.getFilteredEvents().size();
                if (startRow < 0) {
                    startRow = filteredEventsSize - 1;
                }
                if ((previousRow = this.tableModel.locate(this.findRule, startRow, false)) > -1) {
                    this.table.scrollToRow(previousRow);
                    this.findField.setToolTipText("\u5f0f\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
                }
            }
            catch (IllegalArgumentException iae) {
                this.findField.setToolTipText(iae.getMessage());
            }
        }
    }

    private void dock() {
        int row = this.table.getSelectedRow();
        this.setDocked(true);
        this.undockedFrame.setVisible(false);
        this.removeAll();
        this.add((Component)this.nameTreeAndMainPanelSplit, "Center");
        this.externalPanel.setDocked(true);
        this.dockingAction.putValue("Name", "Undock");
        this.dockingAction.putValue("SmallIcon", ChainsawIcons.ICON_UNDOCK);
        if (row > -1) {
            this.table.scrollToRow(row);
        }
    }

    private void loadDefaultColumnSettings(LoadSettingsEvent event) {
        Object element;
        String columnOrder = event.getSetting(TABLE_COLUMN_ORDER);
        TableColumnModel columnModel = this.table.getColumnModel();
        HashMap<String, TableColumn> columnNameMap = new HashMap<String, TableColumn>();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnNameMap.put(this.table.getColumnName(i).toUpperCase(), columnModel.getColumn(i));
        }
        int index = 0;
        StringTokenizer tok = new StringTokenizer(columnOrder, ",");
        ArrayList<TableColumn> sortedColumnList = new ArrayList<TableColumn>();
        while (tok.hasMoreElements()) {
            String element2 = tok.nextElement().toString().trim().toUpperCase();
            TableColumn column = (TableColumn)columnNameMap.get(element2);
            if (column == null) continue;
            sortedColumnList.add(column);
            this.table.removeColumn(column);
        }
        this.preferenceModel.setDetailPaneVisible(event.asBoolean("detailPaneVisible"));
        this.preferenceModel.setLogTreePanelVisible(event.asBoolean("logTreePanelVisible"));
        this.preferenceModel.setHighlightSearchMatchText(event.asBoolean("highlightSearchMatchText"));
        Iterator iter = sortedColumnList.iterator();
        while (iter.hasNext()) {
            element = (TableColumn)iter.next();
            if (!this.preferenceModel.addColumn((TableColumn)element)) continue;
            this.table.addColumn((TableColumn)element);
            this.preferenceModel.setColumnVisible(((TableColumn)element).getHeaderValue().toString(), true);
        }
        String columnWidths = event.getSetting(TABLE_COLUMN_WIDTHS);
        tok = new StringTokenizer(columnWidths, ",");
        index = 0;
        while (tok.hasMoreElements()) {
            element = (String)tok.nextElement();
            try {
                int width = Integer.parseInt((String)element);
                if (index > columnModel.getColumnCount() - 1) {
                    this.logger.warn((Object)("loadsettings - \u30a4\u30f3\u30c7\u30a3\u30af\u30b9\u306e\u5e45\u306e\u8a2d\u5b9a\u306b\u5931\u6557\u3057\u307e\u3057\u305f " + index + ", width " + (String)element));
                } else {
                    columnModel.getColumn(index).setPreferredWidth(width);
                }
                ++index;
            }
            catch (NumberFormatException e) {
                this.logger.error((Object)"\u30c6\u30fc\u30d6\u30eb\u5e45\u306e\u30c7\u30b3\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f", (Throwable)e);
            }
        }
        this.undockedFrame.setSize(this.getSize());
        ((Component)this.undockedFrame).setLocation(this.getBounds().x, this.getBounds().y);
        this.repaint();
    }

    public JTextField getFindTextField() {
        return this.findField;
    }

    private int getMaxColumnWidth(int index) {
        FontMetrics metrics = this.getGraphics().getFontMetrics();
        int longestWidth = metrics.stringWidth("  " + this.table.getColumnName(index) + "  ") + 2 * this.table.getColumnModel().getColumnMargin();
        int j = this.tableModel.getRowCount();
        for (int i = 0; i < j; ++i) {
            Component c = this.renderer.getTableCellRendererComponent(this.table, this.table.getValueAt(i, index), false, false, i, index);
            if (!(c instanceof JLabel)) continue;
            longestWidth = Math.max(longestWidth, metrics.stringWidth(((JLabel)c).getText()));
        }
        return longestWidth + 5;
    }

    private String getToolTipTextForEvent(ExtendedLoggingEvent event) {
        StringBuffer buf = new StringBuffer();
        buf.append(this.detailLayout.getHeader()).append(this.detailLayout.format(event)).append(this.detailLayout.getFooter());
        return buf.toString();
    }

    private void updateOtherModels(LoggingEvent event) {
        this.tableModel.addLoggerName(event.getLoggerName());
        this.filterModel.processNewLoggingEvent(event);
    }

    public void findNextMarker() {
        int nextRow;
        int filteredEventsSize;
        int startRow = this.table.getSelectedRow() + 1;
        if (startRow > (filteredEventsSize = this.getFilteredEvents().size()) - 1) {
            startRow = 0;
        }
        if ((nextRow = this.tableModel.locate(this.findMarkerRule, startRow, true)) > -1) {
            this.table.scrollToRow(nextRow);
        }
    }

    public void findPreviousMarker() {
        int previousRow;
        int startRow = this.table.getSelectedRow() - 1;
        int filteredEventsSize = this.getFilteredEvents().size();
        if (startRow < 0) {
            startRow = filteredEventsSize - 1;
        }
        if ((previousRow = this.tableModel.locate(this.findMarkerRule, startRow, false)) > -1) {
            this.table.scrollToRow(previousRow);
        }
    }

    public void clearAllMarkers() {
        this.tableModel.removePropertyFromEvents("log4j.marker");
    }

    public void toggleMarker() {
        ExtendedLoggingEvent event;
        int row = this.table.getSelectedRow();
        if (row != -1 && (event = this.tableModel.getRow(row)) != null) {
            String marker = event.getProperty("log4j.marker");
            if (marker == null) {
                event.setProperty("log4j.marker", "set");
            } else {
                event.removeProperty("log4j.marker");
            }
            this.tableModel.fireRowUpdated(row, marker == null);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class AutoFilterComboBox
    extends JComboBox {
        private boolean bypassFiltering;
        private List allEntries = new ArrayList();
        private List displayedEntries = new ArrayList();
        private AutoFilterComboBoxModel model = new AutoFilterComboBoxModel();
        private final JTextField textField = new JTextField();
        private String lastTextToMatch;

        public AutoFilterComboBox(Collection entries) {
            if (entries != null) {
                Iterator iter = entries.iterator();
                while (iter.hasNext()) {
                    Object nextObject = iter.next();
                    this.model.addElement(nextObject);
                }
            }
            this.setModel(this.model);
            this.setEditor(new AutoFilterEditor());
            ((JTextField)this.getEditor().getEditorComponent()).getDocument().addDocumentListener(new AutoFilterDocumentListener());
            this.setEditable(true);
            this.addPopupMenuListener(new PopupMenuListenerImpl());
        }

        public Vector getModelData() {
            Vector vector = new Vector();
            Iterator iter = this.allEntries.iterator();
            while (iter.hasNext()) {
                vector.insertElementAt(iter.next(), 0);
            }
            return vector;
        }

        private void refilter() {
            String textToMatch = this.getEditor().getItem().toString();
            if (this.bypassFiltering || this.lastTextToMatch != null && this.lastTextToMatch.equals(textToMatch)) {
                return;
            }
            this.lastTextToMatch = textToMatch;
            this.displayedEntries.clear();
            this.bypassFiltering = true;
            this.model.removeAllElements();
            ArrayList entriesCopy = new ArrayList(this.allEntries);
            Iterator iter = entriesCopy.iterator();
            while (iter.hasNext()) {
                String thisEntry = iter.next().toString();
                if (!thisEntry.toLowerCase().contains(textToMatch.toLowerCase())) continue;
                this.displayedEntries.add(thisEntry);
                this.model.addElement(thisEntry);
            }
            this.bypassFiltering = false;
            if (this.displayedEntries.size() > 0 && !textToMatch.equals("")) {
                this.showPopup();
            } else {
                this.hidePopup();
            }
        }

        private class PopupMenuListenerImpl
        implements PopupMenuListener {
            private boolean willBecomeVisible = false;

            private PopupMenuListenerImpl() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                AutoFilterComboBox.this.bypassFiltering = true;
                ((JComboBox)e.getSource()).setSelectedIndex(-1);
                AutoFilterComboBox.this.bypassFiltering = false;
                if (!this.willBecomeVisible) {
                    if (AutoFilterComboBox.this.displayedEntries.contains(AutoFilterComboBox.this.textField.getText())) {
                        AutoFilterComboBox.this.model.showAllElements();
                    }
                    JComboBox list = (JComboBox)e.getSource();
                    this.willBecomeVisible = true;
                    try {
                        list.getUI().setPopupVisible(list, true);
                    }
                    finally {
                        this.willBecomeVisible = false;
                    }
                }
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        }

        class AutoFilterComboBoxModel
        extends AbstractListModel
        implements MutableComboBoxModel {
            private Object selectedItem;

            AutoFilterComboBoxModel() {
            }

            public void addElement(Object obj) {
                if (AutoFilterComboBox.this.allEntries.contains(obj)) {
                    return;
                }
                AutoFilterComboBox.this.bypassFiltering = true;
                AutoFilterComboBox.this.allEntries.add(obj);
                AutoFilterComboBox.this.displayedEntries.add(obj);
                this.fireIntervalAdded(this, AutoFilterComboBox.this.displayedEntries.size() - 1, AutoFilterComboBox.this.displayedEntries.size() - 1);
                AutoFilterComboBox.this.bypassFiltering = false;
            }

            public void removeElement(Object obj) {
                int index = AutoFilterComboBox.this.displayedEntries.indexOf(obj);
                if (index != -1) {
                    this.removeElementAt(index);
                }
            }

            public void insertElementAt(Object obj, int index) {
                if (AutoFilterComboBox.this.allEntries.contains(obj)) {
                    return;
                }
                AutoFilterComboBox.this.bypassFiltering = true;
                AutoFilterComboBox.this.displayedEntries.add(index, obj);
                AutoFilterComboBox.this.allEntries.add(index, obj);
                this.fireIntervalAdded(this, index, index);
                AutoFilterComboBox.this.bypassFiltering = false;
                AutoFilterComboBox.this.refilter();
            }

            public void removeElementAt(int index) {
                AutoFilterComboBox.this.bypassFiltering = true;
                Object obj = AutoFilterComboBox.this.displayedEntries.get(index);
                AutoFilterComboBox.this.allEntries.remove(obj);
                this.fireContentsChanged(this, 0, AutoFilterComboBox.this.displayedEntries.size());
                AutoFilterComboBox.this.bypassFiltering = false;
                AutoFilterComboBox.this.refilter();
            }

            public void setSelectedItem(Object item) {
                if (this.selectedItem != null && !this.selectedItem.equals(item) || this.selectedItem == null && item != null) {
                    this.selectedItem = item;
                    this.fireContentsChanged(this, -1, -1);
                }
            }

            public Object getSelectedItem() {
                return this.selectedItem;
            }

            public int getSize() {
                return AutoFilterComboBox.this.displayedEntries.size();
            }

            public Object getElementAt(int index) {
                if (index >= 0 && index < AutoFilterComboBox.this.displayedEntries.size()) {
                    return AutoFilterComboBox.this.displayedEntries.get(index);
                }
                return null;
            }

            public void removeAllElements() {
                AutoFilterComboBox.this.bypassFiltering = true;
                AutoFilterComboBox.this.displayedEntries.clear();
                this.fireContentsChanged(this, 0, AutoFilterComboBox.this.displayedEntries.size());
                AutoFilterComboBox.this.bypassFiltering = false;
            }

            public void showAllElements() {
                AutoFilterComboBox.this.bypassFiltering = true;
                AutoFilterComboBox.this.displayedEntries.clear();
                AutoFilterComboBox.this.displayedEntries.addAll(AutoFilterComboBox.this.allEntries);
                this.fireContentsChanged(this, 0, AutoFilterComboBox.this.displayedEntries.size());
                AutoFilterComboBox.this.bypassFiltering = false;
            }
        }

        class AutoFilterDocumentListener
        implements DocumentListener {
            AutoFilterDocumentListener() {
            }

            public void insertUpdate(DocumentEvent e) {
                AutoFilterComboBox.this.refilter();
            }

            public void removeUpdate(DocumentEvent e) {
                AutoFilterComboBox.this.refilter();
            }

            public void changedUpdate(DocumentEvent e) {
                AutoFilterComboBox.this.refilter();
            }
        }

        class AutoFilterEditor
        implements ComboBoxEditor {
            AutoFilterEditor() {
            }

            public Component getEditorComponent() {
                return AutoFilterComboBox.this.textField;
            }

            public void setItem(Object item) {
                if (AutoFilterComboBox.this.bypassFiltering) {
                    return;
                }
                AutoFilterComboBox.this.bypassFiltering = true;
                if (item == null) {
                    AutoFilterComboBox.this.textField.setText("");
                } else {
                    AutoFilterComboBox.this.textField.setText(item.toString());
                }
                AutoFilterComboBox.this.bypassFiltering = false;
            }

            public Object getItem() {
                return AutoFilterComboBox.this.textField.getText();
            }

            public void selectAll() {
                AutoFilterComboBox.this.textField.selectAll();
            }

            public void addActionListener(ActionListener listener) {
                AutoFilterComboBox.this.textField.addActionListener(listener);
            }

            public void removeActionListener(ActionListener listener) {
                AutoFilterComboBox.this.textField.removeActionListener(listener);
            }
        }
    }

    private class EventMatchThumbnail
    extends JPanel {
        private List all = new ArrayList();
        private List findMatches = new ArrayList();
        private final int maxEventHeight = 6;

        public EventMatchThumbnail() {
            this.configureColors();
            LogPanel.this.colorizer.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    EventMatchThumbnail.this.configureColors();
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                public void mouseMoved(MouseEvent e) {
                    if (LogPanel.this.preferenceModel.isThumbnailBarToolTips()) {
                        int yPosition = e.getPoint().y;
                        EventWrapper event = EventMatchThumbnail.this.getEventWrapperAtPosition(yPosition);
                        if (event != null) {
                            EventMatchThumbnail.this.setToolTipText(LogPanel.this.getToolTipTextForEvent(event.loggingEvent));
                        }
                    } else {
                        EventMatchThumbnail.this.setToolTipText(null);
                    }
                }
            });
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    int yPosition = e.getPoint().y;
                    EventWrapper event = EventMatchThumbnail.this.getEventWrapperAtPosition(yPosition);
                    if (event != null) {
                        int id = new Integer(event.loggingEvent.getProperty("log4jid"));
                        LogPanel.this.setSelectedEvent(id);
                    }
                }
            });
            LogPanel.this.tableModel.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent e) {
                    int firstRow = e.getFirstRow();
                    int lastRow = Math.min(e.getLastRow(), LogPanel.this.table.getRowCount() - 1);
                    if (firstRow < 0 || lastRow < 0) {
                        EventMatchThumbnail.this.all.clear();
                        EventMatchThumbnail.this.findMatches.clear();
                    }
                    List displayedEvents = LogPanel.this.tableModel.getFilteredEvents();
                    if (e.getType() == 1) {
                        for (int i = firstRow; i < lastRow; ++i) {
                            ExtendedLoggingEvent event = (ExtendedLoggingEvent)((Object)displayedEvents.get(i));
                            EventWrapper wrapper = new EventWrapper(i, event);
                            if (event.isSearchMatch()) {
                                EventMatchThumbnail.this.findMatches.add(wrapper);
                            }
                            if (wrapper.loggingEvent.getColorRuleBackground().equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND)) continue;
                            EventMatchThumbnail.this.all.add(wrapper);
                        }
                    } else if (e.getType() == -1) {
                        EventWrapper wrapper;
                        Iterator iter = EventMatchThumbnail.this.findMatches.iterator();
                        while (iter.hasNext()) {
                            wrapper = (EventWrapper)iter.next();
                            if (wrapper.rowNum < firstRow || wrapper.rowNum > lastRow) continue;
                            iter.remove();
                        }
                        iter = EventMatchThumbnail.this.all.iterator();
                        while (iter.hasNext()) {
                            wrapper = (EventWrapper)iter.next();
                            if (wrapper.rowNum < firstRow || wrapper.rowNum > lastRow) continue;
                            iter.remove();
                        }
                    } else if (e.getType() == 0) {
                        EventWrapper wrapper;
                        Iterator iter = EventMatchThumbnail.this.findMatches.iterator();
                        while (iter.hasNext()) {
                            wrapper = (EventWrapper)iter.next();
                            if (wrapper.rowNum < firstRow || wrapper.rowNum > lastRow) continue;
                            iter.remove();
                        }
                        iter = EventMatchThumbnail.this.all.iterator();
                        while (iter.hasNext()) {
                            wrapper = (EventWrapper)iter.next();
                            if (wrapper.rowNum < firstRow || wrapper.rowNum > lastRow) continue;
                            iter.remove();
                        }
                        for (int i = firstRow; i <= lastRow; ++i) {
                            ExtendedLoggingEvent event = (ExtendedLoggingEvent)((Object)displayedEvents.get(i));
                            EventWrapper wrapper2 = new EventWrapper(i, event);
                            if (!wrapper2.loggingEvent.getColorRuleBackground().equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND)) {
                                EventMatchThumbnail.this.all.add(wrapper2);
                            }
                            if (!event.isSearchMatch()) continue;
                            EventMatchThumbnail.this.findMatches.add(wrapper2);
                        }
                    }
                    EventMatchThumbnail.this.invalidate();
                    EventMatchThumbnail.this.repaint();
                    if (LogPanel.this.isScrollToBottom()) {
                        LogPanel.this.scrollToBottom();
                    }
                }
            });
        }

        private EventWrapper getEventWrapperAtPosition(int yPosition) {
            int rowCount = LogPanel.this.table.getRowCount();
            Point offsets = this.getScrollBarOffsets();
            int topOffset = offsets.x;
            int bottomOffset = offsets.y;
            int height = LogPanel.this.eventsPane.getHeight() - topOffset - bottomOffset;
            if ((yPosition = Math.max(yPosition - topOffset, 0)) >= height) {
                yPosition = height;
            }
            float ratio = (float)yPosition / (float)height;
            int rowToSelect = Math.round((float)rowCount * ratio);
            EventWrapper event = this.getClosestRow(rowToSelect);
            return event;
        }

        private EventWrapper getClosestRow(int rowToSelect) {
            int newRowDelta;
            EventWrapper event;
            EventWrapper closestRow = null;
            int rowDelta = Integer.MAX_VALUE;
            Iterator iter = this.findMatches.iterator();
            while (iter.hasNext()) {
                event = (EventWrapper)iter.next();
                newRowDelta = Math.abs(rowToSelect - event.rowNum);
                if (newRowDelta >= rowDelta) continue;
                closestRow = event;
                rowDelta = newRowDelta;
            }
            iter = this.all.iterator();
            while (iter.hasNext()) {
                event = (EventWrapper)iter.next();
                newRowDelta = Math.abs(rowToSelect - event.rowNum);
                if (newRowDelta >= rowDelta) continue;
                closestRow = event;
                rowDelta = newRowDelta;
            }
            return closestRow;
        }

        private void configureColors() {
            this.findMatches.clear();
            this.all.clear();
            int i = 0;
            Iterator iter = LogPanel.this.tableModel.getFilteredEvents().iterator();
            while (iter.hasNext()) {
                ExtendedLoggingEvent extendedLoggingEvent = (ExtendedLoggingEvent)((Object)iter.next());
                extendedLoggingEvent.updateColorRuleColors(LogPanel.this.colorizer.getBackgroundColor(extendedLoggingEvent), LogPanel.this.colorizer.getForegroundColor(extendedLoggingEvent));
                EventWrapper wrapper = new EventWrapper(i, extendedLoggingEvent);
                if (extendedLoggingEvent.isSearchMatch()) {
                    this.findMatches.add(wrapper);
                }
                ++i;
                if (wrapper.loggingEvent.getColorRuleBackground().equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND)) continue;
                this.all.add(wrapper);
            }
            this.invalidate();
            this.repaint();
        }

        public Point getScrollBarOffsets() {
            Integer scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
            int scrollBarOffset = scrollBarWidth == null ? 0 : scrollBarWidth;
            int topOffset = ((LogPanel)LogPanel.this).table.getTableHeader().getMinimumSize().height;
            int bottomOffset = 0;
            if (LogPanel.this.eventsPane.getVerticalScrollBar().isVisible()) {
                topOffset += scrollBarOffset;
                bottomOffset += scrollBarOffset;
            }
            if (LogPanel.this.eventsPane.getHorizontalScrollBar().isVisible()) {
                bottomOffset += scrollBarOffset;
            }
            return new Point(topOffset, bottomOffset);
        }

        public void paintComponent(Graphics g) {
            int width;
            int startX;
            int verticalLocation;
            float ratio;
            EventWrapper wrapper;
            super.paintComponent(g);
            Point topAndBottomOffset = this.getScrollBarOffsets();
            int topOffset = topAndBottomOffset.x;
            int bottomOffset = topAndBottomOffset.y;
            int rowCount = LogPanel.this.table.getRowCount();
            if (rowCount == 0) {
                return;
            }
            int height = LogPanel.this.eventsPane.getHeight() - topOffset - bottomOffset;
            int maxHeight = Math.min(6, height / rowCount);
            int minHeight = Math.max(1, maxHeight);
            int componentHeight = height - minHeight;
            int eventHeight = minHeight;
            Iterator iter = this.all.iterator();
            while (iter.hasNext()) {
                wrapper = (EventWrapper)iter.next();
                if (wrapper.loggingEvent.getColorRuleBackground().equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND) || wrapper.loggingEvent.getLevel().toInt() >= Level.WARN.toInt() || wrapper.loggingEvent.getProperty("log4j.marker") != null) continue;
                ratio = (float)wrapper.rowNum / (float)rowCount;
                verticalLocation = (int)((float)componentHeight * ratio) + topOffset;
                startX = 1;
                width = this.getWidth() - startX * 2;
                this.drawEvent(wrapper.loggingEvent.getColorRuleBackground(), verticalLocation, eventHeight, g, startX, width);
            }
            iter = this.all.iterator();
            while (iter.hasNext()) {
                wrapper = (EventWrapper)iter.next();
                if (wrapper.loggingEvent.getColorRuleBackground().equals(ChainsawConstants.COLOR_DEFAULT_BACKGROUND) || wrapper.loggingEvent.getLevel().toInt() < Level.WARN.toInt() && wrapper.loggingEvent.getProperty("log4j.marker") == null) continue;
                ratio = (float)wrapper.rowNum / (float)rowCount;
                verticalLocation = (int)((float)componentHeight * ratio) + topOffset;
                startX = 1;
                width = this.getWidth() - startX * 2;
                eventHeight = Math.min(6, eventHeight + 3);
                this.drawEvent(wrapper.loggingEvent.getColorRuleBackground(), verticalLocation - eventHeight + 1, eventHeight, g, startX, width);
            }
            iter = this.findMatches.iterator();
            while (iter.hasNext()) {
                wrapper = (EventWrapper)iter.next();
                ratio = (float)wrapper.rowNum / (float)rowCount;
                verticalLocation = (int)((float)componentHeight * ratio) + topOffset;
                startX = 1;
                width = this.getWidth() - startX * 2;
                this.drawEvent(Color.BLACK, verticalLocation, eventHeight, g, startX, width /= 2);
            }
        }

        public Point getToolTipLocation(MouseEvent event) {
            return new Point(event.getX(), event.getY() + 30);
        }

        private void drawEvent(Color newColor, int verticalLocation, int eventHeight, Graphics g, int x, int width) {
            int y = verticalLocation + eventHeight / 2;
            Color oldColor = g.getColor();
            g.setColor(newColor);
            g.fillRect(x, y, width, eventHeight);
            if (eventHeight >= 3) {
                g.setColor(newColor.darker());
                g.drawRect(x, y, width, eventHeight);
            }
            g.setColor(oldColor);
        }

        class EventWrapper {
            int rowNum;
            ExtendedLoggingEvent loggingEvent;

            public EventWrapper(int rowNum, ExtendedLoggingEvent loggingEvent) {
                this.rowNum = rowNum;
                this.loggingEvent = loggingEvent;
            }

            public String toString() {
                return "event - rownum: " + this.rowNum + ", level: " + this.loggingEvent.getLevel();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                EventWrapper that = (EventWrapper)o;
                return !(this.loggingEvent != null ? !((Object)((Object)this.loggingEvent)).equals((Object)that.loggingEvent) : that.loggingEvent != null);
            }

            public int hashCode() {
                return this.loggingEvent != null ? ((Object)((Object)this.loggingEvent)).hashCode() : 0;
            }
        }
    }

    private class MarkerCellEditor
    implements TableCellEditor {
        JTextField textField = new JTextField();
        Set cellEditorListeners = new HashSet();
        private ExtendedLoggingEvent currentEvent;

        private MarkerCellEditor() {
        }

        public Object getCellEditorValue() {
            return this.textField.getText();
        }

        public boolean isCellEditable(EventObject anEvent) {
            return true;
        }

        public boolean shouldSelectCell(EventObject anEvent) {
            this.textField.selectAll();
            return true;
        }

        public boolean stopCellEditing() {
            if (this.textField.getText().trim().equals("")) {
                this.currentEvent.removeProperty("log4j.marker");
            } else {
                this.currentEvent.setProperty("log4j.marker", this.textField.getText());
            }
            LogPanel.this.tableModel.fireRowUpdated(LogPanel.this.table.getSelectedRow(), true);
            ChangeEvent event = new ChangeEvent(LogPanel.this.table);
            Iterator iter = this.cellEditorListeners.iterator();
            while (iter.hasNext()) {
                ((CellEditorListener)iter.next()).editingStopped(event);
            }
            return true;
        }

        public void cancelCellEditing() {
            ChangeEvent event = new ChangeEvent(LogPanel.this.table);
            Iterator iter = this.cellEditorListeners.iterator();
            while (iter.hasNext()) {
                ((CellEditorListener)iter.next()).editingCanceled(event);
            }
        }

        public void addCellEditorListener(CellEditorListener l) {
            this.cellEditorListeners.add(l);
        }

        public void removeCellEditorListener(CellEditorListener l) {
            this.cellEditorListeners.remove(l);
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.currentEvent = LogPanel.this.tableModel.getRow(row);
            if (this.currentEvent != null) {
                this.textField.setText(this.currentEvent.getProperty("log4j.marker"));
                this.textField.selectAll();
            }
            return this.textField;
        }
    }

    private class DetailPaneUpdater
    implements PropertyChangeListener {
        private int selectedRow = -1;
        int lastRow = -1;

        private DetailPaneUpdater() {
        }

        private void setSelectedRow(int row) {
            this.selectedRow = row;
            this.updateDetailPane();
        }

        private void setAndUpdateSelectedRow(int row) {
            this.selectedRow = row;
            this.updateDetailPane(true);
        }

        private void updateDetailPane() {
            this.updateDetailPane(false);
        }

        private void updateDetailPane(boolean force) {
            if (!LogPanel.this.preferenceModel.isDetailPaneVisible()) {
                return;
            }
            ExtendedLoggingEvent event = null;
            if ((force || this.selectedRow != -1 && this.lastRow != this.selectedRow) && (event = LogPanel.this.tableModel.getRow(this.selectedRow)) != null) {
                StringBuffer buf = new StringBuffer();
                buf.append(LogPanel.this.detailLayout.getHeader()).append(LogPanel.this.detailLayout.format(event)).append(LogPanel.this.detailLayout.getFooter());
                if (buf.length() > 0) {
                    try {
                        final Document doc = LogPanel.this.detail.getEditorKit().createDefaultDocument();
                        LogPanel.this.detail.getEditorKit().read(new StringReader(buf.toString()), doc, 0);
                        SwingHelper.invokeOnEDT(new Runnable(){

                            public void run() {
                                LogPanel.this.detail.setDocument(doc);
                                JTextComponentFormatter.applySystemFontAndSize(LogPanel.this.detail);
                                LogPanel.this.detail.setCaretPosition(0);
                                DetailPaneUpdater.this.lastRow = DetailPaneUpdater.this.selectedRow;
                            }
                        });
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            if (event == null && this.lastRow != this.selectedRow) {
                try {
                    final Document doc = LogPanel.this.detail.getEditorKit().createDefaultDocument();
                    LogPanel.this.detail.getEditorKit().read(new StringReader("<html>\u306a\u306b\u3082\u9078\u629e\u3055\u308c\u3066\u3044\u307e\u305b\u3093</html>"), doc, 0);
                    SwingHelper.invokeOnEDT(new Runnable(){

                        public void run() {
                            LogPanel.this.detail.setDocument(doc);
                            JTextComponentFormatter.applySystemFontAndSize(LogPanel.this.detail);
                            LogPanel.this.detail.setCaretPosition(0);
                            DetailPaneUpdater.this.lastRow = DetailPaneUpdater.this.selectedRow;
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public void propertyChange(PropertyChangeEvent arg0) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DetailPaneUpdater.this.updateDetailPane(true);
                }
            });
        }
    }

    private class ChainsawTableColumnModelListener
    implements TableColumnModelListener {
        private ChainsawTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            Enumeration<TableColumn> enumeration = LogPanel.this.table.getColumnModel().getColumns();
            while (enumeration.hasMoreElements()) {
                TableColumn column = enumeration.nextElement();
                if (column.getModelIndex() + 1 == 8) {
                    column.setCellEditor(LogPanel.this.throwableRenderPanel);
                }
                if (!column.getHeaderValue().toString().toLowerCase().equals("log4j.marker")) continue;
                column.setCellEditor(LogPanel.this.markerCellEditor);
            }
        }

        public void columnRemoved(TableColumnModelEvent e) {
            LogPanel.this.table.updateSortedColumn();
        }

        public void columnMoved(TableColumnModelEvent e) {
            LogPanel.this.table.updateSortedColumn();
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    private final class TableColumnDetailMouseListener
    extends MouseMotionAdapter {
        private int currentRow = -1;

        private TableColumnDetailMouseListener() {
        }

        public void mouseMoved(MouseEvent evt) {
            LogPanel.this.currentPoint = evt.getPoint();
            if (LogPanel.this.preferenceModel.isToolTips()) {
                int row = LogPanel.this.table.rowAtPoint(evt.getPoint());
                if (row == this.currentRow || row == -1) {
                    return;
                }
                this.currentRow = row;
                ExtendedLoggingEvent event = LogPanel.this.tableModel.getRow(this.currentRow);
                if (event != null) {
                    String toolTipText = LogPanel.this.getToolTipTextForEvent(event);
                    LogPanel.this.table.setToolTipText(toolTipText);
                }
            } else {
                LogPanel.this.table.setToolTipText(null);
            }
        }
    }

    private final class TableMarkerListener
    extends MouseAdapter {
        private TableMarkerListener() {
        }

        public void mouseClicked(MouseEvent evt) {
            ExtendedLoggingEvent event;
            int row;
            if (evt.getClickCount() == 2 && (row = LogPanel.this.table.rowAtPoint(evt.getPoint())) != -1 && (event = LogPanel.this.tableModel.getRow(row)) != null) {
                String marker = event.getProperty("log4j.marker");
                if (marker == null) {
                    event.setProperty("log4j.marker", "set");
                } else {
                    event.removeProperty("log4j.marker");
                }
                LogPanel.this.tableModel.fireRowUpdated(row, marker == null);
            }
        }
    }

    private final class DelayedFilterTextDocumentListener
    implements DocumentListener {
        private static final long CHECK_PERIOD = 1000L;
        private final JTextField filterText;
        private long lastTimeStamp = System.currentTimeMillis();
        private final Thread delayThread;
        private final String defaultToolTip;
        private String lastFilterText = null;

        private DelayedFilterTextDocumentListener(final JTextField filterText) {
            this.filterText = filterText;
            this.defaultToolTip = filterText.getToolTipText();
            this.delayThread = new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (System.currentTimeMillis() - DelayedFilterTextDocumentListener.this.lastTimeStamp < 1000L || System.currentTimeMillis() - DelayedFilterTextDocumentListener.this.lastTimeStamp >= 2000L || filterText.getText().equals(DelayedFilterTextDocumentListener.this.lastFilterText)) continue;
                        DelayedFilterTextDocumentListener.this.lastFilterText = filterText.getText();
                        EventQueue.invokeLater(new Runnable(){

                            public void run() {
                                DelayedFilterTextDocumentListener.this.setFilter();
                            }
                        });
                    }
                }
            });
            this.delayThread.setPriority(1);
            this.delayThread.start();
        }

        public void insertUpdate(DocumentEvent e) {
            this.notifyChange();
        }

        public void removeUpdate(DocumentEvent e) {
            this.notifyChange();
        }

        public void changedUpdate(DocumentEvent e) {
            this.notifyChange();
        }

        private void notifyChange() {
            this.lastTimeStamp = System.currentTimeMillis();
        }

        private void setFilter() {
            if (this.filterText.getText().trim().equals("")) {
                this.filterText.setBackground(UIManager.getColor("TextField.background"));
                LogPanel.this.ruleMediator.setRefinementRule(null);
                this.filterText.setToolTipText(this.defaultToolTip);
            } else {
                try {
                    LogPanel.this.ruleMediator.setRefinementRule(ExpressionRule.getRule((String)this.filterText.getText()));
                    this.filterText.setToolTipText(this.defaultToolTip);
                    this.filterText.setBackground(UIManager.getColor("TextField.background"));
                }
                catch (IllegalArgumentException iae) {
                    this.filterText.setToolTipText(iae.getMessage());
                    this.filterText.setBackground(ChainsawConstants.INVALID_EXPRESSION_BACKGROUND);
                }
            }
        }
    }
}

