/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.chainsaw.FileLoadAction;
import org.apache.log4j.chainsaw.FileSaveAction;
import org.apache.log4j.chainsaw.LogUI;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.osx.OSXIntegration;
import org.apache.log4j.chainsaw.prefs.MRUFileList;
import org.apache.log4j.spi.Decoder;
import org.apache.log4j.xml.UtilLoggingXMLDecoder;
import org.apache.log4j.xml.XMLDecoder;

class FileMenu
extends JMenu {
    private Action loadConfigAction;
    private Action exitAction;
    private Action loadLog4JAction;
    private Action loadUtilLoggingAction;
    private Action remoteLog4JAction;
    private Action remoteUtilLoggingAction;
    private Action saveAction;

    public FileMenu(final LogUI logUI) {
        super("\u30d5\u30a1\u30a4\u30eb");
        this.setMnemonic(70);
        this.loadConfigAction = new AbstractAction("Chainsaw\u8a2d\u5b9a\u306e\u8aad\u8fbc\u307f"){

            public void actionPerformed(ActionEvent actionEvent) {
                logUI.showApplicationPreferencesBrowse();
            }
        };
        this.loadLog4JAction = new FileLoadAction(logUI, (Decoder)new XMLDecoder((Component)logUI), "log4j XML\u5f62\u5f0f\u30d5\u30a1\u30a4\u30eb(.xml or .zip)\u3092\u958b\u304f...", false);
        this.loadLog4JAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(79, 2));
        this.loadLog4JAction.putValue("MnemonicKey", new Integer(76));
        this.loadLog4JAction.putValue("ShortDescription", "\u30ed\u30fc\u30ab\u30ebXMLLayout\u5f62\u5f0f\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u30a4\u30d9\u30f3\u30c8\u3092\u8aad\u307f\u8fbc\u3080");
        this.loadLog4JAction.putValue("SmallIcon", new ImageIcon(ChainsawIcons.FILE_OPEN));
        this.loadUtilLoggingAction = new FileLoadAction(logUI, (Decoder)new UtilLoggingXMLDecoder((Component)logUI), "util.logging XML\u5f62\u5f0f\u30d5\u30a1\u30a4\u30eb(.xml or .zip)\u3092\u958b\u304f...", false);
        this.remoteLog4JAction = new FileLoadAction(logUI, (Decoder)new XMLDecoder((Component)logUI), "\u9060\u9694log4j XML\u5f62\u5f0f\u30d5\u30a1\u30a4\u30eb(.xml or .zip)\u3092\u958b\u304f...", true);
        this.remoteUtilLoggingAction = new FileLoadAction(logUI, (Decoder)new UtilLoggingXMLDecoder((Component)logUI), "\u9060\u9694util.logging XML\u5f62\u5f0f\u30d5\u30a1\u30a4\u30eb(.xml or .zip)\u3092\u958b\u304f...", true);
        this.saveAction = new FileSaveAction(logUI);
        JMenuItem loadChainsawConfig = new JMenuItem(this.loadConfigAction);
        JMenuItem loadLog4JFile = new JMenuItem(this.loadLog4JAction);
        JMenuItem loadUtilLoggingFile = new JMenuItem(this.loadUtilLoggingAction);
        JMenuItem remoteLog4JFile = new JMenuItem(this.remoteLog4JAction);
        JMenuItem remoteUtilLoggingFile = new JMenuItem(this.remoteUtilLoggingAction);
        JMenuItem saveFile = new JMenuItem(this.saveAction);
        this.exitAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                logUI.exit();
            }
        };
        this.exitAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(88, 8));
        this.exitAction.putValue("ShortDescription", "\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u3092\u7d42\u4e86\u3059\u308b");
        this.exitAction.putValue("MnemonicKey", new Integer(88));
        this.exitAction.putValue("Name", "\u7d42\u4e86");
        JMenuItem menuItemExit = new JMenuItem(this.exitAction);
        this.add(loadChainsawConfig);
        this.add(loadLog4JFile);
        this.add(loadUtilLoggingFile);
        this.addSeparator();
        this.add(remoteLog4JFile);
        this.add(remoteUtilLoggingFile);
        this.addSeparator();
        this.add(saveFile);
        this.addSeparator();
        final JMenu mrulog4j = new JMenu("MRU...");
        MRUFileList.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                FileMenu.this.buildMRUMenu(mrulog4j, logUI);
            }
        });
        this.buildMRUMenu(mrulog4j, logUI);
        this.add(mrulog4j);
        if (!OSXIntegration.IS_OSX) {
            this.addSeparator();
            this.add(menuItemExit);
        }
    }

    private void buildMRUMenu(JMenu mrulog4j, final LogUI logui) {
        mrulog4j.removeAll();
        int counter = 1;
        if (MRUFileList.log4jMRU().getMRUList().size() > 0) {
            Iterator iter = MRUFileList.log4jMRU().getMRUList().iterator();
            while (iter.hasNext()) {
                final URL url = (URL)iter.next();
                final String name = url.getProtocol().startsWith("file") ? url.getPath().substring(url.getPath().lastIndexOf(47) + 1) : url.getPath();
                String title = counter++ + " - " + url.toExternalForm();
                JMenuItem menuItem = new JMenuItem(new AbstractAction(title){

                    public void actionPerformed(ActionEvent e) {
                        FileLoadAction.importURL(logui.handler, (Decoder)new XMLDecoder(), name, url);
                    }
                });
                mrulog4j.add(menuItem);
            }
        } else {
            JMenuItem none = new JMenuItem("\u73fe\u5728\u306f\u306a\u3057...");
            none.setEnabled(false);
            mrulog4j.add(none);
        }
    }

    Action getLog4JFileOpenAction() {
        return this.loadLog4JAction;
    }

    Action getUtilLoggingJFileOpenAction() {
        return this.loadUtilLoggingAction;
    }

    Action getFileSaveAction() {
        return this.saveAction;
    }

    Action getExitAction() {
        return this.exitAction;
    }
}

