/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.ChainsawConstants;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggingEvent;

public class ExtendedLoggingEvent
extends LoggingEvent {
    private static final int DEFAULT_HEIGHT = -1;
    private Color colorRuleBackground = ChainsawConstants.COLOR_DEFAULT_BACKGROUND;
    private Color colorRuleForeground = ChainsawConstants.COLOR_DEFAULT_FOREGROUND;
    private int markerHeight = -1;
    private int msgHeight = -1;
    private boolean searchMatch = false;
    Map eventMatches = new HashMap();

    public ExtendedLoggingEvent(LoggingEvent e) {
        super(e.getFQNOfLoggerClass(), (Category)(e.getLogger() != null ? e.getLogger() : Logger.getLogger((String)e.getLoggerName())), e.getTimeStamp(), e.getLevel(), e.getMessage(), e.getThreadName(), e.getThrowableInformation(), e.getNDC(), e.getLocationInformation(), e.getProperties());
    }

    public void updateColorRuleColors(Color backgroundColor, Color foregroundColor) {
        if (backgroundColor != null && foregroundColor != null) {
            this.colorRuleBackground = backgroundColor;
            this.colorRuleForeground = foregroundColor;
        } else {
            this.colorRuleBackground = ChainsawConstants.COLOR_DEFAULT_BACKGROUND;
            this.colorRuleForeground = ChainsawConstants.COLOR_DEFAULT_FOREGROUND;
        }
    }

    public void evaluateSearchRule(Rule searchRule) {
        this.eventMatches.clear();
        this.searchMatch = searchRule != null && searchRule.evaluate((LoggingEvent)this, this.eventMatches);
    }

    public Map getSearchMatches() {
        return this.eventMatches;
    }

    public Color getForeground() {
        return this.colorRuleForeground;
    }

    public Color getBackground() {
        return this.colorRuleBackground;
    }

    public Color getColorRuleBackground() {
        return this.colorRuleBackground;
    }

    public Color getColorRuleForeground() {
        return this.colorRuleForeground;
    }

    public boolean isSearchMatch() {
        return this.searchMatch;
    }

    public void setMarkerHeight(int markerHeight) {
        this.markerHeight = markerHeight;
    }

    public int getMarkerHeight() {
        return this.markerHeight;
    }

    public void setMsgHeight(int msgHeight) {
        this.msgHeight = msgHeight;
    }

    public int getMsgHeight() {
        return this.msgHeight;
    }

    public void setDisplayed(boolean b) {
        this.markerHeight = -1;
        this.msgHeight = -1;
    }

    public String toString() {
        return "ExtendedLoggingEvent - id: " + this.getProperty("log4jid") + " background: " + this.getBackground() + ", foreground: " + this.getForeground() + ", msg: " + this.getMessage();
    }
}

