/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import org.apache.log4j.EnhancedPatternLayout;
import org.apache.log4j.Layout;
import org.apache.log4j.chainsaw.LogUI;
import org.apache.log4j.spi.LoggingEvent;

public class CopyEventsToClipboardAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final int EVENTSIZE_FUDGE_FACTOR = 128;
    private final LogUI logUi;
    private final Layout layout = new EnhancedPatternLayout("[%d{ISO8601} %-5p][%20.20c][%t] %m%n");

    public CopyEventsToClipboardAction(LogUI parent) {
        super("Copy events to clipboard");
        this.logUi = parent;
        this.layout.activateOptions();
        this.putValue("ShortDescription", "Copies to the clipboard currently visible events to a human-readable, log-like format");
    }

    public void actionPerformed(ActionEvent e) {
        List filteredEvents = this.logUi.getCurrentLogPanel().getFilteredEvents();
        StringBuffer writer = new StringBuffer(filteredEvents.size() * 128);
        Iterator iterator = filteredEvents.iterator();
        while (iterator.hasNext()) {
            LoggingEvent event = (LoggingEvent)iterator.next();
            writer.append(this.layout.format(event));
        }
        StringSelection stringSelection = new StringSelection(writer.toString());
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, stringSelection);
    }
}

