/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.chainsaw.CommonActions;
import org.apache.log4j.chainsaw.CopyEventsToClipboardAction;
import org.apache.log4j.chainsaw.ExpressionRuleContext;
import org.apache.log4j.chainsaw.FileMenu;
import org.apache.log4j.chainsaw.JTextComponentFormatter;
import org.apache.log4j.chainsaw.LogPanel;
import org.apache.log4j.chainsaw.LogUI;
import org.apache.log4j.chainsaw.SmallButton;
import org.apache.log4j.chainsaw.SmallToggleButton;
import org.apache.log4j.chainsaw.filter.FilterModel;
import org.apache.log4j.chainsaw.help.HelpManager;
import org.apache.log4j.chainsaw.icons.ChainsawIcons;
import org.apache.log4j.chainsaw.osx.OSXIntegration;
import org.apache.log4j.chainsaw.receivers.ReceiversHelper;

class ChainsawToolBarAndMenus
implements ChangeListener {
    private final SmallToggleButton showReceiversButton;
    private final JTextField findField;
    private final Action changeModelAction;
    private final Action clearAction;
    private final Action toggleWelcomeVisibleAction;
    private final Action findNextAction;
    private final Action findPreviousAction;
    private final Action findPreviousColorizedEventAction;
    private final Action findNextColorizedEventAction;
    private final Action findNextMarkerAction;
    private final Action findPreviousMarkerAction;
    private final Action toggleMarkerAction;
    private final Action clearAllMarkersAction;
    private final Action pauseAction;
    private final Action showPreferencesAction;
    private final Action showColorPanelAction;
    private final Action showReceiversAction;
    private final Action toggleLogTreeAction;
    private final Action toggleScrollToBottomAction;
    private final Action scrollToTopAction;
    private final Action toggleDetailPaneAction;
    private final Action toggleToolbarAction;
    private final Action undockAction;
    private final Action customExpressionPanelAction;
    private final Collection lookAndFeelMenus = new ArrayList();
    private final JCheckBoxMenuItem toggleShowReceiversCheck = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem toggleLogTreeMenuItem = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem toggleScrollToBottomMenuItem = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem toggleDetailMenuItem = new JCheckBoxMenuItem();
    private final JCheckBoxMenuItem toggleCyclicMenuItem = new JCheckBoxMenuItem();
    private final FileMenu fileMenu;
    private final JCheckBoxMenuItem toggleStatusBarCheck = new JCheckBoxMenuItem();
    private final JMenu viewMenu = new JMenu("\u30d3\u30e5\u30fc");
    private final JMenuBar menuBar;
    private final JCheckBoxMenuItem menuShowWelcome = new JCheckBoxMenuItem();
    private final JToolBar toolbar;
    private final LogUI logui;
    private final SmallButton clearButton = new SmallButton();
    private final SmallToggleButton detailPaneButton = new SmallToggleButton();
    private final SmallToggleButton logTreePaneButton = new SmallToggleButton();
    private final SmallToggleButton scrollToBottomButton = new SmallToggleButton();
    private final SmallToggleButton pauseButton = new SmallToggleButton();
    private final SmallToggleButton toggleCyclicButton = new SmallToggleButton();
    private final Action[] logPanelSpecificActions;
    private final JMenu activeTabMenu = new JMenu("\u73fe\u5728\u306e\u30bf\u30d6");
    private final JPanel findPanel;
    static /* synthetic */ Class class$javax$swing$JDialog;

    ChainsawToolBarAndMenus(LogUI logui) {
        this.logui = logui;
        this.toolbar = new JToolBar(0);
        this.menuBar = new JMenuBar();
        this.fileMenu = new FileMenu(logui);
        this.toggleWelcomeVisibleAction = this.toggleWelcomeVisibleAction();
        this.changeModelAction = this.createChangeModelAction();
        this.findField = new JTextField();
        this.findNextAction = this.getFindNextAction();
        this.findPreviousAction = this.getFindPreviousAction();
        this.findNextMarkerAction = this.createFindNextMarkerAction();
        this.findPreviousColorizedEventAction = this.getFindPreviousColorizedEventAction();
        this.findNextColorizedEventAction = this.getFindNextColorizedEventAction();
        this.findPreviousMarkerAction = this.createFindPreviousMarkerAction();
        this.toggleMarkerAction = this.createToggleMarkerAction();
        this.clearAllMarkersAction = this.createClearAllMarkersAction();
        this.customExpressionPanelAction = this.createCustomExpressionPanelAction();
        this.showPreferencesAction = this.createShowPreferencesAction();
        this.showColorPanelAction = this.createShowColorPanelAction();
        this.toggleToolbarAction = this.createToggleToolbarAction();
        this.toggleLogTreeAction = this.createToggleLogTreeAction();
        this.toggleScrollToBottomAction = this.createScrollToBottomAction();
        this.scrollToTopAction = this.createScrollToTopAction();
        this.pauseAction = this.createPauseAction();
        this.clearAction = this.createClearAction();
        this.undockAction = this.createUndockAction();
        this.showReceiversAction = this.createShowReceiversAction();
        this.showReceiversButton = new SmallToggleButton(this.showReceiversAction);
        this.findPanel = new JPanel();
        this.findPanel.setLayout(new BoxLayout(this.findPanel, 0));
        Dimension findSize = new Dimension(260, 22);
        Dimension findPanelSize = new Dimension(310, 30);
        this.findPanel.setPreferredSize(findPanelSize);
        this.findPanel.setMaximumSize(findPanelSize);
        this.findPanel.setMinimumSize(findPanelSize);
        this.findField.setPreferredSize(findSize);
        this.findField.setMaximumSize(findSize);
        this.findField.setMinimumSize(findSize);
        this.findPanel.setAlignmentY(0.5f);
        this.findField.setAlignmentY(0.5f);
        this.toggleDetailPaneAction = this.createToggleDetailPaneAction();
        this.createMenuBar();
        this.createToolbar();
        this.logPanelSpecificActions = new Action[]{this.pauseAction, this.findNextAction, this.findPreviousAction, this.findNextColorizedEventAction, this.findPreviousColorizedEventAction, this.findNextMarkerAction, this.findPreviousMarkerAction, this.toggleMarkerAction, this.clearAllMarkersAction, this.scrollToTopAction, this.clearAction, this.fileMenu.getFileSaveAction(), this.toggleDetailPaneAction, this.showPreferencesAction, this.showColorPanelAction, this.undockAction, this.toggleLogTreeAction, this.toggleScrollToBottomAction, this.changeModelAction};
        logui.getApplicationPreferenceModel().addPropertyChangeListener("statusBar", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean value = (Boolean)evt.getNewValue();
                ChainsawToolBarAndMenus.this.toggleStatusBarCheck.setSelected(value);
            }
        });
        logui.getApplicationPreferenceModel().addPropertyChangeListener("receivers", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean value = (Boolean)evt.getNewValue();
                ChainsawToolBarAndMenus.this.showReceiversButton.setSelected(value);
                ChainsawToolBarAndMenus.this.toggleShowReceiversCheck.setSelected(value);
            }
        });
    }

    private Action createChangeModelAction() {
        AbstractAction action = new AbstractAction("\u74b0\u72b6", new ImageIcon(ChainsawIcons.REFRESH)){

            public void actionPerformed(ActionEvent arg0) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                logPanel.toggleCyclic();
                ChainsawToolBarAndMenus.this.scanState();
            }
        };
        action.putValue("ShortDescription", "\u74b0\u72b6\u3068\u7121\u9650\u30e2\u30fc\u30c9\u306b\u5207\u308a\u66ff\u3048\u308b\u3002");
        return action;
    }

    private Action createToggleLogTreeAction() {
        AbstractAction action = new AbstractAction("\u30ed\u30b0\u30c4\u30ea\u30fc\u8868\u793a\u306e\u5207\u308a\u66ff\u3048"){

            public void actionPerformed(ActionEvent e) {
                if (ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel() != null) {
                    ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel().toggleLogTreeVisible();
                }
            }
        };
        action.putValue("ShortDescription", "\u30ed\u30b0\u30c4\u30ea\u30fc\u8868\u793a\u306e\u5207\u308a\u66ff\u3048");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", new Integer(84));
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, 8));
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.WINDOW_ICON));
        return action;
    }

    private Action createScrollToBottomAction() {
        AbstractAction action = new AbstractAction("\u4e0b\u307e\u3067\u30b9\u30af\u30ed\u30fc\u30eb"){

            public void actionPerformed(ActionEvent e) {
                if (ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel() != null) {
                    ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel().toggleScrollToBottom();
                }
            }
        };
        action.putValue("ShortDescription", "\u4e0b\u307e\u3067\u30b9\u30af\u30ed\u30fc\u30eb");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", new Integer(66));
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 2));
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.SCROLL_TO_BOTTOM));
        return action;
    }

    private Action createScrollToTopAction() {
        AbstractAction action = new AbstractAction("\u4e0a\u307e\u3067\u30b9\u30af\u30ed\u30fc\u30eb"){

            public void actionPerformed(ActionEvent e) {
                if (ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel() != null) {
                    ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel().scrollToTop();
                }
            }
        };
        action.putValue("ShortDescription", "\u4e0a\u307e\u3067\u30b9\u30af\u30ed\u30fc\u30eb");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", new Integer(84));
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, 2));
        return action;
    }

    private Action createFindNextMarkerAction() {
        AbstractAction action = new AbstractAction("\u6b21\u306e\u30de\u30fc\u30ab\u3092\u691c\u7d22"){

            public void actionPerformed(ActionEvent e) {
                if (ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel() != null) {
                    ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel().findNextMarker();
                }
            }
        };
        action.putValue("ShortDescription", "\u73fe\u5728\u4f4d\u7f6e\u304b\u3089\u6b21\u306e\u30de\u30fc\u30ab\u3092\u691c\u7d22\u3059\u308b");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", new Integer(78));
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F2"));
        return action;
    }

    private Action createFindPreviousMarkerAction() {
        AbstractAction action = new AbstractAction("\u524d\u306e\u30de\u30fc\u30ab\u3092\u691c\u7d22"){

            public void actionPerformed(ActionEvent e) {
                if (ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel() != null) {
                    ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel().findPreviousMarker();
                }
            }
        };
        action.putValue("ShortDescription", "\u73fe\u5728\u4f4d\u7f6e\u304b\u3089\u524d\u306e\u30de\u30fc\u30ab\u3092\u691c\u7d22\u3059\u308b");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", new Integer(80));
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 1));
        return action;
    }

    private Action createToggleMarkerAction() {
        AbstractAction action = new AbstractAction("\u30de\u30fc\u30ab\u306e\u5207\u308a\u66ff\u3048"){

            public void actionPerformed(ActionEvent e) {
                if (ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel() != null) {
                    ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel().toggleMarker();
                }
            }
        };
        action.putValue("ShortDescription", "\u9078\u629e\u3055\u308c\u305f\u884c\u306e\u30de\u30fc\u30ab\u306e\u5207\u308a\u66ff\u3048");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", new Integer(84));
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 2));
        return action;
    }

    private Action createClearAllMarkersAction() {
        AbstractAction action = new AbstractAction("\u3059\u3079\u3066\u306e\u30de\u30fc\u30ab\u3092\u524a\u9664"){

            public void actionPerformed(ActionEvent e) {
                if (ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel() != null) {
                    ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel().clearAllMarkers();
                }
            }
        };
        action.putValue("ShortDescription", "\u3059\u3079\u3066\u306e\u30de\u30fc\u30ab\u3092\u524a\u9664\u3059\u308b");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", new Integer(82));
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(113, 3));
        return action;
    }

    public void stateChange() {
        this.scanState();
    }

    public void stateChanged(ChangeEvent e) {
        this.scanState();
    }

    JMenuBar getMenubar() {
        return this.menuBar;
    }

    JToolBar getToolbar() {
        return this.toolbar;
    }

    private Action createClearAction() {
        AbstractAction action = new AbstractAction("\u6d88\u53bb"){

            public void actionPerformed(ActionEvent e) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel == null) {
                    return;
                }
                logPanel.clearEvents();
            }
        };
        action.putValue("MnemonicKey", new Integer(67));
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(8, 2));
        action.putValue("ShortDescription", "\u73fe\u5728\u30d3\u30e5\u30fc\u304b\u3089\u3059\u3079\u3066\u306e\u30a4\u30d9\u30f3\u30c8\u3092\u524a\u9664\u3059\u308b");
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.DELETE));
        return action;
    }

    private Action toggleWelcomeVisibleAction() {
        AbstractAction action = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ChainsawToolBarAndMenus.this.toggleWelcomeVisibleAction.putValue("Name", "\u306f\u3058\u3081\u306b\u30bf\u30d6");
                if (ChainsawToolBarAndMenus.this.menuShowWelcome.isSelected()) {
                    ChainsawToolBarAndMenus.this.logui.addWelcomePanel();
                } else {
                    ChainsawToolBarAndMenus.this.logui.removeWelcomePanel();
                }
            }
        };
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F1"));
        action.putValue("ShortDescription", "\u306f\u3058\u3081\u306b\u30bf\u30b0\u306e\u5207\u308a\u66ff\u3048");
        action.putValue("MnemonicKey", new Integer(67));
        action.putValue("Name", "\u306f\u3058\u3081\u306b\u30bf\u30d6");
        return action;
    }

    private void createMenuBar() {
        JMenuItem menuItemUseRightMouse = new JMenuItem("Other options available via panel's right mouse button popup menu");
        menuItemUseRightMouse.setEnabled(false);
        this.viewMenu.setMnemonic('V');
        final JCheckBoxMenuItem showToolbarCheck = new JCheckBoxMenuItem(this.toggleToolbarAction);
        showToolbarCheck.setSelected(this.logui.getApplicationPreferenceModel().isToolbar());
        this.logui.getApplicationPreferenceModel().addPropertyChangeListener("toolbar", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                boolean value = (Boolean)evt.getNewValue();
                showToolbarCheck.setSelected(value);
            }
        });
        this.menuShowWelcome.setAction(this.toggleWelcomeVisibleAction);
        JCheckBoxMenuItem pause = new JCheckBoxMenuItem(this.pauseAction);
        JMenuItem menuPrefs = new JMenuItem(this.showPreferencesAction);
        menuPrefs.setText(this.showPreferencesAction.getValue("ShortDescription").toString());
        JMenuItem menuCustomExpressionPanel = new JMenuItem(this.customExpressionPanelAction);
        menuCustomExpressionPanel.setText(this.customExpressionPanelAction.getValue("ShortDescription").toString());
        JMenuItem menuShowColor = new JMenuItem(this.showColorPanelAction);
        menuShowColor.setText(this.showColorPanelAction.getValue("ShortDescription").toString());
        JMenuItem menuUndock = new JMenuItem(this.undockAction);
        JMenuItem showAppPrefs = new JMenuItem("\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u5168\u822c\u306e\u8a2d\u5b9a...");
        showAppPrefs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChainsawToolBarAndMenus.this.logui.showApplicationPreferences();
            }
        });
        this.toggleDetailMenuItem.setAction(this.toggleDetailPaneAction);
        this.toggleDetailMenuItem.setSelected(true);
        this.toggleCyclicMenuItem.setAction(this.changeModelAction);
        this.toggleCyclicMenuItem.setSelected(true);
        this.toggleLogTreeMenuItem.setAction(this.toggleLogTreeAction);
        this.toggleLogTreeMenuItem.setSelected(true);
        this.toggleScrollToBottomMenuItem.setAction(this.toggleScrollToBottomAction);
        AbstractAction toggleStatusBarAction = new AbstractAction("\u30b9\u30c6\u30fc\u30bf\u30b9\u30d0\u30fc\u3092\u8868\u793a"){

            public void actionPerformed(ActionEvent arg0) {
                ChainsawToolBarAndMenus.this.logui.getApplicationPreferenceModel().setStatusBar(ChainsawToolBarAndMenus.this.toggleStatusBarCheck.isSelected());
            }
        };
        toggleStatusBarAction.putValue("MnemonicKey", new Integer(66));
        this.toggleStatusBarCheck.setAction(toggleStatusBarAction);
        this.toggleStatusBarCheck.setSelected(this.logui.getApplicationPreferenceModel().isStatusBar());
        this.activeTabMenu.add(pause);
        this.activeTabMenu.add(this.toggleCyclicMenuItem);
        this.activeTabMenu.addSeparator();
        this.activeTabMenu.add(this.toggleDetailMenuItem);
        this.activeTabMenu.add(this.toggleLogTreeMenuItem);
        this.activeTabMenu.addSeparator();
        this.activeTabMenu.add(menuUndock);
        this.activeTabMenu.add(menuShowColor);
        this.activeTabMenu.add(menuPrefs);
        this.activeTabMenu.addSeparator();
        this.activeTabMenu.add(new CopyEventsToClipboardAction(this.logui));
        this.activeTabMenu.add(new JMenuItem(this.clearAction));
        this.activeTabMenu.addSeparator();
        this.activeTabMenu.add(new JMenuItem(this.toggleMarkerAction));
        this.activeTabMenu.add(new JMenuItem(this.findNextMarkerAction));
        this.activeTabMenu.add(new JMenuItem(this.findPreviousMarkerAction));
        this.activeTabMenu.add(new JMenuItem(this.clearAllMarkersAction));
        this.activeTabMenu.add(new JMenuItem(this.findNextColorizedEventAction));
        this.activeTabMenu.add(new JMenuItem(this.findPreviousColorizedEventAction));
        this.activeTabMenu.addSeparator();
        this.activeTabMenu.add(new JMenuItem(this.scrollToTopAction));
        this.activeTabMenu.add(this.toggleScrollToBottomMenuItem);
        this.activeTabMenu.add(menuItemUseRightMouse);
        this.viewMenu.add(showToolbarCheck);
        this.viewMenu.add(this.toggleStatusBarCheck);
        this.viewMenu.add(this.toggleShowReceiversCheck);
        this.viewMenu.add(this.menuShowWelcome);
        this.viewMenu.addSeparator();
        this.viewMenu.add(menuCustomExpressionPanel);
        if (!OSXIntegration.IS_OSX) {
            this.viewMenu.addSeparator();
            this.viewMenu.add(showAppPrefs);
        }
        JMenu helpMenu = new JMenu("\u30d8\u30eb\u30d7");
        helpMenu.setMnemonic('H');
        JMenuItem about = new JMenuItem("Chainsaw v2\u306b\u3064\u3044\u3066...");
        about.setMnemonic('A');
        about.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ChainsawToolBarAndMenus.this.logui.showAboutBox();
            }
        });
        AbstractAction startTutorial = new AbstractAction("\u30c1\u30e5\u30fc\u30c8\u30ea\u30a2\u30eb...", new ImageIcon(ChainsawIcons.HELP)){

            public void actionPerformed(ActionEvent e) {
                ChainsawToolBarAndMenus.this.logui.setupTutorial();
            }
        };
        startTutorial.putValue("ShortDescription", "\u30c1\u30e5\u30fc\u30c8\u30ea\u30a2\u30eb\u3092\u59cb\u3081\u308b");
        helpMenu.add(startTutorial);
        List knownReceivers = ReceiversHelper.getInstance().getKnownReceiverClasses();
        JMenu receiverHelp = new JMenu("\u30ec\u30b7\u30fc\u30d0\u30fcJavaDoc");
        Iterator iter = knownReceivers.iterator();
        while (iter.hasNext()) {
            final Class clazz = (Class)iter.next();
            receiverHelp.add(new AbstractAction(clazz.getName()){

                public void actionPerformed(ActionEvent arg0) {
                    HelpManager.getInstance().showHelpForClass(clazz);
                }
            });
        }
        helpMenu.add(receiverHelp);
        helpMenu.addSeparator();
        helpMenu.add(CommonActions.getInstance().getShowReleaseNotes());
        helpMenu.add(about);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(this.activeTabMenu);
        this.menuBar.add(helpMenu);
    }

    private Action createPauseAction() {
        AbstractAction action = new AbstractAction("\u505c\u6b62"){

            public void actionPerformed(ActionEvent evt) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel == null) {
                    return;
                }
                logPanel.setPaused(!logPanel.isPaused());
                ChainsawToolBarAndMenus.this.scanState();
            }
        };
        action.putValue("MnemonicKey", new Integer(80));
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F12"));
        action.putValue("ShortDescription", "\u3053\u306e\u30bf\u30d6\u306e\u53d7\u4fe1\u30a4\u30d9\u30f3\u30c8\u3092\u653e\u68c4\u3059\u308b");
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.PAUSE));
        return action;
    }

    private Action createShowPreferencesAction() {
        AbstractAction showPreferences = new AbstractAction("", ChainsawIcons.ICON_PREFERENCES){

            public void actionPerformed(ActionEvent arg0) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel != null) {
                    logPanel.showPreferences();
                }
            }
        };
        showPreferences.putValue("ShortDescription", "\u30bf\u30d6\u8a2d\u5b9a...");
        return showPreferences;
    }

    private Action createCustomExpressionPanelAction() {
        final JDialog dialog = new JDialog(this.logui, "\u30bf\u30d6\u306e\u5b9a\u7fa9", true);
        dialog.getContentPane().add(this.getCustomExpressionPanel());
        dialog.setLocationRelativeTo(null);
        dialog.pack();
        AbstractAction createExpressionPanel = new AbstractAction("", ChainsawIcons.ICON_HELP){

            public void actionPerformed(ActionEvent arg0) {
                LogPanel.centerAndSetVisible(dialog);
            }
        };
        createExpressionPanel.putValue("ShortDescription", "\u5f0f\u304b\u3089\u30bf\u30d6\u3092\u4f5c\u6210...   ");
        return createExpressionPanel;
    }

    private Action createShowColorPanelAction() {
        AbstractAction showColorPanel = new AbstractAction("", ChainsawIcons.ICON_PREFERENCES){

            public void actionPerformed(ActionEvent arg0) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel != null) {
                    logPanel.showColorPreferences();
                }
            }
        };
        showColorPanel.putValue("ShortDescription", "\u8272\u306e\u8a2d\u5b9a...");
        return showColorPanel;
    }

    private Action createShowReceiversAction() {
        AbstractAction action = new AbstractAction("\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u8868\u793a"){

            public void actionPerformed(ActionEvent arg0) {
                ChainsawToolBarAndMenus.this.logui.getApplicationPreferenceModel().setReceivers(!ChainsawToolBarAndMenus.this.logui.getApplicationPreferenceModel().isReceivers());
            }
        };
        action.putValue("MnemonicKey", new Integer(69));
        action.putValue("ShortDescription", "\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u308bLog4j\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u8868\u793a");
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F6"));
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.ANIM_NET_CONNECT));
        this.toggleShowReceiversCheck.setAction(action);
        return action;
    }

    private Action createToggleDetailPaneAction() {
        AbstractAction action = new AbstractAction("\u8a73\u7d30\u30da\u30a4\u30f3\u3092\u8868\u793a"){

            public void actionPerformed(ActionEvent evt) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel == null) {
                    return;
                }
                logPanel.toggleDetailVisible();
            }
        };
        action.putValue("MnemonicKey", new Integer(68));
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(68, 8));
        action.putValue("ShortDescription", "\u8a73\u7d30\u30da\u30a4\u30f3\u306e\u8868\u793a\uff0f\u975e\u8868\u793a");
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.INFO));
        return action;
    }

    private Action createToggleToolbarAction() {
        AbstractAction action = new AbstractAction("\u30c4\u30fc\u30eb\u30d0\u30fc\u3092\u8868\u793a"){

            public void actionPerformed(ActionEvent e) {
                ChainsawToolBarAndMenus.this.logui.getApplicationPreferenceModel().setToolbar(!ChainsawToolBarAndMenus.this.logui.getApplicationPreferenceModel().isToolbar());
            }
        };
        action.putValue("MnemonicKey", new Integer(84));
        return action;
    }

    private void createToolbar() {
        Insets buttonMargins = new Insets(1, 1, 1, 1);
        FileMenu menu = (FileMenu)this.menuBar.getMenu(0);
        SmallButton fileOpenButton = new SmallButton(menu.getLog4JFileOpenAction());
        fileOpenButton.setMargin(buttonMargins);
        SmallButton fileSaveButton = new SmallButton(menu.getFileSaveAction());
        fileSaveButton.setMargin(buttonMargins);
        fileOpenButton.setText("");
        fileSaveButton.setText("");
        this.toolbar.add(fileOpenButton);
        this.toolbar.add(fileSaveButton);
        this.toolbar.addSeparator();
        this.pauseButton.setAction(this.pauseAction);
        this.pauseButton.setText("");
        this.pauseButton.getActionMap().put(this.pauseAction.getValue("Name"), this.pauseAction);
        this.toggleCyclicButton.setAction(this.changeModelAction);
        this.toggleCyclicButton.setText(null);
        this.detailPaneButton.setAction(this.toggleDetailPaneAction);
        this.detailPaneButton.setText(null);
        this.detailPaneButton.getActionMap().put(this.toggleDetailPaneAction.getValue("Name"), this.toggleDetailPaneAction);
        this.detailPaneButton.getInputMap(1).put(KeyStroke.getKeyStroke(68, 8), this.toggleDetailPaneAction.getValue("Name"));
        this.logTreePaneButton.setAction(this.toggleLogTreeAction);
        this.logTreePaneButton.getActionMap().put(this.toggleLogTreeAction.getValue("Name"), this.toggleLogTreeAction);
        this.logTreePaneButton.getInputMap(1).put(KeyStroke.getKeyStroke(84, 8), this.toggleLogTreeAction.getValue("Name"));
        this.logTreePaneButton.setText(null);
        this.scrollToBottomButton.setAction(this.toggleScrollToBottomAction);
        this.scrollToBottomButton.getActionMap().put(this.toggleScrollToBottomAction.getValue("Name"), this.toggleScrollToBottomAction);
        this.scrollToBottomButton.getInputMap(1).put(KeyStroke.getKeyStroke(66, 2), this.toggleScrollToBottomAction.getValue("Name"));
        this.scrollToBottomButton.setText(null);
        SmallButton prefsButton = new SmallButton(this.showPreferencesAction);
        SmallButton undockButton = new SmallButton(this.undockAction);
        undockButton.setText("");
        this.toolbar.add(undockButton);
        this.toolbar.add(this.pauseButton);
        this.toolbar.add(this.toggleCyclicButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.detailPaneButton);
        this.toolbar.add(this.logTreePaneButton);
        this.toolbar.add(this.scrollToBottomButton);
        this.toolbar.add(prefsButton);
        this.toolbar.addSeparator();
        this.toolbar.add(this.clearButton);
        this.clearButton.setAction(this.clearAction);
        this.clearButton.setText("");
        this.toolbar.addSeparator();
        SmallButton findNextButton = new SmallButton(this.findNextAction);
        findNextButton.setText("");
        findNextButton.getActionMap().put(this.findNextAction.getValue("Name"), this.findNextAction);
        findNextButton.getInputMap(2).put((KeyStroke)this.findNextAction.getValue("AcceleratorKey"), this.findNextAction.getValue("Name"));
        SmallButton findPreviousButton = new SmallButton(this.findPreviousAction);
        findPreviousButton.setText("");
        findPreviousButton.getActionMap().put(this.findPreviousAction.getValue("Name"), this.findPreviousAction);
        findPreviousButton.getInputMap(2).put((KeyStroke)this.findPreviousAction.getValue("AcceleratorKey"), this.findPreviousAction.getValue("Name"));
        JLabel searchLabel = new JLabel("\u691c\u7d22\uff1a");
        searchLabel.setDisplayedMnemonic('j');
        searchLabel.setFont(searchLabel.getFont().deriveFont(1));
        this.findPanel.add(searchLabel);
        this.findPanel.add(Box.createHorizontalStrut(3));
        this.findPanel.add(this.findField);
        this.findPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        searchLabel.setLabelFor(this.findField);
        this.toolbar.add(this.findPanel);
        this.toolbar.addSeparator(new Dimension(7, 5));
        this.toolbar.add(findNextButton);
        this.toolbar.add(findPreviousButton);
        this.toolbar.addSeparator();
        this.showReceiversButton.setText(null);
        this.toolbar.add(this.showReceiversButton);
        this.toolbar.add(Box.createHorizontalGlue());
        this.toolbar.setMargin(buttonMargins);
        this.toolbar.setFloatable(false);
    }

    private Action createUndockAction() {
        AbstractAction action = new AbstractAction("\u5206\u96e2", ChainsawIcons.ICON_UNDOCK){

            public void actionPerformed(ActionEvent arg0) {
                LogPanel logPanel = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (logPanel != null) {
                    logPanel.undock();
                }
            }
        };
        action.putValue("ShortDescription", "\u73fe\u5728\u306elog\u30d1\u30cd\u30eb\u3092\u72ec\u81ea\u306e\u30a6\u30a3\u30f3\u30c9\u30a6\u306b\u5206\u96e2\u3059\u308b");
        return action;
    }

    private void scanState() {
        JLabel searchLabel;
        this.toggleStatusBarCheck.setSelected(this.logui.isStatusBarVisible());
        this.toggleShowReceiversCheck.setSelected(this.logui.getApplicationPreferenceModel().isReceivers());
        this.logTreePaneButton.setSelected(this.logui.isLogTreePanelVisible());
        LogPanel panel = this.logui.getCurrentLogPanel();
        if (panel != null) {
            this.scrollToBottomButton.setSelected(panel.isScrollToBottom());
        } else {
            this.scrollToBottomButton.setSelected(false);
        }
        this.showReceiversButton.setSelected(this.logui.getApplicationPreferenceModel().isReceivers());
        this.menuShowWelcome.setSelected(this.logui.getTabbedPane().containsWelcomePanel());
        LogPanel logPanel = this.logui.getCurrentLogPanel();
        boolean activateLogPanelActions = true;
        if (logPanel == null) {
            activateLogPanelActions = false;
            this.findField.setEnabled(false);
            this.findPanel.removeAll();
            searchLabel = new JLabel("\u691c\u7d22\uff1a");
            searchLabel.setDisplayedMnemonic('j');
            searchLabel.setFont(searchLabel.getFont().deriveFont(1));
            this.findPanel.add(searchLabel);
            this.findPanel.add(Box.createHorizontalStrut(3));
            this.findPanel.add(this.findField);
            this.findPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            searchLabel.setLabelFor(this.findField);
            this.activeTabMenu.setEnabled(false);
            this.toggleWelcomeVisibleAction.setEnabled(true);
            this.detailPaneButton.setSelected(false);
            this.toggleCyclicButton.setSelected(false);
        } else {
            this.activeTabMenu.setEnabled(true);
            this.fileMenu.getFileSaveAction().setEnabled(true);
            this.findPanel.removeAll();
            searchLabel = new JLabel("\u691c\u7d22\uff1a");
            searchLabel.setDisplayedMnemonic('j');
            searchLabel.setFont(searchLabel.getFont().deriveFont(1));
            this.findPanel.add(searchLabel);
            this.findPanel.add(Box.createHorizontalStrut(3));
            this.findPanel.add(logPanel.getFindTextField());
            this.findPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            searchLabel.setLabelFor(logPanel.getFindTextField());
            this.pauseButton.getModel().setSelected(logPanel.isPaused());
            this.toggleCyclicButton.setSelected(logPanel.isCyclic());
            this.logui.getStatusBar().setPaused(logPanel.isPaused(), logPanel.getIdentifier());
            this.toggleCyclicMenuItem.setSelected(logPanel.isCyclic());
            this.detailPaneButton.getModel().setSelected(logPanel.isDetailVisible());
            this.toggleLogTreeMenuItem.setSelected(logPanel.isLogTreeVisible());
            this.toggleScrollToBottomMenuItem.setSelected(logPanel.isScrollToBottom());
        }
        this.findPanel.invalidate();
        this.findPanel.revalidate();
        this.findPanel.repaint();
        for (int i = 0; i < this.logPanelSpecificActions.length; ++i) {
            this.logPanelSpecificActions[i].setEnabled(activateLogPanelActions);
        }
        String currentLookAndFeelName = UIManager.getLookAndFeel().getName();
        Iterator iter = this.lookAndFeelMenus.iterator();
        while (iter.hasNext()) {
            JRadioButtonMenuItem element = (JRadioButtonMenuItem)iter.next();
            if (element.getText().equals(currentLookAndFeelName)) {
                element.setSelected(true);
                continue;
            }
            element.setSelected(false);
        }
    }

    private Action getFindNextAction() {
        AbstractAction action = new AbstractAction("\u6b21\u3092\u691c\u7d22"){

            public void actionPerformed(ActionEvent e) {
                LogPanel p = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (p != null) {
                    p.findNext();
                }
            }
        };
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke("F3"));
        action.putValue("ShortDescription", "\u73fe\u5728\u884c\u3088\u308a\u6b21\u306e\u30eb\u30fc\u30eb\u3092\u691c\u7d22\u3059\u308b");
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.DOWN));
        return action;
    }

    private Action getFindPreviousAction() {
        AbstractAction action = new AbstractAction("\u524d\u3092\u691c\u7d22"){

            public void actionPerformed(ActionEvent e) {
                LogPanel p = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (p != null) {
                    p.findPrevious();
                }
            }
        };
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(114, 1));
        action.putValue("ShortDescription", "\u73fe\u5728\u884c\u3088\u308a\u6b21\u306e\u30eb\u30fc\u30eb\u3092\u691c\u7d22\u3059\u308b");
        action.putValue("SmallIcon", new ImageIcon(ChainsawIcons.UP));
        return action;
    }

    private Action getFindNextColorizedEventAction() {
        AbstractAction action = new AbstractAction("\u6b21\u306e\u8272\u4ed8\u304d\u30a4\u30d9\u30f3\u30c8\u3092\u691c\u7d22"){

            public void actionPerformed(ActionEvent e) {
                LogPanel p = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (p != null) {
                    p.findNextColorizedEvent();
                }
            }
        };
        action.putValue("ShortDescription", "\u73fe\u5728\u884c\u3088\u308a\u6b21\u306e\u8272\u4ed8\u304d\u30a4\u30d9\u30f3\u30c8\u3092\u691c\u7d22\u3059\u308b");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", new Integer(78));
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(78, 128));
        return action;
    }

    private Action getFindPreviousColorizedEventAction() {
        AbstractAction action = new AbstractAction("\u524d\u306e\u8272\u4ed8\u304d\u30a4\u30d9\u30f3\u30c8\u3092\u691c\u7d22"){

            public void actionPerformed(ActionEvent e) {
                LogPanel p = ChainsawToolBarAndMenus.this.logui.getCurrentLogPanel();
                if (p != null) {
                    p.findPreviousColorizedEvent();
                }
            }
        };
        action.putValue("ShortDescription", "\u73fe\u5728\u884c\u3088\u308a\u6b21\u306e\u8272\u4ed8\u304d\u30a4\u30d9\u30f3\u30c8\u3092\u691c\u7d22\u3059\u308b");
        action.putValue("enabled", Boolean.TRUE);
        action.putValue("MnemonicKey", new Integer(80));
        action.putValue("AcceleratorKey", KeyStroke.getKeyStroke(80, 128));
        return action;
    }

    private JPanel getCustomExpressionPanel() {
        final JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("\u65b0\u3057\u3044\u30bf\u30d6\u7528\u306e\u5f0f\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044\uff1a  "), "North");
        final JEditorPane entryField = new JEditorPane();
        entryField.setPreferredSize(new Dimension(350, 75));
        JTextComponentFormatter.applySystemFontAndSize(entryField);
        entryField.addKeyListener(new ExpressionRuleContext(new FilterModel(), entryField));
        panel.add((Component)entryField, "Center");
        JButton ok = new JButton(" OK ");
        JButton close = new JButton("\u9589\u3058\u308b");
        JPanel lowerPanel = new JPanel();
        lowerPanel.add(ok);
        lowerPanel.add(Box.createHorizontalStrut(7));
        lowerPanel.add(close);
        panel.add((Component)lowerPanel, "South");
        ok.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                ChainsawToolBarAndMenus.this.logui.createCustomExpressionLogPanel(entryField.getText());
                SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = ChainsawToolBarAndMenus.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, panel).setVisible(false);
            }
        });
        close.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                SwingUtilities.getAncestorOfClass(class$javax$swing$JDialog == null ? (class$javax$swing$JDialog = ChainsawToolBarAndMenus.class$("javax.swing.JDialog")) : class$javax$swing$JDialog, panel).setVisible(false);
            }
        });
        return panel;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

