/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.event.EventListenerList;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.LogManager;
import org.apache.log4j.chainsaw.ChainsawAppender;
import org.apache.log4j.chainsaw.ChainsawEventBatch;
import org.apache.log4j.chainsaw.EventBatchListener;
import org.apache.log4j.net.SocketReceiver;
import org.apache.log4j.plugins.Plugin;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.LoggerRepositoryEx;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.LoggingEventFieldResolver;

public class ChainsawAppenderHandler
extends AppenderSkeleton {
    private static final String DEFAULT_IDENTIFIER = "Unknown";
    private final Object mutex = new Object();
    private int sleepInterval = 1000;
    private EventListenerList listenerList = new EventListenerList();
    private double dataRate = 0.0;
    private String identifierExpression;
    private final LoggingEventFieldResolver resolver = LoggingEventFieldResolver.getInstance();
    private PropertyChangeSupport propertySupport = new PropertyChangeSupport((Object)this);
    private Map customExpressionRules = new HashMap();
    private WorkQueue worker = new WorkQueue();
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$EventBatchListener;

    public ChainsawAppenderHandler(ChainsawAppender appender) {
        super(true);
        appender.setAppender((Appender)this);
    }

    public ChainsawAppenderHandler() {
        super(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIdentifierExpression(String identifierExpression) {
        Object object = this.mutex;
        synchronized (object) {
            this.identifierExpression = identifierExpression;
            this.mutex.notify();
        }
    }

    public String getIdentifierExpression() {
        return this.identifierExpression;
    }

    public void addCustomEventBatchListener(String identifier, EventBatchListener l) throws IllegalArgumentException {
        this.customExpressionRules.put(identifier, ExpressionRule.getRule((String)identifier));
        this.listenerList.add(class$org$apache$log4j$chainsaw$EventBatchListener == null ? (class$org$apache$log4j$chainsaw$EventBatchListener = ChainsawAppenderHandler.class$("org.apache.log4j.chainsaw.EventBatchListener")) : class$org$apache$log4j$chainsaw$EventBatchListener, l);
    }

    public void addEventBatchListener(EventBatchListener l) {
        this.listenerList.add(class$org$apache$log4j$chainsaw$EventBatchListener == null ? (class$org$apache$log4j$chainsaw$EventBatchListener = ChainsawAppenderHandler.class$("org.apache.log4j.chainsaw.EventBatchListener")) : class$org$apache$log4j$chainsaw$EventBatchListener, l);
    }

    public void removeEventBatchListener(EventBatchListener l) {
        this.listenerList.remove(class$org$apache$log4j$chainsaw$EventBatchListener == null ? (class$org$apache$log4j$chainsaw$EventBatchListener = ChainsawAppenderHandler.class$("org.apache.log4j.chainsaw.EventBatchListener")) : class$org$apache$log4j$chainsaw$EventBatchListener, l);
    }

    public void append(LoggingEvent event) {
        this.worker.enqueue(event);
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    public int getQueueInterval() {
        return this.sleepInterval;
    }

    public void setQueueInterval(int interval) {
        this.sleepInterval = interval;
    }

    String getTabIdentifier(LoggingEvent e) {
        String ident = this.resolver.applyFields(this.identifierExpression, e);
        return ident != null ? ident : DEFAULT_IDENTIFIER;
    }

    public static void main(String[] args) throws InterruptedException {
        ChainsawAppenderHandler handler = new ChainsawAppenderHandler();
        handler.addEventBatchListener(new EventBatchListener(){

            public String getInterestedIdentifier() {
                return null;
            }

            public void receiveEventBatch(String identifier, List events) {
                System.out.println("received " + events.size());
            }
        });
        LogManager.getRootLogger().addAppender((Appender)handler);
        SocketReceiver receiver = new SocketReceiver(4445);
        ((LoggerRepositoryEx)LogManager.getLoggerRepository()).getPluginRegistry().addPlugin((Plugin)receiver);
        receiver.activateOptions();
        Thread.sleep(60000L);
    }

    public double getDataRate() {
        return this.dataRate;
    }

    void setDataRate(double dataRate) {
        double oldValue = this.dataRate;
        this.dataRate = dataRate;
        this.propertySupport.firePropertyChange("dataRate", new Double(oldValue), new Double(this.dataRate));
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(propertyName, listener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(propertyName, listener);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class WorkQueue {
        final ArrayList queue = new ArrayList();
        Thread workerThread = new WorkerThread();

        protected WorkQueue() {
            this.workerThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void enqueue(LoggingEvent event) {
            Object object = ChainsawAppenderHandler.this.mutex;
            synchronized (object) {
                this.queue.add(event);
                ChainsawAppenderHandler.this.mutex.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void stop() {
            Object object = ChainsawAppenderHandler.this.mutex;
            synchronized (object) {
                this.workerThread.interrupt();
            }
        }

        private class WorkerThread
        extends Thread {
            public WorkerThread() {
                super("Chainsaw-WorkerThread");
                this.setDaemon(true);
                this.setPriority(4);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ArrayList innerList = new ArrayList();
                while (true) {
                    Object iter;
                    long timeStart = System.currentTimeMillis();
                    Object object = ChainsawAppenderHandler.this.mutex;
                    synchronized (object) {
                        try {
                            while (WorkQueue.this.queue.size() == 0 || ChainsawAppenderHandler.this.identifierExpression == null) {
                                ChainsawAppenderHandler.this.setDataRate(0.0);
                                ChainsawAppenderHandler.this.mutex.wait();
                            }
                            if (WorkQueue.this.queue.size() > 0) {
                                innerList.addAll(WorkQueue.this.queue);
                                WorkQueue.this.queue.clear();
                            }
                        }
                        catch (InterruptedException ie) {
                            // empty catch block
                        }
                    }
                    int size = innerList.size();
                    if (size > 0) {
                        iter = innerList.iterator();
                        ChainsawEventBatch eventBatch = new ChainsawEventBatch();
                        while (iter.hasNext()) {
                            String remoteHost;
                            LoggingEvent e = (LoggingEvent)iter.next();
                            if (e.getProperty("hostname") == null && (remoteHost = e.getProperty("log4j.remoteSourceInfo")) != null) {
                                int colonIndex = remoteHost.indexOf(":");
                                if (colonIndex == -1) {
                                    colonIndex = remoteHost.length();
                                }
                                e.setProperty("hostname", remoteHost.substring(0, colonIndex));
                            }
                            Iterator itery = ChainsawAppenderHandler.this.customExpressionRules.entrySet().iterator();
                            while (itery.hasNext()) {
                                Map.Entry entry = itery.next();
                                Rule rule = (Rule)entry.getValue();
                                if (!rule.evaluate(e, null)) continue;
                                eventBatch.addEvent((String)entry.getKey(), e);
                            }
                            eventBatch.addEvent(ChainsawAppenderHandler.this.getTabIdentifier(e), e);
                        }
                        this.dispatchEventBatch(eventBatch);
                        innerList.clear();
                    }
                    if (ChainsawAppenderHandler.this.getQueueInterval() > 1000) {
                        try {
                            iter = this;
                            synchronized (iter) {
                                this.wait(ChainsawAppenderHandler.this.getQueueInterval());
                            }
                        }
                        catch (InterruptedException ie) {}
                    } else {
                        Thread.yield();
                    }
                    if (size == 0) {
                        ChainsawAppenderHandler.this.setDataRate(0.0);
                        continue;
                    }
                    long timeEnd = System.currentTimeMillis();
                    long diffInSeconds = (timeEnd - timeStart) / 1000L;
                    double rate = (double)size / (double)diffInSeconds;
                    ChainsawAppenderHandler.this.setDataRate(rate);
                }
            }

            private void dispatchEventBatch(ChainsawEventBatch eventBatch) {
                EventBatchListener[] listeners = (EventBatchListener[])ChainsawAppenderHandler.this.listenerList.getListeners(class$org$apache$log4j$chainsaw$EventBatchListener == null ? (class$org$apache$log4j$chainsaw$EventBatchListener = ChainsawAppenderHandler.class$("org.apache.log4j.chainsaw.EventBatchListener")) : class$org$apache$log4j$chainsaw$EventBatchListener);
                Iterator iter = eventBatch.identifierIterator();
                while (iter.hasNext()) {
                    String identifier = (String)iter.next();
                    List eventList = null;
                    for (int i = 0; i < listeners.length; ++i) {
                        EventBatchListener listener = listeners[i];
                        if (listener.getInterestedIdentifier() != null && !listener.getInterestedIdentifier().equals(identifier)) continue;
                        if (eventList == null) {
                            eventList = eventBatch.entrySet(identifier);
                        }
                        listener.receiveEventBatch(identifier, eventList);
                    }
                    eventList = null;
                }
            }
        }
    }
}

