/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.chainsaw;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.chainsaw.AbstractPreferencePanel;
import org.apache.log4j.chainsaw.ApplicationPreferenceModel;
import org.apache.log4j.chainsaw.BasicPrefPanel;
import org.apache.log4j.chainsaw.osx.OSXIntegration;

public class ApplicationPreferenceModelPanel
extends AbstractPreferencePanel {
    private ApplicationPreferenceModel committedPreferenceModel;
    private ApplicationPreferenceModel uncommittedPreferenceModel = new ApplicationPreferenceModel();
    private JTextField identifierExpression;
    private JTextField toolTipDisplayMillis;
    private JTextField cyclicBufferSize;
    private JComboBox configurationURL;
    private final Logger logger;
    private GeneralAllPrefPanel generalAllPrefPanel;
    static /* synthetic */ Class class$org$apache$log4j$chainsaw$ApplicationPreferenceModelPanel;

    ApplicationPreferenceModelPanel(ApplicationPreferenceModel model) {
        this.committedPreferenceModel = model;
        this.logger = LogManager.getLogger((Class)(class$org$apache$log4j$chainsaw$ApplicationPreferenceModelPanel == null ? (class$org$apache$log4j$chainsaw$ApplicationPreferenceModelPanel = ApplicationPreferenceModelPanel.class$("org.apache.log4j.chainsaw.ApplicationPreferenceModelPanel")) : class$org$apache$log4j$chainsaw$ApplicationPreferenceModelPanel));
        this.initComponents();
        this.getOkButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setConfigurationURL((String)ApplicationPreferenceModelPanel.this.configurationURL.getSelectedItem());
                ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setIdentifierExpression(ApplicationPreferenceModelPanel.this.identifierExpression.getText());
                try {
                    int millis = Integer.parseInt(ApplicationPreferenceModelPanel.this.toolTipDisplayMillis.getText());
                    if (millis >= 0) {
                        ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setToolTipDisplayMillis(millis);
                    }
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
                try {
                    int bufferSize = Integer.parseInt(ApplicationPreferenceModelPanel.this.cyclicBufferSize.getText());
                    if (bufferSize >= 0) {
                        ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setCyclicBufferSize(bufferSize);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                ApplicationPreferenceModelPanel.this.committedPreferenceModel.apply(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel);
                ApplicationPreferenceModelPanel.this.hidePanel();
            }
        });
        this.getCancelButton().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.apply(ApplicationPreferenceModelPanel.this.committedPreferenceModel);
                ApplicationPreferenceModelPanel.this.hidePanel();
            }
        });
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("App Preferences Panel Test Bed");
        ApplicationPreferenceModel model = new ApplicationPreferenceModel();
        ApplicationPreferenceModelPanel panel = new ApplicationPreferenceModelPanel(model);
        f.getContentPane().add(panel);
        model.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                System.out.println(evt);
            }
        });
        panel.setOkCancelActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(1);
            }
        });
        f.setSize(640, 480);
        f.setVisible(true);
    }

    public void updateModel() {
        this.uncommittedPreferenceModel.apply(this.committedPreferenceModel);
    }

    protected TreeModel createTreeModel() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode("Preferences");
        DefaultTreeModel model = new DefaultTreeModel(rootNode);
        this.generalAllPrefPanel = new GeneralAllPrefPanel();
        DefaultMutableTreeNode general = new DefaultMutableTreeNode(this.generalAllPrefPanel);
        DefaultMutableTreeNode visuals = new DefaultMutableTreeNode(new VisualsPrefPanel());
        rootNode.add(general);
        rootNode.add(visuals);
        return model;
    }

    public void browseForConfiguration() {
        this.generalAllPrefPanel.browseForConfiguration();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class GeneralAllPrefPanel
    extends BasicPrefPanel {
        private final JCheckBox showNoReceiverWarning = new JCheckBox("\u30ec\u30b7\u30fc\u30d0\u30fc\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u306a\u3044\u5834\u5408\u306f\u3001\u8d77\u52d5\u6642\u306b\u8981\u6c42\u3059\u308b");
        private final JCheckBox showSplash = new JCheckBox("\u8d77\u52d5\u6642\u306b\u30b9\u30d7\u30e9\u30c3\u30b7\u30e5\u753b\u9762\u3092\u8868\u793a");
        private final JSlider responsiveSlider = new JSlider(0, 1, 4, 2);
        private final JCheckBox confirmExit = new JCheckBox("\u7d42\u4e86\u3092\u78ba\u8a8d");
        Dictionary sliderLabelMap = new Hashtable();
        private final JCheckBox okToRemoveSecurityManager = new JCheckBox("\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u30de\u30cd\u30fc\u30b8\u30e3\u3092\u524a\u9664\u53ef\u80fd");

        public GeneralAllPrefPanel() {
            super("\u4e00\u822c");
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BoxLayout(this, 1));
            ApplicationPreferenceModelPanel.this.configurationURL = new JComboBox(new DefaultComboBoxModel(ApplicationPreferenceModelPanel.this.committedPreferenceModel.getConfigurationURLs()));
            ApplicationPreferenceModelPanel.this.configurationURL.setEditable(true);
            ApplicationPreferenceModelPanel.this.configurationURL.setPrototypeDisplayValue("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa");
            ApplicationPreferenceModelPanel.this.configurationURL.setPreferredSize(new Dimension(375, 13));
            ApplicationPreferenceModelPanel.this.identifierExpression = new JTextField(30);
            ApplicationPreferenceModelPanel.this.toolTipDisplayMillis = new JTextField(8);
            ApplicationPreferenceModelPanel.this.cyclicBufferSize = new JTextField(8);
            Box p = new Box(0);
            p.add(this.showNoReceiverWarning);
            p.add(Box.createHorizontalGlue());
            this.confirmExit.setToolTipText("Chainsaw\u3092\u7d42\u4e86\u3059\u308b\u304b\u3001\u78ba\u8a8d\u3092\u53d6\u308b\u3088\u3046\u306b\u3059\u308b");
            this.okToRemoveSecurityManager.setToolTipText("\u5916\u90e8\u4f9d\u5b58\u304c\u3042\u308b\u308c\u3057\u30fc\u3070\u30fc\uff0f\u30d7\u30e9\u30b0\u30a4\u30f3\u3092\u8aad\u307f\u8fbc\u3080\u5834\u5408\u306f\u3001\u30c1\u30a7\u30c3\u30af\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002");
            this.setupInitialValues();
            this.setupListeners();
            this.initSliderComponent();
            this.add(this.responsiveSlider);
            JPanel p1 = new JPanel(new FlowLayout(0));
            p1.add(new JLabel("\u30bf\u30d6\u540d\uff0f\u30a4\u30d9\u30f3\u30c8\u30eb\u30fc\u30c6\u30a3\u30f3\u30b0\u5f0f"));
            p1.add(Box.createHorizontalStrut(5));
            p1.add(ApplicationPreferenceModelPanel.this.identifierExpression);
            this.add(p1);
            this.add(p);
            Box p2 = new Box(0);
            p2.add(this.confirmExit);
            p2.add(Box.createHorizontalGlue());
            Box p3 = new Box(0);
            p3.add(this.showSplash);
            p3.add(Box.createHorizontalGlue());
            Box ok4 = new Box(0);
            ok4.add(this.okToRemoveSecurityManager);
            ok4.add(Box.createHorizontalGlue());
            this.add(p2);
            this.add(p3);
            this.add(ok4);
            JPanel p4 = new JPanel(new FlowLayout(0));
            p4.add(new JLabel("\u30c4\u30fc\u30eb\u30c1\u30c3\u30d7\u8868\u793a\u6642\u9593(\u30df\u30ea\u79d2)"));
            p4.add(Box.createHorizontalStrut(5));
            p4.add(ApplicationPreferenceModelPanel.this.toolTipDisplayMillis);
            this.add(p4);
            JPanel p5 = new JPanel(new FlowLayout(0));
            p5.add(new JLabel("\u74b0\u72b6\u30d0\u30c3\u30d5\u30a1\u30b5\u30a4\u30ba"));
            p5.add(Box.createHorizontalStrut(5));
            p5.add(ApplicationPreferenceModelPanel.this.cyclicBufferSize);
            p5.add(Box.createHorizontalStrut(5));
            p5.add(new JLabel("\u74b0\u72b6\u30d0\u30c3\u30d5\u30a1\u30b5\u30a4\u30ba\u306e\u8a2d\u5b9a\u306fChainsaw\u304c\u518d\u8d77\u52d5\u3055\u308c\u305f\u5f8c\u306b\u6709\u52b9\u306b\u306a\u308a\u307e\u3059"));
            this.add(p5);
            Box p6 = new Box(1);
            Box configURLPanel = new Box(0);
            JLabel configLabel = new JLabel("\u81ea\u52d5\u8a2d\u5b9aURL");
            configURLPanel.add(configLabel);
            configURLPanel.add(Box.createHorizontalStrut(5));
            configURLPanel.add(ApplicationPreferenceModelPanel.this.configurationURL);
            configURLPanel.add(Box.createHorizontalGlue());
            p6.add(configURLPanel);
            JButton browseButton = new JButton("\u53c2\u7167");
            browseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    GeneralAllPrefPanel.this.browseForConfiguration();
                }
            });
            Box browsePanel = new Box(0);
            browsePanel.add(Box.createHorizontalGlue());
            browsePanel.add(browseButton);
            p6.add(Box.createVerticalStrut(5));
            p6.add(browsePanel);
            p6.add(Box.createVerticalGlue());
            this.add(p6);
            ApplicationPreferenceModelPanel.this.configurationURL.setToolTipText("\u30ec\u30b7\u30fc\u30d0\u30fc\u53ca\u3073\u4ed6\u30d7\u30e9\u30b0\u30a4\u30f3\u3092\u81ea\u52d5\u8a2d\u5b9a\u3059\u308blog4j\u306exml\u8a2d\u5b9a\u30d5\u30a1\u30a4\u30eb\u306e\u5b8c\u5168URL");
            ApplicationPreferenceModelPanel.this.configurationURL.setInputVerifier(new InputVerifier(){

                public boolean verify(JComponent input) {
                    try {
                        String selectedItem = (String)ApplicationPreferenceModelPanel.this.configurationURL.getSelectedItem();
                        if (selectedItem != null && !selectedItem.trim().equals("")) {
                            new URL(selectedItem);
                        }
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                }
            });
            String configToDisplay = ApplicationPreferenceModelPanel.this.committedPreferenceModel.getBypassConfigurationURL() != null ? ApplicationPreferenceModelPanel.this.committedPreferenceModel.getBypassConfigurationURL() : ApplicationPreferenceModelPanel.this.committedPreferenceModel.getConfigurationURL();
            ApplicationPreferenceModelPanel.this.configurationURL.setSelectedItem(configToDisplay);
        }

        public void browseForConfiguration() {
            JFileChooser chooser;
            int result;
            File currentConfigurationPath;
            Object selectedItem;
            String defaultPath = ".";
            if (ApplicationPreferenceModelPanel.this.configurationURL.getItemCount() > 0 && (selectedItem = ApplicationPreferenceModelPanel.this.configurationURL.getSelectedItem()) != null && (currentConfigurationPath = new File(selectedItem.toString()).getParentFile()) != null && (defaultPath = currentConfigurationPath.getPath()).toLowerCase().startsWith("file:\\")) {
                defaultPath = defaultPath.substring("file:\\".length());
            }
            if (0 == (result = (chooser = new JFileChooser(defaultPath)).showOpenDialog(ApplicationPreferenceModelPanel.this))) {
                File f = chooser.getSelectedFile();
                try {
                    String newConfigurationFile = f.toURI().toURL().toExternalForm();
                    if (!ApplicationPreferenceModelPanel.this.committedPreferenceModel.getConfigurationURLs().contains(newConfigurationFile)) {
                        ApplicationPreferenceModelPanel.this.configurationURL.addItem(newConfigurationFile);
                    }
                    ApplicationPreferenceModelPanel.this.configurationURL.setSelectedItem(newConfigurationFile);
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
            }
        }

        private void initSliderComponent() {
            this.responsiveSlider.setToolTipText("\u8868\u793a\u3092\u66f4\u65b0\u3059\u308b\u9593\u9694\u3002");
            this.responsiveSlider.setSnapToTicks(true);
            this.responsiveSlider.setLabelTable(this.sliderLabelMap);
            this.responsiveSlider.setPaintLabels(true);
            this.responsiveSlider.setPaintTrack(true);
            this.responsiveSlider.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\u66f4\u65b0\u9593\u9694"));
        }

        private void setupListeners() {
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("showNoReceiverWarning", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    GeneralAllPrefPanel.this.showNoReceiverWarning.setSelected((Boolean)evt.getNewValue());
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("showSplash", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    boolean value = (Boolean)evt.getNewValue();
                    GeneralAllPrefPanel.this.showSplash.setSelected(value);
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("okToRemoveSecurityManager", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    boolean newValue = (Boolean)evt.getNewValue();
                    if (newValue) {
                        GeneralAllPrefPanel.this.okToRemoveSecurityManager.setSelected(newValue);
                    } else {
                        GeneralAllPrefPanel.this.okToRemoveSecurityManager.setSelected(false);
                    }
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("identifierExpression", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ApplicationPreferenceModelPanel.this.identifierExpression.setText(evt.getNewValue().toString());
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("responsiveness", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    int value = (Integer)evt.getNewValue();
                    if (value >= 1000) {
                        int newValue = (value - 750) / 1000;
                        ApplicationPreferenceModelPanel.this.logger.debug((Object)("Adjusting old Responsiveness value from " + value + " to " + newValue));
                        value = newValue;
                    }
                    GeneralAllPrefPanel.this.responsiveSlider.setValue(value);
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("toolTipDisplayMillis", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ApplicationPreferenceModelPanel.this.toolTipDisplayMillis.setText(evt.getNewValue().toString());
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("cyclicBufferSize", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    ApplicationPreferenceModelPanel.this.cyclicBufferSize.setText(evt.getNewValue().toString());
                }
            });
            this.showNoReceiverWarning.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setShowNoReceiverWarning(GeneralAllPrefPanel.this.showNoReceiverWarning.isSelected());
                }
            });
            this.showSplash.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setShowSplash(GeneralAllPrefPanel.this.showSplash.isSelected());
                }
            });
            this.okToRemoveSecurityManager.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    if (GeneralAllPrefPanel.this.okToRemoveSecurityManager.isSelected() && JOptionPane.showConfirmDialog(GeneralAllPrefPanel.this.okToRemoveSecurityManager, "\u3053\u306e\u8a2d\u5b9a\u3092\u30c1\u30a7\u30c3\u30af\u3059\u308b\u3068\u3001Chainsaw\u306fJava\u306e\u30bb\u30ad\u30e5\u30ea\u30c6\u30a3\u30de\u30cd\u30fc\u30b8\u30e3\u3092\u89e3\u9664\u3057\u307e\u3059\u3002\n\nJava Web Start\u304c\u30ed\u30fc\u30ab\u30ebJars\uff0f\u30af\u30e9\u30b9\u3092\u5229\u7528\u3059\u308b\u305f\u3081\u306b\u89e3\u9664\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002\u3053\u308c\u3089\u304c\u306a\u3044\u3068JMSReceiver + DBReceiver\u306e\u3088\u3046\u306b\u7279\u5b9a\u306e\u30c9\u30e9\u30a4\u30d0jar\u3092\u5fc5\u8981\u3068\u3059\u308b\u51e6\u7406\u306f\u5b9f\u884c\u3067\u304d\u307e\u305b\u3093\u3002\n\n\u7d99\u7d9a\u3057\u307e\u3059\u304b\uff1f", "\u7d99\u7d9a", 0) == 0) {
                        ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setOkToRemoveSecurityManager(true);
                    } else {
                        ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setOkToRemoveSecurityManager(false);
                    }
                }
            });
            this.responsiveSlider.getModel().addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (!GeneralAllPrefPanel.this.responsiveSlider.getValueIsAdjusting()) {
                        int value = GeneralAllPrefPanel.this.responsiveSlider.getValue();
                        if (value == 0) {
                            value = 1;
                        }
                        ApplicationPreferenceModelPanel.this.logger.debug((Object)("Adjust responsiveness to " + value));
                        ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setResponsiveness(value);
                    }
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("confirmExit", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    boolean value = (Boolean)evt.getNewValue();
                    GeneralAllPrefPanel.this.confirmExit.setSelected(value);
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("configurationURL", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    String value = evt.getNewValue().toString();
                    ApplicationPreferenceModelPanel.this.configurationURL.setSelectedItem(value);
                }
            });
            this.confirmExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setConfirmExit(GeneralAllPrefPanel.this.confirmExit.isSelected());
                }
            });
        }

        private void setupInitialValues() {
            this.sliderLabelMap.put(new Integer(1), new JLabel("\u6700\u901f"));
            this.sliderLabelMap.put(new Integer(2), new JLabel("\u65e9\u3044"));
            this.sliderLabelMap.put(new Integer(3), new JLabel("\u666e\u901a"));
            this.sliderLabelMap.put(new Integer(4), new JLabel("\u9045\u3044"));
            this.showNoReceiverWarning.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isShowNoReceiverWarning());
            ApplicationPreferenceModelPanel.this.identifierExpression.setText(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.getIdentifierExpression());
            this.confirmExit.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isConfirmExit());
            this.okToRemoveSecurityManager.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isOkToRemoveSecurityManager());
            this.showNoReceiverWarning.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isShowNoReceiverWarning());
            this.showSplash.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isShowSplash());
            ApplicationPreferenceModelPanel.this.identifierExpression.setText(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.getIdentifierExpression());
            ApplicationPreferenceModelPanel.this.toolTipDisplayMillis.setText(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.getToolTipDisplayMillis() + "");
            ApplicationPreferenceModelPanel.this.cyclicBufferSize.setText(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.getCyclicBufferSize() + "");
            ApplicationPreferenceModelPanel.this.configurationURL.setSelectedItem(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.getConfigurationURL());
        }
    }

    public class VisualsPrefPanel
    extends BasicPrefPanel {
        private final JRadioButton topPlacement = new JRadioButton("\u4e0a");
        private final JRadioButton bottomPlacement = new JRadioButton("\u4e0b");
        private final JCheckBox statusBar = new JCheckBox("\u30b9\u30c6\u30fc\u30bf\u30d0\u30fc\u3092\u8868\u793a");
        private final JCheckBox toolBar = new JCheckBox("\u30c4\u30fc\u30eb\u30d0\u30fc\u3092\u8868\u793a");
        private final JCheckBox receivers = new JCheckBox("\u30ec\u30b7\u30fc\u30d0\u30fc\u3092\u8868\u793a");
        private UIManager.LookAndFeelInfo[] lookAndFeels = UIManager.getInstalledLookAndFeels();
        private final ButtonGroup lookAndFeelGroup = new ButtonGroup();

        private VisualsPrefPanel() {
            super("\u8868\u793a");
            this.setupComponents();
            this.setupListeners();
            this.setupInitialValues();
        }

        private void setupListeners() {
            this.topPlacement.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setTabPlacement(1);
                }
            });
            this.bottomPlacement.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setTabPlacement(3);
                }
            });
            this.statusBar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setStatusBar(VisualsPrefPanel.this.statusBar.isSelected());
                }
            });
            this.toolBar.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setToolbar(VisualsPrefPanel.this.toolBar.isSelected());
                }
            });
            this.receivers.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setReceivers(VisualsPrefPanel.this.receivers.isSelected());
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("tabPlacement", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    int value = (Integer)evt.getNewValue();
                    VisualsPrefPanel.this.configureTabPlacement(value);
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("statusBar", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    VisualsPrefPanel.this.statusBar.setSelected((Boolean)evt.getNewValue());
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("toolbar", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    VisualsPrefPanel.this.toolBar.setSelected((Boolean)evt.getNewValue());
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("receivers", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    VisualsPrefPanel.this.receivers.setSelected((Boolean)evt.getNewValue());
                }
            });
            ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.addPropertyChangeListener("lookAndFeelClassName", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    String lf = evt.getNewValue().toString();
                    Enumeration<AbstractButton> enumeration = VisualsPrefPanel.this.lookAndFeelGroup.getElements();
                    while (enumeration.hasMoreElements()) {
                        JRadioButton button = (JRadioButton)enumeration.nextElement();
                        if (button.getName() == null || !button.getName().equals(lf)) continue;
                        button.setSelected(true);
                        break;
                    }
                }
            });
        }

        private void setupComponents() {
            this.setLayout(new BoxLayout(this, 1));
            JPanel tabPlacementBox = new JPanel();
            tabPlacementBox.setLayout(new BoxLayout(tabPlacementBox, 1));
            tabPlacementBox.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\u30bf\u30d6\u306e\u4f4d\u7f6e"));
            ButtonGroup tabPlacementGroup = new ButtonGroup();
            tabPlacementGroup.add(this.topPlacement);
            tabPlacementGroup.add(this.bottomPlacement);
            tabPlacementBox.add(this.topPlacement);
            tabPlacementBox.add(this.bottomPlacement);
            if (OSXIntegration.IS_OSX) {
                tabPlacementBox.setEnabled(false);
                this.topPlacement.setEnabled(false);
                this.bottomPlacement.setEnabled(false);
            }
            this.add(tabPlacementBox);
            this.add(this.statusBar);
            this.add(this.receivers);
            this.add(this.toolBar);
            JPanel lfPanel = new JPanel();
            lfPanel.setLayout(new BoxLayout(lfPanel, 1));
            lfPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "\u30eb\u30c3\u30af\uff06\u30d5\u30a3\u30fc\u30eb"));
            for (int i = 0; i < this.lookAndFeels.length; ++i) {
                final UIManager.LookAndFeelInfo lfInfo = this.lookAndFeels[i];
                JRadioButton lfItem = new JRadioButton(lfInfo.getName());
                lfItem.setName(lfInfo.getClassName());
                lfItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setLookAndFeelClassName(lfInfo.getClassName());
                    }
                });
                this.lookAndFeelGroup.add(lfItem);
                lfPanel.add(lfItem);
            }
            try {
                final Class<?> gtkLF = Class.forName("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                JRadioButton lfIGTK = new JRadioButton("GTK+ 2.0");
                lfIGTK.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.setLookAndFeelClassName(gtkLF.getName());
                    }
                });
                this.lookAndFeelGroup.add(lfIGTK);
                lfPanel.add(lfIGTK);
            }
            catch (Exception e) {
                ApplicationPreferenceModelPanel.this.logger.debug((Object)"\u65b0\u3057\u3044GTK \u30eb\u30c3\u30af&\u30d5\u30a3\u30fc\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002Windows\u53c8\u306fJDK1.4.2\u3088\u308a\u524d\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u306e\u53ef\u80fd\u6027\u304c\u3042\u308a\u307e\u3059");
            }
            this.add(lfPanel);
            this.add(new JLabel("<html>\u3053\u3053\u306e\u8a2d\u5b9a\u306f\u3001Chainsaw\u304c\u518d\u8d77\u52d5\u3055\u308c\u305f\u5834\u5408\u306b\u6709\u52b9\u306b\u306a\u308a\u307e\u3059\u3002<br>\u5024\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u306a\u3044\u5834\u5408\u306f\u3001\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u30eb\u30c3\u30af&\u30d5\u30a3\u30fc\u30eb\u3067\u4f7f\u308f\u308c\u307e\u3059\u3002</html>"));
        }

        private void configureTabPlacement(int value) {
            switch (value) {
                case 1: {
                    this.topPlacement.setSelected(true);
                    break;
                }
                case 3: {
                    this.bottomPlacement.setSelected(true);
                    break;
                }
            }
        }

        private void setupInitialValues() {
            this.statusBar.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isStatusBar());
            this.receivers.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isReceivers());
            this.toolBar.setSelected(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.isToolbar());
            this.configureTabPlacement(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.getTabPlacement());
            Enumeration<AbstractButton> e = this.lookAndFeelGroup.getElements();
            while (e.hasMoreElements()) {
                JRadioButton radioButton = (JRadioButton)e.nextElement();
                if (!radioButton.getText().equals(ApplicationPreferenceModelPanel.this.uncommittedPreferenceModel.getLookAndFeelClassName())) continue;
                radioButton.setSelected(true);
                break;
            }
        }
    }
}

