/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.spi;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.ULogger;
import org.apache.log4j.helpers.MessageFormatter;

public final class Log4JULogger
implements ULogger {
    private final Logger logger;

    public Log4JULogger(Logger l) {
        if (l == null) {
            throw new NullPointerException("l");
        }
        this.logger = l;
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void debug(Object msg) {
        this.logger.debug(msg);
    }

    public void debug(Object parameterizedMsg, Object param1) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormatter.format(parameterizedMsg.toString(), param1));
        }
    }

    public void debug(String parameterizedMsg, Object param1, Object param2) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)MessageFormatter.format(parameterizedMsg.toString(), param1, param2));
        }
    }

    public void debug(Object msg, Throwable t) {
        this.logger.debug(msg, t);
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public void info(Object msg) {
        this.logger.info(msg);
    }

    public void info(Object parameterizedMsg, Object param1) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)MessageFormatter.format(parameterizedMsg.toString(), param1));
        }
    }

    public void info(String parameterizedMsg, Object param1, Object param2) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)MessageFormatter.format(parameterizedMsg.toString(), param1, param2));
        }
    }

    public void info(Object msg, Throwable t) {
        this.logger.info(msg, t);
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabledFor((Priority)Level.WARN);
    }

    public void warn(Object msg) {
        this.logger.warn(msg);
    }

    public void warn(Object parameterizedMsg, Object param1) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            this.logger.warn((Object)MessageFormatter.format(parameterizedMsg.toString(), param1));
        }
    }

    public void warn(String parameterizedMsg, Object param1, Object param2) {
        if (this.logger.isEnabledFor((Priority)Level.WARN)) {
            this.logger.warn((Object)MessageFormatter.format(parameterizedMsg.toString(), param1, param2));
        }
    }

    public void warn(Object msg, Throwable t) {
        this.logger.warn(msg, t);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabledFor((Priority)Level.ERROR);
    }

    public void error(Object msg) {
        this.logger.error(msg);
    }

    public void error(Object parameterizedMsg, Object param1) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            this.logger.error((Object)MessageFormatter.format(parameterizedMsg.toString(), param1));
        }
    }

    public void error(String parameterizedMsg, Object param1, Object param2) {
        if (this.logger.isEnabledFor((Priority)Level.ERROR)) {
            this.logger.error((Object)MessageFormatter.format(parameterizedMsg.toString(), param1, param2));
        }
    }

    public void error(Object msg, Throwable t) {
        this.logger.error(msg, t);
    }
}

