/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.xml;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.plugins.Receiver;
import org.apache.log4j.rule.ExpressionRule;
import org.apache.log4j.rule.Rule;
import org.apache.log4j.spi.Decoder;
import org.apache.log4j.spi.LoggingEvent;

public class LogFileXMLReceiver
extends Receiver {
    private String fileURL;
    private Rule expressionRule;
    private String filterExpression;
    private String decoder = "org.apache.log4j.xml.XMLDecoder";
    private boolean tailing = false;
    private Decoder decoderInstance;
    private Reader reader;
    private static final String FILE_KEY = "file";
    private String host;
    private String path;
    private boolean useCurrentThread;

    public String getFileURL() {
        return this.fileURL;
    }

    public void setFileURL(String fileURL) {
        this.fileURL = fileURL;
    }

    public String getDecoder() {
        return this.decoder;
    }

    public void setDecoder(String _decoder) {
        this.decoder = _decoder;
    }

    public String getFilterExpression() {
        return this.filterExpression;
    }

    public boolean isTailing() {
        return this.tailing;
    }

    public void setTailing(boolean tailing) {
        this.tailing = tailing;
    }

    public void setFilterExpression(String filterExpression) {
        this.filterExpression = filterExpression;
    }

    private boolean passesExpression(LoggingEvent event) {
        if (event != null && this.expressionRule != null) {
            return this.expressionRule.evaluate(event, null);
        }
        return true;
    }

    public static void main(String[] args) {
    }

    public void shutdown() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void activateOptions() {
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    URL url = new URL(LogFileXMLReceiver.this.fileURL);
                    LogFileXMLReceiver.this.host = url.getHost();
                    if (LogFileXMLReceiver.this.host != null && LogFileXMLReceiver.this.host.equals("")) {
                        LogFileXMLReceiver.this.host = LogFileXMLReceiver.FILE_KEY;
                    }
                    LogFileXMLReceiver.this.path = url.getPath();
                }
                catch (MalformedURLException e1) {
                    e1.printStackTrace();
                }
                try {
                    if (LogFileXMLReceiver.this.filterExpression != null) {
                        LogFileXMLReceiver.this.expressionRule = ExpressionRule.getRule((String)LogFileXMLReceiver.this.filterExpression);
                    }
                }
                catch (Exception e) {
                    LogFileXMLReceiver.this.getLogger().warn((Object)("Invalid filter expression: " + LogFileXMLReceiver.this.filterExpression), (Throwable)e);
                }
                try {
                    Class<?> c = Class.forName(LogFileXMLReceiver.this.decoder);
                    Object o = c.newInstance();
                    if (o instanceof Decoder) {
                        LogFileXMLReceiver.this.decoderInstance = (Decoder)o;
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                catch (InstantiationException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                try {
                    LogFileXMLReceiver.this.reader = new InputStreamReader(new URL(LogFileXMLReceiver.this.getFileURL()).openStream());
                    LogFileXMLReceiver.this.process(LogFileXMLReceiver.this.reader);
                }
                catch (FileNotFoundException fnfe) {
                    LogFileXMLReceiver.this.getLogger().info((Object)"file not available");
                }
                catch (IOException ioe) {
                    LogFileXMLReceiver.this.getLogger().warn((Object)"unable to load file", (Throwable)ioe);
                    return;
                }
            }
        };
        if (this.useCurrentThread) {
            runnable.run();
        } else {
            Thread thread = new Thread(runnable, "LogFileXMLReceiver-" + this.getName());
            thread.start();
        }
    }

    private void process(Reader unbufferedReader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(unbufferedReader);
        char[] content = new char[10000];
        this.getLogger().debug((Object)("processing starting: " + this.fileURL));
        int length = 0;
        do {
            System.out.println("in do loop-about to process");
            while ((length = bufferedReader.read(content)) > -1) {
                this.processEvents(this.decoderInstance.decodeEvents(String.valueOf(content, 0, length)));
            }
            if (!this.tailing) continue;
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        } while (this.tailing);
        this.getLogger().debug((Object)("processing complete: " + this.fileURL));
        this.shutdown();
    }

    private void processEvents(Collection c) {
        if (c == null) {
            return;
        }
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            LoggingEvent evt = (LoggingEvent)iter.next();
            if (!this.passesExpression(evt)) continue;
            if (evt.getProperty("hostname") != null) {
                evt.setProperty("hostname", this.host);
            }
            if (evt.getProperty("application") != null) {
                evt.setProperty("application", this.path);
            }
            this.doPost(evt);
        }
    }

    public final boolean isUseCurrentThread() {
        return this.useCurrentThread;
    }

    public final void setUseCurrentThread(boolean useCurrentThread) {
        this.useCurrentThread = useCurrentThread;
    }
}

