/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.locale.I18n;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.JRCSVDataSourceConnection;
import com.jaspersoft.ireport.designer.connection.JRCsvDataSourceInspector;
import com.jaspersoft.ireport.designer.tools.FieldPatternDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

/**
 *
 * @author  gtoffoli
 */
public class CSVDataSourceConnectionEditor extends javax.swing.JPanel implements IReportConnectionEditor {
    
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    
    /** Creates new form EJBQLConnectionEditor */
    public CSVDataSourceConnectionEditor() {
        initComponents();
        jListCVSColumns.setModel( new DefaultListModel());
        jTextFieldCVSDateFormat.setText( new SimpleDateFormat().toPattern());
        //applyI18n();
        
        jTextFieldCVSSeparatorText.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                jRadioButtonCVSSeparatorOther.setSelected(true);
            }
            public void insertUpdate(DocumentEvent e) {
                jRadioButtonCVSSeparatorOther.setSelected(true);
            }
            public void removeUpdate(DocumentEvent e) {
                jRadioButtonCVSSeparatorOther.setSelected(true);
            }
        });
        
        jTextFieldCVSSeparatorText1.getDocument().addDocumentListener(new DocumentListener() {
            public void changedUpdate(DocumentEvent e) {
                jRadioButtonCVSSeparatorOther1.setSelected(true);
            }
            public void insertUpdate(DocumentEvent e) {
                jRadioButtonCVSSeparatorOther1.setSelected(true);
            }
            public void removeUpdate(DocumentEvent e) {
                jRadioButtonCVSSeparatorOther1.setSelected(true);
            }
        });

        jLabelSpecialCharacters.setText(I18n.getString("CSVExportParametersPanel.jLabelSpecialCharacters.text"));
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        buttonGroup2 = new javax.swing.ButtonGroup();
        jPanelCSV = new javax.swing.JPanel();
        jLabel15 = new javax.swing.JLabel();
        jTextFieldCSVFilename = new javax.swing.JTextField();
        jButtonCSVFilename = new javax.swing.JButton();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel11 = new javax.swing.JPanel();
        jPanel8 = new javax.swing.JPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jListCVSColumns = new javax.swing.JList();
        jPanel9 = new javax.swing.JPanel();
        jButtonNewParameter = new javax.swing.JButton();
        jButtonModifyParameter = new javax.swing.JButton();
        jButtonDeleteParameter = new javax.swing.JButton();
        jPanel10 = new javax.swing.JPanel();
        jButtonGetColumns = new javax.swing.JButton();
        jPanel6 = new javax.swing.JPanel();
        jCheckBoxCVSDateFormat = new javax.swing.JCheckBox();
        jTextFieldCVSDateFormat = new javax.swing.JTextField();
        jButtonCVSDateFormat = new javax.swing.JButton();
        jCheckBoxCVSFirstRowAsHeader = new javax.swing.JCheckBox();
        jPanel7 = new javax.swing.JPanel();
        jPanel4 = new javax.swing.JPanel();
        jRadioButtonCVSSeparatorComma = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorSpace = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorTab = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorSemicolon = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorOther = new javax.swing.JRadioButton();
        jTextFieldCVSSeparatorText = new javax.swing.JTextField();
        jRadioButtonCVSSeparatorNewLine = new javax.swing.JRadioButton();
        jPanel5 = new javax.swing.JPanel();
        jRadioButtonCVSSeparatorComma1 = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorSpace1 = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorTab1 = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorSemicolon1 = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorNewLine1 = new javax.swing.JRadioButton();
        jRadioButtonCVSSeparatorOther1 = new javax.swing.JRadioButton();
        jTextFieldCVSSeparatorText1 = new javax.swing.JTextField();
        jRadioButtonCVSSeparatorNewLine3 = new javax.swing.JRadioButton();
        jLabelSpecialCharacters = new javax.swing.JLabel();
        jPanel12 = new javax.swing.JPanel();

        setLayout(new java.awt.BorderLayout());

        jPanelCSV.setPreferredSize(new java.awt.Dimension(1, 30));
        jPanelCSV.setLayout(new java.awt.GridBagLayout());

        jLabel15.setText("CSVファイル");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jPanelCSV.add(jLabel15, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 6, 0, 0);
        jPanelCSV.add(jTextFieldCSVFilename, gridBagConstraints);

        jButtonCSVFilename.setText("参照");
        jButtonCSVFilename.setMargin(new java.awt.Insets(2, 4, 2, 4));
        jButtonCSVFilename.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCSVFilenameActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 27;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        jPanelCSV.add(jButtonCSVFilename, gridBagConstraints);

        jPanel11.setLayout(new java.awt.GridBagLayout());

        jPanel8.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Column names"));
        jPanel8.setLayout(new java.awt.GridBagLayout());

        jListCVSColumns.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jListCVSColumnsValueChanged(evt);
            }
        });
        jListCVSColumns.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jListCVSColumnsMouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(jListCVSColumns);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel8.add(jScrollPane1, gridBagConstraints);

        jPanel9.setPreferredSize(new java.awt.Dimension(71, 200));
        jPanel9.setLayout(new java.awt.GridBagLayout());

        jButtonNewParameter.setText("新規");
        jButtonNewParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonNewParameterActionPerformed1(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel9.add(jButtonNewParameter, gridBagConstraints);

        jButtonModifyParameter.setText("変更");
        jButtonModifyParameter.setEnabled(false);
        jButtonModifyParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonModifyParameterActionPerformed1(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 5, 3);
        jPanel9.add(jButtonModifyParameter, gridBagConstraints);

        jButtonDeleteParameter.setText("削除");
        jButtonDeleteParameter.setEnabled(false);
        jButtonDeleteParameter.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonDeleteParameterActionPerformed1(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 3, 5, 3);
        jPanel9.add(jButtonDeleteParameter, gridBagConstraints);

        jPanel10.setLayout(null);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        jPanel9.add(jPanel10, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 4);
        jPanel8.add(jPanel9, gridBagConstraints);

        jButtonGetColumns.setText("Get columns name from the first row of the file");
        jButtonGetColumns.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonGetColumnsActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel8.add(jButtonGetColumns, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel11.add(jPanel8, gridBagConstraints);

        jPanel6.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Other"));
        jPanel6.setLayout(new java.awt.GridBagLayout());

        jCheckBoxCVSDateFormat.setText("Use custom date format");
        jCheckBoxCVSDateFormat.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBoxCVSDateFormat.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jCheckBoxCVSDateFormat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxCVSDateFormatActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        jPanel6.add(jCheckBoxCVSDateFormat, gridBagConstraints);

        jTextFieldCVSDateFormat.setEnabled(false);
        jTextFieldCVSDateFormat.setPreferredSize(new java.awt.Dimension(100, 19));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 10, 0, 0);
        jPanel6.add(jTextFieldCVSDateFormat, gridBagConstraints);

        jButtonCVSDateFormat.setText("Date format");
        jButtonCVSDateFormat.setEnabled(false);
        jButtonCVSDateFormat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCVSDateFormatActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        jPanel6.add(jButtonCVSDateFormat, gridBagConstraints);

        jCheckBoxCVSFirstRowAsHeader.setText("Skip the first line (the column names will be read from the first line)");
        jCheckBoxCVSFirstRowAsHeader.setActionCommand("Skip the first line (column names will be read from the first line)");
        jCheckBoxCVSFirstRowAsHeader.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jCheckBoxCVSFirstRowAsHeader.setMargin(new java.awt.Insets(0, 0, 0, 0));
        jCheckBoxCVSFirstRowAsHeader.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBoxCVSDateFormatActionPerformed1(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        jPanel6.add(jCheckBoxCVSFirstRowAsHeader, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 20;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel11.add(jPanel6, gridBagConstraints);

        jTabbedPane1.addTab("列", jPanel11);

        jPanel7.setLayout(new java.awt.GridBagLayout());

        jPanel4.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "Field separator (char)"));
        jPanel4.setLayout(new java.awt.GridBagLayout());

        buttonGroup1.add(jRadioButtonCVSSeparatorComma);
        jRadioButtonCVSSeparatorComma.setSelected(true);
        jRadioButtonCVSSeparatorComma.setText("コンマ");
        jRadioButtonCVSSeparatorComma.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorComma.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jRadioButtonCVSSeparatorComma, gridBagConstraints);

        buttonGroup1.add(jRadioButtonCVSSeparatorSpace);
        jRadioButtonCVSSeparatorSpace.setText("空白");
        jRadioButtonCVSSeparatorSpace.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorSpace.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jRadioButtonCVSSeparatorSpace, gridBagConstraints);

        buttonGroup1.add(jRadioButtonCVSSeparatorTab);
        jRadioButtonCVSSeparatorTab.setText("タブ");
        jRadioButtonCVSSeparatorTab.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorTab.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jRadioButtonCVSSeparatorTab, gridBagConstraints);

        buttonGroup1.add(jRadioButtonCVSSeparatorSemicolon);
        jRadioButtonCVSSeparatorSemicolon.setText("Semicolon");
        jRadioButtonCVSSeparatorSemicolon.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorSemicolon.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jRadioButtonCVSSeparatorSemicolon, gridBagConstraints);

        buttonGroup1.add(jRadioButtonCVSSeparatorOther);
        jRadioButtonCVSSeparatorOther.setText("その他");
        jRadioButtonCVSSeparatorOther.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorOther.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jRadioButtonCVSSeparatorOther, gridBagConstraints);

        jTextFieldCVSSeparatorText.setPreferredSize(new java.awt.Dimension(30, 19));
        jTextFieldCVSSeparatorText.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldCVSSeparatorTextActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        jPanel4.add(jTextFieldCVSSeparatorText, gridBagConstraints);

        buttonGroup1.add(jRadioButtonCVSSeparatorNewLine);
        jRadioButtonCVSSeparatorNewLine.setText("New line (Unix)");
        jRadioButtonCVSSeparatorNewLine.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorNewLine.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel4.add(jRadioButtonCVSSeparatorNewLine, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel7.add(jPanel4, gridBagConstraints);

        jPanel5.setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createEtchedBorder(), "行区切り"));
        jPanel5.setLayout(new java.awt.GridBagLayout());

        buttonGroup2.add(jRadioButtonCVSSeparatorComma1);
        jRadioButtonCVSSeparatorComma1.setText("コンマ");
        jRadioButtonCVSSeparatorComma1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorComma1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel5.add(jRadioButtonCVSSeparatorComma1, gridBagConstraints);

        buttonGroup2.add(jRadioButtonCVSSeparatorSpace1);
        jRadioButtonCVSSeparatorSpace1.setText("空白");
        jRadioButtonCVSSeparatorSpace1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorSpace1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel5.add(jRadioButtonCVSSeparatorSpace1, gridBagConstraints);

        buttonGroup2.add(jRadioButtonCVSSeparatorTab1);
        jRadioButtonCVSSeparatorTab1.setText("タブ");
        jRadioButtonCVSSeparatorTab1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorTab1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel5.add(jRadioButtonCVSSeparatorTab1, gridBagConstraints);

        buttonGroup2.add(jRadioButtonCVSSeparatorSemicolon1);
        jRadioButtonCVSSeparatorSemicolon1.setText("Semicolon");
        jRadioButtonCVSSeparatorSemicolon1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorSemicolon1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel5.add(jRadioButtonCVSSeparatorSemicolon1, gridBagConstraints);

        buttonGroup2.add(jRadioButtonCVSSeparatorNewLine1);
        jRadioButtonCVSSeparatorNewLine1.setText("New line (Unix)");
        jRadioButtonCVSSeparatorNewLine1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorNewLine1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel5.add(jRadioButtonCVSSeparatorNewLine1, gridBagConstraints);

        buttonGroup2.add(jRadioButtonCVSSeparatorOther1);
        jRadioButtonCVSSeparatorOther1.setText("その他");
        jRadioButtonCVSSeparatorOther1.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorOther1.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel5.add(jRadioButtonCVSSeparatorOther1, gridBagConstraints);

        jTextFieldCVSSeparatorText1.setPreferredSize(new java.awt.Dimension(30, 19));
        jTextFieldCVSSeparatorText1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextFieldCVSSeparatorText1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        jPanel5.add(jTextFieldCVSSeparatorText1, gridBagConstraints);

        buttonGroup2.add(jRadioButtonCVSSeparatorNewLine3);
        jRadioButtonCVSSeparatorNewLine3.setSelected(true);
        jRadioButtonCVSSeparatorNewLine3.setText("New line (Windows)");
        jRadioButtonCVSSeparatorNewLine3.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        jRadioButtonCVSSeparatorNewLine3.setMargin(new java.awt.Insets(0, 0, 0, 0));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHEAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel5.add(jRadioButtonCVSSeparatorNewLine3, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel7.add(jPanel5, gridBagConstraints);

        jLabelSpecialCharacters.setText("<html>特殊文字：:<br><b>\\n</b>\tラインフィード<br><b>\\r</b>\tキャリッジリターン<br><b>\\t</b>\tタブ<br><b>\\\\</b>\t円");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new java.awt.Insets(8, 8, 8, 8);
        jPanel7.add(jLabelSpecialCharacters, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        jPanel7.add(jPanel12, gridBagConstraints);

        jTabbedPane1.addTab("区切り", jPanel7);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelCSV.add(jTabbedPane1, gridBagConstraints);

        add(jPanelCSV, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.ButtonGroup buttonGroup2;
    private javax.swing.JButton jButtonCSVFilename;
    private javax.swing.JButton jButtonCVSDateFormat;
    private javax.swing.JButton jButtonDeleteParameter;
    private javax.swing.JButton jButtonGetColumns;
    private javax.swing.JButton jButtonModifyParameter;
    private javax.swing.JButton jButtonNewParameter;
    private javax.swing.JCheckBox jCheckBoxCVSDateFormat;
    private javax.swing.JCheckBox jCheckBoxCVSFirstRowAsHeader;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabelSpecialCharacters;
    private javax.swing.JList jListCVSColumns;
    private javax.swing.JPanel jPanel10;
    private javax.swing.JPanel jPanel11;
    private javax.swing.JPanel jPanel12;
    private javax.swing.JPanel jPanel4;
    private javax.swing.JPanel jPanel5;
    private javax.swing.JPanel jPanel6;
    private javax.swing.JPanel jPanel7;
    private javax.swing.JPanel jPanel8;
    private javax.swing.JPanel jPanel9;
    private javax.swing.JPanel jPanelCSV;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorComma;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorComma1;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorNewLine;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorNewLine1;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorNewLine3;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorOther;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorOther1;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorSemicolon;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorSemicolon1;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorSpace;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorSpace1;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorTab;
    private javax.swing.JRadioButton jRadioButtonCVSSeparatorTab1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JTextField jTextFieldCSVFilename;
    private javax.swing.JTextField jTextFieldCVSDateFormat;
    private javax.swing.JTextField jTextFieldCVSSeparatorText;
    private javax.swing.JTextField jTextFieldCVSSeparatorText1;
    // End of variables declaration//GEN-END:variables
    
    
    public void setIReportConnection(IReportConnection c) {
        
        this.iReportConnection = c;
        if (iReportConnection instanceof JRCSVDataSourceConnection)
        {
            JRCSVDataSourceConnection con = (JRCSVDataSourceConnection)iReportConnection;
            this.jTextFieldCSVFilename.setText( con.getFilename() );
            
            if (con.getCustomDateFormat().length() > 0)
            {
                this.jCheckBoxCVSDateFormat.setSelected(true);
                this.jTextFieldCVSDateFormat.setText(con.getCustomDateFormat());
                this.jTextFieldCVSDateFormat.setEnabled(true);
                this.jButtonCVSDateFormat.setEnabled(true);
            }
            
            this.jCheckBoxCVSFirstRowAsHeader.setSelected( con.isUseFirstRowAsHeader() );
            
            String fieldSeparator = con.getFieldDelimiter();
            if (fieldSeparator.equals(",")) this.jRadioButtonCVSSeparatorComma.setSelected(true);
            else if (fieldSeparator.equals("\t")) this.jRadioButtonCVSSeparatorTab.setSelected(true);
            else if (fieldSeparator.equals(" ")) this.jRadioButtonCVSSeparatorSpace.setSelected(true);
            else if (fieldSeparator.equals(";")) this.jRadioButtonCVSSeparatorSemicolon.setSelected(true);
            else if (fieldSeparator.equals("\n")) this.jRadioButtonCVSSeparatorNewLine.setSelected(true);
            else {
                this.jRadioButtonCVSSeparatorOther.setSelected(true);
                this.jTextFieldCVSSeparatorText.setText( Misc.addSlashesString(fieldSeparator));
            }
            
            String rowSeparator = con.getRecordDelimiter();
            if (rowSeparator.equals(",")) this.jRadioButtonCVSSeparatorComma1.setSelected(true);
            else if (rowSeparator.equals("\t")) this.jRadioButtonCVSSeparatorTab1.setSelected(true);
            else if (rowSeparator.equals(" ")) this.jRadioButtonCVSSeparatorSpace1.setSelected(true);
            else if (rowSeparator.equals(";")) this.jRadioButtonCVSSeparatorSemicolon1.setSelected(true);
            else if (rowSeparator.equals("\n")) this.jRadioButtonCVSSeparatorNewLine1.setSelected(true);
            else if (rowSeparator.equals("\r\n")) this.jRadioButtonCVSSeparatorNewLine3.setSelected(true);
            else {
                this.jRadioButtonCVSSeparatorOther1.setSelected(true);
                this.jTextFieldCVSSeparatorText1.setText(Misc.addSlashesString(rowSeparator));
            }
            
            DefaultListModel dlm = (DefaultListModel)this.jListCVSColumns.getModel();

            for (int i=0; i< con.getColumnNames().size(); ++i)
            {
                dlm.addElement(con.getColumnNames().elementAt(i)+"" );
            }
            
            if (dlm.size() > 0)
            {
                jListCVSColumns.setSelectedIndex(0);
            }
        }
    }

    @SuppressWarnings("unchecked")
    public IReportConnection getIReportConnection() {
        
        IReportConnection irConn = new JRCSVDataSourceConnection();

            ((JRCSVDataSourceConnection)irConn).setFilename( this.jTextFieldCSVFilename.getText().trim() );
            
            if (jRadioButtonCVSSeparatorComma.isSelected()) ((JRCSVDataSourceConnection)irConn).setFieldDelimiter(",");
            if (jRadioButtonCVSSeparatorTab.isSelected()) ((JRCSVDataSourceConnection)irConn).setFieldDelimiter("\t");
            if (jRadioButtonCVSSeparatorSpace.isSelected()) ((JRCSVDataSourceConnection)irConn).setFieldDelimiter(" ");
            if (jRadioButtonCVSSeparatorSemicolon.isSelected()) ((JRCSVDataSourceConnection)irConn).setFieldDelimiter(";");
            if (jRadioButtonCVSSeparatorNewLine.isSelected()) ((JRCSVDataSourceConnection)irConn).setFieldDelimiter("\n");
            if (jRadioButtonCVSSeparatorOther.isSelected())
            {
                ((JRCSVDataSourceConnection)irConn).setFieldDelimiter( Misc.removeSlashesString( jTextFieldCVSSeparatorText.getText() ));
            }

            if (jRadioButtonCVSSeparatorComma1.isSelected()) ((JRCSVDataSourceConnection)irConn).setRecordDelimiter(",");
            if (jRadioButtonCVSSeparatorTab1.isSelected()) ((JRCSVDataSourceConnection)irConn).setRecordDelimiter("\t");
            if (jRadioButtonCVSSeparatorSpace1.isSelected()) ((JRCSVDataSourceConnection)irConn).setRecordDelimiter(" ");
            if (jRadioButtonCVSSeparatorSemicolon1.isSelected()) ((JRCSVDataSourceConnection)irConn).setRecordDelimiter(";");
            if (jRadioButtonCVSSeparatorNewLine1.isSelected()) ((JRCSVDataSourceConnection)irConn).setRecordDelimiter("\n");
            if (jRadioButtonCVSSeparatorNewLine3.isSelected()) ((JRCSVDataSourceConnection)irConn).setRecordDelimiter("\r\n");
            if (jRadioButtonCVSSeparatorOther1.isSelected())
            {
                ((JRCSVDataSourceConnection)irConn).setRecordDelimiter( Misc.removeSlashesString( jTextFieldCVSSeparatorText1.getText() ));
            }

            ((JRCSVDataSourceConnection)irConn).setCustomDateFormat( jCheckBoxCVSDateFormat.isSelected() ?  jTextFieldCVSDateFormat.getText() : "");
            ((JRCSVDataSourceConnection)irConn).setUseFirstRowAsHeader( jCheckBoxCVSFirstRowAsHeader.isSelected() );
            
            DefaultListModel dlm = (DefaultListModel)this.jListCVSColumns.getModel();
            Vector columnsNames = new Vector();
            for (int k=0; k< dlm.size(); ++k)
            {
                columnsNames.add(dlm.elementAt(k)+"");
            }
            
            ((JRCSVDataSourceConnection)irConn).setColumnNames( columnsNames );
            
            if (columnsNames.size() == 0)
            {
                if (JOptionPane.showConfirmDialog(this,I18n.getString("CSVDataSourceConnectionEditor.Dialog.Confirm"),"",JOptionPane.INFORMATION_MESSAGE) != JOptionPane.OK_OPTION) //"messages.connectionDialog.notAllColumnsDefined"
                {
                    return null;
                }
            }
            if (((JRCSVDataSourceConnection)irConn).getFieldDelimiter().equals( ((JRCSVDataSourceConnection)irConn).getRecordDelimiter() ))
            {
                if (JOptionPane.showConfirmDialog(this,I18n.getString("CSVDataSourceConnectionEditor.Dialog.Confirm2"),"",JOptionPane.INFORMATION_MESSAGE) != JOptionPane.OK_OPTION) //"messages.connectionDialog.duplicatedDelimiter"
                {
                    return null;
                } 
            }

        iReportConnection = irConn;
        return iReportConnection;
    }
    
    /*
    public void applyI18n(){

                jCheckBoxCVSDateFormat.setText(I18n.getString("connectionDialog.checkBoxCVSDateFormat","Use custom date format"));
                jCheckBoxCVSFirstRowAsHeader.setText(I18n.getString("connectionDialog.checkBoxCVSFirstRowAsHeader","Skip the first line (the column names will be read from the first line)"));
                jRadioButtonCVSSeparatorComma.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorComma","Comma"));
                jRadioButtonCVSSeparatorComma1.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorComma1","Comma"));
                jRadioButtonCVSSeparatorNewLine.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorNewLine","New line"));
                jRadioButtonCVSSeparatorNewLine1.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorNewLine1","New line"));
                jRadioButtonCVSSeparatorOther.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorOther","Other"));
                jRadioButtonCVSSeparatorOther1.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorOther1","Other"));
                jRadioButtonCVSSeparatorSemicolon.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorSemicolon","Semicolon"));
                jRadioButtonCVSSeparatorSemicolon1.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorSemicolon1","Semicolon"));
                jRadioButtonCVSSeparatorSpace.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorSpace","Space"));
                jRadioButtonCVSSeparatorSpace1.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorSpace1","Space"));
                jRadioButtonCVSSeparatorTab.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorTab","Tab"));
                jRadioButtonCVSSeparatorTab1.setText(I18n.getString("connectionDialog.radioButtonCVSSeparatorTab1","Tab"));
                jButtonCSVFilename.setText(I18n.getString("connectionDialog.buttonCSVFilename","Browse"));
                jButtonCVSDateFormat.setText(I18n.getString("connectionDialog.buttonCVSDateFormat","Date format"));
                jButtonDeleteParameter.setText(I18n.getString("connectionDialog.buttonDeleteParameter","Delete"));
                jButtonModifyParameter.setText(I18n.getString("connectionDialog.buttonModifyParameter","Modify"));
                jButtonNewParameter.setText(I18n.getString("connectionDialog.buttonNewParameter","New"));
                jButtonNewParameter1.setText(I18n.getString("connectionDialog.buttonNewParameter1","Get columns name from the first row of the file"));
                
                jTabbedPane1.setTitleAt(0,I18n.getString("connectionDialog.tab.Columns","Columns") );
                jTabbedPane1.setTitleAt(0,I18n.getString("connectionDialog.tab.Separators","Separators") );
                
                ((javax.swing.border.TitledBorder)jPanel8.getBorder()).setTitle( it.businesslogic.ireport.util.I18n.getString("connectionDialog.panelBorder.ColumnNames","Column names") );
                ((javax.swing.border.TitledBorder)jPanel6.getBorder()).setTitle( it.businesslogic.ireport.util.I18n.getString("connectionDialog.panelBorder.Other","Other") );
                ((javax.swing.border.TitledBorder)jPanel4.getBorder()).setTitle( it.businesslogic.ireport.util.I18n.getString("connectionDialog.panelBorder.FieldSeparatorChat","Field separator (char)") );
                ((javax.swing.border.TitledBorder)jPanel5.getBorder()).setTitle( it.businesslogic.ireport.util.I18n.getString("connectionDialog.panelBorder.RowSeparator","Row separator") );
                                
    }
     */
    
    
     private void jButtonCSVFilenameActionPerformed(java.awt.event.ActionEvent evt) {                                                   
            String fileName = "";
	    javax.swing.JFileChooser jfc = new javax.swing.JFileChooser( IReportManager.getInstance().getCurrentDirectory());
	    
	    jfc.setDialogTitle(I18n.getString("CSVDataSourceConnectionEditor.DialogTitle.SelectFile"));
	    
	    jfc.addChoosableFileFilter( new javax.swing.filechooser.FileFilter() {
		    public boolean accept(java.io.File file) {
			    String filename = file.getName();
			    return (filename.toLowerCase().endsWith(".csv") || file.isDirectory()) ;
		    }
		    public String getDescription() {
			    return "CSV *.csv";
		    }
	    });
	    
	    jfc.setMultiSelectionEnabled(false);
	    jfc.setDialogType( javax.swing.JFileChooser.OPEN_DIALOG);
	    if  (jfc.showOpenDialog( this) == javax.swing.JOptionPane.OK_OPTION) {
		    java.io.File file = jfc.getSelectedFile();		
                    try {
                        jTextFieldCSVFilename.setText( file.getAbsolutePath() );
                    } catch (Exception ex){}
	    }        
    }        
     
      private void jListCVSColumnsValueChanged(javax.swing.event.ListSelectionEvent evt) {                                             

        if (jListCVSColumns.getSelectedIndex() >= 0)
        {
            jButtonModifyParameter.setEnabled(true);
            jButtonDeleteParameter.setEnabled(true);
        }
        else
        {
            jButtonModifyParameter.setEnabled(false);
            jButtonDeleteParameter.setEnabled(false);
        }
        
    }                                            

    private void jListCVSColumnsMouseClicked(java.awt.event.MouseEvent evt) {                                             

            if (evt.getClickCount() == 2 && evt.getButton() == MouseEvent.BUTTON1)
            {
                jButtonModifyParameterActionPerformed1(null);
            }
        
    }                                            

    private void jCheckBoxCVSDateFormatActionPerformed1(java.awt.event.ActionEvent evt) {                                                        
// TODO add your handling code here:
    }                                                       

    private void jButtonGetColumnsActionPerformed(java.awt.event.ActionEvent evt) {

        try {
            JRCsvDataSourceInspector ds = new JRCsvDataSourceInspector(new File( jTextFieldCSVFilename.getText()));
        
            if (jRadioButtonCVSSeparatorComma.isSelected()) ds.setFieldDelimiter(',');
            if (jRadioButtonCVSSeparatorTab.isSelected()) ds.setFieldDelimiter('\t');
            if (jRadioButtonCVSSeparatorSpace.isSelected()) ds.setFieldDelimiter(' ');
            if (jRadioButtonCVSSeparatorSemicolon.isSelected()) ds.setFieldDelimiter(';');
            if (jRadioButtonCVSSeparatorNewLine.isSelected()) ds.setFieldDelimiter('\n');
            if (jRadioButtonCVSSeparatorOther.isSelected()) ds.setFieldDelimiter(( Misc.removeSlashesString(jTextFieldCVSSeparatorText.getText()+" ")).charAt(0));
            
            if (jRadioButtonCVSSeparatorComma1.isSelected()) ds.setRecordDelimiter(",");
            if (jRadioButtonCVSSeparatorTab1.isSelected()) ds.setRecordDelimiter("\t");
            if (jRadioButtonCVSSeparatorSpace1.isSelected()) ds.setRecordDelimiter(" ");
            if (jRadioButtonCVSSeparatorSemicolon1.isSelected()) ds.setRecordDelimiter(";");
            if (jRadioButtonCVSSeparatorNewLine1.isSelected()) ds.setRecordDelimiter("\n");
            if (jRadioButtonCVSSeparatorNewLine3.isSelected()) ds.setRecordDelimiter("\r\n");
            if (jRadioButtonCVSSeparatorOther1.isSelected()) ds.setRecordDelimiter(Misc.removeSlashesString(jTextFieldCVSSeparatorText1.getText()));
            
            DefaultListModel dlm = (DefaultListModel)jListCVSColumns.getModel();
            dlm.removeAllElements();
            
            Vector names = ds.getColumnNames();
            for (int i=0; i < names.size(); ++i )
            {
                String fname = (names.elementAt(i)+"").trim();
                if (fname.length() > 0)
                  dlm.addElement(fname);
            }
            
            if (names.size() > 0)
            {
                jListCVSColumns.setSelectedIndex(0);
            }

            jCheckBoxCVSFirstRowAsHeader.setSelected(true);
        } catch (Exception ex)
        {
            JOptionPane.showMessageDialog(this,ex.getMessage(), I18n.getString("CSVDataSourceConnectionEditor.Message.Exception"), JOptionPane.ERROR_MESSAGE); //"message.title.exception"
        }
        
    }                                                     

    private void jButtonDeleteParameterActionPerformed1(java.awt.event.ActionEvent evt) {                                                        
        
        // Get the selected connection...
        DefaultListModel dlm = (DefaultListModel)jListCVSColumns.getModel();
        Object[] values = jListCVSColumns.getSelectedValues();

        for (int i=0; i<values.length; ++i)
        {
            dlm.removeElement(values[i]);
        }
    }                                                       

    private void jButtonModifyParameterActionPerformed1(java.awt.event.ActionEvent evt) {                                                        
        
        int index = jListCVSColumns.getSelectedIndex();
        
        if (index < 0) return;
        
        DefaultListModel dlm = (DefaultListModel)jListCVSColumns.getModel();
        String oldName = (String)dlm.getElementAt(index); 
        
        String name = JOptionPane.showInputDialog(this, I18n.getString("CSVDataSourceConnectionEditor.Pane.Column_name"), oldName); //"connectionDialog.input.columnName"
        
        if (name != null)
        {
            dlm.setElementAt(name, index);
        }
    }                                                       

    private void jButtonNewParameterActionPerformed1(java.awt.event.ActionEvent evt) {                                                     
        
        DefaultListModel dlm = (DefaultListModel)jListCVSColumns.getModel();
        String name = JOptionPane.showInputDialog(this, I18n.getString("CSVDataSourceConnectionEditor.Pane.Column_name"), "COLUMN_" + dlm.getSize()); //"connectionDialog.input.columnName"
        
        if (name != null)
        {
            dlm.addElement(name);
        }
        
        if (dlm.size() == 1)
        {
            jListCVSColumns.setSelectedIndex(0);
        }
    }                                                    

    private void jTextFieldCVSSeparatorText1ActionPerformed(java.awt.event.ActionEvent evt) {                                                            
    
        if (this.jTextFieldCVSSeparatorText1.getText().length() > 0)
        this.jRadioButtonCVSSeparatorOther1.setSelected(true);
    }                                                           

    private void jTextFieldCVSSeparatorTextActionPerformed(java.awt.event.ActionEvent evt) {                                                           

        if (this.jTextFieldCVSSeparatorText.getText().length() > 0)
        this.jRadioButtonCVSSeparatorOther.setSelected(true);
        
    }                                                          

    private void jButtonCVSDateFormatActionPerformed(java.awt.event.ActionEvent evt) {                                                     

            FieldPatternDialog fpd = new FieldPatternDialog((JDialog)SwingUtilities.getWindowAncestor(this), true);
            fpd.setOnlyDate(true);
            
            fpd.setVisible(true);
            if (fpd.getDialogResult() == JOptionPane.OK_OPTION)
            {
                jTextFieldCVSDateFormat.setText( fpd.getPattern() );
            }
        
    }                                                    

    private void jCheckBoxCVSDateFormatActionPerformed(java.awt.event.ActionEvent evt) {                                                       
        
        jTextFieldCVSDateFormat.setEnabled( this.jCheckBoxCVSDateFormat.isSelected());
        jButtonCVSDateFormat.setEnabled(  this.jCheckBoxCVSDateFormat.isSelected() );
        
        if (!this.jCheckBoxCVSDateFormat.isSelected())
        {
            jTextFieldCVSDateFormat.setText( new SimpleDateFormat().toPattern());
        }
        
    } 
    
}
