/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.welcome;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.locale.I18n;
import java.io.IOException;
import java.net.URL;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;

/**
 *
 * @author gtoffoli
 */
public class WebContentPanel extends javax.swing.JPanel {

    private String contentUrl = null;
    /** Creates new form WebContentPanel */
    public WebContentPanel(final String url) {
        initComponents();

        this.contentUrl = url;

        jEditorPane1.setContentType("text/html");
        URL img_url = this.getClass().getResource("/com/jaspersoft/ireport/designer/welcome/loader.gif");
        
        if (IReportManager.getInstance().isNoNetwork())
        {
            jEditorPane1.setText("<html><body><br><br><font color=\"#AAAAAA\">Network disabled</font><br><br></body></html>");
        }
        else
        {
            jEditorPane1.setText("<html><body><br><br><img src=\"" + img_url + "\"><br><br></body></html>");
        }

        jEditorPane1.addHyperlinkListener(new HyperlinkListener() {

            public void hyperlinkUpdate(HyperlinkEvent e) {

                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED)
                {
                    StatusDisplayer.getDefault().setStatusText(e.getURL().toString());
                }
                else if (e.getEventType() == HyperlinkEvent.EventType.EXITED)
                {
                    StatusDisplayer.getDefault().setStatusText("");
                }
                else if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED)
                {
                    try {
                        HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
                        if (displayer != null) {
                            displayer.showURL(e.getURL());
                        }
                    } catch (Exception ex) {}
                }
            }
        });

        if (!IReportManager.getInstance().isNoNetwork())
        {
            new Thread(new Runnable() {

                public void run() {
                    try {

                        jEditorPane1.setPage(url);
                    } catch (Throwable ex) {
                        SwingUtilities.invokeLater(new Runnable() {

                            public void run() {
                                jEditorPane1.setText("<html><body><br><br><font face=\"Arial\" size=\"-1\" color=\"888888\">" + I18n.getString("error.loading.web.resource") + "</font><br><br></body></html>");
                            }
                        });
                    }
                }
            }).start();
        }

        jEditorPane1.getDocument().addDocumentListener(new DocumentListener() {

            public void insertUpdate(DocumentEvent e) {
                updateUI();
            }

            public void removeUpdate(DocumentEvent e) {
                updateUI();
            }

            public void changedUpdate(DocumentEvent e) {
                updateUI();
            }
        });

    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPopupMenu1 = new javax.swing.JPopupMenu();
        jMenuItem1 = new javax.swing.JMenuItem();
        jEditorPane1 = new javax.swing.JEditorPane();

        jMenuItem1.setText(org.openide.util.NbBundle.getMessage(WebContentPanel.class, "WebContentPanel.jMenuItem1.text")); // NOI18N
        jMenuItem1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem1ActionPerformed(evt);
            }
        });
        jPopupMenu1.add(jMenuItem1);

        setMinimumSize(new java.awt.Dimension(300, 250));
        setLayout(new java.awt.BorderLayout());

        jEditorPane1.setBorder(null);
        jEditorPane1.setEditable(false);
        jEditorPane1.setComponentPopupMenu(jPopupMenu1);
        add(jEditorPane1, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents

    private void jMenuItem1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem1ActionPerformed
        new Thread(new Runnable() {

            public void run() {
                try {
                    jEditorPane1.setPage(getContentUrl());
                } catch (Throwable ex) {
                    SwingUtilities.invokeLater(new Runnable() {

                        public void run() {
                            jEditorPane1.setText("<html><body><br><br><font face=\"Arial\" size=\"-1\" color=\"888888\">" + I18n.getString("error.loading.web.resource") + "</font><br><br></body></html>");
                        }
                    });
                }
            }
        }).start();
    }//GEN-LAST:event_jMenuItem1ActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JEditorPane jEditorPane1;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JPopupMenu jPopupMenu1;
    // End of variables declaration//GEN-END:variables

    /**
     * @return the contentUrl
     */
    public String getContentUrl() {
        return contentUrl;
    }

    /**
     * @param contentUrl the contentUrl to set
     */
    public void setContentUrl(String contentUrl) {
        this.contentUrl = contentUrl;
    }

}
