/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.base;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseObjectFactory;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;

public class JRBaseHyperlink
implements JRHyperlink,
Serializable {
    private static final long serialVersionUID = 10200L;
    protected String linkType;
    protected String linkTarget;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    protected JRExpression hyperlinkTooltipExpression;
    protected JRHyperlinkParameter[] hyperlinkParameters;
    private byte hyperlinkTarget;

    public JRBaseHyperlink() {
    }

    protected JRBaseHyperlink(JRHyperlink link, JRBaseObjectFactory factory) {
        factory.put(link, this);
        this.linkType = link.getLinkType();
        this.linkTarget = link.getLinkTarget();
        this.hyperlinkReferenceExpression = factory.getExpression(link.getHyperlinkReferenceExpression());
        this.hyperlinkAnchorExpression = factory.getExpression(link.getHyperlinkAnchorExpression());
        this.hyperlinkPageExpression = factory.getExpression(link.getHyperlinkPageExpression());
        this.hyperlinkTooltipExpression = factory.getExpression(link.getHyperlinkTooltipExpression());
        this.hyperlinkParameters = JRBaseHyperlink.copyHyperlinkParameters(link, factory);
    }

    public static JRHyperlinkParameter[] copyHyperlinkParameters(JRHyperlink link, JRBaseObjectFactory factory) {
        JRHyperlinkParameter[] linkParameters = link.getHyperlinkParameters();
        JRHyperlinkParameter[] parameters = null;
        if (linkParameters != null && linkParameters.length > 0) {
            parameters = new JRHyperlinkParameter[linkParameters.length];
            for (int i = 0; i < linkParameters.length; ++i) {
                JRHyperlinkParameter parameter = linkParameters[i];
                parameters[i] = factory.getHyperlinkParameter(parameter);
            }
        }
        return parameters;
    }

    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    public JRHyperlinkParameter[] getHyperlinkParameters() {
        return this.hyperlinkParameters;
    }

    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this);
    }

    public String getLinkType() {
        return this.linkType;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public Object clone() {
        JRBaseHyperlink clone = null;
        try {
            clone = (JRBaseHyperlink)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new JRRuntimeException(e);
        }
        if (this.hyperlinkParameters != null) {
            clone.hyperlinkParameters = new JRHyperlinkParameter[this.hyperlinkParameters.length];
            for (int i = 0; i < this.hyperlinkParameters.length; ++i) {
                clone.hyperlinkParameters[i] = (JRHyperlinkParameter)this.hyperlinkParameters[i].clone();
            }
        }
        if (this.hyperlinkReferenceExpression != null) {
            clone.hyperlinkReferenceExpression = (JRExpression)this.hyperlinkReferenceExpression.clone();
        }
        if (this.hyperlinkAnchorExpression != null) {
            clone.hyperlinkAnchorExpression = (JRExpression)this.hyperlinkAnchorExpression.clone();
        }
        if (this.hyperlinkPageExpression != null) {
            clone.hyperlinkPageExpression = (JRExpression)this.hyperlinkPageExpression.clone();
        }
        if (this.hyperlinkTooltipExpression != null) {
            clone.hyperlinkTooltipExpression = (JRExpression)this.hyperlinkTooltipExpression.clone();
        }
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(this.hyperlinkTarget));
        }
    }
}

