/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.config;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.util.Assert;

public class ObjectFactoryCreatingFactoryBean
extends AbstractFactoryBean
implements BeanFactoryAware {
    private String targetBeanName;
    private BeanFactory beanFactory;

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected Object createInstance() {
        return new ObjectFactory(){

            public Object getObject() throws BeansException {
                return ObjectFactoryCreatingFactoryBean.this.beanFactory.getBean(ObjectFactoryCreatingFactoryBean.this.targetBeanName);
            }
        };
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasText(this.targetBeanName, "targetBeanName is required");
        super.afterPropertiesSet();
    }

    public Class getObjectType() {
        return ObjectFactory.class;
    }
}

