/*
 * Decompiled with CFR 0.152.
 */
package org.krysalis.barcode4j.cli;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.logger.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.krysalis.barcode4j.BarcodeException;
import org.krysalis.barcode4j.BarcodeGenerator;
import org.krysalis.barcode4j.BarcodeUtil;
import org.krysalis.barcode4j.cli.AdvancedConsoleLogger;
import org.krysalis.barcode4j.cli.DefaultExitHandler;
import org.krysalis.barcode4j.cli.ExitHandler;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.output.bitmap.BitmapEncoderRegistry;
import org.krysalis.barcode4j.output.eps.EPSCanvasProvider;
import org.krysalis.barcode4j.output.svg.SVGCanvasProvider;
import org.krysalis.barcode4j.tools.MimeTypes;

public class Main {
    private static final String[] APP_HEADER = new String[]{"Barcode4J command-line application, Version " + Main.getVersion(), ""};
    public static PrintStream stdout = System.out;
    public static PrintStream stderr = System.err;
    private static ExitHandler exitHandler = new DefaultExitHandler();
    private Options options;
    private boolean headerPrinted = false;
    private Logger log;
    static /* synthetic */ Class class$org$krysalis$barcode4j$cli$Main;

    public static void main(String[] args) {
        Main app = new Main();
        app.handleCommandLine(args);
    }

    public static void setExitHandler(ExitHandler handler) {
        exitHandler = handler;
    }

    public void handleCommandLine(String[] args) {
        String[] msg;
        CommandLine cl;
        try {
            PosixParser clp = new PosixParser();
            cl = clp.parse(this.getOptions(), args);
            msg = cl.getArgs();
            if (msg.length == 0) {
                throw new ParseException("No message");
            }
            if (msg.length > 1) {
                throw new ParseException("Too many parameters: " + msg.length);
            }
        }
        catch (MissingOptionException moe) {
            this.printHelp(new PrintWriter(stdout));
            exitHandler.failureExit(this, "Bad command line. Missing option: " + moe.getMessage(), null, -2);
            return;
        }
        catch (ParseException pe) {
            this.printHelp(new PrintWriter(stdout));
            exitHandler.failureExit(this, "Bad command line: " + pe.getMessage(), null, -2);
            return;
        }
        try {
            OutputStream out;
            if (!cl.hasOption("o")) {
                this.log = new AdvancedConsoleLogger(3, false, stderr, stderr);
                this.printAppHeader();
                out = stdout;
            } else {
                int logLevel = 1;
                if (cl.hasOption('v')) {
                    logLevel = 0;
                }
                this.log = new AdvancedConsoleLogger(logLevel, false, stdout, stderr);
                this.printAppHeader();
                File outFile = new File(cl.getOptionValue("o"));
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Output to: " + outFile.getCanonicalPath());
                }
                out = new FileOutputStream(outFile);
            }
            this.log.debug("Message: " + msg[0]);
            String format = MimeTypes.expandFormat(cl.getOptionValue("f", "image/svg+xml"));
            int orientation = 0;
            this.log.info("Generating " + format + "...");
            BarcodeUtil util = BarcodeUtil.getInstance();
            BarcodeGenerator gen = util.createBarcodeGenerator(this.getConfiguration(cl));
            if ("image/svg+xml".equals(format)) {
                SVGCanvasProvider svg = new SVGCanvasProvider(false, orientation);
                gen.generateBarcode(svg, msg[0]);
                try {
                    TransformerFactory factory = TransformerFactory.newInstance();
                    Transformer trans = factory.newTransformer();
                    DOMSource src = new DOMSource(svg.getDOMFragment());
                    StreamResult res = new StreamResult(out);
                    trans.transform(src, res);
                }
                catch (TransformerException te) {
                    exitHandler.failureExit(this, "XML/XSLT library error", te, -6);
                }
            } else if ("image/x-eps".equals(format)) {
                EPSCanvasProvider eps = new EPSCanvasProvider(out, orientation);
                gen.generateBarcode(eps, msg[0]);
                eps.finish();
            } else {
                BitmapCanvasProvider bitmap;
                int dpi = Integer.parseInt(cl.getOptionValue('d', "300"));
                this.log.debug("Resolution: " + dpi + "dpi");
                if (cl.hasOption("bw")) {
                    this.log.debug("Black/white image (1-bit)");
                    bitmap = new BitmapCanvasProvider(out, format, dpi, 12, false, orientation);
                } else {
                    this.log.debug("Grayscale image (8-bit) with anti-aliasing");
                    bitmap = new BitmapCanvasProvider(out, format, dpi, 10, true, orientation);
                }
                gen.generateBarcode(bitmap, msg[0]);
                bitmap.finish();
            }
            out.close();
            this.log.info("done.");
            exitHandler.successfulExit(this);
        }
        catch (IOException ioe) {
            exitHandler.failureExit(this, "Error writing output file: " + ioe.getMessage(), null, -5);
        }
        catch (ConfigurationException ce) {
            exitHandler.failureExit(this, "Configuration problem: " + ce.getMessage(), ce, -6);
        }
        catch (BarcodeException be) {
            exitHandler.failureExit(this, "Error generating the barcode", be, -3);
        }
    }

    private Options getOptions() {
        if (this.options == null) {
            this.options = new Options();
            OptionBuilder.withLongOpt((String)"verbose");
            OptionBuilder.withDescription((String)"enable debug output");
            this.options.addOption(OptionBuilder.create((char)'v'));
            OptionBuilder.withLongOpt((String)"output");
            OptionBuilder.withArgName((String)"file");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the output filename");
            this.options.addOption(OptionBuilder.create((char)'o'));
            OptionGroup group = new OptionGroup();
            group.setRequired(true);
            OptionBuilder.withArgName((String)"file");
            OptionBuilder.withLongOpt((String)"config");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the config file");
            group.addOption(OptionBuilder.create((char)'c'));
            OptionBuilder.withArgName((String)"name");
            OptionBuilder.withLongOpt((String)"symbol");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the barcode symbology to select (default settings, use -c if you want to customize)");
            group.addOption(OptionBuilder.create((char)'s'));
            this.options.addOptionGroup(group);
            OptionBuilder.withArgName((String)"format");
            OptionBuilder.withLongOpt((String)"format");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"the output format: MIME type or file extension\nDefault: image/svg+xml (SVG)");
            this.options.addOption(OptionBuilder.create((char)'f'));
            OptionBuilder.withArgName((String)"integer");
            OptionBuilder.withLongOpt((String)"dpi");
            OptionBuilder.hasArg();
            OptionBuilder.withDescription((String)"(for bitmaps) the image resolution in dpi\nDefault: 300");
            this.options.addOption(OptionBuilder.create((char)'d'));
            OptionBuilder.withLongOpt((String)"bw");
            OptionBuilder.withDescription((String)"(for bitmaps) create monochrome (1-bit) image instead of grayscale (8-bit)");
            this.options.addOption(OptionBuilder.create());
        }
        return this.options;
    }

    private Configuration getConfiguration(CommandLine cl) {
        if (cl.hasOption("s")) {
            String sym = cl.getOptionValue("s");
            DefaultConfiguration cfg = new DefaultConfiguration("cfg");
            DefaultConfiguration child = new DefaultConfiguration(sym);
            cfg.addChild((Configuration)child);
            return cfg;
        }
        if (cl.hasOption("c")) {
            try {
                String filename = cl.getOptionValue("c");
                File cfgFile = new File(filename);
                if (!cfgFile.exists() || !cfgFile.isFile()) {
                    throw new FileNotFoundException("Config file not found: " + cfgFile);
                }
                this.log.info("Using configuration: " + cfgFile);
                DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
                return builder.buildFromFile(cfgFile);
            }
            catch (Exception e) {
                exitHandler.failureExit(this, "Error reading configuration file: " + e.getMessage(), null, -3);
            }
        }
        return new DefaultConfiguration("cfg");
    }

    public static String getVersion() {
        String version = null;
        Package jarinfo = (class$org$krysalis$barcode4j$cli$Main == null ? (class$org$krysalis$barcode4j$cli$Main = Main.class$("org.krysalis.barcode4j.cli.Main")) : class$org$krysalis$barcode4j$cli$Main).getPackage();
        if (jarinfo != null) {
            version = jarinfo.getImplementationVersion();
        }
        if (version == null) {
            version = "DEV";
        }
        return version;
    }

    public void printAppHeader() {
        if (!this.headerPrinted) {
            if (this.log != null) {
                for (int i = 0; i < APP_HEADER.length; ++i) {
                    this.log.info(APP_HEADER[i]);
                }
            } else {
                for (int i = 0; i < APP_HEADER.length; ++i) {
                    stdout.println(APP_HEADER[i]);
                }
            }
            this.headerPrinted = true;
        }
    }

    private void printHelp(PrintWriter writer) {
        this.printAppHeader();
        HashSet<String> knownMimes = new HashSet<String>();
        knownMimes.add(null);
        knownMimes.add("");
        knownMimes.add("image/x-png");
        knownMimes.add("image/png");
        knownMimes.add("image/jpeg");
        knownMimes.add("image/tiff");
        knownMimes.add("image/gif");
        Set additionalMimes = BitmapEncoderRegistry.getSupportedMIMETypes();
        additionalMimes.removeAll(knownMimes);
        HelpFormatter help = new HelpFormatter();
        String unavailable = " (unavailable)";
        help.printHelp(writer, 74, "java -jar barcode4j.jar [-v] [[-s <symbology>]|[-c <cfg-file>]] [-f <format>] [-d <dpi>] [-bw] [-o <file>] <message>", null, this.getOptions(), 1, 3, "Valid output formats:\nSVG: image/svg+xml, svg\nEPS: image/x-eps, eps\nPNG: image/x-png, png" + (BitmapEncoderRegistry.supports("image/x-png") ? "" : " (unavailable)") + "\nTIFF: " + "image/tiff" + ", tiff, tif" + (BitmapEncoderRegistry.supports("image/tiff") ? "" : " (unavailable)") + "\nJPEG: " + "image/jpeg" + ", jpeg, jpg" + (BitmapEncoderRegistry.supports("image/jpeg") ? "" : " (unavailable)") + "\nGIF: " + "image/gif" + ", gif" + (BitmapEncoderRegistry.supports("image/gif") ? "" : " (unavailable)") + (additionalMimes.size() > 0 ? "\nAdditional supported formats:\n" + additionalMimes : "") + "\n" + "\nIf -o is omitted the output is written to stdout.");
        writer.flush();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

