/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import mondrian.olap.MondrianProperties;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class Ssas2005CompatibilityTest
extends FoodMartTestCase {
    private static final boolean MEMBER_NAMING_IMPL = false;
    public static final boolean ATTR_HIER_IMPL = false;
    public static final boolean AXIS_IMPL = false;
    public static final boolean KEY_IMPL = false;
    public static final boolean ALLOW_HIERS_ON_INDEP_AXES = false;
    private static final boolean IMPLEMENTED = false;

    public Ssas2005CompatibilityTest(String name) {
        super(name);
    }

    private void runQ(String s) {
        Result result = this.getTestContext().executeQuery(s);
        Util.discard((Object)TestContext.toString(result));
    }

    public TestContext getTestContext() {
        return TestContext.create("<Schema name=\"FoodMart\">\n<Cube name=\"Warehouse and Sales\" defaultMeasure=\"Unit Sales\">\n  <Table name=\"sales_fact_1997\" />\n  <Dimension name=\"Store\" foreignKey=\"store_id\">\n    <Hierarchy name=\"Stores\" hasAll=\"true\" primaryKey=\"store_id\">\n      <Table name=\"store\"/>\n      <Level name=\"Store Country\" column=\"store_country\" uniqueMembers=\"true\"/>\n      <Level name=\"Store State\" column=\"store_state\" uniqueMembers=\"true\"/>\n      <Level name=\"Store City\" column=\"store_city\" uniqueMembers=\"false\"/>\n      <Level name=\"Store Name\" column=\"store_name\" uniqueMembers=\"true\">\n        <Property name=\"Store Type\" column=\"store_type\"/>\n        <Property name=\"Store Sqft\" column=\"store_sqft\" type=\"Numeric\"/>\n      </Level>\n    </Hierarchy>\n  </Dimension>\n  <Dimension name=\"Time\" type=\"TimeDimension\" foreignKey=\"time_id\">\n    <Hierarchy hasAll=\"true\" name=\"Time By Week\" primaryKey=\"time_id\" >\n      <Table name=\"time_by_day\"/>\n      <Level name=\"Year2\" column=\"the_year\" type=\"Numeric\" uniqueMembers=\"true\"\n          levelType=\"TimeYears\"/>\n      <Level name=\"Week\" column=\"week_of_year\" type=\"Numeric\" uniqueMembers=\"false\"\n          levelType=\"TimeWeeks\"/>\n      <Level name=\"Date2\" column=\"day_of_month\" uniqueMembers=\"false\" type=\"Numeric\"\n          levelType=\"TimeDays\"/>\n    </Hierarchy>\n    <Hierarchy name=\"Time2\" hasAll=\"false\" primaryKey=\"time_id\">\n      <Table name=\"time_by_day\"/>\n      <Level name=\"Year2\" column=\"the_year\" type=\"Numeric\" uniqueMembers=\"true\"\n          levelType=\"TimeYears\"/>\n      <Level name=\"Quarter\" column=\"quarter\" uniqueMembers=\"false\"\n          levelType=\"TimeQuarters\"/>\n      <Level name=\"Month\" column=\"month_of_year\" uniqueMembers=\"false\" type=\"Numeric\"\n          levelType=\"TimeMonths\"/>\n    </Hierarchy>\n  </Dimension>\n  <Dimension name=\"Product\" foreignKey=\"product_id\">\n    <Hierarchy name=\"Products\" hasAll=\"true\" primaryKey=\"product_id\" primaryKeyTable=\"product\">\n      <Join leftKey=\"product_class_id\" rightKey=\"product_class_id\">\n        <Table name=\"product\"/>\n        <Table name=\"product_class\"/>\n      </Join>\n      <Level name=\"Product Family\" table=\"product_class\" column=\"product_family\"\n          uniqueMembers=\"true\"/>\n      <Level name=\"Product Department\" table=\"product_class\" column=\"product_department\"\n          uniqueMembers=\"false\"/>\n      <Level name=\"Product Category\" table=\"product_class\" column=\"product_category\"\n          uniqueMembers=\"false\"/>\n      <Level name=\"Product Subcategory\" table=\"product_class\" column=\"product_subcategory\"\n          uniqueMembers=\"false\"/>\n      <Level name=\"Brand Name\" table=\"product\" column=\"brand_name\" uniqueMembers=\"false\"/>\n      <Level name=\"Product Name\" table=\"product\" column=\"product_name\"\n          uniqueMembers=\"true\"/>\n    </Hierarchy>\n    <Hierarchy name=\"Product Name\" hasAll=\"true\" primaryKey=\"product_id\" primaryKeyTable=\"product\">\n      <Join leftKey=\"product_class_id\" rightKey=\"product_class_id\">\n        <Table name=\"product\"/>\n        <Table name=\"product_class\"/>\n      </Join>\n      <Level name=\"Product Name\" table=\"product\" column=\"product_name\"\n          uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n  <Dimension name=\"Promotion\" foreignKey=\"promotion_id\">\n    <Hierarchy hasAll=\"true\" allMemberName=\"All Promotions\" primaryKey=\"promotion_id\" defaultMember=\"[All Promotions]\">\n      <Table name=\"promotion\"/>\n      <Level name=\"Promotion Name\" column=\"promotion_name\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>\n  <Dimension name=\"Currency\" foreignKey=\"promotion_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"promotion_id\">\n      <Table name=\"promotion\"/>\n      <Level name=\"Currency\" column=\"media_type\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>  <Dimension name=\"Customer\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"true\" allMemberName=\"All Customers\" primaryKey=\"customer_id\">\n      <Table name=\"customer\"/>\n      <Level name=\"Country\" column=\"country\" uniqueMembers=\"true\"/>\n      <Level name=\"State Province\" column=\"state_province\" uniqueMembers=\"true\"/>\n      <Level name=\"City\" column=\"city\" uniqueMembers=\"false\"/>\n      <Level name=\"Name\" column=\"customer_id\" type=\"Numeric\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>  <Measure name=\"Unit Sales\" column=\"unit_sales\" aggregator=\"sum\"\n      formatString=\"Standard\"/>\n</Cube>\n</Schema>").withCube("Warehouse and Sales");
    }

    public void testUniqueName() {
    }

    public void testDimensionDotHierarchyAmbiguous() {
        if (MondrianProperties.instance().SsasCompatibleNaming.get()) {
            this.getTestContext().assertExprThrows("[Currency].[Currency].Ordinal", "No function matches signature '<Hierarchy>.Ordinal'");
            this.getTestContext().assertExprReturns("[Currency].[Currency].Levels(0).Name", "(All)");
            this.getTestContext().assertExprReturns("[Currency].[Currency].Members.Count", "15");
            this.getTestContext().assertExprReturns("[Currency].[Currency].[Currency].Members.Count", "14");
        } else {
            this.getTestContext().assertExprReturns("[Currency].[Currency].Ordinal", "1");
            this.getTestContext().assertExprReturns("[Currency].[Currency].Levels(0).Name", "(All)");
            this.getTestContext().assertExprReturns("[Currency].[Currency].UniqueName", "[Currency].[Currency]");
            this.getTestContext().assertExprReturns("[Currency].[Currency].Members.Count", "14");
            this.getTestContext().assertExprThrows("[Currency].[Currency].[Currency].Members.Count", "MDX object '[Currency].[Currency].[Currency]' not found in cube 'Warehouse and Sales'");
        }
    }

    public void testHierarchyLevelsFunction() {
    }

    public void testDimensionDotHierarchyDotLevelDotMembers() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        this.runQ("select [Time].[Time by Week].[Week].MEMBERS on 0\nfrom [Warehouse and Sales]");
    }

    public void testDimensionDotHierarchyDotLevel() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        this.assertQueryReturns("select [Store].[Stores].[Store State].MEMBERS on 0\nfrom [Warehouse and Sales]", Ssas2005CompatibilityTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[Stores].[All Storess].[Canada].[BC]}\n{[Store].[Stores].[All Storess].[Mexico].[DF]}\n{[Store].[Stores].[All Storess].[Mexico].[Guerrero]}\n{[Store].[Stores].[All Storess].[Mexico].[Jalisco]}\n{[Store].[Stores].[All Storess].[Mexico].[Veracruz]}\n{[Store].[Stores].[All Storess].[Mexico].[Yucatan]}\n{[Store].[Stores].[All Storess].[Mexico].[Zacatecas]}\n{[Store].[Stores].[All Storess].[USA].[CA]}\n{[Store].[Stores].[All Storess].[USA].[OR]}\n{[Store].[Stores].[All Storess].[USA].[WA]}\nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: 74,748\nRow #0: 67,659\nRow #0: 124,366\n"));
    }

    public void testNamingDimensionDotLevel() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        this.runQ("select [Time].[Week].MEMBERS on 0\nfrom [Warehouse and Sales]");
        this.assertQueryReturns("with member [Measures].[Foo] as ' [Time].[Year2].UniqueName '\nselect [Measures].[Foo] on 0\nfrom [Warehouse and Sales]", Ssas2005CompatibilityTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: [Time].[Time By Week].[Year2]\n"));
    }

    public void testNamingDimensionDotLevel2() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        this.runQ("select [Time].[Date2].MEMBERS on 0 from [Warehouse and Sales]");
        this.runQ("with member [Measures].[Foo] as ' [Time].[Date2].UniqueName '\nselect [Measures].[Foo] on 0\nfrom [Warehouse and Sales]");
    }

    public void testNamingDimensionDotLevelNotUnique() {
    }

    public void testDimensionMembersOnSingleHierarchyDimension() {
        this.assertQueryReturns("select [Currency].Members on 0\nfrom [Warehouse and Sales]", Ssas2005CompatibilityTest.fold("Axis #0:\n{}\nAxis #1:\n{[Currency].[All Currencys]}\n{[Currency].[All Currencys].[Bulk Mail]}\n{[Currency].[All Currencys].[Cash Register Handout]}\n{[Currency].[All Currencys].[Daily Paper]}\n{[Currency].[All Currencys].[Daily Paper, Radio]}\n{[Currency].[All Currencys].[Daily Paper, Radio, TV]}\n{[Currency].[All Currencys].[In-Store Coupon]}\n{[Currency].[All Currencys].[No Media]}\n{[Currency].[All Currencys].[Product Attachment]}\n{[Currency].[All Currencys].[Radio]}\n{[Currency].[All Currencys].[Street Handout]}\n{[Currency].[All Currencys].[Sunday Paper]}\n{[Currency].[All Currencys].[Sunday Paper, Radio]}\n{[Currency].[All Currencys].[Sunday Paper, Radio, TV]}\n{[Currency].[All Currencys].[TV]}\nRow #0: 266,773\nRow #0: 4,320\nRow #0: 6,697\nRow #0: 7,738\nRow #0: 6,891\nRow #0: 9,513\nRow #0: 3,798\nRow #0: 195,448\nRow #0: 7,544\nRow #0: 2,454\nRow #0: 5,753\nRow #0: 4,339\nRow #0: 5,945\nRow #0: 2,726\nRow #0: 3,607\n"));
    }

    public void testMultipleHierarchyRequiresQualification() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        this.assertThrows("select [Product].Members on 0\nfrom [Warehouse and Sales]", "The 'Product' dimension contains more than one hierarchy, therefore the hierarchy must be explicitly specified.");
    }

    public void testUnqualifiedHierarchy() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        this.runQ("select [Products].Members on 0\nfrom [Warehouse and Sales]");
        this.runQ("select {[Products]} on 0\nfrom [Warehouse and Sales]");
        this.runQ("select [Measures].[Unit Sales] on 0,\n  [Products].[Food] on 1\nfrom [Warehouse and Sales]");
    }

    public void testAxesOutOfOrder() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        this.assertQueryReturns("select [Measures].[Unit Sales] on 1,\n[Products].Children on 0\nfrom [Warehouse and Sales]", Ssas2005CompatibilityTest.fold("Axis #0:\n{}\nAxis #1:\n{[Product].[Products].[All Productss].[Drink]}\n{[Product].[Products].[All Productss].[Food]}\n{[Product].[Products].[All Productss].[Non-Consumable]}\nAxis #2:\n{[Measures].[Unit Sales]}\nRow #0: 24,597\nRow #0: 191,940\nRow #0: 50,236\n"));
    }

    public void testDimensionMembersRequiresHierarchyQualification() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        this.assertThrows("select [Time].Members on 0\nfrom [Warehouse and Sales]", "The 'Time' dimension contains more than one hierarchy, therefore the hierarchy must be explicitly specified.");
    }

    public void testDimensionMemberRequiresHierarchyQualification() {
        String[] exprs;
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        for (String s : exprs = new String[]{"[Product].CurrentMember", "[Product].DefaultMember", "[Product].AllMembers", "Dimensions(3).CurrentMember", "Dimensions(3).DefaultMember", "Dimensions(3).AllMembers"}) {
            this.assertThrows("select " + s + " on 0\n" + "from [Warehouse and Sales]", "The 'Product' dimension contains more than one hierarchy, therefore the hierarchy must be explicitly specified.");
        }
    }

    public void testImplicitCurrentMemberRequiresHierarchyQualification() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        this.assertThrows("select Ascendants([Product]) on 0\nfrom [Warehouse and Sales]", "The 'Product' dimension contains more than one hierarchy, therefore the hierarchy must be explicitly specified.");
        this.assertQueryReturns("select Ascendants([Store]) on 0\nfrom [Warehouse and Sales]", Ssas2005CompatibilityTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[Stores].[All Storess]}\nRow #0: 266,773\n"));
    }

    public void testUnqualifiedHierarchyCurrentMember() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        this.runQ("select [Products].CurrentMember on 0\nfrom [Warehouse and Sales]");
    }

    public void testCannotDistinguishMdxFromSql() {
        this.assertThrows("select [Time].Members\nfrom [Warehouse and Sales]", "Syntax error at line 2, column 2, token 'FROM'");
    }

    public void testNamingDimensionAttr() {
    }

    public void testNamingDimensionAttrVsLevel() {
    }

    public void testAttrHierarchyMemberParent() {
    }

    public void testAttrHierarchyMemberChildren() {
    }

    public void testAttrHierarchyAllMemberChildren() {
    }

    public void testAttrHierarchyMemberLevel() {
    }

    public void testAttrHierarchyUniqueName() {
    }

    public void testMemberAddressedByLevelAndKey() {
    }

    public void testMemberAddressedByCompoundKey() {
    }

    public void testMemberAddressedByPartialCompoundKey() {
    }

    public void testMemberAddressedByNonUniqueName() {
    }

    public void testMemberAddressedByLevelAndCompoundKey() {
    }

    public void testMemberAddressedByLevelAndName() {
    }

    public void testFoo31() {
        this.runQ("select Measures on 0,[Product].[Product Department].Members on 1\nfrom [Warehouse and Sales]");
    }

    public void testFoo32() {
    }

    public void testNamingAttrVsLevel() {
    }

    public void testUnqualifiedLevel() {
    }

    public void testDimensionAsScalarExpression() {
    }

    public void testDimensionWithMultipleHierarchiesDotParent() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        this.assertThrows("with member [Measures].[Foo] as ' [Product].Parent.UniqueName '\nselect [Measures].[Foo] on 0\nfrom [Warehouse and Sales]\nwhere [Product].[Drink].[Beverages]", "The 'Product' dimension contains more than one hierarchy, therefore the hierarchy must be explicitly specified.");
    }

    public void testDimensionDotHierarchyInBrackets() {
        this.runQ("select {[Time.Time By Week].Members} on 0\nfrom [Warehouse and Sales]");
    }

    public void testDimensionDotHierarchySameNameInBrackets() {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "<Dimension name=\"Store Type 2\" foreignKey=\"store_id\"> <Hierarchy name=\"Store Type 2\" hasAll=\"true\" primaryKey=\"store_id\"> <Table name=\"store\"/> <Level name=\"Store Type\" column=\"store_type\" uniqueMembers=\"true\"/> </Hierarchy></Dimension>", null);
        testContext.assertQueryReturns("select [Store Type 2.Store Type 2].[Store Type].members ON columns from [Sales] where [Time].[1997]", Ssas2005CompatibilityTest.fold("Axis #0:\n{[Time].[1997]}\nAxis #1:\n{[Store Type 2].[All Store Type 2s].[Deluxe Supermarket]}\n{[Store Type 2].[All Store Type 2s].[Gourmet Supermarket]}\n{[Store Type 2].[All Store Type 2s].[HeadQuarters]}\n{[Store Type 2].[All Store Type 2s].[Mid-Size Grocery]}\n{[Store Type 2].[All Store Type 2s].[Small Grocery]}\n{[Store Type 2].[All Store Type 2s].[Supermarket]}\nRow #0: 76,837\nRow #0: 21,333\nRow #0: \nRow #0: 11,491\nRow #0: 6,557\nRow #0: 150,555\n"));
    }

    public void testDimensionDotLevelDotHierarchyInBrackets() {
        this.assertThrows("select [Time.Time2.Quarter].Members on 0\nfrom [Warehouse and Sales]", "MDX object '[Time.Time2.Quarter]' not found in cube 'Warehouse and Sales'");
    }

    public void testDimensionDotInvalidHierarchyInBrackets() {
        this.assertThrows("select {[Time.Time By Week55].Members} on 0\nfrom [Warehouse and Sales]", "MDX object '[Time.Time By Week55]' not found in cube 'Warehouse and Sales'");
    }

    public void testDimensionDotDimensionInBrackets() {
        this.assertThrows("select {[Time.Time].Members} on 0\nfrom [Warehouse and Sales]", "MDX object '[Time.Time]' not found in cube 'Warehouse and Sales'");
    }

    public void testDimensionDotHierarchyDotNonExistentLevel() {
    }

    public void testDimensionDotHierarchyDotLevelMembers() {
    }

    public void testDupHierarchyOnAxes() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        this.assertThrows("select {[Products]} on 0,\n  {[Products]} on 1\nfrom [Warehouse and Sales]", "Dimension '[Product]' appears in more than one independent axis.");
    }

    public void testDimensionOnAxis() {
    }

    public void testDimensionDotHierarchyOnAxis() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        this.runQ("select [Product].[Products] on 0,\n[Customer].[Customer] on 1\nfrom [Warehouse and Sales]");
    }

    public void testHierarchiesFromSameDimensionOnAxes() {
    }

    public void testDifferentHierarchiesFromSameDimensionOnAxes() {
    }

    public void testDifferentHierarchiesFromSameDimensionInCrossjoin() {
    }

    public void testHierarchyUsedTwiceInCrossjoin() {
    }

    public void testAttributeHierarchyUsedTwiceInCrossjoin() {
    }

    public void testFoo50() {
    }

    public void testQuoteInStringInQuotedFormula() {
        this.assertQueryReturns("with member [Measures].[Foo] as ' len(\"can''t\") '\nselect [Measures].[Foo] on 0\nfrom [Warehouse and Sales]", Ssas2005CompatibilityTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: 5\n"));
    }

    public void testQuoteInStringInUnquotedFormula() {
        this.assertQueryReturns("with member [Measures].[Foo] as len(\"can''t\")\nselect [Measures].[Foo] on 0\nfrom [Warehouse and Sales]", Ssas2005CompatibilityTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Foo]}\nRow #0: 6\n"));
    }

    public void testMemberIdentifiedByDimensionAndKey() {
    }

    public void testDimensionHierarchyKey() {
    }

    public void testCompoundKey() {
    }

    public void testCompoundKeySyntaxError() {
    }

    public void testCompoundKeyString() {
    }

    public void testFoo56() {
    }

    public void testKeyNonExistent() {
    }

    public void testAxesLabelsOutOfSequence() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        this.assertQueryReturns("select [Measures].[Unit Sales] on 1,\n[Product].[Products] on 0\nfrom [Warehouse and Sales]", Ssas2005CompatibilityTest.fold("Axis #0:\n{}\nAxis #1:\n{[Product].[Products].[All Productss]}\nAxis #2:\n{[Measures].[Unit Sales]}\nRow #0: 266,773\n"));
    }

    public void testAxisLabelsNotContiguousFails() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
        this.assertThrows("select [Measures].[Unit Sales] on 1,\n[Product].[Products].Children on 2\nfrom [Warehouse and Sales]", "Axis numbers specified in a query must be sequentially specified, and cannot contain gaps. Axis 0 (COLUMNS) is missing.");
    }

    public void testLotsOfAxes() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
    }

    public void testOnAxesFails() {
        this.assertThrows("select [Measures].[Unit Sales] on axes(0)\nfrom [Warehouse and Sales]", "Syntax error at line 1, column 35, token 'axes'");
    }

    public void testOnExpression() {
        this.assertThrows("select [Measures].[Unit Sales] on 0 + 1\nfrom [Warehouse and Sales]", "Syntax error at line 1, column 37, token '+'");
    }

    public void testOnFractionFails() {
        this.assertThrows("select [Measures].[Unit Sales] on 0.4\nfrom [Warehouse and Sales]", "Invalid axis specification. The axis number must be non-negative integer, but it was 0.4.");
    }

    public void testAxisFunction() {
    }

    public void testAxisAppliedToExpr() {
    }

    public void testAxisFunctionReferencesPreviousAxis() {
    }

    public void testAxisFunctionReferencesSameAxisFails() {
    }

    public void testAxisFunctionReferencesSameAxisZeroFails() {
    }

    public void testAxisFunctionReferencesLaterAxis() {
    }

    public void testAxisFunctionReferencesSameAxisInlineFails() {
    }

    public void testCrossjoinMember() {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            return;
        }
    }

    public static class NewBehaviorTest
    extends Ssas2005CompatibilityTest {
        public NewBehaviorTest(String name) {
            super(name);
        }

        protected void setUp() throws Exception {
            this.propSaver.set(MondrianProperties.instance().SsasCompatibleNaming, true);
        }
    }

    public static class OldBehaviorTest
    extends Ssas2005CompatibilityTest {
        public OldBehaviorTest(String name) {
            super(name);
        }

        protected void setUp() throws Exception {
            this.propSaver.set(MondrianProperties.instance().SsasCompatibleNaming, false);
        }
    }
}

