/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.AggregateFunDef;
import mondrian.olap.fun.CrossJoinFunDef;
import mondrian.rolap.BatchTestCase;
import mondrian.rolap.RolapCube;
import mondrian.spi.Dialect;
import mondrian.test.SqlPattern;
import mondrian.test.TestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationOnDistinctCountMeasuresTest
extends BatchTestCase {
    private final MondrianProperties props = MondrianProperties.instance();
    private SchemaReader salesCubeSchemaReader = null;
    private SchemaReader schemaReader = null;
    private RolapCube salesCube;

    protected void setUp() throws Exception {
        this.schemaReader = this.getTestContext().getConnection().getSchemaReader();
        this.salesCube = (RolapCube)this.cubeByName(this.getTestContext().getConnection(), "Sales");
        this.salesCubeSchemaReader = this.salesCube.getSchemaReader(this.getTestContext().getConnection().getRole());
    }

    @Override
    public TestContext getTestContext() {
        return TestContext.create(null, null, "<VirtualCube name=\"Warehouse and Sales2\" defaultMeasure=\"Store Sales\">\n   <VirtualCubeDimension cubeName=\"Sales\" name=\"Gender\"/>\n   <VirtualCubeDimension name=\"Store\"/>\n   <VirtualCubeDimension name=\"Product\"/>\n   <VirtualCubeDimension cubeName=\"Warehouse\" name=\"Warehouse\"/>\n   <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Store Sales]\"/>\n   <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Customer Count]\"/>\n</VirtualCube><VirtualCube name=\"Warehouse and Sales3\" defaultMeasure=\"Store Invoice\">\n  <CubeUsages>\n       <CubeUsage cubeName=\"Sales\" ignoreUnrelatedDimensions=\"true\"/>   </CubeUsages>\n   <VirtualCubeDimension cubeName=\"Sales\" name=\"Gender\"/>\n   <VirtualCubeDimension name=\"Store\"/>\n   <VirtualCubeDimension name=\"Product\"/>\n   <VirtualCubeDimension cubeName=\"Warehouse\" name=\"Warehouse\"/>\n   <VirtualCubeMeasure cubeName=\"Sales\" name=\"[Measures].[Customer Count]\"/>\n</VirtualCube>", null, null, null);
    }

    public void testTupleWithAllLevelMembersOnly() {
        this.assertQueryReturns("WITH MEMBER GENDER.X AS 'AGGREGATE({([GENDER].DEFAULTMEMBER,\n[STORE].DEFAULTMEMBER)})'\nSELECT GENDER.X ON 0, [MEASURES].[CUSTOMER COUNT] ON 1 FROM SALES", AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Gender].[X]}\nAxis #2:\n{[Measures].[Customer Count]}\nRow #0: 5,581\n"));
    }

    public void testCrossJoinOfAllMembers() {
        this.assertQueryReturns("WITH MEMBER GENDER.X AS 'AGGREGATE({CROSSJOIN({[GENDER].DEFAULTMEMBER},\n{[STORE].DEFAULTMEMBER})})'\nSELECT GENDER.X ON 0, [MEASURES].[CUSTOMER COUNT] ON 1 FROM SALES", AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Gender].[X]}\nAxis #2:\n{[Measures].[Customer Count]}\nRow #0: 5,581\n"));
    }

    public void testCrossJoinMembersWithASingleMember() {
        String query = "WITH MEMBER GENDER.X AS 'AGGREGATE({[GENDER].[GENDER].members} * {[STORE].[ALL STORES].[USA].[CA]})', solve_order=100 SELECT GENDER.X ON 0, [MEASURES].[CUSTOMER COUNT] ON 1 FROM SALES";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Gender].[X]}\nAxis #2:\n{[Measures].[Customer Count]}\nRow #0: 2,716\n";
        this.assertQueryReturns(query, AggregationOnDistinctCountMeasuresTest.fold(result));
        String derbySql = "select \"time_by_day\".\"the_year\" as \"c0\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"store\" as \"store\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"store\".\"store_state\" = 'CA' group by \"time_by_day\".\"the_year\"";
        String mysqlSql = "select `time_by_day`.`the_year` as `c0`, count(distinct `sales_fact_1997`.`customer_id`) as `m0` from `time_by_day` as `time_by_day`, `sales_fact_1997` as `sales_fact_1997`, `store` as `store` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `sales_fact_1997`.`store_id` = `store`.`store_id` and `store`.`store_state` = 'CA' group by `time_by_day`.`the_year`";
        String oraTeraSql = "select \"time_by_day\".\"the_year\" as \"c0\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" =as= \"time_by_day\", \"sales_fact_1997\" =as= \"sales_fact_1997\", \"store\" =as= \"store\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"store\".\"store_state\" = 'CA' group by \"time_by_day\".\"the_year\"";
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.DERBY, derbySql, derbySql), new SqlPattern(Dialect.DatabaseProduct.MYSQL, mysqlSql, mysqlSql), new SqlPattern(Dialect.DatabaseProduct.ORACLE, oraTeraSql, oraTeraSql), new SqlPattern(Dialect.DatabaseProduct.TERADATA, oraTeraSql, oraTeraSql)};
        this.assertQuerySql(query, patterns);
    }

    public void testCrossJoinMembersWithSetOfMembers() {
        String query = "WITH MEMBER GENDER.X AS 'AGGREGATE({[GENDER].[GENDER].members} * {[STORE].[ALL STORES].[USA].[CA], [Store].[All Stores].[Canada]})', solve_order=100 SELECT GENDER.X ON 0, [MEASURES].[CUSTOMER COUNT] ON 1 FROM SALES";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Gender].[X]}\nAxis #2:\n{[Measures].[Customer Count]}\nRow #0: 2,716\n";
        this.assertQueryReturns(query, AggregationOnDistinctCountMeasuresTest.fold(result));
        String derbySql = "select \"time_by_day\".\"the_year\" as \"c0\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"store\" as \"store\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and (\"store\".\"store_country\" = 'Canada' or \"store\".\"store_state\" = 'CA') group by \"time_by_day\".\"the_year\"";
        String mysqlSql = "select `time_by_day`.`the_year` as `c0`, count(distinct `sales_fact_1997`.`customer_id`) as `m0` from `time_by_day` as `time_by_day`, `sales_fact_1997` as `sales_fact_1997`, `store` as `store` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `sales_fact_1997`.`store_id` = `store`.`store_id` and (`store`.`store_country` = 'Canada' or `store`.`store_state` = 'CA') group by `time_by_day`.`the_year`";
        String oraTeraSql = "select \"time_by_day\".\"the_year\" as \"c0\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" =as= \"time_by_day\", \"sales_fact_1997\" =as= \"sales_fact_1997\", \"store\" =as= \"store\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and (\"store\".\"store_country\" = 'Canada' or \"store\".\"store_state\" = 'CA') group by \"time_by_day\".\"the_year\"";
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.DERBY, derbySql, derbySql), new SqlPattern(Dialect.DatabaseProduct.MYSQL, mysqlSql, mysqlSql), new SqlPattern(Dialect.DatabaseProduct.ORACLE, oraTeraSql, oraTeraSql), new SqlPattern(Dialect.DatabaseProduct.TERADATA, oraTeraSql, oraTeraSql)};
        this.assertQuerySql(query, patterns);
    }

    public void testCrossJoinParticularMembersFromTwoDimensions() {
        this.assertQueryReturns("WITH MEMBER GENDER.X AS 'AGGREGATE({[GENDER].M} * {[STORE].[ALL STORES].[USA].[CA]})', solve_order=100 SELECT GENDER.X ON 0, [MEASURES].[CUSTOMER COUNT] ON 1 FROM SALES", AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Gender].[X]}\nAxis #2:\n{[Measures].[Customer Count]}\nRow #0: 1,389\n"));
    }

    public void testDistinctCountOnSetOfMembersFromOneDimension() {
        this.assertQueryReturns("WITH MEMBER GENDER.X AS 'AGGREGATE({[GENDER].[GENDER].members})'SELECT GENDER.X ON 0, [MEASURES].[CUSTOMER COUNT] ON 1 FROM SALES", AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Gender].[X]}\nAxis #2:\n{[Measures].[Customer Count]}\nRow #0: 5,581\n"));
    }

    public void testDistinctCountWithAMeasureAsPartOfTuple() {
        this.assertQueryReturns("SELECT [STORE].[ALL STORES].[USA].[CA] ON 0, ([MEASURES].[CUSTOMER COUNT], [Gender].[m]) ON 1 FROM SALES", AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[USA].[CA]}\nAxis #2:\n{[Measures].[Customer Count], [Gender].[All Gender].[M]}\nRow #0: 1,389\n"));
    }

    public void testDistinctCountOnSetOfMembers() {
        this.assertQueryReturns("WITH MEMBER STORE.X as 'Aggregate({[STORE].[ALL STORES].[USA].[CA],[STORE].[ALL STORES].[USA].[WA]})'SELECT STORE.X  ON ROWS, {[MEASURES].[CUSTOMER COUNT]} ON COLUMNS\nFROM [SALES]", AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Store].[X]}\nRow #0: 4,544\n"));
    }

    public void testDistinctCountOnTuplesWithSomeNonJoiningDimensions() {
        boolean orginalPropertyValue = this.props.IgnoreMeasureForNonJoiningDimension.get();
        this.props.IgnoreMeasureForNonJoiningDimension.set(false);
        String mdx = "WITH MEMBER WAREHOUSE.X as 'Aggregate({WAREHOUSE.[STATE PROVINCE].MEMBERS}*{[Gender].Members})'SELECT WAREHOUSE.X  ON ROWS, {[MEASURES].[CUSTOMER COUNT]} ON COLUMNS\nFROM [WAREHOUSE AND SALES2]";
        String expectedResult = AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Warehouse].[X]}\nRow #0: \n");
        this.assertQueryReturns(mdx, expectedResult);
        this.props.IgnoreMeasureForNonJoiningDimension.set(true);
        this.assertQueryReturns(mdx, expectedResult);
        this.props.IgnoreMeasureForNonJoiningDimension.set(orginalPropertyValue);
    }

    public void testAggregationListOptimizationForChildren() {
        String query = "WITH MEMBER GENDER.X AS 'AGGREGATE({[GENDER].[GENDER].members} * {[STORE].[ALL STORES].[USA].[CA], [STORE].[ALL STORES].[USA].[OR], [STORE].[ALL STORES].[USA].[WA], [Store].[All Stores].[Canada]})' SELECT GENDER.X ON 0, [MEASURES].[CUSTOMER COUNT] ON 1 FROM SALES";
        String result = "Axis #0:\n{}\nAxis #1:\n{[Gender].[X]}\nAxis #2:\n{[Measures].[Customer Count]}\nRow #0: 5,581\n";
        this.assertQueryReturns(query, AggregationOnDistinctCountMeasuresTest.fold(result));
    }

    public void testDistinctCountOnMembersWithNonJoiningDimensionNotAtAllLevel() {
        this.assertQueryReturns("WITH MEMBER WAREHOUSE.X as 'Aggregate({WAREHOUSE.[STATE PROVINCE].MEMBERS})'SELECT WAREHOUSE.X  ON ROWS, {[MEASURES].[CUSTOMER COUNT]} ON COLUMNS\nFROM [WAREHOUSE AND SALES2]", AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Warehouse].[X]}\nRow #0: \n"));
    }

    public void testNonJoiningDimensionWithAllMember() {
        this.assertQueryReturns("WITH MEMBER WAREHOUSE.X as 'Aggregate({WAREHOUSE.MEMBERS})'SELECT WAREHOUSE.X  ON ROWS, {[MEASURES].[CUSTOMER COUNT]} ON COLUMNS\nFROM [WAREHOUSE AND SALES2]", AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Warehouse].[X]}\nRow #0: 5,581\n"));
    }

    public void testCrossJoinOfJoiningAndNonJoiningDimensionWithAllMember() {
        this.assertQueryReturns("WITH MEMBER WAREHOUSE.X AS 'AGGREGATE({GENDER.GENDER.MEMBERS} * {WAREHOUSE.MEMBERS})'SELECT WAREHOUSE.X  ON ROWS, {[MEASURES].[CUSTOMER COUNT]} ON COLUMNS\nFROM [WAREHOUSE AND SALES2]", AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Warehouse].[X]}\nRow #0: 5,581\n"));
        this.assertQueryReturns("WITH MEMBER WAREHOUSE.X AS 'AGGREGATE({GENDER.GENDER.MEMBERS} * {WAREHOUSE.MEMBERS})'SELECT WAREHOUSE.X  ON ROWS, {[MEASURES].[CUSTOMER COUNT]} ON COLUMNS\nFROM [WAREHOUSE AND SALES3]", AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Warehouse].[X]}\nRow #0: 5,581\n"));
    }

    public void testCrossJoinOfJoiningAndNonJoiningDimension() {
        this.assertQueryReturns("WITH MEMBER WAREHOUSE.X AS 'AGGREGATE({GENDER.GENDER.MEMBERS} * {WAREHOUSE.[STATE PROVINCE].MEMBERS})'SELECT WAREHOUSE.X  ON ROWS, {[MEASURES].[CUSTOMER COUNT]} ON COLUMNS\nFROM [WAREHOUSE AND SALES2]", AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Warehouse].[X]}\nRow #0: \n"));
        this.assertQueryReturns("WITH MEMBER WAREHOUSE.X AS 'AGGREGATE({GENDER.GENDER.MEMBERS} * {WAREHOUSE.[STATE PROVINCE].MEMBERS})'SELECT WAREHOUSE.X  ON ROWS, {[MEASURES].[CUSTOMER COUNT]} ON COLUMNS\nFROM [WAREHOUSE AND SALES3]", AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Warehouse].[X]}\nRow #0: 5,581\n"));
    }

    public void testAggregationOverLargeListGeneratesError() {
        int origMaxConstraint = this.props.MaxConstraints.get();
        this.props.MaxConstraints.set(7);
        String query = "WITH MEMBER PRODUCT.X as 'Aggregate({[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Good],\n[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Portsmouth],\n[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Top Measure],\n[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Beer].[Walrus],\n[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Pearl],\n[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Portsmouth],\n[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Top Measure],\n[Product].[All Products].[Drink].[Alcoholic Beverages].[Beer and Wine].[Wine].[Walrus]})' SELECT PRODUCT.X  ON ROWS, {[MEASURES].[CUSTOMER COUNT]} ON COLUMNS\nFROM [WAREHOUSE AND SALES2]";
        Dialect dialect = this.getTestContext().getDialect();
        String result = dialect.getDatabaseProduct() == Dialect.DatabaseProduct.LUCIDDB ? "Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Product].[X]}\nRow #0: 1,360\n" : "Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Product].[X]}\nRow #0: #ERR: mondrian.olap.fun.MondrianEvaluationException: Distinct Count aggregation is not supported over a list with more than 7 predicates (see property mondrian.rolap.maxConstraints)\n";
        this.assertQueryReturns(query, AggregationOnDistinctCountMeasuresTest.fold(result));
        this.props.MaxConstraints.set(origMaxConstraint);
    }

    public void testMultiLevelMembersNullParents() {
        if (!this.isDefaultNullMemberRepresentation()) {
            return;
        }
        String dimension = "<Dimension name=\"Warehouse2\">\n  <Hierarchy hasAll=\"true\" primaryKey=\"warehouse_id\">\n    <Table name=\"warehouse\"/>\n    <Level name=\"address3\" column=\"wa_address3\" uniqueMembers=\"true\"/>\n    <Level name=\"address2\" column=\"wa_address2\" uniqueMembers=\"true\"/>\n    <Level name=\"address1\" column=\"wa_address1\" uniqueMembers=\"false\"/>\n    <Level name=\"name\" column=\"warehouse_name\" uniqueMembers=\"false\"/>\n  </Hierarchy>\n</Dimension>\n";
        String cube = "<Cube name=\"Warehouse2\">\n  <Table name=\"inventory_fact_1997\"/>\n  <DimensionUsage name=\"Product\" source=\"Product\" foreignKey=\"product_id\"/>\n  <DimensionUsage name=\"Warehouse2\" source=\"Warehouse2\" foreignKey=\"warehouse_id\"/>\n  <Measure name=\"Cost Count\" column=\"warehouse_cost\" aggregator=\"distinct-count\"/>\n</Cube>";
        String query = "with set [Filtered Warehouse Set] as {[Warehouse2].[#null].[#null].[5617 Saclan Terrace].[Arnold and Sons], [Warehouse2].[#null].[#null].[3377 Coachman Place].[Jones International]} member [Warehouse2].[TwoMembers] as 'AGGREGATE([Filtered Warehouse Set])' select {[Measures].[Cost Count]} on columns, {[Warehouse2].[TwoMembers]} on rows from [Warehouse2]";
        String necjSqlDerby = "select count(distinct \"inventory_fact_1997\".\"warehouse_cost\") as \"m0\" from \"warehouse\" as \"warehouse\", \"inventory_fact_1997\" as \"inventory_fact_1997\" where \"inventory_fact_1997\".\"warehouse_id\" = \"warehouse\".\"warehouse_id\" and ((\"warehouse\".\"warehouse_name\" = 'Arnold and Sons' and \"warehouse\".\"wa_address1\" = '5617 Saclan Terrace' and \"warehouse\".\"wa_address2\" is null) or (\"warehouse\".\"warehouse_name\" = 'Jones International' and \"warehouse\".\"wa_address1\" = '3377 Coachman Place' and \"warehouse\".\"wa_address2\" is null))";
        String necjSqlMySql = "select count(distinct `inventory_fact_1997`.`warehouse_cost`) as `m0` from `warehouse` as `warehouse`, `inventory_fact_1997` as `inventory_fact_1997` where `inventory_fact_1997`.`warehouse_id` = `warehouse`.`warehouse_id` and ((`warehouse`.`wa_address2` is null and (`warehouse`.`wa_address1`, `warehouse`.`warehouse_name`) in (('5617 Saclan Terrace', 'Arnold and Sons'), ('3377 Coachman Place', 'Jones International'))))";
        TestContext testContext = TestContext.create(dimension, cube, null, null, null, null);
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.DERBY, necjSqlDerby, necjSqlDerby), new SqlPattern(Dialect.DatabaseProduct.MYSQL, necjSqlMySql, necjSqlMySql)};
        this.assertQuerySql(testContext, query, patterns);
    }

    public void testMultiLevelMembersMixedNullNonNullParent() {
        if (!this.isDefaultNullMemberRepresentation()) {
            return;
        }
        String dimension = "<Dimension name=\"Warehouse2\">\n  <Hierarchy hasAll=\"true\" primaryKey=\"warehouse_id\">\n    <Table name=\"warehouse\"/>\n    <Level name=\"fax\" column=\"warehouse_fax\" uniqueMembers=\"true\"/>\n    <Level name=\"address1\" column=\"wa_address1\" uniqueMembers=\"false\"/>\n    <Level name=\"name\" column=\"warehouse_name\" uniqueMembers=\"false\"/>\n  </Hierarchy>\n</Dimension>\n";
        String cube = "<Cube name=\"Warehouse2\">\n  <Table name=\"inventory_fact_1997\"/>\n  <DimensionUsage name=\"Product\" source=\"Product\" foreignKey=\"product_id\"/>\n  <DimensionUsage name=\"Warehouse2\" source=\"Warehouse2\" foreignKey=\"warehouse_id\"/>\n  <Measure name=\"Cost Count\" column=\"warehouse_cost\" aggregator=\"distinct-count\"/>\n</Cube>";
        String query = "with\nset [Filtered Warehouse Set] as {[Warehouse2].[#null].[234 West Covina Pkwy].[Freeman And Co], [Warehouse2].[971-555-6213].[3377 Coachman Place].[Jones International]} member [Warehouse2].[TwoMembers] as 'AGGREGATE([Filtered Warehouse Set])' select {[Measures].[Cost Count]} on columns, {[Warehouse2].[TwoMembers]} on rows from [Warehouse2]";
        String necjSqlMySql2 = "select count(distinct `inventory_fact_1997`.`warehouse_cost`) as `m0` from `warehouse` as `warehouse`, `inventory_fact_1997` as `inventory_fact_1997` where `inventory_fact_1997`.`warehouse_id` = `warehouse`.`warehouse_id` and ((`warehouse`.`warehouse_name` = 'Freeman And Co' and `warehouse`.`wa_address1` = '234 West Covina Pkwy' and `warehouse`.`warehouse_fax` is null) or (`warehouse`.`warehouse_name` = 'Jones International' and `warehouse`.`wa_address1` = '3377 Coachman Place' and `warehouse`.`warehouse_fax` = '971-555-6213'))";
        TestContext testContext = TestContext.create(dimension, cube, null, null, null, null);
        String result = AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Cost Count]}\nAxis #2:\n{[Warehouse2].[TwoMembers]}\nRow #0: 220\n");
        testContext.assertQueryReturns(query, result);
    }

    public void testMultiLevelsMixedNullNonNullChild() {
        if (!this.isDefaultNullMemberRepresentation()) {
            return;
        }
        String dimension = "<Dimension name=\"Warehouse2\">\n  <Hierarchy hasAll=\"true\" primaryKey=\"warehouse_id\">\n    <Table name=\"warehouse\"/>\n    <Level name=\"address3\" column=\"wa_address3\" uniqueMembers=\"true\"/>\n    <Level name=\"address2\" column=\"wa_address2\" uniqueMembers=\"false\"/>\n    <Level name=\"fax\" column=\"warehouse_fax\" uniqueMembers=\"false\"/>\n  </Hierarchy>\n</Dimension>\n";
        String cube = "<Cube name=\"Warehouse2\">\n  <Table name=\"inventory_fact_1997\"/>\n  <DimensionUsage name=\"Product\" source=\"Product\" foreignKey=\"product_id\"/>\n  <DimensionUsage name=\"Warehouse2\" source=\"Warehouse2\" foreignKey=\"warehouse_id\"/>\n  <Measure name=\"Cost Count\" column=\"warehouse_cost\" aggregator=\"distinct-count\"/>\n</Cube>";
        String query = "with\nset [Filtered Warehouse Set] as {[Warehouse2].[#null].[#null].[#null], [Warehouse2].[#null].[#null].[971-555-6213]} member [Warehouse2].[TwoMembers] as 'AGGREGATE([Filtered Warehouse Set])' select {[Measures].[Cost Count]} on columns, {[Warehouse2].[TwoMembers]} on rows from [Warehouse2]";
        String necjSqlMySql2 = "select count(distinct `inventory_fact_1997`.`warehouse_cost`) as `m0` from `warehouse` as `warehouse`, `inventory_fact_1997` as `inventory_fact_1997` where `inventory_fact_1997`.`warehouse_id` = `warehouse`.`warehouse_id` and ((`warehouse`.`warehouse_fax` is null and `warehouse`.`wa_address2` is null and `warehouse`.`wa_address3` is null) or (`warehouse`.`warehouse_fax` = '971-555-6213' and `warehouse`.`wa_address2` is null and `warehouse`.`wa_address3` is null))";
        TestContext testContext = TestContext.create(dimension, cube, null, null, null, null);
        String result = AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Cost Count]}\nAxis #2:\n{[Warehouse2].[TwoMembers]}\nRow #0: 220\n");
        testContext.assertQueryReturns(query, result);
    }

    public void testAggregationOnCJofMembersGeneratesOptimalQuery() {
        String mdxQuery = "WITH \nSET [COG_OQP_INT_s2] AS 'CROSSJOIN({[Store].[Store].MEMBERS}, {{[Gender].[Gender].MEMBERS}, {([Gender].[COG_OQP_USR_Aggregate(Gender)])}})' \nSET [COG_OQP_INT_s1] AS 'CROSSJOIN({[Store].[Store].MEMBERS}, {[Gender].[Gender].MEMBERS})' \n\nMEMBER [Store].[COG_OQP_USR_Aggregate(Store)] AS '\nAGGREGATE({COG_OQP_INT_s1})', SOLVE_ORDER = 4 \n\nMEMBER [Gender].[COG_OQP_USR_Aggregate(Gender)] AS '\nAGGREGATE({[Gender].DEFAULTMEMBER})', SOLVE_ORDER = 8 \n\n\nSELECT {[Measures].[Customer Count]} ON AXIS(0), \n{[COG_OQP_INT_s2], HEAD({([Store].[COG_OQP_USR_Aggregate(Store)], [Gender].DEFAULTMEMBER)}, IIF(COUNT([COG_OQP_INT_s1], INCLUDEEMPTY) > 0, 1, 0))} ON AXIS(1) \nFROM [sales]";
        String oraTeraSql = this.props.EnableGroupingSets.get() ? "select \"store\".\"store_name\" as \"c0\", \"time_by_day\".\"the_year\" as \"c1\", \"customer\".\"gender\" as \"c2\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\", grouping(\"customer\".\"gender\") as \"g0\" from \"store\" =as= \"store\", \"sales_fact_1997\" =as= \"sales_fact_1997\", \"time_by_day\" =as= \"time_by_day\", \"customer\" =as= \"customer\" where \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" group by grouping sets ((\"store\".\"store_name\",\"time_by_day\".\"the_year\",\"customer\".\"gender\"),(\"store\".\"store_name\",\"time_by_day\".\"the_year\"))" : "select \"store\".\"store_state\" as \"c0\", \"time_by_day\".\"the_year\" as \"c1\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"store\" =as= \"store\", \"sales_fact_1997\" =as= \"sales_fact_1997\", \"time_by_day\" =as= \"time_by_day\" where \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 group by \"store\".\"store_state\", \"time_by_day\".\"the_year\"";
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ORACLE, oraTeraSql, oraTeraSql), new SqlPattern(Dialect.DatabaseProduct.TERADATA, oraTeraSql, oraTeraSql)};
        this.assertQuerySql(mdxQuery, patterns);
    }

    public void testCanNotBatchForDifferentCompoundPredicate() {
        boolean originalGroupingSetsPropertyValue = this.props.EnableGroupingSets.get();
        this.props.EnableGroupingSets.set(true);
        String mdxQueryWithFewMembers = "WITH MEMBER [Store].[COG_OQP_USR_Aggregate(Store)] AS 'AGGREGATE({[Store].[All Stores].[USA].[CA], [Store].[All Stores].[USA].[OR],[Store].[All Stores].[USA].[WA]})', SOLVE_ORDER = 8SELECT {[Measures].[Customer Count]} ON AXIS(0), {[Store].[All Stores].[USA].[CA], [Store].[All Stores].[USA].[OR], [Store].[COG_OQP_USR_Aggregate(Store)]} ON AXIS(1) FROM [Sales]";
        String desiredResult = AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[COG_OQP_USR_Aggregate(Store)]}\nRow #0: 2,716\nRow #1: 1,037\nRow #2: 5,581\n");
        String oraTeraSqlForAgg = "select \"time_by_day\".\"the_year\" as \"c0\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" =as= \"time_by_day\", \"sales_fact_1997\" =as= \"sales_fact_1997\", \"store\" =as= \"store\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"store\".\"store_country\" = 'USA' group by \"time_by_day\".\"the_year\"";
        String oraTeraSqlForDetail = "select \"store\".\"store_state\" as \"c0\", \"time_by_day\".\"the_year\" as \"c1\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"store\" =as= \"store\", \"sales_fact_1997\" =as= \"sales_fact_1997\", \"time_by_day\" =as= \"time_by_day\" where \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"store\".\"store_state\" in ('CA', 'OR') and \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 group by \"store\".\"store_state\", \"time_by_day\".\"the_year\"";
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ORACLE, oraTeraSqlForAgg, oraTeraSqlForAgg), new SqlPattern(Dialect.DatabaseProduct.TERADATA, oraTeraSqlForAgg, oraTeraSqlForAgg), new SqlPattern(Dialect.DatabaseProduct.ORACLE, oraTeraSqlForDetail, oraTeraSqlForDetail), new SqlPattern(Dialect.DatabaseProduct.TERADATA, oraTeraSqlForDetail, oraTeraSqlForDetail)};
        this.assertQueryReturns(mdxQueryWithFewMembers, desiredResult);
        this.assertQuerySql(mdxQueryWithFewMembers, patterns);
        this.props.EnableGroupingSets.set(originalGroupingSetsPropertyValue);
    }

    public void testDistinctCountAggHappensInNonGSQueryForSubsetOfMembersWithMixedMeasures() {
        boolean originalGroupingSetsPropertyValue = this.props.EnableGroupingSets.get();
        this.props.EnableGroupingSets.set(true);
        String mdxQueryWithFewMembers = "WITH MEMBER [Store].[COG_OQP_USR_Aggregate(Store)] AS 'AGGREGATE({[Store].[All Stores].[USA].[CA], [Store].[All Stores].[USA].[OR]})', SOLVE_ORDER = 8SELECT {[Measures].[Customer Count],[Measures].[Unit Sales]} ON AXIS(0), {[Store].[All Stores].[USA].[CA], [Store].[All Stores].[USA].[OR], [Store].[COG_OQP_USR_Aggregate(Store)]} ON AXIS(1) FROM [Sales]";
        String desiredResult = AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Store].[All Stores].[USA].[CA]}\n{[Store].[All Stores].[USA].[OR]}\n{[Store].[COG_OQP_USR_Aggregate(Store)]}\nRow #0: 2,716\nRow #0: 74,748\nRow #1: 1,037\nRow #1: 67,659\nRow #2: 3,753\nRow #2: 142,407\n");
        String oraTeraSqlForDetail = "select \"store\".\"store_state\" as \"c0\", \"time_by_day\".\"the_year\" as \"c1\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m1\" from \"store\" =as= \"store\", \"sales_fact_1997\" =as= \"sales_fact_1997\", \"time_by_day\" =as= \"time_by_day\" where \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"store\".\"store_state\" in ('CA', 'OR') and \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 group by \"store\".\"store_state\", \"time_by_day\".\"the_year\"";
        String oraTeraSqlForDistinctCountAgg = "select \"time_by_day\".\"the_year\" as \"c0\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" =as= \"time_by_day\", \"sales_fact_1997\" =as= \"sales_fact_1997\", \"store\" =as= \"store\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"store\".\"store_state\" in ('CA', 'OR') group by \"time_by_day\".\"the_year\"";
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ORACLE, oraTeraSqlForDetail, oraTeraSqlForDetail), new SqlPattern(Dialect.DatabaseProduct.TERADATA, oraTeraSqlForDetail, oraTeraSqlForDetail), new SqlPattern(Dialect.DatabaseProduct.ORACLE, oraTeraSqlForDistinctCountAgg, oraTeraSqlForDistinctCountAgg), new SqlPattern(Dialect.DatabaseProduct.TERADATA, oraTeraSqlForDistinctCountAgg, oraTeraSqlForDistinctCountAgg)};
        this.assertQueryReturns(mdxQueryWithFewMembers, desiredResult);
        this.assertQuerySql(mdxQueryWithFewMembers, patterns);
        this.props.EnableGroupingSets.set(originalGroupingSetsPropertyValue);
    }

    public void testAggregationOfMembersAndDefaultMemberWithoutGroupingSets() {
        boolean originalGroupingSetsPropertyValue = this.props.EnableGroupingSets.get();
        this.props.EnableGroupingSets.set(false);
        String mdxQueryWithMembers = "WITH MEMBER [Gender].[COG_OQP_USR_Aggregate(Gender)] AS 'AGGREGATE({[Gender].MEMBERS})', SOLVE_ORDER = 8SELECT {[Measures].[Customer Count]} ON AXIS(0), {[Gender].MEMBERS, [Gender].[COG_OQP_USR_Aggregate(Gender)]} ON AXIS(1) FROM [Sales]";
        String mdxQueryWithDefaultMember = "WITH MEMBER [Gender].[COG_OQP_USR_Aggregate(Gender)] AS 'AGGREGATE({[Gender].DEFAULTMEMBER})', SOLVE_ORDER = 8SELECT {[Measures].[Customer Count]} ON AXIS(0), \n{[Gender].MEMBERS, [Gender].[COG_OQP_USR_Aggregate(Gender)]} ON AXIS(1) \nFROM [sales]";
        String desiredResult = AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Gender].[All Gender]}\n{[Gender].[All Gender].[F]}\n{[Gender].[All Gender].[M]}\n{[Gender].[COG_OQP_USR_Aggregate(Gender)]}\nRow #0: 5,581\nRow #1: 2,755\nRow #2: 2,826\nRow #3: 5,581\n");
        String oraTeraSql = "select \"time_by_day\".\"the_year\" as \"c0\", \"customer\".\"gender\" as \"c1\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" =as= \"time_by_day\", \"sales_fact_1997\" =as= \"sales_fact_1997\", \"customer\" =as= \"customer\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" group by \"time_by_day\".\"the_year\", \"customer\".\"gender\"";
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ORACLE, oraTeraSql, oraTeraSql), new SqlPattern(Dialect.DatabaseProduct.TERADATA, oraTeraSql, oraTeraSql)};
        this.assertQueryReturns(mdxQueryWithMembers, desiredResult);
        this.assertQuerySql(mdxQueryWithMembers, patterns);
        this.assertQueryReturns(mdxQueryWithDefaultMember, desiredResult);
        this.assertQuerySql(mdxQueryWithDefaultMember, patterns);
        this.props.EnableGroupingSets.set(originalGroupingSetsPropertyValue);
    }

    public void testShouldConvertListOfMembersToTuples() {
        List<Member[]> tuples = this.tupleList(this.genderMembersIncludingAll(true, this.salesCubeSchemaReader, this.salesCube));
        AggregationOnDistinctCountMeasuresTest.assertEquals((int)3, (int)tuples.size());
        AggregationOnDistinctCountMeasuresTest.assertEquals((String)this.allMember("Gender", this.salesCube).getUniqueName(), (String)tuples.get(0)[0].getUniqueName());
    }

    public void testOptimizeChildren() {
        String query = "with member gender.x as 'aggregate({gender.gender.members * Store.[all stores].[usa].children})' select {gender.x} on 0, measures.[customer count] on 1 from sales";
        String expected = AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Gender].[x]}\nAxis #2:\n{[Measures].[Customer Count]}\nRow #0: 5,581\n");
        this.assertQueryReturns(query, expected);
        String derbySql = "select \"time_by_day\".\"the_year\" as \"c0\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"store\" as \"store\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and \"store\".\"store_country\" = 'USA' group by \"time_by_day\".\"the_year\"";
        String accessSql = "select `d0` as `c0`, count(`m0`) as `c1` from (select distinct `time_by_day`.`the_year` as `d0`, `sales_fact_1997`.`customer_id` as `m0` from `time_by_day` as `time_by_day`, `sales_fact_1997` as `sales_fact_1997`, `store` as `store` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `sales_fact_1997`.`store_id` = `store`.`store_id` and `store`.`store_country` = 'USA') as `dummyname` group by `d0`";
        String luciddbSql = "select \"time_by_day\".\"the_year\" as \"c0\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"customer\" as \"customer\", \"store\" as \"store\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" and \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and (((\"store\".\"store_state\", \"customer\".\"gender\") in (('CA', 'F'), ('OR', 'F'), ('WA', 'F'), ('CA', 'M'), ('OR', 'M'), ('WA', 'M')))) group by \"time_by_day\".\"the_year\"";
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.DERBY, derbySql, derbySql), new SqlPattern(Dialect.DatabaseProduct.ACCESS, accessSql, accessSql), new SqlPattern(Dialect.DatabaseProduct.LUCIDDB, luciddbSql, luciddbSql)};
        this.assertQuerySql(query, patterns);
    }

    public void testOptimizeListWhenTuplesAreFormedWithDifferentLevels() {
        String query = "WITH\nMEMBER Product.Agg AS \n'Aggregate({[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pot Scrubbers].[Cormorant],\n[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pot Scrubbers].[Denny],\n[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pot Scrubbers].[High Quality],\n[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pot Scrubbers].[Red Wing],\n[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pots and Pans].[Cormorant],\n[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pots and Pans].[Denny],\n[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pots and Pans].[High Quality],\n[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pots and Pans].[Red Wing],\n[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pots and Pans].[Sunset]} *\n{[Gender].[Gender].Members})'\nSELECT {Product.Agg} on 0, {[Measures].[Customer Count]} on 1\nfrom Sales\nwhere [Time.Weekly].[1997]";
        String expected = AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{[Time].[Weekly].[All Weeklys].[1997]}\nAxis #1:\n{[Product].[Agg]}\nAxis #2:\n{[Measures].[Customer Count]}\nRow #0: 421\n");
        this.assertQueryReturns(query, expected);
        String derbySql = "select \"time_by_day\".\"the_year\" as \"c0\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"product\" as \"product\", \"product_class\" as \"product_class\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"product_id\" = \"product\".\"product_id\" and \"product\".\"product_class_id\" = \"product_class\".\"product_class_id\" and (((\"product\".\"brand_name\" = 'Red Wing' and \"product_class\".\"product_subcategory\" = 'Pot Scrubbers' and \"product_class\".\"product_category\" = 'Kitchen Products' and \"product_class\".\"product_department\" = 'Household' and \"product_class\".\"product_family\" = 'Non-Consumable') or (\"product\".\"brand_name\" = 'Cormorant' and \"product_class\".\"product_subcategory\" = 'Pot Scrubbers' and \"product_class\".\"product_category\" = 'Kitchen Products' and \"product_class\".\"product_department\" = 'Household' and \"product_class\".\"product_family\" = 'Non-Consumable') or (\"product\".\"brand_name\" = 'Denny' and \"product_class\".\"product_subcategory\" = 'Pot Scrubbers' and \"product_class\".\"product_category\" = 'Kitchen Products' and \"product_class\".\"product_department\" = 'Household' and \"product_class\".\"product_family\" = 'Non-Consumable') or (\"product\".\"brand_name\" = 'High Quality' and \"product_class\".\"product_subcategory\" = 'Pot Scrubbers' and \"product_class\".\"product_category\" = 'Kitchen Products' and \"product_class\".\"product_department\" = 'Household' and \"product_class\".\"product_family\" = 'Non-Consumable')) or (\"product_class\".\"product_subcategory\" = 'Pots and Pans' and \"product_class\".\"product_category\" = 'Kitchen Products' and \"product_class\".\"product_department\" = 'Household' and \"product_class\".\"product_family\" = 'Non-Consumable')) group by \"time_by_day\".\"the_year\"";
        String accessSql = "select `d0` as `c0`, count(`m0`) as `c1` from (select distinct `time_by_day`.`the_year` as `d0`, `sales_fact_1997`.`customer_id` as `m0` from `time_by_day` as `time_by_day`, `sales_fact_1997` as `sales_fact_1997`, `product` as `product`, `product_class` as `product_class` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `sales_fact_1997`.`product_id` = `product`.`product_id` and `product`.`product_class_id` = `product_class`.`product_class_id` and (((`product`.`brand_name` = 'High Quality' and `product_class`.`product_subcategory` = 'Pot Scrubbers' and `product_class`.`product_category` = 'Kitchen Products' and `product_class`.`product_department` = 'Household' and `product_class`.`product_family` = 'Non-Consumable') or (`product`.`brand_name` = 'Denny' and `product_class`.`product_subcategory` = 'Pot Scrubbers' and `product_class`.`product_category` = 'Kitchen Products' and `product_class`.`product_department` = 'Household' and `product_class`.`product_family` = 'Non-Consumable') or (`product`.`brand_name` = 'Red Wing' and `product_class`.`product_subcategory` = 'Pot Scrubbers' and `product_class`.`product_category` = 'Kitchen Products' and `product_class`.`product_department` = 'Household' and `product_class`.`product_family` = 'Non-Consumable') or (`product`.`brand_name` = 'Cormorant' and `product_class`.`product_subcategory` = 'Pot Scrubbers' and `product_class`.`product_category` = 'Kitchen Products' and `product_class`.`product_department` = 'Household' and `product_class`.`product_family` = 'Non-Consumable')) or (`product_class`.`product_subcategory` = 'Pots and Pans' and `product_class`.`product_category` = 'Kitchen Products' and `product_class`.`product_department` = 'Household' and `product_class`.`product_family` = 'Non-Consumable'))) as `dummyname` group by `d0`";
        SqlPattern[] patterns = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ACCESS, accessSql, accessSql)};
        this.assertQuerySql(query, patterns);
    }

    public void testOptimizeListWithTuplesOfLength3() {
        String query = "WITH\nMEMBER Product.Agg AS \n'Aggregate({[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pot Scrubbers].[Cormorant],\n[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pot Scrubbers].[Denny],\n[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pot Scrubbers].[High Quality],\n[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pot Scrubbers].[Red Wing],\n[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pots and Pans].[Cormorant],\n[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pots and Pans].[Denny],\n[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pots and Pans].[High Quality],\n[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pots and Pans].[Red Wing],\n[Product].[All Products].[Non-Consumable].[Household].[Kitchen Products].[Pots and Pans].[Sunset]} *\n{[Gender].[Gender].Members}*{[Store].[All Stores].[USA].[CA].[Alameda],\n[Store].[All Stores].[USA].[CA].[Alameda].[HQ],\n[Store].[All Stores].[USA].[CA].[Beverly Hills],\n[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6],\n[Store].[All Stores].[USA].[CA].[Los Angeles],\n[Store].[All Stores].[USA].[OR].[Portland],\n[Store].[All Stores].[USA].[OR].[Portland].[Store 11],\n[Store].[All Stores].[USA].[OR].[Salem],\n[Store].[All Stores].[USA].[OR].[Salem].[Store 13]})'\nSELECT {Product.Agg} on 0, {[Measures].[Customer Count]} on 1 from Sales";
        String expected = AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Product].[Agg]}\nAxis #2:\n{[Measures].[Customer Count]}\nRow #0: 189\n");
        this.assertQueryReturns(query, expected);
    }

    public void testOptimizeChildrenForTuplesWithLength1() {
        List<Member[]> memberList = AggregateFunDef.AggregateCalc.makeTupleList(this.productMembersPotScrubbersPotsAndPans(this.salesCubeSchemaReader));
        List<Member[]> tuples = this.optimizeChildren(memberList);
        AggregationOnDistinctCountMeasuresTest.assertTrue((boolean)this.tuppleListContains(tuples, this.member(Id.Segment.toList("Product", "All Products", "Non-Consumable", "Household", "Kitchen Products", "Pot Scrubbers", "Cormorant"), this.salesCubeSchemaReader)));
        AggregationOnDistinctCountMeasuresTest.assertFalse((boolean)this.tuppleListContains(tuples, this.member(Id.Segment.toList("Product", "All Products", "Non-Consumable", "Household", "Kitchen Products", "Pot Scrubbers"), this.salesCubeSchemaReader)));
        AggregationOnDistinctCountMeasuresTest.assertFalse((boolean)this.tuppleListContains(tuples, this.member(Id.Segment.toList("Product", "All Products", "Non-Consumable", "Household", "Kitchen Products", "Pots and Pans", "Cormorant"), this.salesCubeSchemaReader)));
        AggregationOnDistinctCountMeasuresTest.assertTrue((boolean)this.tuppleListContains(tuples, this.member(Id.Segment.toList("Product", "All Products", "Non-Consumable", "Household", "Kitchen Products", "Pots and Pans"), this.salesCubeSchemaReader)));
        AggregationOnDistinctCountMeasuresTest.assertEquals((int)4, (int)tuples.size());
    }

    public void testOptimizeChildrenForTuplesWithLength3() {
        List<Member[]> memberList = CrossJoinFunDef.crossJoin(this.genderMembersIncludingAll(false, this.salesCubeSchemaReader, this.salesCube), this.productMembersPotScrubbersPotsAndPans(this.salesCubeSchemaReader));
        memberList = CrossJoinFunDef.crossJoin(memberList, this.storeMembersCAAndOR(this.salesCubeSchemaReader));
        List<Member[]> tuples = this.optimizeChildren(memberList);
        AggregationOnDistinctCountMeasuresTest.assertFalse((boolean)this.tuppleListContains(tuples, this.member(Id.Segment.toList("Store", "All Stores", "USA", "OR", "Portland"), this.salesCubeSchemaReader)));
        AggregationOnDistinctCountMeasuresTest.assertTrue((boolean)this.tuppleListContains(tuples, this.member(Id.Segment.toList("Store", "All Stores", "USA", "OR"), this.salesCubeSchemaReader)));
        AggregationOnDistinctCountMeasuresTest.assertEquals((int)16, (int)tuples.size());
    }

    public void testOptimizeChildrenWhenTuplesAreFormedWithDifferentLevels() {
        List<Member[]> memberList = CrossJoinFunDef.crossJoin(this.genderMembersIncludingAll(false, this.salesCubeSchemaReader, this.salesCube), this.productMembersPotScrubbersPotsAndPans(this.salesCubeSchemaReader));
        List<Member[]> tuples = this.optimizeChildren(memberList);
        AggregationOnDistinctCountMeasuresTest.assertEquals((int)4, (int)tuples.size());
        AggregationOnDistinctCountMeasuresTest.assertFalse((boolean)this.tuppleListContains(tuples, this.member(Id.Segment.toList("Product", "All Products", "Non-Consumable", "Household", "Kitchen Products", "Pots and Pans", "Cormorant"), this.salesCubeSchemaReader)));
        AggregationOnDistinctCountMeasuresTest.assertTrue((boolean)this.tuppleListContains(tuples, this.member(Id.Segment.toList("Product", "All Products", "Non-Consumable", "Household", "Kitchen Products", "Pots and Pans"), this.salesCubeSchemaReader)));
        AggregationOnDistinctCountMeasuresTest.assertTrue((boolean)this.tuppleListContains(tuples, this.member(Id.Segment.toList("Product", "All Products", "Non-Consumable", "Household", "Kitchen Products", "Pot Scrubbers", "Cormorant"), this.salesCubeSchemaReader)));
    }

    public void testWhetherCJOfChildren() {
        List<Member[]> memberList = CrossJoinFunDef.crossJoin(this.genderMembersIncludingAll(false, this.salesCubeSchemaReader, this.salesCube), this.storeMembersUsaAndCanada(false, this.salesCubeSchemaReader, this.salesCube));
        List<Member[]> tuples = this.optimizeChildren(memberList);
        AggregationOnDistinctCountMeasuresTest.assertEquals((int)2, (int)tuples.size());
    }

    public void testShouldNotRemoveDuplicateTuples() {
        Member maleChildMember = this.member(Id.Segment.toList("Gender", "All Gender", "M"), this.salesCubeSchemaReader);
        Member femaleChildMember = this.member(Id.Segment.toList("Gender", "All Gender", "F"), this.salesCubeSchemaReader);
        ArrayList<Member> memberList = new ArrayList<Member>();
        memberList.add(maleChildMember);
        memberList.add(maleChildMember);
        memberList.add(femaleChildMember);
        List<Member[]> tuples = this.tupleList(memberList);
        tuples = this.optimizeChildren(tuples);
        AggregationOnDistinctCountMeasuresTest.assertEquals((int)3, (int)tuples.size());
    }

    public void testMemberCountIsSameForAllMembersInTuple() {
        List<Member[]> memberList = CrossJoinFunDef.crossJoin(this.genderMembersIncludingAll(false, this.salesCubeSchemaReader, this.salesCube), this.storeMembersUsaAndCanada(false, this.salesCubeSchemaReader, this.salesCube));
        Map<Member, Integer>[] memberCounterMap = AggregateFunDef.AggregateCalc.membersVersusOccurencesInTuple(memberList);
        AggregationOnDistinctCountMeasuresTest.assertTrue((boolean)Util.areOccurencesEqual(memberCounterMap[0].values()));
        AggregationOnDistinctCountMeasuresTest.assertTrue((boolean)Util.areOccurencesEqual(memberCounterMap[1].values()));
    }

    public void testMemberCountIsNotSameForAllMembersInTuple() {
        Member maleChild = this.member(Id.Segment.toList("Gender", "All Gender", "M"), this.salesCubeSchemaReader);
        Member femaleChild = this.member(Id.Segment.toList("Gender", "All Gender", "F"), this.salesCubeSchemaReader);
        Member mexicoMember = this.member(Id.Segment.toList("Store", "All Stores", "Mexico"), this.salesCubeSchemaReader);
        List<Object> memberList = new ArrayList<Member[]>();
        memberList.add(new Member[]{maleChild});
        memberList = CrossJoinFunDef.crossJoin(memberList, this.storeMembersUsaAndCanada(false, this.salesCubeSchemaReader, this.salesCube));
        memberList.add(new Member[]{femaleChild, mexicoMember});
        Map<Member, Integer>[] memberCounterMap = AggregateFunDef.AggregateCalc.membersVersusOccurencesInTuple(memberList);
        AggregationOnDistinctCountMeasuresTest.assertFalse((boolean)Util.areOccurencesEqual(memberCounterMap[0].values()));
        AggregationOnDistinctCountMeasuresTest.assertTrue((boolean)Util.areOccurencesEqual(memberCounterMap[1].values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testAggregatesAtTheSameLevelForNormalAndDistinctCountMeasure() {
        boolean useGroupingSets = this.props.EnableGroupingSets.get();
        this.props.EnableGroupingSets.set(true);
        try {
            this.assertQueryReturns("WITH MEMBER GENDER.AGG AS 'AGGREGATE({ GENDER.[F] })' MEMBER GENDER.AGG2 AS 'AGGREGATE({ GENDER.[M] })' SELECT { MEASURES.[CUSTOMER COUNT], MEASURES.[UNIT SALES] } ON 0, { GENDER.AGG, GENDER.AGG2 } ON 1 \nFROM SALES", AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\n{[Measures].[Unit Sales]}\nAxis #2:\n{[Gender].[AGG]}\n{[Gender].[AGG2]}\nRow #0: 2,755\nRow #0: 131,558\nRow #1: 2,826\nRow #1: 135,215\n"));
        }
        finally {
            this.props.EnableGroupingSets.set(useGroupingSets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDistinctCountForAggregatesAtTheSameLevel() {
        boolean useGroupingSets = this.props.EnableGroupingSets.get();
        this.props.EnableGroupingSets.set(true);
        try {
            this.assertQueryReturns("WITH MEMBER GENDER.AGG AS 'AGGREGATE({ GENDER.[F], GENDER.[M] })' SELECT {MEASURES.[CUSTOMER COUNT]} ON 0, {GENDER.AGG } ON 1 FROM SALES", AggregationOnDistinctCountMeasuresTest.fold("Axis #0:\n{}\nAxis #1:\n{[Measures].[Customer Count]}\nAxis #2:\n{[Gender].[AGG]}\nRow #0: 5,581\n"));
        }
        finally {
            this.props.EnableGroupingSets.set(useGroupingSets);
        }
    }

    private boolean tuppleListContains(List tuples, Member memberByUniqueName) {
        if (tuples.get(0) instanceof Member) {
            return tuples.contains(memberByUniqueName);
        }
        for (Object o : tuples) {
            Member[] members = (Member[])o;
            if (!Arrays.asList(members).contains(memberByUniqueName)) continue;
            return true;
        }
        return false;
    }

    private List<Member[]> optimizeChildren(List<Member[]> memberList) {
        return AggregateFunDef.AggregateCalc.optimizeChildren(memberList, this.schemaReader, this.salesCube);
    }

    private List<Member[]> tupleList(List<Member> members) {
        return AggregateFunDef.AggregateCalc.makeTupleList(members);
    }
}

