/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Set;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BatchTestCase;
import mondrian.rolap.agg.CellRequest;
import mondrian.spi.Dialect;
import mondrian.test.SqlPattern;

public class GroupingSetQueryTest
extends BatchTestCase {
    private MondrianProperties prop = MondrianProperties.instance();
    private static final String cubeNameSales2 = "Sales 2";
    private static final String measureStoreSales = "[Measures].[Store Sales]";
    private static final String fieldNameMaritalStatus = "marital_status";
    private static final String measureCustomerCount = "[Measures].[Customer Count]";
    private boolean useGroupingSets;
    private boolean formattedSql;
    private String origWarnIfNoPatternForDialect;
    private static final Set<Dialect.DatabaseProduct> ORACLE_TERADATA = Util.enumSetOf((Enum)Dialect.DatabaseProduct.ORACLE, (Enum[])new Dialect.DatabaseProduct[]{Dialect.DatabaseProduct.TERADATA});

    protected void setUp() throws Exception {
        super.setUp();
        this.getTestContext().clearConnection();
        this.useGroupingSets = this.prop.EnableGroupingSets.get();
        this.formattedSql = this.prop.GenerateFormattedSql.get();
        this.origWarnIfNoPatternForDialect = this.prop.WarnIfNoPatternForDialect.get();
        this.prop.GenerateFormattedSql.set(false);
        Dialect dialect = this.getTestContext().getDialect();
        if (this.prop.WarnIfNoPatternForDialect.get().equals("ANY") || dialect.getDatabaseProduct() == Dialect.DatabaseProduct.ACCESS || dialect.getDatabaseProduct() == Dialect.DatabaseProduct.ORACLE) {
            this.prop.WarnIfNoPatternForDialect.set(dialect.getDatabaseProduct().toString());
        } else {
            this.prop.WarnIfNoPatternForDialect.set("NONE");
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.prop.EnableGroupingSets.set(this.useGroupingSets);
        this.prop.GenerateFormattedSql.set(this.formattedSql);
        this.prop.WarnIfNoPatternForDialect.set(this.origWarnIfNoPatternForDialect);
    }

    public void testGroupingSetForSingleColumnConstraint() {
        this.prop.DisableCaching.setString("false");
        CellRequest request1 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", "customer", this.fieldGender, "M");
        CellRequest request2 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", "customer", this.fieldGender, "F");
        CellRequest request3 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", null, "", "");
        SqlPattern[] patternsWithGsets = new SqlPattern[]{new SqlPattern(ORACLE_TERADATA, "select \"customer\".\"gender\" as \"c0\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\", grouping(\"customer\".\"gender\") as \"g0\" from \"customer\" =as= \"customer\", \"sales_fact_1997\" =as= \"sales_fact_1997\" where \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" group by grouping sets ((\"customer\".\"gender\"),())", 26)};
        SqlPattern[] patternsWithAggs = new SqlPattern[]{new SqlPattern(ORACLE_TERADATA, "select sum(\"agg_c_10_sales_fact_1997\".\"unit_sales\") as \"m0\" from \"agg_c_10_sales_fact_1997\" \"agg_c_10_sales_fact_1997\"", null), new SqlPattern(ORACLE_TERADATA, "select \"agg_g_ms_pcat_sales_fact_1997\".\"gender\" as \"c0\", sum(\"agg_g_ms_pcat_sales_fact_1997\".\"unit_sales\") as \"m0\" from \"agg_g_ms_pcat_sales_fact_1997\" \"agg_g_ms_pcat_sales_fact_1997\" group by \"agg_g_ms_pcat_sales_fact_1997\".\"gender\"", null)};
        SqlPattern[] patternsWithoutGsets = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ACCESS, "select \"customer\".\"gender\" as \"c0\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"customer\" as \"customer\", \"sales_fact_1997\" as \"sales_fact_1997\" where \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" group by \"customer\".\"gender\"", 26), new SqlPattern(ORACLE_TERADATA, "select \"customer\".\"gender\" as \"c0\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"customer\" =as= \"customer\", \"sales_fact_1997\" =as= \"sales_fact_1997\" where \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" group by \"customer\".\"gender\"", 26)};
        this.prop.EnableGroupingSets.set(true);
        if (this.prop.ReadAggregates.get() && this.prop.UseAggregates.get()) {
            this.assertRequestSql(new CellRequest[]{request3, request1, request2}, patternsWithAggs);
        } else {
            this.assertRequestSql(new CellRequest[]{request3, request1, request2}, patternsWithGsets);
        }
        this.prop.EnableGroupingSets.set(false);
        if (this.prop.ReadAggregates.get() && this.prop.UseAggregates.get()) {
            this.assertRequestSql(new CellRequest[]{request3, request1, request2}, patternsWithAggs);
        } else {
            this.assertRequestSql(new CellRequest[]{request3, request1, request2}, patternsWithoutGsets);
        }
    }

    public void testNotUsingGroupingSetWhenGroupUsesDifferentAggregateTable() {
        if (!this.prop.UseAggregates.get() || !this.prop.ReadAggregates.get()) {
            return;
        }
        CellRequest request1 = this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", this.fieldGender, "M");
        CellRequest request2 = this.createRequest("Sales", "[Measures].[Unit Sales]", "customer", this.fieldGender, "F");
        CellRequest request3 = this.createRequest("Sales", "[Measures].[Unit Sales]", null, "", "");
        this.prop.EnableGroupingSets.set(true);
        SqlPattern[] patternsWithoutGsets = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ACCESS, "select \"agg_g_ms_pcat_sales_fact_1997\".\"gender\" as \"c0\", sum(\"agg_g_ms_pcat_sales_fact_1997\".\"unit_sales\") as \"m0\" from \"agg_g_ms_pcat_sales_fact_1997\" as \"agg_g_ms_pcat_sales_fact_1997\" group by \"agg_g_ms_pcat_sales_fact_1997\".\"gender\"", 26), new SqlPattern(ORACLE_TERADATA, "select \"agg_g_ms_pcat_sales_fact_1997\".\"gender\" as \"c0\", sum(\"agg_g_ms_pcat_sales_fact_1997\".\"unit_sales\") as \"m0\" from \"agg_g_ms_pcat_sales_fact_1997\" \"agg_g_ms_pcat_sales_fact_1997\" group by \"agg_g_ms_pcat_sales_fact_1997\".\"gender\"", 26)};
        this.assertRequestSql(new CellRequest[]{request3, request1, request2}, patternsWithoutGsets);
    }

    public void testNotUsingGroupingSet() {
        if (this.prop.ReadAggregates.get() && this.prop.UseAggregates.get()) {
            return;
        }
        this.prop.EnableGroupingSets.set(true);
        CellRequest request1 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", "customer", this.fieldGender, "M");
        CellRequest request2 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", "customer", this.fieldGender, "F");
        SqlPattern[] patternsWithGsets = new SqlPattern[]{new SqlPattern(ORACLE_TERADATA, "select \"customer\".\"gender\" as \"c0\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"customer\" =as= \"customer\", \"sales_fact_1997\" =as= \"sales_fact_1997\" where \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" group by \"customer\".\"gender\"", 72)};
        this.assertRequestSql(new CellRequest[]{request1, request2}, patternsWithGsets);
        this.prop.EnableGroupingSets.set(false);
        SqlPattern[] patternsWithoutGsets = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ACCESS, "select \"customer\".\"gender\" as \"c0\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"customer\" as \"customer\", \"sales_fact_1997\" as \"sales_fact_1997\" where \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" group by \"customer\".\"gender\"", 72), new SqlPattern(ORACLE_TERADATA, "select \"customer\".\"gender\" as \"c0\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"customer\" =as= \"customer\", \"sales_fact_1997\" =as= \"sales_fact_1997\" where \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" group by \"customer\".\"gender\"", 72)};
        this.assertRequestSql(new CellRequest[]{request1, request2}, patternsWithoutGsets);
    }

    public void testGroupingSetForMultipleMeasureAndSingleConstraint() {
        if (this.prop.ReadAggregates.get() && this.prop.UseAggregates.get()) {
            return;
        }
        this.prop.EnableGroupingSets.set(true);
        CellRequest request1 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", "customer", this.fieldGender, "M");
        CellRequest request2 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", "customer", this.fieldGender, "F");
        CellRequest request3 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", null, "", "");
        CellRequest request4 = this.createRequest(cubeNameSales2, measureStoreSales, "customer", this.fieldGender, "M");
        CellRequest request5 = this.createRequest(cubeNameSales2, measureStoreSales, "customer", this.fieldGender, "F");
        CellRequest request6 = this.createRequest(cubeNameSales2, measureStoreSales, null, "", "");
        SqlPattern[] patternsWithGsets = new SqlPattern[]{new SqlPattern(ORACLE_TERADATA, "select \"customer\".\"gender\" as \"c0\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\", sum(\"sales_fact_1997\".\"store_sales\") as \"m1\", grouping(\"customer\".\"gender\") as \"g0\" from \"customer\" =as= \"customer\", \"sales_fact_1997\" =as= \"sales_fact_1997\" where \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" group by grouping sets ((\"customer\".\"gender\"),())", 26)};
        this.assertRequestSql(new CellRequest[]{request1, request2, request3, request4, request5, request6}, patternsWithGsets);
        this.prop.EnableGroupingSets.set(false);
        SqlPattern[] patternsWithoutGsets = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ACCESS, "select \"customer\".\"gender\" as \"c0\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\", sum(\"sales_fact_1997\".\"store_sales\") as \"m1\" from \"customer\" as \"customer\", \"sales_fact_1997\" as \"sales_fact_1997\" where \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" group by \"customer\".\"gender\"", 26), new SqlPattern(ORACLE_TERADATA, "select \"customer\".\"gender\" as \"c0\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\", sum(\"sales_fact_1997\".\"store_sales\") as \"m1\" from \"customer\" =as= \"customer\", \"sales_fact_1997\" =as= \"sales_fact_1997\" where \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" group by \"customer\".\"gender\"", 26)};
        this.assertRequestSql(new CellRequest[]{request1, request2, request3, request4, request5, request6}, patternsWithoutGsets);
    }

    public void testGroupingSetForASummaryCanBeGroupedWith2DetailBatch() {
        if (this.prop.ReadAggregates.get() && this.prop.UseAggregates.get()) {
            return;
        }
        this.prop.EnableGroupingSets.set(true);
        CellRequest request1 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", "customer", this.fieldGender, "M");
        CellRequest request2 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", "customer", this.fieldGender, "F");
        CellRequest request3 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", null, "", "");
        CellRequest request4 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", "customer", fieldNameMaritalStatus, "M");
        CellRequest request5 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", "customer", fieldNameMaritalStatus, "S");
        CellRequest request6 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", null, "", "");
        SqlPattern[] patternWithGsets = new SqlPattern[]{new SqlPattern(ORACLE_TERADATA, "select \"customer\".\"gender\" as \"c0\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\", grouping(\"customer\".\"gender\") as \"g0\" from \"customer\" =as= \"customer\", \"sales_fact_1997\" =as= \"sales_fact_1997\" where \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" group by grouping sets ((\"customer\".\"gender\"),())", 26), new SqlPattern(ORACLE_TERADATA, "select \"customer\".\"marital_status\" as \"c0\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"customer\" =as= \"customer\", \"sales_fact_1997\" =as= \"sales_fact_1997\" where \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" group by \"customer\".\"marital_status\"", 26)};
        this.assertRequestSql(new CellRequest[]{request1, request2, request3, request4, request5, request6}, patternWithGsets);
        this.prop.EnableGroupingSets.set(false);
        SqlPattern[] patternWithoutGsets = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ACCESS, "select sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"sales_fact_1997\" as \"sales_fact_1997\"", 40), new SqlPattern(ORACLE_TERADATA, "select sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"sales_fact_1997\" =as= \"sales_fact_1997\"", 40)};
        this.assertRequestSql(new CellRequest[]{request1, request2, request3, request4, request5, request6}, patternWithoutGsets);
    }

    public void testGroupingSetForMultipleColumnConstraint() {
        if (this.prop.ReadAggregates.get() && this.prop.UseAggregates.get()) {
            return;
        }
        this.prop.EnableGroupingSets.set(true);
        CellRequest request1 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", new String[]{"customer", "time_by_day"}, new String[]{this.fieldGender, "the_year"}, new String[]{"M", "1997"});
        CellRequest request2 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", new String[]{"customer", "time_by_day"}, new String[]{this.fieldGender, "the_year"}, new String[]{"F", "1997"});
        CellRequest request3 = this.createRequest(cubeNameSales2, "[Measures].[Unit Sales]", "time_by_day", "the_year", "1997");
        SqlPattern[] patternsWithGsets = new SqlPattern[]{new SqlPattern(ORACLE_TERADATA, "select \"time_by_day\".\"the_year\" as \"c0\", \"customer\".\"gender\" as \"c1\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\", grouping(\"customer\".\"gender\") as \"g0\" from \"time_by_day\" =as= \"time_by_day\", \"sales_fact_1997\" =as= \"sales_fact_1997\", \"customer\" =as= \"customer\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" group by grouping sets ((\"time_by_day\".\"the_year\",\"customer\".\"gender\"),(\"time_by_day\".\"the_year\"))", 150)};
        this.assertRequestSql(new CellRequest[]{request3, request1, request2}, patternsWithGsets);
        this.prop.EnableGroupingSets.set(false);
        SqlPattern[] patternsWithoutGsets = new SqlPattern[]{new SqlPattern(Dialect.DatabaseProduct.ACCESS, "select \"time_by_day\".\"the_year\" as \"c0\", \"customer\".\"gender\" as \"c1\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"time_by_day\" as \"time_by_day\", \"sales_fact_1997\" as \"sales_fact_1997\", \"customer\" as \"customer\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" group by \"time_by_day\".\"the_year\", \"customer\".\"gender\"", 50), new SqlPattern(ORACLE_TERADATA, "select \"time_by_day\".\"the_year\" as \"c0\", \"customer\".\"gender\" as \"c1\", sum(\"sales_fact_1997\".\"unit_sales\") as \"m0\" from \"time_by_day\" =as= \"time_by_day\", \"sales_fact_1997\" =as= \"sales_fact_1997\", \"customer\" =as= \"customer\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" group by \"time_by_day\".\"the_year\", \"customer\".\"gender\"", 50)};
        this.assertRequestSql(new CellRequest[]{request3, request1, request2}, patternsWithoutGsets);
    }

    public void testGroupingSetForMultipleColumnConstraintAndCompoundConstraint() {
        SqlPattern[] patternsGSDisabled;
        if (this.prop.ReadAggregates.get() && this.prop.UseAggregates.get()) {
            return;
        }
        ArrayList<String[]> compoundMembers = new ArrayList<String[]>();
        compoundMembers.add(new String[]{"USA", "OR"});
        compoundMembers.add(new String[]{"CANADA", "BC"});
        BatchTestCase.CellRequestConstraint constraint = GroupingSetQueryTest.makeConstraintCountryState(compoundMembers);
        CellRequest request1 = this.createRequest(cubeNameSales2, measureCustomerCount, new String[]{"customer", "time_by_day"}, new String[]{this.fieldGender, "the_year"}, new String[]{"M", "1997"}, constraint);
        CellRequest request2 = this.createRequest(cubeNameSales2, measureCustomerCount, new String[]{"customer", "time_by_day"}, new String[]{this.fieldGender, "the_year"}, new String[]{"F", "1997"}, constraint);
        CellRequest request3 = this.createRequest(cubeNameSales2, measureCustomerCount, "time_by_day", "the_year", "1997", constraint);
        String sqlWithoutGS = "select \"time_by_day\".\"the_year\" as \"c0\", \"customer\".\"gender\" as \"c1\", count(distinct \"sales_fact_1997\".\"customer_id\") as \"m0\" from \"time_by_day\" =as= \"time_by_day\", \"sales_fact_1997\" =as= \"sales_fact_1997\", \"customer\" =as= \"customer\", \"store\" =as= \"store\" where \"sales_fact_1997\".\"time_id\" = \"time_by_day\".\"time_id\" and \"time_by_day\".\"the_year\" = 1997 and \"sales_fact_1997\".\"customer_id\" = \"customer\".\"customer_id\" and \"sales_fact_1997\".\"store_id\" = \"store\".\"store_id\" and ((\"store\".\"store_country\" = 'USA' and \"store\".\"store_state\" = 'OR') or (\"store\".\"store_country\" = 'CANADA' and \"store\".\"store_state\" = 'BC')) group by \"time_by_day\".\"the_year\", \"customer\".\"gender\"";
        SqlPattern[] patternsGSEnabled = patternsGSDisabled = new SqlPattern[]{new SqlPattern(ORACLE_TERADATA, sqlWithoutGS, sqlWithoutGS)};
        this.prop.EnableGroupingSets.set(true);
        this.assertRequestSql(new CellRequest[]{request3, request1, request2}, patternsGSEnabled);
        this.prop.EnableGroupingSets.set(false);
        this.assertRequestSql(new CellRequest[]{request3, request1, request2}, patternsGSDisabled);
    }

    public void testBug2004202() {
        this.assertQueryReturns("with member store.allbutwallawalla as\n 'aggregate(\n    except(\n        store.[store name].members,\n        { [Store].[All Stores].[USA].[WA].[Walla Walla].[Store 22]}))'\nselect {\n          store.[store name].members,\n         store.allbutwallawalla,\n         store.[all stores]} on 0,\n  {measures.[customer count]} on 1\nfrom sales", GroupingSetQueryTest.fold("Axis #0:\n{}\nAxis #1:\n{[Store].[All Stores].[Canada].[BC].[Vancouver].[Store 19]}\n{[Store].[All Stores].[Canada].[BC].[Victoria].[Store 20]}\n{[Store].[All Stores].[Mexico].[DF].[Mexico City].[Store 9]}\n{[Store].[All Stores].[Mexico].[DF].[San Andres].[Store 21]}\n{[Store].[All Stores].[Mexico].[Guerrero].[Acapulco].[Store 1]}\n{[Store].[All Stores].[Mexico].[Jalisco].[Guadalajara].[Store 5]}\n{[Store].[All Stores].[Mexico].[Veracruz].[Orizaba].[Store 10]}\n{[Store].[All Stores].[Mexico].[Yucatan].[Merida].[Store 8]}\n{[Store].[All Stores].[Mexico].[Zacatecas].[Camacho].[Store 4]}\n{[Store].[All Stores].[Mexico].[Zacatecas].[Hidalgo].[Store 12]}\n{[Store].[All Stores].[Mexico].[Zacatecas].[Hidalgo].[Store 18]}\n{[Store].[All Stores].[USA].[CA].[Alameda].[HQ]}\n{[Store].[All Stores].[USA].[CA].[Beverly Hills].[Store 6]}\n{[Store].[All Stores].[USA].[CA].[Los Angeles].[Store 7]}\n{[Store].[All Stores].[USA].[CA].[San Diego].[Store 24]}\n{[Store].[All Stores].[USA].[CA].[San Francisco].[Store 14]}\n{[Store].[All Stores].[USA].[OR].[Portland].[Store 11]}\n{[Store].[All Stores].[USA].[OR].[Salem].[Store 13]}\n{[Store].[All Stores].[USA].[WA].[Bellingham].[Store 2]}\n{[Store].[All Stores].[USA].[WA].[Bremerton].[Store 3]}\n{[Store].[All Stores].[USA].[WA].[Seattle].[Store 15]}\n{[Store].[All Stores].[USA].[WA].[Spokane].[Store 16]}\n{[Store].[All Stores].[USA].[WA].[Tacoma].[Store 17]}\n{[Store].[All Stores].[USA].[WA].[Walla Walla].[Store 22]}\n{[Store].[All Stores].[USA].[WA].[Yakima].[Store 23]}\n{[Store].[allbutwallawalla]}\n{[Store].[All Stores]}\nAxis #2:\n{[Measures].[Customer Count]}\nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: \nRow #0: 1,059\nRow #0: 1,147\nRow #0: 962\nRow #0: 296\nRow #0: 563\nRow #0: 474\nRow #0: 190\nRow #0: 179\nRow #0: 906\nRow #0: 84\nRow #0: 278\nRow #0: 96\nRow #0: 95\nRow #0: 5,485\nRow #0: 5,581\n"));
    }
}

