/*
 * Decompiled with CFR 0.152.
 */
package rex.metadata.resultelements;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rex.graphics.ColumnTupleMemberLabel;
import rex.graphics.RowTupleMemberLabel;
import rex.graphics.layoutmanagers.GridBagConstraints;
import rex.graphics.layoutmanagers.GridBagLayoutRex;
import rex.metadata.Query;
import rex.metadata.resultelements.HierarchyInfo;
import rex.metadata.resultelements.Tuple;
import rex.utils.AppColors;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class Axis
implements LanguageChangedListener {
    private String name;
    private ArrayList hierarchies;
    private Vector tuples = new Vector();
    JLabel lblSum;
    JLabel lblAverage;

    public Axis(Node hNode) {
        this.name = hNode.getAttributes().getNamedItem("name").getNodeValue();
        this.lblSum = new JLabel(I18n.getString("label.sum"), 0);
        this.lblAverage = new JLabel(I18n.getString("label.average"), 0);
        NodeList hl = hNode.getChildNodes();
        if (hl.getLength() > 0) {
            this.hierarchies = new ArrayList();
            for (int i = 0; i < hl.getLength(); ++i) {
                if (hl.item(i).getNodeType() != 1) continue;
                this.hierarchies.add(new HierarchyInfo(hl.item(i)));
            }
        }
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
    }

    public void loadMemberTuples(Node tuplesNode) {
        Tuple prevTuple = null;
        NodeList tl = tuplesNode.getChildNodes();
        if (tl.getLength() > 0) {
            for (int i = 0; i < tl.getLength(); ++i) {
                if (tl.item(i).getNodeType() != 1) continue;
                prevTuple = new Tuple(tl.item(i), prevTuple);
                this.tuples.add(prevTuple);
            }
        }
    }

    public int getTupleCount() {
        if (this.tuples != null) {
            return this.tuples.size();
        }
        return 0;
    }

    public Tuple getTupleAt(int i) {
        if (i >= 0 && i <= this.tuples.size()) {
            return (Tuple)this.tuples.elementAt(i);
        }
        S.out("assert: Axis.getTupleAt(i) - i is out of the array range");
        return null;
    }

    public int getTupleOrdinal(Tuple t) {
        for (int i = 0; i < this.tuples.size(); ++i) {
            if (!t.equals(this.getTupleAt(i))) continue;
            return i;
        }
        S.out("assert: Axis.getTupleOrdinal(Tuple t) - couldn't find a tuple: " + t);
        return -1;
    }

    public String toString() {
        if (this.name == null) {
            return I18n.getString("toolTip.notInitiliazed");
        }
        return "" + this.name;
    }

    public String getName() {
        return this.name;
    }

    public int getHierarchyInfoCount() {
        if (this.hierarchies != null) {
            return this.hierarchies.size();
        }
        return 0;
    }

    public HierarchyInfo getHierarchyInfoAt(int i) {
        return (HierarchyInfo)this.hierarchies.toArray()[i];
    }

    public void dumpTable() {
        S.out("Dump table for axis:" + this.name + "\ntuple count is:" + this.getTupleCount());
        if (this.tuples != null) {
            int j;
            int i;
            int k;
            int tupleCount = this.getTupleCount();
            int memberCount = ((Tuple)this.tuples.elementAt(0)).getMemberCount();
            int[] memberSpan = new int[memberCount];
            int[] currMemberX = new int[memberCount];
            for (k = 0; k < memberCount; ++k) {
                memberSpan[k] = 0;
            }
            for (k = 0; k < memberCount; ++k) {
                currMemberX[k] = tupleCount;
            }
            for (i = tupleCount - 1; i >= 0; --i) {
                for (j = 0; j < memberCount; ++j) {
                    S.out("member=" + this.getTupleAt(i).getMemberAt(j) + " span = " + this.getTupleAt(i).getMemberAt(j).getMemberSpan());
                }
            }
            for (i = tupleCount - 1; i >= 0; --i) {
                j = 0;
                while (j < memberCount) {
                    if (memberSpan[j] == 0) {
                        memberSpan[j] = this.getTupleAt(i).getMemberAt(j).getMemberSpan();
                        int n = j;
                        currMemberX[n] = currMemberX[n] - this.getTupleAt(i).getMemberAt(j).getMemberSpan();
                        S.out("x=" + currMemberX[j] + "\ty=" + j + "\twidth=" + this.getTupleAt(i).getMemberAt(j).getMemberSpan() + "\tmember=" + this.getTupleAt(i).getMemberAt(j));
                    }
                    int n = j++;
                    memberSpan[n] = memberSpan[n] - 1;
                }
            }
        }
    }

    public JPanel getHorizontalTreePanel(Query query, int itemWidth, int itemHeight, boolean showRowTotalsOn) {
        if (this.tuples != null) {
            int k;
            JPanel jp = new JPanel();
            jp.setBackground(AppColors.HIERARCHY_PANE_BACKGROUND);
            GridBagLayoutRex gb = new GridBagLayoutRex();
            GridBagConstraints c = new GridBagConstraints();
            jp.setLayout(gb);
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            Dimension prefSize = new Dimension(itemWidth, itemHeight);
            int tupleCount = this.getTupleCount();
            int memberCount = ((Tuple)this.tuples.elementAt(0)).getMemberCount();
            int[] memberSpan = new int[memberCount];
            int[] currMemberX = new int[memberCount];
            for (k = 0; k < memberCount; ++k) {
                memberSpan[k] = 0;
            }
            for (k = 0; k < memberCount; ++k) {
                currMemberX[k] = tupleCount;
            }
            for (int i = tupleCount - 1; i >= 0; --i) {
                int j = 0;
                while (j < memberCount) {
                    if (memberSpan[j] == 0) {
                        memberSpan[j] = this.getTupleAt(i).getMemberAt(j).getMemberSpan();
                        int n = j;
                        currMemberX[n] = currMemberX[n] - this.getTupleAt(i).getMemberAt(j).getMemberSpan();
                        ColumnTupleMemberLabel item = new ColumnTupleMemberLabel("" + this.getTupleAt(i).getMemberAt(j), query, this.getTupleAt(i), j, i);
                        if (this.getTupleAt(i).getMemberAt(j).isMeasure()) {
                            item.setIcon(this.getTupleAt(i).getMemberAt(j).getIcon());
                        }
                        item.setToolTipText(this.getTupleAt(i).getMemberAt(j).getToolTip());
                        item.setPreferredSize(prefSize);
                        item.setMinimumSize(prefSize);
                        item.setMaximumSize(prefSize);
                        c.gridx = currMemberX[j];
                        c.gridy = j;
                        c.gridwidth = this.getTupleAt(i).getMemberAt(j).getMemberSpan();
                        c.gridheight = 1;
                        gb.setConstraints(item, c);
                        jp.add(item);
                    }
                    int n = j++;
                    memberSpan[n] = memberSpan[n] - 1;
                }
            }
            if (showRowTotalsOn) {
                JLabel totalsLabel = this.lblSum;
                totalsLabel.setBackground(AppColors.CELL_TOTAL_SUM_BACKGROUND_COLOR);
                totalsLabel.setBorder(AppColors.CELL_TOTAL_SUM_BORDER);
                totalsLabel.setOpaque(true);
                totalsLabel.setPreferredSize(prefSize);
                totalsLabel.setMinimumSize(prefSize);
                totalsLabel.setMaximumSize(prefSize);
                c.gridx = tupleCount;
                c.gridy = 0;
                c.gridwidth = 1;
                c.gridheight = memberCount;
                gb.setConstraints(totalsLabel, c);
                jp.add(totalsLabel);
                totalsLabel = this.lblAverage;
                totalsLabel.setBackground(AppColors.CELL_TOTAL_AVERAGE_BACKGROUND_COLOR);
                totalsLabel.setBorder(AppColors.CELL_TOTAL_AVERAGE_BORDER);
                totalsLabel.setOpaque(true);
                totalsLabel.setPreferredSize(prefSize);
                totalsLabel.setMinimumSize(prefSize);
                totalsLabel.setMaximumSize(prefSize);
                c.gridx = tupleCount + 1;
                c.gridy = 0;
                c.gridwidth = 1;
                c.gridheight = memberCount;
                gb.setConstraints(totalsLabel, c);
                jp.add(totalsLabel);
            }
            return jp;
        }
        return null;
    }

    public JPanel getVerticalTreePanel(Query query, int itemWidth, int itemHeight, boolean showColumnTotalsOn) {
        if (this.tuples != null) {
            int k;
            JPanel jp = new JPanel();
            jp.setBackground(AppColors.HIERARCHY_PANE_BACKGROUND);
            GridBagLayoutRex gb = new GridBagLayoutRex();
            jp.setLayout(gb);
            int tupleCount = this.getTupleCount();
            int memberCount = ((Tuple)this.tuples.elementAt(0)).getMemberCount();
            GridBagConstraints c = new GridBagConstraints();
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            int[] memberSpan = new int[memberCount];
            int[] currMemberX = new int[memberCount];
            for (k = 0; k < memberCount; ++k) {
                memberSpan[k] = 0;
            }
            for (k = 0; k < memberCount; ++k) {
                currMemberX[k] = tupleCount;
            }
            for (int i = tupleCount - 1; i >= 0; --i) {
                int j = 0;
                while (j < memberCount) {
                    if (memberSpan[j] == 0) {
                        memberSpan[j] = this.getTupleAt(i).getMemberAt(j).getMemberSpan();
                        int n = j;
                        currMemberX[n] = currMemberX[n] - this.getTupleAt(i).getMemberAt(j).getMemberSpan();
                        RowTupleMemberLabel item = new RowTupleMemberLabel("" + this.getTupleAt(i).getMemberAt(j), query, this.getTupleAt(i), j, i);
                        item.setToolTipText(this.getTupleAt(i).getMemberAt(j).getToolTip());
                        item.setPreferredSize(new Dimension(itemWidth, itemHeight));
                        item.setMinimumSize(new Dimension(itemWidth, itemHeight));
                        item.setMaximumSize(new Dimension(itemWidth, itemHeight));
                        c.gridx = j;
                        c.gridy = currMemberX[j];
                        c.gridwidth = 1;
                        c.gridheight = this.getTupleAt(i).getMemberAt(j).getMemberSpan();
                        gb.setConstraints(item, c);
                        jp.add(item);
                    }
                    int n = j++;
                    memberSpan[n] = memberSpan[n] - 1;
                }
            }
            if (showColumnTotalsOn) {
                JLabel totalsLabel = this.lblSum;
                totalsLabel.setBackground(AppColors.CELL_TOTAL_SUM_BACKGROUND_COLOR);
                totalsLabel.setBorder(AppColors.CELL_TOTAL_SUM_BORDER);
                totalsLabel.setOpaque(true);
                c.gridx = 0;
                c.gridy = tupleCount;
                c.gridwidth = memberCount;
                c.gridheight = 1;
                gb.setConstraints(totalsLabel, c);
                jp.add(totalsLabel);
                totalsLabel = this.lblAverage;
                totalsLabel.setBackground(AppColors.CELL_TOTAL_AVERAGE_BACKGROUND_COLOR);
                totalsLabel.setBorder(AppColors.CELL_TOTAL_AVERAGE_BORDER);
                totalsLabel.setOpaque(true);
                c.gridx = 0;
                c.gridy = tupleCount + 1;
                c.gridwidth = memberCount;
                c.gridheight = 1;
                gb.setConstraints(totalsLabel, c);
                jp.add(totalsLabel);
            }
            return jp;
        }
        return null;
    }

    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public void applyI18n() {
        this.lblSum.setText(I18n.getString("label.sum"));
        this.lblAverage.setText(I18n.getString("label.average"));
    }
}

